/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.checkscheme.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.common.constants.CalResultCheckConstants;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ResultCheckSchemeHelper {
    private static final Log log = LogFactory.getLog(ResultCheckSchemeHelper.class);

    public Map<String, Map<String, Map<String, Object>>> getAllItemData(IDataModel model, DynamicObject payrollgroupObj) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        long countryId = payrollgroupObj.getLong("country.id");
        long orgId = payrollgroupObj.getLong("org.id");
        String areatype = "2";
        QFilter countryQFilter = AreaHelper.addAreaFilter((long)countryId, (String)areatype);
        Map<String, Map<String, Object>> bsItemMap = this.getBSItemList(model, countryQFilter, orgId);
        Map<String, Map<String, Object>> salaryItemMap = this.getSalaryItemList(model, countryQFilter, orgId);
        dataMap.put("salaryitemkey", salaryItemMap);
        dataMap.put("bsitemkey", bsItemMap);
        return dataMap;
    }

    private Map<String, Map<String, Object>> getBSItemList(IDataModel model, QFilter countryQFilter, long orgId) {
        LinkedHashMap bsItemMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String queryField = "id,number,name,bizitemcategory.number,bizitemcategory.name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("datatype.id", "=", (Object)CalResultCheckConstants.AMOUNT_TYPE_ID));
        filter.and(countryQFilter);
        IBaseDataService baseDataService = (IBaseDataService)model.getService(IBaseDataService.class);
        QFilter orgFilter = baseDataService.getBaseDataFilter("hsbs_bizitem", Long.valueOf(orgId));
        String orderBy = "index asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter, orgFilter}, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(8);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("bizTypeNumber", item.getString("bizitemcategory.number"));
            tempMap.put("bizTypeName", item.getString("bizitemcategory.name"));
            tempMap.put("datatype", item.getString("datatype.showtype"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            bsItemMap.put(item.getString("name"), tempMap);
        }
        return bsItemMap;
    }

    private Map<String, Map<String, Object>> getSalaryItemList(IDataModel model, QFilter countryQFilter, long orgId) {
        LinkedHashMap<String, Map<String, Object>> salaryItemMap = new LinkedHashMap<String, Map<String, Object>>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(countryQFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String queryField = "id,number,name,salaryitemtype.number,salaryitemtype.name,uniquecode,datatype.showtype";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("datatype.id", "=", (Object)CalResultCheckConstants.AMOUNT_TYPE_ID));
        IBaseDataService baseDataService = (IBaseDataService)model.getService(IBaseDataService.class);
        QFilter orgFilter = baseDataService.getBaseDataFilter("hsbs_salaryitem", Long.valueOf(orgId));
        qFilters.add(filter);
        qFilters.add(orgFilter);
        QFilter[] newFilters = new QFilter[qFilters.size()];
        newFilters = qFilters.toArray(newFilters);
        String orderBy = "salaryitemtype.index asc,salaryitemtype.number asc,index asc,number asc";
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, newFilters, orderBy);
        HashMap<String, Object> tempMap = null;
        for (DynamicObject item : result) {
            tempMap = new HashMap<String, Object>(6);
            tempMap.put("id", item.getLong("id"));
            tempMap.put("number", item.getString("number"));
            tempMap.put("name", item.getString("name"));
            tempMap.put("salaryitemtype_number", item.getString("salaryitemtype.number"));
            tempMap.put("salaryitemtype_name", item.getString("salaryitemtype.name"));
            tempMap.put("uniquecode", item.getString("uniquecode"));
            tempMap.put("showtype", item.getString("datatype.showtype"));
            salaryItemMap.put(item.getString("name"), tempMap);
        }
        return salaryItemMap;
    }

    public void createCalResultCheckScheme(Long payrollGroupId) {
        log.info("createCalResultCheckScheme");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "=", (Object)payrollGroupId);
        filter.and("enable", "=", (Object)"1");
        String fields = "id,number,name,org,payrollsceneentry.payrollscene,payrollsceneentry.payrollscene.calrule";
        DynamicObject dynamicObjects = helper.queryOne(fields, new QFilter[]{filter});
        if (dynamicObjects == null) {
            return;
        }
        DynamicObjectCollection payrollsceneentry = dynamicObjects.getDynamicObjectCollection("payrollsceneentry");
        if (payrollsceneentry.size() == 0) {
            return;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(payrollsceneentry.size());
        List<Long> sceneIdList = payrollsceneentry.stream().map(scene -> scene.getLong("payrollscene.id")).filter(single -> single != 0L).collect(Collectors.toList());
        List calRuleIdList = payrollsceneentry.stream().map(scene -> scene.getLong("payrollscene.calrule.id")).filter(single -> single != 0L).collect(Collectors.toList());
        DynamicObject[] checkObj = this.selectResultCheckObj(sceneIdList);
        ArrayList<Long> existSceneIdList = new ArrayList<Long>(10);
        ArrayList<DynamicObject> needUpdateObj = new ArrayList<DynamicObject>(10);
        if (checkObj.length > 0) {
            for (DynamicObject obj : checkObj) {
                long sceneId = obj.getLong("payrollscene.id");
                long groupId = obj.getLong("payrollgroup.id");
                if (groupId != payrollGroupId) continue;
                existSceneIdList.add(sceneId);
                String enable = obj.getString("enable");
                if (!SWCStringUtils.equals((String)"0", (String)enable)) continue;
                obj.set("enable", (Object)"1");
                needUpdateObj.add(obj);
            }
        }
        helper = new SWCDataServiceHelper("hsas_calrule");
        filter = new QFilter("id", "in", calRuleIdList);
        fields = "id,totalsalary.number,totalsalary.name,netsalary.number,netsalary.name,totalsalary.id,netsalary.id";
        DynamicObjectCollection ruleObjList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, Map<String, Object>> ruleMap = new HashMap<Long, Map<String, Object>>(16);
        if (ruleObjList.size() > 0) {
            this.assembleRuleMap(ruleObjList, ruleMap);
        }
        this.assembleSceneDataMap(existSceneIdList, dynamicObjects, payrollsceneentry, dataList, ruleMap);
        this.saveData(dataList, needUpdateObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(List<Map<String, Object>> dataList, List<DynamicObject> needUpdateObj) {
        log.info("saveData begin");
        try (TXHandle txHandle = TX.requiresNew();){
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
            this.saveCheckSceneList(helper, dataList);
            if (needUpdateObj.size() > 0) {
                helper.update(needUpdateObj.toArray(new DynamicObject[needUpdateObj.size()]));
            }
            log.info("saveData finish");
        }
    }

    private void saveCheckSceneList(SWCDataServiceHelper helper, List<Map<String, Object>> dataList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataList.size());
        for (Map<String, Object> data : dataList) {
            DynamicObject object = helper.generateEmptyDynamicObject();
            this.initCheckSceneObj(data, object);
            DynamicObjectCollection valueentry = object.getDynamicObjectCollection("valueentry");
            Object totalsalaryNumber = data.get("totalsalaryNumber");
            if (totalsalaryNumber != null) {
                DynamicObject totalSalaryEntry = helper.generateEmptyEntryDynamicObject(object, "valueentry");
                totalSalaryEntry.set("itemid", data.get("totalsalaryId"));
                totalSalaryEntry.set("itemtype", (Object)"SL");
                totalSalaryEntry.set("itemnumber", totalsalaryNumber);
                totalSalaryEntry.set("itemname", data.get("totalsalaryName"));
                totalSalaryEntry.set("workbenchshow", (Object)"1");
                totalSalaryEntry.set("valueequals", (Object)"0");
                totalSalaryEntry.set("valueless", (Object)"0");
                valueentry.add((Object)totalSalaryEntry);
            }
            Object netsalaryNumber = data.get("netsalaryNumber");
            if (!SWCStringUtils.equals((String)(totalsalaryNumber + ""), (String)(netsalaryNumber + "")) && netsalaryNumber != null) {
                DynamicObject netSalaryEntry = helper.generateEmptyEntryDynamicObject(object, "valueentry");
                netSalaryEntry.set("itemid", data.get("netsalaryId"));
                netSalaryEntry.set("itemtype", (Object)"SL");
                netSalaryEntry.set("itemnumber", netsalaryNumber);
                netSalaryEntry.set("itemname", data.get("netsalaryName"));
                netSalaryEntry.set("workbenchshow", (Object)"1");
                netSalaryEntry.set("valueequals", (Object)"0");
                netSalaryEntry.set("valueless", (Object)"0");
                valueentry.add((Object)netSalaryEntry);
            }
            list.add(object);
        }
        helper.save(list.toArray(new DynamicObject[list.size()]));
    }

    private void initCheckSceneObj(Map<String, Object> data, DynamicObject object) {
        Date nowDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        String number = "" + data.get("groupNumber") + data.get("sceneNumber");
        String name = data.get("groupName") + data.get("sceneName") + ResManager.loadKDString((String)"\u68c0\u6838\u65b9\u6848", (String)"ResultCheckSchemeHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        object.set("number", (Object)(number.length() < 120 ? number : number.substring(0, 120)));
        object.set("name", (Object)(name.length() < 200 ? name : name.substring(0, 200)));
        object.set("status", (Object)"C");
        object.set("createtime", (Object)nowDate);
        object.set("modifytime", (Object)nowDate);
        object.set("creator", (Object)userId);
        object.set("modifier", (Object)userId);
        object.set("enable", (Object)"1");
        object.set("org", data.get("orgId"));
        object.set("payrollgroup", data.get("groupId"));
        object.set("payrollscene", data.get("sceneId"));
        object.set("chaingrowth", (Object)"1");
        object.set("changestatus", (Object)"0");
    }

    private DynamicObject[] selectResultCheckObj(List<Long> sceneIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_resultcheckscheme");
        QFilter filter = new QFilter("payrollscene", "in", sceneIdList);
        DynamicObject[] dynamicObjects = helper.query("payrollgroup,payrollscene,enable", new QFilter[]{filter});
        return dynamicObjects;
    }

    private void assembleSceneDataMap(List<Long> existSceneIdList, DynamicObject dynamicObjects, DynamicObjectCollection payrollsceneentry, List<Map<String, Object>> dataList, Map<Long, Map<String, Object>> ruleMap) {
        log.info("assembleSceneDataMap");
        long orgId = dynamicObjects.getLong("org.id");
        long groupId = dynamicObjects.getLong("id");
        String groupNumber = dynamicObjects.getString("number");
        String groupName = dynamicObjects.getString("name");
        for (DynamicObject scene : payrollsceneentry) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            long sceneId = scene.getLong("payrollscene.id");
            if (existSceneIdList.contains(sceneId) || sceneId == 0L) continue;
            long ruleId = scene.getLong("payrollscene.calrule.id");
            dataMap.put("orgId", orgId);
            dataMap.put("groupId", groupId);
            dataMap.put("groupName", groupName);
            dataMap.put("groupNumber", groupNumber);
            dataMap.put("sceneId", sceneId);
            dataMap.put("sceneName", scene.getString("payrollscene.name"));
            dataMap.put("sceneNumber", scene.getString("payrollscene.number"));
            dataMap.put("ruleId", ruleId);
            Map<String, Object> rule = ruleMap.get(ruleId);
            if (rule != null) {
                dataMap.put("totalsalaryNumber", rule.get("totalsalaryNumber"));
                dataMap.put("totalsalaryName", rule.get("totalsalaryName"));
                dataMap.put("netsalaryNumber", rule.get("netsalaryNumber"));
                dataMap.put("netsalaryName", rule.get("netsalaryName"));
                dataMap.put("netsalaryId", rule.get("netsalaryId"));
                dataMap.put("totalsalaryId", rule.get("totalsalaryId"));
            }
            dataList.add(dataMap);
        }
    }

    private void assembleRuleMap(DynamicObjectCollection ruleObjList, Map<Long, Map<String, Object>> ruleMap) {
        for (DynamicObject rule : ruleObjList) {
            HashMap<String, Object> singleMap = new HashMap<String, Object>(5);
            long ruleId = rule.getLong("id");
            String totalsalaryNumber = rule.getString("totalsalary.number");
            if (SWCStringUtils.isEmpty((String)totalsalaryNumber)) continue;
            singleMap.put("ruleId", ruleId);
            singleMap.put("totalsalaryNumber", totalsalaryNumber);
            singleMap.put("totalsalaryName", rule.getString("totalsalary.name"));
            singleMap.put("netsalaryNumber", rule.getString("netsalary.number"));
            singleMap.put("netsalaryName", rule.getString("netsalary.name"));
            singleMap.put("totalsalaryId", rule.getString("totalsalary.id"));
            singleMap.put("netsalaryId", rule.getString("netsalary.id"));
            ruleMap.put(ruleId, singleMap);
        }
    }
}

