/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.common.dto.CollaSalaryFileDataEntity;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsbp.business.cloudcolla.CloudCollaContextHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CloudSalaryFileDataHelper {
    private static Log LOGGER = LogFactory.getLog(CloudSalaryFileDataHelper.class);
    private static final String SALARY_FILE_PROPERTY = "id,number,boid,employee,empposinfo,payrollgroup,payrollgroup.org,sourcevid";
    public static final String EMPLOYEE_ID = "employee.id";
    public static final String EMPPOSINFO_ID = "empposinfo.id";
    public static final String PAYROLLGROUP_ID = "payrollgroup.id";
    public static final String ADMINORG_ID = "adminorg.id";
    public static final String SALARY_CAL_STYLE = "salarycalstyle";
    public static final String PAY_ROLL_GROUP = "payrollgroup";

    public boolean validateOrgId(DynamicObject salaryFile, Long orgId) {
        if (salaryFile == null || orgId == null) {
            return false;
        }
        long existOrgId = salaryFile.getLong("payrollgroup.org.id");
        if (existOrgId == 0L) {
            return false;
        }
        return orgId.equals(existOrgId);
    }

    public DynamicObject isDepEmpExistInSalaryFile(long salaryFileId, long depEmpId) {
        QFilter depEmpQfilter;
        if (salaryFileId == 0L || depEmpId == 0L) {
            return null;
        }
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter salaryFileQfilter = new QFilter("salaryfile.id", "=", (Object)salaryFileId);
        DynamicObject dynamicObject = empPosOrgRelOrm.queryOne("id,boid,workrole,paystartdate,payenddate", new QFilter[]{salaryFileQfilter.and(depEmpQfilter = new QFilter("workrole.id", "=", (Object)depEmpId))});
        if (dynamicObject == null) {
            return null;
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return null;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            long workRoleId = entry.getLong("workrole.id");
            if (workRoleId != depEmpId) continue;
            return dynamicObject;
        }
        return null;
    }

    public Boolean getRuleEngineIsMainWorkRole(Map<String, Object> ruleEngineData) {
        return !"false".equals(ruleEngineData.get("hsas_salaryfile_ismainrole"));
    }

    public static final CloudSalaryFileDataHelper getInstance() {
        return Load.INSTANCE;
    }

    private CloudSalaryFileDataHelper() {
    }

    public Set<Long> updatePayDateSalaryData(List<CollaSalaryFileDataEntity> updatePayStartDateList, List<String> errorLog) {
        try {
            return this.updateEmpPosOrgRelPayDate(updatePayStartDateList, errorLog);
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u4fee\u6539\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u201c\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u201d\u548c\u201c\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u201d\u5747\u5931\u8d25: {0}\u3002", (String)"CloudSalaryFileDataHelper_0", (String)"swc-hsas-business", (Object[])new Object[]{ex.getMessage()})), new Object[0]);
        }
    }

    private Set<Long> updateEmpPosOrgRelPayDate(List<CollaSalaryFileDataEntity> updateDateList, List<String> errorLog) {
        if (CollectionUtils.isEmpty(updateDateList)) {
            return Collections.emptySet();
        }
        return this.addOrgTeamSalaryData(updateDateList, errorLog);
    }

    public Set<Long> addOrgTeamSalaryData(List<CollaSalaryFileDataEntity> addOrgTeamList, List<String> errorLog) {
        if (CollectionUtils.isEmpty(addOrgTeamList)) {
            return Collections.emptySet();
        }
        try {
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(10);
            for (CollaSalaryFileDataEntity entity : addOrgTeamList) {
                DynamicObject depemp = entity.getDepEmp();
                DynamicObject salaryFile = entity.getSalaryFile();
                DynamicObject existSalaryFile = entity.getExistSalaryFile();
                HashMap<String, Serializable> data = new HashMap<String, Serializable>(16);
                ArrayList workRoles = new ArrayList(10);
                HashMap<String, Object> workRole = new HashMap<String, Object>(16);
                workRole.put("workRole", depemp);
                workRole.put("workRoleId", depemp.getLong("id"));
                workRole.put("isMainWorkRole", "0");
                workRole.put("payStartDate", entity.getPayStartDate());
                Date payEndDate = entity.getPayEndDate();
                if (payEndDate == null) {
                    payEndDate = SalaryFileEmpPosOrgRelHelper.getMaxDate();
                }
                workRole.put("payEndDate", payEndDate);
                workRoles.add(workRole);
                data.put("salaryFileId", Long.valueOf(existSalaryFile.getLong("boid")));
                data.put("workRoles", workRoles);
                datas.add(data);
            }
            OperationResult tempOpResult = SalaryFileEmpPosOrgRelHelper.saveEmpPosOrgRel(datas);
            if (tempOpResult != null && !tempOpResult.isSuccess()) {
                List allErrorOrValidateInfo = tempOpResult.getAllErrorOrValidateInfo();
                if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                    throw new KDBizException(tempOpResult.getMessage());
                }
                throw new KDBizException(allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator())));
            }
            if (tempOpResult != null && tempOpResult.isSuccess()) {
                return tempOpResult.getSuccessPkIds().stream().map(item -> Long.valueOf(String.valueOf(item))).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u6dfb\u52a0\u6216\u4fee\u6539\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u5931\u8d25: {0}", (String)"CloudSalaryFileDataHelper_2", (String)"swc-hsas-business", (Object[])new Object[]{ex.getMessage()})), new Object[0]);
        }
    }

    public DynamicObject getSalaryFileByDepEmpAndDate(Long depEmpId, Date effectTime) {
        return this.getSalaryFileByDepEmpAndDate(depEmpId, effectTime, false);
    }

    public DynamicObject getSalaryFileByDepEmpAndDate(Long depEmpId, Date effectTime, boolean isAudited) {
        List<Map<String, Object>> result = this.getSalaryFile(depEmpId, effectTime, isAudited);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        List resultList = (List)result.get(0).get("matchSalaryFileVers");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return null;
        }
        return (DynamicObject)resultList.get(0);
    }

    public List<DynamicObject> getSalaryFileByDepEmp(Long depEmpId, boolean isAudited) {
        List<Map<String, Object>> result = this.getSalaryFile(depEmpId, null, isAudited);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        List resultList = (List)result.get(0).get("matchSalaryFileVers");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Collections.emptyList();
        }
        return resultList;
    }

    private List<Map<String, Object>> getSalaryFile(Long depEmpId, Date effectTime, boolean isAudited) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("depEmpId", depEmpId);
        params.put("endDate", effectTime);
        params.put("status", isAudited ? Collections.singletonList("C") : Arrays.asList("A", "B", "C"));
        SalaryFileServiceHelper helper = new SalaryFileServiceHelper();
        return helper.matchSalaryFile(Collections.singletonList(params));
    }

    public boolean isPayRollGroupEqual(DynamicObject salaryFile, Long ruleEnginePayRollGroupId) {
        if (ruleEnginePayRollGroupId == null || salaryFile == null || ruleEnginePayRollGroupId == 0L) {
            return false;
        }
        long payRollGrpId = salaryFile.getLong(PAYROLLGROUP_ID);
        return ruleEnginePayRollGroupId.equals(payRollGrpId);
    }

    public DynamicObject confirmCopyData(DynamicObject newSalaryFile, Map<String, Object> commonParams, DynamicObject querySalaryFile) {
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        HashSet<String> ignoreFields = new HashSet<String>(contextHelper.parseCurrentCollaFields(commonParams, "hsas_salaryfile"));
        ignoreFields.add("bsled");
        HRDynamicObjectUtils.copy((DynamicObject)querySalaryFile, (DynamicObject)newSalaryFile, ignoreFields);
        contextHelper.parseAndSetCustomizeResultOnlyExistData(newSalaryFile, commonParams, querySalaryFile);
        newSalaryFile.set("id", (Object)querySalaryFile.getLong("id"));
        newSalaryFile.set("boid", querySalaryFile.get("boid"));
        newSalaryFile.set("sourcevid", querySalaryFile.get("sourcevid"));
        newSalaryFile.set("number", (Object)querySalaryFile.getString("number"));
        newSalaryFile.set("name", (Object)querySalaryFile.getString("name"));
        newSalaryFile.set("salaryfile", (Object)querySalaryFile);
        newSalaryFile.set("iscurrentversion", (Object)"1");
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        newSalaryFile.set("creator", (Object)userId);
        newSalaryFile.set("status", (Object)"C");
        return newSalaryFile;
    }

    public boolean isMainWorkRole(DynamicObject existSalaryFile, Long depEmpId) {
        if (depEmpId == null) {
            return false;
        }
        long salaryFileId = existSalaryFile.getLong("id");
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter salaryFileQFilter = new QFilter("salaryfile.id", "=", (Object)salaryFileId);
        QFilter workRoleQFilter = new QFilter("workrole.id", "=", (Object)depEmpId);
        DynamicObject query = empPosOrgRelOrm.queryOne("id,number,workrole,ismainworkrole", new QFilter[]{salaryFileQFilter, workRoleQFilter});
        if (query == null) {
            return this.isDepEmpInMainSalaryFile(salaryFileId, depEmpId);
        }
        DynamicObjectCollection entryEntity = query.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return this.isDepEmpInMainSalaryFile(salaryFileId, depEmpId);
        }
        for (DynamicObject dynamicObject : entryEntity) {
            long workRoleId = dynamicObject.getLong("workrole.id");
            if (!depEmpId.equals(workRoleId)) continue;
            return "1".equals(dynamicObject.getString("ismainworkrole"));
        }
        return false;
    }

    private boolean isDepEmpInMainSalaryFile(Long salaryFileId, Long depEmpId) {
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileQFilter = new QFilter("id", "=", (Object)salaryFileId);
        QFilter workRoleQFilter = new QFilter("depemp.id", "=", (Object)depEmpId);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        return salaryFileOrm.isExists(new QFilter[]{salaryFileQFilter, workRoleQFilter, dataStatusQFilter});
    }

    public boolean isPayStartDateBeforeRuleEngineBsed(DynamicObject existSalaryFile, Long depEmpId, Date ruleEngineBsed) {
        QFilter workRoleQFilter;
        if (depEmpId == null || existSalaryFile == null || ruleEngineBsed == null) {
            return false;
        }
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter salaryFileQFilter = new QFilter("salaryfile.id", "=", (Object)existSalaryFile.getLong("boid"));
        DynamicObject query = empPosOrgRelOrm.queryOne("id,number,workrole,ismainworkrole,paystartdate", new QFilter[]{salaryFileQFilter, workRoleQFilter = new QFilter("workrole.id", "=", (Object)depEmpId)});
        if (query == null) {
            return false;
        }
        DynamicObjectCollection entryEntity = query.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return false;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            long workRoleId = dynamicObject.getLong("workrole.id");
            if (!depEmpId.equals(workRoleId)) continue;
            Date payStartDate = dynamicObject.getDate("paystartdate");
            if (!payStartDate.before(ruleEngineBsed)) break;
            return true;
        }
        return false;
    }

    public DynamicObject getSalaryFileByPayRollGroupAndEmployee(Long ruleEnginePayRollGroupId, Long personId) {
        if (ruleEnginePayRollGroupId == null || personId == null) {
            return null;
        }
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        QFilter payRollGroupQFilter = new QFilter(PAYROLLGROUP_ID, "=", (Object)ruleEnginePayRollGroupId);
        QFilter personQFilter = new QFilter("person.id", "=", (Object)personId);
        return salaryFileOrm.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{enableQFilter, versionQFilter, payRollGroupQFilter, personQFilter, dataStatusQFilter, statusQFilter});
    }

    public DynamicObject getUnAuditSalaryFileByPayRollGroupAndEmployee(Long ruleEnginePayRollGroupId, Long personId) {
        if (ruleEnginePayRollGroupId == null || personId == null) {
            return null;
        }
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "in", Arrays.asList("A", "B"));
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter payRollGroupQFilter = new QFilter(PAYROLLGROUP_ID, "=", (Object)ruleEnginePayRollGroupId);
        QFilter personQFilter = new QFilter("person.id", "=", (Object)personId);
        return salaryFileOrm.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{enableQFilter, versionQFilter, payRollGroupQFilter, personQFilter, statusQFilter});
    }

    public Set<Long> insertSalaryData(List<DynamicObject> salaryFiles, List<String> errorLog) {
        if (CollectionUtils.isEmpty(salaryFiles)) {
            return Collections.emptySet();
        }
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        salaryFiles.stream().forEach(item -> item.set("id", (Object)ORM.create().genLongId("hsas_salaryfile")));
        OperationResult saveOpResult = this.invokeOperation(salaryFiles, "save");
        if (!saveOpResult.isSuccess()) {
            String message = saveOpResult.getMessage();
            if (SWCStringUtils.isNotEmpty((String)message)) {
                errorLog.add(message);
            }
            List allErrorOrValidateInfo = saveOpResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                errorLog.add(iOperateInfo.toString());
            }
            LOGGER.info("[colla]: local Invoke salaryfile save Operation error. msg = {}", errorLog);
            throw new KDException(new ErrorCode("CloudCollaSalaryFileDataAssemblePlugin_insertSalaryData_save", errorLog.stream().collect(Collectors.joining(System.lineSeparator()))), new Object[0]);
        }
        List savePkIds = saveOpResult.getSuccessPkIds();
        DynamicObject[] savedData = salaryFileOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{new QFilter("id", "in", (Object)savePkIds), new QFilter("status", "=", (Object)"A")});
        OperationResult submitOpResult = this.invokeOperation(Arrays.asList(savedData), "submit");
        if (!submitOpResult.isSuccess()) {
            String message = submitOpResult.getMessage();
            if (SWCStringUtils.isNotEmpty((String)message)) {
                errorLog.add(message);
            }
            List allErrorOrValidateInfo = submitOpResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                errorLog.add(iOperateInfo.toString());
            }
            LOGGER.info("[colla]: local Invoke salaryfile submit Operation error. msg = {}", errorLog);
            throw new KDException(new ErrorCode("CloudCollaSalaryFileDataAssemblePlugin_insertSalaryData_submit", errorLog.stream().collect(Collectors.joining(System.lineSeparator()))), new Object[0]);
        }
        List submitPkIds = submitOpResult.getSuccessPkIds();
        DynamicObject[] submitDatas = salaryFileOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{new QFilter("id", "in", (Object)submitPkIds), new QFilter("status", "=", (Object)"B")});
        OperationResult auditOpResult = this.invokeOperation(Arrays.asList(submitDatas), "audit");
        if (!auditOpResult.isSuccess()) {
            String message = auditOpResult.getMessage();
            if (SWCStringUtils.isNotEmpty((String)message)) {
                errorLog.add(message);
            }
            List allErrorOrValidateInfo = auditOpResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                errorLog.add(iOperateInfo.toString());
            }
            LOGGER.info("[colla]: local Invoke salaryfile audit Operation error. msg = {}", errorLog);
            throw new KDException(new ErrorCode("CloudCollaSalaryFileDataAssemblePlugin_insertSalaryData_audit", errorLog.stream().collect(Collectors.joining(System.lineSeparator()))), new Object[0]);
        }
        return Arrays.stream(savedData).map(item -> item.getLong("boid")).collect(Collectors.toSet());
    }

    public OperationResult invokeOperation(List<DynamicObject> datas, String operateType) {
        if (CollectionUtils.isEmpty(datas)) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(true);
            return operationResult;
        }
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("cloudcolla", "true");
        opOption.setVariableValue("ishasright", "true");
        opOption.setVariableValue("skipCheckDataPermission", "true");
        opOption.setVariableValue("skipCheckSpecialDataPermission", "true");
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult tempOpResult = operationService.localInvokeOperation(operateType, datas.toArray(new DynamicObject[0]), opOption);
        return tempOpResult;
    }

    public Set<Long> confirmChangeSalaryData(List<DynamicObject> salaryFiles, List<String> errorLog) {
        if (salaryFiles == null || salaryFiles.isEmpty()) {
            return Collections.emptySet();
        }
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("cloudcolla", "true");
        opOption.setVariableValue("ishasright", "true");
        opOption.setVariableValue("skipCheckDataPermission", "true");
        opOption.setVariableValue("skipCheckSpecialDataPermission", "true");
        OperationResult opResult = operationService.localInvokeOperation("saveafteraudit", salaryFiles.toArray(new DynamicObject[0]), opOption);
        if (!opResult.isSuccess()) {
            String message = opResult.getMessage();
            if (SWCStringUtils.isNotEmpty((String)message)) {
                errorLog.add(message);
            }
            List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                errorLog.add(iOperateInfo.toString());
            }
            LOGGER.info("[colla]:confirmChangeSalaryData saveTimeVersion getErrorMessage={0}", (Object)opResult.getMessage());
            throw new KDException(new ErrorCode("CloudCollaSalaryFileDataAssemblePlugin_insertSalaryData_confirmchage", errorLog.stream().collect(Collectors.joining(System.lineSeparator()))), new Object[0]);
        }
        return opResult.getSuccessPkIds().stream().map(item -> Long.valueOf(String.valueOf(item))).collect(Collectors.toSet());
    }

    public void validateEmpGroup(DynamicObject salaryFileObject) {
        long fieldId;
        if (salaryFileObject == null) {
            return;
        }
        Long businessFieldId = 107010L;
        if (!businessFieldId.equals(fieldId = salaryFileObject.getLong("empgroup.bussinessfield.id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8ba1\u85aa\u4eba\u5458\u7ec4\u4e0d\u662f\u7b97\u53d1\u85aa\u7ba1\u7406\u7684\u4eba\u5458\u7ec4\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"CloudSalaryFileDataHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    public void validateEffectDate(Map<String, DynamicObject> databaseDatas, DynamicObject salaryFile) throws ParseException {
        if (salaryFile == null) {
            return;
        }
        Date tempEffactDate = salaryFile.getDate("bsed");
        if (tempEffactDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u534f\u4f5c\u89c4\u5219\u914d\u7f6e\u3002", (String)"CloudSalaryFileDataHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        Date effectDate = SWCDateTimeUtils.formatDateToDate((Date)tempEffactDate, (String)"yyyy-MM-dd");
        salaryFile.set("bsed", (Object)effectDate);
    }

    public void validateAndSetPayrollGroup(Map<String, DynamicObject> databaseDatas, DynamicObject salaryFileObject, Long orgId) {
        DynamicObject databaseSalaryFile = this.getDatabaseSalaryFile(salaryFileObject, databaseDatas);
        if (databaseSalaryFile != null) {
            Long payRollGroupId;
            Long dataBasePayRollGroupId = databaseSalaryFile.getLong(PAYROLLGROUP_ID);
            if (!dataBasePayRollGroupId.equals(payRollGroupId = Long.valueOf(salaryFileObject.getLong(PAYROLLGROUP_ID)))) {
                throw new KDBizException(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4efb\u804c\u7ecf\u5386({2})\u5df2\u5b58\u5728\u4e8e\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{3}\uff09\uff0c\u4e14\u85aa\u8d44\u6863\u6848\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0e\u534f\u4f5c\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"CloudSalaryFileDataHelper_7", (String)"swc-hsas-business", (Object[])new Object[]{salaryFileObject.getString("employee.showname"), salaryFileObject.getString("employee.empnumber"), salaryFileObject.getString("empposinfo.number"), databaseSalaryFile.getString("number")}));
            }
            return;
        }
        long dataBaseOrgId = salaryFileObject.getLong("payrollgroup.org.id");
        if (!orgId.equals(dataBaseOrgId)) {
            LOGGER.info("[colla]: database salaryfile payrollgroup {} != {} ", (Object)dataBaseOrgId, (Object)orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5f53\u524d\u534f\u4f5c\u4efb\u52a1\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u65b0\u589e\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"CloudSalaryFileDataHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    public void setPropertyValue(DynamicObject salaryFile, Map<String, List<DynamicObject>> commonDatas, String property, String entityName) {
        List<DynamicObject> entityLists = commonDatas.get(entityName);
        if (CollectionUtils.isEmpty(entityLists)) {
            return;
        }
        entityLists.stream().filter(item -> item.getBoolean("iscurrentversion")).findFirst().ifPresent(item -> salaryFile.set(property, item));
    }

    public Optional<DynamicObject> getCurrentEntity(Map<String, List<DynamicObject>> commonDatas, String entityName) {
        if (commonDatas == null) {
            return Optional.empty();
        }
        List<DynamicObject> datas = commonDatas.get(entityName);
        if (datas == null || datas.size() == 0) {
            return Optional.empty();
        }
        return datas.stream().filter(item -> item.getBoolean("iscurrentversion")).findFirst();
    }

    public Long getCurrentEntityId(Map<String, List<DynamicObject>> commonDatas, String entityName) {
        Optional<DynamicObject> currentEntity = this.getCurrentEntity(commonDatas, entityName);
        if (currentEntity.isPresent()) {
            return currentEntity.get().getLong("id");
        }
        return null;
    }

    private String appendKeys(Object ... keys) {
        if (keys == null || keys.length == 0) {
            return "";
        }
        return Arrays.stream(keys).map(String::valueOf).collect(Collectors.joining("#"));
    }

    public Map<String, DynamicObject> getDatabaseDatas(List<DynamicObject> salaryFiles) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(salaryFiles.size());
        ArrayList employeeIds = new ArrayList(salaryFiles.size());
        ArrayList empposInfoIds = new ArrayList(salaryFiles.size());
        ArrayList payRollGroupIds = new ArrayList(salaryFiles.size());
        salaryFiles.forEach(item -> {
            long employeeId = item.getLong(EMPLOYEE_ID);
            long empPosInfoId = item.getLong(EMPPOSINFO_ID);
            long payRollGroupId = item.getLong(PAYROLLGROUP_ID);
            employeeIds.add(employeeId != 0L ? Long.valueOf(employeeId) : null);
            empposInfoIds.add(empPosInfoId != 0L ? Long.valueOf(empPosInfoId) : null);
            payRollGroupIds.add(payRollGroupId != 0L ? Long.valueOf(payRollGroupId) : null);
        });
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter employeeQfilter = new QFilter(EMPLOYEE_ID, "in", employeeIds);
        QFilter empposInfoQfilter = new QFilter(EMPPOSINFO_ID, "in", empposInfoIds);
        QFilter payRollGroupQfilter = new QFilter(PAYROLLGROUP_ID, "in", payRollGroupIds);
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQfilter = new QFilter("status", "!=", (Object)"E");
        QFilter currentQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] tempEmployeePosResults = salaryFileOrm.query(SALARY_FILE_PROPERTY, new QFilter[]{employeeQfilter, empposInfoQfilter, enableQfilter, statusQfilter, currentQfilter});
        DynamicObject[] tempEmployeePayRollGrpResults = salaryFileOrm.query(SALARY_FILE_PROPERTY, new QFilter[]{employeeQfilter, payRollGroupQfilter, enableQfilter, statusQfilter, currentQfilter});
        ArrayList<DynamicObject> queryResults = new ArrayList<DynamicObject>(10);
        List<DynamicObject> employeePosResults = Arrays.asList(tempEmployeePosResults);
        List<DynamicObject> employeePayRollGrpResults = Arrays.asList(tempEmployeePayRollGrpResults);
        queryResults.addAll(employeePosResults);
        queryResults.addAll(employeePayRollGrpResults);
        if (queryResults.size() == 0) {
            return null;
        }
        for (DynamicObject queryResult : queryResults) {
            long salaryFileId = queryResult.getLong("id");
            long employeeId = queryResult.getLong(EMPLOYEE_ID);
            long empposInfoId = queryResult.getLong(EMPPOSINFO_ID);
            long payRollGroupId = queryResult.getLong(PAYROLLGROUP_ID);
            if (!this.isAnyNotBlank(salaryFileId, empposInfoId, employeeId, payRollGroupId)) continue;
            result.put(this.appendKeys(String.valueOf(employeeId), String.valueOf(empposInfoId)), queryResult);
            result.put(this.appendKeys(String.valueOf(employeeId), String.valueOf(payRollGroupId)), queryResult);
        }
        return result;
    }

    private boolean isAnyNotBlank(long ... keys) {
        if (keys == null || keys.length == 0) {
            return false;
        }
        for (long key : keys) {
            if (key != 0L) continue;
            return false;
        }
        return true;
    }

    public DynamicObject getDatabaseSalaryFile(DynamicObject salaryFile, Map<String, DynamicObject> databaseData) {
        if (databaseData == null || databaseData.isEmpty()) {
            return null;
        }
        String employeeId = String.valueOf(salaryFile.getLong(EMPLOYEE_ID));
        String empposInfoId = String.valueOf(salaryFile.getLong(EMPPOSINFO_ID));
        String payRollGroupId = String.valueOf(salaryFile.getLong(PAYROLLGROUP_ID));
        DynamicObject querySalaryFile = databaseData.get(this.appendKeys(employeeId, empposInfoId));
        if (querySalaryFile != null) {
            return querySalaryFile;
        }
        DynamicObject payRolSalaryfile = databaseData.get(this.appendKeys(employeeId, payRollGroupId));
        if (payRolSalaryfile != null) {
            return payRolSalaryfile;
        }
        return null;
    }

    public void validate(DynamicObject salaryFile, CloudSalaryFileDataHelper helper) {
        Map<String, DynamicObject> databaseDatas = helper.getDatabaseDatas(Collections.singletonList(salaryFile));
        try {
            helper.validateEffectDate(databaseDatas, salaryFile);
        }
        catch (ParseException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"CloudSalaryFileDataHelper_9", (String)"swc-hsas-business", (Object[])new Object[0])), new Object[0]);
        }
        helper.validateEmpGroup(salaryFile);
    }

    public void setCommonValue(DynamicObject salaryFile, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams) {
        Optional<DynamicObject> currentEntity;
        this.setPropertyValue(salaryFile, assembleSaveData, "person", "hsas_personhr");
        this.setPropertyValue(salaryFile, assembleSaveData, "employee", "hsas_employee");
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("bos_org");
        Long orgId = (Long)commonParams.get("orgId");
        DynamicObject dy = serviceHelper.queryOne((Object)orgId);
        salaryFile.set("org", (Object)dy);
        DynamicObject payRollGroup = salaryFile.getDynamicObject(PAY_ROLL_GROUP);
        if (null != payRollGroup) {
            salaryFile.set("payrollregion", (Object)payRollGroup.getDynamicObject("country"));
            salaryFile.set("org", (Object)payRollGroup.getDynamicObject("org"));
        }
        if ((currentEntity = this.getCurrentEntity(assembleSaveData, "hsas_depemp")).isPresent()) {
            DynamicObject depEmpObject = currentEntity.get();
            salaryFile.set("depemp", (Object)depEmpObject);
            if (depEmpObject.getLong(ADMINORG_ID) != salaryFile.getLong(ADMINORG_ID)) {
                salaryFile.set("isescrowstaff", (Object)"1");
            } else {
                salaryFile.set("isescrowstaff", (Object)"0");
            }
        }
        this.setPropertyValue(salaryFile, assembleSaveData, "managingscope", "hsas_managingscope");
        salaryFile.set("status", (Object)"C");
        salaryFile.set("enable", (Object)"1");
        DynamicObject dynamicObject = salaryFile.getDynamicObject("salarycalcstyle");
        if (dynamicObject != null && dynamicObject.getDataEntityType().getProperties().containsKey((Object)SALARY_CAL_STYLE)) {
            salaryFile.set("paystatus", (Object)dynamicObject.getString(SALARY_CAL_STYLE));
        }
    }

    public Map<String, Object> relateSalaryTaxFile(Long taxFileId, Long SalaryFileId) {
        SWCDataServiceHelper relOrm = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        DynamicObject data = relOrm.queryOne(new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("salaryfile", "=", (Object)SalaryFileId), new QFilter("taxfile", "=", (Object)taxFileId)});
        Long oldRelId = null;
        if (data != null) {
            oldRelId = data.getLong("id");
        }
        BaseResult<?> baseResult = SalaryTaxFileRelServiceHelper.relateSalaryWithTaxFile(taxFileId, SalaryFileId, oldRelId);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (baseResult.isSuccess()) {
            result.put("success", Boolean.TRUE);
            return result;
        }
        result.put("success", Boolean.FALSE);
        result.put("errorMsg", baseResult.getMessage());
        return result;
    }

    private static class Load {
        private static final CloudSalaryFileDataHelper INSTANCE = new CloudSalaryFileDataHelper();

        private Load() {
        }
    }
}

