/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileDataHelper;
import kd.swc.hsas.business.cloudcolla.ICloudCollaSalaryFileHandler;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.common.dto.CollaSalaryFileDataEntity;
import kd.swc.hsas.common.enums.CloudSalaryFileTypeEnum;

public class CloudSalaryFileFlowInHandler
implements ICloudCollaSalaryFileHandler {
    private static final Log LOGGER = LogFactory.getLog(CloudSalaryFileFlowInHandler.class);

    private CloudSalaryFileFlowInHandler() {
    }

    public static CloudSalaryFileFlowInHandler getInstance() {
        return Load.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<Integer, CollaSalaryFileDataEntity> AssembleData(DynamicObject salaryFile, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> fieldMapResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData) {
        LOGGER.info("[colla] CloudSalaryFileFlowInHandler begin");
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        Optional<DynamicObject> depEmpOp = helper.getCurrentEntity(assembleSaveData, "hsas_depemp");
        if (!depEmpOp.isPresent()) {
            LOGGER.info("[colla] 0. CloudSalaryFileFlowInHandler: depEmp == null");
            return null;
        }
        DynamicObject depEmp = depEmpOp.get();
        Long depEmpId = depEmp.getLong("id");
        Date effectTime = (Date)commonParams.get("effectTime");
        Long ruleEnginePayRollGroupId = salaryFile.getLong("payrollgroup.id");
        Boolean ruleEngineIsMainWorkRole = helper.getRuleEngineIsMainWorkRole(ruleEngineData);
        Date ruleEngineBsed = salaryFile.getDate("bsed");
        Optional<DynamicObject> employeeOp = helper.getCurrentEntity(assembleSaveData, "hsas_employee");
        Optional<DynamicObject> personOp = helper.getCurrentEntity(assembleSaveData, "hsas_personhr");
        if (!employeeOp.isPresent() || !personOp.isPresent()) {
            LOGGER.info("[colla] 0. CloudSalaryFileFlowInHandler: employee == null || person == null");
            return null;
        }
        DynamicObject employee = employeeOp.get();
        Long employeeId = employee.getLong("id");
        DynamicObject person = personOp.get();
        Long personId = person.getLong("id");
        HashMap<Integer, CollaSalaryFileDataEntity> result = new HashMap<Integer, CollaSalaryFileDataEntity>(16);
        DynamicObject existSalaryFile = helper.getSalaryFileByDepEmpAndDate(depEmpId, effectTime);
        CollaSalaryFileDataEntity dataEntity = new CollaSalaryFileDataEntity();
        if (existSalaryFile != null) {
            LOGGER.info("[colla] 1. CloudSalaryFileFlowInHandler: employeeId ={}, condition: existSalaryFile != null", (Object)employeeId);
            dataEntity.setExistSalaryFile(existSalaryFile);
            if (!"C".equals(existSalaryFile.getString("status"))) {
                throw new KDBizException(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5173\u8054\u7684\u85aa\u8d44\u6863\u6848({3})\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u8fdb\u884c\u5ba1\u6838\u3002", (String)"CloudSalaryFileFlowInHandler_0", (String)"swc-hsas-business", (Object[])new Object[]{employee.getString("showname"), employee.getString("empnumber"), depEmp.getString("number"), existSalaryFile.getString("number")}));
            }
            if (!helper.isPayRollGroupEqual(existSalaryFile, ruleEnginePayRollGroupId)) {
                salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
                dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
                dataEntity.setExistSalaryFile(existSalaryFile);
                salaryFile.set("payrollgroup", existSalaryFile.get("payrollgroup"));
                dataEntity.setSalaryFile(salaryFile);
            } else if (ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole.booleanValue()) {
                LOGGER.info("[colla] 2. CloudSalaryFileFlowInHandler: employeeId ={}, condition: ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole", (Object)employeeId);
                salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
                dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
                dataEntity.setExistSalaryFile(existSalaryFile);
            } else {
                LOGGER.info("[colla] 3. CloudSalaryFileFlowInHandler: employeeId ={}, condition: else(ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole)", (Object)employeeId);
                if (helper.isMainWorkRole(existSalaryFile, depEmpId)) {
                    LOGGER.info("[colla] 4. CloudSalaryFileFlowInHandler: employeeId ={}, condition: helper.isMainWorkRole(existSalaryFile, depEmpId)", (Object)employeeId);
                    salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
                    dataEntity.setExistSalaryFile(existSalaryFile);
                } else {
                    LOGGER.info("[colla] 5. CloudSalaryFileFlowInHandler: employeeId ={}, condition: else(helper.isMainWorkRole(existSalaryFile, depEmpId))", (Object)employeeId);
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.UPDATE_PAY_START_END_DATE);
                    dataEntity.setPayStartDate(salaryFile.getDate("bsed"));
                    dataEntity.setDepEmp(depEmp);
                    dataEntity.setPayEndDate(SalaryFileEmpPosOrgRelHelper.getMaxDate());
                }
            }
        } else {
            DynamicObject dynamicObject;
            LOGGER.info("[colla] 8. CloudSalaryFileFlowInHandler: employeeId ={}, condition: else(existSalaryFile != null)", (Object)employeeId);
            if (ruleEngineIsMainWorkRole.booleanValue()) {
                LOGGER.info("[colla] 9. CloudSalaryFileFlowInHandler: employeeId ={}, condition: ruleEngineIsMainWorkRole", (Object)employeeId);
                dynamicObject = helper.getSalaryFileByPayRollGroupAndEmployee(ruleEnginePayRollGroupId, personId);
                if (dynamicObject == null) {
                    DynamicObject unAuditSalaryFile = helper.getUnAuditSalaryFileByPayRollGroupAndEmployee(ruleEnginePayRollGroupId, personId);
                    if (unAuditSalaryFile != null) throw new KDBizException(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u85aa\u8d44\u6863\u6848({2})\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u8fdb\u884c\u5ba1\u6838\u3002", (String)"CloudSalaryFileFlowInHandler_4", (String)"swc-hsas-business", (Object[])new Object[]{employee.getString("showname"), employee.getString("empnumber"), unAuditSalaryFile.getString("number")}));
                    LOGGER.info("[colla] 9.1 CloudSalaryFileFlowInHandler: employeeId ={}, condition: ruleEngineIsMainWorkRole,dynamicObject == null", (Object)employeeId);
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.NEW);
                } else {
                    LOGGER.info("[colla] 9.2 CloudSalaryFileFlowInHandler: employeeId ={}, condition: ruleEngineIsMainWorkRole,dynamicObject != null", (Object)employeeId);
                    salaryFile = helper.confirmCopyData(salaryFile, commonParams, dynamicObject);
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
                    dataEntity.setExistSalaryFile(dynamicObject);
                }
            } else {
                LOGGER.info("[colla] 10. CloudSalaryFileFlowInHandler: employeeId ={}, condition: else(ruleEngineIsMainWorkRole)", (Object)employeeId);
                dynamicObject = helper.getSalaryFileByPayRollGroupAndEmployee(ruleEnginePayRollGroupId, personId);
                if (dynamicObject == null) {
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.NEW);
                } else {
                    Date bsed = salaryFile.getDate("bsed");
                    dataEntity.setSaveType(CloudSalaryFileTypeEnum.UPDATE_PAY_START_END_DATE);
                    dataEntity.setPayEndDate(SalaryFileEmpPosOrgRelHelper.getMaxDate());
                    dataEntity.setPayStartDate(bsed);
                    dataEntity.setDepEmp(depEmp);
                    dataEntity.setExistSalaryFile(dynamicObject);
                }
            }
        }
        helper.setCommonValue(salaryFile, assembleSaveData, commonParams);
        helper.validate(salaryFile, helper);
        String name = salaryFile.getDataEntityType().getName();
        List<DynamicObject> dynamicObjects = assembleSaveData.get(name);
        if (dynamicObjects == null) {
            dynamicObjects = new ArrayList<DynamicObject>(10);
            assembleSaveData.put(name, dynamicObjects);
        }
        dynamicObjects.add(salaryFile);
        dataEntity.setSalaryFile(salaryFile);
        dataEntity.setDepEmpId(depEmpId);
        result.put(salaryFile.hashCode(), dataEntity);
        return result;
    }

    private static class Load {
        private static final CloudSalaryFileFlowInHandler INSTANCE = new CloudSalaryFileFlowInHandler();

        private Load() {
        }
    }
}

