/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cloudcolla.CloudSalaryFileDataHelper;
import kd.swc.hsas.business.cloudcolla.ICloudCollaSalaryFileHandler;
import kd.swc.hsas.common.dto.CollaSalaryFileDataEntity;
import kd.swc.hsas.common.enums.CloudSalaryFileTypeEnum;

public class CloudSalaryFileFlowOutHandler
implements ICloudCollaSalaryFileHandler {
    private static final Log LOGGER = LogFactory.getLog(CloudSalaryFileFlowOutHandler.class);

    private CloudSalaryFileFlowOutHandler() {
    }

    public static CloudSalaryFileFlowOutHandler getInstance() {
        return Load.INSTANCE;
    }

    @Override
    public Map<Integer, CollaSalaryFileDataEntity> AssembleData(DynamicObject salaryFile, Map<String, Object> fieldRuleResult, Map<String, List<DynamicObject>> fieldMapResult, Map<String, List<DynamicObject>> assembleSaveData, Map<String, Object> commonParams, Map<String, Object> ruleEngineData) {
        LOGGER.info("[colla] CloudSalaryFileFlowOutHandler begin");
        CloudSalaryFileDataHelper helper = CloudSalaryFileDataHelper.getInstance();
        Optional<DynamicObject> depEmpOp = helper.getCurrentEntity(assembleSaveData, "hsas_depemp");
        if (!depEmpOp.isPresent()) {
            LOGGER.info("[colla] 0. CloudSalaryFileFlowInHandler: depEmp == null");
            return null;
        }
        DynamicObject depEmp = depEmpOp.get();
        Long depEmpId = depEmp.getLong("id");
        Date effectTime = (Date)commonParams.get("effectTime");
        Long ruleEnginePayRollGroupId = salaryFile.getLong("payrollgroup.id");
        Boolean ruleEngineIsMainWorkRole = helper.getRuleEngineIsMainWorkRole(ruleEngineData);
        Optional<DynamicObject> employeeOp = helper.getCurrentEntity(assembleSaveData, "hsas_employee");
        if (!employeeOp.isPresent()) {
            LOGGER.info("[colla] 0. CloudSalaryFileFlowInHandler: employee == null");
            return null;
        }
        DynamicObject employee = employeeOp.get();
        Long employeeId = employee.getLong("id");
        HashMap<Integer, CollaSalaryFileDataEntity> result = new HashMap<Integer, CollaSalaryFileDataEntity>(16);
        DynamicObject existSalaryFile = helper.getSalaryFileByDepEmpAndDate(depEmpId, effectTime);
        CollaSalaryFileDataEntity dataEntity = new CollaSalaryFileDataEntity();
        if (existSalaryFile == null) {
            String effectTimeStr = HRInteDateTimeUtil.formatDate((String)"hpfs_chgrecord", (String)"effecttime", (Date)effectTime);
            throw new KDBizException(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5728{3}\u4e0d\u5b58\u5728\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u4f5c\u3002", (String)"CloudSalaryFileFlowOutHandler_0", (String)"swc-hsas-business", (Object[])new Object[]{employee.getString("showname"), employee.getString("empnumber"), depEmp.getString("number"), effectTimeStr}));
        }
        dataEntity.setExistSalaryFile(existSalaryFile);
        if (!"C".equals(existSalaryFile.getString("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5c97\u4f4d({2})\u5173\u8054\u7684\u85aa\u8d44\u6863\u6848({3})\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u8fdb\u884c\u5ba1\u6838\u3002", (String)"CloudSalaryFileFlowOutHandler_1", (String)"swc-hsas-business", (Object[])new Object[]{employee.getString("showname"), employee.getString("empnumber"), depEmp.getString("number"), existSalaryFile.getString("number")}));
        }
        if (!helper.isPayRollGroupEqual(existSalaryFile, ruleEnginePayRollGroupId)) {
            salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
            dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
            dataEntity.setExistSalaryFile(existSalaryFile);
            salaryFile.set("payrollgroup", existSalaryFile.get("payrollgroup"));
            dataEntity.setSalaryFile(salaryFile);
        } else if (ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole.booleanValue()) {
            LOGGER.info("[colla] 1. CloudSalaryFileFlowOutHandler: employeeId ={}, condition: ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole", (Object)employeeId);
            salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
            dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
            dataEntity.setExistSalaryFile(existSalaryFile);
            dataEntity.setSalaryFile(salaryFile);
            LOGGER.info("[colla] salaryfile = {}, existSalaryFile = {}", (Object)salaryFile, (Object)existSalaryFile);
        } else {
            LOGGER.info("[colla] 2. CloudSalaryFileFlowOutHandler: employeeId ={}, condition: else(ruleEngineIsMainWorkRole != null && ruleEngineIsMainWorkRole)", (Object)employeeId);
            if (helper.isMainWorkRole(existSalaryFile, depEmpId)) {
                LOGGER.info("[colla] 3. CloudSalaryFileFlowOutHandler: employeeId ={}, condition: helper.isMainWorkRole(existSalaryFile, depEmpId)", (Object)employeeId);
                salaryFile = helper.confirmCopyData(salaryFile, commonParams, existSalaryFile);
                dataEntity.setSaveType(CloudSalaryFileTypeEnum.CONFIRM_CHANGE);
                dataEntity.setExistSalaryFile(existSalaryFile);
                LOGGER.info("[colla] salaryfile = {}, existSalaryFile = {}", (Object)salaryFile, (Object)existSalaryFile);
            } else {
                dataEntity.setSaveType(CloudSalaryFileTypeEnum.DO_NOTHING);
            }
        }
        helper.setCommonValue(salaryFile, assembleSaveData, commonParams);
        helper.validate(salaryFile, helper);
        String name = salaryFile.getDataEntityType().getName();
        List<DynamicObject> dynamicObjects = assembleSaveData.get(name);
        if (dynamicObjects == null) {
            dynamicObjects = new ArrayList<DynamicObject>(10);
            assembleSaveData.put(name, dynamicObjects);
        }
        dynamicObjects.add(salaryFile);
        dataEntity.setSalaryFile(salaryFile);
        dataEntity.setDepEmpId(depEmpId);
        result.put(salaryFile.hashCode(), dataEntity);
        return result;
    }

    private static class Load {
        private static final CloudSalaryFileFlowOutHandler INSTANCE = new CloudSalaryFileFlowOutHandler();

        private Load() {
        }
    }
}

