/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.cloudcolla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cloudcolla.HSASCloudCollaRuleConstructHelper;
import kd.swc.hsbp.business.cloudcolla.StandardCloudCollaTaskExecuteHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CollaRuleExecuteContext;

@Deprecated
public class HSASCloudCollaExecuteHelper {
    private static final Log LOGGER = LogFactory.getLog(HSASCloudCollaExecuteHelper.class);

    private HSASCloudCollaExecuteHelper() {
    }

    public static HSASCloudCollaExecuteHelper getInstance() {
        return Load.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<String, Object>> executeCloudCollaTask(Map<String, Object> paramMap) {
        String key = (String)paramMap.get("key");
        if (SWCStringUtils.isEmpty((String)key)) {
            return this.doExecuteCloudCollaTask(paramMap);
        }
        DLock lock = DLock.create((String)("executeCloudCollaTask_" + key));
        if (!lock.tryLock(10000L)) {
            DLock.forceUnlock((String[])new String[]{key});
            lock.lock();
        }
        try {
            Map<Long, Map<String, Object>> map = this.doExecuteCloudCollaTask(paramMap);
            return map;
        }
        finally {
            this.releaseLock(key, lock);
        }
    }

    private void releaseLock(String key, DLock lock) {
        lock.unlock();
    }

    private Map<Long, Map<String, Object>> doExecuteCloudCollaTask(Map<String, Object> paramMap) {
        List entryDatas = (List)paramMap.get("taskCenterEntryData");
        if (CollectionUtils.isEmpty((Collection)entryDatas)) {
            return null;
        }
        ArrayList<Map> exeResultList = new ArrayList<Map>(entryDatas.size());
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(entryDatas.size());
        for (int i = 0; i < entryDatas.size(); ++i) {
            Map entryData = (Map)entryDatas.get(i);
            Long payRollActGrpId = (Long)entryData.get("payRollActGrpId");
            Long payRollActGrpVid = (Long)entryData.get("payRollActGrpVid");
            Long centerEntId = (Long)entryData.get("centerEntId");
            Boolean isManualVerify = entryData.getOrDefault("isManualVerify", Boolean.FALSE);
            paramMap.put("payRollActGrpId", isManualVerify != false ? payRollActGrpVid : payRollActGrpId);
            paramMap.put("centerEntId", centerEntId);
            paramMap.put("ruleDataSource", isManualVerify != false ? 1 : 0);
            paramMap.put("preExeResult", exeResultList);
            Map<String, Object> executeCloudCollaTask = this.doCollaRule(paramMap);
            result.put(centerEntId, executeCloudCollaTask);
            exeResultList.add((Map)executeCloudCollaTask.get("data"));
            if (((Boolean)executeCloudCollaTask.get("success")).booleanValue() || !((Boolean)entryData.get("stopAfterFail")).booleanValue()) continue;
            LOGGER.info("[colla]:stop after fail,payRollActGrpId={},centerEntId={}", (Object)payRollActGrpId, (Object)centerEntId);
            break;
        }
        return result;
    }

    public Map<String, Object> executeCollaRule(Map<String, Object> paramMap) {
        List collaRules = (List)paramMap.get("collaRules");
        if (CollectionUtils.isEmpty((Collection)collaRules)) {
            return null;
        }
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(collaRules.size());
        for (int i = 0; i < collaRules.size(); ++i) {
            Map collaRule = (Map)collaRules.get(i);
            Long payRollActGrpId = (Long)collaRule.get("payRollActGrpId");
            paramMap.put("payRollActGrpId", payRollActGrpId);
            Map<String, Object> executeCloudCollaTask = this.doCollaRule(collaRule);
            result.put(payRollActGrpId, executeCloudCollaTask);
            if (((Boolean)executeCloudCollaTask.get("success")).booleanValue()) continue;
            LOGGER.info("[colla]:executeCollaRule fail,payRollActGrpId={},payRollActGrpId={}", (Object)payRollActGrpId);
            break;
        }
        return this.success(result);
    }

    private Map<String, Object> doCollaRule(Map<String, Object> paramMap) {
        try {
            CollaRuleExecuteContext collaExecuteInfo = HSASCloudCollaRuleConstructHelper.getInstance().constructCollaRuleExecuteContext(paramMap);
            if (collaExecuteInfo == null) {
                return this.error("");
            }
            Map exeResult = new StandardCloudCollaTaskExecuteHelper(collaExecuteInfo).executeCloudCollaTask();
            Boolean success = (Boolean)exeResult.get("success");
            if (success != null && success.booleanValue()) {
                return this.success(collaExecuteInfo.getExeResult());
            }
            return this.error((String)exeResult.get("msg"));
        }
        catch (Exception e) {
            return this.error(e.getMessage());
        }
    }

    private Map<String, Object> success(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        result.put("msg", null);
        return result;
    }

    private Map<String, Object> error(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.FALSE);
        result.put("data", null);
        result.put("msg", msg);
        return result;
    }

    private static class Load {
        private static final HSASCloudCollaExecuteHelper INSTANCE = new HSASCloudCollaExecuteHelper();

        private Load() {
        }
    }
}

