/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.salaryfile.TaxFileServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;

public class ExportHelper {
    private static final Log logger = LogFactory.getLog(ExportHelper.class);
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String EXCEL_SUFFIX = ".xlsx";

    public static void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle style, ImportEntityRel importEntityRel) {
        ImportEntity mainEntity = importEntityRel.getMainEntity();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainEntity.getEntityId());
        ExportHelper.writeEntityNameRow(wb, sheet, style, entityType);
        ExportHelper.writeTipsRow(wb, sheet, style);
    }

    private static void writeEntityNameRow(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle style, MainEntityType entityType) {
        SXSSFRow entityRow = ExportHelper.getRow(sheet, 0);
        ExportHelper.createCell(entityRow, 0, style.getTextStyle()).setCellValue(entityType.getDisplayName() + " # " + entityType.getName());
    }

    private static void writeTipsRow(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle style) {
        SXSSFRow tipsRow = ExportHelper.getRow(sheet, 1);
        ExportHelper.createCell(tipsRow, 0, style.getTextHighLightStyle()).setCellValue(ResManager.loadKDString((String)"\u5c06\u9f20\u6807\u79fb\u81f3\u7070\u8272\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"ExportHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
    }

    public static void writeEntityField(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, ExportSheetStyle style, ImportEntityRel importEntityRel) {
        SXSSFRow fieldRow = ExportHelper.getRow(sheet, 2);
        ExportHelper.resolveMainEntityRel(wb, sheet, dropDownHiddenSheet, fieldRow, style, importEntityRel.getMainEntity());
        ExportHelper.resolveOtherEntityRel(wb, sheet, dropDownHiddenSheet, fieldRow, style, importEntityRel.getOtherEntities());
    }

    private static void resolveMainEntityRel(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, SXSSFRow fieldRow, ExportSheetStyle style, ImportEntity mainEntity) {
        ExportHelper.createEntityFieldCell(wb, sheet, dropDownHiddenSheet, fieldRow, style, mainEntity);
    }

    private static void resolveOtherEntityRel(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, SXSSFRow fieldRow, ExportSheetStyle style, List<ImportEntity> otherEntityTypes) {
        for (ImportEntity otherEntityType : otherEntityTypes) {
            ExportHelper.createEntityFieldCell(wb, sheet, dropDownHiddenSheet, fieldRow, style, otherEntityType);
        }
    }

    private static void createEntityFieldCell(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, SXSSFRow fieldRow, ExportSheetStyle style, ImportEntity entity) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity.getEntityId());
        if (null != entityType) {
            short lastCellNum = fieldRow.getLastCellNum();
            if (lastCellNum == -1) {
                lastCellNum = 0;
            }
            TaxFileServiceHelper.setComboItem(entity.getEntityId(), entityType);
            for (String field : entity.getFieldKey()) {
                String[] splitField = field.split("\\.");
                if (splitField.length == 1) {
                    ExportHelper.createFieldCell(wb, sheet, dropDownHiddenSheet, fieldRow, lastCellNum, style, entityType, field);
                    lastCellNum = (short)(lastCellNum + 1);
                    continue;
                }
                ExportHelper.createBaseDataCell(wb, sheet, fieldRow, lastCellNum, style, entityType, splitField);
                lastCellNum = (short)(lastCellNum + 1);
            }
        }
    }

    private static void createFieldCell(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, SXSSFRow fieldRow, short lastCellNum, ExportSheetStyle style, MainEntityType entityType, String field) {
        String caption;
        DynamicProperty dp = entityType.getProperty(field);
        XSSFHyperlink tips = ExportHelper.getFieldCellHyperLink(wb, dp);
        SXSSFCell cell = ExportHelper.createCell(fieldRow, lastCellNum, null);
        FieldProp fieldProp = (FieldProp)dp;
        boolean isMustInput = fieldProp.isMustInput();
        if (isMustInput) {
            caption = "*" + fieldProp.getDisplayName() + " # " + entityType.getName() + "." + fieldProp.getName();
            cell.setCellStyle(style.getTitleMustInputStyle());
        } else {
            caption = fieldProp.getDisplayName() + " # " + entityType.getName() + "." + fieldProp.getName();
            cell.setCellStyle(style.getTitleStyle());
        }
        if (dp instanceof ComboProp) {
            ExportHelper.setComboItemDropDownColumn(sheet, dropDownHiddenSheet, dp, lastCellNum);
        } else if (dp instanceof BooleanProp) {
            ExportHelper.setCheckBoxDropDownColumn(sheet, dropDownHiddenSheet, dp, lastCellNum);
        } else {
            CellStyle columnStyle = ExportHelper.getColumnStyle(wb, style, dp);
            sheet.setDefaultColumnStyle((int)lastCellNum, columnStyle);
        }
        sheet.setColumnWidth((int)lastCellNum, ExportHelper.calcColumnWidth(caption));
        cell.setCellValue(caption);
        cell.setHyperlink((Hyperlink)tips);
    }

    private static void setCheckBoxDropDownColumn(SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, DynamicProperty dp, short lastCellNum) {
        ArrayList<String> dropDownVals = new ArrayList<String>(10);
        dropDownVals.add(ResManager.loadKDString((String)"\u662f", (String)"ExportHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        dropDownVals.add(ResManager.loadKDString((String)"\u5426", (String)"ExportHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        String tip = "";
        if (SWCStringUtils.equals((String)dp.getName(), (String)"addtaxfilecheckbox")) {
            tip = ResManager.loadKDString((String)"\u5f53\u4e0d\u9700\u8981\u540c\u65f6\u521b\u5efa\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u65f6\uff0c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5b57\u6bb5\u65e0\u9700\u586b\u5199\u3002", (String)"ExportHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        ExportHelper.setDropDownColumn(sheet, dropDownHiddenSheet, dropDownVals, lastCellNum, tip);
    }

    private static void setComboItemDropDownColumn(SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, DynamicProperty dp, short lastCellNum) {
        ArrayList<String> dropDownVals = new ArrayList<String>(10);
        List mapItems = ((ComboProp)dp).getComboItems();
        for (ValueMapItem mapItem : mapItems) {
            dropDownVals.add(mapItem.getName().toString());
        }
        ExportHelper.setDropDownColumn(sheet, dropDownHiddenSheet, dropDownVals, lastCellNum, "");
    }

    private static void setDropDownColumn(SXSSFSheet sheet, SXSSFSheet dropDownHiddenSheet, List<String> dropDownVals, short lastCellNum, String tipStr) {
        if (CollectionUtils.isEmpty(dropDownVals)) {
            return;
        }
        int size = dropDownVals.size();
        for (int i = 0; i < size; ++i) {
            ExportHelper.getRow(dropDownHiddenSheet, i).createCell((int)lastCellNum).setCellValue(dropDownVals.get(i));
        }
        String currColLabel = ExportHelper.getColumnLabel(lastCellNum + 1);
        String strFormula = String.format("dropdown_items_sheet!$%s$%d:$%s$%d", currColLabel, 1, currColLabel, dropDownVals.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(3, 10000, (int)lastCellNum, (int)lastCellNum);
        DataValidationConstraint constraint = helper.createExplicitListConstraint(dropDownVals.toArray(new String[0]));
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createPromptBox("", tipStr);
        dataValidation.setShowPromptBox(true);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private static String getColumnLabel(int columnNo) {
        if (columnNo < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    private static void createBaseDataCell(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow fieldRow, short lastCellNum, ExportSheetStyle style, MainEntityType entityType, String[] splitField) {
        BasedataProp dp;
        String leftField = "";
        String rightField = "";
        int len = splitField.length;
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                leftField = splitField[i];
                continue;
            }
            if (i != 1) continue;
            rightField = splitField[i];
            break;
        }
        if ((dp = (BasedataProp)entityType.getProperty(leftField)) == null) {
            logger.info("[salaryfile_import] error,dp is null,leftField = {}", (Object)leftField);
            return;
        }
        boolean isMustInput = dp.isMustInput();
        String numberCaption = null;
        SXSSFCell numberCell = null;
        String importTag = rightField;
        String importTagName = "";
        if (SWCStringUtils.equals((String)importTag, (String)"number")) {
            importTagName = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)importTag, (String)"name")) {
            importTagName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)importTag, (String)"empnumber")) {
            importTagName = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExportHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        if ("depemp".equals(leftField) && SWCStringUtils.equals((String)importTag, (String)"number")) {
            importTagName = ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u7801", (String)"ExportHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        if (isMustInput) {
            numberCaption = "*" + dp.getDisplayName() + "." + importTagName + " # " + entityType.getName() + "." + dp.getName() + "." + importTag;
            numberCell = ExportHelper.createCell(fieldRow, lastCellNum, style.getTitleMustInputStyle());
        } else {
            numberCaption = dp.getDisplayName() + "." + importTagName + " # " + entityType.getName() + "." + dp.getName() + "." + importTag;
            numberCell = ExportHelper.createCell(fieldRow, lastCellNum, style.getTitleStyle());
        }
        CellStyle columnStyle = ExportHelper.getColumnStyle(wb, style, (DynamicProperty)dp);
        sheet.setDefaultColumnStyle((int)lastCellNum, columnStyle);
        sheet.setColumnWidth((int)lastCellNum, ExportHelper.calcColumnWidth(numberCaption));
        XSSFHyperlink numberTips = (XSSFHyperlink)wb.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        numberTips.setTooltip(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\uff0c\u652f\u6301\u5f55\u5165{0}\u3002", (String)"ExportHelper_5", (String)"swc-hsas-business", (Object[])new Object[]{importTagName}));
        numberCell.setCellValue(numberCaption);
        numberCell.setHyperlink((Hyperlink)numberTips);
    }

    private static XSSFHyperlink getFieldCellHyperLink(SXSSFWorkbook wb, DynamicProperty dp) {
        XSSFHyperlink tips = (XSSFHyperlink)wb.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        if (dp instanceof TextProp || dp instanceof LargeTextProp || dp instanceof VarcharProp || dp instanceof MuliLangTextProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u6587\u672c", (String)"ExportHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (dp instanceof AdminDivisionProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u6587\u672c\uff0c\u793a\u4f8b\uff1a\u4e2d\u56fd/\u5e7f\u4e1c/\u6df1\u5733/\u5357\u5c71/\u79d1\u6280\u56ed", (String)"ExportHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (dp instanceof DecimalProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u6570\u5b57", (String)"ExportHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (dp instanceof DateProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"ExportHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (dp instanceof DateTimeProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a2018-05-01 12:00:00", (String)"ExportHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (dp instanceof BooleanProp) {
            tips.setTooltip(ResManager.loadKDString((String)"\u9009\u9879\uff0c\u662f/\u5426", (String)"ExportHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else {
            tips = null;
        }
        return tips;
    }

    private static CellStyle getColumnStyle(SXSSFWorkbook wb, ExportSheetStyle style, DynamicProperty dp) {
        if (dp instanceof DateProp) {
            return style.getDateStyle();
        }
        if (dp instanceof DateTimeProp) {
            return style.getDatetimeStyle();
        }
        if (dp instanceof DecimalProp) {
            return style.getDecimalStyle(wb, null);
        }
        return style.getTextStyle();
    }

    private static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private static int calcColumnWidth(String caption) {
        return 256 * caption.getBytes(StandardCharsets.UTF_8).length;
    }

    private static SXSSFRow getRow(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String mainEntityId) throws IOException {
        ByteArrayOutputStream outputStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outputStream);
            outputStream.flush();
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            String fileName = "";
            switch (mainEntityId) {
                case "hsas_person": {
                    fileName = ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u5bfc\u5165_{0}{1}", (String)"ExportHelper_12", (String)"swc-hsas-business", (Object[])new Object[]{SWCDateTimeUtils.format((Date)new Date(), (String)"YYYYMM"), EXCEL_SUFFIX});
                    break;
                }
                case "hsas_salaryfile": {
                    fileName = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5bfc\u5165\u6a21\u677f_{0}{1}", (String)"ExportHelper_13", (String)"swc-hsas-business", (Object[])new Object[]{SWCDateTimeUtils.format((Date)new Date(), (String)"MMdd"), EXCEL_SUFFIX});
                    break;
                }
                default: {
                    fileName = "_" + mainEntityId + "_" + SWCDateTimeUtils.format((Date)new Date(), (String)"YYYYMM") + EXCEL_SUFFIX;
                }
            }
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inputStream, 10000);
            return string;
        }
        finally {
            if (null != outputStream) {
                outputStream.close();
            }
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    public static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ImportEntityRel importEntityRel) {
        SXSSFSheet dropDownHiddenSheet = wb.createSheet("dropdown_items_sheet");
        wb.setSheetHidden(wb.getSheetIndex("dropdown_items_sheet"), true);
        ExportSheetStyle style = new ExportSheetStyle(wb);
        ExportHelper.writeHeader(wb, sheet, style, importEntityRel);
        ExportHelper.writeEntityField(wb, sheet, dropDownHiddenSheet, style, importEntityRel);
        return sheet.getLastRowNum() + 1;
    }
}

