/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.IPersonImportPlugin;
import kd.swc.hsas.business.dataport.ImportRowInfo;
import kd.swc.hsas.business.dataport.PersonImportConfig;
import kd.swc.hsas.business.dataport.PersonImportFailedSheetHandler;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import kd.swc.hsas.business.dataport.PersonImportSheetHandler;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class PersonImportDataTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(PersonImportDataTask.class);
    private static final String IMPORT_NUMBER_FORMAT = "IMPORT_%s_%s";
    private RequestContext ctx;
    private PersonImportConfig conf;
    private String action;

    public PersonImportDataTask(RequestContext ctx, PersonImportConfig conf, String action) {
        this.ctx = ctx;
        this.conf = conf;
        this.action = action;
    }

    public static String getCacheKey(String mainEntityId, String pageId) {
        String cacheKey = String.format(IMPORT_NUMBER_FORMAT, mainEntityId, pageId);
        return cacheKey.substring(0, Math.min(cacheKey.length(), 50));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call() throws Exception {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            switch (this.action) {
                case "resolveExcel": {
                    log.info("{}\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u89e3\u6790\u6570\u636e\u3002\u3002\u3002", (Object)this.conf.getFormView().getPageId());
                    this.resolve(this.conf.getUrlLoggers());
                    log.info("{}\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u89e3\u6790\u6570\u636e\u3002\u3002\u3002\u7ed3\u675f", (Object)this.conf.getFormView().getPageId());
                    return null;
                }
                case "importData": {
                    log.info("{}\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u3002\u3002\u3002", (Object)this.conf.getFormView().getPageId());
                    this.importData();
                    log.info("{}\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u3002\u3002\u3002\u7ed3\u675f", (Object)this.conf.getFormView().getPageId());
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            PersonImportDataTask.removeImportCache(this.conf.getImportEntityRel().getMainEntity().getEntityId(), this.conf.getUrlLoggers().keySet());
            throw new RuntimeException(e);
        }
        finally {
            if (SWCStringUtils.equals((String)"importData", (String)this.action)) {
                PersonImportDataTask.removeImportCache(this.conf.getImportEntityRel().getMainEntity().getEntityId(), this.conf.getUrlLoggers().keySet());
            }
            RequestContext.set(null);
        }
    }

    private void resolve(Map<String, PersonImportLogger> urlLoggers) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        for (Map.Entry<String, PersonImportLogger> urlLogger : urlLoggers.entrySet()) {
            String path = urlLogger.getKey();
            log.info("{}----\u5bfc\u5165\u51c6\u5907\u4e0b\u8f7d\u6587\u4ef6----", (Object)this.conf.getFormView().getPageId());
            try {
                InputStream in = service.getInputStream(path);
                Throwable throwable = null;
                try {
                    excelReader.read(in, (SheetHandler)new PersonImportSheetHandler(this.conf, path, this.conf.getDataQueues().get(path)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof KDBizException) {
                    urlLogger.getValue().putRowError((Integer)0, cause.getMessage());
                } else {
                    urlLogger.getValue().putRowError((Integer)0, ImportLogger.formatException((Throwable)e));
                }
                log.error(e);
                this.conf.getDataQueues().get(path).add(new ImportBillData(new JSONObject(), 0, 0));
                this.conf.addCompleteUrl(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData() throws Exception {
        try {
            Map<String, LinkedBlockingQueue<ImportBillData>> dataQueueMap = this.conf.getDataQueues();
            for (Map.Entry<String, PersonImportLogger> urlloggers : this.conf.getUrlLoggers().entrySet()) {
                Map entityOpRel;
                LinkedBlockingQueue<ImportBillData> dataQueue = dataQueueMap.get(urlloggers.getKey());
                PersonImportLogger importLogger = urlloggers.getValue();
                LinkedBlockingQueue<ImportRowInfo> reimportDataQueue = new LinkedBlockingQueue<ImportRowInfo>(15000);
                ImportEntityRel importEntityRel = this.conf.getImportEntityRel();
                boolean isTimeOut = this.doImport(urlloggers, dataQueue, reimportDataQueue, importEntityRel, entityOpRel = importEntityRel.getEntityOpRel(), importLogger);
                if (isTimeOut) continue;
                this.doReimport(urlloggers, reimportDataQueue, importEntityRel, entityOpRel, importLogger);
            }
        }
        catch (Exception e) {
            log.error("importData error...", (Throwable)e);
        }
        finally {
            HashMap<String, Object> retdata = new HashMap<String, Object>(16);
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.conf.getUrlLoggers());
            PersonImportLogger totalImportLogger = new PersonImportLogger();
            for (Map.Entry<String, PersonImportLogger> urlLogger : this.conf.getUrlLoggers().entrySet()) {
                PersonImportLogger importLogger = urlLogger.getValue();
                int failQty = importLogger.getLogCache().size();
                importLogger.setFailed(failQty);
                totalImportLogger.setTotal(totalImportLogger.getTotal() + importLogger.getTotal());
                totalImportLogger.setSuccess(totalImportLogger.getSuccess() + importLogger.getSuccess());
                totalImportLogger.setFailed(totalImportLogger.getFailed() + failQty);
                totalImportLogger.setRowIndex(totalImportLogger.getRowIndex() + importLogger.getRowIndex());
                totalImportLogger.setLastRowIndex(totalImportLogger.getLastRowIndex() + importLogger.getLastRowIndex());
                if (failQty <= 0 && importLogger.getRowIndex() >= importLogger.getLastRowIndex() - 1) continue;
                this.outputFailedData(urlLogger);
            }
            this.resetErrorMsgIndex(retdata);
            ImportLogHelper.logAll((Object)this.conf.getLogId(), (String)JSON.toJSONString(retdata), (int)totalImportLogger.getTotal(), (int)totalImportLogger.getFailed());
            this.conf.feedbackProgress(100, totalImportLogger, null);
        }
    }

    private boolean doImport(Map.Entry<String, PersonImportLogger> urlloggers, LinkedBlockingQueue<ImportBillData> dataQueue, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue, ImportEntityRel importEntityRel, Map<String, String> entityOpRel, PersonImportLogger importLogger) throws InterruptedException {
        boolean isTimeOut = false;
        int timeout = 0;
        while (!this.conf.isComplete(urlloggers.getKey()) || !dataQueue.isEmpty()) {
            if (timeout > 5) {
                isTimeOut = true;
                break;
            }
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>(10);
            ImportBillData rowdata = dataQueue.poll(1L, TimeUnit.MINUTES);
            if (null == rowdata || rowdata.isEmpty()) {
                log.info("{}...read...null", (Object)this.conf.getFormView().getPageId());
                ++timeout;
                continue;
            }
            rowdatas.add(rowdata);
            dataQueue.drainTo(rowdatas, 5000);
            rowdatas = rowdatas.stream().filter(data -> !data.isEmpty()).collect(Collectors.toList());
            timeout = 0;
            List<ImportRowInfo> rowInfos = this.getImportRowInportantInfo(rowdatas, importLogger);
            this.assembleImportData(importEntityRel, rowInfos, importLogger);
            this.validateImportData(importEntityRel, entityOpRel, rowInfos, importLogger);
            this.fireImplementAPIEvent(rowInfos, importLogger);
            this.importData(importEntityRel, entityOpRel, rowInfos, reimportDataQueue, importLogger);
            this.syncFeedbackProgree(rowdatas, importLogger);
        }
        return isTimeOut;
    }

    private void doReimport(Map.Entry<String, PersonImportLogger> urlloggers, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue, ImportEntityRel importEntityRel, Map<String, String> entityOpRel, PersonImportLogger importLogger) throws InterruptedException {
        int timeout = 0;
        while (!(this.conf.isComplete(urlloggers.getKey()) && reimportDataQueue.isEmpty() || timeout > 5)) {
            List<ImportRowInfo> rowInfos = new ArrayList<ImportRowInfo>(10);
            ImportRowInfo rowInfo = reimportDataQueue.poll(1L, TimeUnit.MINUTES);
            if (null == rowInfo || rowInfo.isEmpty()) {
                if (null != rowInfo && rowInfo.isEmpty()) {
                    log.info("{}...read...null", (Object)this.conf.getFormView().getPageId());
                    ++timeout;
                    continue;
                }
            } else {
                rowInfos.add(rowInfo);
                reimportDataQueue.drainTo(rowInfos, 5000);
                rowInfos = rowInfos.stream().filter(data -> !data.isEmpty()).collect(Collectors.toList());
            }
            this.importData(importEntityRel, entityOpRel, rowInfos, reimportDataQueue, importLogger);
        }
    }

    private void resetErrorMsgIndex(Map<String, Object> retdata) {
        Map personImportLoggers = (Map)retdata.get("info");
        for (Map.Entry personImportLoggerEntry : personImportLoggers.entrySet()) {
            PersonImportLogger personImportLogger = (PersonImportLogger)personImportLoggerEntry.getValue();
            Map<Integer, List<ImportLogger.ImportLog>> importLogs = personImportLogger.getLogCache();
            HashMap<Integer, List<ImportLogger.ImportLog>> tempImpotLogs = new HashMap<Integer, List<ImportLogger.ImportLog>>(16);
            for (Map.Entry<Integer, List<ImportLogger.ImportLog>> importLogEntry : importLogs.entrySet()) {
                tempImpotLogs.put(importLogEntry.getKey() - 1, importLogEntry.getValue());
            }
            personImportLogger.setLogCache(tempImpotLogs);
        }
    }

    public static void removeImportCache(String entityId, Set<String> urls) {
        ISWCAppCache appCache = SWCAppCache.get((String)"hsasimport");
        String userId = RequestContext.get().getUserId();
        Set fileNames = (Set)appCache.get(userId, Set.class);
        for (String url : urls) {
            fileNames.remove(entityId + "_" + PersonImportHelper.getImportFileName(url));
        }
        if (!fileNames.isEmpty()) {
            appCache.put(userId, (Object)fileNames);
        } else {
            appCache.remove(userId);
        }
    }

    private void validateImportData(ImportEntityRel importEntityRel, Map<String, String> entityOpRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        block5: {
            try {
                Map<String, List<DynamicObject>> multiEntityDyobjRel = this.getQualifiedMultiEntityDyobjs(importEntityRel, rowInfos, importLogger);
                HashMap<String, OperationResult> operationResults = new HashMap<String, OperationResult>(16);
                if (this.isImportDataEmpty(importEntityRel, multiEntityDyobjRel)) break block5;
                for (Map.Entry<String, List<DynamicObject>> entrySet : multiEntityDyobjRel.entrySet()) {
                    String entityId = entrySet.getKey();
                    String opKey = entityOpRel.get(entityId);
                    DynamicObject[] multiEntityDyobjRelArray = (DynamicObject[])entrySet.getValue().stream().toArray(DynamicObject[]::new);
                    if (SWCStringUtils.isEmpty((String)opKey)) continue;
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ignoreinteraction", "true");
                    operateOption.setVariableValue("op", "validate");
                    operateOption.setVariableValue("import", "1");
                    operateOption.setVariableValue("ishasright", String.valueOf(true));
                    operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)entityId, (DynamicObject[])multiEntityDyobjRelArray, (OperateOption)operateOption);
                    operationResults.put(entityId, operationResult);
                }
                this.assembleErrorInfosDuringValidate(operationResults, importEntityRel, rowInfos, importLogger);
                operationResults.clear();
            }
            catch (Exception ex) {
                log.error("importData error...validateImportData...", (Throwable)ex);
                String msg = ex.getMessage();
                if (SWCStringUtils.isEmpty((String)msg)) {
                    msg = "Batch save error[validateImportData]";
                }
                for (ImportRowInfo rowInfo : rowInfos) {
                    importLogger.putRowError((Integer)rowInfo.getRowIndex(), msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(ImportEntityRel importEntityRel, Map<String, String> entityOpRel, List<ImportRowInfo> rowInfos, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue, PersonImportLogger importLogger) {
        Map<String, List<DynamicObject>> multiEntityDyobjRel = this.getQualifiedMultiEntityDyobjs(importEntityRel, rowInfos, importLogger);
        HashMap<String, OperationResult> operationResults = new HashMap<String, OperationResult>(16);
        if (!this.isImportDataEmpty(importEntityRel, multiEntityDyobjRel)) {
            TXHandle txHandle = TX.required();
            OperationResult localOperationResult = new OperationResult();
            try {
                this.localImportData(importEntityRel, multiEntityDyobjRel, operationResults, entityOpRel, localOperationResult, rowInfos, reimportDataQueue, importLogger);
            }
            catch (KDBizException e) {
                localOperationResult.setSuccess(false);
            }
            finally {
                if (!localOperationResult.isSuccess()) {
                    txHandle.markRollback();
                }
                txHandle.close();
            }
        }
    }

    public void localImportData(ImportEntityRel importEntityRel, Map<String, List<DynamicObject>> multiEntityDyobjRel, Map<String, OperationResult> operationResults, Map<String, String> entityOpRel, OperationResult localOperationResult, List<ImportRowInfo> rowInfos, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue, PersonImportLogger importLogger) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        for (Map.Entry<String, List<DynamicObject>> entrySet : multiEntityDyobjRel.entrySet()) {
            String entityId = entrySet.getKey();
            String opKey = entityOpRel.get(entityId);
            DynamicObject[] multiEntityDyobjRelArray = (DynamicObject[])entrySet.getValue().stream().toArray(DynamicObject[]::new);
            if (SWCStringUtils.isEmpty((String)opKey)) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("normalsave", "true");
            operateOption.setVariableValue("import", "1");
            OperationResult operationResult = opImpl.localInvokeOperation(opKey, multiEntityDyobjRelArray, operateOption);
            operationResults.put(entityId, operationResult);
        }
        boolean isSuccess = this.assembleErrorInfosDuringImport(operationResults, importEntityRel, rowInfos, importLogger);
        if (!isSuccess) {
            localOperationResult.setSuccess(false);
            this.putReimportDataIntoQueue(rowInfos, importLogger, reimportDataQueue);
        }
    }

    private void putReimportDataIntoQueue(List<ImportRowInfo> rowInfos, PersonImportLogger importLogger, LinkedBlockingQueue<ImportRowInfo> reimportDataQueue) {
        Set<Integer> errorRowIndexs = importLogger.getLogCache().keySet();
        try {
            for (ImportRowInfo rowInfo : rowInfos) {
                if (errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
                reimportDataQueue.put(rowInfo);
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u5bfc\u5165\u5f02\u5e38\u3002", (Throwable)e);
            this.throwBizException();
        }
    }

    private void throwBizException() {
        throw new KDBizException(ResManager.loadKDString((String)"\u91cd\u65b0\u5bfc\u5165\u5f02\u5e38\u3002", (String)"PersonImportDataTask_1", (String)"swc-hsas-business", (Object[])new Object[0]));
    }

    public boolean assembleErrorInfosDuringImport(Map<String, OperationResult> operationResults, ImportEntityRel importEntityRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        boolean isSuccess = true;
        Map<String, ImportRowInfo> rowInfosMap = this.transferRowInfosToMap(rowInfos);
        for (Map.Entry<String, OperationResult> entrySet : operationResults.entrySet()) {
            this.assembleImportErrorInfos(operationResults, importEntityRel, rowInfosMap, importLogger, entrySet, isSuccess);
        }
        return isSuccess;
    }

    private void assembleImportErrorInfos(Map<String, OperationResult> operationResults, ImportEntityRel importEntityRel, Map<String, ImportRowInfo> rowInfosMap, PersonImportLogger importLogger, Map.Entry<String, OperationResult> entrySet, boolean isSuccess) {
        HashMap<String, Set<String>> opErrorInfos = new HashMap<String, Set<String>>(16);
        String entityId = entrySet.getKey();
        OperationResult operationResult = entrySet.getValue();
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                String pkId = String.valueOf(operateInfo.getPkValue());
                if (!opErrorInfos.containsKey(pkId)) {
                    HashSet errorMsg = new HashSet();
                    opErrorInfos.put(pkId, errorMsg);
                }
                ((Set)opErrorInfos.get(pkId)).add(operateInfo.getMessage());
            }
            String cancelMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4e86\u64cd\u4f5c", (String)"PersonImportDataTask_12", (String)"swc-hsas-business", (Object[])new Object[0]);
            String validateMsg = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"EntityOperateService_11", (String)"bos-mservice-operation", (Object[])new Object[0]);
            String msg = operationResult.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)msg) && !msg.contains(cancelMsg) && !msg.contains(validateMsg)) {
                for (String id : rowInfosMap.keySet()) {
                    if (opErrorInfos.containsKey(id)) continue;
                    HashSet<String> errorMsg = new HashSet<String>();
                    errorMsg.add(msg);
                    opErrorInfos.put(id, errorMsg);
                }
            }
            this.assembleErrorRowInfoInRowInfo(entityId, opErrorInfos, rowInfosMap, importLogger);
        }
    }

    private void syncFeedbackProgree(List<ImportBillData> rowdatas, PersonImportLogger importLogger) {
        int lastEndIndex = rowdatas.get(rowdatas.size() - 1).getEndIndex();
        int lastRowIndex = importLogger.getLastRowIndex();
        if (0 != lastRowIndex) {
            int failQty = importLogger.getLogCache().size();
            importLogger.setFailed(failQty);
            int sucessQty = importLogger.getTotal() - failQty;
            importLogger.setSuccess(sucessQty < 0 ? 0 : sucessQty);
            this.conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / lastRowIndex), importLogger, null);
        }
        int failTotal = importLogger.getLogCache().size();
        log.info("----import importLogger.getSrcFile() --batch--succeed = {}--failed = {}", (Object)(importLogger.getTotal() - failTotal), (Object)failTotal);
    }

    public Map<String, List<DynamicObject>> getQualifiedMultiEntityDyobjs(ImportEntityRel importEntityRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        LinkedHashMap<String, List<DynamicObject>> multiEntityDyobjs = new LinkedHashMap<String, List<DynamicObject>>(16);
        List entityIds = importEntityRel.getMultiEntityIds();
        for (String entityId : entityIds) {
            multiEntityDyobjs.put(entityId, new ArrayList(10));
        }
        Set<Integer> errorRowIndexs = importLogger.getLogCache().keySet();
        for (ImportRowInfo rowInfo : rowInfos) {
            if (errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            for (String entityId : entityIds) {
                if (rowInfo.getEntityDyobj(entityId) == null) continue;
                ((List)multiEntityDyobjs.get(entityId)).add(rowInfo.getEntityDyobj(entityId));
            }
        }
        return multiEntityDyobjs;
    }

    public boolean isImportDataEmpty(ImportEntityRel importEntityRel, Map<String, List<DynamicObject>> multiEntityDyobjRel) {
        boolean isEmpty = true;
        String mainEntityId = importEntityRel.getMainEntity().getEntityId();
        List<DynamicObject> mainEntityDyobjs = multiEntityDyobjRel.get(mainEntityId);
        if (!mainEntityDyobjs.isEmpty()) {
            isEmpty = false;
        }
        return isEmpty;
    }

    private void assembleErrorInfosDuringValidate(Map<String, OperationResult> operationResults, ImportEntityRel importEntityRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        Map<String, ImportRowInfo> rowInfosMap = this.transferRowInfosToMap(rowInfos);
        for (Map.Entry<String, OperationResult> entrySet : operationResults.entrySet()) {
            this.assembleValidateErrorInfos(rowInfosMap, importLogger, entrySet);
        }
    }

    private Map<String, ImportRowInfo> transferRowInfosToMap(List<ImportRowInfo> rowInfos) {
        HashMap<String, ImportRowInfo> rowInfosMap = new HashMap<String, ImportRowInfo>();
        for (ImportRowInfo rowInfo : rowInfos) {
            Map<String, DynamicObject> dyobjs = rowInfo.getDyobjs();
            for (DynamicObject dyobj : dyobjs.values()) {
                rowInfosMap.put(dyobj.getString("id"), rowInfo);
            }
        }
        return rowInfosMap;
    }

    private void assembleValidateErrorInfos(Map<String, ImportRowInfo> rowInfosMap, PersonImportLogger importLogger, Map.Entry<String, OperationResult> entrySet) {
        OperationResult operationResult = entrySet.getValue();
        HashMap<String, Set<String>> opErrorInfos = new HashMap<String, Set<String>>(16);
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                String pkId = String.valueOf(operateInfo.getPkValue());
                if (!opErrorInfos.containsKey(pkId)) {
                    HashSet errorMsg = new HashSet();
                    opErrorInfos.put(pkId, errorMsg);
                }
                ((Set)opErrorInfos.get(pkId)).add(operateInfo.getMessage());
            }
            String cancelMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4e86\u64cd\u4f5c", (String)"PersonImportDataTask_12", (String)"swc-hsas-business", (Object[])new Object[0]);
            String validateMsg = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"EntityOperateService_11", (String)"bos-mservice-operation", (Object[])new Object[0]);
            String msg = operationResult.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)msg) && !msg.contains(cancelMsg) && !msg.contains(validateMsg)) {
                for (String id : rowInfosMap.keySet()) {
                    if (opErrorInfos.containsKey(id)) continue;
                    HashSet<String> errorMsg = new HashSet<String>();
                    errorMsg.add(msg);
                    opErrorInfos.put(id, errorMsg);
                }
            }
        }
        this.assembleErrorRowInfoInRowInfo(entrySet.getKey(), opErrorInfos, rowInfosMap, importLogger);
    }

    private void assembleErrorRowInfoInRowInfo(String entityId, Map<String, Set<String>> opErrorInfos, Map<String, ImportRowInfo> rowInfosMap, PersonImportLogger importLogger) {
        for (Map.Entry<String, Set<String>> entrySet : opErrorInfos.entrySet()) {
            ImportRowInfo rowInfo = rowInfosMap.get(entrySet.getKey());
            if (rowInfo == null) continue;
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), entrySet.getValue());
        }
    }

    private void assembleImportData(ImportEntityRel importEntityRel, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        List entityIds = importEntityRel.getMultiEntityIds();
        HashMap<String, Map<String, Set<String>>> basedataValMap = new HashMap<String, Map<String, Set<String>>>(16);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        this.fireBeforeGenDyobjDataEvent(data, rowInfos);
        for (ImportRowInfo rowInfo : rowInfos) {
            for (String entityId : entityIds) {
                this.genDynamicObject(entityId, rowInfo, importLogger, basedataValMap);
            }
            this.fillImportDataRelPkId(importEntityRel, rowInfo);
            this.fireAssembleDataEvent(rowInfo, importLogger, data);
        }
        Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = this.getBasedataRel(basedataValMap);
        HashMap<String, Object> fillData = new HashMap<String, Object>(16);
        this.fireBeforeFillBasedataEvent(fillData, basedataValRels);
        this.fillBasedataIntoMultiEntityDyobjRel(importEntityRel, basedataValRels, rowInfos, importLogger, fillData);
        this.fireAfterAssembleDataEvent(rowInfos, fillData, importLogger, data);
    }

    private void fillBasedataIntoMultiEntityDyobjRel(ImportEntityRel importEntityRel, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, List<ImportRowInfo> rowInfos, PersonImportLogger importLogger, Map<String, Object> fillData) {
        List entityIds = importEntityRel.getMultiEntityIds();
        for (ImportRowInfo rowInfo : rowInfos) {
            for (String entityId : entityIds) {
                this.fillBasedataInEntityDyobj(importEntityRel, entityId, basedataValRels, rowInfo, importLogger, fillData);
            }
        }
    }

    private void fillBasedataInEntityDyobj(ImportEntityRel importEntityRel, String entityId, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, ImportRowInfo rowInfo, PersonImportLogger importLogger, Map<String, Object> fillData) {
        int rowIndex = rowInfo.getRowIndex();
        JSONObject rowData = rowInfo.getData();
        DynamicObject dyobj = rowInfo.getEntityDyobj(entityId);
        if (null != dyobj) {
            DynamicObjectType dyobjType = dyobj.getDynamicObjectType();
            JSONObject entityDataJSON = rowData.getJSONObject(entityId);
            ArrayList<String> fieldList = new ArrayList<String>(entityDataJSON.size());
            fieldList.addAll(entityDataJSON.keySet());
            fieldList.remove("employee");
            fieldList.add(0, "employee");
            for (String fieldId : fieldList) {
                DynamicProperty basedataDP = dyobjType.getProperty(fieldId);
                if (!(basedataDP instanceof BasedataProp) || dyobj.get(fieldId) instanceof DynamicObject) continue;
                this.fillBasedata(entityDataJSON, fieldId, basedataDP, basedataValRels, dyobj, fillData, rowIndex, importLogger);
            }
        }
    }

    private void fillBasedata(JSONObject entityDataJSON, String fieldId, DynamicProperty basedataDP, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, DynamicObject dyobj, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        JSONObject basedataJSON = entityDataJSON.getJSONObject(fieldId);
        String importKey = basedataJSON.getString("importprop");
        BasedataProp basedataProp = (BasedataProp)basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals && !importPropVals.isEmpty()) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importKey);
            if (null != basedataValsMap && !basedataValsMap.isEmpty()) {
                this.fillBasedataIfValExist(fieldId, basedataDP, basedataValsMap, basedataJSON, importKey, dyobj, fillData, rowIndex, importLogger);
            } else if (null != dyobj.get(fieldId)) {
                importLogger.putRowError((Integer)rowIndex, this.getBasedNoMatchMsg(basedataDP, importKey, dyobj, fieldId));
                dyobj.set(fieldId, null);
            }
        } else {
            if (basedataProp.isMustInput()) {
                importLogger.putRowError((Integer)rowIndex, this.getBasedNoMatchMsg(basedataDP, importKey, dyobj, fieldId));
            }
            dyobj.set(fieldId, null);
        }
    }

    private void fillBasedataIfValExist(String fieldId, DynamicProperty basedataDP, Map<String, List<DynamicObject>> basedataValsMap, JSONObject basedataJSON, String importKey, DynamicObject dyobj, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        List<DynamicObject> basedataDyobjs = basedataValsMap.get(basedataJSON.get((Object)importKey));
        boolean isBreak = this.fireFillSpecificBasedataBasedOnRelEvent(basedataDP, dyobj, basedataDyobjs, fillData, rowIndex, importLogger);
        if (!isBreak) {
            if (null == basedataDyobjs) {
                importLogger.putRowError((Integer)rowIndex, this.getBasedNoMatchMsg(basedataDP, importKey, dyobj, fieldId));
                dyobj.set(fieldId, null);
            } else if (basedataDyobjs.size() != 1) {
                importLogger.putRowError((Integer)rowIndex, this.getDuplicateDataErrorMsg(basedataDP, importKey, basedataDyobjs));
                dyobj.set(fieldId, null);
            } else {
                this.executeSpecialUseStatusEvent(fieldId, basedataDP, basedataDyobjs, basedataJSON, importKey, dyobj, fillData, rowIndex, importLogger);
            }
        }
    }

    private void executeSpecialUseStatusEvent(String fieldId, DynamicProperty basedataDP, List<DynamicObject> basedataDyobjs, JSONObject basedataJSON, String importKey, DynamicObject dyobj, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        boolean isBreak = this.fireFillBasedataWithSpecialUseStatusEvent(basedataDP, dyobj, basedataDyobjs.get(0), rowIndex, importLogger);
        if (!isBreak) {
            DynamicObject basedata = basedataDyobjs.get(0);
            if (this.isUseStatusQualified(basedata)) {
                dyobj.set(fieldId, (Object)basedata);
            } else {
                importLogger.putRowError((Integer)rowIndex, this.getBasedataStatusUnqualifiedMsg(basedataDP, importKey, dyobj, fieldId));
            }
        }
    }

    protected boolean isUseStatusQualified(DynamicObject basedata) {
        boolean isQualified = true;
        if (!SWCStringUtils.equals((String)basedata.getString("status"), (String)"C") || !SWCStringUtils.equals((String)basedata.getString("enable"), (String)"1")) {
            isQualified = false;
        }
        return isQualified;
    }

    private String getBasedNoMatchMsg(DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a{1}\u201c{2}\u201d\u3002", (String)"PersonImportDataTask_11", (String)"swc-hsas-business", (Object[])new Object[]{dp.getDisplayName(), this.getImportPropDisName(importProp), dyobj.getString(fieldId)});
    }

    private String getBasedataStatusUnqualifiedMsg(DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(%s)\u6570\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u53ef\u7528\u201d\u3002", (String)"PersonImportDataTask_10", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName());
    }

    private String getDuplicateDataErrorMsg(DynamicProperty dp, String importProp, List<DynamicObject> basedataDyObjs) {
        return ResManager.loadKDString((String)"{0}\uff1a\u503c\u201c{1}\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\u3002", (String)"PersonImportDataTask_4", (String)"swc-hsas-business", (Object[])new Object[]{dp.getDisplayName(), basedataDyObjs.get(0).getString(importProp)});
    }

    private String getImportPropDisName(String importProp) {
        if (SWCStringUtils.equals((String)importProp, (String)"number") || SWCStringUtils.equals((String)importProp, (String)"empnumber")) {
            return ResManager.loadKDString((String)"\u7f16\u7801", (String)"PersonImportDataTask_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        if (SWCStringUtils.equals((String)importProp, (String)"name")) {
            return ResManager.loadKDString((String)"\u540d\u79f0", (String)"PersonImportDataTask_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return "";
    }

    private Map<String, Map<String, Map<String, List<DynamicObject>>>> getBasedataRel(Map<String, Map<String, Set<String>>> basedataValMap) {
        log.info("getBasedataRel...{}", (Object)JSONObject.toJSONString(basedataValMap));
        HashMap<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = new HashMap<String, Map<String, Map<String, List<DynamicObject>>>>(16);
        for (Map.Entry<String, Map<String, Set<String>>> entrySet : basedataValMap.entrySet()) {
            Map<String, Set<String>> importDataMap = entrySet.getValue();
            if (null == importDataMap) continue;
            for (Map.Entry<String, Set<String>> importEntrySet : importDataMap.entrySet()) {
                this.assembleBaseDataRel(importEntrySet, entrySet, basedataValRels);
            }
        }
        return basedataValRels;
    }

    private void assembleBaseDataRel(Map.Entry<String, Set<String>> importEntrySet, Map.Entry<String, Map<String, Set<String>>> entrySet, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        String importKey = importEntrySet.getKey();
        String basedataEntityId = entrySet.getKey();
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(basedataEntityId);
        QFilter qFilter = new QFilter(importKey, "in", importEntrySet.getValue());
        Set<String> selectProps = this.getDefSelectProps();
        this.fireSetDataBaseSelectPropEvent(basedataEntityId, selectProps);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)basedataEntityId);
        List allFields = SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType);
        if (allFields.contains("iscurrentversion")) {
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        }
        if (allFields.contains("datastatus")) {
            qFilter.and("datastatus", "!=", (Object)"-1");
        }
        DynamicObject[] dyobjs = serviceHelper.query(String.join((CharSequence)",", selectProps), new QFilter[]{qFilter});
        HashMap<String, List<DynamicObject>> basedataRel = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject dyobj : dyobjs) {
            this.putBaseDataRel(basedataRel, dyobj, importKey);
        }
        HashMap<String, HashMap<String, List<DynamicObject>>> importPropVals = new HashMap<String, HashMap<String, List<DynamicObject>>>(16);
        importPropVals.put(importKey, basedataRel);
        basedataValRels.put(basedataEntityId, importPropVals);
    }

    private void putBaseDataRel(Map<String, List<DynamicObject>> basedataRel, DynamicObject dbDyobj, String importKey) {
        List<DynamicObject> existDyobjs = basedataRel.get(dbDyobj.getString(importKey));
        if (null != existDyobjs) {
            existDyobjs.add(dbDyobj);
        } else {
            existDyobjs = new ArrayList<DynamicObject>(10);
            existDyobjs.add(dbDyobj);
            basedataRel.put(dbDyobj.getString(importKey), existDyobjs);
        }
    }

    private Set<String> getDefSelectProps() {
        HashSet<String> defSelectProps = new HashSet<String>(16);
        String def = "id, name, number, status, enable";
        for (String str : def.split(",")) {
            defSelectProps.add(str.trim());
        }
        return defSelectProps;
    }

    private void fillImportDataRelPkId(ImportEntityRel importEntityRel, ImportRowInfo rowInfo) {
        Map<String, DynamicObject> multiEntityDyobjData = rowInfo.getDyobjs();
        List otherEntities = importEntityRel.getOtherEntities();
        for (ImportEntity otherEntity : otherEntities) {
            String entityId = otherEntity.getEntityId();
            String parentEntityId = otherEntity.getParentEntityId();
            DynamicObject dyobj = multiEntityDyobjData.get(entityId);
            if (null == dyobj) continue;
            if (entityId.equals("hsas_taxfiletmp")) {
                dyobj.set(otherEntity.getParentFieldId(), (Object)multiEntityDyobjData.get(parentEntityId));
                continue;
            }
            dyobj.set(otherEntity.getParentFieldId(), (Object)PersonHelper.genDyobjById(parentEntityId, multiEntityDyobjData.get(parentEntityId).getLong("id")));
        }
    }

    private void genDynamicObject(String entityId, ImportRowInfo rowInfo, PersonImportLogger importLogger, Map<String, Map<String, Set<String>>> basedataValMap) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        DynamicObject dyobj = serviceHelper.generateEmptyDynamicObject();
        JSONObject importJSONData = rowInfo.getData().getJSONObject(entityId);
        if (null != importJSONData) {
            Map allFields = mainEntityType.getAllFields();
            allFields.forEach((fieldKey, dp) -> this.fillDyobjValue((String)fieldKey, importJSONData, dyobj, importLogger, rowInfo.getRowIndex(), (IDataEntityProperty)dp, basedataValMap));
            Long pkId = ORM.create().genLongId(entityId);
            dyobj.set("id", (Object)pkId);
            rowInfo.putEntityDyobj(entityId, dyobj);
        }
    }

    private void fillDyobjValue(String fieldKey, JSONObject importJSONData, DynamicObject dyobj, PersonImportLogger importLogger, int rowIndex, IDataEntityProperty dp, Map<String, Map<String, Set<String>>> basedataValMap) {
        String fieldValue = importJSONData.getString(fieldKey);
        if (!SWCStringUtils.isEmpty((String)fieldValue)) {
            this.setValueIfValExist(fieldKey, fieldValue, importJSONData, dyobj, importLogger, rowIndex, dp, basedataValMap);
        } else {
            this.setValueIfValNotExist(fieldKey, dyobj, dp);
        }
    }

    private void setValueIfValNotExist(String fieldKey, DynamicObject dyobj, IDataEntityProperty dp) {
        if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
            dyobj.set(fieldKey, (Object)new Date());
        } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
            dyobj.set(fieldKey, (Object)RequestContext.get().getUserId());
        } else if (dp instanceof FieldProp) {
            dyobj.set(fieldKey, ((FieldProp)dp).getDefValue());
        }
    }

    private void setValueIfValExist(String fieldKey, String fieldValue, JSONObject importJSONData, DynamicObject dyobj, PersonImportLogger importLogger, int rowIndex, IDataEntityProperty dp, Map<String, Map<String, Set<String>>> basedataValMap) {
        if (dp instanceof TextProp || dp instanceof LargeTextProp) {
            dyobj.set(fieldKey, (Object)fieldValue);
        } else if (dp instanceof VarcharProp || dp instanceof MuliLangTextProp || dp instanceof ComboProp) {
            dyobj.set(fieldKey, (Object)fieldValue);
        } else if (dp instanceof DecimalProp) {
            dyobj.set(fieldKey, (Object)new BigDecimal(fieldValue));
        } else if (dp instanceof DateProp) {
            this.putDatePropData(fieldKey, fieldValue, dyobj, rowIndex, importLogger, dp);
        } else if (dp instanceof DateTimeProp) {
            this.putDateTimePropData(fieldKey, fieldValue, dyobj, rowIndex, importLogger, dp);
        } else if (dp instanceof BooleanProp) {
            if (SWCStringUtils.equals((String)fieldValue, (String)"true")) {
                dyobj.set(fieldKey, (Object)Boolean.TRUE);
            } else {
                dyobj.set(fieldKey, (Object)Boolean.FALSE);
            }
        } else if (dp instanceof BasedataProp) {
            this.putBasedataPropData(fieldKey, dyobj, dp, basedataValMap, importJSONData);
        } else {
            dyobj.set(fieldKey, (Object)fieldValue);
        }
    }

    private void putDatePropData(String fieldKey, String fieldValue, DynamicObject dyobj, int rowIndex, PersonImportLogger importLogger, IDataEntityProperty dp) {
        try {
            dyobj.set(fieldKey, (Object)SWCDateTimeUtils.parseDate((String)fieldValue, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002", (Throwable)e);
            importLogger.putRowError((Integer)rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002", (String)"PersonImportDataTask_7", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName()));
        }
    }

    private void putDateTimePropData(String fieldKey, String fieldValue, DynamicObject dyobj, int rowIndex, PersonImportLogger importLogger, IDataEntityProperty dp) {
        try {
            dyobj.set(fieldKey, (Object)SWCDateTimeUtils.parseDate((String)fieldValue));
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002", (Throwable)e);
            importLogger.putRowError((Integer)rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u65e5\u671f\u8f6c\u6362\u9519\u8bef\u3002", (String)"PersonImportDataTask_7", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName()));
        }
    }

    private void putBasedataPropData(String fieldKey, DynamicObject dyobj, IDataEntityProperty dp, Map<String, Map<String, Set<String>>> basedataValSum, JSONObject JSONObj) {
        Set<String> importProps;
        JSONObject basedataJson = JSONObj.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        String basedataEntityId = ((BasedataProp)dp).getBaseEntityId();
        Map<String, Set<String>> importPropVals = basedataValSum.get(basedataEntityId);
        if (null == importPropVals) {
            importPropVals = new HashMap<String, Set<String>>(16);
            basedataValSum.put(basedataEntityId, importPropVals);
        }
        if (null == (importProps = importPropVals.get(importProp))) {
            importProps = new HashSet<String>(16);
            importPropVals.put(importProp, importProps);
        }
        importProps.add(basedataVal);
        dyobj.set(fieldKey, (Object)basedataVal);
    }

    private List<ImportRowInfo> getImportRowInportantInfo(List<ImportBillData> rowdatas, PersonImportLogger importLogger) {
        ArrayList<ImportRowInfo> rowInfos = new ArrayList<ImportRowInfo>(10);
        Set<Integer> errorRowIndexs = importLogger.getLogCache().keySet();
        for (ImportBillData rowdata : rowdatas) {
            ImportRowInfo rowInfo = new ImportRowInfo(rowdata.getStartIndex() + 1, rowdata.getData());
            importLogger.tick();
            if (errorRowIndexs.contains(rowInfo.getRowIndex())) continue;
            rowInfos.add(rowInfo);
        }
        return rowInfos;
    }

    private void outputFailedData(Map.Entry<String, PersonImportLogger> urlLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            log.info("{}\u3002\u3002\u3002\u5bfc\u5165\u51c6\u5907\u751f\u6210\u9519\u8bef\u6570\u636e\u6587\u4ef6------", (Object)this.conf.getFormView().getPageId());
            new ExcelReader().read(service.getInputStream(urlLogger.getKey()), (SheetHandler)new PersonImportFailedSheetHandler(this.conf, urlLogger.getValue(), service));
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    private void fireBeforeGenDyobjDataEvent(Map<String, Object> data, List<ImportRowInfo> rowInfos) {
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            Map<String, Object> returnMap = plugin.beforeGenDyobjData(rowInfos);
            if (null == returnMap) continue;
            data.putAll(returnMap);
        }
    }

    private boolean fireAssembleDataEvent(ImportRowInfo rowInfo, PersonImportLogger importLogger, Map<String, Object> data) {
        boolean pluginBreak = false;
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            pluginBreak = plugin.assembleMultiEntityRel(data, rowInfo.getDyobjs());
            if (!pluginBreak) continue;
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6{0}\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"PersonImportDataTask_8", (String)"swc-hsas-business", (Object[])new Object[0]), plugin.getClass().getName()));
            break;
        }
        return pluginBreak;
    }

    private void fireBeforeFillBasedataEvent(Map<String, Object> fillData, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            Map<String, Object> returnMap = plugin.beforeFillBasedata(basedataValRels);
            if (null == returnMap) continue;
            fillData.putAll(returnMap);
        }
    }

    private boolean fireFillSpecificBasedataBasedOnRelEvent(DynamicProperty dp, DynamicObject dyobj, List<DynamicObject> basedataDyObjs, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        IPersonImportPlugin plugin;
        boolean isBreak = false;
        Iterator<IPersonImportPlugin> iterator = this.conf.getImportPlugins().iterator();
        while (iterator.hasNext() && !(isBreak = (plugin = iterator.next()).fillSpecificBasedataBasedOnRel(dp, dyobj, basedataDyObjs, fillData, rowIndex, importLogger))) {
        }
        return isBreak;
    }

    private boolean fireFillBasedataWithSpecialUseStatusEvent(DynamicProperty dp, DynamicObject dyobj, DynamicObject basedataDyObj, int rowIndex, PersonImportLogger importLogger) {
        boolean isBreak = false;
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            isBreak = plugin.fillBasedataWithSpecialUseStatus(dp, dyobj, basedataDyObj, rowIndex, importLogger);
        }
        return isBreak;
    }

    private void fireAfterAssembleDataEvent(List<ImportRowInfo> rowInfos, Map<String, Object> fillData, PersonImportLogger importLogger, Map<String, Object> data) {
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            plugin.afterAssembleData(data, fillData, importLogger, rowInfos);
        }
    }

    private void fireSetDataBaseSelectPropEvent(String entityId, Set<String> selectProps) {
        log.info("fireSetDataBaseSelectPropEvent...begin");
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            log.info("fireSetDataBaseSelectPropEvent...getName...", (Object)plugin.getClass().getName());
            plugin.setDataBaseSelectProp(entityId, selectProps);
        }
        log.info("fireSetDataBaseSelectPropEvent...end");
    }

    private void fireImplementAPIEvent(List<ImportRowInfo> rowInfos, PersonImportLogger importLogger) {
        for (IPersonImportPlugin plugin : this.conf.getImportPlugins()) {
            plugin.implementAPI(rowInfos, importLogger);
        }
    }
}

