/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hsas.common.entity.ImportEntityRel;
import kd.swc.hsas.business.dataport.salaryfile.TaxFileServiceHelper;

public class PersonImportEntityMapping {
    private Set<String> TRUE = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"PersonImportEntityMapping_0", (String)"swc-hsas-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"PersonImportEntityMapping_1", (String)"swc-hsas-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"PersonImportEntityMapping_2", (String)"swc-hsas-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"PersonImportEntityMapping_3", (String)"swc-hsas-business", (Object[])new Object[0]), "true", "yes", "ok"));
    private Map<String, DynamicObjectType> multiEntityDyobjType;
    private Map<String, Map<String, List<ColInfo>>> colInfoMaps = new LinkedHashMap<String, Map<String, List<ColInfo>>>(16);
    private Map<String, Map<String, String>> onOffMaps = new HashMap<String, Map<String, String>>(16);
    private static final Integer ENTITY_INDEX = 0;
    private static final Integer FIELD_KEY_INDEX = 1;
    private static final Integer PROP_INDEX = 2;
    private static final String POUND_SIGN = " # ";

    public static PersonImportEntityMapping create(ImportEntityRel importEntityRel, Map<Integer, String> rowData) {
        PersonImportEntityMapping mapping = new PersonImportEntityMapping();
        mapping.multiEntityDyobjType = importEntityRel.getMultiEntityDyobjType();
        for (Map.Entry<String, DynamicObjectType> entry : mapping.multiEntityDyobjType.entrySet()) {
            TaxFileServiceHelper.setComboItem(entry.getKey(), (MainEntityType)entry.getValue());
        }
        mapping.setColInfoMapKey();
        mapping.onOffMaps = importEntityRel.getOnOffMaps();
        for (Map.Entry<Object, Object> entry : rowData.entrySet()) {
            Integer columnIndex = (Integer)entry.getKey();
            String fullName = (String)entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)fullName) || !fullName.contains(POUND_SIGN)) continue;
            String[] propertyName = fullName.split(POUND_SIGN);
            String[] propNameSplit = propertyName[FIELD_KEY_INDEX].split("\\.");
            PersonImportEntityMapping.putColInfo(mapping, propNameSplit, columnIndex, fullName);
        }
        return mapping;
    }

    private static void putColInfo(PersonImportEntityMapping mapping, String[] propNameSplit, Integer columnIndex, String fullName) {
        int fieldLength = propNameSplit.length;
        String entityId = propNameSplit[ENTITY_INDEX].trim();
        DynamicObjectType dyobjType = mapping.multiEntityDyobjType.get(entityId);
        Map<String, List<ColInfo>> colInfoMap = mapping.colInfoMaps.get(entityId);
        if (colInfoMap != null) {
            if (fieldLength > 2) {
                ColInfo colInfo = PersonImportEntityMapping.getBaseDataColInfo(columnIndex, fullName.startsWith("*"), dyobjType, propNameSplit);
                if (colInfo == null || colInfo.getProperty() == null) {
                    return;
                }
                String fieldId = colInfo.getProperty().getName();
                List<ColInfo> colInfos = colInfoMap.get(fieldId);
                if (null != colInfos && !colInfos.isEmpty()) {
                    colInfos.add(colInfo);
                } else {
                    colInfos = new ArrayList<ColInfo>(10);
                    colInfos.add(colInfo);
                    colInfoMap.put(fieldId, colInfos);
                }
            } else {
                String fieldId = propNameSplit[FIELD_KEY_INDEX];
                colInfoMap.put(fieldId, Collections.singletonList(new ColInfo(columnIndex, fullName.startsWith("*"), (IDataEntityProperty)dyobjType.getProperty(fieldId))));
            }
        }
    }

    private static ColInfo getBaseDataColInfo(Integer index, boolean mustInput, DynamicObjectType dyobjType, String[] propNameSplit) {
        ColInfo colInfo = new ColInfo();
        colInfo.setIndex(index);
        colInfo.setMustInput(mustInput);
        int length = propNameSplit.length;
        if (3 == length) {
            colInfo.setProperty((IDataEntityProperty)dyobjType.getProperty(propNameSplit[FIELD_KEY_INDEX].trim()));
            colInfo.setBasedataId(propNameSplit[PROP_INDEX].trim());
        }
        return colInfo;
    }

    private void setColInfoMapKey() {
        for (String entityId : this.multiEntityDyobjType.keySet()) {
            this.colInfoMaps.put(entityId, new LinkedHashMap(16));
        }
    }

    public Set<String> pushData(Map<Integer, String> rowData, JSONObject JSONData, String mainEntityId) throws KDBizException {
        HashSet<String> logs = new HashSet<String>();
        LinkedList isNeedInputEmptyList = Lists.newLinkedList();
        for (Map.Entry<String, Map<String, List<ColInfo>>> entrySet : this.colInfoMaps.entrySet()) {
            String entityId = entrySet.getKey();
            if (!this.validIsOn(entityId, JSONData)) continue;
            JSONObject entityJson = new JSONObject();
            isNeedInputEmptyList.addAll(this.pushFieldDatas(entrySet.getValue(), rowData, entityJson, logs));
            if (JSONData.containsKey((Object)entityId)) continue;
            JSONData.put(entityId, (Object)entityJson);
        }
        if (!JSONData.getJSONObject(mainEntityId).isEmpty() && !CollectionUtils.isEmpty((Collection)isNeedInputEmptyList)) {
            StringBuilder message = new StringBuilder();
            for (ColInfo colInfo : isNeedInputEmptyList) {
                String localeValue = colInfo.getProperty().getDisplayName().getLocaleValue();
                message.append(localeValue).append(ResManager.loadKDString((String)"\u3001", (String)"PersonImportEntityMapping_8", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            logs.add(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a{0}\u3002", (String)"PersonImportEntityMapping_4", (String)"swc-hsas-business", (Object[])new Object[]{message.substring(0, message.length() - 1)}));
        }
        return logs;
    }

    private boolean validIsOn(String entityId, JSONObject jSONData) {
        Map<String, String> onOffInfo = this.onOffMaps.get(entityId);
        if (onOffInfo != null) {
            String parentEntityId = onOffInfo.get(entityId);
            String parentOnOffField = onOffInfo.get(parentEntityId);
            JSONObject parentObject = jSONData.getJSONObject(parentEntityId);
            if (parentObject.isEmpty()) {
                return false;
            }
            String onOffField = parentObject.getString(parentOnOffField);
            if (StringUtils.isEmpty((CharSequence)onOffField)) {
                return false;
            }
            if (!this.TRUE.contains(onOffField)) {
                return false;
            }
        }
        return true;
    }

    private List<ColInfo> pushFieldDatas(Map<String, List<ColInfo>> colInfoMap, Map<Integer, String> rowData, JSONObject entityJson, Set<String> logs) {
        LinkedList isNeedInputEmptyList = Lists.newLinkedList();
        for (Map.Entry<String, List<ColInfo>> colInfoEntrySet : colInfoMap.entrySet()) {
            for (ColInfo colInfo : colInfoEntrySet.getValue()) {
                String val = rowData.get(colInfo.getIndex());
                if (StringUtils.isNotBlank((Object)val)) {
                    this.pushFieldData(colInfoEntrySet.getKey(), entityJson, val, colInfo, logs);
                    continue;
                }
                if (!colInfo.isMustInput()) continue;
                isNeedInputEmptyList.add(colInfo);
            }
        }
        return isNeedInputEmptyList;
    }

    private void pushFieldData(String fieldId, JSONObject JSONdata, Object val, ColInfo colInfo, Set<String> logs) {
        IDataEntityProperty dataEntityProp = colInfo.getProperty();
        if (dataEntityProp instanceof BasedataProp || dataEntityProp instanceof MulBasedataProp) {
            this.resolveeBaseData(fieldId, JSONdata, val, colInfo);
        } else if (dataEntityProp instanceof DecimalProp) {
            this.resolveBigDecimal(fieldId, JSONdata, val, dataEntityProp, logs);
        } else if (dataEntityProp instanceof AdminDivisionProp) {
            this.resolveAdminDivision(fieldId, JSONdata, val, logs);
        } else if (dataEntityProp instanceof BooleanProp) {
            val = this.TRUE.contains(((String)val).toLowerCase());
            if (!JSONdata.containsKey((Object)fieldId)) {
                JSONdata.put(fieldId, val);
            }
        } else if (dataEntityProp instanceof ComboProp) {
            this.resolveCombo(fieldId, JSONdata, val, dataEntityProp, logs);
        } else if (!JSONdata.containsKey((Object)fieldId)) {
            JSONdata.put(fieldId, val);
        }
    }

    private void resolveeBaseData(String fieldId, JSONObject JSONdata, Object val, ColInfo colInfo) {
        JSONObject basedataJson = JSONdata.getJSONObject(fieldId);
        if (null != basedataJson) {
            basedataJson.put(colInfo.getBasedataId(), val);
        } else {
            basedataJson = new JSONObject();
            basedataJson.put("importprop", (Object)colInfo.getBasedataId());
            basedataJson.put(colInfo.getBasedataId(), val);
            JSONdata.put(fieldId, (Object)basedataJson);
        }
    }

    private void resolveBigDecimal(String fieldId, JSONObject JSONdata, Object val, IDataEntityProperty dataEntityProp, Set<String> logs) {
        try {
            val = new BigDecimal((String)val);
            if (!JSONdata.containsKey((Object)fieldId)) {
                JSONdata.put(fieldId, val);
            }
        }
        catch (NumberFormatException e) {
            logs.add(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5 {0} \u683c\u5f0f\u5f02\u5e38\uff1a{1}", (String)"PersonImportEntityMapping_5", (String)"swc-hsas-business", (Object[])new Object[]{dataEntityProp.getDisplayName(), val}));
        }
    }

    private void resolveAdminDivision(String fieldId, JSONObject JSONdata, Object val, Set<String> logs) {
        if (((String)val).contains("/")) {
            Object adminId = ORMUtil.getAdminDivisionByName((String)((String)val).replace('/', '_'));
            if (StringUtils.isNotBlank((Object)adminId)) {
                val = adminId;
                if (!JSONdata.containsKey((Object)fieldId)) {
                    JSONdata.put(fieldId, val);
                }
            } else {
                logs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PersonImportEntityMapping_7", (String)"swc-hsas-business", (Object[])new Object[0]), val));
            }
        } else {
            logs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PersonImportEntityMapping_7", (String)"swc-hsas-business", (Object[])new Object[0]), val));
        }
    }

    private void resolveCombo(String fieldId, JSONObject JSONdata, Object val, IDataEntityProperty dataEntityProp, Set<String> logs) {
        List items = ((ComboProp)dataEntityProp).getComboItems();
        if (items != null && !items.isEmpty()) {
            ArrayList<String> values = new ArrayList<String>(10);
            this.assembleComboVal(val, dataEntityProp, items, values, logs);
            val = String.join((CharSequence)",", values);
            if (!JSONdata.containsKey((Object)fieldId)) {
                JSONdata.put(fieldId, val);
            }
        }
    }

    private void assembleComboVal(Object val, IDataEntityProperty dataEntityProp, List<ValueMapItem> items, List<String> values, Set<String> logs) {
        List<String> cellValueSplit = Arrays.asList(((String)val).split(","));
        boolean isMulCombo = dataEntityProp instanceof MulComboProp;
        int valueSize = values.size();
        for (ValueMapItem item : items) {
            if (!(isMulCombo ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(val))) continue;
            values.add(item.getValue());
            if (isMulCombo) continue;
            break;
        }
        if (valueSize == values.size()) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\u201c{1}\u201d\u3002", (String)"PersonImportEntityMapping_9", (String)"swc-hsas-business", (Object[])new Object[0]), dataEntityProp.getDisplayName().getLocaleValue(), val.toString()));
        }
    }

    public boolean isEntityEmpty() {
        for (Map.Entry<String, Map<String, List<ColInfo>>> entrySet : this.colInfoMaps.entrySet()) {
            Map<String, List<ColInfo>> colInfoMap = entrySet.getValue();
            for (Map.Entry<String, List<ColInfo>> entry : colInfoMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static class ColInfo {
        private int index;
        private boolean mustInput;
        private IDataEntityProperty property;
        private IDataEntityProperty entryentityProperty;
        private String basedataId;

        public ColInfo() {
        }

        public ColInfo(int index, boolean mustInput, IDataEntityProperty property) {
            this.index = index;
            this.mustInput = mustInput;
            this.property = property;
        }

        public ColInfo(int index, boolean mustInput, IDataEntityProperty property, IDataEntityProperty entryentityProperty) {
            this.index = index;
            this.mustInput = mustInput;
            this.property = property;
            this.entryentityProperty = entryentityProperty;
        }

        public ColInfo(int index, boolean mustInput, IDataEntityProperty property, IDataEntityProperty entryentityProperty, String basedataId) {
            this.index = index;
            this.mustInput = mustInput;
            this.property = property;
            this.entryentityProperty = entryentityProperty;
            this.basedataId = basedataId;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public void setProperty(IDataEntityProperty property) {
            this.property = property;
        }

        public IDataEntityProperty getEntryentityProperty() {
            return this.entryentityProperty;
        }

        public void setEntryentityProperty(IDataEntityProperty entryentityProperty) {
            this.entryentityProperty = entryentityProperty;
        }

        public String getBasedataId() {
            return this.basedataId;
        }

        public void setBasedataId(String basedataId) {
            this.basedataId = basedataId;
        }
    }
}

