/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.sdk.swc.hsas.common.entity.ImportEntity;
import kd.swc.hsas.business.dataport.PersonImportConfig;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.xml.sax.SAXException;

public class PersonImportFailedSheetHandler
extends SheetHandler {
    private static Log log = LogFactory.getLog(PersonImportFailedSheetHandler.class);
    private SXSSFWorkbook book;
    private SXSSFSheet sheet;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>(16);
    private PersonImportLogger importLogger;
    private FileService service;
    private PersonImportConfig conf;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public PersonImportFailedSheetHandler(PersonImportConfig conf, PersonImportLogger importLogger, FileService service) {
        this.conf = conf;
        this.importLogger = importLogger;
        this.service = service;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFCell cell;
        this.currentRow = row;
        int currRowIndex = this.currentRow.getRowNum();
        if (currRowIndex > 2) {
            if (this.isRowSuccess(++currRowIndex, this.importLogger)) return;
            String error = this.getErrorStr(this.importLogger.getLogCache().get(currRowIndex));
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell(0);
            JSONObject styleJson = new JSONObject();
            styleJson.put("color", (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleJson));
            cell.setCellValue(error);
        } else if (currRowIndex == 2) {
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PersonImportFailedSheetHandler_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        } else if (currRowIndex == 0) {
            this.book = new SXSSFWorkbook(1000);
            this.book.setCompressTempFiles(true);
            this.sheet = this.book.createSheet("sheet1");
            this.sheet.setColumnWidth(0, 10000);
        }
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            CellStyle style;
            JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell((Integer)entry.getKey() + 1);
            if (currRowIndex == 2) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (((String)entry.getValue()).startsWith("*")) {
                    styleObj.put("color", (Object)IndexedColors.RED.getIndex());
                }
                this.sheet.setColumnWidth((Integer)entry.getKey() + 1, ((String)entry.getValue()).getBytes(StandardCharsets.UTF_8).length * 2 * 160);
            }
            if ((style = this.getCellStyle(styleObj)) != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
        ++this.cursorRowNum;
    }

    private boolean isRowSuccess(int currRowNum, PersonImportLogger importLogger) {
        return !importLogger.getLogCache().containsKey(currRowNum);
    }

    private String getErrorStr(List<ImportLogger.ImportLog> errorMsgs) {
        HashSet<String> strs = new HashSet<String>(16);
        for (ImportLogger.ImportLog errorMsg : errorMsgs) {
            strs.add(errorMsg.msg);
        }
        String separator = ";" + System.lineSeparator();
        return strs.stream().collect(Collectors.joining(separator));
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort("color");
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int index) {
        SXSSFRow row = sheet.getRow(index);
        if (row == null) {
            row = sheet.createRow(index);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            LocalDate now = LocalDate.now();
            ImportEntity mainEntity = this.conf.getImportEntityRel().getMainEntity();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntity.getEntityId());
            String format = String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth());
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_{0}_{1}.xlsx", (String)"PersonImportFailedSheetHandler_1", (String)"swc-hsas-business", (Object[])new Object[]{mainEntityType.getDisplayName(), format});
            fileName = fileName.trim().replaceAll(" ", "_");
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)mainEntity.getAppId(), (String)(mainEntity.getEntityId() + UUID.randomUUID().toString()), (String)fileName);
            url = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            if (null != this.book) {
                try {
                    this.book.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            this.conf = null;
            this.sheet = null;
            this.book = null;
            this.importLogger = null;
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        for (SheetHandler.CellValidation validation : cellValidations) {
            String[] items = validation.getValidation().split(",", -1);
            for (String range : validation.getRange().split(" ")) {
                AreaReference ref = new AreaReference(range, SpreadsheetVersion.EXCEL2007);
                CellRangeAddressList addressList = new CellRangeAddressList(ref.getFirstCell().getRow(), ref.getLastCell().getRow(), ref.getFirstCell().getCol() + 1, ref.getLastCell().getCol() + 1);
                DataValidationConstraint constraint = helper.createExplicitListConstraint(items);
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                this.sheet.addValidationData(dataValidation);
            }
        }
    }
}

