/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataport;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.model.DimValueResult;
import kd.swc.hsas.business.dataport.IPersonImportPlugin;
import kd.swc.hsas.business.dataport.ImportRowInfo;
import kd.swc.hsas.business.dataport.PersonImportLogger;
import kd.swc.hsas.business.file.SalaryFilePermissionHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.MultiLangEnumBridge;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileImportPlugin
implements IPersonImportPlugin {
    public static final Log logger = LogFactory.getLog(SalaryFileImportPlugin.class);
    private static final char UNDER_LINE = '_';
    private static final String QUESTION_MARK = "?";
    private static final String FUSEORGID = "fuseorgid";
    private static final String FDATAID = "fdataid";

    @Override
    public void setDataBaseSelectProp(String entityId, Set<String> selectProps) {
        logger.info("setDataBaseSelectProp...entityId={}", (Object)entityId);
        switch (entityId) {
            case "hbss_empgroup": {
                selectProps.add("bussinessfield");
                break;
            }
            case "hsas_payrollgrp": {
                selectProps.add("paysubject");
                selectProps.add("createorg");
                selectProps.add("country");
                selectProps.add("currency.id");
                selectProps.add("firstbsed");
                break;
            }
            case "hsas_person": {
                selectProps.add("empposinfo.adminorg.id");
                break;
            }
            case "hsas_employee": {
                selectProps.add("empnumber");
                selectProps.add("person");
                break;
            }
            case "hsas_salarycalcstyle": {
                selectProps.add("country");
                selectProps.add("countrytype");
                selectProps.add("ctrlstrategy");
                selectProps.add("salarycalstyle");
                break;
            }
            case "hsas_depemp": {
                selectProps.add("orgteam");
                selectProps.add("orgteam.name");
                selectProps.add("dutyworkroles.name");
                selectProps.add("isprimary");
                selectProps.add("otclassify.number");
                selectProps.add("employee.id");
                selectProps.add("employee.person");
                selectProps.add("cmpemp.number");
                selectProps.add("postype.name");
                selectProps.add("startdate");
                selectProps.add("enddate");
                selectProps.add("sysenddate");
                selectProps.add("laborrelrecord");
                logger.info("setDataBaseSelectProp...{}", (Object)selectProps.toString());
                break;
            }
        }
    }

    @Override
    public boolean fillSpecificBasedataBasedOnRel(DynamicProperty dp, DynamicObject dyobj, List<DynamicObject> basedataDyobjs, Map<String, Object> fillData, int rowIndex, PersonImportLogger importLogger) {
        String msgNotExistsWithEmp = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u4e1a\u52a1\u7f16\u7801\u4e3a\u201c{0}\u201d\u7684\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SalaryFileImportPlugin_21", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgNotExists = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u6709\u6548\u7684\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SalaryFileImportPlugin_22", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (basedataDyobjs != null && "employee".equals(dp.getName()) && basedataDyobjs.size() >= 2) {
            String employeeNumber = dyobj.getString("employee");
            String depEmpNumber = dyobj.getString("depemp");
            SWCDataServiceHelper employeeServiceHelper = new SWCDataServiceHelper("hsas_employee");
            SWCDataServiceHelper depempServiceHelper = new SWCDataServiceHelper("hsas_depemp");
            QFilter employeeFilter = new QFilter("employee.empnumber", "=", (Object)employeeNumber);
            if (SWCStringUtils.isNotEmpty((String)depEmpNumber)) {
                employeeFilter.and("number", "=", (Object)depEmpNumber);
            }
            QFilter notAbandonFilter = new QFilter("iscurrentversion", "!=", (Object)"-1");
            BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
            Object[] depempArray = depempServiceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)depempServiceHelper.getEntityName()), new QFilter[]{employeeFilter, notAbandonFilter}, "enddate desc, startdate desc, createtime desc");
            if (!SWCArrayUtils.isEmpty((Object[])depempArray)) {
                dyobj.set(dp.getName(), (Object)employeeServiceHelper.queryOne(depempArray[0].get("employee.id")));
                dyobj.set("depemp", depempArray[0]);
            } else {
                dyobj.set(dp.getName(), null);
                if (SWCStringUtils.isNotEmpty((String)depEmpNumber)) {
                    importLogger.putRowError((Integer)rowIndex, MessageFormat.format(msgNotExistsWithEmp, depEmpNumber));
                } else {
                    importLogger.putRowError((Integer)rowIndex, msgNotExists);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void afterAssembleData(Map<String, Object> data, Map<String, Object> fillData, PersonImportLogger importLogger, List<ImportRowInfo> rowInfos) {
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)Long.parseLong(RequestContext.get().getUserId()));
        HasPermOrgResult hasPermOrgResult = SalaryFilePermissionHelper.getBusinessUnitPermissionResult();
        HashMap<String, Set<Long>> userPermissionMap = new HashMap<String, Set<Long>>(4);
        Set<Long> importPermissionOrgIds = SalaryFilePermissionHelper.getOrgIdsByPermissionId("47156aff000000ac");
        Set<Long> importPermissionEmpGroupIds = SalaryFilePermissionHelper.getEmpGroupIdsByPermissionId("47156aff000000ac");
        Set<Long> payRollGroupIdsByPermissionId = SalaryFilePermissionHelper.getPayRollGroupIdsByPermissionId("47156aff000000ac");
        Set<Long> countrySetByPermItem = SalaryFilePermissionHelper.getCountrySetByPermItem("47156aff000000ac");
        userPermissionMap.put("adminOrg", importPermissionOrgIds);
        userPermissionMap.put("empGroup", importPermissionEmpGroupIds);
        userPermissionMap.put("payRollGroup", payRollGroupIdsByPermissionId);
        userPermissionMap.put("country", countrySetByPermItem);
        DynamicObject[] salaryFileArray = this.querySalaryFile(rowInfos);
        Set<String> abandonSalaryFile = this.getAbandonSalaryFileByIds(rowInfos);
        Set<String> submitSalaryFile = this.getSubmitSalaryFileByIds(salaryFileArray);
        Map<String, List<DynamicObject>> personFileMap = this.getSalaryFileKeyMap(salaryFileArray);
        Map<String, DynamicObject> salaryFileNumberMap = this.getSalaryFileNumberMap(salaryFileArray);
        Map<Long, DynamicObject> depempInfoMap = this.getDepempInfoMap(rowInfos);
        Map<Long, DynamicObject> empPosInfoMap = this.getEmpPosInfoMap(rowInfos);
        Map<Long, DynamicObject> employeeInfoMap = this.getEmployeeInfoMap(rowInfos);
        Map<Long, List<DynamicObject>> userSalaryFileMap = this.getUserSalaryFileMap(rowInfos);
        Map<Long, Set<Long>> useableSalaryCalsList = this.getUseableSalaryCalsList(rowInfos);
        for (ImportRowInfo rowInfo : rowInfos) {
            Map<String, DynamicObject> dyobjs = rowInfo.getDyobjs();
            DynamicObject salaryFileDyobj = dyobjs.get("hsas_salaryfile");
            this.setEmpPosInfo(depempInfoMap, empPosInfoMap, employeeInfoMap, importLogger, rowInfo);
            this.setAdminOrg(salaryFileDyobj);
            salaryFileDyobj.set("paystatus", (Object)salaryFileDyobj.getString("salarycalcstyle.salarycalstyle"));
            boolean isPass = true;
            if (!isSuperUser) {
                isPass = this.validatePerm(hasPermOrgResult, userPermissionMap, salaryFileDyobj, rowInfo, importLogger);
            }
            if (!isPass) continue;
            this.setBsedDate(salaryFileDyobj);
            this.validateSalaryFileIsAbandon(abandonSalaryFile, importLogger, rowInfo);
            this.validateSalaryFileIsSubmit(submitSalaryFile, importLogger, rowInfo);
            String orgNEmpGrpAdminOrgId = salaryFileDyobj.getString("adminorg.id");
            String personAdminOrgId = salaryFileDyobj.getString("depemp.orgteam.id");
            salaryFileDyobj.set("person", salaryFileDyobj.get("employee.person"));
            if (!SWCStringUtils.equals((String)personAdminOrgId, (String)orgNEmpGrpAdminOrgId)) {
                salaryFileDyobj.set("isescrowstaff", (Object)Boolean.TRUE);
            }
            this.validateEmpOwner(salaryFileDyobj, importLogger, rowInfo);
            DynamicObject personDBFile = this.validateUniqueFields(salaryFileDyobj, rowInfo, importLogger, personFileMap, salaryFileNumberMap);
            this.validateSalaryCountry(salaryFileDyobj, rowInfo, importLogger, useableSalaryCalsList);
            this.validateBred(salaryFileDyobj, rowInfo, importLogger);
            if (personDBFile == null) continue;
            dyobjs.put("hsas_salaryfile", personDBFile);
        }
    }

    private Map<Long, DynamicObject> getEmployeeInfoMap(List<ImportRowInfo> rowInfos) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        for (int i = 0; i < rowInfos.size(); ++i) {
            DynamicObject data = rowInfos.get(i).getEntityDyobj("hsas_salaryfile");
            DynamicObject empPosInfo = data.getDynamicObject("depemp");
            if (null != empPosInfo) continue;
            personIds.add(data.getLong("employee.person.id"));
        }
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_employee");
        QFilter personQfilter = new QFilter("person.id", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)personQfilter);
        DynamicObject[] employeeDys = personHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)personHelper.getEntityName()), new QFilter[]{personQfilter});
        HashMap<Long, DynamicObject> employeeMap = new HashMap<Long, DynamicObject>(16);
        if (null == employeeDys || employeeDys.length < 1) {
            return employeeMap;
        }
        for (int i = 0; i < employeeDys.length; ++i) {
            DynamicObject tempEmp = employeeDys[i];
            employeeMap.put(tempEmp.getLong("id"), tempEmp);
        }
        return employeeMap;
    }

    private Set<Long> queryEmpGroupIdsByPermissionId(String permissionImport) {
        long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult((Long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)permissionImport, (String)"empgroup");
        Set dimValueIds = dimValueResult.getDimValueIds();
        if (dimValueIds == null || dimValueIds.isEmpty()) {
            return new HashSet<Long>(16);
        }
        return dimValueIds.stream().map(item -> Long.valueOf(item)).collect(Collectors.toSet());
    }

    private void setBsedDate(DynamicObject salaryFileDyobj) {
        Date date = salaryFileDyobj.getDate("bsed");
        if (date != null) {
            return;
        }
        Date empPosStartDate = salaryFileDyobj.getDate("depemp.startdate");
        salaryFileDyobj.set("bsed", (Object)empPosStartDate);
    }

    private void setAdminOrg(DynamicObject salaryFileDyobj) {
        DynamicObject adminOrgDy = salaryFileDyobj.getDynamicObject("adminorg");
        DynamicObject empAdminOrgDy = salaryFileDyobj.getDynamicObject("empposinfo.adminorgvid");
        if (!SWCObjectUtils.isEmpty((Object)adminOrgDy)) {
            return;
        }
        DynamicObject empPosInfoAdminOrg = salaryFileDyobj.getDynamicObject("depemp.orgteam");
        salaryFileDyobj.set("adminorg", (Object)empPosInfoAdminOrg);
        salaryFileDyobj.set("adminorgvid", (Object)empAdminOrgDy);
    }

    private Set<String> getSubmitSalaryFileByIds(DynamicObject[] salaryFileArray) {
        HashSet<String> numberSet = new HashSet<String>(16);
        if (salaryFileArray == null) {
            return numberSet;
        }
        for (DynamicObject salaryFile : salaryFileArray) {
            if (!"B".equals(salaryFile.getString("status"))) continue;
            numberSet.add(salaryFile.getString("number"));
        }
        return numberSet;
    }

    private void validateEmpPos(DynamicObject salaryFileDyobj, PersonImportLogger importLogger, ImportRowInfo rowInfo, Map<Long, List<DynamicObject>> userSalaryFileMap) {
        long employeeId = salaryFileDyobj.getLong("employee.id");
        List<DynamicObject> empPosList = userSalaryFileMap.get(employeeId);
        if (empPosList == null || empPosList.isEmpty()) {
            return;
        }
        String salaryNumber = salaryFileDyobj.getString("number");
        HashMap<Long, String> salaryFileNumberMap = new HashMap<Long, String>(16);
        for (int i = 0; i < empPosList.size(); ++i) {
            DynamicObject tempSalary = empPosList.get(i);
            Long depempId = tempSalary.getLong("depemp.id");
            String tempSalaryNumber = tempSalary.getString("number");
            if (tempSalaryNumber.equalsIgnoreCase(salaryNumber)) continue;
            salaryFileNumberMap.put(depempId, tempSalaryNumber);
        }
        Long newEmpPosId = salaryFileDyobj.getLong("depemp.id");
        String newSalaryNumber = (String)salaryFileNumberMap.get(newEmpPosId);
        if (newSalaryNumber != null) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u5173\u8054\u4efb\u804c\u7ecf\u5386\u5df2\u7528\u4e8e\u521b\u5efa\u85aa\u8d44\u6863\u6848\u201c{0}\u201d\uff0c\u65e0\u6cd5\u518d\u521b\u5efa\u3002", (String)"SalaryFileImportPlugin_17", (String)"swc-hsas-business", (Object[])new Object[0]), newSalaryNumber));
        }
    }

    private void validateSalaryCountry(DynamicObject salaryFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger, Map<Long, Set<Long>> useableSalaryCalsList) {
        Object salaryStyleObj = salaryFileDyobj.get("salarycalcstyle");
        if (!(salaryStyleObj instanceof DynamicObject)) {
            return;
        }
        DynamicObject salaryStyle = (DynamicObject)salaryStyleObj;
        boolean condition = this.getCondition(salaryStyle, useableSalaryCalsList, salaryFileDyobj);
        if (!condition) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u65b9\u5f0f\u7684\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u3001\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u4e0e\u6863\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SalaryFileImportPlugin_19", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    private boolean getCondition(DynamicObject salaryStyle, Map<Long, Set<Long>> useableSalaryCalsList, DynamicObject dynamicObject) {
        if (salaryStyle == null) {
            return true;
        }
        long payRollRegionId = dynamicObject.getLong("payrollregion.id");
        long key = dynamicObject.getLong("salarycalcstyle.id");
        String countryType = salaryStyle.getString("countrytype");
        long countryId = salaryStyle.getLong("country.id");
        long orgId = dynamicObject.getLong("org.id");
        Set<Long> useableSalarySet = useableSalaryCalsList.get(key);
        if (payRollRegionId != countryId && "0".equals(countryType)) {
            return false;
        }
        String controlStrategy = salaryStyle.getString("ctrlstrategy");
        if ("5".equals(controlStrategy)) {
            return true;
        }
        return useableSalarySet != null && useableSalarySet.contains(orgId);
    }

    private Map<Long, Set<Long>> getUseableSalaryCalsList(List<ImportRowInfo> rowInfos) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        if (rowInfos == null || rowInfos.size() < 1) {
            return result;
        }
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<Long> styleSet = new HashSet<Long>(16);
        for (int i = 0; i < rowInfos.size(); ++i) {
            long styleId;
            DynamicObject salaryFile = rowInfos.get(i).getDyobjs().get("hsas_salaryfile");
            if (salaryFile == null) continue;
            long orgId = salaryFile.getLong("org.id");
            if (orgId != 0L) {
                orgSet.add(orgId);
            }
            if ((styleId = salaryFile.getLong("salarycalcstyle.id")) == 0L) continue;
            styleSet.add(styleId);
        }
        return SalaryFileHelper.getUseableSalaryCalsList(orgSet, styleSet);
    }

    private void validateEmpOwner(DynamicObject salaryFileDyobj, PersonImportLogger importLogger, ImportRowInfo rowInfo) {
        long empPersonId = salaryFileDyobj.getLong("depemp.employee.id");
        long salaryFileEmployeeId = salaryFileDyobj.getLong("employee.id");
        if (empPersonId != 0L && salaryFileEmployeeId != 0L && empPersonId != salaryFileEmployeeId) {
            logger.info("\u6240\u586b\u5199\u7684\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u8be5\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002empPersonId={},salaryFileEmployeeId={}", (Object)empPersonId, (Object)salaryFileEmployeeId);
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u8be5\u5173\u8054\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SalaryFileImportPlugin_12", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    private Map<Long, List<DynamicObject>> getUserSalaryFileMap(List<ImportRowInfo> rowInfos) {
        Set<Long> personIds = this.getSalaryPersonIds(rowInfos);
        SWCDataServiceHelper salaryFileDataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter personFilter = new QFilter("employee.id", "in", personIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)personFilter);
        QFilter satusFilter = new QFilter("salaryfile.status", "!=", (Object)"E");
        QFilter notAbandonFilter = new QFilter("datastatus", "!=", (Object)"-2");
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile");
        DynamicObject[] salaryFileArray = salaryFileDataServiceHelper.query(selectProperties, new QFilter[]{personFilter, notAbandonFilter, satusFilter});
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        if (rowInfos == null || salaryFileArray.length < 1) {
            return result;
        }
        for (int i = 0; i < salaryFileArray.length; ++i) {
            DynamicObject tempData = salaryFileArray[i];
            long employeeId = tempData.getLong("employee.id");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)result.get(employeeId);
            if (null == list) {
                list = new ArrayList<DynamicObject>();
                result.put(employeeId, list);
            }
            list.add(tempData);
        }
        return result;
    }

    private void setEmpPosInfo(Map<Long, DynamicObject> depempInfoMap, Map<Long, DynamicObject> empPosInfoMap, Map<Long, DynamicObject> employeeInfoMap, PersonImportLogger importLogger, ImportRowInfo rowInfo) {
        DynamicObject salaryFileDyobj = rowInfo.getEntityDyobj("hsas_salaryfile");
        DynamicObject depemp = salaryFileDyobj.getDynamicObject("depemp");
        if (depemp != null) {
            salaryFileDyobj.set("empposinfo", (Object)empPosInfoMap.get(salaryFileDyobj.get("depemp.id")));
            return;
        }
        Long personId = salaryFileDyobj.getLong("employee.person.id");
        DynamicObject depempDB = depempInfoMap.get(personId);
        if (null == depempDB) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u4e3b\u8981\u5c97\u4f4d\u3002", (String)"SalaryFileImportPlugin_9", (String)"swc-hsas-business", (Object[])new Object[0]));
            return;
        }
        salaryFileDyobj.set("depemp", (Object)depempDB);
        salaryFileDyobj.set("employee", (Object)employeeInfoMap.get(depempDB.get("employee.id")));
        salaryFileDyobj.set("empposinfo", (Object)empPosInfoMap.get(salaryFileDyobj.get("depemp.id")));
    }

    private void validateSalaryFileIsAbandon(Set<String> abandonSalaryFile, PersonImportLogger importLogger, ImportRowInfo rowInfo) {
        DynamicObject entityDyobj = rowInfo.getEntityDyobj("hsas_salaryfile");
        String number = entityDyobj.getString("number");
        if (!SWCStringUtils.isEmpty((String)number) && abandonSalaryFile.contains(number)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"SalaryFileImportPlugin_8", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    private void validateSalaryFileIsSubmit(Set<String> submitSalaryFile, PersonImportLogger importLogger, ImportRowInfo rowInfo) {
        DynamicObject entityDyobj = rowInfo.getEntityDyobj("hsas_salaryfile");
        String number = entityDyobj.getString("number");
        if (!SWCStringUtils.isEmpty((String)number) && submitSalaryFile.contains(number)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u8be5\u6863\u6848\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SalaryFileImportPlugin_16", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    private Set<String> getAbandonSalaryFileByIds(List<ImportRowInfo> rowInfos) {
        HashSet<String> numberSet = new HashSet<String>(16);
        for (ImportRowInfo rowInfo : rowInfos) {
            DynamicObject salaryFileObj = rowInfo.getEntityDyobj("hsas_salaryfile");
            String tempNumber = salaryFileObj.getString("number");
            numberSet.add(tempNumber);
        }
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        QFilter abandonFilter = new QFilter("status", "=", (Object)"E");
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] query = salaryFileOrm.query(new QFilter[]{numberFilter, abandonFilter});
        HashSet<String> resultSet = new HashSet<String>(16);
        if (query == null || query.length < 1) {
            return resultSet;
        }
        for (int i = 0; i < query.length; ++i) {
            DynamicObject dynamicObject = query[i];
            resultSet.add(dynamicObject.getString("number"));
        }
        return resultSet;
    }

    private Map<Long, DynamicObject> getEmpPosInfoMap(List<ImportRowInfo> rowInfos) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        for (int i = 0; i < rowInfos.size(); ++i) {
            DynamicObject data = rowInfos.get(i).getEntityDyobj("hsas_salaryfile");
            personIds.add(data.getLong("employee.person.id"));
        }
        SWCDataServiceHelper empPosOrgOrm = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter employeeQfilter = new QFilter("employee.person", "in", personIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeQfilter);
        employeeQfilter.and("datastatus", "!=", (Object)"-1");
        DynamicObject[] empPosOrgs = empPosOrgOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)empPosOrgOrm.getEntityName()), new QFilter[]{employeeQfilter});
        HashMap<Long, DynamicObject> empMap = new HashMap<Long, DynamicObject>(16);
        if (null == empPosOrgs || empPosOrgs.length < 1) {
            return empMap;
        }
        for (int i = 0; i < empPosOrgs.length; ++i) {
            DynamicObject tempEmp = empPosOrgs[i];
            long depempId = tempEmp.getLong("depemp.id");
            empMap.put(depempId, tempEmp);
        }
        return empMap;
    }

    private Map<Long, DynamicObject> getDepempInfoMap(List<ImportRowInfo> rowInfos) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        for (int i = 0; i < rowInfos.size(); ++i) {
            DynamicObject data = rowInfos.get(i).getEntityDyobj("hsas_salaryfile");
            DynamicObject empPosInfo = data.getDynamicObject("depemp");
            if (null != empPosInfo) continue;
            personIds.add(data.getLong("employee.person.id"));
        }
        SWCDataServiceHelper empPosOrgOrm = new SWCDataServiceHelper("hsas_depemp");
        QFilter employeeQfilter = new QFilter("employee.person", "in", personIds);
        employeeQfilter.and("isprimary", "=", (Object)Boolean.TRUE);
        BaseDataHisHelper.addHisCurrFilter((QFilter)employeeQfilter);
        employeeQfilter.and("datastatus", "!=", (Object)"-1");
        DynamicObject[] empPosOrgs = empPosOrgOrm.query("employee.id, employee.person.id, employee.person.personindexid, orgteam.name, dutyworkroles.name, otclassify.number, cmpemp.number,isprimary, postype.name, startdate, enddate, sysenddate, assignno, laborrelrecord", new QFilter[]{employeeQfilter}, "employee.person.id, enddate desc, startdate desc, createtime desc");
        HashMap<Long, DynamicObject> empMap = new HashMap<Long, DynamicObject>(16);
        if (null == empPosOrgs || empPosOrgs.length < 1) {
            return empMap;
        }
        for (int i = 0; i < empPosOrgs.length; ++i) {
            DynamicObject tempEmp = empPosOrgs[i];
            long personId = tempEmp.getLong("employee.person.id");
            if (empMap.containsKey(personId)) continue;
            empMap.put(personId, tempEmp);
        }
        return empMap;
    }

    private Map<String, DynamicObject> getSalaryFileNumberMap(DynamicObject[] salaryFileArray) {
        HashMap<String, DynamicObject> salaryFileNumberMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dy : salaryFileArray) {
            salaryFileNumberMap.put(dy.getString("number"), dy);
        }
        return salaryFileNumberMap;
    }

    private DynamicObject[] querySalaryFile(List<ImportRowInfo> rowInfos) {
        HashSet<String> numberSet = new HashSet<String>(16);
        for (ImportRowInfo rowInfo : rowInfos) {
            DynamicObject salaryFileObj = rowInfo.getEntityDyobj("hsas_salaryfile");
            String tempNumber = salaryFileObj.getString("number");
            numberSet.add(tempNumber);
        }
        SWCDataServiceHelper salaryFileDataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter personFilter = new QFilter("number", "in", numberSet);
        QFilter notAbandonFilter = new QFilter("status", "!=", (Object)"E");
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        DynamicObject[] salaryFileArray = salaryFileDataServiceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, notAbandonFilter});
        logger.info("querySalaryFile, salaryFileDataServiceHelper.loadDynamicObjectArray...{}", (Object)((Object)numberSet).toString());
        return salaryFileArray;
    }

    private Map<String, List<DynamicObject>> getSalaryFileKeyMap(DynamicObject[] salaryFileArray) {
        HashMap<String, List<DynamicObject>> personFileMap = new HashMap<String, List<DynamicObject>>(16);
        String key = null;
        ArrayList<DynamicObject> files = null;
        for (DynamicObject dy : salaryFileArray) {
            key = this.getUniqueFieldsKey(dy);
            files = (ArrayList<DynamicObject>)personFileMap.get(key);
            if (files == null) {
                files = new ArrayList<DynamicObject>(10);
                personFileMap.put(key, files);
            }
            files.add(dy);
        }
        return personFileMap;
    }

    private Set<Long> getSalaryPersonIds(List<ImportRowInfo> rowInfos) {
        HashSet<Long> personIds = new HashSet<Long>(16);
        Map<String, DynamicObject> dyobjs = null;
        DynamicObject salaryFileDyobj = null;
        Long personId = null;
        for (ImportRowInfo rowInfo : rowInfos) {
            dyobjs = rowInfo.getDyobjs();
            if (dyobjs == null || (salaryFileDyobj = dyobjs.get("hsas_salaryfile")) == null) continue;
            personId = salaryFileDyobj.getLong("employee.id");
            personIds.add(personId);
        }
        return personIds;
    }

    private String getUniqueFieldsKey(DynamicObject salaryFileDyobj) {
        String personId = salaryFileDyobj.getString("employee.person.id");
        String orgId = salaryFileDyobj.getString("org.id");
        String payRollGroupId = salaryFileDyobj.getString("payrollgroup.id");
        String payRollRegionId = salaryFileDyobj.getString("payrollregion.id");
        StringBuilder sb = new StringBuilder();
        sb.append(personId).append('_').append(orgId).append('_').append(payRollGroupId).append('_').append(payRollRegionId);
        return String.valueOf(sb);
    }

    private boolean validatePerm(HasPermOrgResult hasPermOrgResult, Map<String, Set<Long>> permissionMap, DynamicObject salaryFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger) {
        Set<Long> countrySetByPermItem;
        Set<Long> payRollGroupIdsByPermissionId;
        Set<Long> importPermissionEmpGroupIds;
        Set<Long> importPermissionOrgIds = permissionMap.get("adminOrg");
        int permValue = this.getPermValue(hasPermOrgResult, importPermissionOrgIds, importPermissionEmpGroupIds = permissionMap.get("empGroup"), payRollGroupIdsByPermissionId = permissionMap.get("payRollGroup"), countrySetByPermItem = permissionMap.get("country"), salaryFileDyobj);
        List<Integer> perm = ImportPermHelper.returnNoPerm(permValue);
        if (!perm.isEmpty()) {
            String noPermTips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%s\u7684\u6743\u9650,\u4e0d\u80fd\u5bfc\u5165\u6863\u6848,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SalaryFileImportPlugin_1", (String)"swc-hsas-business", (Object[])new Object[0]), ImportPermHelper.getPlaceHolderTips(perm));
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), noPermTips);
        }
        return perm.isEmpty();
    }

    private int getPermValue(HasPermOrgResult hasPermOrgResult, Set<Long> importPermissionOrgIds, Set<Long> importPermissionEmpGroupIds, Set<Long> payRollGroupIdsByPermissionId, Set<Long> countryPermissionId, DynamicObject salaryFileDyobj) {
        int defaultPermValue = 0;
        if (!this.hasOrgPermission(importPermissionOrgIds, salaryFileDyobj)) {
            defaultPermValue |= 2;
        }
        if (!this.hasBosOrgPermission(hasPermOrgResult, salaryFileDyobj)) {
            defaultPermValue |= 4;
        }
        if (!this.hasEmpGroupPermission(importPermissionEmpGroupIds, salaryFileDyobj)) {
            defaultPermValue |= 1;
        }
        if (!this.hasPayRollGroupPermission(payRollGroupIdsByPermissionId, salaryFileDyobj)) {
            defaultPermValue |= 8;
        }
        if (!this.hasEmpPosInfoPermission(importPermissionOrgIds, salaryFileDyobj)) {
            defaultPermValue |= 0x20;
        }
        if (!this.hasPayRollRegionPermission(countryPermissionId, salaryFileDyobj)) {
            defaultPermValue |= 0x10;
        }
        return defaultPermValue;
    }

    private boolean hasPayRollRegionPermission(Set<Long> countryPermissionId, DynamicObject salaryFileDyobj) {
        if (countryPermissionId == null) {
            return true;
        }
        Long payrollregionId = salaryFileDyobj.getLong("payrollregion.id");
        if (payrollregionId == null || payrollregionId == 0L) {
            return true;
        }
        return countryPermissionId.contains(payrollregionId);
    }

    private boolean hasEmpPosInfoPermission(Set<Long> importPermissionOrgIds, DynamicObject salaryFileDyobj) {
        Long orgteamId;
        if (importPermissionOrgIds == null) {
            return true;
        }
        String propName = "depemp.orgteam.id";
        String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
        if ("adminorgvid".equals(propKey)) {
            propName = "empposinfo.adminorgvid.id";
        }
        if ((orgteamId = Long.valueOf(salaryFileDyobj.getLong(propName))) == null || orgteamId == 0L) {
            return true;
        }
        return importPermissionOrgIds.contains(orgteamId);
    }

    private boolean hasOrgPermission(Set<Long> importPermissionOrgIds, DynamicObject salaryFileDyobj) {
        if (importPermissionOrgIds == null) {
            return true;
        }
        String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
        Long adminOrgId = salaryFileDyobj.getLong(propKey + ".id");
        if (adminOrgId == null || adminOrgId == 0L) {
            return true;
        }
        return importPermissionOrgIds.contains(adminOrgId);
    }

    private boolean hasBosOrgPermission(HasPermOrgResult hasPermOrgResult, DynamicObject salaryFileDyobj) {
        if (hasPermOrgResult == null) {
            return true;
        }
        List bosPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        Long orgId = salaryFileDyobj.getLong("org.id");
        if (orgId == null || orgId == 0L) {
            return true;
        }
        return bosPermOrgIds.contains(orgId);
    }

    private boolean hasEmpGroupPermission(Set<Long> importPermissionEmpGroupIds, DynamicObject salaryFileDyobj) {
        if (importPermissionEmpGroupIds == null) {
            return true;
        }
        Long empGroupId = salaryFileDyobj.getLong("empgroup.id");
        if (empGroupId == null || empGroupId == 0L) {
            return true;
        }
        return importPermissionEmpGroupIds.contains(empGroupId);
    }

    private boolean hasPayRollGroupPermission(Set<Long> importPermissionPayRollGroupIds, DynamicObject salaryFileDyobj) {
        if (importPermissionPayRollGroupIds == null) {
            return true;
        }
        Long payrollgroupId = salaryFileDyobj.getLong("payrollgroup.id");
        if (payrollgroupId == null || payrollgroupId == 0L) {
            return true;
        }
        return importPermissionPayRollGroupIds.contains(payrollgroupId);
    }

    private void validateBred(DynamicObject salaryFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger) {
        Date bsed = salaryFileDyobj.getDate("bsed");
        Date bsled = salaryFileDyobj.getDate("bsled");
        String number = salaryFileDyobj.getString("number");
        if (!SWCStringUtils.isEmpty((String)number) && bsed != null && bsled != null && !SWCDateTimeUtils.dayBefore((Date)bsed, (Date)bsled)) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"SalaryFileImportPlugin_4", (String)"swc-hsas-business", (Object[])new Object[0]), number));
        }
    }

    private DynamicObject validateUniqueFields(DynamicObject salaryFileDyobj, ImportRowInfo rowInfo, PersonImportLogger importLogger, Map<String, List<DynamicObject>> personFileMap, Map<String, DynamicObject> salaryFileNumberMap) {
        String number = salaryFileDyobj.getString("number");
        DynamicObject personDBFile = salaryFileNumberMap.get(number);
        if (personDBFile != null) {
            String excelUniquekey;
            String dbUniquekey = this.getUniqueFieldsKey(personDBFile);
            boolean isEqual = dbUniquekey.equals(excelUniquekey = this.getUniqueFieldsKey(salaryFileDyobj));
            if (isEqual) {
                boolean addtaxfile = salaryFileDyobj.getBoolean("addtaxfilecheckbox");
                if (addtaxfile) {
                    importLogger.putRowError((Integer)rowInfo.getRowIndex(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u85aa\u8d44\u6863\u6848\u6570\u636e\u65f6\uff0c\u4e0d\u53ef\u540c\u65f6\u66f4\u65b0\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u6570\u636e\u3002", (String)"SalaryFileImportPlugin_7", (String)"swc-hsas-business", (Object[])new Object[0]), number));
                    return null;
                }
                salaryFileDyobj.set("id", personDBFile.get("id"));
                salaryFileDyobj.set("boid", personDBFile.get("boid"));
                salaryFileDyobj.set("status", personDBFile.get("status"));
                salaryFileDyobj.set("creator", personDBFile.get("creator"));
                salaryFileDyobj.set("createtime", personDBFile.get("createtime"));
                return salaryFileDyobj;
            }
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7684\u201c\u8ba1\u85aa\u4eba\u5458\u201d\u3001\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u5b57\u6bb5\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SalaryFileImportPlugin_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        String excelUniquekey = this.getUniqueFieldsKey(salaryFileDyobj);
        List<DynamicObject> personFiles = personFileMap.get(excelUniquekey);
        if (personDBFile == null && personFiles != null && personFiles.size() >= 1) {
            importLogger.putRowError((Integer)rowInfo.getRowIndex(), String.format(Locale.ROOT, this.getConflictShowMessage(excelUniquekey), number));
        }
        return null;
    }

    private void dealPersonNumberRepeatUse(DynamicObject salaryFileDyobj, ImportRowInfo rowInfo, DynamicObject personDBFile) {
        boolean employeeIdIsEqual;
        JSONObject jsonData = (JSONObject)rowInfo.getData().get((Object)"hsas_salaryfile");
        boolean isHasDepEmp = jsonData.containsKey((Object)"depemp");
        boolean employeeNumberIsEqual = salaryFileDyobj.getString("employee.empnumber").equals(personDBFile.getString("employee.empnumber"));
        boolean bl = employeeIdIsEqual = salaryFileDyobj.getLong("employee.id") == personDBFile.getLong("employee.id");
        if (employeeNumberIsEqual && !employeeIdIsEqual) {
            salaryFileDyobj.set("employee", personDBFile.get("employee"));
            if (!isHasDepEmp) {
                SWCDataServiceHelper depempServiceHelper = new SWCDataServiceHelper("hsas_depemp");
                QFilter employeeFilter = new QFilter("employee.id", "=", salaryFileDyobj.get("employee.id"));
                QFilter notAbandonFilter = new QFilter("iscurrentversion", "!=", (Object)"-1");
                BaseDataHisHelper.addHisCurrFilter((QFilter)employeeFilter);
                Object[] depempArray = depempServiceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)depempServiceHelper.getEntityName()), new QFilter[]{employeeFilter, notAbandonFilter}, "enddate desc, startdate desc, createtime desc");
                if (!SWCArrayUtils.isEmpty((Object[])depempArray)) {
                    salaryFileDyobj.set("depemp", depempArray[0]);
                } else {
                    salaryFileDyobj.set("depemp", null);
                }
            }
        }
    }

    private String getConflictShowMessage(String excelUniquekey) {
        return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u201c\u8ba1\u85aa\u4eba\u5458\u201d\u3001\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3001\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\u7684\u6863\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\u3002", (String)"SalaryFileImportPlugin_10", (String)"swc-hsas-business", (Object[])new Object[0]);
    }

    @Override
    public boolean fillBasedataWithSpecialUseStatus(DynamicProperty dp, DynamicObject dyobj, DynamicObject basedataDyObj, int rowIndex, PersonImportLogger importLogger) {
        String fieldId = dp.getName();
        boolean isBreak = false;
        switch (fieldId) {
            case "adminorg": {
                isBreak = true;
                if (SWCStringUtils.equals((String)basedataDyObj.getString("enable"), (String)"1")) {
                    dyobj.set(fieldId, (Object)basedataDyObj);
                    break;
                }
                importLogger.putRowError((Integer)rowIndex, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599(%s)\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u542f\u7528\u201d\u3002", (String)"PersonImportPlugin_2", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName()));
                break;
            }
        }
        return isBreak;
    }

    static class ImportPermHelper {
        public static final int EMP_GROUP_PERM = 1;
        public static final int ADMIN_ORG_PERM = 2;
        public static final int ORG_PERM = 4;
        public static final int PAY_PROLL_GROUP = 8;
        public static final int PAY_PROLL_REGION = 16;
        public static final int EMP_POS_INFO = 32;

        private ImportPermHelper() {
        }

        private static Map<Integer, MultiLangEnumBridge> getMap() {
            int empGroupPermIndex = 0;
            int adminOrgPermIndex = 1;
            int orgPermIndex = 2;
            int payRollGroupPermIndex = 3;
            int payRollRegionPermIndex = 4;
            int empPosPermIndex = 5;
            HashMap<Integer, MultiLangEnumBridge> map = new HashMap<Integer, MultiLangEnumBridge>(16);
            map.put(empGroupPermIndex, new MultiLangEnumBridge("\u201c\u8ba1\u85aa\u4eba\u5458\u7ec4\u201d\u3001", "ImportPermHelper_0", "swc-hsas-business"));
            map.put(adminOrgPermIndex, new MultiLangEnumBridge("\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\u3001", "ImportPermHelper_1", "swc-hsas-business"));
            map.put(orgPermIndex, new MultiLangEnumBridge("\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001", "ImportPermHelper_2", "swc-hsas-business"));
            map.put(payRollGroupPermIndex, new MultiLangEnumBridge("\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3001", "ImportPermHelper_3", "swc-hsas-business"));
            map.put(payRollRegionPermIndex, new MultiLangEnumBridge("\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\u3001", "ImportPermHelper_4", "swc-hsas-business"));
            map.put(empPosPermIndex, new MultiLangEnumBridge("\u201c\u4e3b\u8981\u5c97\u4f4d\u201d\u3001", "ImportPermHelper_5", "swc-hsas-business"));
            return map;
        }

        public static List<Integer> returnNoPerm(int perm) {
            int maxIndex;
            String binAryStr = Integer.toBinaryString(perm);
            int lackedBit = ImportPermHelper.getMap().size() - binAryStr.length();
            StringBuilder sb = new StringBuilder();
            while (lackedBit-- > 0) {
                sb.append('0');
            }
            sb.append(binAryStr);
            char[] binAryChar = sb.toString().toCharArray();
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int i = maxIndex = binAryChar.length - 1; i >= 0; --i) {
                if (binAryChar[i] != '1') continue;
                res.add(maxIndex - i);
            }
            return res;
        }

        public static String getPlaceHolderTips(List<Integer> list) {
            StringBuilder placeHolderTips = new StringBuilder();
            for (Integer index : list) {
                placeHolderTips.append(ImportPermHelper.getMap().get(index).loadKDString());
            }
            return placeHolderTips.deleteCharAt(placeHolderTips.length() - 1).toString();
        }
    }
}

