/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.dataupgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CalSLItemResultUpGradeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CalSLItemResultUpGradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.dataUpGrade();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        service.disableJob(taskInfo.getJobId());
    }

    public void dataUpGrade() {
        logger.info("dataUpgrade start");
        List<Map<String, Object>> calTaskList = this.getCalTaskData();
        if (calTaskList.size() == 0) {
            return;
        }
        for (Map<String, Object> calTaskMap : calTaskList) {
            this.updateCalResultByTask(calTaskMap);
        }
        logger.info("dataUpgrade end");
    }

    private void updateCalResultByTask(Map<String, Object> calTaskMap) {
        long calTaskId = (Long)calTaskMap.get("id");
        Date startDate = (Date)calTaskMap.get("startDate");
        Date endDate = (Date)calTaskMap.get("endDate");
        logger.info("calTaskId:{} start", (Object)calTaskId);
        try {
            long lastCalResultId = 0L;
            for (int batchIndex = 0; batchIndex < 50; ++batchIndex) {
                String queryCalPersonSql = "select top 10000 fcalresultid from t_hsas_calperson where  fcalresultid != 0 and fcaltaskid = ? and fcalresultid > ? order by fcalresultid asc";
                ArrayList<Long> calResultIdList = new ArrayList<Long>(10);
                try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryCalPersonData", (DBRoute)SWCConstants.SWC_ROUETE, (String)queryCalPersonSql, (Object[])new Object[]{calTaskId, lastCalResultId});){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        calResultIdList.add(row.getLong("fcalresultid"));
                    }
                }
                if (calResultIdList.size() != 0) {
                    logger.info("calTaskId:{} , calResultId size:{}", (Object)calTaskId, (Object)calResultIdList.size());
                    Object[] params = new Object[calResultIdList.size() + 2];
                    params[0] = startDate;
                    params[1] = endDate;
                    int index = 2;
                    StringBuilder paramReplace = new StringBuilder();
                    for (Long id : calResultIdList) {
                        params[index] = id;
                        ++index;
                        paramReplace.append('?').append(',');
                    }
                    String updateSql = "update t_hsas_caltableentry set fstartdate = ? ,fenddate = ? where fid in (" + paramReplace.substring(0, paramReplace.length() - 1) + ") and fstartdate is null and fenddate is null";
                    SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, (Object[])params);
                    lastCalResultId = (Long)calResultIdList.get(calResultIdList.size() - 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("calTaskId = {} update error", (Object)calTaskId);
            logger.error("CalSLItemResultUpGradeService error", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getCalTaskData() {
        String selectSql = "select fid,fstartdate,fenddate from t_hsas_calpayrolltask where fid in (select fid from t_hsas_calpayrolltask_a where ftaskstatus not in ('1','2'))";
        ArrayList<Map<String, Object>> calTaskList = new ArrayList<Map<String, Object>>();
        HashMap<String, Comparable<Long>> tempMap = null;
        try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"queryCalPayRollTaskData", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                tempMap = new HashMap<String, Comparable<Long>>(3);
                tempMap.put("id", row.getLong("fid"));
                tempMap.put("startDate", row.getDate("fstartdate"));
                tempMap.put("endDate", row.getDate("fenddate"));
                calTaskList.add(tempMap);
            }
        }
        return calTaskList;
    }
}

