/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.file;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class FileDBHelper {
    private static final String SALARY_FILE = "salaryfile";

    private FileDBHelper() {
    }

    public static String getSalaryFileStatus(long id) {
        QFilter qIdFilter = new QFilter("id", "=", (Object)id);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject salaryFile = serviceHelper.queryOne("status", new QFilter[]{qIdFilter});
        if (salaryFile != null) {
            return salaryFile.getString("status");
        }
        return "";
    }

    public static void abandonSalaryFile(ArrayList<Long> salaryFileIdList) {
        FileDBHelper.abandonSalaryfile(salaryFileIdList);
        FileDBHelper.abandonPaysetting(salaryFileIdList);
        FileDBHelper.abandonEmpPosOrgRel(salaryFileIdList);
    }

    private static void abandonEmpPosOrgRel(ArrayList<Long> salaryFileIdList) {
        if (CollectionUtils.isEmpty(salaryFileIdList)) {
            return;
        }
        Set<Long> collect = salaryFileIdList.stream().collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.abandonEmpPosOrgRelBySalaryFileIds(collect);
    }

    private static void abandonPaysetting(ArrayList<Long> salaryFileIdList) {
        DynamicObject[] paySettingDyobjs;
        QFilter qPaySettingFilter = new QFilter(SALARY_FILE, "in", salaryFileIdList);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qPaySettingFilter);
        SWCDataServiceHelper paySettingServiceHelper = new SWCDataServiceHelper("hsas_paysetting");
        for (DynamicObject paySettingDyobj : paySettingDyobjs = paySettingServiceHelper.query("status", new QFilter[]{qPaySettingFilter})) {
            paySettingDyobj.set("status", (Object)"E");
        }
        paySettingServiceHelper.update(paySettingDyobjs);
    }

    private static void abandonSalaryfile(ArrayList<Long> idList) {
        QFilter qIdFilter = new QFilter("id", "in", idList);
        SWCDataServiceHelper salaryFileServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] salaryFileDyobjs = salaryFileServiceHelper.query("status, modifier, modifytime", new QFilter[]{qIdFilter});
        Date currTime = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject salaryFileDyobj : salaryFileDyobjs) {
            salaryFileDyobj.set("status", (Object)"E");
            salaryFileDyobj.set("modifier", (Object)userId);
            salaryFileDyobj.set("modifytime", (Object)currTime);
        }
        salaryFileServiceHelper.update(salaryFileDyobjs);
    }
}

