/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.file;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class FileDelDBHelper {
    public static final Log log = LogFactory.getLog(FileDelDBHelper.class);

    private FileDelDBHelper() {
    }

    public static void deleteSalaryFile(ArrayList<Long> salaryFileIdList) {
        FileDelDBHelper.deleteSalaryfile(salaryFileIdList);
        FileDelDBHelper.deletePaysetting(salaryFileIdList);
        FileDelDBHelper.deleteEmpPosOrgRel(salaryFileIdList);
    }

    private static void deleteEmpPosOrgRel(ArrayList<Long> salaryFileIdList) {
        if (CollectionUtils.isEmpty(salaryFileIdList)) {
            return;
        }
        Set<Long> collect = salaryFileIdList.stream().collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.deleteEmpPosOrgRelBySalaryFileIds(collect);
    }

    private static void deletePaysetting(ArrayList<Long> salaryFileIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_paysetting");
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdList);
        DynamicObject[] currDys = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_paysetting"), new QFilter[]{filter});
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        OperationResult result = opImpl.localInvokeOperation("delete", currDys, operateOption);
        log.info("hb_wang------------deletePaysetting,isSuccess={},getMessage={}", (Object)result.isSuccess(), (Object)result.getMessage());
    }

    private static void deleteSalaryfile(ArrayList<Long> idList) {
        QFilter qIdFilter = new QFilter("boid", "in", idList);
        SWCDataServiceHelper salaryFileServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        salaryFileServiceHelper.deleteByFilter(new QFilter[]{qIdFilter});
    }
}

