/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.file;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class SalaryFileCodeHelper {
    private static final Log logger = LogFactory.getLog(SalaryFileCodeHelper.class);
    private static final String FILE_CODE_ENTITY = "hsas_salaryfilecodec";
    private static final String FILE_ENTITY = "hsas_salaryfile";

    public static void refresh() {
        SWCDataServiceHelper fileCodeHelper = new SWCDataServiceHelper(FILE_CODE_ENTITY);
        DynamicObjectCollection fileCodes = fileCodeHelper.queryOriginalCollection("coderuleintermitnoid", new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        Set fileCodeIds = fileCodes.stream().map(dy -> dy.getString("coderuleintermitnoid")).collect(Collectors.toSet());
        SWCDataServiceHelper bosCodeHelper = new SWCDataServiceHelper("bos_coderule");
        String bosCodeProps = SWCHisBaseDataHelper.getSelectProperties((String)bosCodeHelper.getEntityName());
        QFilter fileObjFilter = new QFilter("bizobjectid.number", "=", (Object)FILE_ENTITY);
        fileObjFilter.and("enable", "=", (Object)"1");
        DynamicObject fileCodeDy = bosCodeHelper.queryOne(bosCodeProps, new QFilter[]{fileObjFilter});
        if (fileCodeDy == null) {
            return;
        }
        String fileCodeId = fileCodeDy.getString("id");
        SWCDataServiceHelper bosServiceHelper = new SWCDataServiceHelper("bos_coderule_intermitno");
        QFilter idFilter = new QFilter("coderuleid.id", "=", (Object)fileCodeId);
        String props = SWCHisBaseDataHelper.getSelectProperties((String)bosServiceHelper.getEntityName());
        props = props.replace(",sortitemvalue1", "");
        props = props.replace("sortitemvalue1,", "");
        DynamicObject[] codes = bosServiceHelper.query(props, new QFilter[]{idFilter});
        ArrayList<DynamicObject> waitInsert = new ArrayList<DynamicObject>(16);
        HashSet<String> newNumbers = new HashSet<String>(16);
        for (DynamicObject code : codes) {
            if (fileCodeIds.contains(code.getString("id"))) continue;
            DynamicObject newEntry = fileCodeHelper.generateEmptyDynamicObject();
            waitInsert.add(newEntry);
            newEntry.set("coderuleintermitnoid", code.get("id"));
            newEntry.set("sortitemvalue", code.get("sortitemvalue"));
            newEntry.set("serial", code.get("serial"));
            newEntry.set("codecreator", code.get("creater"));
            newEntry.set("codecreatetime", code.get("createdate"));
            newEntry.set("codemodifier", code.get("modifier"));
            newEntry.set("codemodifytime", code.get("modifydate"));
            newEntry.set("creator", (Object)RequestContext.get().getCurrUserId());
            newEntry.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newEntry.set("dealstatus", (Object)"0");
            newEntry.set("remark", (Object)("CodeId:" + fileCodeId + ";CodeName:" + fileCodeDy.getString("name")));
            String val = code.getString("sortitemvalue");
            int serial = code.getInt("serial");
            String val2 = String.format(Locale.ROOT, "%04d", serial);
            String newNumber = val + "-" + val2;
            newNumbers.add(newNumber);
            newEntry.set("newnumber", (Object)newNumber);
        }
        SWCDataServiceHelper fserviceHelper = new SWCDataServiceHelper(FILE_ENTITY);
        QFilter numberFilter = new QFilter("number", "in", newNumbers);
        String numberprops = SWCHisBaseDataHelper.getSelectProperties((String)fserviceHelper.getEntityName());
        DynamicObject[] files = fserviceHelper.query(numberprops, new QFilter[]{numberFilter});
        Map<String, DynamicObject> fileMap = Arrays.stream(files).collect(Collectors.toMap(file -> file.getString("number"), file -> file, (oldValue, newValue) -> oldValue));
        SWCDataServiceHelper taskServiceHelper = new SWCDataServiceHelper("hpdi_taskcenter");
        QFilter taskFilter = new QFilter("taskexecutestatus", "!=", (Object)"D");
        String taskProps = SWCHisBaseDataHelper.getSelectProperties((String)taskServiceHelper.getEntityName());
        DynamicObject[] tasks = taskServiceHelper.query(taskProps, new QFilter[]{taskFilter});
        for (DynamicObject newEntry : waitInsert) {
            String newNumber = newEntry.getString("newnumber");
            String sortitemvalue = newEntry.getString("sortitemvalue");
            DynamicObject file2 = fileMap.get(newNumber);
            newEntry.set("compareresult", (Object)(file2 == null ? 1 : 0));
            if (file2 == null) {
                newEntry.set("dealstatus", (Object)"2");
            }
            if (file2 == null) continue;
            String name = file2.getString("name");
            newEntry.set("filename", (Object)name);
            int i = 0;
            for (DynamicObject task : tasks) {
                String taskName = task.getString("name");
                if (taskName == null || !taskName.contains(sortitemvalue) && !taskName.contains(name)) continue;
                ++i;
            }
            newEntry.set("failtasknum", (Object)i);
        }
        fileCodeHelper.save(waitInsert.toArray(new DynamicObject[0]));
    }

    public static void clear() {
        SWCDataServiceHelper codeHelper2 = new SWCDataServiceHelper(FILE_CODE_ENTITY);
        QFilter dealstatusFilter = new QFilter("dealstatus", "=", (Object)"0");
        QFilter compareresultFilter = new QFilter("compareresult", "=", (Object)"false");
        String filecodeprops = SWCHisBaseDataHelper.getSelectProperties((String)codeHelper2.getEntityName());
        DynamicObject[] waitDeals = codeHelper2.query(filecodeprops, new QFilter[]{dealstatusFilter, compareresultFilter});
        Set codeIds2 = Arrays.stream(waitDeals).map(dy -> dy.getString("coderuleintermitnoid")).collect(Collectors.toSet());
        if (codeIds2 == null || codeIds2.size() == 0) {
            return;
        }
        SWCDataServiceHelper serviceHelper2 = new SWCDataServiceHelper("bos_coderule_intermitno");
        QFilter idFilter2 = new QFilter("id", "in", codeIds2);
        String coderuleprops = SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper2.getEntityName());
        DynamicObject[] waitDeletes = serviceHelper2.query(coderuleprops, new QFilter[]{idFilter2});
        Set coderuleWaitDeleteIds = Arrays.stream(waitDeletes).map(dy -> dy.getString("id")).collect(Collectors.toSet());
        OperationResult result = new OperationServiceImpl().localInvokeOperation("delete", waitDeletes, OperateOption.create());
        logger.info(MessageFormat.format("deletebill_result:{0}", SerializationUtils.toJsonString((Object)result)));
        List succPkIds = result.getSuccessPkIds();
        for (DynamicObject waitDeal : waitDeals) {
            if (!coderuleWaitDeleteIds.contains(waitDeal.get("coderuleintermitnoid"))) {
                waitDeal.set("dealstatus", (Object)"1");
                waitDeal.set("modifytime", (Object)new Date());
            }
            if (!succPkIds.contains(waitDeal.get("coderuleintermitnoid"))) continue;
            waitDeal.set("dealstatus", (Object)"1");
            waitDeal.set("modifytime", (Object)new Date());
        }
        codeHelper2.update(waitDeals);
    }
}

