/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.file;

import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.service.HSASPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class SalaryFilePermissionHelper {
    private SalaryFilePermissionHelper() {
    }

    private static boolean checkEntityCtrl(String entityNumber, String propkey) {
        SWCDataServiceHelper ctrlOrm = new SWCDataServiceHelper("hrcs_entityctrl");
        QFilter dimFilter = new QFilter("entitytype", "=", (Object)entityNumber);
        QFilter propkeyFilter = new QFilter("entryentity.propkey", "=", (Object)propkey);
        return ctrlOrm.isExists(new QFilter[]{dimFilter, propkeyFilter});
    }

    public static String getAdminorgPermPropKey() {
        String propKey = "adminorg";
        if (SalaryFilePermissionHelper.checkEntityCtrl("hsas_salaryfile", "adminorgvid")) {
            propKey = "adminorgvid";
        }
        return propKey;
    }

    public static Set<Long> getOrgIdsByPermissionId(String permItemId) {
        String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
        return SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)permItemId, (String)propKey);
    }

    public static HasPermOrgResult getBusinessUnitPermissionResult() {
        return HSASPermissionServiceHelper.getPermOrgs("hsas_salaryfile");
    }

    public static Set<Long> getEmpGroupIdsByPermissionId(String permissionId) {
        return HSASPermissionServiceHelper.getEmpgrpSetByPermItem("hsas_salaryfile", permissionId);
    }

    public static Set<Long> getPayRollGroupIdsByPermissionId(String permissionId) {
        return HSASPermissionServiceHelper.getPayrollGrpSetByPermItem("hsas_salaryfile", permissionId);
    }

    public static Set<Long> getCountrySetByPermItem(String permissionId) {
        return SWCPermissionServiceHelper.getCountrySetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)permissionId);
    }

    public static boolean hasEmpPosOrgGelPerm(String permItemId) {
        return HSASPermissionServiceHelper.hasPerm("hsas_empposorgrel_enthis", permItemId);
    }
}

