/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula;

import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;

public class FormulaViewServiceHelper {
    public static boolean isViewStatus(IDataModel model, IFormView formView) {
        if (FormulaViewServiceHelper.isRevisePage(formView)) {
            FormShowParameter parameter = formView.getFormShowParameter();
            OperationStatus status = parameter.getStatus();
            return OperationStatus.VIEW.equals((Object)status);
        }
        if (BaseDataHisHelper.isCurrPage((IFormView)formView)) {
            return FormulaViewServiceHelper.isViewStatusForCurr(model, formView);
        }
        return FormulaViewServiceHelper.isViewStatusForHis(model, formView);
    }

    private static boolean isRevisePage(IFormView formView) {
        Map params = formView.getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        return fromPage != null && "revise".equals(fromPage);
    }

    private static boolean isViewStatusForHis(IDataModel model, IFormView formView) {
        String dataStatus = (String)model.getValue("datastatus");
        return dataStatus != null && !"-3".equals(dataStatus) || OperationStatus.VIEW.equals((Object)formView.getFormShowParameter().getStatus());
    }

    private static boolean isViewStatusForCurr(IDataModel model, IFormView formView) {
        String status = (String)model.getValue("status");
        return status != null && !"A".equals(status) || OperationStatus.VIEW.equals((Object)formView.getFormShowParameter().getStatus());
    }
}

