/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.swc.hsas.business.formula.utils.FormulaParseUtils;
import kd.swc.hsas.common.formula.enums.ConditionEnum;
import kd.swc.hsas.common.formula.enums.ExpressionNodeTypeEnum;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsas.common.formula.enums.OperatorEnum;
import kd.swc.hsas.common.formula.expression.vo.AssExpression;
import kd.swc.hsas.common.formula.expression.vo.CalExpression;
import kd.swc.hsas.common.formula.expression.vo.DataGradeExpression;
import kd.swc.hsas.common.formula.expression.vo.Expression;
import kd.swc.hsas.common.formula.expression.vo.FunExpression;
import kd.swc.hsas.common.formula.expression.vo.ItemExpression;
import kd.swc.hsas.common.formula.expression.vo.NullExpression;
import kd.swc.hsas.common.formula.expression.vo.NumExpression;
import kd.swc.hsas.common.formula.expression.vo.OperatorExpression;
import kd.swc.hsas.common.formula.expression.vo.OutputFunExpression;
import kd.swc.hsas.common.formula.expression.vo.ResultExpression;
import kd.swc.hsas.common.formula.expression.vo.SpecialExpression;
import kd.swc.hsas.common.formula.expression.vo.StrExpression;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsas.common.utils.FormulaUtils;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class ExpressionParseHelper {
    private FormulaInfo formula;
    private Expression expression;
    private OriginalNode conditionNode;
    private ConditionEnum conditionEnum;
    private List<String> tempVarExpressionList;

    public ExpressionParseHelper(FormulaInfo formula, Expression expression, OriginalNode conditionNode, ConditionEnum conditionEnum) {
        this.formula = formula;
        this.expression = expression;
        this.conditionNode = conditionNode;
        this.conditionEnum = conditionEnum;
        this.tempVarExpressionList = new ArrayList<String>(10);
    }

    public List<String> getTempVarExpressionList() {
        return this.tempVarExpressionList;
    }

    public ResultExpression compile() throws KDBizException {
        ResultExpression result = this.compile(this.expression);
        return result;
    }

    public ResultExpression compile(Expression expression) throws KDBizException {
        if (expression instanceof CalExpression) {
            return this.compile((CalExpression)expression);
        }
        if (expression instanceof OutputFunExpression) {
            return this.compile((OutputFunExpression)expression);
        }
        if (expression instanceof FunExpression) {
            return this.compile((FunExpression)expression);
        }
        if (expression instanceof ItemExpression) {
            return this.compile((ItemExpression)expression);
        }
        if (expression instanceof StrExpression) {
            return this.compile((StrExpression)expression);
        }
        if (expression instanceof NumExpression) {
            return this.compile((NumExpression)expression);
        }
        if (expression instanceof AssExpression) {
            return this.compile((AssExpression)expression);
        }
        if (expression instanceof ResultExpression) {
            return (ResultExpression)expression;
        }
        if (expression instanceof DataGradeExpression) {
            return this.compile((DataGradeExpression)expression);
        }
        if (expression instanceof NullExpression) {
            return this.compile((NullExpression)expression);
        }
        return null;
    }

    private ResultExpression compile(StrExpression strExpression) {
        OriginalNode node = strExpression.getValue();
        String value = node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText();
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, value, DataTypeEnum.STRING);
    }

    private ResultExpression compile(NullExpression nullExpression) {
        String value = nullExpression.getValue().getNodeText();
        return new ResultExpression(ExpressionNodeTypeEnum.NULL, value, "null", DataTypeEnum.NULL);
    }

    private ResultExpression compile(NumExpression numExpression) {
        String value = numExpression.getValue().getNodeText();
        String code = null;
        code = FormulaUtils.isNumber((String)value) ? String.format(Locale.ROOT, "new BigDecimal(\"%s\")", value) : String.format(Locale.ROOT, "new BigDecimal(%s)", value);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, code, DataTypeEnum.NUMBERIC);
    }

    private ResultExpression compile(AssExpression assExpression) {
        Map value = assExpression.getItemInfoMap();
        String uniqueCode = MapUtils.getString((Map)value, (Object)"uniquecode");
        DataTypeEnum dataType = DataTypeEnum.getDataType((String)MapUtils.getString((Map)value, (Object)"datatype"));
        String code = "    " + uniqueCode;
        return new ResultExpression(assExpression.getType(), null, code, dataType, (Expression)assExpression);
    }

    public ResultExpression compile(ItemExpression itemExpression) {
        ResultExpression itemResultExpression = null;
        itemResultExpression = "SL".equals(itemExpression.getItemType()) ? this.getSlItemResultExpression(itemExpression) : ("SP".equals(itemExpression.getItemType()) || "VR".equals(itemExpression.getItemType()) ? this.getSpOrVrItemResultExpression(itemExpression) : ("AC".equals(itemExpression.getItemType()) ? this.getAccResultExpression(itemExpression) : this.getItemResultExpression(itemExpression)));
        return itemResultExpression;
    }

    private ResultExpression getSpOrVrItemResultExpression(ItemExpression itemExpression) {
        Map itemInfoMap = itemExpression.getItemInfoMap();
        DataTypeEnum dataType = DataTypeEnum.getDataType((String)((String)itemInfoMap.get("datatype")));
        ResultExpression resultExpression = null;
        if ("SP".equals(itemExpression.getItemType()) && dataType == DataTypeEnum.NUMBERIC) {
            String code = String.format(Locale.ROOT, "dealSpItemValuePrecision(\"%s\",%s)", (String)itemInfoMap.get("uniquecode"), (String)itemInfoMap.get("uniquecode"));
            resultExpression = new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, code, dataType);
        } else {
            resultExpression = new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, (String)itemInfoMap.get("uniquecode"), dataType);
        }
        return resultExpression;
    }

    private ResultExpression getAccResultExpression(ItemExpression itemExpression) {
        Map itemInfoMap = itemExpression.getItemInfoMap();
        DataTypeEnum dataType = DataTypeEnum.getDataType((String)((String)itemInfoMap.get("datatype")));
        String uniqueCode = (String)itemInfoMap.get("uniquecode");
        String itemCode = String.format(Locale.ROOT, "getAccValueAsBigDecimal(\"%s\")", uniqueCode);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, itemCode, dataType);
    }

    private ResultExpression getItemResultExpression(ItemExpression itemExpression) {
        String uniqueCode;
        DataTypeEnum itemType;
        Map itemInfoMap = itemExpression.getItemInfoMap();
        String itemUniqueCode = null;
        itemUniqueCode = this.formula.isProrateItemFormula() ? this.formula.getId() : this.formula.getSalaryItem().getUniquecode();
        OriginalNode node = itemExpression.getItem();
        if (node.isBsPropItemNode()) {
            String dataTypeId = (String)itemInfoMap.get("datatype");
            itemType = DataTypeEnum.getDataTypeById((long)Long.parseLong(dataTypeId));
            uniqueCode = itemInfoMap.get("bizItemUiqueCode") + "_@_" + itemInfoMap.get("uniquecode");
        } else {
            itemType = DataTypeEnum.getDataType((String)((String)itemInfoMap.get("datatype")));
            uniqueCode = (String)itemInfoMap.get("uniquecode");
        }
        String itemCode = null;
        DataTypeEnum dataType = null;
        if (itemType == DataTypeEnum.NUMBERIC) {
            itemCode = String.format("getFieldValueAsBigDecimal(\"%s\",sectionKey,\"%s\")", uniqueCode, itemUniqueCode);
            dataType = DataTypeEnum.NUMBERIC;
        } else if (itemType == DataTypeEnum.DATE) {
            itemCode = String.format("getFieldValueAsDate(\"%s\",sectionKey,\"%s\")", uniqueCode, itemUniqueCode);
            dataType = DataTypeEnum.DATE;
        } else {
            itemCode = String.format("getFieldValueAsString(\"%s\",sectionKey,\"%s\")", uniqueCode, itemUniqueCode);
            dataType = DataTypeEnum.STRING;
        }
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, itemCode, dataType);
    }

    private ResultExpression getSlItemResultExpression(ItemExpression itemExpression) {
        Map itemInfoMap = itemExpression.getItemInfoMap();
        DataTypeEnum itemType = DataTypeEnum.getDataType((String)((String)itemInfoMap.get("showtype")));
        String uniqueCode = (String)itemInfoMap.get("uniquecode");
        String itemCode = null;
        DataTypeEnum dataType = null;
        if (itemType == DataTypeEnum.NUMBERIC) {
            itemCode = String.format(Locale.ROOT, "getResultValueAsBigDecimal(\"%s\")", uniqueCode);
            dataType = DataTypeEnum.NUMBERIC;
        } else if (itemType == DataTypeEnum.DATE) {
            itemCode = String.format(Locale.ROOT, "getResultValueAsDate(\"%s\")", uniqueCode);
            dataType = DataTypeEnum.DATE;
        } else {
            itemCode = String.format(Locale.ROOT, "getResultValueAsString(\"%s\")", uniqueCode);
            dataType = DataTypeEnum.STRING;
        }
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, itemCode, dataType);
    }

    public ResultExpression compile(OutputFunExpression funExpression) throws KDBizException {
        ResultExpression resultExp = this.compile((FunExpression)funExpression);
        resultExp.setType(ExpressionNodeTypeEnum.OUTPUT);
        return resultExp;
    }

    public ResultExpression compile(FunExpression funExpression) throws KDBizException {
        OriginalNode funNode = funExpression.getFunction();
        ResultExpression paramResult = null;
        Map funcInfoMap = funExpression.getFuncInfoMap();
        List paramList = (List)funcInfoMap.get("entryentity");
        int index = 0;
        Map paramMap = null;
        DataTypeEnum paramDataType = null;
        String msg = null;
        StringBuilder funcCode = new StringBuilder();
        funcCode.append(funcInfoMap.get("define"));
        funcCode.append('(');
        for (Expression paramExp : funExpression.getParameter()) {
            paramResult = this.compile(paramExp);
            paramMap = (Map)paramList.get(index);
            paramDataType = DataTypeEnum.getDataType((String)((String)paramMap.get("paramdatatype")));
            if (paramDataType != paramResult.getDataType()) {
                msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7684\u7b2c{3}\u4e2a\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u51fd\u6570[{4}]\u7684\u7b2c{5}\u4e2a\u53c2\u6570\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f{6}\uff0c\u800c\u7ef4\u62a4\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e3a{7}\u3002", (String)"ExpressionParseHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, funNode.getLineIndex() + 1, funNode.getEndColumnIndex() + 1, funNode.getNodeText(), index + 1, funNode.getNodeText(), index + 1, FormulaParseUtils.getDataTypeDesc(paramDataType), FormulaParseUtils.getDataTypeDesc(paramResult.getDataType())));
            }
            if (index == 0) {
                funcCode.append(paramResult.getCode());
            } else {
                funcCode.append(',').append(paramResult.getCode());
            }
            ++index;
        }
        funcCode.append(')');
        funNode.setKeyType(ExpressionNodeTypeEnum.FUN);
        ResultExpression resultExp = new ResultExpression(ExpressionNodeTypeEnum.RESULT, funcCode.toString(), funcCode.toString(), DataTypeEnum.getDataType((String)((String)funcInfoMap.get("funcdatatype"))));
        return resultExp;
    }

    public ResultExpression compile(DataGradeExpression dmExpression) throws KDBizException {
        OriginalNode dmNode = dmExpression.getDataGrade();
        ResultExpression paramResult = null;
        Map dmInfoMap = dmExpression.getDMInfoMap();
        List paramList = (List)dmInfoMap.get("conditionList");
        int index = 0;
        Map paramMap = null;
        DataTypeEnum paramDataType = null;
        String msg = null;
        StringBuilder dmCode = new StringBuilder();
        String resultValType = (String)dmInfoMap.get("resultValType");
        if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.AMOUNT.getCode()) || SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            dmCode.append("getDataGradeBigDecimalResult");
        } else if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            dmCode.append("getDataGradeStringResult");
        } else if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            dmCode.append("getDataGradeDateResult");
        }
        dmCode.append('(');
        String gradeNumber = (String)dmInfoMap.get("gradeNumber");
        dmCode.append('\"').append("BR").append('_').append(gradeNumber).append('\"');
        dmCode.append(',');
        String itemId = (String)dmInfoMap.get("id");
        if (itemId.indexOf(95) != -1) {
            String resultIdStr = itemId.substring(itemId.lastIndexOf(95) + 1);
            Long resultId = Long.valueOf(resultIdStr);
            dmCode.append('\"').append(resultId).append('\"');
        }
        dmCode.append(',');
        dmCode.append("new Object[] {");
        for (Expression paramExp : dmExpression.getParameter()) {
            paramResult = this.compile(paramExp);
            paramMap = (Map)paramList.get(index);
            String conditionValType = (String)paramMap.get("conditionValType");
            String valTypeDesc = this.getDatagradeValType(conditionValType);
            paramDataType = DataTypeEnum.getDataType((String)valTypeDesc);
            if (paramDataType != paramResult.getDataType()) {
                msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7[{2}]\u7684\u7b2c{3}\u4e2a\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u6570\u636e\u5206\u7ea7[{4}]\u7684\u7b2c{5}\u4e2a\u53c2\u6570\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f{6}\uff0c\u800c\u7ef4\u62a4\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e3a{7}\u3002", (String)"ExpressionParseHelper_18", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, dmNode.getLineIndex() + 1, dmNode.getEndColumnIndex() + 1, dmNode.getNodeText(), index + 1, dmNode.getNodeText(), index + 1, FormulaParseUtils.getDataTypeDesc(paramDataType), FormulaParseUtils.getDataTypeDesc(paramResult.getDataType())));
            }
            if (index == 0) {
                dmCode.append(paramResult.getCode());
            } else {
                dmCode.append(',').append(paramResult.getCode());
            }
            ++index;
        }
        dmCode.append('}');
        dmCode.append(')');
        dmNode.setKeyType(ExpressionNodeTypeEnum.DM);
        String resultvalType = (String)dmInfoMap.get("resultValType");
        String valTypeDesc = this.getDatagradeValType(resultvalType);
        ResultExpression resultExp = new ResultExpression(ExpressionNodeTypeEnum.RESULT, dmCode.toString(), dmCode.toString(), DataTypeEnum.getDataType((String)valTypeDesc));
        return resultExp;
    }

    private String getDatagradeValType(String code) {
        String valTypeDesc = "";
        if (SWCStringUtils.equals((String)code, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            valTypeDesc = DataGradeValueTypeEnum.TEXT.getDesc();
        } else if (SWCStringUtils.equals((String)code, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            valTypeDesc = DataGradeValueTypeEnum.DECIMAL.getDesc();
        } else if (SWCStringUtils.equals((String)code, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            valTypeDesc = DataGradeValueTypeEnum.AMOUNT.getDesc();
        } else if (SWCStringUtils.equals((String)code, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            valTypeDesc = DataGradeValueTypeEnum.DATE.getDesc();
        }
        return valTypeDesc;
    }

    public ResultExpression compile(CalExpression calExpression) throws KDBizException {
        Stack<Expression> calStack = this.getCalStack(calExpression.getParameter());
        Stack<Expression> resultStack = new Stack<Expression>();
        int index = 0;
        String errorMsg = null;
        int len = calStack.size();
        for (int i = 0; i < len; ++i) {
            ResultExpression result;
            ResultExpression resultExp;
            Expression exp = (Expression)calStack.get(i);
            ++index;
            if (exp instanceof StrExpression || exp instanceof NumExpression || exp instanceof ResultExpression || exp instanceof NullExpression) {
                resultStack.push(exp);
                continue;
            }
            if (exp instanceof ItemExpression) {
                resultExp = this.compile((ItemExpression)exp);
                resultStack.push((Expression)resultExp);
                continue;
            }
            if (exp instanceof OperatorExpression) {
                index = this.pushResultExpressionToStack(resultStack, exp, calExpression, index);
                continue;
            }
            if (exp instanceof AssExpression) {
                resultExp = this.compile((AssExpression)exp);
                resultStack.push((Expression)resultExp);
                continue;
            }
            if (!(exp instanceof SpecialExpression) || (result = this.compile(resultStack.pop())) == null) continue;
            result.setCode(String.format(Locale.ROOT, "(%s)", result.getCode()));
            resultStack.push((Expression)result);
        }
        Expression express = (Expression)resultStack.pop();
        if (!(express instanceof ResultExpression)) {
            if (this.conditionNode != null) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u540e\u9762\u7684\u8868\u8fbe\u5f0f\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"ExpressionParseHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, this.conditionNode.getLineIndex() + 1, this.conditionNode.getStartColumnIndex() + 1, this.conditionNode.getNodeText()));
            }
            OriginalNode tempNode = FormulaUtils.getExpressionNode((Expression)((Expression)calExpression.getParameter().get(0)));
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"ExpressionParseHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, tempNode.getLineIndex() + 1, tempNode.getStartColumnIndex() + 1, this.buildErrorParam(calExpression.getParameter())));
        }
        return (ResultExpression)express;
    }

    private String buildErrorParam(List<Expression> expressionList) {
        StringBuilder sb = new StringBuilder();
        OriginalNode tempNode = null;
        for (Expression temp : expressionList) {
            tempNode = FormulaUtils.getExpressionNode((Expression)temp);
            sb.append(tempNode.getNodeText());
        }
        return sb.toString();
    }

    private int pushResultExpressionToStack(Stack<Expression> resultStack, Expression exp, CalExpression calExpression, int index) throws KDBizException {
        boolean hasNull;
        String errorMsg = null;
        OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum((OperatorExpression)((OperatorExpression)exp));
        OriginalNode operNode = ((OperatorExpression)exp).getOperation();
        if (resultStack.size() < 2) {
            if (operatorEnum == OperatorEnum.LPARENTHESES) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7f3a\u5c11\u4e0e\u5de6\u62ec\u53f7\u201c{2}\u201d\u5339\u914d\u7684\u53f3\u62ec\u53f7\u201c{3}\u201d\u3002", (String)"ExpressionParseHelper_19", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, OperatorEnum.LPARENTHESES.getAlias(), OperatorEnum.RPARENTHESES.getAlias()));
            }
            if (operatorEnum == OperatorEnum.AND || operatorEnum == OperatorEnum.OR) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4e24\u4fa7\u53ea\u80fd\u662f\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"ExpressionParseHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText()));
            }
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u53f3\u4fa7\u8868\u8fbe\u5f0f\u4e0d\u5b8c\u6574\u3002", (String)"ExpressionParseHelper_21", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText()));
        }
        if (SWCStringUtils.equals((String)operNode.getNodeText(), (String)OperatorEnum.COMMA.getAlias()) || "\uff0c".equals(operNode.getNodeText())) {
            OriginalNode tempNode = FormulaUtils.getExpressionNode((Expression)((Expression)calExpression.getParameter().get(0)));
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"ExpressionParseHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, tempNode.getLineIndex() + 1, tempNode.getStartColumnIndex() + 1, this.buildErrorParam(calExpression.getParameter())));
        }
        Expression calExp2 = resultStack.pop();
        Expression calExp1 = resultStack.pop();
        String code = null;
        ResultExpression result1 = this.compile(calExp1);
        ResultExpression result2 = this.compile(calExp2);
        ResultExpression resultExp = null;
        boolean bl = hasNull = result2.getDataType() == DataTypeEnum.NULL;
        if (operatorEnum != OperatorEnum.EQUAL && operatorEnum != OperatorEnum.UNEQUAL && hasNull) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201cNULL\u201d\u53ea\u80fd\u8fdb\u884c\u201c=\u201d\u3001\u201c!=\u201d\u6bd4\u8f83\u3002", (String)"ExpressionParseHelper_22", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1));
        }
        if (operatorEnum == OperatorEnum.PLUS || operatorEnum == OperatorEnum.SUBTRACT || operatorEnum == OperatorEnum.MULTIPLY || operatorEnum == OperatorEnum.DIVIDE) {
            resultExp = this.getCalResultExpression(operatorEnum, operNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.EQUAL || operatorEnum == OperatorEnum.UNEQUAL) {
            resultExp = this.getEqualOrUnEqualResultExpression(operatorEnum, operNode, result1, result2, hasNull);
        } else if (operatorEnum == OperatorEnum.GT || operatorEnum == OperatorEnum.GTOREQUAL || operatorEnum == OperatorEnum.LT || operatorEnum == OperatorEnum.LTOREQUAL) {
            resultExp = this.getCompareResultExpression(operatorEnum, operNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.AND || operatorEnum == OperatorEnum.OR) {
            resultExp = this.getConditionResultExpression(operatorEnum, operNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.LIKE) {
            if (result1.getDataType() != DataTypeEnum.STRING) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201cLIKE\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u7684\u8fd4\u56de\u503c\u6570\u636e\u7c7b\u578b\u4e3a{2}\uff0c\u800c\u201cLIKE\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6587\u672c\u3002", (String)"ExpressionParseHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, FormulaParseUtils.getDataTypeDesc(result1.getDataType())));
            }
            if (result2.getDataType() != DataTypeEnum.STRING) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201cLIKE\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u7684\u8fd4\u56de\u503c\u6570\u636e\u7c7b\u578b\u4e3a{2}\uff0c\u800c\u201cLIKE\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6587\u672c\u3002", (String)"ExpressionParseHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, FormulaParseUtils.getDataTypeDesc(result2.getDataType())));
            }
            code = String.format("contains(%s,%s)", result1.getCode(), result2.getCode());
            resultExp = new ResultExpression(ExpressionNodeTypeEnum.BOOLEAN, code, code, DataTypeEnum.BOOLEAN);
        }
        if ((this.conditionEnum == null || this.conditionEnum == ConditionEnum.ELSE || this.conditionEnum == ConditionEnum.THEN) && index >= 29) {
            resultExp = this.splitOutPutExpression(resultExp);
            this.formula.addTempVarCount();
            index = 0;
        }
        resultStack.push((Expression)resultExp);
        return index;
    }

    private ResultExpression splitOutPutExpression(ResultExpression resultExp) {
        if (resultExp == null) {
            return resultExp;
        }
        int tempVarNum = this.formula.getTempVarNum();
        String varName = "tempVariable" + tempVarNum;
        DataTypeEnum dataType = resultExp.getDataType();
        String typeStr = dataType == DataTypeEnum.NUMBERIC || dataType == DataTypeEnum.AMOUNT ? "BigDecimal " : (dataType == DataTypeEnum.DATE ? "Date " : "String ");
        String code = typeStr + varName + " = " + resultExp.getCode() + ";";
        this.tempVarExpressionList.add(code);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, varName, varName, dataType);
    }

    private ResultExpression getCalResultExpression(OperatorEnum operatorEnum, OriginalNode operNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        String errorMsg = null;
        DataTypeEnum dataType = null;
        if (result1.getDataType() != DataTypeEnum.NUMBERIC) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u662f{3}\uff0c\u800c\u52a0\u3001\u51cf\u3001\u4e58\u3001\u9664\u7b49\u8fd0\u7b97\u7b26\u5de6\u53f3\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u3002", (String)"ExpressionParseHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText(), FormulaParseUtils.getDataTypeDesc(result1.getDataType())));
        }
        if (result2.getDataType() != DataTypeEnum.NUMBERIC) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u662f{3}\uff0c\u800c\u52a0\u3001\u51cf\u3001\u4e58\u3001\u9664\u7b49\u8fd0\u7b97\u7b26\u5de6\u53f3\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u3002", (String)"ExpressionParseHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText(), FormulaParseUtils.getDataTypeDesc(result2.getDataType())));
        }
        dataType = DataTypeEnum.NUMBERIC;
        String code = String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, dataType);
    }

    private ResultExpression getEqualOrUnEqualResultExpression(OperatorEnum operatorEnum, OriginalNode operNode, ResultExpression result1, ResultExpression result2, boolean hasNull) throws KDBizException {
        if (result1.getDataType() != result2.getDataType() && result2.getDataType() != DataTypeEnum.NULL) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"ExpressionParseHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText(), FormulaParseUtils.getDataTypeDesc(result1.getDataType()), FormulaParseUtils.getDataTypeDesc(result2.getDataType())));
        }
        String code = null;
        if (operatorEnum == OperatorEnum.EQUAL && (this.conditionNode == null || !FormulaKeyEnum.IF.getCode().equalsIgnoreCase(this.conditionNode.getNodeText()) && !FormulaKeyEnum.ELSEIF.getCode().equalsIgnoreCase(this.conditionNode.getNodeText()))) {
            code = String.format("%s %s %s", result1.getCode(), "=", result2.getCode());
            return new ResultExpression(ExpressionNodeTypeEnum.ASS, code, code, result1.getDataType(), result1.getOriginalExp());
        }
        code = result1.getDataType() == DataTypeEnum.NUMBERIC ? String.format("%s(%s,%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode(), hasNull ? Boolean.FALSE.toString() : Boolean.TRUE.toString()) : String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        return new ResultExpression(ExpressionNodeTypeEnum.BOOLEAN, code, code, DataTypeEnum.BOOLEAN);
    }

    private ResultExpression getCompareResultExpression(OperatorEnum operatorEnum, OriginalNode operNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        String code = null;
        String errorMsg = null;
        if (!(result1.getDataType() == DataTypeEnum.NUMBERIC && result2.getDataType() == DataTypeEnum.NUMBERIC || result1.getDataType() == DataTypeEnum.DATE && result2.getDataType() == DataTypeEnum.DATE)) {
            if (result1.getDataType() != DataTypeEnum.NUMBERIC && result1.getDataType() != DataTypeEnum.DATE) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u53f7\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u4e0d\u6b63\u786e\uff0c\u5927\u4e8e\u3001\u5c0f\u4e8e\u3001\u5927\u4e8e\u7b49\u4e8e\u548c\u5c0f\u4e8e\u7b49\u4e8e\u7b49\u8fd0\u7b97\u7b26\u53f7\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u6216\u65e5\u671f\u3002", (String)"ExpressionParseHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText(), FormulaParseUtils.getDataTypeDesc(result1.getDataType())));
            }
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u53f7\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u4e0d\u6b63\u786e\uff0c\u5927\u4e8e\u3001\u5c0f\u4e8e\u3001\u5927\u4e8e\u7b49\u4e8e\u548c\u5c0f\u4e8e\u7b49\u4e8e\u7b49\u8fd0\u7b97\u7b26\u53f7\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u6216\u65e5\u671f\u3002", (String)"ExpressionParseHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText(), FormulaParseUtils.getDataTypeDesc(result2.getDataType())));
        }
        code = String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        return new ResultExpression(ExpressionNodeTypeEnum.BOOLEAN, code, code, DataTypeEnum.BOOLEAN);
    }

    private ResultExpression getConditionResultExpression(OperatorEnum operatorEnum, OriginalNode operNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        String errorMsg = null;
        String code = null;
        if (result1.getDataType() != DataTypeEnum.BOOLEAN) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u903b\u8f91\u7c7b\u578b\u3002", (String)"ExpressionParseHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText()));
        }
        if (result2.getDataType() != DataTypeEnum.BOOLEAN) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u903b\u8f91\u7c7b\u578b\u3002", (String)"ExpressionParseHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operNode.getLineIndex() + 1, operNode.getStartColumnIndex() + 1, operNode.getNodeText()));
        }
        code = String.format("%s%s%s", result1.getCode(), operatorEnum.getCode(), result2.getCode());
        return new ResultExpression(ExpressionNodeTypeEnum.BOOLEAN, code, code, DataTypeEnum.BOOLEAN);
    }

    private Stack<Expression> getCalStack(List<Expression> list) throws KDBizException {
        String errorMsg = null;
        OriginalNode nodeTemp = null;
        Stack<Expression> calStack = new Stack<Expression>();
        Stack<Expression> operatorStack = new Stack<Expression>();
        Expression previousExp = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ResultExpression resultExp;
            FunExpression funExp;
            Expression expression = list.get(i);
            if (expression instanceof StrExpression || expression instanceof NumExpression || expression instanceof ItemExpression || expression instanceof AssExpression || expression instanceof NullExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                calStack.push(expression);
                continue;
            }
            if (expression instanceof OperatorExpression) {
                Expression operator;
                Expression top;
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                OperatorExpression operExpression = (OperatorExpression)expression;
                nodeTemp = operExpression.getOperation();
                if (this.isLParentheses(expression)) {
                    operatorStack.push(expression);
                    continue;
                }
                if (this.isRParentheses(expression)) {
                    if (!operatorStack.isEmpty()) {
                        Expression pop = (Expression)operatorStack.pop();
                        while (!operatorStack.isEmpty() && !this.isLParentheses(pop)) {
                            calStack.push(pop);
                            pop = (Expression)operatorStack.pop();
                        }
                        if (!this.isLParentheses(pop)) {
                            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"ExpressionParseHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
                            throw new KDBizException(MessageFormat.format(errorMsg, nodeTemp.getLineIndex() + 1, nodeTemp.getStartColumnIndex() + 1, nodeTemp.getNodeText()));
                        }
                        calStack.push((Expression)new SpecialExpression());
                        continue;
                    }
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"ExpressionParseHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, nodeTemp.getLineIndex() + 1, nodeTemp.getStartColumnIndex() + 1, nodeTemp.getNodeText()));
                }
                OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum((OperatorExpression)operExpression);
                if ((operExpression.getOperation().getNodeText().equals(OperatorEnum.SUBTRACT.getAlias()) || operExpression.getOperation().getNodeText().equals(OperatorEnum.PLUS.getAlias())) && (i == 0 || list.get(i - 1) instanceof OperatorExpression && (this.isLParentheses(list.get(i - 1)) || this.isSpecialOperator((OperatorExpression)list.get(i - 1))))) {
                    OriginalNode thisNode = operExpression.getOperation();
                    OriginalNode zeroNode = new OriginalNode();
                    zeroNode.setLineIndex(thisNode.getLineIndex());
                    zeroNode.setStartColumnIndex(thisNode.getStartColumnIndex());
                    zeroNode.setStartColumnIndex(thisNode.getStartColumnIndex());
                    zeroNode.setNodeText("0");
                    zeroNode.setKeyType(ExpressionNodeTypeEnum.NUM);
                    calStack.push((Expression)new NumExpression(zeroNode));
                }
                if (this.isLParentheses(top = this.getTop(operatorStack)) || top == null) {
                    operatorStack.push(expression);
                    continue;
                }
                if (this.isBooleanOperator(operatorEnum)) {
                    if (!operatorStack.isEmpty()) {
                        operator = operatorStack.pop();
                        while (!(operatorStack.isEmpty() || this.isLParentheses(operator) || this.isAndOrOperator((OperatorExpression)operator))) {
                            calStack.push(operator);
                            operator = operatorStack.pop();
                        }
                        if (this.isLParentheses(operator) || this.isAndOrOperator((OperatorExpression)operator)) {
                            operatorStack.push(operator);
                        } else {
                            calStack.push(operator);
                        }
                    }
                    operatorStack.push(expression);
                    continue;
                }
                if (this.isAndOrOperator(operExpression)) {
                    if (!operatorStack.isEmpty()) {
                        operator = operatorStack.pop();
                        while (!operatorStack.isEmpty() && !this.isLParentheses(operator)) {
                            calStack.push(operator);
                            operator = operatorStack.pop();
                        }
                        if (this.isLParentheses(operator)) {
                            operatorStack.push(operator);
                        } else {
                            calStack.push(operator);
                        }
                    }
                    operatorStack.push(expression);
                    continue;
                }
                int num = FormulaUtils.compareOperatorPriority((OperatorExpression)((OperatorExpression)top), (OperatorExpression)((OperatorExpression)expression));
                if (num >= 0) {
                    int priority;
                    Expression op;
                    calStack.push(operatorStack.pop());
                    while (!operatorStack.isEmpty() && !this.isLParentheses(op = operatorStack.peek()) && (priority = FormulaUtils.compareOperatorPriority((OperatorExpression)((OperatorExpression)op), (OperatorExpression)((OperatorExpression)expression))) >= 0) {
                        calStack.push(operatorStack.pop());
                    }
                    operatorStack.push(expression);
                    continue;
                }
                operatorStack.push(expression);
                continue;
            }
            if (expression instanceof FunExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                funExp = (FunExpression)expression;
                resultExp = this.compile(funExp);
                calStack.push((Expression)resultExp);
                continue;
            }
            if (!(expression instanceof DataGradeExpression)) continue;
            previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
            funExp = (DataGradeExpression)expression;
            resultExp = this.compile((DataGradeExpression)funExp);
            calStack.push((Expression)resultExp);
        }
        while (!operatorStack.isEmpty()) {
            Expression pop = (Expression)operatorStack.pop();
            calStack.push(pop);
        }
        return calStack;
    }

    private boolean isBooleanOperator(OperatorEnum operatorEnum) {
        boolean flag = false;
        if (operatorEnum == OperatorEnum.EQUAL || operatorEnum == OperatorEnum.UNEQUAL || operatorEnum == OperatorEnum.GT || operatorEnum == OperatorEnum.LT || operatorEnum == OperatorEnum.GTOREQUAL || operatorEnum == OperatorEnum.LTOREQUAL) {
            flag = true;
        }
        return flag;
    }

    private boolean isAndOrOperator(OperatorExpression operExpression) {
        boolean flag = false;
        OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum((OperatorExpression)operExpression);
        if (operatorEnum == OperatorEnum.AND || operatorEnum == OperatorEnum.OR) {
            flag = true;
        }
        return flag;
    }

    private Expression checkTwoParenthesesHaveOperator(Expression previousExp, Expression currentExp) throws KDBizException {
        if (previousExp == null) {
            return currentExp;
        }
        String msg = null;
        if (this.isRParentheses(previousExp) && this.isLParentheses(currentExp)) {
            OperatorExpression previous = (OperatorExpression)previousExp;
            OperatorExpression current = (OperatorExpression)currentExp;
            OriginalNode previousNode = previous.getOperation();
            OriginalNode currentNode = current.getOperation();
            msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u53f3\u62ec\u53f7[{2}]\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u5de6\u62ec\u53f7[{5}]\u4e4b\u95f4\u6ca1\u6709\u64cd\u4f5c\u7b26\uff0c\u9700\u8981\u901a\u8fc7\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isRParentheses(previousExp) && !(currentExp instanceof OperatorExpression)) {
            msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u4e4b\u95f4\u7f3a\u5c11\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            OriginalNode currentNode = FormulaUtils.getExpressionNode((Expression)currentExp);
            OperatorExpression opExp = (OperatorExpression)previousExp;
            OriginalNode previousNode = opExp.getOperation();
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isLParentheses(currentExp) && !(previousExp instanceof OperatorExpression)) {
            msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u4e4b\u95f4\u7f3a\u5c11\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
            OriginalNode previousNode = FormulaUtils.getExpressionNode((Expression)previousExp);
            OperatorExpression opExp = (OperatorExpression)currentExp;
            OriginalNode currentNode = opExp.getOperation();
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isLParentheses(previousExp) && this.isRParentheses(currentExp)) {
            OperatorExpression opExp = (OperatorExpression)previousExp;
            OriginalNode node = opExp.getOperation();
            msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u62ec\u53f7\u5185\u5fc5\u987b\u7ef4\u62a4\u503c\u3002", (String)"ExpressionParseHelper_17", (String)"swc-hsas-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1));
        }
        return currentExp;
    }

    private boolean isLParentheses(Expression expression) {
        if (expression instanceof OperatorExpression) {
            OperatorExpression tempExp = (OperatorExpression)expression;
            OriginalNode operatorNode = tempExp.getOperation();
            if (OperatorEnum.LPARENTHESES.getAlias().equals(operatorNode.getNodeText()) || "\uff08".equals(operatorNode.getNodeText())) {
                return true;
            }
        }
        return false;
    }

    private boolean isRParentheses(Expression expression) {
        if (expression instanceof OperatorExpression) {
            OperatorExpression tempExp = (OperatorExpression)expression;
            OriginalNode operatorNode = tempExp.getOperation();
            if (OperatorEnum.RPARENTHESES.getAlias().equals(operatorNode.getNodeText()) || "\uff09".equals(operatorNode.getNodeText())) {
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialOperator(OperatorExpression expression) {
        OriginalNode node = expression.getOperation();
        return SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.EQUAL.getAlias()) || SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.UNEQUAL.getAlias()) || SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GT.getAlias()) || SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LT.getAlias()) || SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GTOREQUAL.getAlias()) || SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LTOREQUAL.getAlias());
    }

    private Expression getTop(Stack<Expression> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        int top = stack.size() - 1;
        return (Expression)stack.get(top);
    }
}

