/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.formula.helper.ExpressionParseHelper;
import kd.swc.hsas.business.formula.utils.FormulaParseUtils;
import kd.swc.hsas.common.formula.enums.ConditionEnum;
import kd.swc.hsas.common.formula.enums.ExpressionNodeTypeEnum;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsas.common.formula.enums.OperatorEnum;
import kd.swc.hsas.common.formula.expression.vo.AssExpression;
import kd.swc.hsas.common.formula.expression.vo.CalExpression;
import kd.swc.hsas.common.formula.expression.vo.ConditionExpression;
import kd.swc.hsas.common.formula.expression.vo.DataGradeExpression;
import kd.swc.hsas.common.formula.expression.vo.DateExpression;
import kd.swc.hsas.common.formula.expression.vo.ExitExpression;
import kd.swc.hsas.common.formula.expression.vo.Expression;
import kd.swc.hsas.common.formula.expression.vo.FunExpression;
import kd.swc.hsas.common.formula.expression.vo.ItemExpression;
import kd.swc.hsas.common.formula.expression.vo.NullExpression;
import kd.swc.hsas.common.formula.expression.vo.NumExpression;
import kd.swc.hsas.common.formula.expression.vo.OperatorExpression;
import kd.swc.hsas.common.formula.expression.vo.OutputFunExpression;
import kd.swc.hsas.common.formula.expression.vo.ResultExpression;
import kd.swc.hsas.common.formula.expression.vo.StrExpression;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsas.common.formula.vo.SalaryItem;
import kd.swc.hsas.common.utils.FormulaUtils;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class FormulaParseHelper {
    private static final char NEWLINE = '\n';
    private static final String ENDINDEX = "endIndex";
    private static final String EXPRESSIONFLAG = "expression";
    private static final String CONDITION_EXP_PLACEHOLDER = "CONDITION_EXP_PLACEHOLDER_";
    private static final String VRITEM_NAME = "vrItem_";
    private static final String SYSTEMTYPE = "swc-hsas-business";
    public static final String PRE_VAR_NAME = "formula_";
    private Map<String, String> spAndVrItemInfoMap = new HashMap<String, String>(16);

    public FormulaInfo parse(FormulaInfo formula) throws KDBizException {
        List<OriginalNode> nodeList = this.filterCommentNode(formula.getOriginalNodes());
        List<ConditionExpression> conditionExpList = this.getConditionExpressionList(nodeList, true);
        this.checkCondition(conditionExpList, formula);
        this.parseAndBuildExecuteExp(formula, conditionExpList);
        return formula;
    }

    private List<OriginalNode> filterCommentNode(List<OriginalNode> nodeList) {
        ArrayList<OriginalNode> list = new ArrayList<OriginalNode>(nodeList.size());
        boolean isAllCommentNode = true;
        for (OriginalNode node : nodeList) {
            if (node.isCommontNode()) {
                node.setUniqueKey(node.getNodeText());
                continue;
            }
            list.add(node);
            isAllCommentNode = false;
        }
        if (isAllCommentNode) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u6709\u6548\u7684\u516c\u5f0f\u5185\u5bb9\u3002", (String)"FormulaParseHelper_16", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return list;
    }

    private List<ConditionExpression> getConditionExpressionList(List<OriginalNode> nodeList, boolean isOutermost) {
        int complex = 0;
        ArrayList<ConditionExpression> expressionList = new ArrayList<ConditionExpression>(10);
        Map conditionKeyMap = FormulaUtils.getConditionMap();
        ConditionExpression conditionExpression = new ConditionExpression(null);
        OriginalNode ifConditionNode = null;
        int index = 0;
        while (index < nodeList.size()) {
            OriginalNode node = nodeList.get(index);
            ConditionEnum conditionEnum = (ConditionEnum)conditionKeyMap.get(node.getNodeText().toUpperCase(Locale.ROOT));
            if (null != conditionEnum) {
                if (ConditionEnum.ENDIF == conditionEnum) {
                    if (!CollectionUtils.isEmpty((Collection)conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getCondition())) {
                        expressionList.add(conditionExpression);
                    }
                    if (complex == 0 && !isOutermost) break;
                    conditionExpression = new ConditionExpression(node);
                    conditionExpression.setConditionEnum(conditionEnum);
                    expressionList.add(conditionExpression);
                    conditionExpression = new ConditionExpression(null);
                    --complex;
                    ++index;
                    continue;
                }
                if (ConditionEnum.THEN == conditionEnum || ConditionEnum.ELSE == conditionEnum) {
                    if (!CollectionUtils.isEmpty((Collection)conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getCondition())) {
                        expressionList.add(conditionExpression);
                    }
                    if (complex == 0 && !isOutermost) break;
                    List<OriginalNode> childNodes = nodeList.stream().skip(index + 1).collect(Collectors.toList());
                    conditionExpression = new ConditionExpression(node);
                    conditionExpression.setConditionEnum(conditionEnum);
                    List<ConditionExpression> childConditions = this.getConditionExpressionList(childNodes, false);
                    index = index + this.getExpressionNodesCount(childConditions) + this.getCurrentConditionExpressionNodesCount(childConditions) + 1;
                    conditionExpression.setChildConditionExpressionList(this.getActualChildAndSetExpressions(conditionExpression, childConditions));
                    expressionList.add(conditionExpression);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)conditionExpression.getExpressions()) && Objects.isNull(conditionExpression.getCondition())) {
                    expressionList.add(conditionExpression);
                }
                if (ConditionEnum.IF == conditionEnum) {
                    ifConditionNode = node;
                    ++complex;
                }
                if (ConditionEnum.ELSEIF == conditionEnum && !isOutermost && complex == 0) break;
                conditionExpression = new ConditionExpression(node);
                conditionExpression.setConditionEnum(conditionEnum);
                expressionList.add(conditionExpression);
            } else {
                conditionExpression.addExpression(node);
            }
            if (FormulaUtils.isResultKey((String)node.getNodeText())) {
                conditionExpression.setIsResult(Boolean.TRUE);
            }
            ++index;
        }
        if (complex != 0 && ifConditionNode != null) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201cIF\u201d\u7f3a\u5c11\u4e0e\u4e4b\u5339\u914d\u7684\u201cENDIF\u201d\u3002", (String)"FormulaParseHelper_49", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, ifConditionNode.getLineIndex() + 1, ifConditionNode.getStartColumnIndex() + 1));
        }
        if (isOutermost && !CollectionUtils.isEmpty((Collection)conditionExpression.getExpressions())) {
            expressionList.add(conditionExpression);
        }
        return expressionList;
    }

    private int getExpressionNodesCount(List<ConditionExpression> conditionExpressionList) {
        if (CollectionUtils.isEmpty(conditionExpressionList)) {
            return 0;
        }
        int count = conditionExpressionList.stream().filter(exp -> !CollectionUtils.isEmpty((Collection)exp.getChildConditionExpressionList())).mapToInt(exp -> this.getExpressionNodesCount(exp.getChildConditionExpressionList())).sum();
        return count + conditionExpressionList.stream().mapToInt(exp -> exp.getExpressions().size()).sum();
    }

    private int getCurrentConditionExpressionNodesCount(List<ConditionExpression> conditionExpressionList) {
        if (CollectionUtils.isEmpty(conditionExpressionList)) {
            return 0;
        }
        return (int)conditionExpressionList.stream().filter(exp -> Objects.nonNull(exp.getCondition())).count();
    }

    private List<ConditionExpression> getActualChildAndSetExpressions(ConditionExpression parentConditionExp, List<ConditionExpression> childConditionExpressions) {
        if (CollectionUtils.isEmpty(childConditionExpressions)) {
            return childConditionExpressions;
        }
        int index = 0;
        for (ConditionExpression childExp2 : childConditionExpressions) {
            if (Objects.isNull(childExp2.getCondition())) {
                childExp2.getExpressions().forEach(arg_0 -> ((ConditionExpression)parentConditionExp).addExpression(arg_0));
                continue;
            }
            OriginalNode node = new OriginalNode();
            node.setNodeText(CONDITION_EXP_PLACEHOLDER + index);
            parentConditionExp.addExpression(node);
            ++index;
        }
        return childConditionExpressions.stream().filter(childExp -> Objects.nonNull(childExp.getCondition())).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private List<Expression> getExpression(ConditionExpression conditionExpression, List<OriginalNode> nodeList, FormulaInfo formula) throws KDBizException {
        ArrayList<Expression> expList = new ArrayList<Expression>(10);
        ArrayList expressionLists = new ArrayList(10);
        ArrayList<Expression> expressionList = new ArrayList<Expression>(10);
        ConditionEnum conditionEnum = conditionExpression.getConditionEnum();
        int index = 0;
        int length = nodeList.size();
        String previousType = null;
        String errorMsg = null;
        Map<String, Object> tempResultMap = null;
        OriginalNode tempDataTypeNode = null;
        while (index < length) {
            void var16_16;
            ArrayList<Expression> tempVariableExpList;
            OriginalNode node = nodeList.get(index);
            String nextNodeText = null;
            Object var16_17 = null;
            if (index + 1 < length) {
                nextNodeText = nodeList.get(index + 1).getNodeText();
            }
            if (index > 0) {
                String string = nodeList.get(index - 1).getNodeText();
            }
            if (FormulaUtils.isFunction((String)node.getNodeText())) {
                tempResultMap = (Map<String, Object>)formula.getFcMap().get(FormulaUtils.subStringNodetext((String)node.getNodeText()));
                if (null == tempResultMap) {
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_31", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodetext((String)node.getNodeText())));
                }
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                String uniqueCode = (String)tempResultMap.get("uniquecode");
                formula.addFcUniqueCode(uniqueCode);
                node.setUniqueKey("FC[" + uniqueCode + "]");
                Object expression = null;
                expression = "FC_4070_S".equals(uniqueCode) || "FC_4050_S".equals(uniqueCode) ? new OutputFunExpression(node) : new FunExpression(node);
                expression.setFuncInfoMap(tempResultMap);
                int tmpEndIndex = this.getFunctionExpression((FunExpression)expression, nodeList, index, formula);
                expressionList.add((Expression)expression);
                index = tmpEndIndex + 1;
            } else if (FormulaUtils.isExitKey((String)node.getNodeText())) {
                ExitExpression expression = new ExitExpression(node);
                expressionList.add((Expression)expression);
                node.setUniqueKey(FormulaKeyEnum.EXIT.getCode());
                ++index;
            } else if (FormulaUtils.isDataGrade((String)node.getNodeText())) {
                String gradeName = FormulaUtils.subStringNodetext((String)node.getNodeText());
                tempResultMap = this.getDataGradeMap(index, nodeList, formula.getDmMap(), gradeName);
                if (null == tempResultMap) {
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u9879\u76ee[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_41", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodetext((String)node.getNodeText())));
                }
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                formula.addDmUniqueCode("BR_" + tempResultMap.get("gradeNumber"));
                DataGradeExpression expression = new DataGradeExpression(node);
                expression.setDMInfoMap(tempResultMap);
                node.setUniqueKey("BR[" + tempResultMap.get("uniquecode") + "]");
                int tmpEndIndex = this.getDataGradeExpression(expression, nodeList, index, formula, gradeName);
                expressionList.add((Expression)expression);
                index = tmpEndIndex + 1;
            } else if (FormulaUtils.isSalaryItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "SL", formula, expressionList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                ++index;
            } else if (FormulaUtils.isFTItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "FT", formula, expressionList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                ++index;
            } else if (FormulaUtils.isBSItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "BS", formula, expressionList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                ++index;
            } else if (FormulaUtils.isOutputCondition((ConditionEnum)conditionEnum) && FormulaUtils.isSPAssignmentKey((String)node.getNodeText(), (String)nextNodeText)) {
                if (expressionList.size() > 0) {
                    ArrayList<Expression> tempExpList = new ArrayList<Expression>(expressionList);
                    expressionLists.add(tempExpList);
                    expressionList.clear();
                }
                this.checkAssItemAndAddAssExpression(node, formula, expressionList, false);
                previousType = this.checkIsSameExpressType(previousType, "assType", node);
                this.addSpItemInfoToMap(node, formula);
                ++index;
            } else if (FormulaUtils.isSPItem((String)node.getNodeText())) {
                this.checkAssItemAndAddAssExpression(node, formula, expressionList, true);
                previousType = this.checkIsSameExpressType(previousType, "assType", node);
                this.addSpItemInfoToMap(node, formula);
                ++index;
            } else if (FormulaUtils.isAcc((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "AC", formula, expressionList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                ++index;
            } else if (FormulaUtils.isString((String)node.getNodeText())) {
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                expressionList.add((Expression)new StrExpression(node));
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                ++index;
            } else if (FormulaUtils.isOperation((String)node.getNodeText())) {
                previousType = this.checkIsSameExpressType(previousType, "operatorType", node);
                expressionList.add((Expression)new OperatorExpression(node));
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                ++index;
            } else if (FormulaUtils.isNumber((String)node.getNodeText())) {
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                expressionList.add((Expression)new NumExpression(node));
                node.setUniqueKey(node.getNodeText());
                ++index;
            } else if (FormulaUtils.isNullKey((String)node.getNodeText())) {
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                expressionList.add((Expression)new NullExpression(node));
                node.setUniqueKey(FormulaKeyEnum.NULL.getCode());
                ++index;
            } else if (this.isChildConditionKey(node.getNodeText())) {
                List childConditionExpressionList = conditionExpression.getChildConditionExpressionList();
                int tempIndex = Integer.parseInt(node.getNodeText().replace(CONDITION_EXP_PLACEHOLDER, ""));
                if (childConditionExpressionList.size() <= tempIndex) {
                    errorMsg = ResManager.loadKDString((String)"\u590d\u6742\u6761\u4ef6\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\u3002", (String)"FormulaParseHelper_29", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(errorMsg);
                }
                ArrayList childConditionKeyList = new ArrayList(1);
                childConditionKeyList.add(childConditionExpressionList.get(tempIndex));
                expressionLists.add(childConditionKeyList);
                ++index;
            } else if (FormulaUtils.isTempVariableDataType((String)node.getNodeText())) {
                this.checkTempVariable(node, conditionExpression.getConditionEnum());
                if (expressionList.size() > 0) {
                    tempVariableExpList = new ArrayList<Expression>();
                    tempVariableExpList.addAll(expressionList);
                    expressionLists.add(tempVariableExpList);
                    expressionList.clear();
                }
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                tempDataTypeNode = node;
                ++index;
            } else if (FormulaUtils.isOutputCondition((ConditionEnum)conditionEnum) && FormulaUtils.isVRAssignmentKey((String)node.getNodeText(), (String)nextNodeText, (String)var16_16)) {
                if (expressionList.size() > 0) {
                    tempVariableExpList = new ArrayList();
                    tempVariableExpList.addAll(expressionList);
                    expressionLists.add(tempVariableExpList);
                    expressionList.clear();
                }
                this.checkVrItemAndAddExpression(node, formula, expressionList, false);
                previousType = this.checkIsSameExpressType(previousType, "assType", node);
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                ++index;
            } else if (FormulaUtils.isVRItem((String)node.getNodeText())) {
                this.checkVrItemAndAddItemData(tempDataTypeNode, node, formula, (String)var16_16);
                this.checkVrItemAndAddExpression(node, formula, expressionList, tempDataTypeNode == null);
                previousType = this.checkIsSameExpressType(previousType, "assType", node);
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                ++index;
            } else {
                if (!FormulaUtils.isOutputCondition((ConditionEnum)conditionEnum) && FormulaUtils.isResultKey((String)node.getNodeText())) {
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u4f4d\u7f6e\u4e0d\u5bf9\uff0c\u6761\u4ef6\u5173\u952e\u5b57\u540e\u9762\u4e0d\u80fd\u662f\u7ed3\u679c\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_4", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
                }
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u672a\u5b9a\u4e49\u7684\u5173\u952e\u5b57\u201c{2}\u201d\u3002", (String)"FormulaParseHelper_0", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
            if (index != length || expressionList.size() <= 0) continue;
            expressionLists.add(expressionList);
        }
        Expression expression = null;
        for (List list : expressionLists) {
            if (list.size() == 1) {
                expression = (Expression)list.get(0);
            } else {
                CalExpression calExp = new CalExpression();
                calExp.setParameter(list);
                expression = calExp;
            }
            expList.add(expression);
        }
        return expList;
    }

    private void checkTempVariable(OriginalNode node, ConditionEnum conditionEnum) {
        if (conditionEnum == null) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b9a\u4e49\u53d8\u91cf\u6570\u636e\u7c7b\u578b[{2}]\u4f4d\u7f6e\u4e0d\u5bf9\u3002\u5b9a\u4e49\u53d8\u91cf\u8bed\u53e5\u53ea\u80fd\u653e\u5728\u516c\u5f0f\u5f00\u5934\uff0c\u4e0d\u80fd\u5728\u6761\u4ef6\u8bed\u53e5\u4e2d\u5b9a\u4e49\u53d8\u91cf\u3002", (String)"FormulaParseHelper_50", (String)SYSTEMTYPE, (Object[])new Object[0]);
        throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
    }

    private void checkVrItemAndAddItemData(OriginalNode tempDataTypeNode, OriginalNode node, FormulaInfo formula, String preNodeText) {
        if (tempDataTypeNode == null) {
            return;
        }
        if (SWCStringUtils.isNotEmpty((String)preNodeText) && !FormulaUtils.isTempVariableDataType((String)preNodeText)) {
            return;
        }
        String nodeText = FormulaUtils.subStringNodetext((String)node.getNodeText());
        if (formula.getVrItemMap().containsKey(nodeText)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e34\u65f6\u53d8\u91cf[{2}]\u91cd\u590d\uff0c\u540c\u4e00\u4e2a\u516c\u5f0f\u4e2d\u5b9a\u4e49\u7684\u53d8\u91cf\u540d\u79f0\u4e0d\u80fd\u76f8\u540c\u3002", (String)"FormulaParseHelper_43", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        HashMap<String, String> vrDataMap = new HashMap<String, String>(3);
        String uniqueCode = VRITEM_NAME + formula.getVrUniqueCodeSet().size();
        vrDataMap.put("uniquecode", uniqueCode);
        vrDataMap.put("name", nodeText);
        vrDataMap.put("datatype", tempDataTypeNode.getNodeText());
        formula.addVrUniqueCode(uniqueCode);
        formula.addVRItemDataToMap(nodeText, vrDataMap);
        this.spAndVrItemInfoMap.put(uniqueCode, tempDataTypeNode.getNodeText());
    }

    private void checkVrItemAndAddExpression(OriginalNode node, FormulaInfo formula, List<Expression> expressionList, boolean isResult) {
        String nodeText = FormulaUtils.subStringNodetext((String)node.getNodeText());
        Map<String, Object> tempResultMap = this.getResultMapByItemType("VR", formula, nodeText);
        if (null == tempResultMap) {
            throw new KDBizException(MessageFormat.format(this.getItemIsNotExistMsg("VR"), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        if (isResult) {
            ItemExpression vrExpression = new ItemExpression(node);
            vrExpression.setItemType("VR");
            vrExpression.setItemInfoMap(tempResultMap);
            expressionList.add((Expression)vrExpression);
        } else {
            AssExpression assExpression = new AssExpression(ExpressionNodeTypeEnum.ASS, node);
            assExpression.setItemInfoMap(tempResultMap);
            assExpression.setItemType("VR");
            expressionList.add((Expression)assExpression);
        }
    }

    private void addSpItemInfoToMap(OriginalNode node, FormulaInfo formula) {
        String nodeText = FormulaUtils.subStringNodetext((String)node.getNodeText());
        Map itemInfoMap = (Map)formula.getSpItemMap().get(nodeText);
        String uniqueCode = MapUtils.getString((Map)itemInfoMap, (Object)"uniquecode");
        String dataTypeStr = MapUtils.getString((Map)itemInfoMap, (Object)"datatype");
        this.spAndVrItemInfoMap.put(uniqueCode, dataTypeStr);
    }

    private void checkAssItemAndAddAssExpression(OriginalNode node, FormulaInfo formula, List<Expression> expressionList, boolean isResult) throws KDBizException {
        String nodeText = FormulaUtils.subStringNodetext((String)node.getNodeText());
        Map<String, Object> tempResultMap = this.getResultMapByItemType("SP", formula, nodeText);
        if (null == tempResultMap) {
            throw new KDBizException(MessageFormat.format(this.getItemIsNotExistMsg("SP"), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        node.setUniqueKey("SP[" + tempResultMap.get("uniquecode") + "]");
        if (isResult) {
            ItemExpression spExpression = new ItemExpression(node);
            spExpression.setItemInfoMap(tempResultMap);
            spExpression.setItemType("SP");
            expressionList.add((Expression)spExpression);
        } else {
            AssExpression assExpression = new AssExpression(node);
            assExpression.setItemInfoMap(tempResultMap);
            assExpression.setItemType("SP");
            expressionList.add((Expression)assExpression);
        }
        this.addUniqueCodeByItemType(tempResultMap, "SP", formula);
    }

    private void checkItemAndAddItemExpression(OriginalNode node, String itemType, FormulaInfo formula, List<Expression> expressionList) throws KDBizException {
        String nodeText;
        String bsPropItemName = null;
        String bsPropName = null;
        if (node.isBsPropItemNode()) {
            String[] itemArr = node.getNodeText().split("\\.");
            nodeText = FormulaUtils.subStringNodetext((String)itemArr[0]);
            bsPropName = itemArr[1].substring(1, itemArr[1].length() - 1);
            bsPropItemName = nodeText + "_@_" + bsPropName;
        } else {
            nodeText = FormulaUtils.subStringNodetext((String)node.getNodeText());
        }
        Map<String, Object> tempResultMap = this.getResultMapByItemType(itemType, formula, nodeText);
        if (null == tempResultMap) {
            throw new KDBizException(MessageFormat.format(this.getItemIsNotExistMsg(itemType), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        if (node.isBsPropItemNode() && null == (tempResultMap = this.getResultMapByItemType("bspropitemkey", formula, bsPropItemName))) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e1a\u52a1\u9879\u76ee[{2}]\u7684\u5c5e\u6027\u201c{3}\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_66", (String)SYSTEMTYPE, (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText, bsPropName));
        }
        if (!formula.isProrateItemFormula() && "SL".equals(itemType) && SWCStringUtils.equals((String)nodeText, (String)formula.getSalaryItem().getName())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u85aa\u916c\u9879\u76ee[{2}]\u7ef4\u62a4\u9519\u8bef\uff0c\u4e0d\u80fd\u4f7f\u7528\u516c\u5f0f\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u85aa\u916c\u9879\u76ee\u3002", (String)"FormulaParseHelper_27", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, nodeText));
        }
        if ("VR".equalsIgnoreCase(itemType)) {
            node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
        } else if (node.isBsPropItemNode()) {
            node.setUniqueKey(itemType + "[" + tempResultMap.get("bizItemUiqueCode") + "]" + OperatorEnum.FULLSTOP.getAlias() + "[" + tempResultMap.get("uniquecode") + "]");
        } else {
            node.setUniqueKey(itemType + "[" + tempResultMap.get("uniquecode") + "]");
        }
        ItemExpression itemExpression = new ItemExpression(node);
        itemExpression.setItemInfoMap(tempResultMap);
        itemExpression.setItemType(itemType);
        expressionList.add((Expression)itemExpression);
        if (node.isBsPropItemNode()) {
            this.addUniqueCodeByItemType(tempResultMap, "bspropitemkey", formula);
        } else {
            this.addUniqueCodeByItemType(tempResultMap, itemType, formula);
        }
    }

    private String getItemIsNotExistMsg(String itemType) {
        String errorMsg = null;
        switch (itemType) {
            case "SL": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u85aa\u916c\u9879\u76ee[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_32", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
            case "BS": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e1a\u52a1\u9879\u76ee[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_34", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
            case "SP": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u652f\u6301\u9879\u76ee[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_36", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
            case "AC": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7d2f\u52a0\u5668[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_54", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
            case "VR": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e34\u65f6\u53d8\u91cf[{2}]\u672a\u5b9a\u4e49\u3002", (String)"FormulaParseHelper_40", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
            case "FT": {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u53d6\u6570\u9879\u76ee[{2}]\u672a\u5b9a\u4e49\u3002", (String)"FormulaParseHelper_47", (String)SYSTEMTYPE, (Object[])new Object[0]);
                break;
            }
        }
        return errorMsg;
    }

    private void addUniqueCodeByItemType(Map<String, Object> resultMap, String itemType, FormulaInfo formula) {
        switch (itemType) {
            case "BS": {
                formula.addBsUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
            case "SL": {
                formula.addSlUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
            case "SP": {
                formula.addSpUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
            case "AC": {
                formula.addAcUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
            case "FT": {
                formula.addFtUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
            case "bspropitemkey": {
                formula.addBsUniqueCode((String)resultMap.get("bizItemUiqueCode"));
                formula.addBspUniqueCode((String)resultMap.get("uniquecode"));
                break;
            }
        }
    }

    private Map<String, Object> getResultMapByItemType(String itemType, FormulaInfo formula, String nodeText) {
        Map resultMap = null;
        switch (itemType) {
            case "SL": {
                resultMap = (Map)formula.getSlItemMap().get(nodeText);
                break;
            }
            case "BS": {
                resultMap = (Map)formula.getBsItemMap().get(nodeText);
                break;
            }
            case "SP": {
                resultMap = (Map)formula.getSpItemMap().get(nodeText);
                break;
            }
            case "AC": {
                resultMap = (Map)formula.getAcMap().get(nodeText);
                break;
            }
            case "VR": {
                resultMap = (Map)formula.getVrItemMap().get(nodeText);
                break;
            }
            case "FT": {
                resultMap = (Map)formula.getFtMap().get(nodeText);
                break;
            }
            case "bspropitemkey": {
                resultMap = (Map)formula.getBsPropItemMap().get(nodeText);
                break;
            }
        }
        return resultMap;
    }

    private String checkIsSameExpressType(String previousType, String currentType, OriginalNode node) throws KDBizException {
        if (previousType == null) {
            return currentType;
        }
        if (SWCStringUtils.equals((String)previousType, (String)currentType) && !SWCStringUtils.equals((String)"operatorType", (String)previousType)) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u9879\u76ee\u3001\u51fd\u6570\u3001\u5b57\u7b26\u4e32\u3001\u6570\u5b57\u3001NULL\u7b49\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\uff0c\u4e2d\u95f4\u5fc5\u987b\u6709\u8fd0\u7b97\u7b26\u53f7\u3001\u6761\u4ef6\u5173\u952e\u5b57\u3002", (String)"FormulaParseHelper_14", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        return currentType;
    }

    private Map<String, Object> getDataGradeMap(int index, List<OriginalNode> nodes, Map<String, Map<String, Object>> dmMap, String gradeName) {
        if (CollectionUtils.isEmpty(dmMap)) {
            return null;
        }
        int size = nodes.size();
        OriginalNode resultNode = null;
        int leftParentCount = 0;
        ++index;
        while (index < size) {
            OriginalNode currentNode = nodes.get(index);
            if (OperatorEnum.LPARENTHESES.getAlias().equals(currentNode.getNodeText()) || OperatorEnum.LPARENTHESES_CN.getAlias().equals(currentNode.getNodeText())) {
                ++leftParentCount;
                ++index;
                continue;
            }
            if (OperatorEnum.RPARENTHESES.getAlias().equals(currentNode.getNodeText()) || OperatorEnum.RPARENTHESES_CN.getAlias().equals(currentNode.getNodeText())) {
                if (index >= 2 && leftParentCount == 1) {
                    OriginalNode beforeNode = nodes.get(index - 2);
                    if (OperatorEnum.COMMA.getAlias().equals(beforeNode.getNodeText()) || OperatorEnum.COMMA_CN.getAlias().equals(beforeNode.getNodeText())) {
                        resultNode = nodes.get(index - 1);
                        break;
                    }
                }
                --leftParentCount;
            }
            ++index;
        }
        if (resultNode == null) {
            return null;
        }
        return dmMap.get(gradeName + "_" + resultNode.getNodeText());
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getFunctionExpression(FunExpression expression, List<OriginalNode> nodes, int index, FormulaInfo formula) throws KDBizException {
        OriginalNode function = nodes.get(index);
        int endIndex = 0;
        String errorMsg = null;
        OriginalNode firstNode = nodes.get(++index);
        Map<String, Object> temResultMap = null;
        if (!OperatorEnum.LPARENTHESES.getAlias().equals(firstNode.getNodeText()) && !"\uff08".equals(firstNode.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseHelper_3", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1, function.getNodeText()));
        }
        firstNode.setUniqueKey(OperatorEnum.LPARENTHESES.getAlias());
        int num = index + 1;
        int len = nodes.size();
        while (num < len) {
            OriginalNode node = nodes.get(num);
            if (OperatorEnum.RPARENTHESES.getAlias().equals(node.getNodeText()) || "\uff09".equals(node.getNodeText())) {
                node.setUniqueKey(OperatorEnum.RPARENTHESES.getAlias());
                break;
            }
            if (OperatorEnum.COMMA.getAlias().equals(node.getNodeText()) || "\uff0c".equals(node.getNodeText())) {
                node.setUniqueKey(OperatorEnum.COMMA.getAlias());
                temResultMap = this.getParamExp(nodes, num + 1, formula, function);
                expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
                endIndex = (Integer)temResultMap.get(ENDINDEX);
                num = endIndex + 1;
                continue;
            }
            if (num != index + 1) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u5b58\u5728\u9519\u8bef\u7684\u53c2\u6570[{3}]\u3002", (String)"FormulaParseHelper_1", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText(), node.getNodeText()));
            }
            temResultMap = this.getParamExp(nodes, num, formula, function);
            expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
            endIndex = (Integer)temResultMap.get(ENDINDEX);
            num = endIndex + 1;
        }
        if (num >= len) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseHelper_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        OriginalNode lastNode = nodes.get(num);
        if (!OperatorEnum.RPARENTHESES.getAlias().equals(lastNode.getNodeText()) && !"\uff09".equals(lastNode.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseHelper_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        endIndex = num;
        this.checkFuncParams(expression, formula);
        return endIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDataGradeExpression(DataGradeExpression expression, List<OriginalNode> nodes, int index, FormulaInfo formula, String gradeName) throws KDBizException {
        OriginalNode datagrade = nodes.get(index);
        int endIndex = 0;
        String errorMsg = null;
        OriginalNode firstNode = nodes.get(++index);
        Map<String, Object> temResultMap = null;
        if (!OperatorEnum.LPARENTHESES.getAlias().equals(firstNode.getNodeText()) && !"\uff08".equals(firstNode.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7[{2}]\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FormulaParseHelper_42", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1, datagrade.getNodeText()));
        }
        firstNode.setUniqueKey(OperatorEnum.LPARENTHESES.getAlias());
        int num = index + 1;
        int len = nodes.size();
        while (num < len) {
            OriginalNode node = nodes.get(num);
            if (node.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias()) || "\uff09".equals(node.getNodeText())) {
                node.setUniqueKey(OperatorEnum.RPARENTHESES.getAlias());
                break;
            }
            if (node.getNodeText().equals(OperatorEnum.COMMA.getAlias()) || "\uff0c".equals(node.getNodeText())) {
                Map allDmInfoMap;
                Map resultMap;
                node.setUniqueKey(OperatorEnum.COMMA.getAlias());
                OriginalNode nextNode = nodes.get(num + 1);
                String nextNodeText = nextNode.getNodeText();
                OriginalNode rightLessNode = null;
                if (num + 2 < nodes.size()) {
                    rightLessNode = nodes.get(num + 2);
                }
                if ((resultMap = (Map)(allDmInfoMap = formula.getDmMap()).get(gradeName + "_" + nextNodeText)) != null && resultMap.size() > 0 && rightLessNode != null && (rightLessNode.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias()) || "\uff09".equals(rightLessNode.getNodeText()))) {
                    NumExpression numExpression;
                    nextNode.setUniqueKey(nextNode.getNodeText());
                    rightLessNode.setUniqueKey(OperatorEnum.RPARENTHESES.getAlias());
                    String resultValType = (String)resultMap.get("resultValType");
                    if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.TEXT.getCode(), (String)resultValType)) {
                        StrExpression strExpression = new StrExpression(nextNode);
                        expression.setResult((Expression)strExpression);
                    } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.AMOUNT.getCode(), (String)resultValType)) {
                        numExpression = new NumExpression(nextNode);
                        expression.setResult((Expression)numExpression);
                    } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DECIMAL.getCode(), (String)resultValType)) {
                        numExpression = new NumExpression(nextNode);
                        expression.setResult((Expression)numExpression);
                    } else if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DATE.getCode(), (String)resultValType)) {
                        DateExpression dateExpression = new DateExpression(nextNode);
                        expression.setResult((Expression)dateExpression);
                    }
                    num += 2;
                    continue;
                }
                temResultMap = this.getParamExp(nodes, num + 1, formula, datagrade);
                expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
                endIndex = (Integer)temResultMap.get(ENDINDEX);
                num = endIndex + 1;
                continue;
            }
            if (num != index + 1) {
                errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u5b58\u5728\u9519\u8bef\u7684\u53c2\u6570[{3}]\u3002", (String)"FormulaParseHelper_1", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, datagrade.getLineIndex() + 1, datagrade.getStartColumnIndex() + 1, datagrade.getNodeText(), node.getNodeText()));
            }
            temResultMap = this.getParamExp(nodes, num, formula, datagrade);
            expression.addParameter((Expression)temResultMap.get(EXPRESSIONFLAG));
            endIndex = (Integer)temResultMap.get(ENDINDEX);
            num = endIndex + 1;
        }
        if (num >= len) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseHelper_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, datagrade.getLineIndex() + 1, datagrade.getStartColumnIndex() + 1, datagrade.getNodeText()));
        }
        OriginalNode lastNode = nodes.get(num);
        if (!lastNode.getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias()) && !OperatorEnum.RPARENTHESES_CN.getAlias().equals(lastNode.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7f3a\u5931\u53f3\u62ec\u53f7\u3002", (String)"FormulaParseHelper_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, datagrade.getLineIndex() + 1, datagrade.getStartColumnIndex() + 1, datagrade.getNodeText()));
        }
        endIndex = num;
        this.checkDataGradeParams(expression, formula);
        return endIndex;
    }

    private void checkFuncParams(FunExpression expression, FormulaInfo formula) throws KDBizException {
        OriginalNode funcNode = expression.getFunction();
        List parameters = expression.getParameter();
        Map fcMap = formula.getFcMap();
        Map funcMap = (Map)fcMap.get(FormulaUtils.subStringNodetext((String)funcNode.getNodeText()));
        List paramMap = (List)funcMap.get("entryentity");
        String errorMsg = null;
        if (parameters.size() != paramMap.size()) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7684\u53c2\u6570\u6709{3}\u4e2a\uff0c\u7ef4\u62a4\u4e86{4}\u4e2a\uff0c\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseHelper_17", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, funcNode.getLineIndex() + 1, funcNode.getStartColumnIndex() + 1, funcNode.getNodeText(), paramMap.size(), parameters.size()));
        }
    }

    private void checkDataGradeParams(DataGradeExpression expression, FormulaInfo formula) throws KDBizException {
        OriginalNode datagradeNode = expression.getDataGrade();
        List parameters = expression.getParameter();
        Map dmMap = formula.getDmMap();
        String errorMsg = null;
        int conditionCount = this.getDataGradeConditionCount(dmMap, FormulaUtils.subStringNodetext((String)datagradeNode.getNodeText()));
        if (parameters.size() != conditionCount) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7[{2}]\u7684\u53c2\u6570\u6709{3}\u4e2a\uff0c\u7ef4\u62a4\u4e86{4}\u4e2a\uff0c\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseHelper_46", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, datagradeNode.getLineIndex() + 1, datagradeNode.getStartColumnIndex() + 1, datagradeNode.getNodeText(), conditionCount, parameters.size()));
        }
    }

    private int getDataGradeConditionCount(Map<String, Map<String, Object>> dmMap, String nodeName) {
        for (Map.Entry<String, Map<String, Object>> entry : dmMap.entrySet()) {
            List conditionList;
            Map<String, Object> resultMap = entry.getValue();
            String gradeName = (String)resultMap.get("gradeName");
            if (!SWCStringUtils.equals((String)nodeName, (String)gradeName) || (conditionList = (List)resultMap.get("conditionList")) == null || conditionList.size() <= 0) continue;
            return conditionList.size();
        }
        return 0;
    }

    private Map<String, Object> getParamExp(List<OriginalNode> nodes, int index, FormulaInfo formula, OriginalNode function) throws KDBizException {
        OriginalNode node;
        ArrayList<Expression> subExpList = new ArrayList<Expression>(nodes.size());
        int endIndex = 0;
        int lpress = 0;
        int rpress = 0;
        int num = index;
        ArrayList<OriginalNode> lParenyhesesList = new ArrayList<OriginalNode>(10);
        String errorMsg = null;
        Map<String, Object> tempResultMap = null;
        int len = nodes.size();
        String previousType = null;
        while (num < len) {
            node = nodes.get(num);
            if (lpress == rpress && (OperatorEnum.RPARENTHESES.getAlias().equals(node.getNodeText()) || OperatorEnum.COMMA.getAlias().equals(node.getNodeText()) || "\uff09".equals(node.getNodeText()) || "\uff0c".equals(node.getNodeText()))) {
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                break;
            }
            if (OperatorEnum.LPARENTHESES.getAlias().equals(node.getNodeText()) || "\uff08".equals(node.getNodeText())) {
                node.setUniqueKey(OperatorEnum.LPARENTHESES.getAlias());
                lParenyhesesList.add(node);
                subExpList.add((Expression)new OperatorExpression(node));
                ++lpress;
                ++num;
                continue;
            }
            if (OperatorEnum.RPARENTHESES.getAlias().equals(node.getNodeText()) || "\uff09".equals(node.getNodeText())) {
                node.setUniqueKey(OperatorEnum.RPARENTHESES.getAlias());
                subExpList.add((Expression)new OperatorExpression(node));
                ++rpress;
                ++num;
                continue;
            }
            if (FormulaUtils.isFunction((String)node.getNodeText())) {
                tempResultMap = (Map<String, Object>)formula.getFcMap().get(FormulaUtils.subStringNodetext((String)node.getNodeText()));
                if (null == tempResultMap) {
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_31", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodetext((String)node.getNodeText())));
                }
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                FunExpression expression = new FunExpression(node);
                expression.setFuncInfoMap(tempResultMap);
                int tmpEndIndex = this.getFunctionExpression(expression, nodes, num, formula);
                subExpList.add((Expression)expression);
                formula.addFcUniqueCode((String)tempResultMap.get("uniquecode"));
                node.setUniqueKey("FC[" + tempResultMap.get("uniquecode") + "]");
                num = tmpEndIndex + 1;
                continue;
            }
            if (FormulaUtils.isDataGrade((String)node.getNodeText())) {
                String gradeName = FormulaUtils.subStringNodetext((String)node.getNodeText());
                tempResultMap = this.getDataGradeMap(num, nodes, formula.getDmMap(), gradeName);
                if (null == tempResultMap) {
                    errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u9879\u76ee[{2}]\u4e0d\u5b58\u5728\u3002", (String)"FormulaParseHelper_41", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, FormulaUtils.subStringNodetext((String)node.getNodeText())));
                }
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                formula.addDmUniqueCode("BR_" + tempResultMap.get("gradeNumber"));
                node.setUniqueKey("BR[" + tempResultMap.get("uniquecode") + "]");
                DataGradeExpression expression = new DataGradeExpression(node);
                expression.setDMInfoMap(tempResultMap);
                int tmpEndIndex = this.getDataGradeExpression(expression, nodes, num, formula, gradeName);
                subExpList.add((Expression)expression);
                num = tmpEndIndex + 1;
                continue;
            }
            if (FormulaUtils.isSalaryItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "SL", formula, subExpList);
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                ++num;
                continue;
            }
            if (FormulaUtils.isFTItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "FT", formula, subExpList);
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                ++num;
                continue;
            }
            if (FormulaUtils.isBSItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "BS", formula, subExpList);
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                ++num;
                continue;
            }
            if (FormulaUtils.isAcc((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "AC", formula, subExpList);
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                ++num;
                continue;
            }
            if (FormulaUtils.isSPItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "SP", formula, subExpList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                this.addSpItemInfoToMap(node, formula);
                ++num;
                continue;
            }
            if (FormulaUtils.isVRItem((String)node.getNodeText())) {
                this.checkItemAndAddItemExpression(node, "VR", formula, subExpList);
                previousType = this.checkIsSameExpressType(previousType, "otherType", node);
                ++num;
                continue;
            }
            if (FormulaUtils.isString((String)node.getNodeText())) {
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                subExpList.add((Expression)new StrExpression(node));
                ++num;
                continue;
            }
            if (FormulaUtils.isOperation((String)node.getNodeText())) {
                previousType = this.checkParamsExpressionType(previousType, "operatorType", node, function);
                subExpList.add((Expression)new OperatorExpression(node));
                node.setUniqueKey(node.getFormatNodeText() == null ? node.getNodeText() : node.getFormatNodeText());
                ++num;
                continue;
            }
            if (FormulaUtils.isNumber((String)node.getNodeText())) {
                previousType = this.checkParamsExpressionType(previousType, "otherType", node, function);
                subExpList.add((Expression)new NumExpression(node));
                node.setUniqueKey(node.getNodeText());
                ++num;
                continue;
            }
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u672a\u5b9a\u4e49\u7684\u5173\u952e\u5b57\u201c{2}\u201d\u3002", (String)"FormulaParseHelper_0", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (lpress > rpress) {
            node = (OriginalNode)lParenyhesesList.get(0);
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u5b58\u5728\u4e0d\u5339\u914d\u7684\u7b26\u53f7\u201c{2}\u201d\u3002", (String)"FormulaParseHelper_30", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (lpress < rpress) {
            node = (OriginalNode)lParenyhesesList.get(lParenyhesesList.size() - 1);
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u5b58\u5728\u4e0d\u5339\u914d\u7684\u7b26\u53f7\u201c{2}\u201d\u3002", (String)"FormulaParseHelper_30", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        endIndex = num - 1;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        if (subExpList.size() == 0) {
            String expressionType = this.getErrorConditionExpressionType(nodes, num);
            errorMsg = SWCStringUtils.equals((String)expressionType, (String)"BR") ? ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7[{2}]\u7684\u53c2\u6570\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseHelper_53", (String)SYSTEMTYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7684\u53c2\u6570\u586b\u5199\u4e0d\u6b63\u786e\u3002", (String)"FormulaParseHelper_11", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, function.getLineIndex() + 1, function.getStartColumnIndex() + 1, function.getNodeText()));
        }
        if (subExpList.size() == 1) {
            resultMap.put(EXPRESSIONFLAG, subExpList.get(0));
        } else {
            CalExpression calExp = new CalExpression();
            calExp.setParameter(subExpList);
            resultMap.put(EXPRESSIONFLAG, calExp);
        }
        resultMap.put(ENDINDEX, endIndex);
        return resultMap;
    }

    private String getErrorConditionExpressionType(List<OriginalNode> nodes, int index) {
        while (index >= 0) {
            OriginalNode node = nodes.get(index);
            if (node.getNodeText().startsWith("BR")) {
                return "BR";
            }
            if (node.getNodeText().startsWith("FC")) {
                return "FC";
            }
            --index;
        }
        return "FC";
    }

    private String checkParamsExpressionType(String previousType, String currentType, OriginalNode node, OriginalNode funcNode) throws KDBizException {
        if (SWCStringUtils.isEmpty((String)previousType)) {
            return currentType;
        }
        if (SWCStringUtils.equals((String)previousType, (String)currentType)) {
            String errorMsg = null;
            errorMsg = SWCStringUtils.equals((String)currentType, (String)"otherType") ? ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7684\u53c2\u6570\u201c{3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u9879\u76ee\u3001\u51fd\u6570\u3001\u5b57\u7b26\u4e32\u3001\u6570\u5b57\u7b49\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\u3002", (String)"FormulaParseHelper_23", (String)SYSTEMTYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570[{2}]\u7684\u8fd0\u7b97\u7b26\u53f7\u201c{3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e\uff0c\u8fd0\u7b97\u7b26\u53f7\u5173\u952e\u5b57\u4e0d\u80fd\u8fde\u7eed\u51fa\u73b0\u3002", (String)"FormulaParseHelper_24", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, funcNode.getLineIndex() + 1, funcNode.getStartColumnIndex() + 1, funcNode.getNodeText(), node.getNodeText()));
        }
        return currentType;
    }

    private void parseAndBuildExecuteExp(FormulaInfo formula, List<ConditionExpression> conditionExpList) throws KDBizException {
        String resultItemName;
        String itemUniqueCode;
        SalaryItem item = formula.getSalaryItem();
        StringBuilder resultCode = new StringBuilder();
        StringBuilder returnCode = new StringBuilder();
        DataTypeEnum type = item.getType();
        String typeStr = this.getDefineType(type);
        if (formula.isProrateItemFormula()) {
            itemUniqueCode = formula.getId();
            resultItemName = PRE_VAR_NAME + formula.getId();
        } else {
            itemUniqueCode = item.getUniquecode();
            resultItemName = itemUniqueCode.replace('.', '_').replace('-', '_');
        }
        returnCode.append("    ").append(String.format(Locale.ROOT, "if(isNotNeedHandled(\"%s\")) {", itemUniqueCode)).append('\n');
        returnCode.append("    ").append("    ").append("return;").append('\n');
        returnCode.append("    ").append('}').append('\n');
        returnCode.append("    ").append(String.format(Locale.ROOT, typeStr, resultItemName)).append('\n');
        returnCode.append("    ").append(String.format(Locale.ROOT, "setSalaryItemUniqueCode(\"%s\");", itemUniqueCode)).append('\n');
        resultCode.append("    ").append(String.format(Locale.ROOT, "List itemSectionList =  getItemSectionList(\"%s\");", itemUniqueCode)).append('\n');
        resultCode.append("    ").append("String sectionKey = null;").append('\n');
        resultCode.append("    ").append("for(int index=0;index<itemSectionList.size();index++) {").append('\n');
        resultCode.append("    ").append("    ").append("sectionKey = (String)itemSectionList.get(index);").append('\n');
        resultCode.append("    ").append("    ").append("setCurrentSectionKey(sectionKey);").append('\n');
        resultCode.append("    ").append("    ").append(resultItemName).append(" = null;").append('\n');
        ConditionEnum preConditionEnum = null;
        for (ConditionExpression conditionExpression : conditionExpList) {
            this.getResultExpression(formula, resultCode, itemUniqueCode, resultItemName, conditionExpression, preConditionEnum);
            preConditionEnum = conditionExpression.getConditionEnum();
        }
        this.validatorResultExp(formula.getResultCount());
        resultCode.append('\n');
        resultCode.append("    ").append("    ").append(String.format("addResultValue(\"%s\",%s,sectionKey);\n", itemUniqueCode, resultItemName));
        resultCode.append("    ").append("}\n");
        resultCode.append("    ").append(String.format(Locale.ROOT, "sumItemResultValue(\"%s\");", itemUniqueCode));
        this.addSPItemOrVRItemCode(formula.getSpUniqueCodeSet(), returnCode, "SP");
        this.addSPItemOrVRItemCode(formula.getVrUniqueCodeSet(), returnCode, "VR");
        returnCode.append((CharSequence)resultCode);
        formula.setExecuteCode(returnCode.toString());
    }

    private void addSPItemOrVRItemCode(Set<String> uniqueCodeSet, StringBuilder returnCode, String itemType) {
        if (uniqueCodeSet == null || uniqueCodeSet.size() == 0) {
            return;
        }
        for (String uniqueCode : uniqueCodeSet) {
            String dataTypeStr = this.spAndVrItemInfoMap.get(uniqueCode);
            if (dataTypeStr == null) continue;
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dataTypeStr);
            returnCode.append("    ").append(String.format(Locale.ROOT, this.getDefineType(dataType), uniqueCode)).append('\n');
            if (!SWCStringUtils.equals((String)itemType, (String)"SP")) continue;
            String expCode = String.format(this.getSPItemDefineCode(dataType), uniqueCode, uniqueCode, uniqueCode);
            returnCode.append(expCode).append('\n');
        }
    }

    private void validatorResultExp(int resultCount) {
        if (resultCount < 1) {
            String errorMsg = ResManager.loadKDString((String)"\u516c\u5f0f\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u201cRESULT\u201d\u8bed\u53e5\u3002", (String)"FormulaParseHelper_38", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }

    private void getAssItemMap(ResultExpression resultExp) {
        AssExpression exp = (AssExpression)resultExp.getOriginalExp();
        resultExp.setCode(resultExp.getCode() + ";\n");
        if (!"SP".equals(exp.getItemType())) {
            return;
        }
        Map iteminfoMap = exp.getItemInfoMap();
        String uniqueCode = MapUtils.getString((Map)iteminfoMap, (Object)"uniquecode");
        resultExp.setCode(resultExp.getCode() + String.format("    addSPItemValue(\"%s\",%s);\n", uniqueCode, uniqueCode));
    }

    private String getSPItemDefineCode(DataTypeEnum type) {
        String typeStr = null;
        typeStr = type == DataTypeEnum.NUMBERIC ? "    %s=getSPItemValue(\"%s\") == null? null:new BigDecimal(getSPItemValue(\"%s\"));" : (type == DataTypeEnum.DATE ? "    %s=getSPItemValue(\"%s\") == null? null: parseDate(getSPItemValue(\"%s\"));" : "    %s=getSPItemValue(\"%s\")== null? null:getSPItemValue(\"%s\");");
        return typeStr;
    }

    private String getDefineType(DataTypeEnum type) {
        String typeStr = type == DataTypeEnum.NUMBERIC ? "BigDecimal %s = null;" : (type == DataTypeEnum.DATE ? "Date %s = null;" : "String %s = null;");
        return typeStr;
    }

    private void checkCondition(List<ConditionExpression> conditionExpList, FormulaInfo formula) throws KDBizException {
        int complex = 0;
        OriginalNode previousNode = null;
        OriginalNode firstConditionNode = null;
        for (int index = 0; index < conditionExpList.size(); ++index) {
            ConditionExpression conditionExp = conditionExpList.get(index);
            OriginalNode condition = conditionExp.getCondition();
            List expressionList = conditionExp.getExpressions();
            if (condition == null) {
                OriginalNode firstNode = (OriginalNode)expressionList.get(0);
                if (conditionExpList.size() == 1 && index == 0 && expressionList.size() < 3) {
                    if (FormulaUtils.isResultKey((String)firstNode.getNodeText())) {
                        return;
                    }
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u4e0d\u5b8c\u6574\uff0c\u9700\u8981\u5b8c\u6574\u7684\u7ed3\u679c\u8bed\u53e5\u3002", (String)"FormulaParseHelper_15", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, 1, 1));
                }
                if (FormulaUtils.isNullKey((String)firstNode.getNodeText())) {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u3002\u201cNULL\u201d\u53ea\u80fd\u7528\u4e8e\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_60", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, firstNode.getLineIndex() + 1, firstNode.getStartColumnIndex() + 1));
                }
                for (OriginalNode originalNode : expressionList) {
                    if (FormulaUtils.isExitKey((String)originalNode.getNodeText())) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201cEXIT\u201d\u4e0d\u53ef\u653e\u5728\u6761\u4ef6\u8bed\u53e5\u4e4b\u5916\u3002", (String)"FormulaParseHelper_57", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, originalNode.getLineIndex() + 1, originalNode.getStartColumnIndex() + 1));
                    }
                    if (!FormulaUtils.isNullKey((String)originalNode.getNodeText())) continue;
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u3002\u201cNULL\u201d\u53ea\u80fd\u7528\u4e8e\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_60", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, originalNode.getLineIndex() + 1, originalNode.getStartColumnIndex() + 1));
                }
                continue;
            }
            if (firstConditionNode == null) {
                firstConditionNode = condition;
            }
            String conditionNodeText = condition.getNodeText();
            if (index == conditionExpList.size() - 1 && !FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(conditionNodeText)) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e0d\u80fd\u4ee5\u201c{2}\u201d\u4f5c\u4e3a\u6700\u540e\u4e00\u4e2a\u6761\u4ef6\u5173\u952e\u5b57\u3002", (String)"FormulaParseHelper_19", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText()));
            }
            previousNode = this.checkConditionIsMatch(previousNode, condition);
            if (!CollectionUtils.isEmpty((Collection)conditionExp.getChildConditionExpressionList())) {
                this.checkCondition(conditionExp.getChildConditionExpressionList(), formula);
            }
            if (FormulaKeyEnum.IF.getCode().equalsIgnoreCase(conditionNodeText)) {
                ++complex;
            }
            if (FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(conditionNodeText)) {
                --complex;
            }
            OriginalNode lastExpressionNode = null;
            for (int expressionIndex = 0; expressionIndex < expressionList.size(); ++expressionIndex) {
                OriginalNode nextNode = (OriginalNode)expressionList.get(expressionIndex);
                String nodeText = nextNode.getNodeText();
                if (FormulaUtils.isExitKey((String)nodeText)) {
                    if (FormulaKeyEnum.IF.getCode().equalsIgnoreCase(conditionNodeText) || FormulaKeyEnum.ELSEIF.getCode().equalsIgnoreCase(conditionNodeText) || FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(conditionNodeText)) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u4e2d\u201cEXIT\u201d\u53ea\u80fd\u653e\u5728\u6761\u4ef6\u5173\u952e\u5b57\u201cTHEN\u201d/\u201cELSE\u201d\u4e4b\u540e\u3002", (String)"FormulaParseHelper_58", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1));
                    }
                    if (expressionIndex + 1 < expressionList.size()) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5728\u6761\u4ef6\u8bed\u53e5\u7684\u4e00\u4e2a\u8f93\u51fa\u533a\u6bb5\u4e2d\u201cEXIT\u201d\u540e\u4e0d\u80fd\u518d\u63a5\u5176\u4ed6\u5185\u5bb9\u3002", (String)"FormulaParseHelper_59", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1));
                    }
                } else if (FormulaUtils.isNullKey((String)nodeText)) {
                    String lastNodeText;
                    if (FormulaKeyEnum.ELSE.getCode().equalsIgnoreCase(conditionNodeText) || FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(conditionNodeText) || FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(conditionNodeText)) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\u3002\u201cNULL\u201d\u53ea\u80fd\u7528\u4e8e\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_60", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1));
                    }
                    String string = lastNodeText = lastExpressionNode == null ? null : lastExpressionNode.getNodeText();
                    if (SWCStringUtils.isEmpty((String)lastNodeText) || !OperatorEnum.EQUAL.getAlias().equals(lastNodeText) && !OperatorEnum.UNEQUAL.getAlias().equals(lastNodeText)) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0cNULL\u53ea\u80fd\u653e\u5728=\u3001!=\u53f3\u4fa7\u3002", (String)"FormulaParseHelper_61", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1));
                    }
                    if (expressionIndex + 1 < expressionList.size()) {
                        OriginalNode nextExpressionNode = null;
                        for (int tempIndex = expressionIndex + 1; tempIndex < expressionList.size(); ++tempIndex) {
                            OriginalNode tempNode = (OriginalNode)expressionList.get(tempIndex);
                            if (SWCStringUtils.equals((String)"(", (String)tempNode.getNodeText()) || "\uff08".equals(tempNode.getNodeText()) || SWCStringUtils.equals((String)")", (String)tempNode.getNodeText()) || "\uff09".equals(tempNode.getNodeText())) continue;
                            nextExpressionNode = tempNode;
                            break;
                        }
                        if (null != nextExpressionNode && !FormulaKeyEnum.AND.getCode().equalsIgnoreCase(nextExpressionNode.getNodeText()) && !FormulaKeyEnum.OR.getCode().equalsIgnoreCase(nextExpressionNode.getNodeText())) {
                            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0cNULL\u53ea\u80fd\u5355\u72ec\u53c2\u4e0e\u5224\u65ad\uff0c\u4e0d\u53ef\u5728\u5224\u65ad\u8868\u8fbe\u5f0f\u4e2d\u8fdb\u884c\u5176\u4ed6\u8ba1\u7b97\u3002", (String)"FormulaParseHelper_62", (String)SYSTEMTYPE, (Object[])new Object[0]);
                            throw new KDBizException(MessageFormat.format(errorMsg, nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1));
                        }
                    }
                } else if (FormulaUtils.isOutPutMessageFunction((String)nodeText, (FormulaInfo)formula) && (FormulaKeyEnum.IF.getCode().equalsIgnoreCase(conditionNodeText) || FormulaKeyEnum.ELSEIF.getCode().equalsIgnoreCase(conditionNodeText))) {
                    String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u4e2d\u6d88\u606f\u51fd\u6570\u53ea\u80fd\u653e\u5728\u6761\u4ef6\u5173\u952e\u5b57THEN/ELSE\u4e4b\u540e\u3002", (String)"FormulaParseHelper_69", (String)SYSTEMTYPE, (Object[])new Object[]{nextNode.getLineIndex() + 1, nextNode.getStartColumnIndex() + 1});
                    throw new KDBizException(msg);
                }
                lastExpressionNode = nextNode;
            }
        }
        if (firstConditionNode != null && !FormulaKeyEnum.IF.getCode().equalsIgnoreCase(firstConditionNode.getNodeText())) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5224\u65ad\u8bed\u53e5\u53ea\u80fd\u4ee5[IF]\u5f00\u59cb\u3002", (String)"FormulaParseHelper_9", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, firstConditionNode.getLineIndex() + 1, firstConditionNode.getStartColumnIndex() + 1));
        }
        if (complex != 0) {
            String errorMsg = complex > 0 ? ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u7684ENDIF\u5173\u952e\u5b57\u7f3a\u5c11\u4e86{1}\u4e2a,\u8bf7\u68c0\u67e5\u3002", (String)"FormulaParseHelper_7", (String)SYSTEMTYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u516c\u5f0f\u7684ENDIF\u5173\u952e\u5b57\u591a\u4f59\u4e86{1}\u4e2a,\u8bf7\u68c0\u67e5\u3002", (String)"FormulaParseHelper_8", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, Math.abs(complex)));
        }
    }

    private OriginalNode checkConditionIsMatch(OriginalNode previousNode, OriginalNode condition) throws KDBizException {
        if (previousNode == null) {
            return condition;
        }
        String errorMsg = null;
        if (FormulaKeyEnum.IF.getCode().equalsIgnoreCase(previousNode.getNodeText()) && !FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff0c\u201c{3}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{4}\u201d\u3002", (String)"FormulaParseHelper_22", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), FormulaKeyEnum.IF.getCode(), FormulaKeyEnum.THEN.getCode()));
        }
        if (FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(previousNode.getNodeText()) && FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff0c\u201c{3}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u53ef\u4ee5\u662f\u201c{4}\u201d\u3001\u201c{5}\u201d\u3001\u201c{6}\u201d\u3001\u201c{7}\u201d\u3002", (String)"FormulaParseHelper_25", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), FormulaKeyEnum.THEN.getCode(), FormulaKeyEnum.ELSEIF.getCode(), FormulaKeyEnum.ELSE.getCode(), FormulaKeyEnum.ENDIF.getCode(), FormulaKeyEnum.IF.getCode()));
        }
        if (FormulaKeyEnum.ELSEIF.getCode().equalsIgnoreCase(previousNode.getNodeText()) && !FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff0c\u201c{3}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{4}\u201d\u3002", (String)"FormulaParseHelper_26", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), FormulaKeyEnum.ELSEIF.getCode(), FormulaKeyEnum.THEN.getCode()));
        }
        if (FormulaKeyEnum.ELSE.getCode().equalsIgnoreCase(previousNode.getNodeText()) && FormulaKeyEnum.ELSE.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u7f3a\u5c11\u4e0e\u4e4b\u5339\u914d\u7684IF/ELSEIF\u3002", (String)"FormulaParseHelper_51", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText()));
        }
        if (FormulaKeyEnum.ELSE.getCode().equalsIgnoreCase(previousNode.getNodeText()) && !FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(condition.getNodeText()) && !FormulaKeyEnum.IF.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff0c\u201c{3}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{4}\u201d\u3001\u201c{5}\u201d\u3002", (String)"FormulaParseHelper_18", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), FormulaKeyEnum.ELSE.getCode(), FormulaKeyEnum.ENDIF.getCode(), FormulaKeyEnum.IF.getCode()));
        }
        if (FormulaKeyEnum.ENDIF.getCode().equalsIgnoreCase(previousNode.getNodeText()) && condition != null && FormulaKeyEnum.THEN.getCode().equalsIgnoreCase(condition.getNodeText())) {
            errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6b64\u5904\u4e0d\u80fd\u662f\u201c{2}\u201d\uff0c\u201c{3}\u201d\u540e\u9762\u7684\u6761\u4ef6\u5173\u952e\u5b57\u5fc5\u987b\u662f\u201c{4}\u201d\u3001\u201c{5}\u201d\u3001\u201c{6}\u201d\u3001\u201c{7}\u201d\u6216\u8005\u4e3a\u7a7a\u3002", (String)"FormulaParseHelper_28", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, condition.getLineIndex() + 1, condition.getStartColumnIndex() + 1, condition.getNodeText(), FormulaKeyEnum.ENDIF.getCode(), FormulaKeyEnum.IF.getCode(), FormulaKeyEnum.ELSEIF.getCode(), FormulaKeyEnum.ELSE.getCode(), FormulaKeyEnum.ENDIF.getCode()));
        }
        return condition;
    }

    /*
     * WARNING - void declaration
     */
    private List<Expression> transferExp(ConditionExpression conditionExpression, FormulaInfo formula) throws KDBizException {
        OriginalNode conditionNode = conditionExpression.getCondition();
        ConditionEnum conditionEnum = conditionExpression.getConditionEnum();
        List expressionList = conditionExpression.getExpressions();
        if (conditionEnum != null && expressionList.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u7f3a\u5c11\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_21", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText()));
        }
        int expressionSize = expressionList.size();
        boolean hasExit = FormulaUtils.isExitKey((String)((OriginalNode)expressionList.get(expressionSize - 1)).getNodeText());
        if (expressionSize == 1 && !hasExit) {
            OriginalNode node = (OriginalNode)expressionList.get(0);
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
        }
        if (expressionSize == 2 && !FormulaUtils.isTempVariableDataType((String)((OriginalNode)expressionList.get(0)).getNodeText())) {
            OriginalNode node1 = (OriginalNode)expressionList.get(0);
            OriginalNode node2 = (OriginalNode)expressionList.get(1);
            if (hasExit) {
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
            }
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2} {3}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_12", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText(), node2.getNodeText()));
        }
        if (conditionEnum == null || conditionEnum == ConditionEnum.ELSE || conditionEnum == ConditionEnum.THEN) {
            if (hasExit && expressionList.size() == 3 && !FormulaUtils.isTempVariableDataType((String)((OriginalNode)expressionList.get(0)).getNodeText())) {
                OriginalNode node1 = (OriginalNode)expressionList.get(0);
                OriginalNode node2 = (OriginalNode)expressionList.get(1);
                String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2} {3}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_12", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText(), node2.getNodeText()));
            }
            ArrayList originalNodeList = new ArrayList(10);
            ArrayList<OriginalNode> newOriginalNodes = new ArrayList<OriginalNode>(16);
            int len = expressionList.size();
            for (int index = 0; index < len; ++index) {
                void var14_24;
                String nodeText;
                OriginalNode node = (OriginalNode)expressionList.get(index);
                String nextNodeText = null;
                Object var14_25 = null;
                if (index + 1 < len) {
                    nextNodeText = ((OriginalNode)expressionList.get(index + 1)).getNodeText();
                }
                if (index > 0) {
                    String string = ((OriginalNode)expressionList.get(index - 1)).getNodeText();
                }
                if (FormulaUtils.isResultKey((String)(nodeText = node.getNodeText())) || this.isChildConditionKey(nodeText) || FormulaUtils.isTempVariableDataType((String)nodeText) || FormulaUtils.isSPAssignmentKey((String)nodeText, (String)nextNodeText) || FormulaUtils.isVRAssignmentKey((String)nodeText, (String)nextNodeText, (String)var14_24) || this.isSPAssignment(nodeText, (String)var14_24) || FormulaUtils.isExitKey((String)nodeText) || FormulaUtils.isOutPutMessageFunction((String)nodeText, (FormulaInfo)formula)) {
                    if (newOriginalNodes.size() > 0) {
                        originalNodeList.add(newOriginalNodes);
                    }
                    newOriginalNodes = new ArrayList(10);
                }
                if (SWCStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.EQUAL.getAlias()) && !FormulaUtils.isResultKey((String)var14_24) && !FormulaUtils.isSPItem((String)var14_24) && !FormulaUtils.isVRItem((String)var14_24)) {
                    String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u6216\u8d4b\u503c\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff0c\u201c=\u201d\u524d\u5fc5\u987b\u662fRESULT\u3001\u652f\u6301\u9879\u76ee\u6216\u53d8\u91cf\u3002", (String)"FormulaParseHelper_45", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1));
                }
                newOriginalNodes.add(node);
            }
            if (newOriginalNodes.size() > 0) {
                originalNodeList.add(newOriginalNodes);
            }
            ArrayList<Expression> expList = new ArrayList<Expression>(10);
            for (List list : originalNodeList) {
                void var14_30;
                OriginalNode node1 = (OriginalNode)list.get(0);
                OriginalNode node2 = null;
                String nodeText2 = null;
                if (list.size() >= 2) {
                    node2 = (OriginalNode)list.get(1);
                    nodeText2 = node2.getNodeText();
                }
                if (FormulaUtils.isResultKey((String)node1.getNodeText())) {
                    if (list.size() < 3) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
                    }
                    if (node2 != null && !OperatorEnum.EQUAL.getAlias().equals(nodeText2)) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u201c{2} {3}\u201d\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u4e3a\u201c{4} =\u201d\u3002", (String)"FormulaParseHelper_20", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node2.getLineIndex() + 1, node2.getStartColumnIndex() + 1, node1.getNodeText(), node2.getNodeText(), FormulaKeyEnum.RESULT.getCode()));
                    }
                    List<OriginalNode> list2 = this.getNewExpressionList(list);
                    conditionExpression.setExpressionNodes(list2);
                    conditionExpression.setIsResult(Boolean.TRUE);
                    node1.setKeyType(ExpressionNodeTypeEnum.RESULT);
                    node1.setUniqueKey(FormulaKeyEnum.RESULT.getCode());
                    if (node2 != null) {
                        node2.setUniqueKey(node2.getNodeText());
                    }
                    formula.addResultCount();
                } else if (FormulaUtils.isSPAssignmentKey((String)node1.getNodeText(), (String)nodeText2)) {
                    if (list.size() < 3) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
                    }
                    conditionExpression.setExpressionNodes(list);
                    conditionExpression.setIsResult(Boolean.FALSE);
                    node1.setKeyType(ExpressionNodeTypeEnum.ASS);
                    node1.setUniqueKey(node1.getNodeText());
                } else if (FormulaUtils.isTempVariableDataType((String)node1.getNodeText())) {
                    if (conditionEnum != null) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u53d8\u91cf[{2}]\u4e0d\u80fd\u5728\u6761\u4ef6\u8bed\u53e5\u4e2d\u5b9a\u4e49\u3002", (String)"FormulaParseHelper_44", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
                    }
                    if (list.size() < 2 || node2 == null || list.size() == 3) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8bed\u6cd5\u9519\u8bef\uff0c\u53d8\u91cf\u5b9a\u4e49\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1aNUM/TEXT/DATE VR[XXX](=\u8868\u8fbe\u5f0f\uff09\u3002", (String)"FormulaParseHelper_37", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
                    }
                    if (!FormulaUtils.isVRItem((String)nodeText2) || list.size() >= 3 && !SWCStringUtils.equals((String)OperatorEnum.EQUAL.getAlias(), (String)((OriginalNode)list.get(2)).getNodeText())) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8bed\u6cd5\u9519\u8bef\uff0c\u53d8\u91cf\u5b9a\u4e49\u8bed\u53e5\u5fc5\u987b\u6ee1\u8db3\u683c\u5f0f\uff1aNUM/TEXT/DATE VR[XXX](=\u8868\u8fbe\u5f0f\uff09\u3002", (String)"FormulaParseHelper_37", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node2.getLineIndex() + 1, node2.getStartColumnIndex() + 1, node2.getNodeText()));
                    }
                    conditionExpression.setExpressionNodes(list);
                    conditionExpression.setIsResult(Boolean.FALSE);
                    if (node2 != null) {
                        if (list.size() == 2) {
                            node2.setKeyType(ExpressionNodeTypeEnum.DEFINE);
                        } else {
                            node2.setKeyType(ExpressionNodeTypeEnum.ASS);
                        }
                        node2.setUniqueKey(node2.getNodeText());
                    }
                } else if (FormulaUtils.isVRAssignmentKey((String)node1.getNodeText(), (String)nodeText2, null)) {
                    if (list.size() < 3) {
                        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u5b8c\u6574\u3002", (String)"FormulaParseHelper_13", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, node1.getNodeText()));
                    }
                    conditionExpression.setExpressionNodes(list);
                    conditionExpression.setIsResult(Boolean.FALSE);
                    node1.setKeyType(ExpressionNodeTypeEnum.ASS);
                    node1.setUniqueKey(node1.getNodeText());
                } else if (FormulaUtils.isExitKey((String)node1.getNodeText())) {
                    conditionExpression.setExpressionNodes(list);
                    conditionExpression.setIsResult(Boolean.FALSE);
                    node1.setKeyType(ExpressionNodeTypeEnum.EXIT);
                    node1.setUniqueKey(OperatorEnum.EXIT.getName());
                } else if (FormulaUtils.isOutPutMessageFunction((String)node1.getNodeText(), (FormulaInfo)formula)) {
                    conditionExpression.setExpressionNodes(list);
                    conditionExpression.setIsResult(Boolean.FALSE);
                    node1.setKeyType(ExpressionNodeTypeEnum.OUTPUT);
                    node1.setUniqueKey(node1.getNodeText());
                } else if (!this.isChildConditionKey(node1.getNodeText())) {
                    String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8868\u8fbe\u5f0f\u201c{2}\u201d\u4e0d\u6b63\u786e\u3002\u8bf7\u6309\u7167\u4ee5\u4e0b\u8d4b\u503c\u8bed\u53e5\u6837\u5f0f\u8fdb\u884c\u586b\u5199\uff1aRESULT/\u652f\u6301\u9879\u76ee/\u4e34\u65f6\u53d8\u91cf = A*B-C\u3002", (String)"FormulaParseHelper_5", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(msg, node1.getLineIndex() + 1, node1.getStartColumnIndex() + 1, this.buildErrorMsg(list)));
                }
                expList.addAll(this.getExpression(conditionExpression, (List<OriginalNode>)var14_30, formula));
            }
            return expList;
        }
        return this.getExpression(conditionExpression, expressionList, formula);
    }

    private String buildErrorMsg(List<OriginalNode> nodeList) {
        StringBuilder msg = new StringBuilder();
        for (OriginalNode node : nodeList) {
            msg.append(node.getNodeText()).append(' ');
        }
        return msg.toString();
    }

    private boolean isSPAssignment(String nodeText, String preNodeText) {
        return (SWCStringUtils.isEmpty((String)preNodeText) || !FormulaUtils.isOperation((String)preNodeText)) && FormulaUtils.isSPItem((String)nodeText);
    }

    private List<OriginalNode> getNewExpressionList(List<OriginalNode> expressionList) {
        ArrayList<OriginalNode> newExpressionList = new ArrayList<OriginalNode>(expressionList.size());
        int index = 0;
        for (OriginalNode node : expressionList) {
            if (index == 0 || index == 1) {
                ++index;
                continue;
            }
            newExpressionList.add(node);
        }
        return newExpressionList;
    }

    private void checkParentheses(ConditionExpression conditionExpression) {
        List expressionList = conditionExpression.getExpressions();
        if (SWCListUtils.isEmpty((List)expressionList)) {
            return;
        }
        Stack<OriginalNode> leftParenthesesStack = new Stack<OriginalNode>();
        for (OriginalNode node : expressionList) {
            if (OperatorEnum.LPARENTHESES.getAlias().equals(node.getNodeText()) || "\uff08".equals(node.getNodeText())) {
                leftParenthesesStack.push(node);
            }
            if (!OperatorEnum.RPARENTHESES.getAlias().equals(node.getNodeText()) && !"\uff09".equals(node.getNodeText())) continue;
            if (leftParenthesesStack.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"ExpressionParseHelper_2", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
            leftParenthesesStack.pop();
        }
        if (!leftParenthesesStack.isEmpty()) {
            OriginalNode tempNode = (OriginalNode)leftParenthesesStack.pop();
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7f3a\u5c11\u4e0e\u5de6\u62ec\u53f7\u201c(\u201d\u5339\u914d\u7684\u53f3\u62ec\u53f7\u201c)\u201d\u3002", (String)"FormulaParseHelper_52", (String)SYSTEMTYPE, (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, tempNode.getLineIndex() + 1, tempNode.getStartColumnIndex() + 1));
        }
    }

    private void getResultExpression(FormulaInfo formula, StringBuilder resultCode, String itemUniqueCode, String resultItemName, ConditionExpression conditionExpression, ConditionEnum preConditionEnum) {
        OriginalNode conditionNode = conditionExpression.getCondition();
        ConditionEnum conditionEnum = conditionExpression.getConditionEnum();
        if (conditionNode != null) {
            conditionNode.setKeyType(ExpressionNodeTypeEnum.CONDITION);
            if (conditionEnum == ConditionEnum.ENDIF) {
                conditionNode.setUniqueKey(ConditionEnum.ENDIF.getName());
                return;
            }
        }
        this.checkParentheses(conditionExpression);
        List<Expression> expressions = this.transferExp(conditionExpression, formula);
        StringBuilder codeStr = new StringBuilder();
        ConditionEnum preChildConditionEnum = preConditionEnum;
        for (Expression expression : expressions) {
            if (expression instanceof ConditionExpression) {
                this.getResultExpression(formula, codeStr, itemUniqueCode, resultItemName, (ConditionExpression)expression, preChildConditionEnum);
                preChildConditionEnum = ((ConditionExpression)expression).getConditionEnum();
                continue;
            }
            if (expression instanceof ExitExpression) {
                if (codeStr.length() == 0) {
                    codeStr.append('\n');
                }
                codeStr.append(String.format(Locale.ROOT, "\t \t addResultValue(\"%s\",%s,sectionKey);\n", itemUniqueCode, resultItemName));
                codeStr.append("\t \t continue;");
                continue;
            }
            this.getResultJavaCode(formula, resultItemName, conditionNode, conditionEnum, codeStr, expression);
        }
        if (null == conditionEnum && codeStr.length() > 0) {
            resultCode.append(String.format(Locale.ROOT, "\t%s \n", codeStr));
            return;
        }
        if (null == conditionNode) {
            return;
        }
        if (conditionEnum == ConditionEnum.IF) {
            resultCode.append(String.format(Locale.ROOT, "\n    if(%s)", codeStr));
            conditionNode.setUniqueKey(ConditionEnum.IF.getName());
        } else if (conditionEnum == ConditionEnum.ELSEIF) {
            resultCode.append(String.format(Locale.ROOT, "    else if(%s)", codeStr));
            conditionNode.setUniqueKey(ConditionEnum.ELSEIF.getName());
        } else if (conditionEnum == ConditionEnum.ELSE) {
            resultCode.append(String.format(Locale.ROOT, "    else{\n\t %s\n    }", codeStr)).append('\n');
            conditionNode.setUniqueKey(ConditionEnum.ELSE.getName());
        } else if (conditionEnum == ConditionEnum.THEN) {
            resultCode.append(String.format(Locale.ROOT, "{\n\t %s\n    }", codeStr)).append('\n');
            conditionNode.setUniqueKey(ConditionEnum.THEN.getName());
        }
    }

    private void getResultJavaCode(FormulaInfo formula, String resultItemName, OriginalNode conditionNode, ConditionEnum conditionEnum, StringBuilder codeStr, Expression expression) {
        ExpressionParseHelper calExpHelper = new ExpressionParseHelper(formula, expression, conditionNode, conditionEnum);
        ResultExpression resultExp = calExpHelper.compile();
        SalaryItem item = formula.getSalaryItem();
        if (conditionEnum == null || conditionEnum == ConditionEnum.ELSE || conditionEnum == ConditionEnum.THEN) {
            if (resultExp == null) {
                OperatorExpression opExp = (OperatorExpression)expression;
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u4e2d\u201c{2} = {3}\u201d\u7ef4\u62a4\u4e0d\u6b63\u786e,\u201c{4} =\u201d\u540e\u9762\u4e0d\u80fd\u662f\u8fd0\u7b97\u7b26\u3002", (String)"FormulaParseHelper_68", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, opExp.getOperation().getLineIndex() + 1, opExp.getOperation().getStartColumnIndex() + 1, FormulaKeyEnum.RESULT.getCode(), opExp.getOperation().getNodeText(), FormulaKeyEnum.RESULT.getCode()));
            }
            if (resultExp.getType() != ExpressionNodeTypeEnum.ASS && resultExp.getType() != ExpressionNodeTypeEnum.OUTPUT) {
                if (formula.isProrateItemFormula()) {
                    if (resultExp.getDataType() != DataTypeEnum.NUMBERIC) {
                        if (conditionNode != null) {
                            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u540e\u7684\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u516c\u5f0f\u201c{3}\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u516c\u5f0f\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"FormulaParseHelper_64", (String)SYSTEMTYPE, (Object[])new Object[0]);
                            throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText(), formula.getName(), FormulaParseUtils.getDataTypeDesc(resultExp.getDataType())));
                        }
                        OriginalNode tempNode = FormulaUtils.getExpressionNode((Expression)expression);
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u516c\u5f0f[{2}]\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u516c\u5f0f\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\u3002", (String)"FormulaParseHelper_65", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, tempNode.getLineIndex() + 1, tempNode.getStartColumnIndex() + 1, formula.getName(), FormulaParseUtils.getDataTypeDesc(resultExp.getDataType())));
                    }
                } else if (item.getType() != resultExp.getDataType()) {
                    if (conditionNode != null) {
                        String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u540e\u7684\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u85aa\u916c\u9879\u76ee\u201c{3}\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u85aa\u916c\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u8bed\u53e5\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{5}\u3002", (String)"FormulaParseHelper_55", (String)SYSTEMTYPE, (Object[])new Object[0]);
                        throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText(), item.getName(), FormulaParseUtils.getDataTypeDesc(item.getType()), FormulaParseUtils.getDataTypeDesc(resultExp.getDataType())));
                    }
                    OriginalNode tempNode = FormulaUtils.getExpressionNode((Expression)expression);
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u85aa\u916c\u9879\u76ee[{2}]\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u85aa\u916c\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u800c\u7ed3\u679c\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"FormulaParseHelper_56", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, tempNode.getLineIndex() + 1, tempNode.getStartColumnIndex() + 1, item.getName(), FormulaParseUtils.getDataTypeDesc(item.getType()), FormulaParseUtils.getDataTypeDesc(resultExp.getDataType())));
                }
            }
        } else {
            if (resultExp.getDataType() != DataTypeEnum.BOOLEAN) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{2}\u201d\u540e\u9762\u5fc5\u987b\u662f\u5224\u65ad\u8868\u8fbe\u5f0f\u3002", (String)"FormulaParseHelper_63", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1, conditionNode.getNodeText()));
            }
            if (resultExp.getType() == ExpressionNodeTypeEnum.ASS && item.getType() != resultExp.getDataType()) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c=\u201d\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4\u3002", (String)"FormulaParseHelper_67", (String)SYSTEMTYPE, (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, conditionNode.getLineIndex() + 1, conditionNode.getStartColumnIndex() + 1));
            }
        }
        List<String> tempVarExpressionList = calExpHelper.getTempVarExpressionList();
        for (String expressionCode : tempVarExpressionList) {
            codeStr.append(expressionCode).append('\n');
        }
        AssExpression exp = (AssExpression)resultExp.getOriginalExp();
        if (resultExp.getType() == ExpressionNodeTypeEnum.ASS && exp != null && exp.getItem().getKeyType() == ExpressionNodeTypeEnum.DEFINE) {
            return;
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.ASS) {
            this.getAssItemMap(resultExp);
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.OUTPUT) {
            codeStr.append(resultExp.getCode()).append(';').append('\n');
            return;
        }
        if (resultExp.getType() == ExpressionNodeTypeEnum.RESULT && conditionEnum != ConditionEnum.IF && conditionEnum != ConditionEnum.ELSEIF) {
            codeStr.append(String.format("\t %s = %s;", resultItemName, resultExp.getCode()));
        } else {
            codeStr.append(resultExp.getCode());
        }
    }

    private boolean isChildConditionKey(String nodeText) {
        return SWCStringUtils.isNotEmpty((String)nodeText) && nodeText.contains(CONDITION_EXP_PLACEHOLDER);
    }
}

