/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;
import kd.swc.hsas.common.formula.enums.OperatorEnum;
import kd.swc.hsas.common.formula.vo.OriginalNode;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaSplitHelper {
    private boolean isBlockAnnotation = false;
    private int annotationStartLineIndex = 0;
    private int annotationStartColumnIndex = 0;
    private static final String SPECIAL_EMPTY = "\u00a0";
    private static final String NOT = "!";
    private static final Set<String> KEYWORDSET = new HashSet<String>();

    public List<OriginalNode> getOriginalNodes(String formulaText) throws Exception {
        formulaText = formulaText.replace("\t", "    ");
        String[] lines = formulaText.split("\r?\n");
        ArrayList<OriginalNode> nodes = new ArrayList<OriginalNode>(10);
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String lineText = lines[i];
            List<OriginalNode> lineNodes = this.getOriginalNodeByLine(lineText, i);
            nodes.addAll(lineNodes);
        }
        return nodes;
    }

    public List<OriginalNode> getOriginalNodeByLine(String formulaText, int lineIndex) throws Exception {
        ArrayList<OriginalNode> nodes = new ArrayList<OriginalNode>();
        int len = formulaText.length();
        int fromIndex = 0;
        int toIndex = 0;
        int currFromIndex = 0;
        int currToIndex = 0;
        String nodeText = "";
        String tmp = "";
        int index = 0;
        int reducelen = len - 1;
        while (index < len) {
            if (this.isBlockAnnotation) {
                OriginalNode blockAnnotationNode = this.getBlockAnnotation(index, formulaText, lineIndex);
                nodeText = blockAnnotationNode.getNodeText();
                OriginalNode tempNode = this.addOriginalNode(nodes, nodeText, currFromIndex = blockAnnotationNode.getStartColumnIndex(), currToIndex = blockAnnotationNode.getEndColumnIndex(), lineIndex);
                if (tempNode != null) {
                    tempNode.setCommontNode(true);
                }
                fromIndex = index = blockAnnotationNode.getEndColumnIndex() + 1;
                toIndex = index;
                continue;
            }
            String ch = String.valueOf(formulaText.charAt(index));
            if (ch.equals(OperatorEnum.QUOT.getAlias()) || ch.equals("\u201c")) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex;
                    fromIndex = toIndex;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                }
                OriginalNode node = this.getQuotNode(index, formulaText, lineIndex);
                nodeText = node.getNodeText();
                currFromIndex = node.getStartColumnIndex();
                currToIndex = node.getEndColumnIndex();
                index = node.getEndColumnIndex() + 1;
                node = this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                if (node != null) {
                    node.setFormatNodeText(OperatorEnum.QUOT.getAlias() + nodeText.substring(1, nodeText.length() - 1) + OperatorEnum.QUOT.getAlias());
                }
                fromIndex = index;
                toIndex = index;
                continue;
            }
            if (ch.equals(OperatorEnum.LBRACKET.getAlias()) || ch.equals("\u3010")) {
                OriginalNode node;
                boolean isBsProp = false;
                boolean isItem = false;
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    isItem = this.isItemPrefix(nodeText);
                    isBsProp = this.isBsPropItem(nodeText, nodes);
                    if (!isItem && !isBsProp) {
                        currFromIndex = fromIndex;
                        currToIndex = toIndex;
                        fromIndex = toIndex;
                        this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                    }
                } else {
                    node = this.getBracketNode(index, formulaText, lineIndex, false);
                    throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u672a\u5b9a\u4e49\u7684\u5173\u952e\u5b57\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, index + 1, node.getNodeText()));
                }
                node = this.getBracketNode(index, formulaText, lineIndex, true);
                currFromIndex = fromIndex;
                currToIndex = node.getEndColumnIndex();
                index = node.getEndColumnIndex() + 1;
                nodeText = formulaText.substring(fromIndex, node.getEndColumnIndex() + 1);
                if (isBsProp) {
                    OriginalNode preNode = (OriginalNode)nodes.get(nodes.size() - 1);
                    preNode.setNodeText(preNode.getNodeText() + nodeText);
                    preNode.setEndColumnIndex(currToIndex);
                    preNode.setEndLineIndex(lineIndex);
                    nodeText = OperatorEnum.FULLSTOP.getAlias() + OperatorEnum.LBRACKET.getAlias() + nodeText.substring(2, nodeText.length() - 1) + OperatorEnum.RBRACKET.getAlias();
                    preNode.setFormatNodeText(preNode.getFormatNodeText() + nodeText);
                    preNode.setBsPropItemNode(true);
                } else {
                    node = this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                    if (node != null && isItem) {
                        node.setFormatNodeText(nodeText.substring(0, 2).toUpperCase(Locale.ROOT) + OperatorEnum.LBRACKET.getAlias() + nodeText.substring(3, nodeText.length() - 1) + OperatorEnum.RBRACKET.getAlias());
                    }
                }
                fromIndex = index;
                toIndex = index;
                continue;
            }
            if (ch.equals(OperatorEnum.RBRACKET.getAlias()) || ch.equals("\u3011")) {
                throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u4e2d\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, index + 1, ch));
            }
            if (ch.equals(OperatorEnum.LPARENTHESES.getAlias()) || ch.equals("\uff08") || ch.equals(OperatorEnum.RPARENTHESES.getAlias()) || ch.equals("\uff09") || ch.equals(OperatorEnum.COMMA.getAlias()) || ch.equals("\uff0c")) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex - 1;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                }
                fromIndex = index;
                toIndex = index + 1;
                nodeText = formulaText.substring(fromIndex, toIndex);
                currFromIndex = fromIndex;
                currToIndex = toIndex;
                fromIndex = toIndex;
                OriginalNode tempNode = this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                if (tempNode != null) {
                    tempNode.setFormatNodeText(this.replaceEnglishText(tempNode.getNodeText()));
                }
                ++index;
                continue;
            }
            if (ch.equals(OperatorEnum.PLUS.getAlias()) || ch.equals(OperatorEnum.SUBTRACT.getAlias()) || ch.equals(OperatorEnum.MULTIPLY.getAlias()) || ch.equals(OperatorEnum.DIVIDE.getAlias()) || ch.equals(OperatorEnum.EQUAL.getAlias())) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex - 1;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                }
                boolean isRowAnnotation = false;
                if (index < reducelen && ch.equals(OperatorEnum.DIVIDE.getAlias())) {
                    String nextCh = String.valueOf(formulaText.charAt(index + 1));
                    if (nextCh.equals(OperatorEnum.DIVIDE.getAlias())) {
                        isRowAnnotation = true;
                    } else if (nextCh.equals(OperatorEnum.MULTIPLY.getAlias())) {
                        this.annotationStartLineIndex = lineIndex;
                        this.annotationStartColumnIndex = index + 1;
                        this.isBlockAnnotation = true;
                    }
                }
                if (isRowAnnotation) {
                    fromIndex = index;
                    toIndex = len;
                    index = len;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    OriginalNode tempNode = this.addOriginalNode(nodes, nodeText, currFromIndex = fromIndex, currToIndex = toIndex - 1, lineIndex);
                    if (tempNode != null) {
                        tempNode.setCommontNode(true);
                    }
                    fromIndex = index;
                    toIndex = index;
                    continue;
                }
                if (this.isBlockAnnotation) {
                    OriginalNode blockAnnotationNode = this.getBlockAnnotation(index, formulaText, lineIndex);
                    nodeText = blockAnnotationNode.getNodeText();
                    OriginalNode tempNode = this.addOriginalNode(nodes, nodeText, currFromIndex = blockAnnotationNode.getStartColumnIndex(), currToIndex = blockAnnotationNode.getEndColumnIndex(), lineIndex);
                    if (tempNode != null) {
                        tempNode.setCommontNode(true);
                    }
                    fromIndex = index = blockAnnotationNode.getEndColumnIndex() + 1;
                    toIndex = index;
                    continue;
                }
                fromIndex = index;
                toIndex = index + 1;
                nodeText = formulaText.substring(fromIndex, toIndex);
                currFromIndex = fromIndex;
                currToIndex = toIndex;
                fromIndex = toIndex;
                this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                ++index;
                continue;
            }
            if (ch.equals(OperatorEnum.GT.getAlias()) || ch.equals(OperatorEnum.LT.getAlias())) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex;
                    fromIndex = toIndex;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                }
                if ((tmp = len >= index + 2 ? formulaText.substring(fromIndex, index + 2) : formulaText.substring(fromIndex, len)).equals(OperatorEnum.GTOREQUAL.getAlias()) || tmp.equals(OperatorEnum.LTOREQUAL.getAlias()) || tmp.equals(OperatorEnum.UNEQUAL.getAlias())) {
                    toIndex = index + 2;
                    nodeText = tmp;
                    currFromIndex = fromIndex;
                    currToIndex = toIndex;
                    fromIndex = toIndex;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                    index += 2;
                    continue;
                }
                toIndex = index + 1;
                nodeText = formulaText.substring(fromIndex, toIndex);
                currFromIndex = fromIndex;
                currToIndex = toIndex;
                fromIndex = toIndex;
                this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                ++index;
                continue;
            }
            if (ch.equals(NOT)) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex;
                    fromIndex = toIndex;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                }
                if ((tmp = len >= index + 2 ? formulaText.substring(fromIndex, index + 2) : formulaText.substring(fromIndex, len)).equals(OperatorEnum.UNEQUAL.getAlias())) {
                    toIndex = index + 2;
                    nodeText = tmp;
                    currFromIndex = fromIndex;
                    currToIndex = toIndex;
                    fromIndex = toIndex;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                    index += 2;
                    continue;
                }
                toIndex = index + 1;
                nodeText = formulaText.substring(fromIndex, toIndex);
                currFromIndex = fromIndex;
                currToIndex = toIndex;
                fromIndex = toIndex;
                this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                ++index;
                continue;
            }
            if (ch.equals(OperatorEnum.EMPTY.getAlias()) || SPECIAL_EMPTY.equals(ch)) {
                if (fromIndex < index) {
                    toIndex = index;
                    nodeText = formulaText.substring(fromIndex, toIndex);
                    currFromIndex = fromIndex;
                    currToIndex = toIndex - 1;
                    fromIndex = toIndex + 1;
                    this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
                } else {
                    fromIndex = index + 1;
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (fromIndex < len + 1) {
            toIndex = len;
            nodeText = formulaText.substring(fromIndex, toIndex);
            currFromIndex = fromIndex;
            currToIndex = toIndex;
            if (SWCStringUtils.isNotEmpty((String)nodeText)) {
                this.addOriginalNode(nodes, nodeText, currFromIndex, currToIndex, lineIndex);
            }
        }
        return nodes;
    }

    private boolean isBsPropItem(String nodeText, List<OriginalNode> nodeList) {
        if (nodeList.size() < 1 || !OperatorEnum.FULLSTOP.getAlias().equals(nodeText)) {
            return false;
        }
        OriginalNode node = nodeList.get(nodeList.size() - 1);
        return node.getFormatNodeText().startsWith("BS[");
    }

    private String replaceEnglishText(String nodeText) {
        String result = null;
        switch (nodeText) {
            case "\uff0c": {
                result = OperatorEnum.COMMA.getAlias();
                break;
            }
            case "\uff08": {
                result = OperatorEnum.LPARENTHESES.getAlias();
                break;
            }
            case "\uff09": {
                result = OperatorEnum.RPARENTHESES.getAlias();
                break;
            }
            default: {
                result = nodeText;
            }
        }
        return result;
    }

    public List<OriginalNode> getOriginalNodesWithComment(String formulaText) throws Exception {
        formulaText = formulaText.replace("\t", "    ");
        String[] lines = formulaText.split("\r?\n");
        ArrayList<OriginalNode> nodes = new ArrayList<OriginalNode>(10);
        for (String lineText : lines) {
            this.addOriginalNodeByLineWithComment(lineText, nodes);
        }
        return nodes;
    }

    private void addOriginalNodeByLineWithComment(String formulaText, List<OriginalNode> nodes) {
        int len = formulaText.length();
        int index = 0;
        int useIndex = 0;
        int count = nodes.size();
        StringBuilder blankPrixBuilder = new StringBuilder();
        StringBuilder currentTextBuilder = new StringBuilder();
        StringBuilder previousTextBuilder = new StringBuilder();
        HashSet conditionKeySet = new HashSet(5){
            private static final long serialVersionUID = -1919574621903371469L;
            {
                this.add("IF");
                this.add("ELSEIF");
                this.add("THEN");
                this.add("ELSE");
                this.add("ENDIF");
                this.add("EXIT");
            }
        };
        String currentText = null;
        StringBuilder tempBuilder = new StringBuilder();
        StringBuilder tempBuilder2 = new StringBuilder();
        while (index < len) {
            OriginalNode lastNode;
            if (this.isBlockAnnotation) {
                int endBlockIndex = formulaText.indexOf("*/", index);
                lastNode = nodes.get(nodes.size() - 1);
                if (endBlockIndex == -1) {
                    lastNode.setNodeText(lastNode.getNodeText() + '\n' + formulaText);
                    useIndex = index = len;
                    continue;
                }
                String subString = formulaText.substring(index, endBlockIndex + 2);
                lastNode.setNodeText(lastNode.getNodeText() + '\n' + subString);
                useIndex = index = endBlockIndex + 2;
                this.isBlockAnnotation = false;
                continue;
            }
            String ch = String.valueOf(formulaText.charAt(index));
            lastNode = null;
            String lastNodeText = null;
            if (nodes.size() > 0) {
                lastNode = nodes.get(nodes.size() - 1);
                lastNodeText = lastNode.getNodeText();
            }
            if (ch.equals(OperatorEnum.EMPTY.getAlias()) || SPECIAL_EMPTY.equals(ch) || OperatorEnum.DIVIDE.getAlias().equals(ch) && currentTextBuilder.toString().endsWith("/") || ch.equals("(") || ch.equals(")")) {
                if (currentTextBuilder.length() > 0) {
                    currentText = currentTextBuilder.toString();
                    if (conditionKeySet.contains(currentText)) {
                        if (count != nodes.size() && lastNodeText != null && (lastNodeText.startsWith("IF") || lastNodeText.startsWith("ELSEIF"))) {
                            nodes.get(nodes.size() - 1).setNodeText(lastNodeText + previousTextBuilder);
                        } else {
                            this.addOriginalNode(nodes, previousTextBuilder.toString(), 0, 0, 0);
                        }
                        this.addOriginalNode(nodes, currentText, 0, 0, 0);
                        blankPrixBuilder = new StringBuilder();
                        currentTextBuilder = new StringBuilder();
                        previousTextBuilder = new StringBuilder();
                    } else {
                        if (previousTextBuilder.length() == 0 && (count == nodes.size() || lastNodeText != null && (lastNodeText.startsWith("THEN") || lastNodeText.startsWith("ELSE") && !lastNodeText.startsWith("ELSEIF")))) {
                            blankPrixBuilder = new StringBuilder();
                        } else {
                            previousTextBuilder.append((CharSequence)blankPrixBuilder);
                            blankPrixBuilder = new StringBuilder();
                        }
                        previousTextBuilder.append(currentText);
                        currentTextBuilder = new StringBuilder();
                    }
                    useIndex = index - 1;
                }
                if (ch.equals("(")) {
                    currentTextBuilder.append(ch);
                    ++index;
                    continue;
                }
                if (ch.equals(")")) {
                    previousTextBuilder.append((CharSequence)blankPrixBuilder);
                    blankPrixBuilder = new StringBuilder();
                    previousTextBuilder.append(ch);
                    ++index;
                    continue;
                }
                if (!OperatorEnum.DIVIDE.getAlias().equals(ch)) {
                    blankPrixBuilder.append(ch);
                    ++index;
                    continue;
                }
                currentTextBuilder.append(formulaText.substring(index));
                index = len;
                continue;
            }
            currentTextBuilder.append(ch);
            currentText = currentTextBuilder.toString();
            if (SWCStringUtils.equals((String)ch, (String)OperatorEnum.QUOT.getAlias())) {
                int nextQuoteIndex = formulaText.indexOf(ch, index + 1);
                currentTextBuilder.append(formulaText.substring(index + 1, nextQuoteIndex + 1));
                index = nextQuoteIndex + 1;
                previousTextBuilder.append((CharSequence)blankPrixBuilder);
                blankPrixBuilder = new StringBuilder();
                previousTextBuilder.append((CharSequence)currentTextBuilder);
                currentTextBuilder = new StringBuilder();
                continue;
            }
            if (SWCStringUtils.equals((String)"/*", (String)currentText)) {
                if (previousTextBuilder.length() > 0) {
                    if (count != nodes.size() && lastNodeText != null && (lastNodeText.startsWith("IF") || lastNodeText.startsWith("ELSIF"))) {
                        if (lastNode != null) {
                            lastNode.setNodeText(lastNodeText + previousTextBuilder);
                        }
                        previousTextBuilder = new StringBuilder();
                    } else {
                        OriginalNode previousNode = this.addOriginalNode(nodes, previousTextBuilder.toString(), 0, 0, 0);
                        if (previousNode != null) {
                            previousTextBuilder = new StringBuilder();
                        }
                    }
                }
                String subString = null;
                int endBlockIndex = formulaText.indexOf("*/", index + 1);
                if (endBlockIndex == -1) {
                    subString = formulaText.substring(index - 1);
                    this.isBlockAnnotation = true;
                    index = len;
                } else {
                    subString = formulaText.substring(index - 1, endBlockIndex + 2);
                    index = endBlockIndex + 2;
                }
                if (count != nodes.size()) {
                    lastNode = nodes.get(nodes.size() - 1);
                    lastNode.setNodeText(lastNode.getNodeText() + previousTextBuilder + blankPrixBuilder + subString);
                } else {
                    tempBuilder.setLength(0);
                    tempBuilder.append((CharSequence)previousTextBuilder);
                    tempBuilder.append((CharSequence)blankPrixBuilder);
                    tempBuilder.append(subString);
                    OriginalNode newNode = this.addOriginalNode(nodes, tempBuilder.toString(), 0, 0, 0);
                    if (newNode != null) {
                        newNode.setCommontNode(true);
                    }
                }
                useIndex = index - 1;
                previousTextBuilder = new StringBuilder();
                blankPrixBuilder = new StringBuilder();
                currentTextBuilder = new StringBuilder();
                continue;
            }
            if (SWCStringUtils.equals((String)"//", (String)currentText)) {
                if (count != nodes.size() && lastNodeText != null && (lastNodeText.startsWith("IF") || lastNodeText.startsWith("ELSEIF"))) {
                    if (lastNode != null) {
                        lastNode.setNodeText(lastNodeText + previousTextBuilder);
                    }
                    previousTextBuilder = new StringBuilder();
                } else {
                    OriginalNode previousNode = this.addOriginalNode(nodes, previousTextBuilder.toString(), 0, 0, 0);
                    if (previousNode != null) {
                        previousTextBuilder = new StringBuilder();
                    }
                }
                String subString = formulaText.substring(index - 1);
                if (count != nodes.size()) {
                    lastNode = nodes.get(nodes.size() - 1);
                    lastNode.setNodeText(lastNode.getNodeText() + previousTextBuilder + blankPrixBuilder + subString);
                } else {
                    tempBuilder.setLength(0);
                    tempBuilder.append((CharSequence)previousTextBuilder);
                    tempBuilder.append((CharSequence)blankPrixBuilder);
                    tempBuilder.append(subString);
                    OriginalNode newNode = this.addOriginalNode(nodes, tempBuilder.toString(), 0, 0, 0);
                    if (newNode != null) {
                        newNode.setCommontNode(true);
                    }
                }
                useIndex = index = len;
                continue;
            }
            if (SWCStringUtils.equals((String)"]", (String)ch)) {
                if (previousTextBuilder.length() == 0 && (count == nodes.size() || lastNodeText != null && (lastNodeText.startsWith("THEN") || lastNodeText.startsWith("ELSE") && !lastNodeText.startsWith("ELSEIF")))) {
                    blankPrixBuilder = new StringBuilder();
                } else {
                    previousTextBuilder.append((CharSequence)blankPrixBuilder);
                    blankPrixBuilder = new StringBuilder();
                }
                previousTextBuilder.append(currentText);
                currentTextBuilder = new StringBuilder();
                ++index;
                continue;
            }
            ++index;
        }
        if (useIndex <= len - 1) {
            OriginalNode lastNode = null;
            String lastNodeText = null;
            currentText = currentTextBuilder.toString();
            if (conditionKeySet.contains(currentText)) {
                currentTextBuilder = new StringBuilder();
            }
            if (nodes.size() > 0) {
                lastNode = nodes.get(nodes.size() - 1);
                lastNodeText = lastNode.getNodeText();
            }
            if (count == nodes.size() || lastNodeText != null && (lastNodeText.startsWith("THEN") || lastNodeText.startsWith("ELSE") && !lastNodeText.startsWith("ELSEIF"))) {
                if (previousTextBuilder.length() > 0) {
                    previousTextBuilder.append((CharSequence)blankPrixBuilder);
                }
                tempBuilder2.setLength(0);
                tempBuilder2.append((CharSequence)previousTextBuilder);
                tempBuilder2.append((CharSequence)currentTextBuilder);
                OriginalNode newNode = this.addOriginalNode(nodes, tempBuilder2.toString(), 0, 0, 0);
                if (newNode != null && (currentText.startsWith("//") || currentText.startsWith("/*"))) {
                    newNode.setCommontNode(true);
                }
            } else if (lastNode != null) {
                lastNode.setNodeText(lastNodeText + previousTextBuilder + blankPrixBuilder + currentTextBuilder);
            }
            if (conditionKeySet.contains(currentText)) {
                this.addOriginalNode(nodes, currentText, 0, 0, 0);
            }
        }
    }

    private OriginalNode getBlockAnnotation(int index, String formulaText, int lineIndex) {
        int fromIndex = index;
        int len = formulaText.length();
        String nodeText = "";
        while (index < len) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (index >= 1 && ch.equals(OperatorEnum.DIVIDE.getAlias()) && String.valueOf(formulaText.charAt(index - 1)).equals(OperatorEnum.MULTIPLY.getAlias()) && (lineIndex != this.annotationStartLineIndex || this.annotationStartColumnIndex != index - 1)) {
                this.isBlockAnnotation = false;
                ++index;
                break;
            }
            ++index;
        }
        nodeText = formulaText.substring(fromIndex, index);
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index - 1);
        return node;
    }

    private OriginalNode getQuotNode(int fromIndex, String formulaText, int lineIndex) throws Exception {
        int index;
        int len = formulaText.length();
        String nodeText = "";
        if (fromIndex + 1 == len) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5f15\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, index + 1, OperatorEnum.QUOT.getAlias()));
        }
        for (index = fromIndex + 1; index < len; ++index) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (!ch.equals(OperatorEnum.QUOT.getAlias()) && !ch.equals("\u201d")) continue;
            nodeText = formulaText.substring(fromIndex, index + 1);
            break;
        }
        if (nodeText.equals("")) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5f15\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1, OperatorEnum.QUOT.getAlias()));
        }
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index);
        return node;
    }

    private OriginalNode getBracketNode(int fromIndex, String formulaText, int lineIndex, boolean isCheckNull) throws Exception {
        int index;
        int len = formulaText.length();
        String nodeText = "";
        if (fromIndex + 1 == len) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u4e2d\u62ec\u53f7\"{2}\"\u3002", (String)"FormulaSplitHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, index + 1, OperatorEnum.LBRACKET.getAlias()));
        }
        boolean isMatchBracket = false;
        for (index = fromIndex + 1; index < len; ++index) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (ch.equals(OperatorEnum.LBRACKET.getAlias()) || ch.equals("\u3010")) {
                throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e2d\u62ec\u53f7\u5185\u4e0d\u80fd\u51fa\u73b0\u5de6\u4e2d\u62ec\u53f7\"{2}\"\u3002", (String)"FormulaSplitHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, index + 1, ch));
            }
            if (!ch.equals(OperatorEnum.RBRACKET.getAlias()) && !ch.equals("\u3011")) continue;
            nodeText = formulaText.substring(fromIndex + 1, index);
            if (isCheckNull && nodeText.equals("")) {
                throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e2d\u62ec\u53f7\u5185\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaSplitHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1));
            }
            isMatchBracket = true;
            break;
        }
        if (!isMatchBracket) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7f3a\u5c11\u53f3\u4e2d\u62ec\u53f7\"]\"\u3002", (String)"FormulaSplitHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, len + 1));
        }
        nodeText = formulaText.substring(fromIndex, index + 1);
        if (nodeText.equals("")) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u4e2d\u62ec\u53f7\"{2}\"\u3002", (String)"FormulaSplitHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1, OperatorEnum.LBRACKET.getAlias()));
        }
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index);
        return node;
    }

    private OriginalNode addOriginalNode(List<OriginalNode> nodes, String nodeText, int fromIndex, int toIndex, int lineIndex) {
        if (SWCStringUtils.isEmpty((String)nodeText)) {
            return null;
        }
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setLineIndex(lineIndex);
        node.setEndLineIndex(lineIndex);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(toIndex);
        if (KEYWORDSET.contains(nodeText.toUpperCase())) {
            node.setFormatNodeText(nodeText.toUpperCase());
        }
        nodes.add(node);
        return node;
    }

    private boolean isItemPrefix(String nodeText) {
        boolean flag = false;
        switch (nodeText.toUpperCase()) {
            case "SL": 
            case "BS": 
            case "FC": 
            case "BR": 
            case "SP": 
            case "AC": 
            case "VR": 
            case "FT": {
                flag = true;
                break;
            }
            default: {
                flag = false;
            }
        }
        return flag;
    }

    static {
        KEYWORDSET.add(FormulaKeyEnum.IF.getCode());
        KEYWORDSET.add(FormulaKeyEnum.ELSEIF.getCode());
        KEYWORDSET.add(FormulaKeyEnum.ELSE.getCode());
        KEYWORDSET.add(FormulaKeyEnum.THEN.getCode());
        KEYWORDSET.add(FormulaKeyEnum.AND.getCode());
        KEYWORDSET.add(FormulaKeyEnum.OR.getCode());
        KEYWORDSET.add(FormulaKeyEnum.LIKE.getCode());
        KEYWORDSET.add(FormulaKeyEnum.RESULT.getCode());
        KEYWORDSET.add(FormulaKeyEnum.ENDIF.getCode());
        KEYWORDSET.add(FormulaKeyEnum.DATE.getCode());
        KEYWORDSET.add(FormulaKeyEnum.TEXT.getCode());
        KEYWORDSET.add(FormulaKeyEnum.NUM.getCode());
        KEYWORDSET.add(FormulaKeyEnum.EXIT.getCode());
        KEYWORDSET.add(FormulaKeyEnum.NULL.getCode());
    }
}

