/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.formula.utils;

import java.util.HashMap;
import java.util.Map;
import kd.swc.hsas.common.formula.enums.FormulaKeyEnum;

public class FormulaOperatorUtils {
    private static Map<String, String> getOperatorMap() {
        HashMap<String, String> operatorMap = new HashMap<String, String>(35);
        operatorMap.put("oper_linecomment", "//");
        operatorMap.put("oper_quot", "\"\"");
        operatorMap.put("oper_blockcomment", "/* */");
        operatorMap.put("oper_divide", "/");
        operatorMap.put("oper_multiply", "*");
        operatorMap.put("oper_subtract", "-");
        operatorMap.put("oper_plus", "+");
        operatorMap.put("oper_equal", "=");
        operatorMap.put("oper_unequal", "!=");
        operatorMap.put("oper_lt", "<");
        operatorMap.put("oper_gt", ">");
        operatorMap.put("oper_ltorequal", "<=");
        operatorMap.put("oper_gtorequal", ">=");
        operatorMap.put("oper_parentheses", "()");
        operatorMap.put("condition_if", FormulaKeyEnum.IF.getCode());
        operatorMap.put("condition_then", FormulaKeyEnum.THEN.getCode());
        operatorMap.put("condition_elseif", FormulaKeyEnum.ELSEIF.getCode());
        operatorMap.put("condition_else", FormulaKeyEnum.ELSE.getCode());
        operatorMap.put("condition_and", FormulaKeyEnum.AND.getCode());
        operatorMap.put("condition_or", FormulaKeyEnum.OR.getCode());
        operatorMap.put("condition_like", FormulaKeyEnum.LIKE.getCode());
        operatorMap.put("condition_result", FormulaKeyEnum.RESULT.getCode() + " = ");
        operatorMap.put("condition_endif", FormulaKeyEnum.ENDIF.getCode());
        operatorMap.put("datatype_num", "NUM VR[]");
        operatorMap.put("datatype_date", "DATE VR[]");
        operatorMap.put("datatype_text", "TEXT VR[]");
        operatorMap.put("condition_null", FormulaKeyEnum.NULL.getCode());
        operatorMap.put("condition_exit", FormulaKeyEnum.EXIT.getCode());
        return operatorMap;
    }

    public static String getOperatorValue(String key) {
        if (key == null || key.length() == 0) {
            return "";
        }
        Map<String, String> operatorMap = FormulaOperatorUtils.getOperatorMap();
        return operatorMap.get(key);
    }
}

