/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide;

import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.importtaskguide.DataPreDealService;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;

public class DataPreDealTask
implements Callable<String> {
    private static final Log logger = LogFactory.getLog(DataPreDealTask.class);
    private List<Long> temporaryIdList;
    private Long creator;
    private RequestContext rc;
    private Long importTaskId;
    private Long verifyRecordId;
    private String writeTaskType;
    private String empGroupName;

    public DataPreDealTask(List<Long> temporaryIdList, Long creator, RequestContext rc, Long importTaskId, Long verifyRecordId, String writeTaskType, String empGroupName) {
        this.temporaryIdList = temporaryIdList;
        this.creator = creator;
        this.rc = rc;
        this.importTaskId = importTaskId;
        this.verifyRecordId = verifyRecordId;
        this.writeTaskType = writeTaskType;
        this.empGroupName = empGroupName;
    }

    @Override
    public String call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.rc);
        logger.info("DataPreDealTask.call start");
        if (ImportTaskUtils.isCancelPreDeal(this.verifyRecordId)) {
            return null;
        }
        try {
            DataPreDealService preDealService = new DataPreDealService(this.importTaskId, this.verifyRecordId);
            if (WriteTaskTypeEnum.COMMON.getCode().equals(this.writeTaskType)) {
                preDealService.dataPreDealForCommon(this.temporaryIdList);
            } else {
                preDealService.dataPreDeal(this.temporaryIdList, this.creator, this.empGroupName);
            }
            this.updateProgress(preDealService.getSuccessCount(), preDealService.getFailCount());
        }
        catch (Exception e) {
            logger.error("preDealService.dataPreDeal error,", (Throwable)e);
            this.updateProgress(0, this.temporaryIdList.size());
            this.saveErrorVerifyDetailData();
        }
        logger.info("DataPreDealTask.call end");
        return null;
    }

    private void saveErrorVerifyDetailData() {
        DynamicObjectCollection list = new DynamicObjectCollection();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_temporarydata");
        DynamicObjectCollection result = helper.queryOriginalCollection("id,empname,filenumber,caltaskname", new QFilter[]{new QFilter("id", "in", this.temporaryIdList)});
        String FAILTYPE_NULL = "3";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        for (DynamicObject temp : result) {
            list.add((Object)ImportTaskUtils.getVerifyDetailObj((DynamicObjectType)type, temp, FAILTYPE_NULL, ImportTaskFailMsgEnum.UNDEFINE_EXCEPTION, this.verifyRecordId));
        }
        helper.setEntityName("hsas_verifydetail");
        helper.save(list);
    }

    private void updateProgress(int successCount, int failCount) {
        boolean isFinsh = ImportTaskUtils.updatePreDaalProgress(successCount, failCount, this.verifyRecordId);
        if (isFinsh) {
            ImportTaskUtils.updateImportTaskStatus(this.importTaskId, "1");
        }
    }
}

