/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverImportService;
import kd.swc.hsas.business.importtaskguide.utils.ImportTaskUtils;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ImportTaskGuideExportService {
    private static final Log logger = LogFactory.getLog(ImportTaskGuideExportService.class);
    private static final int PAGE_SIZE = 500;
    private static final String TPLERROR = "1";

    public void exportExcelTemplate(IFormView view) {
        logger.info("begin exportExcelTemplate");
        try (SXSSFWorkbook wb = new SXSSFWorkbook(500);){
            FormShowParameter parameter = view.getFormShowParameter();
            Long migrationTplId = (Long)parameter.getCustomParam("migrationtplId");
            String writeTaskType = (String)parameter.getCustomParam("writetasktype");
            Long importTaskId = (Long)parameter.getCustomParam("importTaskId");
            String dd = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            String exportFileName = MessageFormat.format(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1_\u6570\u636e\u5bfc\u5165\u6a21\u677f_{0}", (String)"ImportTaskGuideExportService_1", (String)"swc-hsas-business", (Object[])new Object[0]), dd);
            this.createImportTaskDataSheet(migrationTplId, wb, writeTaskType, importTaskId);
            this.flushAllAndDownload(wb, exportFileName, view);
        }
        catch (Exception exception) {
            logger.error("ImportTaskGuideExportService  error : ", (Throwable)exception);
            String str = ResManager.loadKDString((String)"\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\u5931\u8d25\u3002", (String)"ImportTaskGuideExportService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            view.showErrorNotification(str);
        }
        logger.info("end exportExcelTemplate");
    }

    private void createImportTaskDataSheet(Long migrationTplId, SXSSFWorkbook wb, String writeTaskType, Long importTaskId) {
        DynamicObject migrationData = ImportTaskUtils.getMigrationTplData(migrationTplId, "id,number,startline", null);
        int startLine = migrationData.getInt("startline");
        String sheetName = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f", (String)"ImportTaskGuideExportService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        SXSSFRow headRow = sheet.createRow(startLine - 2);
        CellStyle headDateStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.DATE.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        CellStyle headTextStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        Font font = sheet.getWorkbook().createFont();
        CellStyle requrriedStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        font.setColor((short)10);
        requrriedStyle.setFont(font);
        Map itemEnumMap = PresetItemEnum.getPresetItemEnumMap();
        List<Map<String, String>> columnHeadList = ImportTaskUtils.getColumnHeadList(migrationTplId, importTaskId);
        ArrayList<Integer> textIndexList = new ArrayList<Integer>(columnHeadList.size());
        HashSet<Integer> allIndexSet = new HashSet<Integer>(columnHeadList.size());
        PresetItemEnum presetItemEnum = null;
        for (Map<String, String> columnHead : columnHeadList) {
            String columnIndexStr = columnHead.get("columnIndex");
            String dataTypeIdStr = columnHead.get("datatypeid");
            String name = columnHead.get("name");
            String itemType = columnHead.get("itemType");
            int columnIndex = Integer.parseInt(columnIndexStr);
            if (textIndexList.contains(columnIndex)) continue;
            if (Long.parseLong(dataTypeIdStr) == DataTypeEnum.STRING.getDbId()) {
                textIndexList.add(columnIndex);
            }
            allIndexSet.add(columnIndex);
            if ("0".equals(itemType)) {
                presetItemEnum = (PresetItemEnum)itemEnumMap.get(Long.valueOf(columnHead.get("id")));
                CellStyle style = this.getFixCellStyle(presetItemEnum, requrriedStyle, headDateStyle, headTextStyle);
                this.createCell(headRow, columnIndex, presetItemEnum.getImportColumnName(), presetItemEnum.isRequire(), style, this.getDataType(presetItemEnum), drawingPatriarch);
                continue;
            }
            this.createCell(headRow, columnIndex, name, false, headTextStyle, null, drawingPatriarch);
        }
        Iterator<Map<String, String>> iterator = allIndexSet.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)((Object)iterator.next());
            int columnWidth = sheet.getColumnWidth(index);
            sheet.setColumnWidth(index, columnWidth * 3);
        }
        this.batchSetDefaulColumnStyle(sheet, textIndexList, this.getTextCellStyle(sheet));
    }

    private String getDataType(PresetItemEnum presetItemEnum) {
        if (presetItemEnum.getDataTypeId().longValue() == DataTypeEnum.DATE.getDbId()) {
            return SWCShowType.DATE.getCode();
        }
        return SWCShowType.TEXT.getCode();
    }

    private CellStyle getFixCellStyle(PresetItemEnum presetItemEnum, CellStyle requrriedStyle, CellStyle headDateStyle, CellStyle headTextStyle) {
        if (presetItemEnum.isRequire()) {
            return requrriedStyle;
        }
        if (presetItemEnum.getDataTypeId().longValue() == DataTypeEnum.DATE.getDbId()) {
            return headDateStyle;
        }
        return headTextStyle;
    }

    private void createCell(SXSSFRow headRow, int cellIndex, String name, boolean isRequried, CellStyle cellStyle, String dataType, SXSSFDrawing drawingPatriarch) {
        SXSSFCell cell = headRow.createCell(cellIndex);
        String value = "";
        value = isRequried ? "*" + name : name;
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
        if (dataType != null) {
            cell.setCellComment(this.getComment(drawingPatriarch, cell, dataType));
        }
    }

    private Comment getComment(SXSSFDrawing drawingPatriarch, SXSSFCell cell, String datatype) {
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
        String text = this.assembleCommentText(datatype);
        comment.setString((RichTextString)new XSSFRichTextString(text));
        return comment;
    }

    private String assembleCommentText(String dataType) {
        String text = SWCShowType.AMOUNT.getCode().equals(dataType) || SWCShowType.NUM.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u5b57\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_59", (String)"swc-hsas-business", (Object[])new Object[0]) : (SWCShowType.DATE.getCode().equals(dataType) ? ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\uff0c\u683c\u5f0f\u4e3aYYYY-MM-DD\u3002", (String)"CalResultCoverImportService_60", (String)"swc-hsas-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6587\u672c\u683c\u5f0f\u3002", (String)"CalResultCoverImportService_61", (String)"swc-hsas-business", (Object[])new Object[0]));
        return text;
    }

    private void flushAllAndDownload(SXSSFWorkbook wb, String fileName, IFormView view) {
        String url = SWCExportDataHelper.storeFile((Workbook)wb, fileName);
        if (SWCStringUtils.isNotEmpty((String)url)) {
            view.download(url);
        }
    }

    public String getImportErrorExcelFile(List<Map<Integer, String>> dataHeadList, List<Map<Integer, String>> dataRowList, List<Map<String, String>> errDataList, int headIndex, String writeTaskType, Map<Integer, List<Map<String, String>>> columnIndexMap, boolean hasWorkStartDate) {
        logger.info("getImportErrorExcelFile begin");
        String url = "";
        int rowNum = headIndex + dataRowList.size() + 2;
        try (SXSSFWorkbook wb = new SXSSFWorkbook(rowNum);){
            String dd = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            String exportFileName = MessageFormat.format(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u4efb\u52a1_\u6570\u636e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c_{0}", (String)"ImportTaskGuideExportService_3", (String)"swc-hsas-business", (Object[])new Object[0]), dd);
            String sheetName = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f", (String)"ImportTaskGuideExportService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
            SXSSFSheet sheet = wb.createSheet(sheetName);
            sheet.setRandomAccessWindowSize(-1);
            SXSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
            this.createHeadRow(dataHeadList, headIndex, sheet, drawingPatriarch, writeTaskType);
            this.batchSetDefaulColumnStyle(sheet, this.getTextColumnIndexList(columnIndexMap, writeTaskType), this.getTextCellStyle(sheet));
            HashSet<Integer> allIndexSet = new HashSet<Integer>(columnIndexMap.size() + 12);
            for (int index : columnIndexMap.keySet()) {
                allIndexSet.add(index + 1);
            }
            if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
                allIndexSet.addAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}));
            } else {
                allIndexSet.addAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
            }
            sheet.setColumnWidth(0, sheet.getColumnWidth(0) * 4);
            for (int index : allIndexSet) {
                int columnWidth = sheet.getColumnWidth(index);
                sheet.setColumnWidth(index, columnWidth * 3);
            }
            this.addDataRow(dataRowList, errDataList, headIndex, wb, sheet);
            url = SWCExportDataHelper.storeFile((Workbook)wb, exportFileName);
        }
        catch (Exception exception) {
            logger.error("getImportErrorExcelFile  error : ", (Throwable)exception);
        }
        logger.info("getImportErrorExcelFile end");
        return url;
    }

    private List<Integer> getTextColumnIndexList(Map<Integer, List<Map<String, String>>> columnIndexMap, String writeTaskType) {
        ArrayList<Integer> textIndexList = new ArrayList<Integer>(columnIndexMap.size() + 12);
        if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
            textIndexList.addAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12}));
        } else {
            textIndexList.addAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
        }
        for (Map.Entry<Integer, List<Map<String, String>>> entry : columnIndexMap.entrySet()) {
            String dataTypeIdStr;
            List<Map<String, String>> paramMapList = entry.getValue();
            if (CollectionUtils.isEmpty(paramMapList) || SWCStringUtils.isEmpty((String)(dataTypeIdStr = paramMapList.get(0).get("datatypeid"))) || Long.parseLong(dataTypeIdStr) != DataTypeEnum.STRING.getDbId()) continue;
            textIndexList.add(entry.getKey() + 1);
        }
        return textIndexList;
    }

    private void batchSetDefaulColumnStyle(SXSSFSheet sheet, List<Integer> indexList, CellStyle cellStyle) {
        for (int index : indexList) {
            sheet.setDefaultColumnStyle(index, cellStyle);
        }
    }

    private CellStyle getTextCellStyle(SXSSFSheet sheet) {
        CellStyle textCellStyle = sheet.getWorkbook().createCellStyle();
        textCellStyle.setDataFormat((short)49);
        return textCellStyle;
    }

    private void addDataRow(List<Map<Integer, String>> dataRowList, List<Map<String, String>> errDataList, int headIndex, SXSSFWorkbook wb, SXSSFSheet sheet) {
        Map<Integer, List<String>> errorMap = this.getErrorMap(errDataList);
        boolean isTplError = TPLERROR.equals(errDataList.get(0).get("isAll"));
        int tplIndex = headIndex++;
        CellStyle errColumnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, "text", HorizontalAlignment.LEFT, wb, (short)9, true);
        Font font = wb.createFont();
        font.setColor((short)10);
        errColumnStyle.setFont(font);
        CellStyle columnStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, "text", HorizontalAlignment.LEFT, wb, (short)9, true);
        List<String> errorList = null;
        Map<Integer, String> rowMap = null;
        SXSSFRow dataRow = null;
        SXSSFCell cell = null;
        int length = dataRowList.size();
        for (int index = 0; index < length; ++index) {
            errorList = errorMap.get(index);
            if (isTplError) {
                errorList = errorMap.get(tplIndex);
            }
            if (errorList == null) continue;
            rowMap = dataRowList.get(index);
            dataRow = sheet.createRow(headIndex);
            ++headIndex;
            cell = dataRow.createCell(0);
            cell.setCellStyle(errColumnStyle);
            cell.setCellValue(this.getErrorMsg(errorList));
            for (Map.Entry<Integer, String> entry : rowMap.entrySet()) {
                cell = dataRow.createCell(entry.getKey() + 1);
                cell.setCellStyle(columnStyle);
                cell.setCellValue(entry.getValue());
            }
        }
    }

    private String getErrorMsg(List<String> errorList) {
        StringBuilder key = new StringBuilder();
        int index = 1;
        for (String msg : errorList) {
            key.append(index).append('.').append(' ').append(msg).append(' ');
            ++index;
        }
        return key.toString();
    }

    private Map<Integer, List<String>> getErrorMap(List<Map<String, String>> errDataList) {
        HashMap<Integer, List<String>> errorMap = new HashMap<Integer, List<String>>(16);
        List tempList = null;
        for (Map<String, String> tempMap : errDataList) {
            tempList = errorMap.getOrDefault(Integer.valueOf(tempMap.get("dataIndex")), new ArrayList());
            tempList.add(tempMap.get("errMsg"));
            errorMap.put(Integer.valueOf(tempMap.get("dataIndex")), tempList);
        }
        return errorMap;
    }

    private void createHeadRow(List<Map<Integer, String>> dataHeadList, int headIndex, SXSSFSheet sheet, SXSSFDrawing drawingPatriarch, String writeTaskType) {
        SXSSFRow headRow = sheet.createRow(headIndex);
        CellStyle headTextStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        SXSSFCell errMsgCell = headRow.createCell(0);
        errMsgCell.setCellValue(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"CalResultCoverImportService_58", (String)"swc-hsas-business", (Object[])new Object[0]));
        errMsgCell.setCellStyle(headTextStyle);
        Font font = sheet.getWorkbook().createFont();
        CellStyle requrriedStyle = CalResultCoverImportService.getColumnStyle(true, 0, 0, SWCShowType.TEXT.getCode(), HorizontalAlignment.LEFT, sheet.getWorkbook(), HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex(), true);
        font.setColor((short)10);
        requrriedStyle.setFont(font);
        Set<Integer> requireFixColumnSet = ImportTaskUtils.getExportTplRequireColumnSet(writeTaskType);
        Map<Integer, String> headMap = dataHeadList.get(0);
        CellStyle style = null;
        for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
            style = requireFixColumnSet.contains(entry.getKey()) ? requrriedStyle : headTextStyle;
            this.createCell(headRow, entry.getKey() + 1, entry.getValue(), false, style, null, drawingPatriarch);
        }
    }
}

