/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide.export;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.MigrationFailTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class MigrationDetailExportHelper {
    protected static final Log logger = LogFactory.getLog(MigrationDetailExportHelper.class);
    private static final String SYSTEM_NAME = "swc-hsas-business";
    private static final int CONTENT_ROW_START_LINE = 1;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final Integer PAGE_SIZE = 100;
    private static Map<String, String> failMsgMap = new HashMap<String, String>(ImportTaskFailMsgEnum.values().length);
    private static Map<String, String> failTypeMap = new HashMap<String, String>(MigrationFailTypeEnum.values().length);

    public Map<String, String> getExportHeaders() {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        headerMap.put("caltaskname", ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1", (String)"MigrationDetailExportHelper_0", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("salaryfilenumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"MigrationDetailExportHelper_1", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"MigrationDetailExportHelper_2", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("failtype", ResManager.loadKDString((String)"\u5931\u8d25\u7c7b\u578b", (String)"MigrationDetailExportHelper_3", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("errorelement", ResManager.loadKDString((String)"\u51fa\u9519\u5143\u7d20", (String)"MigrationDetailExportHelper_4", (String)SYSTEM_NAME, (Object[])new Object[0]));
        headerMap.put("failmsg", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"MigrationDetailExportHelper_5", (String)SYSTEM_NAME, (Object[])new Object[0]));
        return headerMap;
    }

    public void mutiThreadExport(RequestContext ctx, String fileName, Map<String, String> headers, int totalPages, CountDownLatch countDownLatch, IFormView view, int totalElements, String downLoadTaskId, List<Long> verifyDetailList) {
        CalTableExportProgressInfo progressInfo = new CalTableExportProgressInfo();
        ThreadPools.executeOnce((String)"MIGRATION_EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            logger.info("starting export data: {}", (Object)stopWatch.toString());
            try (SXSSFWorkbook wb = new SXSSFWorkbook(100);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                this.write2ExportHead(sheet, null, null, headers);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
                        boolean hasLock = false;
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            QFilter[] filters = new QFilter[1];
                            int startIndex = currentPage * 100;
                            int endIndex = currentPage * 100 + PAGE_SIZE;
                            if (endIndex > totalElements) {
                                endIndex = totalElements;
                            }
                            filters[0] = new QFilter("id", "in", verifyDetailList.subList(startIndex, endIndex));
                            List<Map<String, Object>> data = this.getExportData(filters, headers);
                            lock.lock();
                            this.createContentColumn(sheet, currentPage * PAGE_SIZE + 1, data, headers);
                        }
                        catch (Exception e) {
                            logger.error("VerifyReportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(view);
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            if (totalElements < 100) {
                                complete = totalElements;
                            } else {
                                complete = ((long)totalPages - countDownLatch.getCount()) * (long)PAGE_SIZE.intValue();
                                if (complete > (long)totalElements) {
                                    complete = totalElements;
                                }
                            }
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                    this.flushAll(headers, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements, view);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, CalTableExportProgressInfo progressInfo, int totalElements, IFormView view) throws IOException {
        List<Map<String, String>> headList = SWCExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = SWCExportDataHelper.writeFile(sheet.getWorkbook(), fileName);
        SWCPageCache pageCache = new SWCPageCache(view);
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        TaskUtil.addTaskInfoToCache((CalTableExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)totalElements, (String)downLoadTaskId);
        stopWatch.stop();
        logger.info("ending export data: {},countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    private void createContentColumn(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headMap) {
        if (exportDataList.isEmpty()) {
            return;
        }
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = null;
            exportDataMap = exportDataList.get(rowIndex - beginIndex);
            int columnIndex = 0;
            for (Map.Entry<String, String> entry : headMap.entrySet()) {
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = entry.getKey();
                Object value = exportDataMap.get(key);
                if (SWCStringUtils.equals((String)key, (String)"failtype")) {
                    value = failTypeMap.get(value);
                }
                if (SWCStringUtils.equals((String)key, (String)"failmsg")) {
                    value = failMsgMap.get(value);
                }
                String dataType = "text";
                MigrationDetailExportHelper.parseCellValue(columnCell, value, dataType);
                columnCell.setCellType(MigrationDetailExportHelper.getCellType(dataType));
                ++columnIndex;
            }
        }
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    public static void parseCellValue(SXSSFCell cell, Object value, String dataType) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        }
    }

    private List<Map<String, Object>> getExportData(QFilter[] filters, Map<String, String> headers) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        String fields = "caltaskname,salaryfilenumber,name,failtype,errorelement,failmsg";
        SWCDataServiceHelper verifyDetailHelper = new SWCDataServiceHelper("hsas_verifydetail");
        DynamicObjectCollection verifyDetails = verifyDetailHelper.queryOriginalCollection(fields, filters);
        for (DynamicObject verifyDetail : verifyDetails) {
            LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(16);
            for (String key : headers.keySet()) {
                valueMap.put(key, verifyDetail.get(key));
            }
            dataList.add(valueMap);
        }
        return dataList;
    }

    private Sheet write2ExportHead(SXSSFSheet sheet, String pageKey, String pageName, Map<String, String> headMap) {
        int row = 0;
        SXSSFRow headRow = sheet.createRow(row);
        SXSSFWorkbook wb = sheet.getWorkbook();
        int i = 0;
        for (Map.Entry<String, String> entry : headMap.entrySet()) {
            SXSSFCell cell = headRow.createCell(i);
            String headString = entry.getValue();
            cell.setCellValue(headString);
            CellStyle headColumnStyle = this.getHeadColumnStyle(wb);
            cell.setCellStyle(headColumnStyle);
            ++i;
        }
        return sheet;
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    static {
        for (ImportTaskFailMsgEnum importTaskFailMsgEnum : ImportTaskFailMsgEnum.values()) {
            failMsgMap.put(importTaskFailMsgEnum.getCode(), importTaskFailMsgEnum.getDesc());
        }
        for (ImportTaskFailMsgEnum importTaskFailMsgEnum : MigrationFailTypeEnum.values()) {
            failTypeMap.put(importTaskFailMsgEnum.getCode(), importTaskFailMsgEnum.getDesc());
        }
    }
}

