/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.importtaskguide.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.common.enums.PresetItemEnum;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ImportTaskUtils {
    public static final String FIX = "fix";
    public static final String FT = "ft";
    public static final String SL = "sl";
    public static final String BS = "bs";
    public static final String SP = "sp";

    public static int getExcelRowIndexByTitle(String columnTitle) {
        int length = columnTitle.length();
        int num = 0;
        for (int i = 0; i < length; ++i) {
            num = num * 26 + (columnTitle.charAt(i) - 65 + 1);
        }
        return num - 1;
    }

    public static DynamicObject getMigrationTplData(Long migrationTplId, String fields, QFilter qFilter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_migrationtpl");
        QFilter filter = new QFilter("id", "=", (Object)migrationTplId);
        if (qFilter != null) {
            filter.and(qFilter);
        }
        return helper.queryOne(fields, new QFilter[]{filter});
    }

    public static List<Map<String, String>> getColumnHeadList(Long migrationtplId, Long importTaskId) {
        String cacheKey;
        ISWCAppCache appCache;
        String json;
        List<Map<String, String>> columnHeadList = new ArrayList<Map<String, String>>(10);
        if (migrationtplId != null && migrationtplId != 0L && importTaskId != null && importTaskId != 0L && SWCStringUtils.isNotEmpty((String)(json = (String)(appCache = SWCAppCache.get((String)(cacheKey = importTaskId + "_" + migrationtplId))).get("columnHeadList", String.class)))) {
            columnHeadList = (List)SerializationUtils.fromJsonString((String)json, List.class);
            return columnHeadList;
        }
        DynamicObjectCollection list = ImportTaskUtils.getMigrationTplDataList(migrationtplId);
        if (list.size() == 0) {
            return columnHeadList;
        }
        ArrayList<String> itemList = new ArrayList<String>(10);
        HashMap<String, Map<String, String>> itemMap = new HashMap<String, Map<String, String>>(list.size());
        HashSet<Long> fixSet = new HashSet<Long>(16);
        HashSet<Long> ftItemSet = new HashSet<Long>(16);
        HashSet<Long> slItemSet = new HashSet<Long>(16);
        HashSet<Long> spItemSet = new HashSet<Long>(16);
        HashSet<Long> bsItemSet = new HashSet<Long>(16);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (DynamicObject obj : list) {
            String itemType = obj.getString("hsas_migrationtplent.itemtype");
            Long itemId = obj.getLong("hsas_migrationtplent.itemid");
            if ("0".equals(itemType)) {
                itemList.add(FIX + itemId);
                indexMap.put(FIX + itemId, ImportTaskUtils.getExcelRowIndexByTitle(obj.getString("hsas_migrationtplent.matchcolumn")));
                fixSet.add(itemId);
                continue;
            }
            if ("4".equals(itemType)) {
                itemList.add(FT + itemId);
                indexMap.put(FT + itemId, ImportTaskUtils.getExcelRowIndexByTitle(obj.getString("hsas_migrationtplent.matchcolumn")));
                ftItemSet.add(itemId);
                continue;
            }
            if ("1".equals(itemType)) {
                itemList.add(SL + itemId);
                indexMap.put(SL + itemId, ImportTaskUtils.getExcelRowIndexByTitle(obj.getString("hsas_migrationtplent.matchcolumn")));
                slItemSet.add(itemId);
                continue;
            }
            if ("3".equals(itemType)) {
                itemList.add(BS + itemId);
                indexMap.put(BS + itemId, ImportTaskUtils.getExcelRowIndexByTitle(obj.getString("hsas_migrationtplent.matchcolumn")));
                bsItemSet.add(itemId);
                continue;
            }
            if (!"2".equals(itemType)) continue;
            itemList.add(SP + itemId);
            indexMap.put(SP + itemId, ImportTaskUtils.getExcelRowIndexByTitle(obj.getString("hsas_migrationtplent.matchcolumn")));
            spItemSet.add(itemId);
        }
        ImportTaskUtils.addFixValue(fixSet, FIX, itemMap, "0");
        ImportTaskUtils.addItemValue(ftItemSet, FT, itemMap, "hsbs_fetchitem", "4");
        ImportTaskUtils.addItemValue(slItemSet, SL, itemMap, "hsbs_salaryitem", "1");
        ImportTaskUtils.addItemValue(bsItemSet, BS, itemMap, "hsbs_bizitem", "3");
        ImportTaskUtils.addItemValue(spItemSet, SP, itemMap, "hsbs_supportitem", "2");
        if (itemMap.size() == 0) {
            return columnHeadList;
        }
        Integer columnIndex = null;
        Map tempMap = null;
        for (String key : itemList) {
            tempMap = (Map)itemMap.get(key);
            if (tempMap == null) continue;
            columnIndex = (Integer)indexMap.get(key);
            tempMap.put("columnIndex", String.valueOf(columnIndex));
            columnHeadList.add(tempMap);
        }
        if (migrationtplId != null && migrationtplId != 0L && importTaskId != null && importTaskId != 0L) {
            String cacheKey2 = importTaskId + "_" + migrationtplId;
            ISWCAppCache appCache2 = SWCAppCache.get((String)cacheKey2);
            appCache2.put("columnHeadList", (Object)SerializationUtils.toJsonString(columnHeadList));
        }
        return columnHeadList;
    }

    private static void addFixValue(Set<Long> itemSet, String itemKey, Map<String, Map<String, String>> itemMap, String itemType) {
        if (itemSet.size() == 0) {
            return;
        }
        Map map = PresetItemEnum.getPresetItemEnumMap();
        PresetItemEnum itemEnum = null;
        HashMap<String, String> tempMap = null;
        for (Long itemId : itemSet) {
            itemEnum = (PresetItemEnum)map.get(itemId);
            tempMap = new HashMap<String, String>(16);
            tempMap.put("name", itemEnum.getItemName());
            tempMap.put("datatypeid", String.valueOf(itemEnum.getDataTypeId()));
            tempMap.put("id", String.valueOf(itemId));
            tempMap.put("key", ImportTaskUtils.getFixColumnKeyByItemId(itemId.toString()));
            tempMap.put("itemType", itemType);
            itemMap.put(itemKey + itemId, tempMap);
        }
    }

    private static String getFixColumnKeyByItemId(String itemId) {
        String columnKey = null;
        switch (itemId) {
            case "1": {
                columnKey = "caltaskname";
                break;
            }
            case "2": {
                columnKey = "payrollgroup.name";
                break;
            }
            case "3": {
                columnKey = "payrollscene.name";
                break;
            }
            case "4": {
                columnKey = "periodtypename";
                break;
            }
            case "5": {
                columnKey = "periodname";
                break;
            }
            case "6": {
                columnKey = "paydate";
                break;
            }
            case "7": {
                columnKey = "empnumber";
                break;
            }
            case "8": {
                columnKey = "empname";
                break;
            }
            case "9": {
                columnKey = "filenumber";
                break;
            }
            case "10": {
                columnKey = "adminorgname";
                break;
            }
            case "11": {
                columnKey = "empgroupname";
                break;
            }
            case "12": {
                columnKey = "caltaskname";
                break;
            }
            case "13": {
                columnKey = "empnumber";
                break;
            }
            case "14": {
                columnKey = "empname";
                break;
            }
            case "15": {
                columnKey = "filenumber";
                break;
            }
            case "16": {
                columnKey = "workstartdate";
                break;
            }
        }
        return columnKey;
    }

    private static void addItemValue(Set<Long> itemSet, String itemKey, Map<String, Map<String, String>> itemMap, String entityId, String itemType) {
        if (itemSet.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityId);
        String fields = "id,datatype.id,name";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{new QFilter("id", "in", itemSet)});
        HashMap<String, String> tempMap = null;
        for (DynamicObject obj : result) {
            tempMap = new HashMap<String, String>(16);
            tempMap.put("name", obj.getString("name"));
            tempMap.put("datatypeid", String.valueOf(obj.getLong("datatype.id")));
            tempMap.put("id", String.valueOf(obj.getLong("id")));
            tempMap.put("key", itemKey + obj.getLong("id"));
            tempMap.put("itemType", itemType);
            itemMap.put(itemKey + obj.getLong("id"), tempMap);
        }
    }

    private static DynamicObjectCollection getMigrationTplDataList(Long migrationtplId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_migrationtpl");
        String fields = "hsas_migrationtplent.itemtype,hsas_migrationtplent.itemid,hsas_migrationtplent.matchcolumn";
        QFilter qFilter = new QFilter("id", "=", (Object)migrationtplId);
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter}, "hsas_migrationtplent.seq asc");
    }

    public static QFilter getDateFilter(Date startDate, Date endDate) {
        startDate = HandleProrationHelper.replaceDateTime((Date)startDate, (String)"00:00:00");
        endDate = HandleProrationHelper.replaceDateTime((Date)endDate, (String)"23:59:59");
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)startDate);
        bsledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(bsledFilter);
        return filter;
    }

    public static void updateImportTaskStatus(Long importTaskId) {
        SWCDataServiceHelper temporaryHelper = new SWCDataServiceHelper("hsas_temporarydata");
        QFilter filter = new QFilter("importtask", "=", (Object)importTaskId);
        int count = temporaryHelper.count(new QFilter[]{filter});
        if (count == 0) {
            ImportTaskUtils.updateImportTaskByDelete(importTaskId, "0", count);
            return;
        }
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"5");
        int writedCount = temporaryHelper.count(new QFilter[]{filter, statusFilter});
        if (count == writedCount) {
            ImportTaskUtils.updateImportTaskByDelete(importTaskId, "2", count);
            return;
        }
        ImportTaskUtils.updateImportTaskByDelete(importTaskId, null, count);
    }

    private static void updateImportTaskByDelete(Long importTaskId, String taskStatus, int count) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject task = taskHelper.queryOne((Object)importTaskId);
        if (taskStatus != null) {
            task.set("taskstatus", (Object)taskStatus);
        }
        task.set("count", (Object)count);
        task.set("modifytime", (Object)new Date());
        task.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskHelper.updateOne(task);
    }

    public static void updateImportTaskStatus(Long importTaskId, String taskStatus) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_importtask");
        DynamicObject task = taskHelper.queryOne((Object)importTaskId);
        task.set("taskstatus", (Object)taskStatus);
        task.set("modifytime", (Object)new Date());
        task.set("modifier", (Object)RequestContext.get().getCurrUserId());
        taskHelper.updateOne(task);
    }

    public static synchronized boolean updatePreDaalProgress(int successCount, int failCount, Long verifyRecordId) {
        int totalCount;
        int dbFailCount;
        boolean isFinish = false;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
        String fields = "id,failcount,sucesscount,totalcount,endtime,status,modifytime";
        DynamicObject result = helper.queryOne(fields, (Object)verifyRecordId);
        int dbSuccCount = result.getInt("sucesscount") + successCount;
        int sumCount = dbSuccCount + (dbFailCount = result.getInt("failcount") + failCount);
        if (sumCount == (totalCount = result.getInt("totalcount"))) {
            isFinish = true;
            result.set("endtime", (Object)new Date());
            result.set("status", (Object)"2");
        }
        result.set("sucesscount", (Object)dbSuccCount);
        result.set("failcount", (Object)dbFailCount);
        result.set("modifytime", (Object)new Date());
        helper.updateOne(result);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "datapredeal_cache_%s", verifyRecordId));
        appCache.put("successCount", (Object)dbSuccCount);
        appCache.put("failCount", (Object)dbFailCount);
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", verifyRecordId));
        String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            int progress = 0;
            if (isFinish) {
                progress = 100;
            } else {
                progress = sumCount * 100 / totalCount;
                if (progress == 100) {
                    progress = 99;
                }
            }
            HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, progress, "", null);
        }
        return isFinish;
    }

    public static synchronized void updateImportDataProgress(int successCount, int failCount, String cacheKey, String fileUrl) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "import_cache_%s", cacheKey));
        Integer existSuccCount = (Integer)appCache.get("successCount", Integer.class);
        Integer existFailCount = (Integer)appCache.get("failCount", Integer.class);
        if (existSuccCount == null) {
            existSuccCount = 0;
        }
        if (existFailCount == null) {
            existFailCount = 0;
        }
        existSuccCount = existSuccCount + successCount;
        existFailCount = existFailCount + failCount;
        appCache.put("successCount", (Object)existSuccCount);
        appCache.put("failCount", (Object)existFailCount);
        if (fileUrl != null) {
            appCache.put("fileUrl", (Object)fileUrl);
        }
        Integer sumCount = existSuccCount + existFailCount;
        ISWCAppCache bgAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "bggroud_taskid_%s", cacheKey));
        String bgTaskId = (String)bgAppCache.get("bgTaskId", String.class);
        if (SWCStringUtils.isNotEmpty((String)bgTaskId)) {
            Integer totalCount = bgAppCache.get("totalCount", Integer.class) == null ? Integer.valueOf(0) : (Integer)bgAppCache.get("totalCount", Integer.class);
            int progress = 0;
            if (totalCount == 0) {
                return;
            }
            if (sumCount.equals(totalCount)) {
                progress = 100;
            } else {
                progress = sumCount * 100 / totalCount;
                if (progress == 100) {
                    progress = 99;
                }
            }
            HRBackgroundTaskHelper.getInstance().feedbackProgress(bgTaskId, progress, "", null);
        }
    }

    public static boolean isCancelPreDeal(Long cacheKey) {
        String key = String.format(Locale.ROOT, "datapredeal_cache_%s", cacheKey);
        ISWCAppCache appCache = SWCAppCache.get((String)key);
        Boolean flag = (Boolean)appCache.get(String.format(Locale.ROOT, "isCancel_%s", cacheKey), Boolean.class);
        return flag != null && flag != false;
    }

    public static DynamicObject getVerifyDetailObj(DynamicObjectType type, DynamicObject temporary, String failType, ImportTaskFailMsgEnum faileTypeEnum, Long verifyRecordId) {
        DynamicObject verifyObj = (DynamicObject)type.createInstance();
        verifyObj.set("verifyrecord", (Object)verifyRecordId);
        verifyObj.set("temporarydata", (Object)temporary.getLong("id"));
        verifyObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        verifyObj.set("createtime", (Object)new Date());
        verifyObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        verifyObj.set("modifytime", (Object)new Date());
        verifyObj.set("name", (Object)temporary.getString("empname"));
        verifyObj.set("salaryfilenumber", (Object)temporary.getString("filenumber"));
        verifyObj.set("caltaskname", (Object)temporary.getString("caltaskname"));
        verifyObj.set("failtype", (Object)failType);
        verifyObj.set("failmsg", (Object)faileTypeEnum.getCode());
        verifyObj.set("errorelement", (Object)faileTypeEnum.getErrorElement());
        return verifyObj;
    }

    public static void setTemporaryValueForHisDataImoport(DynamicObject temporary, Map<Integer, Object> rowMap, Map<String, DynamicObject> adminOrgMap, boolean hasWorkStartDate) {
        temporary.set("caltaskname", rowMap.get(0) == null ? " " : rowMap.get(0));
        temporary.set("payrollgroup", rowMap.get(1));
        temporary.set("payrollscene", rowMap.get(2) == null ? Long.valueOf(0L) : rowMap.get(2));
        temporary.set("periodtypename", rowMap.get(3));
        temporary.set("periodname", rowMap.get(4));
        temporary.set("paydate", rowMap.get(5));
        temporary.set("empnumber", rowMap.get(6));
        temporary.set("empname", rowMap.get(7));
        temporary.set("filenumber", rowMap.get(8));
        temporary.set("empgroupname", rowMap.get(10) == null ? " " : rowMap.get(10));
        if (hasWorkStartDate) {
            temporary.set("workstartdate", rowMap.get(11));
        }
        if (adminOrgMap == null) {
            return;
        }
        DynamicObject adminOrg = adminOrgMap.get(rowMap.get(9));
        if (adminOrg != null) {
            temporary.set("adminorgname", (Object)adminOrg.getString("name"));
            temporary.set("adminorg", (Object)adminOrg.getLong("id"));
        }
    }

    public static void setTemporaryValueForCommon(DynamicObject temporary, Map<Integer, Object> rowMap) {
        temporary.set("caltaskname", rowMap.get(0));
        temporary.set("payrollgroup", rowMap.get(-1));
        temporary.set("payrollscene", rowMap.get(-2));
        temporary.set("empnumber", rowMap.get(1));
        temporary.set("empname", rowMap.get(2));
        temporary.set("filenumber", rowMap.get(3));
    }

    public static DynamicObjectCollection getItemEntryList(Map<Integer, Object> rowMap, Map<Integer, List<Map<String, String>>> columnIndexMap, EntityType entryType) {
        DynamicObjectCollection itemEntryList = new DynamicObjectCollection();
        Object itemValue = null;
        DynamicObject item = null;
        int seq = 0;
        for (Map.Entry<Integer, List<Map<String, String>>> entry : columnIndexMap.entrySet()) {
            itemValue = rowMap.get(entry.getKey());
            if (itemValue == null) continue;
            for (Map<String, String> itemMap : entry.getValue()) {
                item = (DynamicObject)entryType.createInstance();
                item.set("itemvalue", itemValue);
                item.set("itemtype", (Object)itemMap.get("itemType"));
                item.set("seq", (Object)seq);
                item.set("itemid", (Object)Long.valueOf(itemMap.get("id")));
                item.set("datatype", (Object)Long.valueOf(itemMap.get("datatypeid")));
                ++seq;
                itemEntryList.add((Object)item);
            }
        }
        return itemEntryList;
    }

    public static Set<Integer> getExportTplRequireColumnSet(String writeTaskType) {
        HashSet<Integer> requireFixColumnSet = new HashSet<Integer>(16);
        if (WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(writeTaskType)) {
            requireFixColumnSet.add(1);
            requireFixColumnSet.add(3);
            requireFixColumnSet.add(4);
            requireFixColumnSet.add(6);
            requireFixColumnSet.add(7);
        } else {
            requireFixColumnSet.add(0);
            requireFixColumnSet.add(1);
            requireFixColumnSet.add(2);
            requireFixColumnSet.add(3);
        }
        return requireFixColumnSet;
    }
}

