/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.insurancedata;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.insurancedata.ISaveInsuranceDataSynExtService;
import kd.sdk.swc.hsas.common.events.insurancedata.BeforeSaveInsuranceDataListEvent;
import kd.swc.hsas.business.insurancedata.service.SaveInsuranceDataSynExtService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class InsuranceDataServiceHelper {
    public void dealInsuranceMsg(Map<String, Object> message) {
        List ids = (List)message.get("ids");
        String type = (String)message.get("type");
        Long logId = (Long)message.get("logId");
        String withholdtype = (String)message.get("withholdtype");
        String withholddateStr = (String)message.get("withholddate");
        Date withholddate = null;
        if (SWCStringUtils.isNotEmpty((String)withholddateStr)) {
            try {
                withholddate = SWCDateTimeUtils.parseDate((String)withholddateStr, (String)"yyyy-MM");
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_insurancedata");
        switch (type) {
            case "1": {
                List resultList = (List)SWCMServiceUtils.invokeSITService((String)"hcsi", (String)"ICalResultService", (String)"getCalPersonByIds", (Object[])new Object[]{ids});
                MainEntityType metatype = EntityMetadataCache.getDataEntityType((String)"hsas_insurancedata");
                EntityType entityType = (EntityType)metatype.getAllEntities().get("entryentity");
                List<DynamicObject> results = new ArrayList(ids.size());
                Map<Date, Map<Long, Long>> dateEmployeeDepempMap = this.getDepempByEmploeeIds(resultList);
                Map<Object, Object> existDataMap = new HashMap(16);
                DynamicObject[] existDatas = helper.query("id,batchid", new QFilter[]{new QFilter("id", "in", (Object)ids)});
                if (existDatas != null && existDatas.length > 0) {
                    existDataMap = Arrays.stream(existDatas).collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (v1, v2) -> v1));
                }
                long currUserId = RequestContext.get().getCurrUserId();
                for (Map result : resultList) {
                    Long id = (Long)result.get("id");
                    DynamicObject existData = (DynamicObject)existDataMap.get(id);
                    if (existData != null) {
                        existData.set("batchid", result.get("batchid"));
                        continue;
                    }
                    Date perioddate = (Date)result.get("perioddate");
                    if (perioddate != null) {
                        perioddate = SWCDateTimeUtils.lastDayOfMonth((Date)perioddate);
                    }
                    Long employeeId = (Long)result.get("employee");
                    DynamicObject instance = (DynamicObject)metatype.createInstance();
                    instance.set("id", (Object)id);
                    instance.set("filenumber", result.get("filenumber"));
                    instance.set("person", result.get("person"));
                    instance.set("withholdtype", (Object)withholdtype);
                    instance.set("withholddate", (Object)withholddate);
                    instance.set("employee", (Object)employeeId);
                    instance.set("sinsurperiodnumber", result.get("sinsurperiodnumber"));
                    instance.set("perioddate", (Object)perioddate);
                    instance.set("batchid", result.get("batchid"));
                    instance.set("usestatus", (Object)"0");
                    Date now = new Date();
                    instance.set("id", (Object)id);
                    instance.set("createtime", (Object)now);
                    instance.set("modifytime", (Object)now);
                    instance.set("creator", (Object)currUserId);
                    instance.set("modifier", (Object)currUserId);
                    Map<Long, Long> employeeDepempMap = dateEmployeeDepempMap.get(perioddate);
                    if (employeeDepempMap != null) {
                        instance.set("depemp", (Object)employeeDepempMap.get(employeeId));
                    }
                    DynamicObjectCollection calResults = instance.getDynamicObjectCollection("entryentity");
                    List entryentity = (List)result.get("entryentity");
                    if (entryentity != null) {
                        for (Map entity : entryentity) {
                            DynamicObject entityObj = (DynamicObject)entityType.createInstance();
                            entityObj.set("seq", entity.get("seq"));
                            entityObj.set("insuranceitem", entity.get("insuranceitem"));
                            entityObj.set("numvalue", entity.get("numvalue"));
                            entityObj.set("amountvalue", entity.get("amountvalue"));
                            entityObj.set("isnull", entity.get("isnull"));
                            entityObj.set("currency", entity.get("currency"));
                            entityObj.set("storagetype", entity.get("storagetype"));
                            calResults.add((Object)entityObj);
                        }
                    }
                    results.add(instance);
                }
                BeforeSaveInsuranceDataListEvent beforeSaveInsuranceDataListEvent = new BeforeSaveInsuranceDataListEvent(results, resultList);
                InsuranceDataServiceHelper.invokeBeforeSaveInsuranceDataList(beforeSaveInsuranceDataListEvent);
                results = beforeSaveInsuranceDataListEvent.getSaveInsuranceDataList();
                helper.save(results.toArray(new DynamicObject[0]));
                if (existDatas != null && existDatas.length > 0) {
                    helper.update(existDatas);
                }
                SWCMServiceUtils.invokeSITService((String)"hcsi", (String)"ICalResultService", (String)"updateLog", (Object[])new Object[]{type, ids, null, logId});
                break;
            }
            case "2": {
                ArrayList successIds = new ArrayList(ids);
                HashMap<Long, String> failReasonMap = new HashMap<Long, String>(16);
                DynamicObjectCollection usedObj = helper.queryOriginalCollection("id", new QFilter("usestatus", "=", (Object)"1").and("id", "in", (Object)ids).toArray());
                String failReason = ResManager.loadKDString((String)"\u5df2\u88ab\u6838\u7b97\u4efb\u52a1\u4f7f\u7528", (String)"InsuranceDataServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                for (DynamicObject obj : usedObj) {
                    long failId = obj.getLong("id");
                    failReasonMap.put(failId, failReason);
                    successIds.remove(failId);
                }
                helper.delete(successIds.toArray());
                SWCMServiceUtils.invokeSITService((String)"hcsi", (String)"ICalResultService", (String)"updateLog", (Object[])new Object[]{type, successIds, failReasonMap, logId});
                break;
            }
        }
    }

    private static void invokeBeforeSaveInsuranceDataList(BeforeSaveInsuranceDataListEvent args) {
        SaveInsuranceDataSynExtService extService = new SaveInsuranceDataSynExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ISaveInsuranceDataSynExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.insurancedata.ISaveInsuranceDataSynExtService#beforeSaveInsuranceDataList", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeSaveInsuranceDataList(args);
            return null;
        });
    }

    private Map<Date, Map<Long, Long>> getDepempByEmploeeIds(List<Map<String, Object>> resultList) {
        List employeeIds;
        HashMap<Date, List> dateEmployeesMap = new HashMap<Date, List>(16);
        for (Map<String, Object> result : resultList) {
            Date perioddate = (Date)result.get("perioddate");
            if (perioddate != null) {
                perioddate = SWCDateTimeUtils.lastDayOfMonth((Date)perioddate);
            }
            employeeIds = dateEmployeesMap.computeIfAbsent(perioddate, o -> new ArrayList(10));
            employeeIds.add((Long)result.get("employee"));
        }
        HashMap<Date, Map<Long, Long>> dateEmployeeDepempMap = new HashMap<Date, Map<Long, Long>>(16);
        for (Map.Entry entry : dateEmployeesMap.entrySet()) {
            employeeIds = (List)entry.getValue();
            Date perioddate = (Date)entry.getKey();
            QFilter qFilter = new QFilter("isprimary", "=", (Object)Boolean.TRUE);
            qFilter.and("employee.id", "in", (Object)employeeIds);
            qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
            qFilter.and("startdate", "<=", (Object)perioddate);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_depemp");
            DynamicObjectCollection dempList = helper.queryOriginalCollection("id,employee.id", qFilter.toArray(), "employee.id asc,startdate desc,enddate desc");
            Map<Long, Long> employeeDepempMap = dempList.stream().collect(Collectors.toMap(o -> o.getLong("employee.id"), o -> o.getLong("id"), (v1, v2) -> v1));
            dateEmployeeDepempMap.put(perioddate, employeeDepempMap);
        }
        return dateEmployeeDepempMap;
    }
}

