/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.modifybankaccount.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.sdk.swc.hsas.business.extpoint.paydetail.IBankAccountService;
import kd.sdk.swc.hsas.common.events.paydetail.BankAccountModifyFilterEvent;
import kd.swc.hsas.business.modifybankaccount.entity.ModifyPayDetailDTO;
import kd.swc.hsas.business.modifybankaccount.entity.ModifySdkResultDTO;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountServiceImpl;
import kd.swc.hsas.business.service.BankAccountModifyServiceHelper;
import kd.swc.hsas.common.constants.BankAccountModifyConstants;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BankAccountModifyHelper
implements BankAccountModifyConstants {
    private static Log LOG = LogFactory.getLog(BankAccountModifyHelper.class);

    public static DynamicObject[] getPayDetailInfoArr(Set<Long> pkIdSet) {
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter payDetailFilter = new QFilter("id", "in", pkIdSet);
        return payDetailHelper.query("id,salaryfilehis.id,salaryfilehis.person.id,salaryfilehis.employee.id,perbankcard.id,payrollgroup.id", new QFilter[]{payDetailFilter});
    }

    public static DynamicObject queryPersonBankAccountInfo(Long primaryKey) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter qFilter = new QFilter("id", "=", (Object)primaryKey);
        return helper.queryOne("id,username,accountrelation.id,bankcardnum,bankdeposit.id,sourcevid", qFilter.toArray());
    }

    public static String generateBankAccountModifyBill(Map<String, Map<String, List<DynamicObject>>> entryEntityGroup, IPageCache pageCache) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        Date nowDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        HashMap acctModifyBillListMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap<Long, Long> oldPayDetailAndRelatedModifyBillMap = new HashMap<Long, Long>();
        HashMap<Long, Long> payDetailAndPersonMap = new HashMap<Long, Long>();
        HashMap<String, Integer> calRepeatedMsgMap = new HashMap<String, Integer>();
        int index = 0;
        int sumSize = entryEntityGroup.values().stream().map(Map::size).reduce(0, Integer::sum);
        if (sumSize == 0) {
            return null;
        }
        long[] idArr = DB.genLongIds((String)"hsas_acctmodifybill", (int)sumSize);
        for (Map.Entry<String, Map<String, List<DynamicObject>>> entryEntityGroupMapEntry : entryEntityGroup.entrySet()) {
            DynamicObjectCollection acctModifyBillList = new DynamicObjectCollection();
            for (List<DynamicObject> entityList : entryEntityGroupMapEntry.getValue().values()) {
                long id = idArr[index++];
                DynamicObject bankAccountModifyBill = helper.generateEmptyDynamicObject();
                String number = CodeRuleHelper.getNumber((DynamicObject)bankAccountModifyBill, null);
                bankAccountModifyBill.set("id", (Object)id);
                bankAccountModifyBill.set("billno", (Object)number);
                bankAccountModifyBill.set("creator", (Object)currUserId);
                bankAccountModifyBill.set("createtime", (Object)nowDate);
                DynamicObject dyObj = entityList.get(0);
                bankAccountModifyBill.set("modifier", (Object)dyObj.getLong("auditor.id"));
                bankAccountModifyBill.set("handler", (Object)dyObj.getLong("auditor.id"));
                bankAccountModifyBill.set("acctmodifyway", (Object)dyObj.getString("acctmodifyway"));
                bankAccountModifyBill.set("billstatus", (Object)"A");
                bankAccountModifyBill.set("updatestatus", (Object)"N");
                DynamicObjectCollection modifyDetailCollection = bankAccountModifyBill.getDynamicObjectCollection("entryentity");
                bankAccountModifyBill.set("entryentity", (Object)modifyDetailCollection);
                int seqNum = 0;
                for (DynamicObject entityData : entityList) {
                    String repeatedMsgKey;
                    DynamicObject modifyDetailEntity = helper.generateEmptyEntryDynamicObject("entryentity");
                    modifyDetailEntity.set("seq", (Object)seqNum++);
                    modifyDetailEntity.set("acctmodifyreason", (Object)entityData.getLong("acctmodifyreason.id"));
                    modifyDetailEntity.set("attachmentfield", (Object)entityData.getDynamicObjectCollection("attachmentfield"));
                    modifyDetailEntity.set("salaryfilehis", entityData.get("salaryfilehis.id"));
                    long payDetailId = entityData.getLong("paydetail.id");
                    modifyDetailEntity.set("paydetail", (Object)entityData.getDynamicObject("paydetail"));
                    modifyDetailEntity.set("caltask", entityData.get("paydetail.caltask.id"));
                    modifyDetailEntity.set("perbankcard", entityData.get("paydetail.perbankcard.id"));
                    modifyDetailEntity.set("percontact", entityData.get("percontact.id"));
                    String currModifyWay = entityData.getString("acctmodifyway");
                    if ("3".equals(currModifyWay)) {
                        String lastModifyInfoJsonStr = pageCache.get("last" + payDetailId);
                        if (lastModifyInfoJsonStr == null) continue;
                        String perBankCardProps = SWCHisBaseDataHelper.getSelectProperties((String)"hrpi_perbankcard");
                        Map lastModifyInfoJSONObject = SWCJSONUtils.jsonToMap((Object)lastModifyInfoJsonStr);
                        Long modifyPerBankCardId = Long.parseLong(lastModifyInfoJSONObject.get("perbankcard") + "");
                        DynamicObject perBankCardObject = helper.generateDynamicObject("hrpi_perbankcard", (Object)modifyPerBankCardId, perBankCardProps);
                        modifyDetailEntity.set("modifyperbankcard", (Object)perBankCardObject);
                    }
                    long currAuditor = entityData.getLong("auditor.id");
                    long personId = entityData.getLong("salaryfilehis.person.id");
                    if (!SWCStringUtils.equals((String)dyObj.getString("acctmodifyway"), (String)"1") && calRepeatedMsgMap.get(repeatedMsgKey = BankAccountModifyHelper.getRepeatedMsgKey(pageCache, entityData, payDetailId, currAuditor, personId)) == null) {
                        payDetailAndPersonMap.put(payDetailId, personId);
                        calRepeatedMsgMap.put(repeatedMsgKey, 1);
                    }
                    oldPayDetailAndRelatedModifyBillMap.put(payDetailId, id);
                    modifyDetailCollection.add((Object)modifyDetailEntity);
                }
                acctModifyBillList.add((Object)bankAccountModifyBill);
            }
            acctModifyBillListMap.put(entryEntityGroupMapEntry.getKey(), acctModifyBillList);
        }
        String errorLevel = BankAccountModifyHelper.genBankAccountModifyBill(helper, acctModifyBillListMap, oldPayDetailAndRelatedModifyBillMap);
        if (errorLevel == null) {
            BankAccountModifyHelper.sendNoticeIfNotHandedByEmployeeHimself(payDetailAndPersonMap);
        }
        return errorLevel;
    }

    private static String getRepeatedMsgKey(IPageCache pageCache, DynamicObject entityData, long payDetailId, long currAuditor, long personId) {
        StringBuilder repeatedMsgKey = new StringBuilder();
        repeatedMsgKey.append(personId).append(',').append(currAuditor).append(',');
        String firstModifyInfoJsonStr = pageCache.get("first" + payDetailId);
        if (firstModifyInfoJsonStr != null) {
            Map firstModifyInfoJson = SWCJSONUtils.jsonToMap((Object)firstModifyInfoJsonStr);
            repeatedMsgKey.append(firstModifyInfoJson.get("receivername")).append(',').append(firstModifyInfoJson.get("payrollacrel")).append(',').append(firstModifyInfoJson.get("bankaccount")).append(',').append(firstModifyInfoJson.get("bebank"));
        } else {
            repeatedMsgKey.append(entityData.getString("receivername")).append(',').append(entityData.getLong("payrollacrel.id")).append(',').append(entityData.getString("bankaccount")).append(',').append(entityData.getLong("bebank.id"));
        }
        return repeatedMsgKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String genBankAccountModifyBill(SWCDataServiceHelper helper, Map<String, DynamicObjectCollection> acctModifyBillListMap, Map<Long, Long> oldPayDetailAndRelatedModifyBillMap) {
        DynamicObjectCollection billHandledIndirectly = acctModifyBillListMap.get("2");
        DynamicObjectCollection billHandledDirectly = acctModifyBillListMap.get("3");
        try (TXHandle txHandle = TX.requiresNew();){
            BankAccountModifyHelper.genBankAccountModifyBill(helper, billHandledIndirectly);
            BankAccountModifyHelper.handleModifyBillDirectly(billHandledDirectly);
            BankAccountModifyHelper.updateOldPayDetail(oldPayDetailAndRelatedModifyBillMap);
        }
        try {
            BankAccountModifyHelper.submitBillToWorkFlow(billHandledIndirectly);
        }
        catch (Exception e) {
            LOG.error("generate work flow failed after generating bank account bill", (Throwable)e);
            return "work flow generate error";
        }
        return BankAccountModifyHelper.updateBillStatusHandledIndirectlyToSubmit(helper, billHandledIndirectly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String updateBillStatusHandledIndirectlyToSubmit(SWCDataServiceHelper helper, DynamicObjectCollection billHandledIndirectly) {
        if (billHandledIndirectly == null || billHandledIndirectly.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : billHandledIndirectly) {
            dynamicObject.set("billstatus", (Object)"B");
        }
        try (TXHandle txHandle = TX.requiresNew();){
            helper.save(billHandledIndirectly);
        }
        return null;
    }

    private static void handleModifyBillDirectly(DynamicObjectCollection billHandledDirectly) {
        Optional.ofNullable(billHandledDirectly).filter(list -> list.size() > 0).ifPresent(list -> BankAccountModifyServiceHelper.bankAccountModify((DynamicObject[])list.toArray((Object[])new DynamicObject[0])));
    }

    private static void genBankAccountModifyBill(SWCDataServiceHelper helper, DynamicObjectCollection billHandledIndirectly) {
        Optional.ofNullable(billHandledIndirectly).filter(list -> list.size() > 0).ifPresent(arg_0 -> ((SWCDataServiceHelper)helper).save(arg_0));
    }

    private static void submitBillToWorkFlow(DynamicObjectCollection billHandledIndirectly) {
        if (billHandledIndirectly == null || billHandledIndirectly.size() == 0) {
            return;
        }
        for (DynamicObject acctModifyBill : billHandledIndirectly) {
            long billId = acctModifyBill.getLong("id");
            WorkflowServiceHelper.tryTriggerProcess((String)(billId + ""), (String)"submit", (String)"hsas_acctmodifybill", null);
        }
    }

    private static void updateOldPayDetail(Map<Long, Long> payDetailMapHandledIndirectly) {
        if (payDetailMapHandledIndirectly.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("id", "in", payDetailMapHandledIndirectly.keySet());
        DynamicObject[] payDetailDyObj = helper.query("id,acctmodifybill", filter.toArray());
        if (payDetailDyObj.length == 0) {
            return;
        }
        for (DynamicObject payDetailInfo : payDetailDyObj) {
            long payDetailId = payDetailInfo.getLong("id");
            payDetailInfo.set("acctmodifybill", (Object)payDetailMapHandledIndirectly.get(payDetailId));
        }
        helper.update(payDetailDyObj);
    }

    public static Map<Long, Long> getPerContactMapByPersonIds(List<Long> personIdList) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        List dataList = (List)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPropPersonAttachs", (Object[])new Object[]{personIdList, "id,person.id", filter, "hrpi_percontact"});
        if (dataList != null && !dataList.isEmpty()) {
            HashMap<Long, Long> personContactMap = new HashMap<Long, Long>(personIdList.size());
            for (Map data : dataList) {
                personContactMap.put(MapUtils.getLong((Map)data, (Object)"person.id"), MapUtils.getLong((Map)data, (Object)"id"));
            }
            return personContactMap;
        }
        return new HashMap<Long, Long>(16);
    }

    public static Map<Long, Long> getUserIdMapByPersonIds(List<Long> personIdList) {
        Map<String, List<Long>> idMaps = Collections.singletonMap("person", personIdList);
        Map result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (!((Boolean)result.get("success")).booleanValue()) {
            return Collections.emptyMap();
        }
        Map hrToBosUserMap = (Map)result.get("data");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)personIdList.size());
        for (Map.Entry entry : hrToBosUserMap.entrySet()) {
            resultMap.put(entry.getKey(), ((Map)entry.getValue()).get("user"));
        }
        return resultMap;
    }

    private static void sendNoticeIfNotHandedByEmployeeHimself(Map<Long, Long> payDetailAndRelativePersonMap) {
        DynamicObject[] msgTmplInfoArr = BankAccountModifyHelper.getMsgTmplInfoArr();
        if (msgTmplInfoArr == null || msgTmplInfoArr.length == 0) {
            return;
        }
        HashMap idMaps = Maps.newHashMapWithExpectedSize((int)16);
        List pids = payDetailAndRelativePersonMap.values().stream().collect(Collectors.toList());
        idMaps.put("person", pids);
        Map personBosUserMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        Map bosUserIdMap = (Map)personBosUserMap.get("data");
        HashMap personIdsMapUserIds = new HashMap(16);
        if (bosUserIdMap == null) {
            return;
        }
        bosUserIdMap.forEach((personId, userInfo) -> personIdsMapUserIds.put(personId, userInfo.get("user")));
        for (DynamicObject msgTmplInfo : msgTmplInfoArr) {
            DynamicObject msgTmpl = msgTmplInfo.getDynamicObject("msgtpl");
            if (msgTmpl == null) {
                return;
            }
            String channel = msgTmpl.getString("msgchannel");
            String scene = msgTmpl.getString("msgscene");
            String msgContent = ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u7684\u94f6\u884c\u5361\u5df2\u53d1\u8d77\u53d8\u66f4\u3002\u8bf7\u77e5\u6089\u3002", (String)"BankAccountModifyHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            ArrayList<Long> receviers = new ArrayList<Long>(1);
            for (Map.Entry<Long, Long> entry : payDetailAndRelativePersonMap.entrySet()) {
                receviers.add((Long)personIdsMapUserIds.get(entry.getValue()));
                String msgTitle = ResManager.loadKDString((String)"\u94f6\u884c\u5361\u53d8\u66f4\u901a\u77e5", (String)"BankAccountModifyHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                MessageInfo msgInfo = BankAccountModifyHelper.initMessageInfo(scene, receviers, Collections.singletonList(channel), entry.getKey(), msgTitle, msgContent, msgTitle);
                MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
                receviers.clear();
            }
        }
    }

    private static DynamicObject[] getMsgTmplInfoArr() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifymsg");
        QFilter filter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return helper.query("msgtpl.msgchannel,msgtpl.msgscene,msgtpl.msgtemplate", new QFilter[]{filter});
    }

    private static MessageInfo initMessageInfo(String scene, List<Long> recievers, List<String> channels, Long bizDataId, String msgTitle, String msgContent, String msgTag) {
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setTitle(msgTitle);
        msgInfo.setContent(msgContent);
        msgInfo.setTag(msgTag);
        msgInfo.setUserIds(recievers);
        msgInfo.setType("message");
        msgInfo.setEntityNumber("hsas_paydetail");
        msgInfo.setBizDataId(bizDataId);
        msgInfo.setTplScene(scene);
        StringJoiner notifyType = new StringJoiner(",");
        for (String channel : channels) {
            notifyType.add(channel);
        }
        msgInfo.setNotifyType(notifyType.toString());
        return msgInfo;
    }

    public static BankAccountModifyFilterEvent beforeBankAccountModifyFilterEvent() {
        QFilter payStateFilter = new QFilter("paystate", "=", (Object)"1");
        QFilter bankOfferFilter = new QFilter("bankofferstatus", "in", (Object)new String[]{"1", "4"});
        QFilter agencyPayStateFilter = new QFilter("agencypaystate", "=", (Object)"0");
        QFilter onHoldStatusFilter = new QFilter("onholdstatus", "in", (Object)new String[]{"1", " "});
        HashMap<String, QFilter> fieldFilterMap = new HashMap<String, QFilter>(16);
        fieldFilterMap.put(payStateFilter.getProperty(), payStateFilter);
        fieldFilterMap.put(bankOfferFilter.getProperty(), bankOfferFilter);
        fieldFilterMap.put(agencyPayStateFilter.getProperty(), agencyPayStateFilter);
        fieldFilterMap.put(onHoldStatusFilter.getProperty(), onHoldStatusFilter);
        BankAccountModifyFilterEvent filterEvent = new BankAccountModifyFilterEvent(fieldFilterMap);
        BankAccountServiceImpl extService = new BankAccountServiceImpl();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBankAccountService.class, (String)"kd.sdk.swc.hsas.business.extpoint.paydetail.IBankAccountService#beforeBankAccountModifyFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.beforeBankAccountModifyFilter(filterEvent);
            return null;
        });
        return filterEvent;
    }

    public static DynamicObject[] queryValidPkIdList(Set<Long> pkIdList, BankAccountModifyFilterEvent filterEvent) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        List<QFilter> filterList = BankAccountModifyHelper.getModifyPerBankCardFilter(pkIdList, filterEvent);
        DynamicObject[] pkDyObjArr = helper.query("id", filterList.toArray(new QFilter[0]));
        return pkDyObjArr;
    }

    private static List<QFilter> getModifyPerBankCardFilter(Set<Long> pkIdList, BankAccountModifyFilterEvent filterEvent) {
        QFilter payStateFilter = BankAccountModifyHelper.getPayStateFilter(filterEvent);
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        if (payStateFilter != null) {
            filterList.add(payStateFilter);
        }
        QFilter pkIdlFilter = new QFilter("id", "in", pkIdList);
        QFilter billNoFilter = new QFilter("acctmodifybill", "=", (Object)0L);
        QFilter billStatusFilter = new QFilter("acctmodifybill.billstatus", "in", (Object)new String[]{"E", " "});
        QFilter billFilter = billNoFilter.or(billStatusFilter);
        QFilter abandonedFilter = new QFilter("abandonedstatus", "=", (Object)Boolean.FALSE);
        QFilter isMustBankCardFilter = new QFilter("ismustbankcard", "=", (Object)"1");
        filterList.add(pkIdlFilter);
        filterList.add(billFilter);
        filterList.add(isMustBankCardFilter);
        filterList.add(abandonedFilter);
        return filterList;
    }

    public static QFilter getPayStateFilter(BankAccountModifyFilterEvent filterEvent) {
        if (filterEvent == null) {
            return null;
        }
        Map fieldFilterMap = filterEvent.getFieldFilterMap();
        QFilter extFilter = null;
        if (!CollectionUtils.isEmpty((Map)fieldFilterMap)) {
            for (Map.Entry filterEntry : fieldFilterMap.entrySet()) {
                extFilter = extFilter == null ? (QFilter)filterEntry.getValue() : extFilter.and((QFilter)filterEntry.getValue());
            }
        }
        QFilter presetFilterForPayFail = new QFilter("paystate", "=", (Object)PayStateEnum.PAYFAIL.getCode());
        presetFilterForPayFail.and("onholdstatus", "in", (Object)new String[]{"1", " "});
        QFilter stateFilter = filterEvent.isPayFailEffect() ? (extFilter == null ? presetFilterForPayFail : extFilter.or(presetFilterForPayFail)) : extFilter;
        return stateFilter;
    }

    public static int queryMsgTmplCount() {
        int msgTmplCount = 0;
        DynamicObject[] msgTmplInfoArr = BankAccountModifyHelper.getMsgTmplInfoArr();
        if (msgTmplInfoArr == null || msgTmplInfoArr.length == 0) {
            return msgTmplCount;
        }
        for (DynamicObject msgTmplInfo : msgTmplInfoArr) {
            DynamicObject msgTmpl = msgTmplInfo.getDynamicObject("msgtpl");
            if (msgTmpl == null) continue;
            ++msgTmplCount;
        }
        return msgTmplCount;
    }

    public static DynamicObject queryMsgTmpl() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifymsg");
        QFilter userFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return helper.queryOne("msgtpl.id", userFilter.toArray());
    }

    public static void deleteNoticeMsgTmpl() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifymsg");
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("creator", "=", (Object)currUserId);
        Object[] dynamicObjectArr = helper.query("id,msgtpl", new QFilter[]{userFilter});
        if (dynamicObjectArr != null && dynamicObjectArr.length > 0) {
            helper.delete(dynamicObjectArr);
        }
    }

    public static DynamicObjectCollection getBankAccountBillPkIdList(Set<Long> payDetailIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        QFilter payDetailFilter = new QFilter("entryentity.modifypaydetail", "in", payDetailIdSet).or(new QFilter("entryentity.paydetail", "in", payDetailIdSet));
        return helper.queryColl("id", payDetailFilter.toArray(), null);
    }

    public static ApiResult modifyPayDetailBankCard(List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return ApiResult.success(null);
        }
        HashMap<String, Map<Long, List<ModifyPayDetailDTO>>> modifyWayGroupTable = new HashMap<String, Map<Long, List<ModifyPayDetailDTO>>>(16);
        Map<Long, ModifySdkResultDTO> resultMap = BankAccountModifyHelper.checkAndBuildModifyPayDetailData(dataList, modifyWayGroupTable);
        JSONObject data = new JSONObject();
        data.put("resultList", resultMap.values());
        return ApiResult.success((Object)data);
    }

    private static void dealModifyData(Map<String, Map<Long, List<ModifyPayDetailDTO>>> modifyWayGroupTable, Map<Long, ModifySdkResultDTO> resultMap) {
        int sumSize = modifyWayGroupTable.values().stream().map(Map::size).reduce(0, Integer::sum);
        if (sumSize == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_acctmodifybill");
        Date nowDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        HashMap acctModifyBillListMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap<Long, Long> oldPayDetailAndRelatedModifyBillMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> payDetailAndPersonMap = new HashMap<Long, Long>(16);
        HashSet<String> calRepeatedSet = new HashSet<String>(16);
        int index = 0;
        long[] idArr = DB.genLongIds((String)"hsas_acctmodifybill", (int)sumSize);
        for (Map.Entry<String, Map<Long, List<ModifyPayDetailDTO>>> entry : modifyWayGroupTable.entrySet()) {
            String modifyWay = entry.getKey();
            Map<Long, List<ModifyPayDetailDTO>> handlerMap = entry.getValue();
            for (Map.Entry<Long, List<ModifyPayDetailDTO>> handlerEntry : handlerMap.entrySet()) {
                Long handlerId = handlerEntry.getKey();
                List<ModifyPayDetailDTO> modifyPayDetails = handlerEntry.getValue();
                if (CollectionUtils.isEmpty(modifyPayDetails)) continue;
                long id = idArr[index++];
                DynamicObject bankAccountModifyBill = helper.generateEmptyDynamicObject();
                String number = CodeRuleHelper.getNumber((DynamicObject)bankAccountModifyBill, null);
                bankAccountModifyBill.set("id", (Object)id);
                bankAccountModifyBill.set("billno", (Object)number);
                bankAccountModifyBill.set("creator", (Object)currUserId);
                bankAccountModifyBill.set("createtime", (Object)nowDate);
                bankAccountModifyBill.set("acctmodifyway", (Object)modifyWay);
                bankAccountModifyBill.set("modifier", (Object)handlerId);
                bankAccountModifyBill.set("handler", (Object)handlerId);
                bankAccountModifyBill.set("billstatus", (Object)"A");
                bankAccountModifyBill.set("updatestatus", (Object)"N");
                DynamicObjectCollection modifyDetailCollection = bankAccountModifyBill.getDynamicObjectCollection("entryentity");
                bankAccountModifyBill.set("entryentity", (Object)modifyDetailCollection);
                for (int seqNum = 0; seqNum < modifyPayDetails.size(); ++seqNum) {
                    ModifyPayDetailDTO modifyPayDetail = modifyPayDetails.get(seqNum);
                    DynamicObject payDetail = modifyPayDetail.getPayDetail();
                    if (payDetail == null) continue;
                    Long payDetailId2 = payDetail.getLong("id");
                    DynamicObject modifyDetailEntity = helper.generateEmptyEntryDynamicObject("entryentity");
                    modifyDetailEntity.set("seq", (Object)seqNum);
                    modifyDetailEntity.set("acctmodifyreason", (Object)modifyPayDetail.getAcctModifyReasonId());
                    BankAccountModifyHelper.setAttachmentFields(modifyDetailEntity, modifyPayDetail.getAttachmentFields());
                    modifyDetailEntity.set("salaryfilehis", (Object)modifyPayDetail.getSalaryFileHis());
                    modifyDetailEntity.set("paydetail", (Object)payDetail);
                    modifyDetailEntity.set("caltask", (Object)modifyPayDetail.getCalTaskId());
                    modifyDetailEntity.set("perbankcard", (Object)modifyPayDetail.getPerBankcardId());
                    modifyDetailEntity.set("percontact", (Object)modifyPayDetail.getPerContactId());
                    modifyDetailEntity.set("modifyperbankcard", (Object)modifyPayDetail.getModifyPerBankCard());
                    modifyDetailCollection.add((Object)modifyDetailEntity);
                    oldPayDetailAndRelatedModifyBillMap.put(payDetailId2, id);
                    if (SWCStringUtils.equals((String)modifyPayDetail.getAcctModifyWay(), (String)"1")) continue;
                    Long personId = modifyPayDetail.getPersonId();
                    StringBuilder repeatedMsgKey = new StringBuilder();
                    repeatedMsgKey.append(personId).append(',').append(modifyPayDetail.getHandlerId()).append(',').append(modifyPayDetail.getPerBankcardId());
                    if (!calRepeatedSet.add(repeatedMsgKey.toString())) continue;
                    payDetailAndPersonMap.put(payDetailId2, personId);
                }
                String acctModifyKey = "1".equals(modifyWay) || "2".equals(modifyWay) ? "2" : "3";
                DynamicObjectCollection acctModifyBillList = acctModifyBillListMap.getOrDefault(acctModifyKey, new DynamicObjectCollection());
                acctModifyBillList.add((Object)bankAccountModifyBill);
                acctModifyBillListMap.put(acctModifyKey, acctModifyBillList);
            }
        }
        String errorLevel = BankAccountModifyHelper.genBankAccountModifyBill(helper, acctModifyBillListMap, oldPayDetailAndRelatedModifyBillMap);
        if (errorLevel != null) {
            throw new KDBizException(errorLevel);
        }
        BankAccountModifyHelper.sendNoticeIfNotHandedByEmployeeHimself(payDetailAndPersonMap);
        resultMap.forEach((payDetailId, result) -> {
            if (result.getModifySuccess().booleanValue()) {
                Long billId = oldPayDetailAndRelatedModifyBillMap.getOrDefault(payDetailId, 0L);
                result.setModifySuccess(true);
                result.setAcctModifyBillId(billId);
            }
        });
    }

    private static Map<Long, ModifySdkResultDTO> checkAndBuildModifyPayDetailData(List<Map<String, Object>> dataList, Map<String, Map<Long, List<ModifyPayDetailDTO>>> modifyWayGroupTable) {
        HashMap<Long, ModifySdkResultDTO> resultMap = new HashMap<Long, ModifySdkResultDTO>(16);
        for (Map<String, Object> modifyData : dataList) {
            Long payDetailId2 = MapUtils.getLong(modifyData, (Object)"payDetailId");
            ModifySdkResultDTO modifySdkResultDTO = (ModifySdkResultDTO)resultMap.get(payDetailId2);
            if (modifySdkResultDTO == null) {
                resultMap.put(payDetailId2, ModifySdkResultDTO.getInstance(payDetailId2, null));
                continue;
            }
            modifySdkResultDTO.setModifySuccess(false);
            modifySdkResultDTO.setErrorCode("40001");
            modifySdkResultDTO.setErrorMsg(ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"BankAccountModifyHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
        HashSet<Long> payDetailIdSet = new HashSet<Long>(16);
        resultMap.forEach((payDetailId, result) -> {
            if (result.getModifySuccess().booleanValue()) {
                payDetailIdSet.add((Long)payDetailId);
            }
        });
        if (payDetailIdSet.isEmpty()) {
            return resultMap;
        }
        BankAccountModifyFilterEvent filterEvent = BankAccountModifyHelper.beforeBankAccountModifyFilterEvent();
        List<QFilter> filterList = BankAccountModifyHelper.getModifyPerBankCardFilter(payDetailIdSet, filterEvent);
        Map<Long, DynamicObject> payDetailMap = BankAccountModifyHelper.getBaseDataMap("hsas_paydetail", "id", "id,salaryfilehis,caltask,perbankcard,abandonedstatus,abandonedres", filterList.toArray(new QFilter[0]));
        Map<Long, DynamicObject> acctModifyReasonMap = BankAccountModifyHelper.getBaseDataMap("hsbs_acctmodifyreason", "id", "id", BankAccountModifyHelper.getBaseDataIdQFilter("acctModifyReasonId", "id", dataList, resultMap).toArray());
        Map<Long, DynamicObject> handlerMap = BankAccountModifyHelper.getBaseDataMap("bos_user", "id", "id", BankAccountModifyHelper.getBaseDataIdQFilter("handlerId", "id", dataList, resultMap).toArray());
        QFilter modifyPerBankCardFilter = BankAccountModifyHelper.getBaseDataIdQFilter("modifyPerBankCardId", "boid", dataList, resultMap);
        modifyPerBankCardFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        modifyPerBankCardFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        modifyPerBankCardFilter.and(new QFilter("isdelete", "=", (Object)"0"));
        Map<Long, DynamicObject> modifyPerBankCardMap = BankAccountModifyHelper.getBaseDataMap("hrpi_perbankcard", "boid", "id,person,employee,boid,bankdeposit", modifyPerBankCardFilter.toArray());
        BankAccountModifyHelper.checkDataMustInput(dataList, resultMap, acctModifyReasonMap, handlerMap, modifyPerBankCardMap, payDetailMap);
        resultMap.forEach((payDetailId, result) -> {
            if (result.getModifySuccess().booleanValue() && payDetailMap.get(payDetailId) == null) {
                result.setModifySuccess(false);
                result.setErrorCode("40003");
                result.setErrorMsg(ResManager.loadKDString((String)"\u53d1\u653e\u660e\u7ec6\u4e0d\u7b26\u5408\u53d8\u66f4\u6761\u4ef6\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"BankAccountModifyHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
        });
        BankAccountModifyHelper.checkPerBankCard(dataList, resultMap, payDetailMap, modifyPerBankCardMap);
        BankAccountModifyHelper.buildModifyPayDetailData(dataList, resultMap, payDetailMap, modifyPerBankCardMap, modifyWayGroupTable);
        BankAccountModifyHelper.dealModifyData(modifyWayGroupTable, resultMap);
        resultMap.forEach((payDetailId, result) -> {
            if (result.getModifySuccess().booleanValue()) {
                MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u53d8\u66f4\u94f6\u884c\u5361\u6210\u529f", "BankAccountModifyHelper_11", "swc-hsas-business");
                MultiLangEnumBridge enumBridgeOpName = new MultiLangEnumBridge("\u53d8\u66f4\u94f6\u884c\u5361", "BankAccountModifyHelper_10", "swc-hsas-business");
                SWCOpLogServiceHelper.addOpLog((String)"/UHMBBGZQ65X", (String)"hsas_paydetail", (String)"modifyPayDetailBankCard", (MultiLangEnumBridge)enumBridgeOpName, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[]{((DynamicObject)payDetailMap.get(payDetailId)).getString("number")});
            }
        });
        return resultMap;
    }

    private static void checkPerBankCard(List<Map<String, Object>> dataList, Map<Long, ModifySdkResultDTO> resultMap, Map<Long, DynamicObject> payDetailMap, Map<Long, DynamicObject> modifyPerBankCardMap) {
        for (Map<String, Object> modifyData : dataList) {
            Long perBankCardId;
            String acctModifyWay;
            Long payDetailId = MapUtils.getLong(modifyData, (Object)"payDetailId");
            ModifySdkResultDTO modifySdkResultDTO = resultMap.get(payDetailId);
            if (modifySdkResultDTO == null || !modifySdkResultDTO.getModifySuccess().booleanValue() || !"3".equals(acctModifyWay = MapUtils.getString(modifyData, (Object)"acctModifyWay"))) continue;
            DynamicObject perBankCard = modifyPerBankCardMap.get(MapUtils.getLong(modifyData, (Object)"modifyPerBankCardId"));
            DynamicObject payDetail = payDetailMap.get(payDetailId);
            if (perBankCard == null || payDetail == null || !(perBankCardId = Long.valueOf(perBankCard.getLong("id"))).equals(payDetail.getLong("perbankcard.id"))) continue;
            modifySdkResultDTO.setModifySuccess(false);
            modifySdkResultDTO.setErrorCode("40004");
            modifySdkResultDTO.setErrorMsg(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u94f6\u884c\u5361\u4fe1\u606f\u4e0e\u539f\u94f6\u884c\u5361\u4fe1\u606f\u4e00\u81f4\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"BankAccountModifyHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]));
        }
    }

    private static void checkDataMustInput(List<Map<String, Object>> dataList, Map<Long, ModifySdkResultDTO> resultMap, Map<Long, DynamicObject> acctModifyReasonMap, Map<Long, DynamicObject> handlerMap, Map<Long, DynamicObject> modifyPerBankCardMap, Map<Long, DynamicObject> payDetailMap) {
        for (Map<String, Object> modifyData : dataList) {
            String acctModifyWay;
            ArrayList<String> errorList = new ArrayList<String>(10);
            Long payDetailId = MapUtils.getLong(modifyData, (Object)"payDetailId");
            ModifySdkResultDTO modifySdkResultDTO = resultMap.get(payDetailId);
            if (modifySdkResultDTO == null || !modifySdkResultDTO.getModifySuccess().booleanValue()) continue;
            if (acctModifyReasonMap.get(MapUtils.getLong(modifyData, (Object)"acctModifyReasonId")) == null) {
                errorList.add(ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0", (String)"BankAccountModifyHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            if (!("1".equals(acctModifyWay = MapUtils.getString(modifyData, (Object)"acctModifyWay")) || "2".equals(acctModifyWay) || "3".equals(acctModifyWay))) {
                errorList.add(ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u5f0f", (String)"BankAccountModifyHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            if ("2".equals(acctModifyWay) && handlerMap.get(MapUtils.getLong(modifyData, (Object)"handlerId")) == null) {
                errorList.add(ResManager.loadKDString((String)"\u5904\u7406\u4eba", (String)"BankAccountModifyHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            if ("3".equals(acctModifyWay)) {
                DynamicObject perBankCard = modifyPerBankCardMap.get(MapUtils.getLong(modifyData, (Object)"modifyPerBankCardId"));
                if (perBankCard == null) {
                    errorList.add(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u94f6\u884c\u5361", (String)"BankAccountModifyHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]));
                } else {
                    Long employeeId;
                    DynamicObject payDetail = payDetailMap.get(payDetailId);
                    if (payDetail != null && !(employeeId = Long.valueOf(perBankCard.getLong("employee.id"))).equals(payDetail.getLong("salaryfilehis.employee.id"))) {
                        errorList.add(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u94f6\u884c\u5361", (String)"BankAccountModifyHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]));
                    }
                }
            }
            if (errorList.isEmpty()) continue;
            modifySdkResultDTO.setModifySuccess(false);
            modifySdkResultDTO.setErrorCode("40002");
            StringJoiner joiner = new StringJoiner("\u201d \u3001\u201c", "\u201c", "\u201d");
            errorList.forEach(joiner::add);
            modifySdkResultDTO.setErrorMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e3a\u7a7a\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u53d8\u66f4\u94f6\u884c\u5361\u3002", (String)"BankAccountModifyHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]), joiner.toString()));
        }
    }

    private static void buildModifyPayDetailData(List<Map<String, Object>> dataList, Map<Long, ModifySdkResultDTO> resultMap, Map<Long, DynamicObject> payDetailMap, Map<Long, DynamicObject> modifyPerBankCardMap, Map<String, Map<Long, List<ModifyPayDetailDTO>>> modifyWayGroupTable) {
        Map<Long, Long> perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(new ArrayList<Long>(payDetailMap.keySet()));
        HashMap<String, List> modifyWayGroupMap = new HashMap<String, List>(16);
        for (Map<String, Object> modifyData : dataList) {
            DynamicObject payDetail;
            Long payDetailId = MapUtils.getLong(modifyData, (Object)"payDetailId");
            ModifySdkResultDTO modifySdkResultDTO = resultMap.get(payDetailId);
            if (modifySdkResultDTO == null || !modifySdkResultDTO.getModifySuccess().booleanValue()) continue;
            ModifyPayDetailDTO payDetailDTO = new ModifyPayDetailDTO();
            payDetailDTO.setValueByMap(modifyData);
            DynamicObject perBankCard = modifyPerBankCardMap.get(MapUtils.getLong(modifyData, (Object)"modifyPerBankCardId"));
            if (perBankCard != null) {
                payDetailDTO.setModifyPerBankCard(perBankCard);
            }
            if ((payDetail = payDetailMap.get(payDetailId)) != null) {
                payDetailDTO.setPayDetail(payDetail);
                payDetailDTO.setSalaryFileHis(payDetail.getLong("salaryfilehis.id"));
                payDetailDTO.setPersonId(payDetail.getLong("salaryfilehis.person.id"));
                payDetailDTO.setCalTaskId(payDetail.getLong("caltask.id"));
                payDetailDTO.setPerBankcardId(payDetail.getLong("perbankcard.id"));
                payDetailDTO.setPerContactId(perContactMap.get(payDetailId));
            }
            String acctModifyWay = MapUtils.getString(modifyData, (Object)"acctModifyWay");
            List detailList2 = modifyWayGroupMap.getOrDefault(acctModifyWay, new ArrayList(10));
            detailList2.add(payDetailDTO);
            modifyWayGroupMap.put(acctModifyWay, detailList2);
        }
        List modifyPayDetailList = (List)modifyWayGroupMap.get("1");
        if (!CollectionUtils.isEmpty((Collection)modifyPayDetailList)) {
            Map<Long, Long> userIdMap = BankAccountModifyHelper.getUserIdMapByPersonIds(modifyPayDetailList.stream().map(ModifyPayDetailDTO::getPersonId).collect(Collectors.toList()));
            modifyPayDetailList.forEach(data -> data.setHandlerId(userIdMap.getOrDefault(data.getPersonId(), 0L)));
        }
        if (!CollectionUtils.isEmpty((Collection)(modifyPayDetailList = (List)modifyWayGroupMap.get("3")))) {
            modifyPayDetailList.forEach(data -> data.setHandlerId(RequestContext.get().getCurrUserId()));
        }
        modifyWayGroupMap.forEach((modifyWay, detailList) -> detailList.forEach(detail -> {
            Long handlerId = detail.getHandlerId();
            Map handlerMap = modifyWayGroupTable.getOrDefault(modifyWay, new HashMap(16));
            List modifyPayDetails = handlerMap.getOrDefault(handlerId, new ArrayList(10));
            modifyPayDetails.add(detail);
            handlerMap.put(handlerId, modifyPayDetails);
            modifyWayGroupTable.put((String)modifyWay, handlerMap);
        }));
    }

    private static QFilter getBaseDataIdQFilter(String field, String idKey, List<Map<String, Object>> dataList, Map<Long, ModifySdkResultDTO> resultMap) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (Map<String, Object> modifyData : dataList) {
            Long payDetailId = MapUtils.getLong(modifyData, (Object)"payDetailId");
            ModifySdkResultDTO modifySdkResultDTO = resultMap.get(payDetailId);
            if (modifySdkResultDTO == null || !modifySdkResultDTO.getModifySuccess().booleanValue()) continue;
            idSet.add(MapUtils.getLong(modifyData, (Object)field));
        }
        QFilter filter = new QFilter(idKey, "in", idSet);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return filter;
    }

    private static Map<Long, DynamicObject> getBaseDataMap(String entityName, String idKey, String selectProperties, QFilter[] filters) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityName);
        DynamicObject[] query = helper.query(selectProperties, filters);
        HashMap<Long, DynamicObject> mapData = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject data : query) {
            mapData.put(data.getLong(idKey), data);
        }
        return mapData;
    }

    private static void setAttachmentFields(DynamicObject modifyDetailEntity, List<Long> attachmentFields) {
        if (CollectionUtils.isEmpty(attachmentFields)) {
            return;
        }
        DynamicObjectCollection attachmentFieldCol = modifyDetailEntity.getDynamicObjectCollection("attachmentfield");
        DynamicObjectType dynamicObjectType = attachmentFieldCol.getDynamicObjectType();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
        for (Long attachmentFieldId : attachmentFields) {
            DynamicObject instance = new DynamicObject(dynamicObjectType);
            DynamicObject attachmentField = (DynamicObject)mainEntityType.createInstance();
            attachmentField.set("id", (Object)attachmentFieldId);
            instance.set("fbasedataid", (Object)attachmentField);
            attachmentFieldCol.add((Object)instance);
        }
    }
}

