/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.modifybankaccount.service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsas.business.modifybankaccount.helper.PerBankCardEditBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class PerBankcardEditBillService {
    public DynamicObjectCollection getPerBankCardEditBillByPersonId(Long personId) {
        DynamicObjectCollection billCol = new DynamicObjectCollection();
        if (personId == null || personId == 0L) {
            return billCol;
        }
        String selectFields = "id,billno,billstatus,createtime,edittype";
        List<String> billStatusList = Arrays.asList("D", "E", "C");
        QFilter filter = new QFilter("person", "=", (Object)personId);
        filter.and(new QFilter("billstatus", "in", billStatusList));
        DynamicObjectCollection collection = PerBankCardEditBillHelper.getEditBillByFilter(selectFields, new QFilter[]{filter}, null);
        Comparator<DynamicObject> billStatusSort = Comparator.comparing(data -> billStatusList.indexOf(data.getString("billstatus")));
        billCol.addAll((Collection)collection.stream().sorted(billStatusSort.thenComparing(data -> data.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList()));
        return billCol;
    }

    public boolean havePerBankCardEditBillByPersonId(Long personId) {
        if (personId == null || personId == 0L) {
            return false;
        }
        List<String> billStatusList = Arrays.asList("D", "E", "C");
        QFilter filter = new QFilter("person", "=", (Object)personId);
        filter.and(new QFilter("billstatus", "in", billStatusList));
        return PerBankCardEditBillHelper.getHaveEditBillByFilter(new QFilter[]{filter});
    }

    public DynamicObject getPerBankCardEditBillDetailById(Long billId) {
        String selectFields = "id,billno,failmsg,billstatus,createtime,edittype,entryentity.perbankcard,entryentity.modifybankaccount,entryentity.modifybank,entryentity.modifyreceivername,entryentity.modifyreltype,entryentity.modifycardpurposemul,entryentity.description";
        QFilter filter = new QFilter("id", "=", (Object)billId);
        return PerBankCardEditBillHelper.getEditBillDetailByFilter(selectFields, new QFilter[]{filter}, null);
    }

    public DynamicObject[] getPerBankCardEditBillByPerBankCardId(Long perBankCardId) {
        if (perBankCardId == null || perBankCardId == 0L) {
            return null;
        }
        String selectFields = "id,billstatus,auditstatus";
        QFilter filter = new QFilter("entryentity.perbankcard.boid", "=", (Object)perBankCardId);
        filter.and(new QFilter("billstatus", "=", (Object)"D"));
        return PerBankCardEditBillHelper.getEditBillDetailArrayByFilter(selectFields, new QFilter[]{filter}, null);
    }

    public OperationResult abandonEditBillByPerBankCardId(Long perBankCardId) {
        OperationResult result = new OperationResult();
        DynamicObject[] billDataArray = this.getPerBankCardEditBillByPerBankCardId(perBankCardId);
        if (billDataArray != null && billDataArray.length > 0) {
            Boolean existProcDef = WorkflowServiceHelper.existProcDefByEntityNumber((String)"hsas_perbceditbill");
            if (!existProcDef.booleanValue()) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u5ba1\u6279\u6d41\u7a0b\uff0c\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PerBankcardEditBillService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                return result;
            }
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            result = opImpl.localInvokeOperation("discard", billDataArray, operateOption);
        } else {
            result = new OperationResult();
            result.setSuccess(true);
        }
        return result;
    }

    public OperationResult abandonAndSubmitNewEditBill(Map<String, Object> param) {
        OperationResult result = new OperationResult();
        if (param == null) {
            result.setSuccess(false);
            return result;
        }
        Map bankcardMap = (Map)param.get("bankcard");
        Long perBankCardId = bankcardMap.getOrDefault("perbankcard.id", 0L);
        OperationResult abandonResult = this.abandonEditBillByPerBankCardId(perBankCardId);
        if (abandonResult.isSuccess()) {
            Boolean existProcDef = WorkflowServiceHelper.existProcDefByEntityNumber((String)"hsas_perbceditbill");
            if (!existProcDef.booleanValue()) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u5ba1\u6279\u6d41\u7a0b\uff0c\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PerBankcardEditBillService_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                return result;
            }
            result = this.generatePersonalBankCardEditBill(param);
            if (!result.isSuccess()) {
                return result;
            }
        } else {
            return abandonResult;
        }
        result = new OperationResult();
        result.setSuccess(true);
        return result;
    }

    public OperationResult generatePersonalBankCardEditBill(Map<String, Object> param) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_perbceditbill");
        DynamicObject newEditBill = helper.generateEmptyDynamicObject();
        newEditBill.set("id", param.get("id"));
        Long personId = (Long)param.get("person");
        newEditBill.set("person", param.get("person"));
        newEditBill.set("employee", param.get("employee"));
        Map data = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
        newEditBill.set("adminorg", data.get("adminorg_id"));
        newEditBill.set("edittype", param.get("edittype"));
        Date date = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        newEditBill.set("creator", (Object)userId);
        newEditBill.set("modifier", (Object)userId);
        newEditBill.set("createtime", (Object)date);
        newEditBill.set("modifytime", (Object)date);
        newEditBill.set("billstatus", (Object)"A");
        newEditBill.set("auditstatus", (Object)"B");
        Map<Long, Long> perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(Collections.singletonList(personId));
        newEditBill.set("percontact", (Object)perContactMap.get(personId));
        DynamicObjectCollection entryCol = newEditBill.getDynamicObjectCollection("entryentity");
        Map bankcardMap = (Map)param.get("bankcard");
        this.buildEditBillEntry(helper, entryCol, bankcardMap);
        this.buildAttachmentDataFromEdit((List)bankcardMap.get("attachment"), newEditBill.getLong("id"));
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", "true");
        return opImpl.localInvokeOperation("submit", new DynamicObject[]{newEditBill}, operateOption);
    }

    private void buildEditBillEntry(SWCDataServiceHelper helper, DynamicObjectCollection entryCol, Map<String, Object> bankcardMap) {
        DynamicObject entry = helper.generateEmptyEntryDynamicObject("entryentity");
        entry.set("seq", (Object)1);
        entry.set("perbankcard", bankcardMap.get("perbankcard.vid"));
        entry.set("modifybankaccount", bankcardMap.get("bankcardnum"));
        entry.set("modifybank", bankcardMap.get("bankdeposit.id"));
        entry.set("modifyreceivername", bankcardMap.get("username"));
        entry.set("modifyreltype", bankcardMap.get("accountrelation.id"));
        this.getMulBaseDataDyColl(entry.getDynamicObjectCollection("modifycardpurposemul"), (List)bankcardMap.get("cardpurpose.id"), "hbss_bankpurpose");
        entry.set("description", bankcardMap.get("description"));
        entryCol.add((Object)entry);
    }

    private DynamicObjectCollection getMulBaseDataDyColl(DynamicObjectCollection dyColl, List<Long> fieldValueIds, String mulBaseDataName) {
        if (CollectionUtils.isEmpty(fieldValueIds)) {
            return new DynamicObjectCollection();
        }
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (Long fieldValueId : fieldValueIds) {
            DynamicObject mulBaseDataDy = new DynamicObject(dynamicObjectType);
            mulBaseDataDy.set("fbasedataid", (Object)this.getDynamicObjectById(mulBaseDataName, fieldValueId));
            dyColl.add((Object)mulBaseDataDy);
        }
        return dyColl;
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }

    private void buildAttachmentDataFromEdit(List<Map<String, Object>> sourceAttachCol, Long pkId) {
        if (CollectionUtils.isEmpty(sourceAttachCol)) {
            return;
        }
        this.cacheAttachmentDataFromEdit(sourceAttachCol, pkId);
        AttachmentServiceHelper.upload((String)"hsas_perbceditbill", (Object)pkId, (String)"attachmentpanel", sourceAttachCol);
    }

    private void cacheAttachmentDataFromEdit(List<Map<String, Object>> sourceAttachCol, Long pkId) {
        sourceAttachCol.forEach(attach -> {
            String url = String.valueOf(attach.get("url"));
            String name = String.valueOf(attach.get("name"));
            if (SWCStringUtils.isNotEmpty((String)url) && url.contains("tempfile/download.do?configKey")) {
                url = AttachmentServiceHelper.saveTempToFileService((String)url, (String)"hsas", (String)"hsas_perbceditbill", (Object)pkId, (String)name);
            }
            attach.put("url", url);
            attach.put("fattachmentpanel", "attachmentpanel");
            attach.put("entityNum", "hsas_perbceditbill");
            attach.put("billPkId", String.valueOf(pkId));
            attach.put("lastModified", System.currentTimeMillis());
            attach.put("status", "success");
            attach.put("client", null);
            this.setAttachmentData((Map<String, Object>)attach);
        });
    }

    private void setAttachmentData(Map<String, Object> attachmentData) {
        String url = String.valueOf(attachmentData.get("url"));
        String previewUrl = String.valueOf(attachmentData.get("previewurl"));
        attachmentData.put("url", this.getRelativePath(url));
        attachmentData.put("previewurl", this.getRelativePath(previewUrl));
    }

    private String getRelativePath(String url) {
        if (SWCStringUtils.isEmpty((String)url)) {
            return url;
        }
        if (url.contains("path=") && (url = url.substring(url.indexOf("path="), url.indexOf("&kdedcba"))).startsWith("path=")) {
            url = url.replaceFirst("path=", "");
        }
        try {
            String decode = URLDecoder.decode(url, "UTF-8");
            while (decode.startsWith("//")) {
                decode = decode.substring(1);
            }
            return decode;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return url;
        }
    }
}

