/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.helper;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.fs.util.StringUtils;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class OnHoldDetailHelper {
    private static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    private static final Log LOGGER = LogFactory.getLog(OnHoldDetailHelper.class);

    public static String getTipMsgBeforeSave(DynamicObjectCollection caltableEntity) {
        StringBuilder tipBuilder = new StringBuilder();
        for (DynamicObject onHold : caltableEntity) {
            boolean onholdStatus;
            DataEntityPropertyCollection properties = onHold.getDataEntityType().getProperties();
            if (properties.containsKey((Object)"caltableinfo")) {
                onholdStatus = onHold.getBoolean("caltableonholdstatus");
                if (onholdStatus) continue;
                String caltaskNumber = onHold.getString("caltableinfo.caltask.number");
                tipBuilder.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1(%s)\u672a\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailHelper_0", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), caltaskNumber));
                tipBuilder.append("\r\n");
                continue;
            }
            onholdStatus = onHold.getBoolean("salaryonholdstatus");
            if (onholdStatus) continue;
            String salaryfileNumber = onHold.getString("salaryfileinfo.number");
            tipBuilder.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7f16\u53f7(%s)\u672a\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailHelper_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), salaryfileNumber));
            tipBuilder.append("\r\n");
        }
        return tipBuilder.toString();
    }

    public static DynamicObjectCollection modifyOnHoldStatus(DynamicObjectCollection onHoldCollection) {
        Date currentDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject onholdBill : onHoldCollection) {
            Date releasedate = onholdBill.getDate("releasedate");
            if (!SWCObjectUtils.isEmpty((Object)releasedate) && releasedate.before(currentDate)) {
                onholdBill.set("status", (Object)OnHoldStatusEnum.STATUS_TOPAY.getCode());
            } else {
                onholdBill.set("status", (Object)OnHoldStatusEnum.STATUS_ONHOLD.getCode());
            }
            onholdBill.set("modifytime", (Object)currentDate);
            onholdBill.set("modifier", (Object)userId);
        }
        return onHoldCollection;
    }

    public static void updateRelevanceOnHoldStatus(Object[] savedOnHoldArr, boolean isSave) {
        int savedSize = savedOnHoldArr.length;
        HashSet<Long> calTableIdSet = new HashSet<Long>(savedSize);
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(savedSize);
        HashMap<Long, Date> cacheOnHoldBillMap = new HashMap<Long, Date>(savedSize);
        HashMap<Long, Date> cacheSalaryFileMap = new HashMap<Long, Date>(savedSize);
        ArrayList<DynamicObject> salaryOnHoldList = new ArrayList<DynamicObject>(savedSize);
        for (Object object : savedOnHoldArr) {
            if (!(object instanceof DynamicObject)) continue;
            DynamicObject onHold = (DynamicObject)object;
            Long caltableId = onHold.getLong("caltableid");
            if (caltableId != 0L) {
                calTableIdSet.add(caltableId);
                cacheOnHoldBillMap.put(caltableId, onHold.getDate("startdate"));
                continue;
            }
            salaryOnHoldList.add(onHold);
            Long salaryFileId = 0L;
            Object salaryFileObj = onHold.get("salaryfile");
            if (salaryFileObj instanceof DynamicObject) {
                salaryFileId = onHold.getLong("salaryfile.id");
            } else if (salaryFileObj instanceof String) {
                salaryFileId = Long.parseLong((String)salaryFileObj);
            }
            salaryFileIdSet.add(salaryFileId);
            cacheSalaryFileMap.put(salaryFileId, onHold.getDate("startdate"));
        }
        if (!isSave) {
            Date currDate = new Date();
            Long currUserId = RequestContext.get().getCurrUserId();
            if (!salaryOnHoldList.isEmpty()) {
                OnHoldBillHelper.insertOnHoldFile(currDate, currUserId, salaryOnHoldList.toArray(new DynamicObject[0]));
                Map<Long, String> calPersonOnHoldMap = OnHoldBillHelper.updateCalTableBySalaryFile(salaryFileIdSet, cacheSalaryFileMap);
                if (calPersonOnHoldMap != null && calPersonOnHoldMap.size() > 0) {
                    OnHoldBillHelper.updatePayDetailByCalPerson(currDate, currUserId, calPersonOnHoldMap);
                    OnHoldBillHelper.updateAllotDetailByCalPerson(currDate, currUserId, calPersonOnHoldMap);
                }
            }
            if (!calTableIdSet.isEmpty()) {
                OnHoldBillHelper.updateCalTable(calTableIdSet, cacheOnHoldBillMap);
                OnHoldBillHelper.updatePayDetail(currDate, currUserId, calTableIdSet);
                OnHoldBillHelper.updateAllotDetail(currDate, currUserId, calTableIdSet);
            }
        }
    }

    private static void updateOnHoldCalInfo(Map<String, DynamicObject> onHoldIdRefCalPersonObjMap, List<Long> salaryOnHoldIdList) {
        if (onHoldIdRefCalPersonObjMap.isEmpty()) {
            return;
        }
        int calPersonSize = onHoldIdRefCalPersonObjMap.size();
        HashMap<Long, Long> calPersonIdRefCalRuleVidMap = new HashMap<Long, Long>(calPersonSize);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(calPersonSize);
        HashMap<Long, Long> calPersonIdRefPayRollGroupVidMap = new HashMap<Long, Long>(calPersonSize);
        for (DynamicObject calPersonObj : onHoldIdRefCalPersonObjMap.values()) {
            Long calPersonId = Long.valueOf(calPersonObj.getString("id"));
            long calRuleVid = calPersonObj.getLong("caltask.calrulev.id");
            Long calTableId = calPersonObj.getLong("calresultid");
            Long payRollGroupVid = calPersonObj.getLong("caltask.payrollgroupv.id");
            calPersonIdRefPayRollGroupVidMap.put(calPersonId, payRollGroupVid);
            calPersonIdRefCalRuleVidMap.put(calPersonId, calRuleVid);
            if (calTableId.intValue() == 0) continue;
            calTableIdList.add(calTableId);
        }
        Map<String, String> calRuleNetSalaryItemInfoMap = OnHoldBillHelper.queryCalRuleIdRefNetSalaryItemInfoMap(calPersonIdRefCalRuleVidMap.values());
        SWCDataServiceHelper onHoldBillService = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObjectCollection onHoldCol = new DynamicObjectCollection();
        DynamicObject[] salaryOnHoldArr = OnHoldBillHelper.queryOnHoldsByIds(salaryOnHoldIdList);
        Map<String, DynamicObject> calTableIdRefCalTableObjMap = OnHoldBillHelper.queryCalTableIdRefCalTableObjMap(calTableIdList);
        Map<Long, DynamicObject> payRollGroupIdRefPayRollGroupObjMap = OnHoldBillHelper.queryPayRollGroupIdRefPayRollGroupObjMap(calPersonIdRefPayRollGroupVidMap.values());
        for (DynamicObject onHoldObj : salaryOnHoldArr) {
            String netSalaryItemId;
            String onHoldId = onHoldObj.getString("id");
            DynamicObject calPersonObj = onHoldIdRefCalPersonObjMap.get(onHoldId);
            if (SWCObjectUtils.isEmpty((Object)calPersonObj)) continue;
            DynamicObject calTable = calTableIdRefCalTableObjMap.get(calPersonObj.getString("calresultid"));
            Long calPersonId = calPersonObj.getLong("id");
            Long payRollGroupId = (Long)calPersonIdRefPayRollGroupVidMap.get(calPersonId);
            DynamicObject payRollGroup = payRollGroupIdRefPayRollGroupObjMap.get(payRollGroupId);
            onHoldObj.set("caltableid", (Object)calPersonId);
            onHoldObj.set("caltask", (Object)calPersonObj.getString("caltask.id"));
            Long calRuleVid = (Long)calPersonIdRefCalRuleVidMap.get(calPersonId);
            if (calRuleVid != null && SWCStringUtils.isNotEmpty((String)(netSalaryItemId = calRuleNetSalaryItemInfoMap.get(calRuleVid.toString())))) {
                onHoldObj.set("payoutitem", (Object)netSalaryItemId.substring(0, netSalaryItemId.indexOf("||")));
            }
            Map<String, String> actualSalaryInfoMap = OnHoldBillHelper.getNetSalaryAmountInfo(calRuleVid, calRuleNetSalaryItemInfoMap, calTable, payRollGroup);
            onHoldObj.set("calamount", (Object)actualSalaryInfoMap.get("calAmount"));
            onHoldObj.set("calcurrency", (Object)actualSalaryInfoMap.get("calcurrency"));
            onHoldCol.add((Object)onHoldObj);
        }
        onHoldBillService.update((DynamicObject[])onHoldCol.toArray((Object[])new DynamicObject[0]));
    }

    public static Map<String, DynamicObject> addMoreCalPersonIdSet(Set<Long> calTableIdSet, List<Long> salaryFileIdList, List<DynamicObject> salaryOnHoldList) {
        Map<String, List<DynamicObject>> salaryFileIdRefCalPersonListMap = OnHoldBillHelper.getSalaryFileIdRefCalPersonListMap(salaryFileIdList);
        int onHoldSize = salaryOnHoldList.size();
        HashMap<String, DynamicObject> salaryFileOnHoldIdRefCalPersonMap = new HashMap<String, DynamicObject>(onHoldSize);
        for (DynamicObject salaryFileOnHold : salaryOnHoldList) {
            List<DynamicObject> calPersonList;
            Object salaryFileIdObj = salaryFileOnHold.get("salaryfile");
            String salaryFileId = "";
            if (salaryFileIdObj instanceof DynamicObject) {
                salaryFileId = ((DynamicObject)salaryFileIdObj).getString("id");
            } else if (salaryFileIdObj instanceof String) {
                salaryFileId = (String)salaryFileIdObj;
            }
            if ((calPersonList = salaryFileIdRefCalPersonListMap.get(salaryFileId)) == null || calPersonList.isEmpty()) continue;
            Date onHoldStartDate = SWCDateTimeUtils.getDayDate((Date)salaryFileOnHold.getDate("startdate"));
            Date onHoldEndDate = SWCDateTimeUtils.getDayDate((Date)salaryFileOnHold.getDate("enddate"));
            for (DynamicObject calPersonObj : calPersonList) {
                Date startDate = calPersonObj.getDate("caltask.STARTDATE");
                Date endDate = calPersonObj.getDate("caltask.ENDDATE");
                if (startDate == null || endDate == null) continue;
                Date calTaskStartDate = SWCDateTimeUtils.getDayDate((Date)startDate);
                Date calTaskEndDate = SWCDateTimeUtils.getDayDate((Date)endDate);
                if (!calTaskStartDate.equals(onHoldStartDate) || !onHoldEndDate.equals(calTaskEndDate)) continue;
                calTableIdSet.add(calPersonObj.getLong("id"));
                salaryFileOnHoldIdRefCalPersonMap.put(salaryFileOnHold.getString("id"), calPersonObj);
            }
        }
        return salaryFileOnHoldIdRefCalPersonMap;
    }

    public static int[] integerListToArray(List<Integer> delIndexList) {
        int[] delIndexArr = new int[delIndexList.size()];
        for (int i = 0; i < delIndexList.size(); ++i) {
            Integer index = delIndexList.get(i);
            delIndexArr[i] = index;
        }
        return delIndexArr;
    }

    public static JSONArray getCacheDelOnHoldIdArr(String pageId) {
        ISWCAppCache appCache = SWCAppCache.get((String)"delonholdId_appcache");
        JSONArray delOnHoldIdArr = (JSONArray)appCache.get(pageId, JSONArray.class);
        if (delOnHoldIdArr == null) {
            delOnHoldIdArr = new JSONArray(10);
        }
        return delOnHoldIdArr;
    }

    public static Map<String, String> getDetailContentByOperateKey(String operateKey) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        String message = "";
        String operateName = "";
        String operateSuccessTip = "";
        switch (operateKey) {
            case "caltable_deleteentry": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u5220\u9664\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_3", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OnHoldDetailHelper_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "salaryfile_deleteentry": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u5220\u9664\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_3", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OnHoldDetailHelper_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "donothing_save": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u4fdd\u5b58\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_5", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OnHoldDetailHelper_6", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "donothing_formsubmit": {
                message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u505c\u7f13\u53d1\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldDetailHelper_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateName = ResManager.loadKDString((String)"\u751f\u6548\u505c\u7f13\u53d1", (String)"OnHoldDetailHelper_7", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                operateSuccessTip = ResManager.loadKDString((String)"\u751f\u6548\u6210\u529f", (String)"OnHoldDetailHelper_8", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
        }
        contentMap.put(operateKey + "_message", message);
        contentMap.put(operateKey + "_operateName", operateName);
        contentMap.put(operateKey + "_operateSuccessTip", operateSuccessTip);
        return contentMap;
    }

    public static void showDetailResultMsg(int total, List<String> errorMsgList, String operateKey, IFormView view) {
        Map<String, String> contentByOperateKey = OnHoldDetailHelper.getDetailContentByOperateKey(operateKey);
        if (errorMsgList == null || errorMsgList.isEmpty()) {
            return;
        }
        if (total == 1) {
            view.showErrorNotification(errorMsgList.get(0));
        } else {
            int fail = errorMsgList.size();
            int success = total - fail;
            String message = MessageFormat.format(contentByOperateKey.get(operateKey + "_message"), total, success, fail);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)contentByOperateKey.get(operateKey + "_operateName"), (String)message, errorMsgList);
            view.showForm(parameters);
        }
    }

    public static void showDetailResultMsg(Map<String, Object> resultMap, String operateKey, IFormView view) {
        Map<String, String> contentByOperateKey = OnHoldDetailHelper.getDetailContentByOperateKey(operateKey);
        Set errorMsgSet = (Set)resultMap.get("errorMsgSet");
        if (errorMsgSet == null) {
            view.showSuccessNotification(contentByOperateKey.get(operateKey + "_operateSuccessTip"));
            return;
        }
        ArrayList errorMsgList = new ArrayList(errorMsgSet);
        Integer successCount = (Integer)resultMap.get("successCount");
        Integer totalRecordCount = (Integer)resultMap.get("totalRecordCount");
        if (errorMsgList.isEmpty()) {
            view.showSuccessNotification(contentByOperateKey.get(operateKey + "_operateSuccessTip"));
            return;
        }
        if (errorMsgList.size() == 1 && totalRecordCount == 1) {
            view.showErrorNotification((String)errorMsgList.get(0));
        } else {
            int failCount = totalRecordCount - successCount;
            String message = MessageFormat.format(contentByOperateKey.get(operateKey + "_message"), totalRecordCount, successCount, failCount);
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)contentByOperateKey.get(operateKey + "_operateName"), (String)message, errorMsgList);
            view.showForm(parameters);
        }
    }

    public static List<Long> changeToList(Object[] primaryKeyValues) {
        ArrayList<Long> pkIds = new ArrayList<Long>(primaryKeyValues.length);
        for (Object pkObj : primaryKeyValues) {
            if (!(pkObj instanceof Long)) continue;
            Long pkId = Long.valueOf(String.valueOf(pkObj));
            pkIds.add(pkId);
        }
        return pkIds;
    }

    public static Map<Long, Integer> getDataPrecisionMap() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_dataprecision");
        DynamicObject[] dys = helper.query("id,scale", new QFilter[]{null});
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(dys.length);
        for (DynamicObject dynamicObject : dys) {
            map.put(dynamicObject.getLong("id"), dynamicObject.getInt("scale"));
        }
        return map;
    }

    public static Map<String, DynamicObject> getSalaryItemDataPrecisionInfoMap(Set<Long> salaryItemIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter isFilter = new QFilter("id", "in", salaryItemIdList);
        DynamicObject[] salaryItemArr = helper.query("id,dataprecision", new QFilter[]{isFilter});
        HashMap<String, DynamicObject> salaryItemDataPrecisionInfoMap = new HashMap<String, DynamicObject>(salaryItemArr.length);
        for (DynamicObject salaryItem : salaryItemArr) {
            salaryItemDataPrecisionInfoMap.put(salaryItem.getString("id"), salaryItem.getDynamicObject("dataprecision"));
        }
        return salaryItemDataPrecisionInfoMap;
    }

    public static List<String> getFileUrls(List<Long> selectedRowsId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("id", "in", selectedRowsId);
        String selectedProperties = "attachment";
        DynamicObject onHoldBill = helper.queryOne(selectedProperties, new QFilter[]{qFilter});
        ArrayList<String> urlList = new ArrayList<String>(10);
        if (onHoldBill != null) {
            DynamicObjectCollection attachmentCol = onHoldBill.getDynamicObjectCollection("attachment");
            for (DynamicObject attachment : attachmentCol) {
                urlList.add(attachment.getDynamicObject("fbasedataid").getString("url"));
            }
        }
        return urlList;
    }

    public static void uploadFiles(UploadEvent evt, IListView view) {
        Object[] urls = evt.getUrls();
        int urlSize = urls.length;
        if (urlSize == 0) {
            return;
        }
        DynamicObject[] saveAttObjArr = new DynamicObject[urlSize];
        int index = 0;
        DynamicObject onHoldObj = BusinessDataServiceHelper.loadSingle((Object)view.getFocusRowPkId(), (String)"hsas_onholdbill");
        if (onHoldObj == null) {
            return;
        }
        DynamicObjectCollection attachmentCol = onHoldObj.getDynamicObjectCollection("attachment");
        ArrayList<AttachmentInfo> infos = new ArrayList<AttachmentInfo>(urlSize);
        SWCPageCache pageCache = new SWCPageCache((IFormView)view);
        Map attacheInfoMap = (Map)pageCache.get("attacheInfoMap", Map.class);
        DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        ORM orm = ORM.create();
        long[] attachmentIds = orm.genLongIds(attObj.getDataEntityType(), urls.length);
        Long currUserId = RequestContext.get().getCurrUserId();
        for (Object urlObj : urls) {
            String url = String.valueOf(urlObj);
            String fileName = url.substring(url.lastIndexOf(47) + 1);
            Map attachInfo = (Map)attacheInfoMap.get(fileName);
            if (!MapUtils.isNotEmpty((Map)attachInfo)) continue;
            Integer size = (Integer)attachInfo.get("size");
            String uid = (String)attachInfo.get("uid");
            Date currDate = new Date();
            attObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
            long attachmentId = attachmentIds[index];
            attObj.set("name", (Object)fileName);
            attObj.set("id", (Object)attachmentId);
            attObj.set("size", (Object)size);
            attObj.set("uid", (Object)uid);
            attObj.set("url", (Object)url);
            attObj.set("type", (Object)fileName.substring(fileName.lastIndexOf(46) + 1));
            attObj.set("creator", (Object)currUserId);
            attObj.set("createtime", (Object)currDate);
            attObj.set("modifytime", (Object)currDate);
            attObj.set("pageid", (Object)view.getPageId());
            attObj.set("tempfile", (Object)1);
            attObj.set("filesource", (Object)1);
            attObj.set("status", (Object)"B");
            attObj.set("enable", (Object)"1");
            AttachmentInfo info = OnHoldDetailHelper.attFileldObjToAttachmentInfo(attObj);
            info.setEntityNum("hsas_onholddetail");
            info.setDownloadUrl(url);
            info.setPreviewUrl(info.getDownloadUrl().replace("download.do", "preview.do"));
            infos.add(info);
            saveAttObjArr[index++] = attObj;
            DynamicObject attacheObj = attachmentCol.addNew();
            attacheObj.set("fbasedataid_id", (Object)attachmentId);
        }
        if (saveAttObjArr.length > 0) {
            SaveServiceHelper.save((DynamicObject[])saveAttObjArr);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onHoldObj});
            BillFileMappingWriter.syncWriteFileBillMapping(infos);
        }
        pageCache.remove("attacheInfoMap");
    }

    public static AttachmentInfo attFileldObjToAttachmentInfo(DynamicObject attObj) {
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        Date today = new Date();
        attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
        attachmentInfo.setAttPkId(Long.valueOf(attObj.getLong("id")));
        attachmentInfo.setExt(attObj.getString("type"));
        attachmentInfo.setFileName(attObj.getString("name"));
        attachmentInfo.setFileSize(Long.valueOf(attObj.getLong("size")));
        attachmentInfo.setMark(attObj.getString("description"));
        attachmentInfo.setCreateTime(attObj.getDate("createtime"));
        attachmentInfo.setCreateUserId(RequestContext.get().getUserId());
        attachmentInfo.setModifyTime(today);
        return attachmentInfo;
    }

    public static String getEncodedUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return url;
        }
        try {
            url = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u9644\u4ef6\u4e0a\u4f20\u5730\u5740\u7f16\u7801\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        return url;
    }

    public static BigDecimal getScaleFormatValue(BigDecimal value, int scale) {
        if (value == null) {
            return BigDecimal.ZERO.setScale(scale, 4);
        }
        return value.setScale(scale, 4);
    }

    public static String getCalTableAmount(Map<String, DynamicObject> salaryItemDataPrecisionInfoMap, LinkedHashMap calPersonInfo) {
        String calPayoutItem = (String)calPersonInfo.get("payoutitem");
        String calAmount = (String)calPersonInfo.get("caltablecalamount");
        String calCurrencySign = (String)calPersonInfo.get("caltablecalcurrencySign");
        String calTableAmount = "";
        DynamicObject scaleObj = salaryItemDataPrecisionInfoMap.get(calPayoutItem);
        if (!SWCStringUtils.isEmpty((String)calAmount)) {
            int scale = 2;
            if (scaleObj != null) {
                scale = scaleObj.getInt("scale");
            }
            BigDecimal calAmountDecimal = new BigDecimal(calAmount);
            calAmountDecimal = OnHoldDetailHelper.getScaleFormatValue(calAmountDecimal, scale);
            calTableAmount = String.join((CharSequence)"", calCurrencySign == null ? "" : calCurrencySign, calAmountDecimal.toPlainString());
        }
        return calTableAmount;
    }

    public static Set<Long> getSalaryItemIdSet(Map<String, String> queryCalRuleNetSalaryIdMap) {
        HashSet<Long> salaryItemIdSet = new HashSet<Long>(16);
        for (Map.Entry<String, String> entry : queryCalRuleNetSalaryIdMap.entrySet()) {
            if (entry.getValue() == null) continue;
            String netSalaryItem = entry.getValue();
            Long salaryItemId = Long.valueOf(netSalaryItem.substring(0, netSalaryItem.indexOf("||")));
            salaryItemIdSet.add(salaryItemId);
        }
        return salaryItemIdSet;
    }

    public static String getCalPersonAmount(Map<String, String> actualSalaryInfoMap, Map<String, DynamicObject> salaryItemDataPrecisionInfoMap, String netSalaryId) {
        String calAmount = actualSalaryInfoMap.get("calAmount");
        if (StringUtils.isEmpty((String)calAmount) || SWCStringUtils.isEmpty((String)netSalaryId)) {
            return "";
        }
        DynamicObject dataPrecision = salaryItemDataPrecisionInfoMap.get(netSalaryId);
        int scale = 2;
        if (dataPrecision != null) {
            scale = dataPrecision.getInt("scale");
        }
        String calCurrencySign = actualSalaryInfoMap.get("calcurrencySign");
        BigDecimal calAmountDecimal = new BigDecimal(calAmount);
        calAmountDecimal = OnHoldDetailHelper.getScaleFormatValue(calAmountDecimal, scale);
        return String.join((CharSequence)"", calCurrencySign == null ? "" : calCurrencySign, calAmountDecimal.toPlainString());
    }

    public static Map<String, List<DynamicObject>> validateCalDateIsRepeate(Map<String, DynamicObjectCollection> onHoldObjMap, boolean isSave, Set<String> errorMsgSet) {
        DynamicObjectCollection calPersonOnHoldList = onHoldObjMap.get("caltableList");
        DynamicObjectCollection salaryFileOnHoldList = onHoldObjMap.get("salaryfileList");
        HashMap<String, List<DynamicObject>> validateResultMap = new HashMap<String, List<DynamicObject>>(2);
        DynamicObjectCollection errorCalPersonList = new DynamicObjectCollection();
        DynamicObjectCollection errorSalaryFileList = new DynamicObjectCollection();
        if (calPersonOnHoldList == null || calPersonOnHoldList.isEmpty() || salaryFileOnHoldList == null || salaryFileOnHoldList.isEmpty()) {
            validateResultMap.put("caltableList", (List<DynamicObject>)errorCalPersonList);
            validateResultMap.put("salaryfileList", (List<DynamicObject>)errorSalaryFileList);
            return validateResultMap;
        }
        for (DynamicObject calPersonOnHoldObj : calPersonOnHoldList) {
            Boolean calOnHoldStatus = calPersonOnHoldObj.getBoolean("caltableonholdstatus");
            int calPersonStatus = calPersonOnHoldObj.getInt("caltablestatus");
            Date calTaskStartDate = calPersonOnHoldObj.getDate("caltablestartdate");
            Date calTaskEndDate = calPersonOnHoldObj.getDate("caltableenddate");
            if (!calOnHoldStatus.booleanValue() || calPersonStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode() || calTaskStartDate == null || calTaskEndDate == null) continue;
            for (DynamicObject salaryOnHoldObj : salaryFileOnHoldList) {
                Boolean salaryFileOnHoldStatus = salaryOnHoldObj.getBoolean("salaryonholdstatus");
                int salaryFileStatus = salaryOnHoldObj.getInt("salaryfilestatus");
                Date salaryStartDate = salaryOnHoldObj.getDate("startdate");
                Date salaryEndDate = salaryOnHoldObj.getDate("enddate");
                if (!salaryFileOnHoldStatus.booleanValue() || salaryFileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode() || salaryStartDate == null || SWCDateTimeUtils.getDayDate((Date)calTaskStartDate).before(salaryStartDate) || salaryEndDate.before(SWCDateTimeUtils.getDayDate((Date)calTaskEndDate))) continue;
                errorCalPersonList.add((Object)calPersonOnHoldObj);
                errorSalaryFileList.add((Object)salaryOnHoldObj);
                String salaryfileNumber = salaryOnHoldObj.getString("salaryfileinfo.number");
                String errorContent = "";
                errorContent = isSave ? ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5b58\u5728\u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_24", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5b58\u5728\u91cd\u590d\uff0c\u65e0\u6cd5\u505c\u7f13\u53d1\u3002", (String)"OnHoldBillService_25", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                String errorMsg = MessageFormat.format(errorContent, salaryfileNumber, SWCDateTimeUtils.format((Date)calTaskStartDate, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)calTaskEndDate, (String)"yyyy/MM/dd"));
                errorMsgSet.add(errorMsg);
            }
        }
        validateResultMap.put("caltableList", (List<DynamicObject>)errorCalPersonList);
        validateResultMap.put("salaryfileList", (List<DynamicObject>)errorSalaryFileList);
        return validateResultMap;
    }

    public static String getCalSalaryFileErrorMsg(boolean isSave, boolean isDetail, int onHoldStatus) {
        String errorContent = "";
        if (isSave) {
            if (OnHoldStatusEnum.STATUS_SAVE.getCode() == onHoldStatus) {
                errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\u3002", (String)"OnHoldBillService_17", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                if (isDetail) {
                    errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u5df2{3}\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_10", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                }
            } else if (OnHoldStatusEnum.STATUS_RELEASE.getCode() == onHoldStatus) {
                errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldBillService_20", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                if (isDetail) {
                    errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_13", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                }
            } else if (OnHoldStatusEnum.STATUS_TOPAY.getCode() == onHoldStatus) {
                errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u4e3a{5}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_21", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                if (isDetail) {
                    errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u4e3a{3}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_11", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                }
            } else {
                errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_19", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                if (isDetail) {
                    errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u5df2{3}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_12", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                }
            }
        } else if (OnHoldStatusEnum.STATUS_SAVE.getCode() == onHoldStatus || OnHoldStatusEnum.STATUS_RELEASE.getCode() == onHoldStatus) {
            errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldBillService_20", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            if (isDetail) {
                errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_13", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            }
        } else {
            errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldBillService_21", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            if (isDetail) {
                errorContent = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u7f16\u7801{0}\u5728{1}~{2}\u5df2{3}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldDetailHelper_14", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            }
        }
        return errorContent;
    }

    public static String getSalaryFileErrorMsg(boolean isSave, boolean isDetail, int onHoldStatus) {
        String errorContent;
        block13: {
            block12: {
                errorContent = "";
                if (!isSave) break block12;
                switch (onHoldStatus) {
                    case 0: {
                        errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\u3002", (String)"OnHoldBillService_13", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                        if (isDetail) {
                            errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5df2{3}\uff0c\u8bf7\u52ff\u91cd\u590d\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_15", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                            break;
                        }
                        break block13;
                    }
                    case 1: {
                        errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_22", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                        if (isDetail) {
                            errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_18", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u4e3a{5}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_14", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                        if (isDetail) {
                            errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u4e3a{3}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_16", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                            break;
                        }
                        break block13;
                    }
                    default: {
                        errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_15", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                        if (isDetail) {
                            errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5df2{3}\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldDetailHelper_17", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            switch (onHoldStatus) {
                case 0: 
                case 1: {
                    errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_22", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                    if (!isDetail) break;
                    errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u518d\u8fdb\u884c\u76f8\u5e94\u64cd\u4f5c\u3002", (String)"OnHoldDetailHelper_18", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                    break;
                }
                default: {
                    errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\u5728\u201c{3}~{4}\u201d\u5df2{5}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldDetailHelper_20", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                    if (!isDetail) break;
                    errorContent = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7{0}\u5728{1}~{2}\u5df2{3}\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldDetailHelper_19", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                }
            }
        }
        return errorContent;
    }
}

