/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cal.service.PayStateService;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldMsgHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldFailStatusEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OnHoldBillInterfaceService {
    private static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    private static final Log log = LogFactory.getLog(OnHoldBillInterfaceService.class);
    public static final String OPSTATUS_SUCC = "1";
    public static final String OPSTATUS_FAIL = "0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> saveOnHold(JSONObject onHoldInfoCacheJSONObject, List<String> selectedPersonIdList, List<Map<String, Object>> resultList, String failStrategy) {
        log.info("#######starting saving onHoldInterface data#######");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<Long> onHoldToUpdateIdList = new ArrayList<Long>(10);
        Map<String, Object> validateResultMap = this.validateOnHoldInfo(onHoldInfoCacheJSONObject, selectedPersonIdList, resultList, onHoldToUpdateIdList, true);
        Set errorMsgSet = (Set)validateResultMap.get("errorMsgSet");
        Integer failCount = (Integer)validateResultMap.get("failCount");
        Integer totalRecordCount = (Integer)validateResultMap.get("totalRecordCount");
        if (SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC) && resultList.size() > 0) {
            resultMap.put("errorMsgSet", errorMsgSet);
            resultMap.put("failCount", failCount);
            resultMap.put("totalRecordCount", totalRecordCount);
            resultMap.put("totalPersonCount", selectedPersonIdList.size());
            long endTime = System.currentTimeMillis();
            log.info("[finish saving] total time:{}(ms)", (Object)(endTime - startTime));
            return resultMap;
        }
        SWCDataServiceHelper onHoldBillService = new SWCDataServiceHelper("hsas_onholdbill");
        ArrayList<Long> onHoldToDeleteIdList = new ArrayList<Long>(10);
        DynamicObjectCollection onHoldToSaveCollection = this.getOnHoldToSaveCollection(onHoldInfoCacheJSONObject, onHoldToDeleteIdList, onHoldToUpdateIdList, selectedPersonIdList);
        DynamicObjectCollection onHoldToUpdateCollection = this.getOnHoldToUpdateCollection(onHoldInfoCacheJSONObject, onHoldToUpdateIdList, selectedPersonIdList);
        Object[] savedOnHoldArr = null;
        Object[] updatedOnHoldArr = null;
        Integer successCount = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            JSONArray toDeleOnHoldIdAppcheArr;
            savedOnHoldArr = onHoldBillService.save(onHoldToSaveCollection);
            if (savedOnHoldArr != null && savedOnHoldArr.length > 0) {
                successCount = successCount + savedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(savedOnHoldArr, true);
                this.retrographyOnHoldId(onHoldInfoCacheJSONObject, savedOnHoldArr);
            }
            if ((toDeleOnHoldIdAppcheArr = onHoldInfoCacheJSONObject.getJSONArray("delOnholdIdList")) != null && !toDeleOnHoldIdAppcheArr.isEmpty()) {
                onHoldBillService.delete(toDeleOnHoldIdAppcheArr.toArray());
                onHoldInfoCacheJSONObject.remove((Object)"delOnholdIdList");
            }
            if (!onHoldToDeleteIdList.isEmpty()) {
                onHoldBillService.delete(onHoldToDeleteIdList.toArray());
                this.clearOnHoldId(onHoldInfoCacheJSONObject, onHoldToDeleteIdList);
            }
            if ((updatedOnHoldArr = onHoldBillService.save((DynamicObject[])onHoldToUpdateCollection.toArray((Object[])new DynamicObject[0]))) != null && updatedOnHoldArr.length > 0) {
                successCount = successCount + updatedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(updatedOnHoldArr, true);
            }
        }
        this.putPkIdsToResultMap(savedOnHoldArr, resultMap);
        this.putPkIdsToResultMap(updatedOnHoldArr, resultMap);
        this.saveResultToResultMap(savedOnHoldArr, resultMap);
        resultMap.put("errorMsgSet", errorMsgSet);
        resultMap.put("failCount", failCount);
        resultMap.put("successCount", successCount);
        resultMap.put("totalRecordCount", totalRecordCount);
        resultMap.put("totalPersonCount", selectedPersonIdList.size());
        long endTime = System.currentTimeMillis();
        log.info("[finish saving] total time:{}(ms)", (Object)(endTime - startTime));
        return resultMap;
    }

    private void saveResultToResultMap(Object[] savedOnHoldArr, Map<String, Object> resultMap) {
        if (savedOnHoldArr == null || savedOnHoldArr.length == 0) {
            return;
        }
        ArrayList detailList = new ArrayList(savedOnHoldArr.length);
        for (Object object : savedOnHoldArr) {
            if (!(object instanceof DynamicObject)) continue;
            DynamicObject onHoldObj = (DynamicObject)object;
            HashMap<String, Long> detailMap = new HashMap<String, Long>(2);
            Long salaryFileId = onHoldObj.getLong("salaryfile");
            detailMap.put("salaryFileId", salaryFileId);
            Long calTaskId = onHoldObj.getLong("caltask");
            detailMap.put("calTaskId", calTaskId);
            detailList.add(detailMap);
        }
        resultMap.put("sucResultList", detailList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> submitOnHold(JSONObject onHoldInfoCacheJSONObject, List<String> selectedPersonIdList, List<Map<String, Object>> resultList, String failStrategy) {
        log.info("#######starting submitting onhold datas#######");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer totalRecordCount = 0;
        Integer failCount = 0;
        ArrayList<Long> onHoldToUpdateIdList = new ArrayList<Long>(10);
        Map<String, Object> validateResultMap = this.validateOnHoldInfo(onHoldInfoCacheJSONObject, selectedPersonIdList, resultList, onHoldToUpdateIdList, false);
        Set errorMsgSet = (Set)validateResultMap.get("errorMsgSet");
        failCount = (Integer)validateResultMap.get("failCount");
        totalRecordCount = (Integer)validateResultMap.get("totalRecordCount");
        if (SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC) && resultList.size() > 0) {
            resultMap.put("errorMsgSet", errorMsgSet);
            resultMap.put("failCount", failCount);
            resultMap.put("totalRecordCount", totalRecordCount);
            resultMap.put("totalPersonCount", selectedPersonIdList.size());
            long endTime = System.currentTimeMillis();
            log.info("[finish saving] total time:{}(ms)", (Object)(endTime - startTime));
            return resultMap;
        }
        SWCDataServiceHelper onholdBillService = new SWCDataServiceHelper("hsas_onholdbill");
        ArrayList<Long> onHoldToDeleteIdList = new ArrayList<Long>(10);
        DynamicObjectCollection onHoldToSaveCollection = this.getOnHoldToSaveCollection(onHoldInfoCacheJSONObject, onHoldToDeleteIdList, onHoldToUpdateIdList, selectedPersonIdList);
        DynamicObjectCollection onHoldToUpdateCollection = this.getOnHoldToUpdateCollection(onHoldInfoCacheJSONObject, onHoldToUpdateIdList, selectedPersonIdList);
        Object[] savedOnHoldArr = null;
        Object[] updatedOnHoldArr = null;
        Integer successCount = 0;
        try (TXHandle txHandle = TX.requiresNew();){
            JSONArray toDeleOnHoldIdAppcheArr;
            savedOnHoldArr = onholdBillService.save(OnHoldDetailHelper.modifyOnHoldStatus(onHoldToSaveCollection));
            if (savedOnHoldArr != null && savedOnHoldArr.length > 0) {
                successCount = successCount + savedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(savedOnHoldArr, false);
                this.retrographyOnHoldId(onHoldInfoCacheJSONObject, savedOnHoldArr);
            }
            if ((toDeleOnHoldIdAppcheArr = onHoldInfoCacheJSONObject.getJSONArray("delOnholdIdList")) != null && !toDeleOnHoldIdAppcheArr.isEmpty()) {
                onholdBillService.delete(toDeleOnHoldIdAppcheArr.toArray());
                onHoldInfoCacheJSONObject.remove((Object)"delOnholdIdList");
            }
            if (!onHoldToDeleteIdList.isEmpty()) {
                onholdBillService.delete(onHoldToDeleteIdList.toArray());
                this.clearOnHoldId(onHoldInfoCacheJSONObject, onHoldToDeleteIdList);
            }
            if ((updatedOnHoldArr = onholdBillService.save((DynamicObject[])OnHoldDetailHelper.modifyOnHoldStatus(onHoldToUpdateCollection).toArray((Object[])new DynamicObject[0]))) != null && updatedOnHoldArr.length > 0) {
                successCount = successCount + updatedOnHoldArr.length;
                OnHoldDetailHelper.updateRelevanceOnHoldStatus(updatedOnHoldArr, false);
                this.retrographyOnHoldId(onHoldInfoCacheJSONObject, updatedOnHoldArr);
            }
        }
        this.putPkIdsToResultMap(savedOnHoldArr, resultMap);
        this.putPkIdsToResultMap(updatedOnHoldArr, resultMap);
        this.saveResultToResultMap(savedOnHoldArr, resultMap);
        try {
            OnHoldMsgHelper.sendOnHoldMsgByBillCollection("onholdbillsubmit", onHoldToSaveCollection, onHoldToUpdateCollection);
        }
        catch (Exception e) {
            log.error("error occurred during sending message\uff1a{}", (Object)e.getMessage());
        }
        resultMap.put("errorMsgSet", errorMsgSet);
        resultMap.put("totalPersonCount", selectedPersonIdList.size());
        resultMap.put("failCount", failCount);
        resultMap.put("totalRecordCount", totalRecordCount);
        resultMap.put("successCount", successCount);
        long endTime = System.currentTimeMillis();
        log.info("[finish saving] total time:{}(ms)", (Object)(endTime - startTime));
        return resultMap;
    }

    private List<Long> putPkIdsToResultMap(Object[] savedOnHoldArr, Map<String, Object> resultMap) {
        if (savedOnHoldArr == null) {
            return new ArrayList<Long>(10);
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(savedOnHoldArr.length);
        LinkedHashSet<Long> pkIdSet = new LinkedHashSet<Long>(savedOnHoldArr.length);
        for (Object object : savedOnHoldArr) {
            if (!(object instanceof DynamicObject)) continue;
            DynamicObject onHold = (DynamicObject)object;
            pkIds.add(onHold.getLong("id"));
        }
        pkIdSet.addAll(pkIds);
        List savePkIds = (List)resultMap.get("SavePkIds");
        if (savePkIds == null) {
            resultMap.put("SavePkIds", new ArrayList(pkIdSet));
        } else {
            pkIdSet.addAll(savePkIds);
            resultMap.put("SavePkIds", new ArrayList(pkIdSet));
        }
        return pkIds;
    }

    private DynamicObjectCollection getOnHoldToSaveCollection(JSONObject onholdInfoAppcheJSONObject, List<Long> onHoldToDeleteIdList, List<Long> onHoldToUpdateIdList, List<String> selectedPersonIdList) {
        List<Long> onHoldIdList = this.getCacheAllOnholdIdList(onholdInfoAppcheJSONObject);
        Map<String, String> onHoldIdRefIdMap = OnHoldBillHelper.queryOnHoldIdRefIdByIdList(onHoldIdList);
        DynamicObjectCollection onHoldToSaveColl = new DynamicObjectCollection();
        for (Map.Entry onholdInfo : onholdInfoAppcheJSONObject.entrySet()) {
            Object onHoldInfoObj = onholdInfo.getValue();
            String personId = (String)onholdInfo.getKey();
            if (selectedPersonIdList.indexOf(personId) < 0 || !(onHoldInfoObj instanceof JSONObject)) continue;
            JSONObject personJsonInfo = (JSONObject)onHoldInfoObj;
            Boolean isPass = (Boolean)personJsonInfo.get((Object)"isPass");
            if (isPass != null && isPass.booleanValue()) {
                personJsonInfo.put("isPass", (Object)Boolean.FALSE);
                continue;
            }
            if (personJsonInfo.containsKey((Object)"caltableList")) {
                DynamicObjectCollection calPersonOnHoldColl = this.saveCalPersonOnHoldInfo(personJsonInfo, onHoldToDeleteIdList, onHoldToUpdateIdList, onHoldIdRefIdMap);
                onHoldToSaveColl.addAll((Collection)calPersonOnHoldColl);
            }
            if (!personJsonInfo.containsKey((Object)"salaryfileList")) continue;
            DynamicObjectCollection salaryFileOnHoldColl = this.saveSalaryOnHoldInfo(personJsonInfo, onHoldToUpdateIdList, onHoldIdRefIdMap);
            onHoldToSaveColl.addAll((Collection)salaryFileOnHoldColl);
        }
        return onHoldToSaveColl;
    }

    private DynamicObjectCollection getOnHoldToUpdateCollection(JSONObject onholdInfoAppcheJSONObject, List<Long> onHoldToUpdateIdList, List<String> selectedPersonIdList) {
        DynamicObjectCollection onHoldToUpdateColl = new DynamicObjectCollection();
        Map<String, DynamicObject> onHoldIdRefObjMap = OnHoldBillHelper.queryOnHoldIdRefObjByIdList(onHoldToUpdateIdList);
        if (!onHoldIdRefObjMap.isEmpty()) {
            for (Map.Entry onholdInfo : onholdInfoAppcheJSONObject.entrySet()) {
                JSONObject personJsonInfo;
                Boolean isPass;
                Object onHoldInfoObj = onholdInfo.getValue();
                String personId = (String)onholdInfo.getKey();
                if (selectedPersonIdList.indexOf(personId) < 0 || !(onHoldInfoObj instanceof JSONObject) || (isPass = (Boolean)(personJsonInfo = (JSONObject)onHoldInfoObj).get((Object)"isPass")) != null && isPass.booleanValue()) continue;
                if (personJsonInfo.containsKey((Object)"caltableList")) {
                    DynamicObjectCollection updateCaltableOnHoldInfo = this.updateCaltableOnHoldInfo(personJsonInfo, onHoldIdRefObjMap);
                    onHoldToUpdateColl.addAll((Collection)updateCaltableOnHoldInfo);
                }
                if (!personJsonInfo.containsKey((Object)"salaryfileList")) continue;
                DynamicObjectCollection updateSalaryOnHoldInfo = this.updateSalaryOnHoldInfo(personJsonInfo, onHoldIdRefObjMap);
                onHoldToUpdateColl.addAll((Collection)updateSalaryOnHoldInfo);
            }
        }
        return onHoldToUpdateColl;
    }

    private List<Long> getCacheAllOnholdIdList(JSONObject onholdInfoAppcheJSONObject) {
        ArrayList<Long> onHoldIdList = new ArrayList<Long>(10);
        for (Map.Entry onholdInfo : onholdInfoAppcheJSONObject.entrySet()) {
            Object onHoldInfoObj = onholdInfo.getValue();
            if (!(onHoldInfoObj instanceof JSONObject)) continue;
            JSONObject personJsonInfo = (JSONObject)onHoldInfoObj;
            for (Map.Entry personJsonInfoDetail : personJsonInfo.entrySet()) {
                String onHoldId;
                JSONObject onHoldInfoMap;
                int index;
                String detailKey = (String)personJsonInfoDetail.getKey();
                if (!detailKey.equals("caltableList") && !detailKey.equals("salaryfileList")) continue;
                JSONArray personJsonInfoDetailList = (JSONArray)personJsonInfoDetail.getValue();
                if ("caltableList".equals(detailKey)) {
                    for (index = 0; index < personJsonInfoDetailList.size(); ++index) {
                        onHoldInfoMap = personJsonInfoDetailList.getJSONObject(index);
                        onHoldId = (String)onHoldInfoMap.get((Object)"caltableOnHoldId");
                        if (!SWCStringUtils.isNotEmpty((String)onHoldId)) continue;
                        onHoldIdList.add(Long.valueOf(onHoldId));
                    }
                    continue;
                }
                if (!"salaryfileList".equals(detailKey)) continue;
                for (index = 0; index < personJsonInfoDetailList.size(); ++index) {
                    onHoldInfoMap = personJsonInfoDetailList.getJSONObject(index);
                    onHoldId = (String)onHoldInfoMap.get((Object)"salaryfileOnHoldId");
                    if (!SWCStringUtils.isNotEmpty((String)onHoldId)) continue;
                    onHoldIdList.add(Long.valueOf(onHoldId));
                }
            }
        }
        return onHoldIdList;
    }

    private Map<String, Object> validateOnHoldInfo(JSONObject onholdInfoAppcheJSONObject, List<String> selectedPersonIdList, List<Map<String, Object>> resultList, List<Long> onHoldToUpdateIdList, boolean isSave) {
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        Map<String, List<Long>> cacheIdListMap = this.getCacheIdList(onholdInfoAppcheJSONObject);
        List<Long> calPersonIdList = cacheIdListMap.get("caltableIdList");
        HashSet errorMsgSet = new HashSet(16);
        Map<String, Object> validateCalPersonResultMap = this.validateCalPerson(onholdInfoAppcheJSONObject, calPersonIdList, resultList, selectedPersonIdList, onHoldToUpdateIdList, isSave);
        Set caltableErrorMsgSet = (Set)validateCalPersonResultMap.get("errorMsgSet");
        Integer caltableFailCount = (Integer)validateCalPersonResultMap.get("failCount");
        Integer caltableTotalCount = (Integer)validateCalPersonResultMap.get("totalCount");
        List<Long> salaryIdList = cacheIdListMap.get("salaryfileIdList");
        Map<String, Object> validateSalaryResultMap = this.validateSalary(onholdInfoAppcheJSONObject, salaryIdList, resultList, selectedPersonIdList, onHoldToUpdateIdList, isSave);
        Set salaryErrorMsgSet = (Set)validateSalaryResultMap.get("errorMsgSet");
        Integer salaryFailCount = (Integer)validateSalaryResultMap.get("failCount");
        Integer salaryTotalCount = (Integer)validateSalaryResultMap.get("totalCount");
        Integer totalRecordCount = caltableTotalCount + salaryTotalCount;
        Integer failCount = caltableFailCount + salaryFailCount;
        errorMsgSet.addAll(caltableErrorMsgSet);
        errorMsgSet.addAll(salaryErrorMsgSet);
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalRecordCount", totalRecordCount);
        return validateResultMap;
    }

    public static Map<String, List<DynamicObject>> savedOnHoldAssembleDataMap(Object[] onHoldArr) {
        if (onHoldArr == null || onHoldArr.length == 0) {
            return null;
        }
        int len = onHoldArr.length;
        HashMap<String, List<DynamicObject>> savedOnHoldObjMap = new HashMap<String, List<DynamicObject>>(len);
        ArrayList<DynamicObject> caltableObjList = new ArrayList<DynamicObject>(len);
        ArrayList<DynamicObject> salaryfileObjList = new ArrayList<DynamicObject>(len);
        savedOnHoldObjMap.put("caltableObjList", caltableObjList);
        savedOnHoldObjMap.put("salaryfileObjList", salaryfileObjList);
        for (Object obj : onHoldArr) {
            if (!(obj instanceof DynamicObject)) continue;
            DynamicObject onholdObj = (DynamicObject)obj;
            String caltableId = onholdObj.getString("caltableid");
            if (!SWCStringUtils.equals((String)OPSTATUS_FAIL, (String)caltableId)) {
                caltableObjList.add(onholdObj);
                continue;
            }
            salaryfileObjList.add(onholdObj);
        }
        return savedOnHoldObjMap;
    }

    private void retrographyOnHoldId(JSONObject onholdInfoAppcheJSONObject, Object[] onHoldArr) {
        Map<String, List<DynamicObject>> savedOnHoldObjMap = OnHoldBillInterfaceService.savedOnHoldAssembleDataMap(onHoldArr);
        Map<String, List<DynamicObject>> salaryfileIdRefOnHoldMap = OnHoldBillInterfaceService.packageSalaryfileSavedOnHoldInfo(onHoldArr);
        if (onholdInfoAppcheJSONObject == null || savedOnHoldObjMap == null) {
            return;
        }
        for (Map.Entry onHoldInfo : onholdInfoAppcheJSONObject.entrySet()) {
            Object onHoldInfoObj = onHoldInfo.getValue();
            if (!(onHoldInfoObj instanceof LinkedHashMap)) continue;
            LinkedHashMap personJsonInfo = (LinkedHashMap)onHoldInfoObj;
            for (Map.Entry personJsonInfoDetail : personJsonInfo.entrySet()) {
                String detailKey = (String)personJsonInfoDetail.getKey();
                if (!detailKey.equals("caltableList") && !detailKey.equals("salaryfileList")) continue;
                List personJsonInfoDetailList = (List)personJsonInfoDetail.getValue();
                if ("caltableList".equals(detailKey)) {
                    List<DynamicObject> savedCaltableOnHoldObjList = savedOnHoldObjMap.get("caltableObjList");
                    this.setCalPersonOnHoldId(personJsonInfoDetailList, savedCaltableOnHoldObjList);
                    continue;
                }
                if (!"salaryfileList".equals(detailKey)) continue;
                this.setSalaryOnHoldId(personJsonInfoDetailList, salaryfileIdRefOnHoldMap);
            }
        }
    }

    private void clearOnHoldId(JSONObject onholdInfoAppcheJSONObject, List<Long> onHoldToDeleteIdList) {
        for (Map.Entry onHoldInfo : onholdInfoAppcheJSONObject.entrySet()) {
            Object onHoldInfoObj = onHoldInfo.getValue();
            if (!(onHoldInfoObj instanceof JSONObject)) continue;
            JSONObject personJsonInfo = (JSONObject)onHoldInfoObj;
            for (Map.Entry personJsonInfoDetail : personJsonInfo.entrySet()) {
                String detailKey = (String)personJsonInfoDetail.getKey();
                if (!detailKey.equals("caltableList") && !detailKey.equals("salaryfileList")) continue;
                JSONArray personJsonInfoDetailList = (JSONArray)personJsonInfoDetail.getValue();
                this.clearOnHoldDetailId(personJsonInfoDetailList, onHoldToDeleteIdList, detailKey);
            }
        }
    }

    private void clearOnHoldDetailId(JSONArray personJsonInfoDetailList, List<Long> onHoldToDeleteIdList, String detailKey) {
        for (int index = 0; index < personJsonInfoDetailList.size(); ++index) {
            JSONObject onHoldInfoMap = personJsonInfoDetailList.getJSONObject(index);
            for (Long deletedOnHoldId : onHoldToDeleteIdList) {
                if ("caltableList".equals(detailKey)) {
                    String caltableOnHoldId = (String)onHoldInfoMap.get((Object)"caltableOnHoldId");
                    if (!SWCStringUtils.isNotEmpty((String)caltableOnHoldId) || !deletedOnHoldId.equals(Long.valueOf(caltableOnHoldId))) continue;
                    onHoldInfoMap.remove((Object)"caltableOnHoldId");
                    continue;
                }
                String salaryfileOnHoldId = (String)onHoldInfoMap.get((Object)"salaryfileOnHoldId");
                if (!SWCStringUtils.isNotEmpty((String)salaryfileOnHoldId) || !deletedOnHoldId.equals(Long.valueOf(salaryfileOnHoldId))) continue;
                onHoldInfoMap.remove((Object)"salaryfileOnHoldId");
            }
        }
    }

    private void setCalPersonOnHoldId(List<LinkedHashMap> personJsonInfoDetailList, List<DynamicObject> savedCaltableOnHoldObjList) {
        if (personJsonInfoDetailList == null || personJsonInfoDetailList.isEmpty() || savedCaltableOnHoldObjList == null || savedCaltableOnHoldObjList.isEmpty()) {
            return;
        }
        for (LinkedHashMap onHoldInfoMap : personJsonInfoDetailList) {
            String cacheModuleId = (String)onHoldInfoMap.get("caltable");
            Iterator<DynamicObject> iterator = savedCaltableOnHoldObjList.iterator();
            while (iterator.hasNext()) {
                DynamicObject savedCalPersonOnHoldObj;
                DynamicObject savedCaltableOnHold = savedCalPersonOnHoldObj = iterator.next();
                String moduleIdVal = savedCaltableOnHold.getString("caltableid");
                Boolean onholdStatus = (Boolean)onHoldInfoMap.get("caltableonholdstatus");
                if (!onholdStatus.booleanValue() || !cacheModuleId.equals(moduleIdVal)) continue;
                onHoldInfoMap.put("caltableOnHoldId", savedCaltableOnHold.getString("id"));
                onHoldInfoMap.put("caltableStatus", savedCaltableOnHold.getString("status"));
            }
        }
    }

    private void setSalaryOnHoldId(List<LinkedHashMap> personJsonInfoDetailList, Map<String, List<DynamicObject>> salaryfileIdRefOnHoldMap) {
        block2: for (LinkedHashMap onholdInfoMap : personJsonInfoDetailList) {
            String cacheStartDateStr;
            String salaryfileIdCache = (String)onholdInfoMap.get("salaryfile");
            List<DynamicObject> salaryfileOnHoldSavedList = salaryfileIdRefOnHoldMap.get(salaryfileIdCache);
            if (salaryfileOnHoldSavedList == null || (cacheStartDateStr = (String)onholdInfoMap.get("salaryonholdstartdate")) == null) continue;
            for (DynamicObject salaryfileSavedObj : salaryfileOnHoldSavedList) {
                String savedIsAllowCal = salaryfileSavedObj.getString("isallowcal");
                if (SWCStringUtils.isEmpty((String)savedIsAllowCal)) continue;
                Object salaryfileObj = salaryfileSavedObj.get("salaryfile");
                String salaryfileIdSaved = "";
                salaryfileIdSaved = salaryfileObj instanceof DynamicObject ? ((DynamicObject)salaryfileObj).getString("id") : String.valueOf(salaryfileObj);
                Date cacheStartDate = null;
                try {
                    cacheStartDate = SWCDateTimeUtils.parseDate((String)cacheStartDateStr);
                }
                catch (ParseException e) {
                    log.error("error occurred during changing time\uff1a\uff1a{}", (Object)e.getMessage());
                }
                String cacheIsAllowCal = (String)onholdInfoMap.get("salaryisallowcal");
                Date startDate = salaryfileSavedObj.getDate("startdate");
                if (!salaryfileIdCache.equals(salaryfileIdSaved) || cacheStartDate.getTime() != startDate.getTime() || !SWCStringUtils.equals((String)savedIsAllowCal, (String)cacheIsAllowCal)) continue;
                onholdInfoMap.put("salaryfileOnHoldId", salaryfileSavedObj.getString("id"));
                onholdInfoMap.put("salaryfileStatus", salaryfileSavedObj.getString("status"));
                continue block2;
            }
        }
    }

    public static Map<String, List<DynamicObject>> packageSalaryfileSavedOnHoldInfo(Object[] onHoldArr) {
        int onHoldSize = onHoldArr.length;
        HashMap<String, List<DynamicObject>> salaryfileIdRefOnHoldMap = new HashMap<String, List<DynamicObject>>(onHoldSize);
        for (Object obj : onHoldArr) {
            if (!(obj instanceof DynamicObject)) continue;
            DynamicObject onHoldInfo = (DynamicObject)obj;
            Object salaryfileObj = onHoldInfo.get("salaryfile");
            String salaryfileId = "";
            salaryfileId = salaryfileObj instanceof DynamicObject ? ((DynamicObject)salaryfileObj).getString("id") : (String)salaryfileObj;
            ArrayList<DynamicObject> salaryfileOnHoldList = (ArrayList<DynamicObject>)salaryfileIdRefOnHoldMap.get(salaryfileId);
            if (salaryfileOnHoldList == null) {
                salaryfileOnHoldList = new ArrayList<DynamicObject>(onHoldSize);
                salaryfileIdRefOnHoldMap.put(salaryfileId, salaryfileOnHoldList);
            }
            salaryfileOnHoldList.add(onHoldInfo);
        }
        return salaryfileIdRefOnHoldMap;
    }

    private Map<String, List<Long>> getCacheIdList(JSONObject onholdInfoAppcheJSONObject) {
        HashMap<String, List<Long>> cacheIdListMap = new HashMap<String, List<Long>>(16);
        ArrayList<Long> caltableIdList = new ArrayList<Long>(10);
        ArrayList<Long> salaryIdList = new ArrayList<Long>(10);
        for (Map.Entry onholdInfo : onholdInfoAppcheJSONObject.entrySet()) {
            int index;
            Object onHoldInfoObj = onholdInfo.getValue();
            if (!(onHoldInfoObj instanceof JSONObject)) continue;
            JSONObject personJsonInfo = (JSONObject)onHoldInfoObj;
            JSONArray caltableIdCacheList = personJsonInfo.getJSONArray("caltableIdList");
            JSONArray salaryIdCacheList = personJsonInfo.getJSONArray("salaryfileIdList");
            if (caltableIdCacheList != null) {
                for (index = 0; index < caltableIdCacheList.size(); ++index) {
                    caltableIdList.add(caltableIdCacheList.getLong(index));
                }
            }
            if (salaryIdCacheList == null) continue;
            for (index = 0; index < salaryIdCacheList.size(); ++index) {
                salaryIdList.add(salaryIdCacheList.getLong(index));
            }
        }
        cacheIdListMap.put("caltableIdList", caltableIdList);
        cacheIdListMap.put("salaryfileIdList", salaryIdList);
        return cacheIdListMap;
    }

    private List<Long> getCalSalaryFileIdList(JSONObject onholdInfoAppcheJSONObject, List<String> selectedPersonIdList) {
        ArrayList<Long> salaryFileIdList = new ArrayList<Long>(10);
        for (Map.Entry onholdInfo : onholdInfoAppcheJSONObject.entrySet()) {
            LinkedHashMap personJsonInfo;
            List caltableListAppcheArr;
            Object onHoldInfoObj = onholdInfo.getValue();
            String personId = (String)onholdInfo.getKey();
            if (selectedPersonIdList.indexOf(personId) < 0 || !(onHoldInfoObj instanceof LinkedHashMap) || (caltableListAppcheArr = (List)(personJsonInfo = (LinkedHashMap)onHoldInfoObj).get("caltableList")) == null) continue;
            for (LinkedHashMap caltableOnholdInfoMap : caltableListAppcheArr) {
                Long salaryFileId = Long.valueOf((String)caltableOnholdInfoMap.get("salaryfile"));
                salaryFileIdList.add(salaryFileId);
            }
        }
        return salaryFileIdList;
    }

    private Map<String, Object> validateCalPerson(JSONObject onHoldInfoCacheJSONObject, List<Long> calPersonIdList, List<Map<String, Object>> resultList, List<String> selectedPersonIdList, List<Long> onHoldToUpdateIdList, boolean isSave) {
        log.info("starting validate caltask");
        long startTime = System.currentTimeMillis();
        Map<String, DynamicObject> payedCalPersonMap = OnHoldBillHelper.queryPayedCalPersonMap(calPersonIdList);
        Map<String, DynamicObject> onHoldCaltableMap = OnHoldBillHelper.queryOnHoldedCalPersonMap(calPersonIdList);
        Set<String> calIds = OnHoldBillHelper.validateSalaryFilePayDetail(calPersonIdList);
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        Integer failCount = 0;
        Integer totalCount = 0;
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        PayStateService payStateService = new PayStateService();
        for (Map.Entry onholdInfo : onHoldInfoCacheJSONObject.entrySet()) {
            JSONObject personJsonInfo;
            JSONArray calPersonListAppCacheArr;
            Object onHoldInfoObj = onholdInfo.getValue();
            String personId = (String)onholdInfo.getKey();
            if (selectedPersonIdList.indexOf(personId) < 0 || !(onHoldInfoObj instanceof JSONObject) || (calPersonListAppCacheArr = (personJsonInfo = (JSONObject)onHoldInfoObj).getJSONArray("caltableList")) == null) continue;
            for (int index = 0; index < calPersonListAppCacheArr.size(); ++index) {
                Integer n;
                JSONObject calPersonOnholdInfoMap = calPersonListAppCacheArr.getJSONObject(index);
                Boolean onHoldStatus = (Boolean)calPersonOnholdInfoMap.get((Object)"caltableonholdstatus");
                Integer caltableStatus = Integer.valueOf((String)calPersonOnholdInfoMap.get((Object)"caltableStatus"));
                if (!onHoldStatus.booleanValue() || caltableStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
                Integer n2 = totalCount;
                Integer n3 = totalCount = Integer.valueOf(totalCount + 1);
                boolean isOnHold = this.validateCaltableOnHoldStatus(onHoldInfoCacheJSONObject, calPersonOnholdInfoMap, errorMsgSet, onHoldCaltableMap, onHoldToUpdateIdList, isSave);
                if (isOnHold) {
                    n3 = failCount;
                    Integer n4 = failCount = Integer.valueOf(failCount + 1);
                    if (isSave) {
                        this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1009.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1009.getCode()));
                        continue;
                    }
                    this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1010.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1010.getCode()));
                    continue;
                }
                boolean isPayed = this.validateCalPersonPayStatus(calPersonOnholdInfoMap, errorMsgSet, payedCalPersonMap, isSave, payStateService, onHoldToUpdateIdList, onHoldCaltableMap);
                if (isPayed) {
                    Integer n5 = failCount;
                    n = failCount = Integer.valueOf(failCount + 1);
                    if (isSave) {
                        this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1011.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1011.getCode()));
                        continue;
                    }
                    this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1012.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1012.getCode()));
                    continue;
                }
                boolean isPayDetailBankOffer = this.validatePayDetailBankOfferStatus(calPersonOnholdInfoMap, errorMsgSet, calIds, onHoldToUpdateIdList, onHoldCaltableMap);
                if (!isPayDetailBankOffer) continue;
                n = failCount;
                Integer n6 = failCount = Integer.valueOf(failCount + 1);
                if (isSave) {
                    this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1013.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1013.getCode()));
                    continue;
                }
                this.buildErrorMsg(resultList, calPersonOnholdInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1014.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1014.getCode()));
            }
        }
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalCount", totalCount);
        long endTime = System.currentTimeMillis();
        log.info("[finish saving] caltask validating end total time:{}(ms)", (Object)(endTime - startTime));
        return validateResultMap;
    }

    private boolean validateCaltableOnHoldStatus(JSONObject onholdInfoAppcheJSONObject, JSONObject caltableOnholdInfoMap, Set<String> errorMsgSet, Map<String, DynamicObject> onHoldCaltableMap, List<Long> onHoldToUpdateIdList, boolean isSave) {
        String caltableId = (String)caltableOnholdInfoMap.get((Object)"caltable");
        DynamicObject onHoldCaltableObj = onHoldCaltableMap.get(caltableId);
        JSONArray toDeleOnHoldIdAppcheArr = onholdInfoAppcheJSONObject.getJSONArray("delOnholdIdList");
        if (onHoldCaltableObj != null) {
            String onHoldId;
            int onHoldStatus = onHoldCaltableObj.getInt("status");
            String pageOnHoldId = (String)caltableOnholdInfoMap.get((Object)"caltableOnHoldId");
            if (SWCStringUtils.equals((String)pageOnHoldId, (String)(onHoldId = onHoldCaltableObj.getString("id"))) && (OnHoldStatusEnum.STATUS_SAVE.getCode() == onHoldStatus || OnHoldStatusEnum.STATUS_RELEASE.getCode() == onHoldStatus)) {
                return false;
            }
            if (toDeleOnHoldIdAppcheArr != null && toDeleOnHoldIdAppcheArr.indexOf((Object)onHoldId) >= 0) {
                return false;
            }
            Date startDate = onHoldCaltableObj.getDate("startdate");
            Date endDate = onHoldCaltableObj.getDate("enddate");
            caltableOnholdInfoMap.put("caltableIsPass", (Object)Boolean.TRUE);
            String personName = (String)caltableOnholdInfoMap.get((Object)"caltablePersonName");
            String personNo = (String)caltableOnholdInfoMap.get((Object)"caltablePersonNo");
            String caltaskNumber = (String)caltableOnholdInfoMap.get((Object)"caltableCaltaskNumber");
            String errorContent = "";
            if (!(OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_RELEASE.getCode() != onHoldStatus || isSave)) {
                caltableOnholdInfoMap.put("caltableOnHoldId", (Object)onHoldId);
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                return false;
            }
            errorContent = OnHoldDetailHelper.getCalSalaryFileErrorMsg(isSave, false, onHoldStatus);
            String errorMsg = MessageFormat.format(errorContent, personName, personNo, caltaskNumber, SWCDateTimeUtils.format((Date)startDate, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)endDate, (String)"yyyy/MM/dd"), OnHoldStatusEnum.getDesc((Integer)onHoldStatus));
            errorMsgSet.add(errorMsg);
            return true;
        }
        return false;
    }

    private boolean validateCalPersonPayStatus(JSONObject caltableOnholdInfoMap, Set<String> errorMsgSet, Map<String, DynamicObject> payedCalPersonMap, boolean isSave, PayStateService payStateService, List<Long> onHoldToUpdateIdList, Map<String, DynamicObject> onHoldCaltableMap) {
        String caltableId = (String)caltableOnholdInfoMap.get((Object)"caltable");
        DynamicObject payedCalPersonObj = payedCalPersonMap.get(caltableId);
        if (payedCalPersonObj != null) {
            String personName = (String)caltableOnholdInfoMap.get((Object)"caltablePersonName");
            String personNo = (String)caltableOnholdInfoMap.get((Object)"caltablePersonNo");
            String salaryfileNumber = (String)caltableOnholdInfoMap.get((Object)"caltableSalaryfileNumber");
            String caltaskNumber = (String)caltableOnholdInfoMap.get((Object)"caltableCaltaskNumber");
            String payStatus = payedCalPersonObj.getString("paystatus");
            caltableOnholdInfoMap.put("caltableIsPass", (Object)Boolean.TRUE);
            DynamicObject onHoldCaltableObj = onHoldCaltableMap.get(caltableId);
            if (onHoldCaltableObj != null) {
                Long onHoldId = onHoldCaltableObj.getLong("id");
                onHoldToUpdateIdList.remove(onHoldId);
            }
            String errorMsg = "";
            errorMsg = isSave ? MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a\u201c{3}~{4}\u201d\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_0", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, caltaskNumber, payStateService.getDescByCode(payStatus)) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a\u201c{3}~{4}\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldBillService_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, caltaskNumber, payStateService.getDescByCode(payStatus));
            errorMsgSet.add(errorMsg);
            return true;
        }
        return false;
    }

    private boolean validatePayDetailBankOfferStatus(JSONObject calTableOnHoldInfoMap, Set<String> errorMsgSet, Set<String> calIds, List<Long> onHoldToUpdateIdList, Map<String, DynamicObject> onHoldCaltableMap) {
        String calTableId = (String)calTableOnHoldInfoMap.get((Object)"caltable");
        if (calIds.contains(calTableId)) {
            String personName = (String)calTableOnHoldInfoMap.get((Object)"caltablePersonName");
            String personNo = (String)calTableOnHoldInfoMap.get((Object)"caltablePersonNo");
            String salaryFileNumber = (String)calTableOnHoldInfoMap.get((Object)"caltableSalaryfileNumber");
            String calTaskNumber = (String)calTableOnHoldInfoMap.get((Object)"caltableCaltaskNumber");
            String errorMsg = "";
            errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f16\u53f7\uff08{2}\uff09\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff08{3}\uff09\u4e2d\u7684\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u7684\u53d1\u653e\u660e\u7ec6\u5df2\u5bfc\u51fa\u62a5\u76d8\uff0c\u8bf7\u786e\u8ba4\u62a5\u76d8\u6587\u4ef6\u4e2d\u660e\u7ec6\u5747\u672a\u4ed8\u6b3e\u5e76\u5df2\u5931\u6548\uff0c\u907f\u514d\u91cd\u590d\u652f\u4ed8\u3002", (String)"OnHoldBillService_29", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryFileNumber, calTaskNumber);
            errorMsgSet.add(errorMsg);
            DynamicObject onHoldCaltableObj = onHoldCaltableMap.get(calTableId);
            if (onHoldCaltableObj != null) {
                Long onHoldId = onHoldCaltableObj.getLong("id");
                onHoldToUpdateIdList.remove(onHoldId);
            }
            calTableOnHoldInfoMap.put("caltableIsPass", (Object)Boolean.TRUE);
            return true;
        }
        return false;
    }

    private Map<String, Object> validateSalary(JSONObject onHoldInfoCacheJSONObject, List<Long> salaryFileIdList, List<Map<String, Object>> resultList, List<String> selectedPersonIdList, List<Long> onHoldToUpdateIdList, boolean isSave) {
        log.info("starting validating salary file");
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> validateResultMap = new HashMap<String, Object>(16);
        Integer failCount = 0;
        Integer totalCount = 0;
        HashSet<String> errorMsgSet = new HashSet<String>(16);
        Map<String, List<DynamicObject>> onHoldSalaryMap = OnHoldBillHelper.queryOnHoldedSalaryMap(salaryFileIdList);
        for (Map.Entry onHoldInfo : onHoldInfoCacheJSONObject.entrySet()) {
            Object onHoldInfoObj = onHoldInfo.getValue();
            String personId = (String)onHoldInfo.getKey();
            if (selectedPersonIdList.indexOf(personId) < 0 || !(onHoldInfoObj instanceof JSONObject)) continue;
            JSONObject personJsonInfo = (JSONObject)onHoldInfoObj;
            JSONArray salaryListAppcheArr = personJsonInfo.getJSONArray("salaryfileList");
            JSONArray calTableListAppcheArr = personJsonInfo.getJSONArray("caltableIdList");
            if (!(salaryListAppcheArr != null && salaryListAppcheArr.size() != 0 || calTableListAppcheArr != null && calTableListAppcheArr.size() != 0)) {
                Integer n = totalCount;
                Integer n2 = totalCount = Integer.valueOf(totalCount + 1);
                n = failCount;
                n2 = failCount = Integer.valueOf(failCount + 1);
                String errorContent = "";
                errorContent = isSave ? ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u6216\u6838\u7b97\u4efb\u52a1\u4efb\u610f\u5206\u5f55\u6700\u5c11\u9700\u586b\u5199\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u586b\u5199\u540e\u518d\u4fdd\u5b58\u3002", (String)"OnHoldBillService_38", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u6216\u6838\u7b97\u4efb\u52a1\u4efb\u610f\u5206\u5f55\u6700\u5c11\u9700\u586b\u5199\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u586b\u5199\u540e\u518d\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_39", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                String personName = (String)personJsonInfo.get((Object)"personName");
                String personNo = (String)personJsonInfo.get((Object)"personNo");
                errorContent = MessageFormat.format(errorContent, personName, personNo);
                errorMsgSet.add(errorContent);
                continue;
            }
            if (salaryListAppcheArr == null || salaryListAppcheArr.isEmpty()) continue;
            int index = 0;
            for (int flag = 0; flag < salaryListAppcheArr.size(); ++flag) {
                Object errorMsg;
                Object salaryNumber;
                JSONObject salaryOnoldInfoMap = salaryListAppcheArr.getJSONObject(flag);
                ++index;
                Integer salaryfileStatus = Integer.valueOf((String)salaryOnoldInfoMap.get((Object)"salaryfileStatus"));
                if (salaryfileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
                Integer n = totalCount;
                Integer n3 = totalCount = Integer.valueOf(totalCount + 1);
                String salaryfileId = (String)salaryOnoldInfoMap.get((Object)"salaryfile");
                List<DynamicObject> onHoldSalaryObjList = onHoldSalaryMap.get(salaryfileId);
                boolean isOnHold = this.validateSalaryOnHoldStatus(salaryOnoldInfoMap, errorMsgSet, onHoldSalaryObjList, onHoldToUpdateIdList, isSave);
                if (isOnHold) {
                    Integer n4 = failCount;
                    Integer n5 = failCount = Integer.valueOf(failCount + 1);
                    if (isSave) {
                        this.buildErrorMsg(resultList, salaryOnoldInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1015.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1015.getCode()));
                        continue;
                    }
                    this.buildErrorMsg(resultList, salaryOnoldInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1016.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1016.getCode()));
                    continue;
                }
                boolean isNull = this.validateSalaryDateIsNull(salaryOnoldInfoMap, errorMsgSet, index, onHoldToUpdateIdList, isSave);
                if (isNull) {
                    Integer n6 = failCount;
                    Integer n7 = failCount = Integer.valueOf(failCount + 1);
                    continue;
                }
                boolean isEarly = this.validateSalaryStartDateEarlyReleaseDate(salaryOnoldInfoMap, errorMsgSet, index, onHoldToUpdateIdList, isSave);
                if (isEarly) {
                    Integer n8 = failCount;
                    Integer n9 = failCount = Integer.valueOf(failCount + 1);
                    String errorMsgDesc = OnHoldFailStatusEnum.FAILSTATUS_1008.getDesc();
                    salaryNumber = salaryOnoldInfoMap.getString("salaryNumber");
                    errorMsg = MessageFormat.format(errorMsgDesc, salaryNumber);
                    this.buildErrorMsg(resultList, salaryOnoldInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1008.getCode(), (String)errorMsg);
                    continue;
                }
                boolean isOver = this.validateSalaryDateIsOver(salaryOnoldInfoMap, errorMsgSet, onHoldToUpdateIdList);
                if (!isOver) continue;
                salaryNumber = failCount;
                failCount = failCount + 1;
                errorMsg = failCount;
                String errorMsgDesc = OnHoldFailStatusEnum.FAILSTATUS_1017.getDesc();
                String salaryFirstBred = salaryOnoldInfoMap.getString("salaryFirstBred");
                String salaryBrled = salaryOnoldInfoMap.getString("salaryBrled");
                String salaryNumber2 = salaryOnoldInfoMap.getString("salaryNumber");
                Date cacheSalaryBred = null;
                Date cacheSalaryBrled = null;
                String cacheSalaryBredStr = (String)salaryOnoldInfoMap.get((Object)"salaryFirstBred");
                String cacheSalaryBrledStr = (String)salaryOnoldInfoMap.get((Object)"salaryBrled");
                try {
                    cacheSalaryBred = SWCDateTimeUtils.parseDate((String)cacheSalaryBredStr);
                    cacheSalaryBrled = SWCDateTimeUtils.parseDate((String)cacheSalaryBrledStr);
                    salaryFirstBred = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"firstbsed", (Date)cacheSalaryBred);
                    salaryBrled = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsled", (Date)cacheSalaryBrled);
                }
                catch (ParseException e) {
                    log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
                }
                String errorMsg2 = MessageFormat.format(errorMsgDesc, salaryNumber2, salaryFirstBred, salaryBrled);
                this.buildErrorMsg(resultList, salaryOnoldInfoMap, OnHoldFailStatusEnum.FAILSTATUS_1017.getCode(), errorMsg2);
            }
        }
        validateResultMap.put("errorMsgSet", errorMsgSet);
        validateResultMap.put("failCount", failCount);
        validateResultMap.put("totalCount", totalCount);
        long endTime = System.currentTimeMillis();
        log.info("[finish saving] validating salary file end total time:{}(ms)", (Object)(endTime - startTime));
        return validateResultMap;
    }

    private boolean validateSalaryStartDateEarlyReleaseDate(JSONObject salaryOnoldInfoMap, Set<String> errorMsgSet, int index, List<Long> onHoldToUpdateIdList, boolean isSave) {
        boolean isEarly = false;
        String startDateStr = (String)salaryOnoldInfoMap.get((Object)"salaryonholdstartdate");
        String releaseDateStr = (String)salaryOnoldInfoMap.get((Object)"salaryreleasedate");
        if (SWCStringUtils.isEmpty((String)startDateStr) || SWCStringUtils.isEmpty((String)releaseDateStr)) {
            return false;
        }
        Date releaseDate = null;
        Date startDate = null;
        try {
            releaseDate = SWCDateTimeUtils.parseDate((String)releaseDateStr);
            startDate = SWCDateTimeUtils.parseDate((String)startDateStr);
        }
        catch (ParseException e) {
            log.info("releaseDateStr and startDateStr parser error!");
            return isEarly;
        }
        if (releaseDate.getTime() <= startDate.getTime()) {
            String salaryNumber = (String)salaryOnoldInfoMap.get((Object)"salaryNumber");
            String personName = (String)salaryOnoldInfoMap.get((Object)"salaryPersonName");
            String personNo = (String)salaryOnoldInfoMap.get((Object)"salaryPersonNo");
            String errorMsgNew = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u5e94\u665a\u4e8e\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u586b\u5199\u6709\u6548\u7684\u8ba1\u5212\u89e3\u85aa\u65e5\u671f\u3002", (String)"OnHoldBillService_32", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber);
            errorMsgSet.add(errorMsgNew);
            String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
            if (SWCStringUtils.isNotEmpty((String)pageOnHoldId)) {
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
            }
            salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
            isEarly = true;
        }
        return isEarly;
    }

    private boolean validateSalaryDateIsNull(JSONObject salaryOnoldInfoMap, Set<String> errorMsgSet, int index, List<Long> onHoldToUpdateIdList, boolean isSave) {
        boolean isNull = false;
        String startDateStr = (String)salaryOnoldInfoMap.get((Object)"salaryonholdstartdate");
        String isAllowCal = (String)salaryOnoldInfoMap.get((Object)"salaryisallowcal");
        String errorMsg = "";
        String salaryNumber = (String)salaryOnoldInfoMap.get((Object)"salaryNumber");
        String personName = (String)salaryOnoldInfoMap.get((Object)"salaryPersonName");
        String personNo = (String)salaryOnoldInfoMap.get((Object)"salaryPersonNo");
        if (SWCStringUtils.isEmpty((String)startDateStr)) {
            if (SWCStringUtils.isEmpty((String)isAllowCal)) {
                errorMsg = isSave ? MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u548c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_34", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u548c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_35", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index);
                errorMsgSet.add(errorMsg);
                String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
                if (SWCStringUtils.isNotEmpty((String)pageOnHoldId)) {
                    onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                }
                salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
                isNull = true;
            } else {
                errorMsg = isSave ? MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_30", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u505c\u7f13\u53d1\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_31", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index);
                errorMsgSet.add(errorMsg);
                String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
                if (SWCStringUtils.isNotEmpty((String)pageOnHoldId)) {
                    onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
                }
                salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
                isNull = true;
            }
        } else if (SWCStringUtils.isEmpty((String)isAllowCal)) {
            errorMsg = isSave ? MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_36", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index) : MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u7b2c{3}\u884c\u662f\u5426\u5141\u8bb8\u8ba1\u7b97\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5e76\u751f\u6548\u3002", (String)"OnHoldBillService_37", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryNumber, index);
            errorMsgSet.add(errorMsg);
            String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
            if (SWCStringUtils.isNotEmpty((String)pageOnHoldId)) {
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
            }
            salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
            isNull = true;
        }
        return isNull;
    }

    private boolean validateSalaryDateIsOver(JSONObject salaryOnoldInfoMap, Set<String> errorMsgSet, List<Long> onHoldToUpdateIdList) {
        boolean isOver = false;
        String cacheStartDateStr = (String)salaryOnoldInfoMap.get((Object)"salaryonholdstartdate");
        if (SWCStringUtils.isEmpty((String)cacheStartDateStr)) {
            return isOver;
        }
        Date cacheStartDate = null;
        Date cacheSalaryBred = null;
        Date cacheSalaryBrled = null;
        String cacheSalaryBredStr = (String)salaryOnoldInfoMap.get((Object)"salaryFirstBred");
        String cacheSalaryBrledStr = (String)salaryOnoldInfoMap.get((Object)"salaryBrled");
        try {
            cacheStartDate = SWCDateTimeUtils.parseDate((String)cacheStartDateStr);
            cacheSalaryBred = SWCDateTimeUtils.parseDate((String)cacheSalaryBredStr);
            cacheSalaryBrled = SWCDateTimeUtils.parseDate((String)cacheSalaryBrledStr);
        }
        catch (ParseException e) {
            log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
        }
        if (cacheStartDate == null || cacheSalaryBrled == null || cacheSalaryBred == null) {
            return isOver;
        }
        if (cacheStartDate.after(cacheSalaryBrled) || cacheStartDate.before(cacheSalaryBred)) {
            isOver = true;
            String personName = (String)salaryOnoldInfoMap.get((Object)"salaryPersonName");
            String personNo = (String)salaryOnoldInfoMap.get((Object)"salaryPersonNo");
            String salaryfileNumber = (String)salaryOnoldInfoMap.get((Object)"salaryNumber");
            String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
            if (SWCStringUtils.isNotEmpty((String)pageOnHoldId)) {
                onHoldToUpdateIdList.remove(Long.valueOf(pageOnHoldId));
            }
            salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
            errorMsgSet.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u6863\u6848\u7f16\u53f7\u201c{2}\u201d\u6709\u6548\u671f\u4e3a\u201c{3}~{4}\u201d\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u533a\u95f4\u8fdb\u884c\u505c\u7f13\u53d1\u3002", (String)"OnHoldBillService_9", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryfileNumber, SWCDateTimeUtils.format((Date)cacheSalaryBred, (String)"yyyy/MM/dd"), SWCDateTimeUtils.format((Date)cacheSalaryBrled, (String)"yyyy/MM/dd")));
        }
        return isOver;
    }

    private boolean validateSalaryOnHoldStatus(JSONObject salaryOnoldInfoMap, Set<String> errorMsgSet, List<DynamicObject> onHoldSalaryObjList, List<Long> onHoldToUpdateIdList, boolean isSave) {
        int onHoldStatus;
        boolean isOnHold = false;
        if (onHoldSalaryObjList == null || onHoldSalaryObjList.isEmpty()) {
            return isOnHold;
        }
        Boolean salaryIsPass = (Boolean)salaryOnoldInfoMap.get((Object)"salaryIsPass");
        String pageOnHoldId = (String)salaryOnoldInfoMap.get((Object)"salaryfileOnHoldId");
        boolean isUpdate = false;
        for (DynamicObject dynamicObject : onHoldSalaryObjList) {
            String onHoldId;
            String isAllowCal = dynamicObject.getString("isallowcal");
            if (SWCStringUtils.isEmpty((String)isAllowCal) || !SWCStringUtils.equals((String)pageOnHoldId, (String)(onHoldId = dynamicObject.getString("id"))) && !salaryIsPass.booleanValue()) continue;
            onHoldStatus = dynamicObject.getInt("status");
            if (OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_RELEASE.getCode() != onHoldStatus) continue;
            onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
            isUpdate = true;
        }
        if (isUpdate) {
            return isOnHold;
        }
        boolean isExit = false;
        for (DynamicObject onHoldSalaryObj : onHoldSalaryObjList) {
            Date startDate = onHoldSalaryObj.getDate("startdate");
            if (startDate == null) continue;
            onHoldStatus = onHoldSalaryObj.getInt("status");
            if (OnHoldStatusEnum.STATUS_SAVE.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_ONHOLD.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_STOPPAY.getCode() != onHoldStatus && OnHoldStatusEnum.STATUS_TOPAY.getCode() != onHoldStatus) continue;
            isExit = true;
            break;
        }
        if (isExit) {
            String string = (String)salaryOnoldInfoMap.get((Object)"salaryNumber");
            String personName = (String)salaryOnoldInfoMap.get((Object)"salaryPersonName");
            String personNo = (String)salaryOnoldInfoMap.get((Object)"salaryPersonNo");
            String errorContent = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\uff08{2}\uff09\u5df2\u68c0\u6d4b\u5b58\u5728\u672a\u89e3\u85aa\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u505c\u7f13\u53d1\u6570\u636e\uff0c\u8bf7\u5728\u539f\u6570\u636e\u4e0a\u505a\u64cd\u4f5c\u3002", (String)"OnHoldBillService_33", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
            errorContent = MessageFormat.format(errorContent, personName, personNo, string);
            isOnHold = true;
            salaryOnoldInfoMap.put("salaryIsPass", (Object)Boolean.TRUE);
            errorMsgSet.add(errorContent);
        }
        return isOnHold;
    }

    private Integer validateSalaryDate(List<LinkedHashMap> salaryListAppcheArr, Set<String> errorMsgSet, boolean isSave) {
        HashSet<String> salaryIndexSet = new HashSet<String>(salaryListAppcheArr.size());
        for (int i = 0; i < salaryListAppcheArr.size(); ++i) {
            LinkedHashMap salaryOnholdInfoMap = salaryListAppcheArr.get(i);
            String personName = (String)salaryOnholdInfoMap.get("salaryPersonName");
            String salaryIndex = String.valueOf(salaryOnholdInfoMap.get("salaryIndex"));
            String salaryfileNumber = (String)salaryOnholdInfoMap.get("salaryNumber");
            String personNo = (String)salaryOnholdInfoMap.get("salaryPersonNo");
            String cacheStartDateStr = (String)salaryOnholdInfoMap.get("salaryonholdrange_startdate");
            Boolean onholdStatus = (Boolean)salaryOnholdInfoMap.get("salaryonholdstatus");
            Integer salaryfileStatus = Integer.valueOf((String)salaryOnholdInfoMap.get("salaryfileStatus"));
            if (!onholdStatus.booleanValue() || SWCStringUtils.isEmpty((String)cacheStartDateStr) || salaryfileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            Date cacheStartDate = null;
            Date cacheEndDate = null;
            String cacheEndDateStr = (String)salaryOnholdInfoMap.get("salaryonholdrange_enddate");
            try {
                cacheStartDate = SWCDateTimeUtils.parseDate((String)cacheStartDateStr);
                cacheEndDate = SWCDateTimeUtils.parseDate((String)cacheEndDateStr);
            }
            catch (ParseException e) {
                log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
            }
            for (int j = i + 1; j < salaryListAppcheArr.size(); ++j) {
                LinkedHashMap salaryOnholdInfo = salaryListAppcheArr.get(j);
                String startDateStr = (String)salaryOnholdInfo.get("salaryonholdrange_startdate");
                Boolean status = (Boolean)salaryOnholdInfo.get("salaryonholdstatus");
                String salaryNumber = (String)salaryOnholdInfo.get("salaryNumber");
                if (!status.booleanValue() || SWCStringUtils.isEmpty((String)startDateStr) || !salaryfileNumber.equals(salaryNumber)) continue;
                Date startDate = null;
                Date endDate = null;
                String endDateStr = (String)salaryOnholdInfo.get("salaryonholdrange_enddate");
                try {
                    startDate = SWCDateTimeUtils.parseDate((String)startDateStr);
                    endDate = SWCDateTimeUtils.parseDate((String)endDateStr);
                }
                catch (ParseException e) {
                    log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
                }
                if (cacheStartDate == null || endDate == null || cacheEndDate == null || startDate == null || endDate.before(cacheStartDate) || startDate.after(cacheEndDate)) continue;
                StringBuilder errorBuilder = new StringBuilder();
                String index = String.valueOf(salaryOnholdInfo.get("salaryIndex"));
                if (isSave) {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7b2c{2}\u548c\u7b2c{3}\u884c\u505c\u7f13\u53d1\u533a\u95f4\u91cd\u53e0\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"OnHoldBillService_8", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryIndex, index));
                } else {
                    errorBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7b2c{2}\u548c\u7b2c{3}\u884c\u505c\u7f13\u53d1\u533a\u95f4\u91cd\u53e0\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OnHoldBillService_12", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]), personName, personNo, salaryIndex, index));
                }
                errorMsgSet.add(errorBuilder.toString());
                salaryOnholdInfoMap.put("salaryIsPass", Boolean.TRUE);
                salaryOnholdInfo.put("salaryIsPass", Boolean.TRUE);
                salaryIndexSet.add(salaryIndex);
                salaryIndexSet.add(index);
            }
        }
        return salaryIndexSet.size();
    }

    private DynamicObjectCollection saveSalaryOnHoldInfo(JSONObject personJsonInfo, List<Long> onHoldToUpdateIdList, Map<String, String> onHoldIdRefIdMap) {
        DynamicObjectCollection onholdColl = new DynamicObjectCollection();
        JSONArray salaryListAppcheArr = personJsonInfo.getJSONArray("salaryfileList");
        if (salaryListAppcheArr == null || salaryListAppcheArr.isEmpty()) {
            return onholdColl;
        }
        Long userId = RequestContext.get().getCurrUserId();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_onholdbill");
        for (Object obj : salaryListAppcheArr) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject salaryOnholdInfoMap = (JSONObject)obj;
            Boolean isPass = (Boolean)salaryOnholdInfoMap.get((Object)"salaryIsPass");
            String onHoldId = (String)salaryOnholdInfoMap.get((Object)"salaryfileOnHoldId");
            String startDate = (String)salaryOnholdInfoMap.get((Object)"salaryonholdstartdate");
            Integer salaryfileStatus = Integer.valueOf((String)salaryOnholdInfoMap.get((Object)"salaryfileStatus"));
            if (startDate == null || salaryfileStatus > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            if (isPass.booleanValue()) {
                salaryOnholdInfoMap.put("salaryIsPass", (Object)Boolean.FALSE);
                continue;
            }
            if (onHoldId != null && onHoldIdRefIdMap.get(onHoldId) != null) {
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            DynamicObject onholdBill = (DynamicObject)type.createInstance();
            onholdBill.set("createtime", (Object)new Date());
            onholdBill.set("creator", (Object)userId);
            onholdBill.set("billstatus", (Object)"C");
            onholdBill.set("status", (Object)OnHoldStatusEnum.STATUS_SAVE.getCode());
            for (Map.Entry salaryOnholdEntry : salaryOnholdInfoMap.entrySet()) {
                String entryKey = (String)salaryOnholdEntry.getKey();
                if (entryKey.startsWith("salary") || SWCStringUtils.equals((String)entryKey, (String)"operate") || SWCStringUtils.equals((String)entryKey, (String)"onholduniquecode")) continue;
                onholdBill.set((String)salaryOnholdEntry.getKey(), salaryOnholdEntry.getValue());
            }
            String releaseTime = (String)salaryOnholdInfoMap.get((Object)"salaryreleasedate");
            try {
                onholdBill.set("startdate", (Object)(startDate == null ? null : SWCDateTimeUtils.parseDate((String)startDate)));
                onholdBill.set("releasedate", (Object)(releaseTime == null ? null : SWCDateTimeUtils.parseDate((String)releaseTime)));
            }
            catch (Exception e) {
                log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
            }
            onholdBill.set("salaryfile", salaryOnholdInfoMap.get((Object)"salaryfile"));
            onholdBill.set("cause", salaryOnholdInfoMap.get((Object)"salaryonholdreason"));
            onholdBill.set("attachment", (Object)this.getAttachmentColl(personJsonInfo));
            onholdBill.set("remark", personJsonInfo.get((Object)"remark"));
            onholdBill.set("msgstatus", (Object)OPSTATUS_FAIL);
            onholdBill.set("isallowcal", salaryOnholdInfoMap.get((Object)"salaryisallowcal"));
            onholdColl.add((Object)onholdBill);
        }
        return onholdColl;
    }

    private DynamicObjectCollection getAttachmentColl(JSONObject personJsonInfo) {
        Object attachmentByteObj = personJsonInfo.get((Object)"attachmentCollection");
        if (attachmentByteObj == null) {
            return null;
        }
        if (attachmentByteObj instanceof String) {
            String attachmentByteStr = (String)attachmentByteObj;
            byte[] decoded = Base64.getDecoder().decode(attachmentByteStr);
            DynamicObjectCollection objColl = new DynamicObjectCollection();
            objColl = (DynamicObjectCollection)OnHoldBillHelper.deserialize(decoded);
            return objColl;
        }
        return null;
    }

    private DynamicObjectCollection saveCalPersonOnHoldInfo(JSONObject personJsonInfo, List<Long> onHoldToDeleteIdList, List<Long> onHoldToUpdateIdList, Map<String, String> onHoldIdRefIdMap) {
        DynamicObjectCollection onHoldColl = new DynamicObjectCollection();
        JSONArray calPersonListCacheArr = personJsonInfo.getJSONArray("caltableList");
        if (calPersonListCacheArr == null || calPersonListCacheArr.isEmpty()) {
            return onHoldColl;
        }
        Long userId = RequestContext.get().getCurrUserId();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_onholdbill");
        for (Object obj : calPersonListCacheArr) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject caltableOnholdInfoMap = (JSONObject)obj;
            Boolean onholdStatus = (Boolean)caltableOnholdInfoMap.get((Object)"caltableonholdstatus");
            Boolean isPass = (Boolean)caltableOnholdInfoMap.get((Object)"caltableIsPass");
            String onHoldId = (String)caltableOnholdInfoMap.get((Object)"caltableOnHoldId");
            String caltableStatus = (String)caltableOnholdInfoMap.get((Object)"caltableStatus");
            Integer caltableStatusInt = Integer.valueOf(caltableStatus);
            if (!onholdStatus.booleanValue()) {
                if (onHoldId == null || onHoldIdRefIdMap.get(onHoldId) == null) continue;
                onHoldToDeleteIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            if (caltableStatusInt > OnHoldStatusEnum.STATUS_RELEASE.getCode()) continue;
            if (isPass.booleanValue()) {
                caltableOnholdInfoMap.put("caltableIsPass", (Object)Boolean.FALSE);
                continue;
            }
            if (onHoldId != null && onHoldIdRefIdMap.get(onHoldId) != null) {
                onHoldToUpdateIdList.add(Long.valueOf(onHoldId));
                continue;
            }
            DynamicObject onholdBill = (DynamicObject)type.createInstance();
            onholdBill.set("createtime", (Object)new Date());
            onholdBill.set("creator", (Object)userId);
            onholdBill.set("modifier", (Object)userId);
            onholdBill.set("modifytime", (Object)new Date());
            onholdBill.set("billstatus", (Object)"C");
            onholdBill.set("status", (Object)OnHoldStatusEnum.STATUS_SAVE.getCode());
            for (Map.Entry salaryOnHoldEntry : caltableOnholdInfoMap.entrySet()) {
                String entryKey = (String)salaryOnHoldEntry.getKey();
                if (entryKey.startsWith("caltable") || SWCStringUtils.equals((String)entryKey, (String)"operate") || SWCStringUtils.equals((String)entryKey, (String)"onholduniquecode")) continue;
                onholdBill.set((String)salaryOnHoldEntry.getKey(), salaryOnHoldEntry.getValue());
            }
            onholdBill.set("caltableid", caltableOnholdInfoMap.get((Object)"caltable"));
            onholdBill.set("calamount", caltableOnholdInfoMap.get((Object)"caltablecalamount"));
            onholdBill.set("calcurrency", caltableOnholdInfoMap.get((Object)"caltablecalcurrency"));
            onholdBill.set("msgstatus", (Object)OPSTATUS_FAIL);
            onholdBill.set("cause", caltableOnholdInfoMap.get((Object)"caltableonholdreason"));
            String startDate = (String)caltableOnholdInfoMap.get((Object)"caltableStartdate");
            String endDate = (String)caltableOnholdInfoMap.get((Object)"caltableEnddate");
            String releaseTime = (String)personJsonInfo.get((Object)"releasedate");
            try {
                onholdBill.set("startdate", (Object)(SWCStringUtils.isEmpty((String)startDate) ? null : SWCDateTimeUtils.parseDate((String)startDate)));
                onholdBill.set("enddate", (Object)(SWCStringUtils.isEmpty((String)endDate) ? null : SWCDateTimeUtils.parseDate((String)endDate)));
                onholdBill.set("releasedate", (Object)(SWCStringUtils.isEmpty((String)releaseTime) ? null : SWCDateTimeUtils.parseDate((String)releaseTime)));
            }
            catch (Exception e) {
                log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
            }
            onholdBill.set("attachment", (Object)this.getAttachmentColl(personJsonInfo));
            onholdBill.set("remark", personJsonInfo.get((Object)"remark"));
            onHoldColl.add((Object)onholdBill);
        }
        return onHoldColl;
    }

    private DynamicObjectCollection updateCaltableOnHoldInfo(JSONObject personJsonInfo, Map<String, DynamicObject> onHoldIdRefObjMap) {
        DynamicObjectCollection onHoldToUpdateObjColl = new DynamicObjectCollection();
        JSONArray caltableListAppcheArr = personJsonInfo.getJSONArray("caltableList");
        if (caltableListAppcheArr == null || caltableListAppcheArr.isEmpty()) {
            return onHoldToUpdateObjColl;
        }
        Long userId = RequestContext.get().getCurrUserId();
        for (Object obj : caltableListAppcheArr) {
            DynamicObject onHoldObj;
            if (!(obj instanceof JSONObject)) continue;
            JSONObject caltableOnholdInfoMap = (JSONObject)obj;
            Boolean onHoldStatus = (Boolean)caltableOnholdInfoMap.get((Object)"caltableonholdstatus");
            Boolean isPass = (Boolean)caltableOnholdInfoMap.get((Object)"caltableIsPass");
            String onHoldId = (String)caltableOnholdInfoMap.get((Object)"caltableOnHoldId");
            String caltableStatus = (String)caltableOnholdInfoMap.get((Object)"caltableStatus");
            int caltableStatusInt = Integer.parseInt(caltableStatus);
            if (!onHoldStatus.booleanValue() || isPass.booleanValue() || onHoldId == null || caltableStatusInt >= OnHoldStatusEnum.STATUS_ONHOLD.getCode() || (onHoldObj = onHoldIdRefObjMap.get(onHoldId)) == null) continue;
            onHoldObj.set("modifier", (Object)userId);
            onHoldObj.set("modifytime", (Object)new Date());
            onHoldObj.set("cause", caltableOnholdInfoMap.get((Object)"caltableonholdreason"));
            onHoldObj.set("attachment", (Object)this.getAttachmentColl(personJsonInfo));
            onHoldObj.set("remark", personJsonInfo.get((Object)"remark"));
            onHoldObj.set("msgstatus", (Object)OPSTATUS_FAIL);
            String releasetime = (String)personJsonInfo.get((Object)"releasedate");
            try {
                onHoldObj.set("releasedate", (Object)(SWCStringUtils.isEmpty((String)releasetime) ? null : SWCDateTimeUtils.parseDate((String)releasetime)));
            }
            catch (ParseException e) {
                log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
            }
            onHoldToUpdateObjColl.add((Object)onHoldObj);
        }
        return onHoldToUpdateObjColl;
    }

    private DynamicObjectCollection updateSalaryOnHoldInfo(JSONObject personJsonInfo, Map<String, DynamicObject> onHoldIdRefObjMap) {
        DynamicObjectCollection onHoldToUpdateObjColl = new DynamicObjectCollection();
        JSONArray salaryListAppcheArr = personJsonInfo.getJSONArray("salaryfileList");
        if (salaryListAppcheArr == null || salaryListAppcheArr.isEmpty()) {
            return onHoldToUpdateObjColl;
        }
        Long userId = RequestContext.get().getCurrUserId();
        for (Object obj : salaryListAppcheArr) {
            DynamicObject onHoldObj;
            if (!(obj instanceof JSONObject)) continue;
            JSONObject salaryOnholdInfoMap = (JSONObject)obj;
            Boolean isPass = (Boolean)salaryOnholdInfoMap.get((Object)"salaryIsPass");
            String onHoldId = (String)salaryOnholdInfoMap.get((Object)"salaryfileOnHoldId");
            String salaryfileStatus = (String)salaryOnholdInfoMap.get((Object)"salaryfileStatus");
            int salaryfileStatusInt = Integer.parseInt(salaryfileStatus);
            if (isPass.booleanValue() || onHoldId == null || salaryfileStatusInt >= OnHoldStatusEnum.STATUS_ONHOLD.getCode() || (onHoldObj = onHoldIdRefObjMap.get(onHoldId)) == null) continue;
            onHoldObj.set("cause", salaryOnholdInfoMap.get((Object)"salaryonholdreason"));
            onHoldObj.set("attachment", (Object)this.getAttachmentColl(personJsonInfo));
            onHoldObj.set("remark", personJsonInfo.get((Object)"remark"));
            onHoldObj.set("modifier", (Object)userId);
            onHoldObj.set("modifytime", (Object)new Date());
            onHoldObj.set("msgstatus", (Object)OPSTATUS_FAIL);
            String startDate = (String)salaryOnholdInfoMap.get((Object)"salaryonholdstartdate");
            String releasetime = (String)salaryOnholdInfoMap.get((Object)"salaryreleasedate");
            try {
                onHoldObj.set("startdate", (Object)(startDate == null ? null : SWCDateTimeUtils.parseDate((String)startDate)));
                onHoldObj.set("releasedate", (Object)(releasetime == null ? null : SWCDateTimeUtils.parseDate((String)releasetime)));
            }
            catch (Exception e) {
                log.error("error occurred during changing time\uff1a{}", (Object)e.getMessage());
            }
            String isAllowCal = (String)salaryOnholdInfoMap.get((Object)"salaryisallowcal");
            if (SWCStringUtils.isNotEmpty((String)isAllowCal)) {
                onHoldObj.set("isallowcal", (Object)isAllowCal);
            }
            onHoldToUpdateObjColl.add((Object)onHoldObj);
        }
        return onHoldToUpdateObjColl;
    }

    private void buildErrorMsg(List<Map<String, Object>> resultList, JSONObject dataObj, String errorCode, String errorMsg) {
        HashMap<String, Object> resltMap = new HashMap<String, Object>(6);
        resltMap.put("status", OPSTATUS_FAIL);
        resltMap.put("errorcode", errorCode);
        resltMap.put("errormsg", errorMsg);
        resltMap.put("salaryfileid", dataObj.getLong("salaryfile"));
        resltMap.put("caltaskid", dataObj.getLong("caltask"));
        resltMap.put("operate", dataObj.getString("operate"));
        resltMap.put("onholduniquecode", dataObj.getString("onholduniquecode"));
        resultList.add(resltMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOnHold(List<Map<String, Object>> onHoldDataList, List<Map<String, Object>> resultList) {
        Long calTaskId;
        HashMap<String, Object> resltMap;
        Long calTaskId2;
        HashMap relMap = new HashMap(onHoldDataList.size());
        for (Map<String, Object> onHoldData : onHoldDataList) {
            Long calTaskId3;
            Long salaryFileId = (Long)onHoldData.get("salaryfileid");
            if (salaryFileId == null) continue;
            HashSet<Long> calTaskIdSet = (HashSet<Long>)relMap.get(salaryFileId);
            if (calTaskIdSet == null) {
                calTaskIdSet = new HashSet<Long>(16);
            }
            if ((calTaskId3 = (Long)onHoldData.get("caltaskid")) == null) {
                calTaskId3 = 0L;
            }
            calTaskIdSet.add(calTaskId3);
            relMap.put(salaryFileId, calTaskIdSet);
        }
        Set salaryFileIdSet = onHoldDataList.stream().map(map -> (Long)map.get("salaryfileid")).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        String selectProperties = "id,status,salaryfile,caltableid,modifytime,modifier,startdate,enddate,caltask.id,caltask.calrulev.id,caltask.payrollgroupv.id,releasecalamount,calcurrency";
        DynamicObject[] queryOnHoldDatas = helper.query(selectProperties, new QFilter[]{qFilter});
        ArrayList<DynamicObject> needReleaseList = new ArrayList<DynamicObject>(queryOnHoldDatas.length);
        for (DynamicObject queryOnHoldObj : queryOnHoldDatas) {
            Long salaryFileId = queryOnHoldObj.getLong("salaryfile.id");
            Set calTaskIdSet = (Set)relMap.get(salaryFileId);
            if (calTaskIdSet == null || calTaskIdSet.size() == 0 || !calTaskIdSet.contains(calTaskId2 = Long.valueOf(queryOnHoldObj.getLong("caltask.id")))) continue;
            needReleaseList.add(queryOnHoldObj);
        }
        DynamicObject[] releaseDatas = new DynamicObject[needReleaseList.size()];
        for (int index = 0; index < needReleaseList.size(); ++index) {
            releaseDatas[index] = (DynamicObject)needReleaseList.get(index);
        }
        TXHandle txHandle = TX.requiresNew();
        try {
            OnHoldBillHelper.updateOnHoldStatus(releaseDatas, OnHoldStatusEnum.STATUS_RELEASE.getCode());
        }
        catch (Exception e) {
            try {
                for (Map<String, Object> onHoldDataMap : onHoldDataList) {
                    Map<String, Object> resltMap2 = null;
                    calTaskId2 = (Long)onHoldDataMap.get("caltaskid");
                    resltMap2 = calTaskId2 == null ? this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_0.getCode(), OnHoldFailStatusEnum.FAILSTATUS_0.getDesc(), (Long)onHoldDataMap.get("salaryfileid"), null) : this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_0.getCode(), OnHoldFailStatusEnum.FAILSTATUS_0.getDesc(), (Long)onHoldDataMap.get("salaryfileid"), calTaskId2);
                    resultList.add(resltMap2);
                }
                txHandle.markRollback();
            }
            catch (Throwable throwable) {
                for (Map<String, Object> onHoldDataMap : onHoldDataList) {
                    HashMap<String, Object> resltMap3 = null;
                    Long calTaskId4 = (Long)onHoldDataMap.get("caltaskid");
                    if (calTaskId4 == null) {
                        resltMap3 = new HashMap<String, Object>(16);
                        resltMap3.put("status", OPSTATUS_SUCC);
                        resltMap3.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                        resltMap3.put("caltaskid", null);
                    } else {
                        resltMap3 = new HashMap(16);
                        resltMap3.put("status", OPSTATUS_SUCC);
                        resltMap3.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                        resltMap3.put("caltaskid", calTaskId4);
                    }
                    resultList.add(resltMap3);
                }
                txHandle.close();
                throw throwable;
            }
            for (Map<String, Object> onHoldDataMap : onHoldDataList) {
                resltMap = null;
                calTaskId = (Long)onHoldDataMap.get("caltaskid");
                if (calTaskId == null) {
                    resltMap = new HashMap(16);
                    resltMap.put("status", OPSTATUS_SUCC);
                    resltMap.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                    resltMap.put("caltaskid", null);
                } else {
                    resltMap = new HashMap(16);
                    resltMap.put("status", OPSTATUS_SUCC);
                    resltMap.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                    resltMap.put("caltaskid", calTaskId);
                }
                resultList.add(resltMap);
            }
            txHandle.close();
        }
        for (Map<String, Object> onHoldDataMap : onHoldDataList) {
            resltMap = null;
            calTaskId = (Long)onHoldDataMap.get("caltaskid");
            if (calTaskId == null) {
                resltMap = new HashMap<String, Object>(16);
                resltMap.put("status", OPSTATUS_SUCC);
                resltMap.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                resltMap.put("caltaskid", null);
            } else {
                resltMap = new HashMap(16);
                resltMap.put("status", OPSTATUS_SUCC);
                resltMap.put("salaryfileid", (Long)onHoldDataMap.get("salaryfileid"));
                resltMap.put("caltaskid", calTaskId);
            }
            resultList.add(resltMap);
        }
        txHandle.close();
    }

    private Map<String, Object> buildReleaseReturnMap(String status, String errorCode, String errorMsg, Long salaryFileId, Long calTaskId) {
        HashMap<String, Object> resltMap = new HashMap<String, Object>(16);
        resltMap.put("status", status);
        resltMap.put("errorcode", errorCode);
        resltMap.put("errormsg", errorMsg);
        resltMap.put("salaryfileid", salaryFileId);
        resltMap.put("caltaskid", calTaskId);
        return resltMap;
    }
}

