/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.onhold.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.onhold.service.OnHoldBillInterfaceService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldFailStatusEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class OnHoldInterfaceService {
    public final Log log = LogFactory.getLog(OnHoldInterfaceService.class);
    private static final int BATCHSIZE = 500;
    public static final String OPSTATUS_SUCC = "1";
    public static final String OPSTATUS_FAIL = "0";

    public Map<String, Object> addOnHoldData(Map<String, Object> params) {
        this.log.info("OnHoldInterfaceService addOnHoldData params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        List dataMapList = (List)params.get("data");
        if (CollectionUtils.isEmpty((Collection)dataMapList)) {
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, null, "data is empty");
            return responseMap;
        }
        String isSubmit = (String)params.get("issubmit");
        if (SWCStringUtils.isEmpty((String)isSubmit)) {
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, OnHoldFailStatusEnum.FAILSTATUS_1022.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1022.getCode()));
            return responseMap;
        }
        if (!SWCStringUtils.equals((String)isSubmit, (String)OPSTATUS_FAIL) && !SWCStringUtils.equals((String)isSubmit, (String)OPSTATUS_SUCC)) {
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, OnHoldFailStatusEnum.FAILSTATUS_1007.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1007.getCode()));
            return responseMap;
        }
        String failStrategy = MapUtils.getString(params, (Object)"failstrategy");
        if (SWCStringUtils.isNotEmpty((String)failStrategy)) {
            if (!SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_FAIL) && !SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC)) {
                this.buildErrorResponseMap(responseMap, Boolean.FALSE, OnHoldFailStatusEnum.FAILSTATUS_1026.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1026.getCode()));
                return responseMap;
            }
        } else {
            failStrategy = OPSTATUS_FAIL;
        }
        if (dataMapList.size() > 500) {
            String errorCode = OnHoldFailStatusEnum.FAILSTATUS_1004.getCode();
            String msg = MessageFormat.format(OnHoldFailStatusEnum.getDesc((String)errorCode), 500);
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, errorCode, msg);
            return responseMap;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataMapList.size());
        ArrayList<Map<String, Object>> dateFormateSucList = new ArrayList<Map<String, Object>>(dataMapList.size());
        this.checkDateFormate(resultList, dataMapList, dateFormateSucList);
        if (dateFormateSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> mustInputSucList = new ArrayList<Map<String, Object>>(dateFormateSucList.size());
        this.checkMustInput(resultList, dateFormateSucList, mustInputSucList);
        if (mustInputSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> salaryFileSucList = new ArrayList<Map<String, Object>>(mustInputSucList.size());
        HashMap<Long, String> salaryFileIdAndNumberRelMap = new HashMap<Long, String>(16);
        Set<Long> checkSalaryFileIdSet = mustInputSucList.stream().map(map -> (Long)map.get("salaryfileid")).collect(Collectors.toSet());
        this.checkSalaryFileExists(checkSalaryFileIdSet, resultList, salaryFileSucList, mustInputSucList, salaryFileIdAndNumberRelMap);
        if (salaryFileSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> calTaskSucList = new ArrayList<Map<String, Object>>(salaryFileSucList.size());
        HashMap<Long, String> calTaskIdAndNumberRelMap = new HashMap<Long, String>(16);
        this.checkCalTaskExists(resultList, calTaskSucList, salaryFileSucList, calTaskIdAndNumberRelMap);
        if (calTaskSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> operateSucList = new ArrayList<Map<String, Object>>(calTaskSucList.size());
        this.operateRangeCheck(resultList, operateSucList, calTaskSucList);
        if (operateSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> isAllowCalSucList = new ArrayList<Map<String, Object>>(operateSucList.size());
        this.isAllowCalRangeCheck(resultList, isAllowCalSucList, operateSucList);
        if (isAllowCalSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> onHoldReasonSucList = new ArrayList<Map<String, Object>>(isAllowCalSucList.size());
        this.onHoldReasonCheck(resultList, onHoldReasonSucList, isAllowCalSucList);
        if (onHoldReasonSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> remarkSucList = new ArrayList<Map<String, Object>>(onHoldReasonSucList.size());
        this.remarkLengthCheck(resultList, remarkSucList, onHoldReasonSucList);
        if (remarkSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> onHoldSucList = new ArrayList<Map<String, Object>>(remarkSucList.size());
        this.operateAndCalTaskCheck(resultList, onHoldSucList, remarkSucList);
        if (onHoldSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> repeatSucList = new ArrayList<Map<String, Object>>(onHoldSucList.size());
        this.repeatOnHoldData(onHoldSucList, repeatSucList);
        if (repeatSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> calPersonSucList = new ArrayList<Map<String, Object>>(repeatSucList.size());
        this.calPersonCheck(resultList, calPersonSucList, repeatSucList, salaryFileIdAndNumberRelMap, calTaskIdAndNumberRelMap);
        if (calPersonSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        int checkSucSize = calPersonSucList.size();
        List<String> onHoldUniqueCodeList = this.getOnHoldCodes("onHoldUniqueCode", checkSucSize);
        if (onHoldUniqueCodeList == null || onHoldUniqueCodeList.size() != checkSucSize) {
            this.log.info("getOnHoldCodes error!");
            return responseMap;
        }
        for (int index = 0; index < checkSucSize; ++index) {
            Map checkSucMap = (Map)calPersonSucList.get(index);
            checkSucMap.put("onholduniquecode", onHoldUniqueCodeList.get(index));
        }
        Map<Long, List<Map<String, Object>>> allOnHoldDataBySalaryFile = this.buildDataBySalaryFile(calPersonSucList);
        ArrayList<String> employeeIdList = new ArrayList<String>(calPersonSucList.size());
        JSONObject onHoldJsonObj = new JSONObject();
        this.buildOnHoldInfo(onHoldJsonObj, employeeIdList, allOnHoldDataBySalaryFile, calPersonSucList);
        OnHoldBillInterfaceService onHoldService = new OnHoldBillInterfaceService();
        Map<String, Object> onholdMap = null;
        onholdMap = SWCStringUtils.equals((String)isSubmit, (String)OPSTATUS_FAIL) ? onHoldService.saveOnHold(onHoldJsonObj, employeeIdList, resultList, failStrategy) : onHoldService.submitOnHold(onHoldJsonObj, employeeIdList, resultList, failStrategy);
        this.log.info("onHoldInterfaceService save onhold data is:{}", onholdMap);
        this.log.info("onHoldInterfaceService result is:{}", resultList);
        this.log.info("onHoldInterfaceService checkSuc is:{}", calPersonSucList);
        if (resultList.size() == calPersonSucList.size()) {
            for (Map map2 : resultList) {
                map2.remove("onholduniquecode");
            }
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        if (SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC) && resultList.size() > 0) {
            for (Map map3 : resultList) {
                map3.remove("onholduniquecode");
            }
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        this.buildResultList(resultList, calPersonSucList);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        return responseMap;
    }

    public Map<String, Object> releaseOnHoldData(Map<String, Object> params) {
        this.log.info("OnHoldInterfaceService releaseOnHoldData params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        List dataMapList = (List)params.get("data");
        if (CollectionUtils.isEmpty((Collection)dataMapList)) {
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, null, "data is empty");
            return responseMap;
        }
        String failStrategy = MapUtils.getString(params, (Object)"failstrategy");
        if (SWCStringUtils.isNotEmpty((String)failStrategy)) {
            if (!SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_FAIL) && !SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC)) {
                this.buildErrorResponseMap(responseMap, Boolean.FALSE, OnHoldFailStatusEnum.FAILSTATUS_1032.getCode(), OnHoldFailStatusEnum.getDesc((String)OnHoldFailStatusEnum.FAILSTATUS_1032.getCode()));
                return responseMap;
            }
        } else {
            failStrategy = OPSTATUS_FAIL;
        }
        if (dataMapList.size() > 500) {
            String errorCode = OnHoldFailStatusEnum.FAILSTATUS_1004.getCode();
            String msg = MessageFormat.format(OnHoldFailStatusEnum.getDesc((String)errorCode), 500);
            this.buildErrorResponseMap(responseMap, Boolean.FALSE, errorCode, msg);
            return responseMap;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dataMapList.size());
        ArrayList<Map<String, Object>> mustInputSucList = new ArrayList<Map<String, Object>>(dataMapList.size());
        this.checkSalaryFileMustInput(resultList, dataMapList, mustInputSucList);
        if (mustInputSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> salaryFileSucList = new ArrayList<Map<String, Object>>(mustInputSucList.size());
        HashMap<Long, String> salaryFileIdAndNumberRelMap = new HashMap<Long, String>(16);
        Set<Long> checkSalaryFileIdSet = mustInputSucList.stream().map(map -> (Long)map.get("salaryfileid")).collect(Collectors.toSet());
        this.checkSalaryFileExists(checkSalaryFileIdSet, resultList, salaryFileSucList, mustInputSucList, salaryFileIdAndNumberRelMap);
        if (salaryFileSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> calTaskSucList = new ArrayList<Map<String, Object>>(salaryFileSucList.size());
        HashMap<Long, String> calTaskIdAndNumberRelMap = new HashMap<Long, String>(16);
        this.checkCalTaskExists(resultList, calTaskSucList, salaryFileSucList, calTaskIdAndNumberRelMap);
        if (calTaskSucList.size() == 0) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        ArrayList<Map<String, Object>> onHoldExistList = new ArrayList<Map<String, Object>>(salaryFileSucList.size());
        this.onHoldDataExistCheck(resultList, onHoldExistList, calTaskSucList);
        if (onHoldExistList.size() == 0 || resultList.size() > 0 && SWCStringUtils.equals((String)failStrategy, (String)OPSTATUS_SUCC)) {
            responseMap.put("success", Boolean.TRUE);
            responseMap.put("message", "ok");
            responseMap.put("result", resultList);
            return responseMap;
        }
        OnHoldBillInterfaceService onHoldService = new OnHoldBillInterfaceService();
        onHoldService.releaseOnHold(onHoldExistList, resultList);
        responseMap.put("success", Boolean.TRUE);
        responseMap.put("message", "ok");
        responseMap.put("result", resultList);
        return responseMap;
    }

    private void onHoldDataExistCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> onHoldExistList, List<Map<String, Object>> checkList) {
        Set salaryFileIdSet = checkList.stream().map(map -> (Long)map.get("salaryfileid")).collect(Collectors.toSet());
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObject[] onHoldDatas = helper.query("id,salaryfile.id,caltask.id,status", new QFilter[]{filter});
        HashBasedTable onHoldDataTable = HashBasedTable.create();
        for (DynamicObject onHoldObj : onHoldDatas) {
            Long calTaskId;
            Long salaryFileId = onHoldObj.getLong("salaryfile.id");
            HashSet<String> onHoldStatusSet = (HashSet<String>)onHoldDataTable.get((Object)salaryFileId, (Object)(calTaskId = Long.valueOf(onHoldObj.getLong("caltask.id"))));
            if (onHoldStatusSet == null || onHoldStatusSet.size() == 0) {
                onHoldStatusSet = new HashSet<String>(16);
            }
            String onHoldStatus = onHoldObj.getString("status");
            onHoldStatusSet.add(onHoldStatus);
            onHoldDataTable.put((Object)salaryFileId, (Object)calTaskId, onHoldStatusSet);
        }
        for (Map map2 : checkList) {
            Set onHoldStatusSet;
            Long salaryFileId = (Long)map2.get("salaryfileid");
            Long calTaskId = (Long)map2.get("caltaskid");
            if (calTaskId == null) {
                calTaskId = 0L;
            }
            if ((onHoldStatusSet = (Set)onHoldDataTable.get((Object)salaryFileId, (Object)calTaskId)) == null || onHoldStatusSet.size() == 0) {
                Map<String, Object> resltMap;
                String errorMsg;
                if (calTaskId == 0L) {
                    errorMsg = MessageFormat.format(OnHoldFailStatusEnum.FAILSTATUS_1029.getDesc(), String.valueOf(salaryFileId));
                    resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1029.getCode(), errorMsg, salaryFileId, null);
                    resultList.add(resltMap);
                    continue;
                }
                errorMsg = MessageFormat.format(OnHoldFailStatusEnum.FAILSTATUS_1030.getDesc(), String.valueOf(salaryFileId), String.valueOf(calTaskId));
                resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1030.getCode(), errorMsg, salaryFileId, calTaskId);
                resultList.add(resltMap);
                continue;
            }
            if (!onHoldStatusSet.contains(String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode())) && !onHoldStatusSet.contains(String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode()))) {
                Map<String, Object> resltMap;
                if (calTaskId == 0L) {
                    resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1031.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1031.getDesc(), salaryFileId, null);
                    resultList.add(resltMap);
                    continue;
                }
                resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1031.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1031.getDesc(), salaryFileId, calTaskId);
                resultList.add(resltMap);
                continue;
            }
            onHoldExistList.add(map2);
        }
    }

    private void buildResultList(List<Map<String, Object>> resultList, List<Map<String, Object>> onHoldSucList) {
        String onHoldUniqueCode;
        HashSet<String> checkErrorUniqueCodeSet = new HashSet<String>(resultList.size());
        for (Map<String, Object> resultMap : resultList) {
            onHoldUniqueCode = MapUtils.getString(resultMap, (Object)"onholduniquecode");
            if (SWCStringUtils.isEmpty((String)onHoldUniqueCode)) continue;
            checkErrorUniqueCodeSet.add(onHoldUniqueCode);
        }
        for (Map<String, Object> onHoldSucMap : onHoldSucList) {
            onHoldUniqueCode = MapUtils.getString(onHoldSucMap, (Object)"onholduniquecode");
            if (checkErrorUniqueCodeSet.contains(onHoldUniqueCode)) continue;
            HashMap<String, Object> sucMap = new HashMap<String, Object>(16);
            sucMap.put("salaryfileid", MapUtils.getLong(onHoldSucMap, (Object)"salaryfileid"));
            sucMap.put("caltaskid", MapUtils.getLong(onHoldSucMap, (Object)"caltaskid"));
            sucMap.put("operate", MapUtils.getString(onHoldSucMap, (Object)"operate"));
            sucMap.put("status", OPSTATUS_SUCC);
            sucMap.put("errorcode", null);
            sucMap.put("errormsg", null);
            resultList.add(sucMap);
        }
        for (Map<String, Object> resultMap : resultList) {
            resultMap.remove("onholduniquecode");
        }
    }

    private void buildOnHoldInfo(JSONObject onHoldJsonObj, List<String> employeeIdList, Map<Long, List<Map<String, Object>>> allOnHoldDataBySalaryFile, List<Map<String, Object>> onHoldSucList) {
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter("id", "in", allOnHoldDataBySalaryFile.keySet());
        DynamicObject[] employeeDatas = salaryFileHelper.query("id,employee.id,employee.person.name,employee.person.number,number,bsed,bsled,firstbsed,org.id,payrollgroup.id,adminorg.id,empposinfo.company.id,empposinfo.adminorg.id,empgroup.id,empposinfo.position.id", new QFilter[]{salaryFileFilter});
        HashMap<Long, Map<String, Object>> allEmployeeMap = new HashMap<Long, Map<String, Object>>(employeeDatas.length);
        ArrayList<Long> payRollGroupIdList = new ArrayList<Long>(employeeDatas.length);
        for (DynamicObject employeeObj : employeeDatas) {
            Long salaryFileId = employeeObj.getLong("id");
            HashMap<String, Object> employeeMap = (HashMap<String, Object>)allEmployeeMap.get(salaryFileId);
            if (employeeMap == null) {
                employeeMap = new HashMap<String, Object>(16);
            }
            DynamicObject[] employeeId = Long.valueOf(employeeObj.getLong("employee.id"));
            employeeIdList.add(String.valueOf(employeeId));
            String employeeName = employeeObj.getString("employee.person.name");
            String employeeNumber = employeeObj.getString("employee.person.number");
            employeeMap.put("employeeId", employeeId);
            employeeMap.put("employeeName", employeeName);
            employeeMap.put("employeeNumber", employeeNumber);
            employeeMap.put("salaryNumber", employeeObj.getString("number"));
            employeeMap.put("salaryFirstBred", employeeObj.getDate("firstbsed"));
            employeeMap.put("salaryBred", employeeObj.getDate("bsed"));
            employeeMap.put("salaryBrled", employeeObj.getDate("bsled"));
            employeeMap.put("org", employeeObj.getLong("org.id"));
            Long payRollGroupId = employeeObj.getLong("payrollgroup.id");
            if (payRollGroupId != null) {
                payRollGroupIdList.add(payRollGroupId);
                employeeMap.put("payrollgroup", payRollGroupId);
            }
            employeeMap.put("adminorg", employeeObj.getString("adminorg.id"));
            employeeMap.put("company", employeeObj.getString("empposinfo.company.id"));
            employeeMap.put("department", employeeObj.getString("empposinfo.adminorg.id"));
            employeeMap.put("caltableEmpgroup", employeeObj.getString("empgroup.id"));
            employeeMap.put("position", employeeObj.getString("empposinfo.position.id"));
            allEmployeeMap.put(salaryFileId, employeeMap);
        }
        Map<String, Long> payRollGroupIdRefVidMap = null;
        if (payRollGroupIdList.size() > 0) {
            payRollGroupIdRefVidMap = OnHoldInterfaceService.queryPayrollGroupVidById(payRollGroupIdList);
        }
        HashSet<Long> calTaskIdSet = new HashSet<Long>(onHoldSucList.size());
        for (Map<String, Object> onHoldSucMap : onHoldSucList) {
            Long calTaskId = MapUtils.getLong(onHoldSucMap, (Object)"caltaskid");
            if (calTaskId == null) continue;
            calTaskIdSet.add(calTaskId);
        }
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter calTaskFilter = new QFilter("id", "in", calTaskIdSet);
        DynamicObject[] calTaskDatas = calTaskHelper.query("id,STARTDATE,payrollgroup.id,ENDDATE,calcount,number,payrolldate", new QFilter[]{calTaskFilter});
        HashMap<Long, Map<String, Object>> calTaskInfoMap = new HashMap<Long, Map<String, Object>>(calTaskDatas.length);
        for (DynamicObject calTaskData : calTaskDatas) {
            Long calTaskId = calTaskData.getLong("id");
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            hashMap.put("caltableStartdate", calTaskData.getDate("STARTDATE"));
            hashMap.put("payrollgroup", calTaskData.getLong("payrollgroup.id"));
            hashMap.put("caltableEnddate", calTaskData.getDate("ENDDATE"));
            hashMap.put("caltableCalCount", calTaskData.getInt("calcount"));
            hashMap.put("caltableCaltaskNumber", calTaskData.getString("number"));
            hashMap.put("caltablePayrollDate", calTaskData.getDate("payrolldate"));
            calTaskInfoMap.put(calTaskId, hashMap);
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask.id", "in", calTaskIdSet);
        calPersonFilter.and("salaryfile.id", "in", allOnHoldDataBySalaryFile.keySet());
        DynamicObject[] calPersonDataColl = calPersonHelper.query("id,caltask.id,salaryfile.id", new QFilter[]{calPersonFilter});
        HashBasedTable calPersonInfoTable = HashBasedTable.create();
        for (DynamicObject calPersonDataObj : calPersonDataColl) {
            Long salaryFileId;
            Long calTaskId = calPersonDataObj.getLong("caltask.id");
            HashMap<String, Long> calPersonMap = (HashMap<String, Long>)calPersonInfoTable.get((Object)calTaskId, (Object)(salaryFileId = Long.valueOf(calPersonDataObj.getLong("salaryfile.id"))));
            if (calPersonMap == null) {
                calPersonMap = new HashMap<String, Long>(16);
            }
            calPersonMap.put("calPersonId", calPersonDataObj.getLong("id"));
            calPersonInfoTable.put((Object)calTaskId, (Object)salaryFileId, calPersonMap);
        }
        for (Map map : onHoldSucList) {
            String operate = MapUtils.getString((Map)map, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC)) {
                this.buildSalaryFileData(map, allEmployeeMap, onHoldJsonObj, payRollGroupIdRefVidMap, operate);
                continue;
            }
            if (SWCStringUtils.equals((String)operate, (String)"2")) {
                this.buildCalTaskData(map, allEmployeeMap, onHoldJsonObj, calTaskInfoMap, (Table<Long, Long, Map<String, Object>>)calPersonInfoTable, payRollGroupIdRefVidMap, operate);
                continue;
            }
            this.buildSalaryFileData(map, allEmployeeMap, onHoldJsonObj, payRollGroupIdRefVidMap, operate);
            this.buildCalTaskData(map, allEmployeeMap, onHoldJsonObj, calTaskInfoMap, (Table<Long, Long, Map<String, Object>>)calPersonInfoTable, payRollGroupIdRefVidMap, operate);
        }
        this.buildOnholdReason(onHoldSucList, allEmployeeMap, onHoldJsonObj);
    }

    private void buildOnholdReason(List<Map<String, Object>> onHoldSucList, Map<Long, Map<String, Object>> allEmployeeMap, JSONObject onHoldJsonObj) {
        for (Map<String, Object> onHoldSucMap : onHoldSucList) {
            JSONObject employeeObj;
            Long employeeId;
            Map<String, Object> employeeInfo;
            Long salaryFileId;
            String remark = MapUtils.getString(onHoldSucMap, (Object)"remark");
            if (SWCStringUtils.isEmpty((String)remark) || (salaryFileId = MapUtils.getLong(onHoldSucMap, (Object)"salaryfileid")) == null || (employeeInfo = allEmployeeMap.get(salaryFileId)) == null || employeeInfo.size() == 0 || (employeeId = MapUtils.getLong(employeeInfo, (Object)"employeeId")) == null || (employeeObj = onHoldJsonObj.getJSONObject(String.valueOf(employeeId))) == null) continue;
            JSONObject remarkObj = new JSONObject();
            remarkObj.put("zh_CN", (Object)remark);
            remarkObj.put("zh_TW", (Object)remark);
            remarkObj.put("GLang", (Object)remark);
            employeeObj.put("remark", (Object)remark);
            onHoldJsonObj.put(String.valueOf(employeeId), (Object)employeeObj);
        }
    }

    private void buildCalTaskData(Map<String, Object> onHoldSucMap, Map<Long, Map<String, Object>> allEmployeeMap, JSONObject onHoldJsonObj, Map<Long, Map<String, Object>> calTaskInfoMap, Table<Long, Long, Map<String, Object>> calPersonInfoTable, Map<String, Long> payRollGroupIdRefVidMap, String operate) {
        Long calPersonId;
        Date caltablePayrollDate;
        Long calTaskId = MapUtils.getLong(onHoldSucMap, (Object)"caltaskid");
        if (calTaskId == null) {
            return;
        }
        Long salaryFileId = MapUtils.getLong(onHoldSucMap, (Object)"salaryfileid");
        if (salaryFileId == null) {
            return;
        }
        Map<String, Object> employeeInfo = allEmployeeMap.get(salaryFileId);
        if (employeeInfo == null || employeeInfo.size() == 0) {
            return;
        }
        Long employeeId = MapUtils.getLong(employeeInfo, (Object)"employeeId");
        if (employeeId == null) {
            return;
        }
        JSONObject employeeObj = onHoldJsonObj.getJSONObject(String.valueOf(employeeId));
        if (employeeObj == null) {
            employeeObj = new JSONObject();
        }
        String employeeName = MapUtils.getString(employeeInfo, (Object)"employeeName");
        employeeObj.put("personName", (Object)employeeName);
        String employeeNumber = MapUtils.getString(employeeInfo, (Object)"employeeNumber");
        employeeObj.put("personNo", (Object)employeeNumber);
        JSONArray caltableList = employeeObj.getJSONArray("caltableList");
        if (caltableList == null) {
            caltableList = new JSONArray();
        }
        JSONObject detailObj = new JSONObject();
        detailObj.put("operate", (Object)operate);
        Map<String, Object> calTaskDetailMap = calTaskInfoMap.get(calTaskId);
        if (calTaskDetailMap == null) {
            return;
        }
        Date caltableStartdate = (Date)calTaskDetailMap.get("caltableStartdate");
        if (caltableStartdate != null) {
            detailObj.put("caltableStartdate", (Object)SWCDateTimeUtils.format((Date)caltableStartdate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ((caltablePayrollDate = (Date)calTaskDetailMap.get("caltablePayrollDate")) != null) {
            detailObj.put("caltablePayrollDate", (Object)SWCDateTimeUtils.format((Date)caltablePayrollDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        detailObj.put("salaryfile", (Object)String.valueOf(salaryFileId));
        Long payRollGroupId = (Long)employeeInfo.get("payrollgroup");
        detailObj.put("adminorg", employeeInfo.get("adminorg"));
        if (payRollGroupId != null && payRollGroupIdRefVidMap != null) {
            detailObj.put("payrollgroup", (Object)payRollGroupIdRefVidMap.get(String.valueOf(payRollGroupId)));
        }
        detailObj.put("company", employeeInfo.get("company"));
        detailObj.put("position", employeeInfo.get("position"));
        Long orgId = (Long)employeeInfo.get("org");
        if (orgId != null) {
            detailObj.put("org", (Object)String.valueOf(orgId));
        }
        detailObj.put("department", employeeInfo.get("department"));
        detailObj.put("caltableEmpgroup", employeeInfo.get("caltableEmpgroup"));
        detailObj.put("caltablePersonNo", (Object)employeeNumber);
        Long calTableReasonId = MapUtils.getLong(onHoldSucMap, (Object)"caltaskonholdreasonid");
        if (calTableReasonId != null) {
            detailObj.put("caltableonholdreason", (Object)String.valueOf(calTableReasonId));
        }
        detailObj.put("caltableStatus", (Object)"00");
        detailObj.put("caltableIsPass", (Object)Boolean.FALSE);
        detailObj.put("caltableIndex", (Object)(caltableList.size() + 1));
        detailObj.put("caltask", (Object)String.valueOf(calTaskId));
        detailObj.put("caltableonholdstatus", (Object)Boolean.TRUE);
        Map calPersonInfoMap = (Map)calPersonInfoTable.get((Object)calTaskId, (Object)salaryFileId);
        if (calPersonInfoMap != null && (calPersonId = (Long)calPersonInfoMap.get("calPersonId")) != null) {
            detailObj.put("caltable", (Object)String.valueOf(calPersonId));
            JSONArray caltableIdList = employeeObj.getJSONArray("caltableIdList");
            if (caltableIdList == null) {
                caltableIdList = new JSONArray();
            }
            caltableIdList.add((Object)calPersonId);
            employeeObj.put("caltableIdList", (Object)caltableIdList);
        }
        detailObj.put("caltableCalCount", calTaskDetailMap.get("caltableCalCount"));
        detailObj.put("caltableSalaryfileNumber", (Object)MapUtils.getString(employeeInfo, (Object)"salaryNumber"));
        detailObj.put("onholduniquecode", (Object)MapUtils.getString(onHoldSucMap, (Object)"onholduniquecode"));
        detailObj.put("person", (Object)String.valueOf(employeeId));
        detailObj.put("caltableCaltaskNumber", calTaskDetailMap.get("caltableCaltaskNumber"));
        detailObj.put("caltablePersonName", (Object)employeeName);
        Date caltableEnddate = (Date)calTaskDetailMap.get("caltableEnddate");
        if (caltableEnddate != null) {
            detailObj.put("caltableEnddate", (Object)SWCDateTimeUtils.format((Date)caltableEnddate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        caltableList.add((Object)detailObj);
        employeeObj.put("caltableList", (Object)caltableList);
        onHoldJsonObj.put(String.valueOf(employeeId), (Object)employeeObj);
    }

    private void buildSalaryFileData(Map<String, Object> onHoldSucMap, Map<Long, Map<String, Object>> allEmployeeMap, JSONObject onHoldJsonObj, Map<String, Long> payRollGroupIdRefVidMap, String operate) {
        Long payRollGroupId;
        Long orgId;
        Date salaryBred;
        Long salaryFileId = MapUtils.getLong(onHoldSucMap, (Object)"salaryfileid");
        if (salaryFileId == null) {
            return;
        }
        Map<String, Object> employeeInfo = allEmployeeMap.get(salaryFileId);
        if (employeeInfo == null || employeeInfo.size() == 0) {
            return;
        }
        Long employeeId = MapUtils.getLong(employeeInfo, (Object)"employeeId");
        if (employeeId == null) {
            return;
        }
        JSONObject employeeObj = onHoldJsonObj.getJSONObject(String.valueOf(employeeId));
        if (employeeObj == null) {
            employeeObj = new JSONObject();
        }
        String employeeName = MapUtils.getString(employeeInfo, (Object)"employeeName");
        employeeObj.put("personName", (Object)employeeName);
        String employeeNumber = MapUtils.getString(employeeInfo, (Object)"employeeNumber");
        employeeObj.put("personNo", (Object)employeeNumber);
        JSONArray salaryfileIdList = employeeObj.getJSONArray("salaryfileIdList");
        if (salaryfileIdList == null) {
            salaryfileIdList = new JSONArray();
        }
        if (this.checkSalaryFileExistsById(salaryfileIdList, salaryFileId)) {
            return;
        }
        salaryfileIdList.add((Object)salaryFileId);
        employeeObj.put("salaryfileIdList", (Object)salaryfileIdList);
        JSONArray salaryfileList = employeeObj.getJSONArray("salaryfileList");
        if (salaryfileList == null) {
            salaryfileList = new JSONArray();
        }
        JSONObject detailObj = new JSONObject();
        Date salaryFirstBred = (Date)employeeInfo.get("salaryFirstBred");
        if (salaryFirstBred != null) {
            detailObj.put("salaryFirstBred", (Object)SWCDateTimeUtils.format((Date)salaryFirstBred, (String)"yyyy-MM-dd"));
        }
        if ((salaryBred = (Date)employeeInfo.get("salaryBred")) != null) {
            detailObj.put("salaryBred", (Object)SWCDateTimeUtils.format((Date)salaryBred, (String)"yyyy-MM-dd"));
        }
        if ((orgId = (Long)employeeInfo.get("org")) != null) {
            detailObj.put("org", (Object)String.valueOf(orgId));
        }
        if ((payRollGroupId = (Long)employeeInfo.get("payrollgroup")) != null && payRollGroupIdRefVidMap != null) {
            detailObj.put("payrollgroup", (Object)payRollGroupIdRefVidMap.get(String.valueOf(payRollGroupId)));
        }
        detailObj.put("operate", (Object)operate);
        detailObj.put("adminorg", employeeInfo.get("adminorg"));
        detailObj.put("company", employeeInfo.get("company"));
        detailObj.put("position", employeeInfo.get("position"));
        detailObj.put("department", employeeInfo.get("department"));
        detailObj.put("salaryNumber", (Object)MapUtils.getString(employeeInfo, (Object)"salaryNumber"));
        detailObj.put("salaryIsPass", (Object)Boolean.FALSE);
        Date salaryBrled = (Date)employeeInfo.get("salaryBrled");
        if (salaryBrled != null) {
            detailObj.put("salaryBrled", (Object)SWCDateTimeUtils.format((Date)salaryBrled, (String)"yyyy-MM-dd"));
        }
        detailObj.put("salaryfileStatus", (Object)"00");
        Long salaryOnHoldReasonId = MapUtils.getLong(onHoldSucMap, (Object)"salaryonholdreasonid");
        if (salaryOnHoldReasonId != null) {
            detailObj.put("salaryonholdreason", (Object)salaryOnHoldReasonId);
        }
        detailObj.put("onholduniquecode", (Object)MapUtils.getString(onHoldSucMap, (Object)"onholduniquecode"));
        detailObj.put("salaryfile", (Object)String.valueOf(salaryFileId));
        detailObj.put("salaryPersonNo", (Object)employeeNumber);
        detailObj.put("salaryIndex", (Object)(salaryfileList.size() + 1));
        detailObj.put("person", (Object)String.valueOf(employeeId));
        detailObj.put("salaryonholdstatus", (Object)Boolean.FALSE);
        detailObj.put("salaryPersonName", (Object)employeeName);
        Date salaryOnHoldStartDate = (Date)onHoldSucMap.get("onholdstartdate");
        if (salaryOnHoldStartDate == null) {
            return;
        }
        detailObj.put("salaryonholdstartdate", (Object)SWCDateTimeUtils.format((Date)salaryOnHoldStartDate, (String)"yyyy-MM-dd"));
        Date releaseDate = (Date)onHoldSucMap.get("releasedate");
        if (releaseDate != null) {
            detailObj.put("salaryreleasedate", (Object)SWCDateTimeUtils.format((Date)releaseDate, (String)"yyyy-MM-dd"));
        }
        detailObj.put("salaryisallowcal", (Object)MapUtils.getString(onHoldSucMap, (Object)"isallowcal"));
        salaryfileList.add((Object)detailObj);
        employeeObj.put("salaryfileList", (Object)salaryfileList);
        onHoldJsonObj.put(String.valueOf(employeeId), (Object)employeeObj);
    }

    private boolean checkSalaryFileExistsById(JSONArray salaryfileIdList, Long checkSalaryFileId) {
        for (int index = 0; index < salaryfileIdList.size(); ++index) {
            Long salaryfileId = salaryfileIdList.getLong(index);
            if (salaryfileId == null || checkSalaryFileId == null || salaryfileId.longValue() != checkSalaryFileId.longValue()) continue;
            return true;
        }
        return false;
    }

    private Map<Long, List<Map<String, Object>>> buildDataBySalaryFile(List<Map<String, Object>> onHoldSucList) {
        HashMap<Long, List<Map<String, Object>>> allOnHoldDataBySalaryFile = new HashMap<Long, List<Map<String, Object>>>(onHoldSucList.size());
        for (Map<String, Object> onHoldSucMap : onHoldSucList) {
            Long salaryFileId = MapUtils.getLong(onHoldSucMap, (Object)"salaryfileid");
            ArrayList<Map<String, Object>> onHoldList = (ArrayList<Map<String, Object>>)allOnHoldDataBySalaryFile.get(salaryFileId);
            if (onHoldList == null) {
                onHoldList = new ArrayList<Map<String, Object>>(10);
            }
            onHoldList.add(onHoldSucMap);
            allOnHoldDataBySalaryFile.put(salaryFileId, onHoldList);
        }
        return allOnHoldDataBySalaryFile;
    }

    private void remarkLengthCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> remarkSucList, List<Map<String, Object>> checkList) {
        for (Map<String, Object> checkMap : checkList) {
            String remark = MapUtils.getString(checkMap, (Object)"remark");
            if (SWCStringUtils.isEmpty((String)remark)) {
                remarkSucList.add(checkMap);
                continue;
            }
            if (remark.length() > 255) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1023.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1023.getDesc(), MapUtils.getLong(checkMap, (Object)"salaryfileid"), MapUtils.getLong(checkMap, (Object)"caltaskid"), MapUtils.getString(checkMap, (Object)"operate"));
                resultList.add(resltMap);
                continue;
            }
            remarkSucList.add(checkMap);
        }
    }

    private void operateAndCalTaskCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> onHoldSucList, List<Map<String, Object>> onHoldReasonSucList) {
        for (Map<String, Object> onHoldReasonSucMap : onHoldReasonSucList) {
            String operate = MapUtils.getString(onHoldReasonSucMap, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC)) {
                onHoldSucList.add(onHoldReasonSucMap);
                continue;
            }
            Long calTaskId = MapUtils.getLong(onHoldReasonSucMap, (Object)"caltaskid");
            if (calTaskId == null) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1021.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1021.getDesc(), MapUtils.getLong(onHoldReasonSucMap, (Object)"salaryfileid"), calTaskId, operate);
                resultList.add(resltMap);
                continue;
            }
            onHoldSucList.add(onHoldReasonSucMap);
        }
    }

    private void onHoldReasonCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> onHoldReasonSucList, List<Map<String, Object>> onHoldDateSucList) {
        HashSet<Long> onHoldReasonIdSet = new HashSet<Long>(onHoldDateSucList.size());
        for (Map<String, Object> onHoldDateSucMap : onHoldDateSucList) {
            Long calTaskReasonId;
            Long salaryReasonId = MapUtils.getLong(onHoldDateSucMap, (Object)"salaryonholdreasonid");
            if (salaryReasonId != null) {
                onHoldReasonIdSet.add(salaryReasonId);
            }
            if ((calTaskReasonId = MapUtils.getLong(onHoldDateSucMap, (Object)"caltaskonholdreasonid")) == null) continue;
            onHoldReasonIdSet.add(calTaskReasonId);
        }
        if (onHoldReasonIdSet.size() == 0) {
            onHoldReasonSucList.addAll(onHoldDateSucList);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_onholdcause");
        QFilter filter = new QFilter("id", "in", onHoldReasonIdSet);
        filter.and("enable", "=", (Object)OPSTATUS_SUCC);
        DynamicObject[] onHoldReasonDatas = helper.query("id", new QFilter[]{filter});
        HashSet<Long> queryReasonIdSet = new HashSet<Long>(onHoldReasonDatas.length);
        for (DynamicObject onHoldReasonObj : onHoldReasonDatas) {
            queryReasonIdSet.add(onHoldReasonObj.getLong("id"));
        }
        for (Map map : onHoldDateSucList) {
            Long salaryReasonId = MapUtils.getLong((Map)map, (Object)"salaryonholdreasonid");
            if (salaryReasonId != null && !queryReasonIdSet.contains(salaryReasonId)) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1019.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1019.getDesc(), MapUtils.getLong((Map)map, (Object)"salaryfileid"), MapUtils.getLong((Map)map, (Object)"caltaskid"), MapUtils.getString((Map)map, (Object)"operate"));
                resultList.add(resltMap);
                continue;
            }
            Long calTaskReasonId = MapUtils.getLong((Map)map, (Object)"caltaskonholdreasonid");
            if (calTaskReasonId != null && !queryReasonIdSet.contains(calTaskReasonId)) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1020.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1020.getDesc(), MapUtils.getLong((Map)map, (Object)"salaryfileid"), MapUtils.getLong((Map)map, (Object)"caltaskid"), MapUtils.getString((Map)map, (Object)"operate"));
                resultList.add(resltMap);
                continue;
            }
            onHoldReasonSucList.add(map);
        }
    }

    private void operateRangeCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> operateSucList, List<Map<String, Object>> isAllowSucList) {
        for (Map<String, Object> isAllowSucMap : isAllowSucList) {
            String operate = MapUtils.getString(isAllowSucMap, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC) || SWCStringUtils.equals((String)operate, (String)"2") || SWCStringUtils.equals((String)operate, (String)"3")) {
                operateSucList.add(isAllowSucMap);
                continue;
            }
            Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1006.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1006.getDesc(), MapUtils.getLong(isAllowSucMap, (Object)"salaryfileid"), MapUtils.getLong(isAllowSucMap, (Object)"caltaskid"), operate);
            resultList.add(resltMap);
        }
    }

    private void calPersonCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> calPersonSucList, List<Map<String, Object>> checkList, Map<Long, String> salaryFileIdAndNumberRelMap, Map<Long, String> calTaskIdAndNumberRelMap) {
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(checkList.size());
        HashSet<Long> calTaskIdSet = new HashSet<Long>(checkList.size());
        for (Map<String, Object> checkMap : checkList) {
            Long calTaskId;
            String operate = MapUtils.getString(checkMap, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC) || (calTaskId = MapUtils.getLong(checkMap, (Object)"caltaskid")) == null || calTaskId == 0L) continue;
            calTaskIdSet.add(calTaskId);
            salaryFileIdSet.add(MapUtils.getLong(checkMap, (Object)"salaryfileid"));
        }
        if (calTaskIdSet.size() == 0) {
            calPersonSucList.addAll(checkList);
            return;
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask.id", "in", calTaskIdSet);
        calPersonFilter.and("salaryfile.id", "in", salaryFileIdSet);
        DynamicObject[] calPersonColl = calPersonHelper.query("id,caltask.id,caltask.number,salaryfile.id,salaryfile.number", new QFilter[]{calPersonFilter});
        HashMap<Long, HashSet<Long>> calTaskAndSalaryFileRelMap = new HashMap<Long, HashSet<Long>>(calPersonColl.length);
        for (DynamicObject calPersonObj : calPersonColl) {
            Long calTaskId = calPersonObj.getLong("caltask.id");
            HashSet<Long> salaryFileQuerySet = (HashSet<Long>)calTaskAndSalaryFileRelMap.get(calTaskId);
            if (salaryFileQuerySet == null) {
                salaryFileQuerySet = new HashSet<Long>(16);
            }
            salaryFileQuerySet.add(calPersonObj.getLong("salaryfile.id"));
            calTaskAndSalaryFileRelMap.put(calTaskId, salaryFileQuerySet);
        }
        for (Map map : checkList) {
            String operate = MapUtils.getString((Map)map, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC)) {
                calPersonSucList.add(map);
                continue;
            }
            Long calTaskId = MapUtils.getLong((Map)map, (Object)"caltaskid");
            if (calTaskId == null || calTaskId == 0L) {
                calPersonSucList.add(map);
                continue;
            }
            Set salaryFileQuerySet = (Set)calTaskAndSalaryFileRelMap.get(calTaskId);
            if (salaryFileQuerySet == null || salaryFileQuerySet.size() == 0) {
                String errorMsg = OnHoldFailStatusEnum.FAILSTATUS_1024.getDesc();
                Long checkCalTaskId = MapUtils.getLong((Map)map, (Object)"caltaskid");
                Long checkSalaryFileId = MapUtils.getLong((Map)map, (Object)"salaryfileid");
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1024.getCode(), MessageFormat.format(errorMsg, calTaskIdAndNumberRelMap.get(checkCalTaskId), salaryFileIdAndNumberRelMap.get(checkSalaryFileId)), checkSalaryFileId, checkCalTaskId, operate);
                resultList.add(resltMap);
                continue;
            }
            Long salaryFileId = MapUtils.getLong((Map)map, (Object)"salaryfileid");
            if (salaryFileQuerySet.contains(salaryFileId)) {
                calPersonSucList.add(map);
                continue;
            }
            String errorMsg = OnHoldFailStatusEnum.FAILSTATUS_1024.getDesc();
            Long checkCalTaskId = MapUtils.getLong((Map)map, (Object)"caltaskid");
            Long checkSalaryFileId = MapUtils.getLong((Map)map, (Object)"salaryfileid");
            Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1024.getCode(), MessageFormat.format(errorMsg, calTaskIdAndNumberRelMap.get(checkCalTaskId), salaryFileIdAndNumberRelMap.get(checkSalaryFileId)), checkSalaryFileId, checkCalTaskId, operate);
            resultList.add(resltMap);
        }
    }

    private void isAllowCalRangeCheck(List<Map<String, Object>> resultList, List<Map<String, Object>> isAllowSucList, List<Map<String, Object>> calTaskSucList) {
        for (Map<String, Object> calTaskSucMap : calTaskSucList) {
            String isAllowCal = MapUtils.getString(calTaskSucMap, (Object)"isallowcal");
            if (SWCStringUtils.equals((String)isAllowCal, (String)OPSTATUS_FAIL) || SWCStringUtils.equals((String)isAllowCal, (String)OPSTATUS_SUCC)) {
                isAllowSucList.add(calTaskSucMap);
                continue;
            }
            Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1005.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1005.getDesc(), MapUtils.getLong(calTaskSucMap, (Object)"salaryfileid"), MapUtils.getLong(calTaskSucMap, (Object)"caltaskid"), MapUtils.getString(calTaskSucMap, (Object)"operate"));
            resultList.add(resltMap);
        }
    }

    private void checkCalTaskExists(List<Map<String, Object>> resultList, List<Map<String, Object>> calTaskSucList, List<Map<String, Object>> salaryFileSucList, Map<Long, String> calTaskIdAndNumberRelMap) {
        HashSet<Long> calTaskIdSet = new HashSet<Long>(salaryFileSucList.size());
        for (Map<String, Object> salaryFileMap : salaryFileSucList) {
            Long calTaskId = MapUtils.getLong(salaryFileMap, (Object)"caltaskid");
            if (calTaskId == null || calTaskId == 0L) continue;
            calTaskIdSet.add(calTaskId);
        }
        if (calTaskIdSet.size() == 0) {
            calTaskSucList.addAll(salaryFileSucList);
            return;
        }
        SWCDataServiceHelper hepler = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "in", calTaskIdSet);
        filter.and("taskstatus", "!=", (Object)"6");
        DynamicObject[] queryDatas = hepler.query("id,number,tasktype", new QFilter[]{filter});
        HashSet<Long> queryCalTaskIdSet = new HashSet<Long>(queryDatas.length);
        HashMap<Long, DynamicObject> calTaskInfoMap = new HashMap<Long, DynamicObject>(queryDatas.length);
        for (DynamicObject queryObj : queryDatas) {
            Long calTaskId = queryObj.getLong("id");
            queryCalTaskIdSet.add(calTaskId);
            calTaskInfoMap.put(calTaskId, queryObj);
            calTaskIdAndNumberRelMap.put(calTaskId, queryObj.getString("number"));
        }
        for (Map map : salaryFileSucList) {
            Long calTaskId = MapUtils.getLong((Map)map, (Object)"caltaskid");
            if (calTaskId == null || calTaskId == 0L) {
                calTaskSucList.add(map);
                continue;
            }
            if (queryCalTaskIdSet.contains(calTaskId)) {
                DynamicObject calTaskObj = (DynamicObject)calTaskInfoMap.get(calTaskId);
                if (SWCObjectUtils.isEmpty((Object)calTaskObj)) {
                    calTaskSucList.add(map);
                    continue;
                }
                String taskType = calTaskObj.getString("tasktype");
                if (SWCStringUtils.equals((String)taskType, (String)OPSTATUS_FAIL) || SWCStringUtils.equals((String)taskType, (String)OPSTATUS_SUCC)) {
                    calTaskSucList.add(map);
                    continue;
                }
                Map<String, Object> resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1027.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1027.getDesc(), MapUtils.getLong((Map)map, (Object)"salaryfileid"), calTaskId);
                resultList.add(resltMap);
                continue;
            }
            Map<String, Object> resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1003.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1003.getDesc(), MapUtils.getLong((Map)map, (Object)"salaryfileid"), calTaskId);
            resultList.add(resltMap);
        }
    }

    private void checkSalaryFileExists(Set<Long> checkSalaryFileIdSet, List<Map<String, Object>> resultList, List<Map<String, Object>> salaryFileSucList, List<Map<String, Object>> mustInputSucList, Map<Long, String> salaryFileIdAndNumberRelMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", checkSalaryFileIdSet);
        filter.and("status", "=", (Object)"C");
        DynamicObject[] queryDatas = helper.query("id,number", new QFilter[]{filter});
        HashSet<Long> checkPassSet = new HashSet<Long>(queryDatas.length);
        for (DynamicObject queryData : queryDatas) {
            checkPassSet.add(queryData.getLong("id"));
            salaryFileIdAndNumberRelMap.put(queryData.getLong("id"), queryData.getString("number"));
        }
        for (Map map : mustInputSucList) {
            Long salaryFileId = MapUtils.getLong((Map)map, (Object)"salaryfileid");
            if (checkPassSet.contains(salaryFileId)) {
                salaryFileSucList.add(map);
                continue;
            }
            Map<String, Object> resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1002.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1002.getDesc(), salaryFileId, MapUtils.getLong((Map)map, (Object)"caltaskid"));
            resultList.add(resltMap);
        }
    }

    private void checkDateFormate(List<Map<String, Object>> resultList, List<Map<String, Object>> dataMapList, List<Map<String, Object>> checkSucList) {
        for (Map<String, Object> dataMap : dataMapList) {
            Object onHoldStartDateObj = MapUtils.getObject(dataMap, (Object)"onholdstartdate");
            if (onHoldStartDateObj != null && !(onHoldStartDateObj instanceof Date)) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1025.getCode(), MessageFormat.format(OnHoldFailStatusEnum.FAILSTATUS_1025.getDesc(), "onholdstartdate"), MapUtils.getLong(dataMap, (Object)"salaryfileid"), MapUtils.getLong(dataMap, (Object)"caltaskid"), MapUtils.getString(dataMap, (Object)"operate"));
                resultList.add(resltMap);
                continue;
            }
            Object releaseDate = MapUtils.getObject(dataMap, (Object)"releasedate");
            if (releaseDate != null && !(releaseDate instanceof Date)) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1025.getCode(), MessageFormat.format(OnHoldFailStatusEnum.FAILSTATUS_1025.getDesc(), "releasedate"), MapUtils.getLong(dataMap, (Object)"salaryfileid"), MapUtils.getLong(dataMap, (Object)"caltaskid"), MapUtils.getString(dataMap, (Object)"operate"));
                resultList.add(resltMap);
                continue;
            }
            checkSucList.add(dataMap);
        }
    }

    private void checkMustInput(List<Map<String, Object>> resultList, List<Map<String, Object>> dataMapList, List<Map<String, Object>> mustInputSucList) {
        for (Map<String, Object> dataMap : dataMapList) {
            Long salaryFileId = MapUtils.getLong(dataMap, (Object)"salaryfileid");
            Date onHoldStartDate = (Date)dataMap.get("onholdstartdate");
            String isAllowCal = MapUtils.getString(dataMap, (Object)"isallowcal");
            String operate = MapUtils.getString(dataMap, (Object)"operate");
            if (salaryFileId == null || onHoldStartDate == null || SWCStringUtils.isEmpty((String)isAllowCal) || SWCStringUtils.isEmpty((String)operate)) {
                Map<String, Object> resltMap = this.buildReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1001.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1001.getDesc(), salaryFileId, MapUtils.getLong(dataMap, (Object)"caltaskid"), operate);
                resultList.add(resltMap);
                continue;
            }
            mustInputSucList.add(dataMap);
        }
    }

    private void checkSalaryFileMustInput(List<Map<String, Object>> resultList, List<Map<String, Object>> dataMapList, List<Map<String, Object>> mustInputSucList) {
        for (Map<String, Object> dataMap : dataMapList) {
            Long salaryFileId = MapUtils.getLong(dataMap, (Object)"salaryfileid");
            if (salaryFileId == null) {
                Map<String, Object> resltMap = this.buildReleaseReturnMap(OPSTATUS_FAIL, OnHoldFailStatusEnum.FAILSTATUS_1028.getCode(), OnHoldFailStatusEnum.FAILSTATUS_1028.getDesc(), salaryFileId, MapUtils.getLong(dataMap, (Object)"caltaskid"));
                resultList.add(resltMap);
                continue;
            }
            mustInputSucList.add(dataMap);
        }
    }

    private void buildErrorResponseMap(Map<String, Object> responseMap, Boolean sueecss, String errorcode, String message) {
        responseMap.put("sueecss", sueecss);
        responseMap.put("errorcode", errorcode);
        responseMap.put("message", message);
    }

    public static Map<String, Long> queryPayrollGroupVidById(List<Long> payRollGroupIdList) {
        SWCDataServiceHelper payRollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter idFilter = new QFilter("id", "in", payRollGroupIdList);
        String selectProperties = "id,sourcevid";
        DynamicObject[] payRollGroupArr = payRollGrpHelper.query(selectProperties, new QFilter[]{idFilter});
        HashMap<String, Long> payRollGroupIdRefVidMap = new HashMap<String, Long>(payRollGroupArr.length);
        for (DynamicObject payRollGroup : payRollGroupArr) {
            payRollGroupIdRefVidMap.put(payRollGroup.getString("id"), payRollGroup.getLong("sourcevid"));
        }
        return payRollGroupIdRefVidMap;
    }

    private List<String> getOnHoldCodes(String codePrefix, int count) {
        if (count < 1 || SWCStringUtils.isEmpty((String)codePrefix)) {
            return Collections.EMPTY_LIST;
        }
        if (count == 1) {
            String globalLongId = String.valueOf(DB.genGlobalLongId());
            StringBuilder bizDataCode = new StringBuilder(codePrefix);
            bizDataCode.append('_').append(globalLongId);
            ArrayList<String> results = new ArrayList<String>(1);
            results.add(bizDataCode.toString());
            return results;
        }
        long[] globalLongIds = DB.genGlobalLongIds((int)count);
        List<String> onHoldCodes = Arrays.stream(globalLongIds).mapToObj(id -> codePrefix + '_' + id).collect(Collectors.toList());
        return onHoldCodes;
    }

    private void repeatOnHoldData(List<Map<String, Object>> checkList, List<Map<String, Object>> repeatSucList) {
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(checkList.size());
        HashSet<String> salaryAndTaskIdSet = new HashSet<String>(checkList.size());
        for (Map<String, Object> dataMap : checkList) {
            String checkStr;
            Long salaryFileId;
            String operate = MapUtils.getString(dataMap, (Object)"operate");
            if (SWCStringUtils.equals((String)operate, (String)OPSTATUS_SUCC)) {
                salaryFileId = MapUtils.getLong(dataMap, (Object)"salaryfileid");
                if (salaryFileIdSet.contains(salaryFileId)) continue;
                repeatSucList.add(dataMap);
                salaryFileIdSet.add(salaryFileId);
                continue;
            }
            if (!SWCStringUtils.equals((String)operate, (String)"2") && !SWCStringUtils.equals((String)operate, (String)"3")) continue;
            salaryFileId = MapUtils.getLong(dataMap, (Object)"salaryfileid");
            Long calTaskId = MapUtils.getLong(dataMap, (Object)"caltaskid");
            if (salaryFileId == null || calTaskId == null || salaryAndTaskIdSet.contains(checkStr = String.valueOf(salaryFileId) + '#' + String.valueOf(calTaskId))) continue;
            repeatSucList.add(dataMap);
            salaryAndTaskIdSet.add(checkStr);
        }
    }

    private Map<String, Object> buildReturnMap(String status, String errorCode, String errorMsg, Long salaryFileId, Long calTaskId, String operate) {
        HashMap<String, Object> resltMap = new HashMap<String, Object>(16);
        resltMap.put("status", status);
        resltMap.put("errorcode", errorCode);
        resltMap.put("errormsg", errorMsg);
        resltMap.put("salaryfileid", salaryFileId);
        resltMap.put("caltaskid", calTaskId);
        resltMap.put("operate", operate);
        return resltMap;
    }

    private Map<String, Object> buildReleaseReturnMap(String status, String errorCode, String errorMsg, Long salaryFileId, Long calTaskId) {
        HashMap<String, Object> resltMap = new HashMap<String, Object>(16);
        resltMap.put("status", status);
        resltMap.put("errorcode", errorCode);
        resltMap.put("errormsg", errorMsg);
        resltMap.put("salaryfileid", salaryFileId);
        resltMap.put("caltaskid", calTaskId);
        return resltMap;
    }
}

