/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paynode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsas.business.paynode.PayNodeCacheHelper;
import kd.swc.hsas.common.enums.PayNodeRuleEnum;
import kd.swc.hsas.common.vo.PayNodeTimeConfig;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public class PayNodeHelper {
    public static final String PAY_NODE_GRP_HIS = "paynodegrphis";
    private static final String CAL_PERIOD_TYPE = "calperiodtype";
    public static final String CAL_PERIOD_START_DATE = "startdate";
    public static final String CAL_PERIOD_END_DATE = "enddate";
    private static final String CAL_PERIOD = "period";
    private static final String WORK_CALENDAR = "workcalendar";
    private static final String CAL_PERIOD_PAY = "paydate";
    private static final String FIELD_SELECT = "paynodegrp,entryentity.calperiod,subentryentity.paynode,subentryentity.starttime,subentryentity.endtime";
    private static final String FIELD_SELECT_PAY_NODE = "entryentity,entryentity.bizitem,entryentity.bizitem.id, paynodegrp,paynodegrpent";
    private static final String PAY_NODE_GRP = "paynodegrp";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private static final String KEY_BIZALLCFG = "bizallcfg";
    private static final String PAY_NODE_TYPE = "paynodetype";
    private static final String BIZ_HOLD = "bizhold";
    private static final String CREATE_ORG = "createorg";
    private static final String CAL_PERIOD_TYPE_ID = "calperiodtype.id";
    private static Map<Integer, List<Map<String, String>>> yearWorkCalendarMap;

    public static void buildTimeByTimeRule(Consumer<Void> consumer) {
        yearWorkCalendarMap = new HashMap<Integer, List<Map<String, String>>>();
        consumer.accept(null);
        yearWorkCalendarMap = null;
    }

    public static Date buildTimeByTimeRule(Long workPlanId, PayNodeTimeConfig payNodeTimeConfig, List<DynamicObject> calPeriods, int index) {
        String payNodeRule;
        if (payNodeTimeConfig == null || !payNodeTimeConfig.getAutoCreateEnable()) {
            return null;
        }
        Date result = null;
        switch (payNodeRule = payNodeTimeConfig.getPayNodeRule()) {
            case "period": 
            case "paydate": {
                result = PayNodeHelper.getCalPeriodTime(workPlanId, calPeriods.get(index), payNodeTimeConfig);
                break;
            }
            case "workcalendar": {
                DynamicObject calPeriod = calPeriods.get(index);
                String workRule = payNodeTimeConfig.getWorkRule();
                if (SWCStringUtils.equals((String)"nextperiod", (String)workRule)) {
                    if (index == 0) {
                        return null;
                    }
                    calPeriod = calPeriods.get(index - 1);
                }
                result = PayNodeHelper.getWorkCalendarTime(calPeriod, payNodeTimeConfig);
                if (!payNodeTimeConfig.getHolidayEnable()) break;
                boolean isBiggerDays = true;
                if (SWCStringUtils.equals((String)"before", (String)payNodeTimeConfig.getHolidayWay())) {
                    isBiggerDays = false;
                }
                List<Map<String, String>> workCalendar = PayNodeHelper.loadYearWorkCalendar(result, workPlanId);
                result = WorkCalendarLoadService.getWorkDate(result, isBiggerDays, 1, workCalendar, true);
                break;
            }
        }
        return PayNodeHelper.replaceTime(result, payNodeTimeConfig.getSpecificTime());
    }

    private static Date getWorkCalendarTime(DynamicObject calPeriod, PayNodeTimeConfig payNodeTimeConfig) {
        Date calPeriodStartDate = calPeriod.getDate(CAL_PERIOD_START_DATE);
        Date calPeriodEndDate = calPeriod.getDate(CAL_PERIOD_END_DATE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(calPeriodStartDate);
        calendar.set(5, payNodeTimeConfig.getWorkCalDay());
        if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) == SWCDateTimeUtils.getMonth((Date)calPeriodEndDate)) {
            if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) != calendar.get(2) + 1) {
                calendar.setTime(calPeriodStartDate);
                calendar.set(5, calendar.getActualMaximum(5));
            }
        } else if (calendar.getTime().getTime() < calPeriodStartDate.getTime()) {
            calendar.setTime(calPeriodEndDate);
            calendar.set(5, payNodeTimeConfig.getWorkCalDay());
        } else if (SWCDateTimeUtils.getMonth((Date)calPeriodStartDate) != calendar.get(2) + 1) {
            calendar.setTime(calPeriodStartDate);
            calendar.set(5, calendar.getActualMaximum(5));
        }
        return calendar.getTime();
    }

    private static Date getCalPeriodTime(Long workPlanId, DynamicObject calPeriod, PayNodeTimeConfig payNodeTimeConfig) {
        String calPeriodField = payNodeTimeConfig.getCalPeriodField();
        if (SWCStringUtils.equals((String)CAL_PERIOD_PAY, (String)payNodeTimeConfig.getPayNodeRule())) {
            calPeriodField = CAL_PERIOD_PAY;
        }
        Date result = calPeriod.getDate(calPeriodField.toLowerCase());
        String dateType = payNodeTimeConfig.getDateType();
        int calPeriodDays = payNodeTimeConfig.getCalPeriodDays().intValue();
        String calPeriodWay = payNodeTimeConfig.getCalPeriodWay();
        boolean isBiggerDays = true;
        if (SWCStringUtils.equals((String)"before", (String)calPeriodWay)) {
            isBiggerDays = false;
        }
        if (SWCStringUtils.equals((String)"work", (String)dateType)) {
            List<Map<String, String>> workCalendar = PayNodeHelper.loadYearWorkCalendar(result, workPlanId);
            result = WorkCalendarLoadService.getWorkDate(result, isBiggerDays, calPeriodDays, workCalendar, false);
        } else if (calPeriodDays != 0) {
            result = isBiggerDays ? SWCDateTimeUtils.addDay((Date)result, (long)calPeriodDays) : SWCDateTimeUtils.addDay((Date)result, (long)(-calPeriodDays));
            if (payNodeTimeConfig.getHolidayEnable()) {
                List<Map<String, String>> workCalendar = PayNodeHelper.loadYearWorkCalendar(result, workPlanId);
                result = WorkCalendarLoadService.getWorkDate(result, SWCStringUtils.equals((String)"after", (String)payNodeTimeConfig.getHolidayWay()), 1, workCalendar, true);
            }
        }
        return result;
    }

    private static List<Map<String, String>> loadYearWorkCalendar(Date result, Long wpId) {
        int year = SWCDateTimeUtils.getYear((Date)result);
        return yearWorkCalendarMap.computeIfAbsent(year, key -> WorkCalendarLoadService.loadThreeYearWorkCalendar(result, wpId));
    }

    public static Date replaceTime(Date date, Integer specificTime) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = specificTime / 3600;
        int second = specificTime % 60;
        int minute = (specificTime - hour * 3600 - second) / 60;
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static String buildRuleDesc(PayNodeTimeConfig payNodeTimeConfig) {
        String ruleDesc = "";
        if (Objects.isNull(payNodeTimeConfig)) {
            return ruleDesc;
        }
        if (!payNodeTimeConfig.getAutoCreateEnable()) {
            return ruleDesc;
        }
        String payNodeRule = payNodeTimeConfig.getPayNodeRule();
        BigDecimal calPeriodDays = payNodeTimeConfig.getCalPeriodDays();
        String calPeriodDateType = payNodeTimeConfig.getDateType();
        switch (payNodeRule) {
            case "period": {
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u4ee5{0}\u4e3a\u65f6\u95f4\u951a\u70b9\uff0c{1}\u504f\u79fb{2}{3}", (String)"PayNodeTimeConfigPlugin_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)payNodeTimeConfig.getCalPeriodField()), PayNodeRuleEnum.getDesc((String)payNodeTimeConfig.getCalPeriodWay()), calPeriodDays == null ? Integer.valueOf(0) : calPeriodDays, PayNodeRuleEnum.getDesc((String)calPeriodDateType));
                if (SWCStringUtils.equals((String)calPeriodDateType, (String)"natural") && payNodeTimeConfig.getHolidayEnable()) {
                    ruleDesc = PayNodeHelper.buildHolidayRule(ruleDesc, payNodeTimeConfig);
                }
                return ruleDesc;
            }
            case "workcalendar": {
                if (StringUtils.isEmpty((CharSequence)payNodeTimeConfig.getWorkRule())) {
                    return ruleDesc;
                }
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u5bf9\u7167\u5de5\u4f5c\u65e5\u5386\uff0c\u5728{0}\u627e\u6bcf\u6708{1}\u65e5", (String)"PayNodeTimeConfigPlugin_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)payNodeTimeConfig.getWorkRule()), payNodeTimeConfig.getWorkCalDay());
                if (payNodeTimeConfig.getHolidayEnable()) {
                    ruleDesc = PayNodeHelper.buildHolidayRule(ruleDesc, payNodeTimeConfig);
                }
                return ruleDesc;
            }
            case "paydate": {
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u4ee5\u5f53\u524d\u671f\u95f4\u7684\u652f\u4ed8\u65e5\u671f\u4e3a\u951a\u70b9\uff0c{0}\u504f\u79fb{1}{2}", (String)"PayNodeTimeConfigPlugin_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)payNodeTimeConfig.getCalPeriodWay()), calPeriodDays == null ? Integer.valueOf(0) : calPeriodDays, PayNodeRuleEnum.getDesc((String)calPeriodDateType));
                if (SWCStringUtils.equals((String)calPeriodDateType, (String)"natural") && payNodeTimeConfig.getHolidayEnable()) {
                    ruleDesc = PayNodeHelper.buildHolidayRule(ruleDesc, payNodeTimeConfig);
                }
                return ruleDesc;
            }
        }
        return ruleDesc;
    }

    private static String buildHolidayRule(String ruleDesc, PayNodeTimeConfig payNodeTimeConfig) {
        String holidayWay = payNodeTimeConfig.getHolidayWay();
        if (SWCStringUtils.isNotEmpty((String)holidayWay)) {
            ruleDesc = ruleDesc + MultiLangHelper.getMultiLangCommaDelimiter() + MessageFormat.format(ResManager.loadKDString((String)"\u5982\u9047\u975e\u5de5\u4f5c\u65e5\uff0c{0}\u53d6\u6700\u8fd1\u7684\u5de5\u4f5c\u65e5", (String)"PayNodeTimeConfigPlugin_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)holidayWay));
        }
        return ruleDesc;
    }

    public static Map<String, Object> queryPayNodeTime(Map<String, Object> params) {
        Object id = params.get("id");
        Object bizItemGroupId = params.get("bizitemgroupid");
        Object periodNumber = params.get("periodnumber");
        Object calperiodtypeId = params.get(CAL_PERIOD_TYPE);
        Object orgId = params.get("org");
        DynamicObject bizItemGroup = null;
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("id", id);
        SWCDataServiceHelper payNodeHelper = new SWCDataServiceHelper("hsas_paynode");
        List<QFilter> filters = PayNodeHelper.getAvailableFilters();
        filters.add(new QFilter("entryentity.bizitem.id", "in", bizItemGroupId));
        DynamicObject payNodeDy = payNodeHelper.queryOne(FIELD_SELECT_PAY_NODE, filters.toArray(new QFilter[0]));
        if (Objects.isNull(payNodeDy)) {
            filters = PayNodeHelper.getAvailableFilters();
            QFilter allCfgQFilter = new QFilter(KEY_BIZALLCFG, "=", (Object)"1");
            QFilter typeQFilter = new QFilter(PAY_NODE_TYPE, "=", (Object)BIZ_HOLD);
            QFilter ORGQFilter = new QFilter(CREATE_ORG, "=", orgId);
            HashSet<Object> calperiodtypeIds = new HashSet<Object>(16);
            if (Objects.nonNull(calperiodtypeId)) {
                calperiodtypeIds.add(calperiodtypeId);
            } else {
                SWCDataServiceHelper bizItemGroupHelper = new SWCDataServiceHelper("hsbs_bizitemgroup");
                ArrayList<QFilter> bigFilters = new ArrayList<QFilter>(10);
                bigFilters.add(new QFilter("id", "=", bizItemGroupId));
                bizItemGroup = bizItemGroupHelper.queryOne(CAL_PERIOD_TYPE, bigFilters.toArray(new QFilter[0]));
                if (Objects.nonNull(bizItemGroup)) {
                    calperiodtypeIds.add(bizItemGroup.getLong(CAL_PERIOD_TYPE_ID));
                }
            }
            QFilter payNodegrpQFilter = PayNodeHelper.getPayNodegrpQFilter(calperiodtypeIds);
            filters.add(allCfgQFilter);
            filters.add(typeQFilter);
            filters.add(payNodegrpQFilter);
            filters.add(ORGQFilter);
            payNodeDy = payNodeHelper.queryOne(FIELD_SELECT_PAY_NODE, filters.toArray(new QFilter[0]));
        }
        if (Objects.isNull(payNodeDy)) {
            return resultMap;
        }
        SWCDataServiceHelper payNodeScmHelper = new SWCDataServiceHelper("hsas_paynodescm");
        filters = PayNodeHelper.getAvailableFilters();
        filters.add(new QFilter(PAY_NODE_GRP, "=", payNodeDy.getDynamicObject(PAY_NODE_GRP).getPkValue()));
        filters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObject payNodeGrpDy = payNodeScmHelper.queryOne(FIELD_SELECT, filters.toArray(new QFilter[0]));
        if (Objects.isNull(payNodeGrpDy)) {
            return resultMap;
        }
        DynamicObjectCollection dys = payNodeGrpDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyEnt : dys) {
            String calPeriodNumber = dyEnt.getDynamicObject("calperiod").getString("number");
            if (!StringUtils.equals((CharSequence)calPeriodNumber, (CharSequence)String.valueOf(periodNumber))) continue;
            DynamicObjectCollection subDys = dyEnt.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subDyEnt : subDys) {
                if (!payNodeDy.get("paynodegrpent.id").equals(subDyEnt.get("paynode.id"))) continue;
                resultMap.put(START_TIME, subDyEnt.getDate(START_TIME));
                resultMap.put(END_TIME, subDyEnt.getDate(END_TIME));
                return resultMap;
            }
        }
        return resultMap;
    }

    private static Map<String, Object> queryPayNodeTimeCore(String id, Long bizItemGroupId, String periodNumber, DynamicObject payNodeALL, Map<Long, DynamicObject> payNodeDyMap, Map<Long, DynamicObject> payNodeGrpDyMap) {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("id", id);
        List<QFilter> filters = PayNodeHelper.getAvailableFilters();
        DynamicObject payNodeDy = payNodeDyMap.get(bizItemGroupId);
        if (Objects.isNull(payNodeDy)) {
            payNodeDy = payNodeALL;
        }
        if (Objects.isNull(payNodeDy)) {
            return resultMap;
        }
        DynamicObject payNodeGrpDy = payNodeGrpDyMap.get(payNodeDy.get("paynodegrp.id"));
        if (Objects.isNull(payNodeGrpDy)) {
            return resultMap;
        }
        DynamicObjectCollection dys = payNodeGrpDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyEnt : dys) {
            String calPeriodNumber = dyEnt.getDynamicObject("calperiod").getString("number");
            if (!StringUtils.equals((CharSequence)calPeriodNumber, (CharSequence)periodNumber)) continue;
            DynamicObjectCollection subDys = dyEnt.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subDyEnt : subDys) {
                if (!payNodeDy.get("paynodegrpent.id").equals(subDyEnt.get("paynode.id"))) continue;
                resultMap.put(START_TIME, subDyEnt.getDate(START_TIME));
                resultMap.put(END_TIME, subDyEnt.getDate(END_TIME));
                return resultMap;
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> queryPayNodeTimeBatch(List<Map<String, Object>> params) {
        HashMap<Long, List> groupOrgParams = new HashMap<Long, List>(16);
        for (Map<String, Object> param : params) {
            List groupOrgParam = groupOrgParams.computeIfAbsent(Long.parseLong(String.valueOf(param.get("orgId"))), k -> new ArrayList(10));
            groupOrgParam.add(param);
        }
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry entrySet : groupOrgParams.entrySet()) {
            Long orgId = (Long)entrySet.getKey();
            List param = (List)entrySet.getValue();
            SWCDataServiceHelper payNodeHelper = new SWCDataServiceHelper("hsas_paynode");
            List<QFilter> filters = PayNodeHelper.getAvailableFilters();
            QFilter allCfgQFilter = new QFilter(KEY_BIZALLCFG, "=", (Object)"1");
            QFilter typeQFilter = new QFilter(PAY_NODE_TYPE, "=", (Object)BIZ_HOLD);
            QFilter ORGQFilter = new QFilter(CREATE_ORG, "=", (Object)orgId);
            Set<Object> calPeriodTypeIds = param.stream().map(obj -> obj.get(CAL_PERIOD_TYPE)).collect(Collectors.toSet());
            QFilter payNodeGrpQFilter = PayNodeHelper.getPayNodegrpQFilter(calPeriodTypeIds);
            filters.add(allCfgQFilter);
            filters.add(typeQFilter);
            filters.add(payNodeGrpQFilter);
            filters.add(ORGQFilter);
            Object[] payNodes = payNodeHelper.query(FIELD_SELECT_PAY_NODE, filters.toArray(new QFilter[0]));
            Map<Object, Object> pnMap = new HashMap(16);
            ArrayList<Object> paynodegrpIds = new ArrayList<Object>(10);
            if (!SWCArrayUtils.isEmpty((Object[])payNodes)) {
                List<Object> list = Arrays.asList(payNodes);
                pnMap = list.stream().collect(Collectors.toMap(obj -> obj.getLong("paynodegrp.calperiodtype.id"), value -> value, (k1, k2) -> k2));
                paynodegrpIds.addAll(list.stream().map(item -> item.getDynamicObject(PAY_NODE_GRP).getPkValue()).collect(Collectors.toList()));
            }
            ArrayList<Long> bizItemGroupIds = new ArrayList<Long>(10);
            for (Map map : param) {
                bizItemGroupIds.add(Long.parseLong(String.valueOf(map.get("bizitemgroupid"))));
            }
            List<QFilter> filters2 = PayNodeHelper.getAvailableFilters();
            filters2.add(new QFilter("entryentity.bizitem.id", "in", bizItemGroupIds));
            DynamicObject[] payNodeDys = payNodeHelper.query(FIELD_SELECT_PAY_NODE, filters2.toArray(new QFilter[0]));
            HashMap<Long, DynamicObject> payNodeDyMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject payNodeDy : payNodeDys) {
                DynamicObjectCollection entrys = payNodeDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    payNodeDyMap.put(entry.getLong("bizitem.id"), payNodeDy);
                    paynodegrpIds.add(payNodeDy.getDynamicObject(PAY_NODE_GRP).getPkValue());
                }
            }
            SWCDataServiceHelper payNodeScmHelper = new SWCDataServiceHelper("hsas_paynodescm");
            filters = PayNodeHelper.getAvailableFilters();
            filters.add(new QFilter(PAY_NODE_GRP, "in", paynodegrpIds));
            filters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
            DynamicObject[] payNodeGrpDys = payNodeScmHelper.query(FIELD_SELECT, filters.toArray(new QFilter[0]));
            HashMap<Long, DynamicObject> payNodeGrpDyMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject payNodeGrpDy : payNodeGrpDys) {
                payNodeGrpDyMap.put(payNodeGrpDy.getLong("paynodegrp.id"), payNodeGrpDy);
            }
            for (Map map : param) {
                Object id = map.get("id");
                Object bizItemGroupId = map.get("bizitemgroupid");
                Object periodNumber = map.get("periodnumber");
                if (Objects.isNull(bizItemGroupId) || Objects.isNull(periodNumber)) {
                    throw new KDBizException("param is unexpect");
                }
                Map<String, Object> result = PayNodeHelper.queryPayNodeTimeCore(String.valueOf(id), (Long)bizItemGroupId, (String)periodNumber, (DynamicObject)pnMap.get(map.get(CAL_PERIOD_TYPE)), payNodeDyMap, payNodeGrpDyMap);
                resultList.add(result);
            }
        }
        return resultList;
    }

    public static List<QFilter> getAvailableFilters() {
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        return Lists.newArrayList((Object[])new QFilter[]{qFilterEnable, qFilterStatus});
    }

    public static DynamicObject getSameCons(DynamicObject payNode) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynode");
        if (payNode.getDynamicObject(PAY_NODE_GRP_HIS) == null) {
            return null;
        }
        if (payNode.getBoolean(KEY_BIZALLCFG)) {
            List<QFilter> filters = PayNodeHelper.getAvailableFilters();
            filters.add(new QFilter(KEY_BIZALLCFG, "=", (Object)"1"));
            filters.add(new QFilter(PAY_NODE_TYPE, "=", (Object)BIZ_HOLD));
            filters.add(new QFilter("id", "!=", payNode.getPkValue()));
            filters.add(new QFilter("createorg.id", "=", payNode.getDynamicObject(CREATE_ORG).getPkValue()));
            filters.add(PayNodeHelper.periodQFilter(payNode));
            return helper.queryOne(filters.toArray(new QFilter[0]));
        }
        return null;
    }

    private static QFilter periodQFilter(DynamicObject payNode) {
        Long calPeriodTypeId = payNode.getDynamicObject(PAY_NODE_GRP_HIS).getLong(CAL_PERIOD_TYPE_ID);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodegrp");
        QFilter qFilter = new QFilter(CAL_PERIOD_TYPE, "=", (Object)calPeriodTypeId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject[] payNodeGrp = helper.query(new QFilter[]{qFilter});
        List pkIds = Arrays.stream(payNodeGrp).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        return new QFilter("paynodegrp.id", "in", pkIds);
    }

    private static QFilter getPayNodegrpQFilter(Set<Object> calPeriodTypeIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodegrp");
        QFilter qFilter = new QFilter(CAL_PERIOD_TYPE, "in", calPeriodTypeIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject[] payNodeGrp = helper.query(new QFilter[]{qFilter});
        List pkIds = Arrays.stream(payNodeGrp).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        return new QFilter("paynodegrp.id", "in", pkIds);
    }

    public static Serializable deserialize(byte[] value) {
        return value == null ? null : (Serializable)SerializationUtils.deserialize((byte[])value);
    }

    public static Object serialize(Serializable value) {
        return SerializationUtils.serialize((Serializable)value);
    }

    public static int getOperationStatus(IFormView view) {
        if (OperationStatus.VIEW.equals((Object)view.getFormShowParameter().getStatus())) {
            return OperationStatus.VIEW.getValue();
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)view.getEntityId(), (String)"4715a0df000000ac");
        if (!permFlag) {
            return OperationStatus.VIEW.getValue();
        }
        return PayNodeHelper.getViewOperationStatusByModel(view);
    }

    private static int getViewOperationStatusByModel(IFormView view) {
        String entityId = view.getEntityId();
        if (entityId.contains("his")) {
            return PayNodeHelper.getViewOperationStatusByModelForHis(view.getModel());
        }
        return PayNodeHelper.getViewOperationStatusByModelForCurr(view.getModel());
    }

    private static int getViewOperationStatusByModelForCurr(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        String status = dataEntity.getString("status");
        if ("A".equals(status)) {
            return OperationStatus.EDIT.getValue();
        }
        return OperationStatus.VIEW.getValue();
    }

    private static int getViewOperationStatusByModelForHis(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        String status = dataEntity.getString("datastatus");
        if ("-5".equals(status)) {
            return OperationStatus.EDIT.getValue();
        }
        return OperationStatus.VIEW.getValue();
    }

    private static DynamicObjectCollection selectCalPeriods(DynamicObject payNodeScm) {
        DynamicObject calPeriodType = payNodeScm.getDynamicObject("paynodegrphis.calperiodtype");
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodWithEntity = swcDataServiceHelper.queryOne(calPeriodType.getPkValue());
        return calPeriodWithEntity.getDynamicObjectCollection("entryentity");
    }

    public static List<DynamicObject> getPeriods(IFormView view, IDataModel model, boolean isHis) {
        DynamicObjectCollection calPeriods;
        Serializable cache;
        DynamicObject payNodeScm = model.getDataEntity();
        DynamicObject startCalPeriod = payNodeScm.getDynamicObject("startcalperiod");
        DynamicObject endCalPeriod = payNodeScm.getDynamicObject("endcalperiod");
        Date bsed = payNodeScm.getDate("bsed");
        Date startCalPeriodDate = null;
        Date endCalPeriodDate = null;
        if (startCalPeriod != null) {
            startCalPeriodDate = startCalPeriod.getDate(CAL_PERIOD_START_DATE);
        }
        if (endCalPeriod != null) {
            endCalPeriodDate = endCalPeriod.getDate(CAL_PERIOD_END_DATE);
        }
        if ((cache = PayNodeCacheHelper.getFromPageCache(view, "calperiods")) == null) {
            calPeriods = PayNodeHelper.selectCalPeriods(payNodeScm);
            PayNodeCacheHelper.putToPageCache(view, "calperiods", calPeriods);
        } else {
            calPeriods = (DynamicObjectCollection)cache;
        }
        ArrayList result = Lists.newArrayList();
        for (DynamicObject calPeriod : calPeriods) {
            Date startDate = calPeriod.getDate(CAL_PERIOD_START_DATE);
            Date endDate = calPeriod.getDate(CAL_PERIOD_END_DATE);
            if (PayNodeHelper.notMatch(bsed, endCalPeriodDate, endDate, isHis) || startDate != null && startCalPeriodDate != null && startCalPeriodDate.getTime() > startDate.getTime()) continue;
            result.add(calPeriod);
        }
        return result;
    }

    private static boolean notMatch(Date bsed, Date endCalPeriodDate, Date endDate, boolean isHis) {
        if (isHis && endDate != null && bsed != null && bsed.getTime() > endDate.getTime()) {
            return true;
        }
        if (endDate == null) {
            return false;
        }
        if (endCalPeriodDate == null) {
            return false;
        }
        return endCalPeriodDate.getTime() < endDate.getTime();
    }
}

