/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payrolltask.service;

import java.util.Date;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Html;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayRollTaskSummaryService {
    private static final String AP_SUMMARY = "summaryap";
    private static final String SWC_HSAS_BUSINESS = "swc-hsas-business";
    private static final String[] firstLineSummaries = new String[]{"tasknewtplhis", "tasknewperson", "createtime"};

    private PayRollTaskSummaryService() {
    }

    public static PayRollTaskSummaryService createInstance() {
        return new PayRollTaskSummaryService();
    }

    public void setTaskSummary(Object plugin) {
        AbstractBasePlugIn currPlugin = (AbstractBasePlugIn)plugin;
        IFormView currView = currPlugin.getView();
        IDataModel currModel = currView.getModel();
        String pageId = currView.getPageId();
        IPageCache pageCache = currPlugin.getPageCache();
        Object currTask = currModel.getDataEntity().getPkValue();
        if (currTask != null && !"0".equals(String.valueOf(currTask))) {
            if (!Boolean.TRUE.toString().equals(pageCache.get(pageId + AP_SUMMARY))) {
                DynamicObject dataEntity = currModel.getDataEntity();
                StringBuilder result = new StringBuilder("<p>");
                result.append("<font style=\"font-family: MicrosoftYaHeiSemibold;font-size: 16px;color: #212121;letter-spacing: 0;line-height: 21px;font-weight: 600;\">");
                result.append(dataEntity.getString("name")).append("</font>").append("<font style=\"margin-left:12px; font-family: MicrosoftYaHei;font-size: 12px;color: #666666;letter-spacing: 0;line-height: 18px;font-weight: 400;\">");
                result.append(dataEntity.getString("number")).append("</font>");
                String taskNewMethod = dataEntity.getString("tasknewmethod");
                result.append("<font style=\"margin-left:12px; border: 1px solid rgba(102,102,102,1);border-radius: 10px;font-family: PingFangSC-Regular;font-size: 12px;color: #666666;letter-spacing: 0; padding:2px 8px 2px 8px;text-align: center;line-height: 16px;font-weight: 400;\">");
                result.append(PayRollTaskSummaryService.getShowLangInfo(taskNewMethod)).append("</font>");
                for (int i = 0; i < firstLineSummaries.length; ++i) {
                    String summaryField = firstLineSummaries[i];
                    String name = PayRollTaskSummaryService.getShowLangInfo(summaryField);
                    String value = null;
                    switch (summaryField) {
                        case "tasknewtplhis": {
                            value = dataEntity.getString("tasknewtplhis.name");
                            break;
                        }
                        case "tasknewperson": {
                            value = "2".equals(dataEntity.getString("tasknewmethod")) ? "SYSTEM" : dataEntity.getString("creator.name");
                            break;
                        }
                        case "createtime": {
                            Date date = dataEntity.getDate("createtime");
                            if (date == null) break;
                            value = HRInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"createtime", (Date)date);
                            break;
                        }
                    }
                    if (SWCStringUtils.isEmpty(value)) continue;
                    result.append("<font style=\"margin-left:24px; font-family: MicrosoftYaHei;font-size: 12px;color: #999999;letter-spacing: 1;line-height: 18px;font-weight: 400;\">");
                    result.append(name).append("&nbsp;:&nbsp;&nbsp;").append("</font>").append("<font color=\"#666666\" family=\"MicrosoftYaHei\" weight=\"400\">").append(value).append("</font>");
                }
                result.append("</p>");
                Html html = (Html)currView.getControl("livemsgm");
                html.setConent(result.toString());
                currView.setVisible(Boolean.TRUE, new String[]{AP_SUMMARY});
                currView.updateView(AP_SUMMARY);
                pageCache.put(pageId + AP_SUMMARY, Boolean.TRUE.toString());
            }
        } else {
            currView.setVisible(Boolean.FALSE, new String[]{AP_SUMMARY});
        }
    }

    public void updateSummaryCache(Object plugin) {
        AbstractBasePlugIn currPlugin = (AbstractBasePlugIn)plugin;
        currPlugin.getPageCache().put(currPlugin.getView().getPageId() + AP_SUMMARY, Boolean.FALSE.toString());
    }

    private static String getShowLangInfo(String fieldName) {
        String showLangInfo = "";
        if (fieldName == null) {
            return showLangInfo;
        }
        switch (fieldName) {
            case "1": {
                showLangInfo = ResManager.loadKDString((String)"\u7528\u6237\u521b\u5efa", (String)"PayRollTaskSummaryService_0", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "2": {
                showLangInfo = ResManager.loadKDString((String)"\u7cfb\u7edf\u521b\u5efa", (String)"PayRollTaskSummaryService_1", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "tasknewperson": {
                showLangInfo = ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"PayRollTaskSummaryService_2", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "createtime": {
                showLangInfo = ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"PayRollTaskSummaryService_3", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "tasknewtplhis": {
                showLangInfo = ResManager.loadKDString((String)"\u521b\u5efa\u6a21\u677f", (String)"PayRollTaskSummaryService_4", (String)SWC_HSAS_BUSINESS, (Object[])new Object[0]);
                break;
            }
        }
        return showLangInfo;
    }
}

