/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.enable.HisEnableParamBo;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.PaySettingUpdateProgressInfo;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingResult;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PayRuleDetailDTO;
import kd.swc.hsas.common.dto.PaySalAccountConfigDTO;
import kd.swc.hsas.common.dto.PaySalaryDTO;
import kd.swc.hsas.common.dto.PaySettingDTO;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySalarySettingHelper {
    private static final String UNLIMITED = "0";
    private static final String ALL = "0";
    private static final String OTHER = "2";
    private static final String BASE_DATA = "data";
    private static final String KEY_SALARYITEM = "entryentity.salaryitem";
    private static final String KEY_SALARYITEMMark = "entryentity.salaryitemmark";
    public static final Log logger = LogFactory.getLog(PaySalarySettingHelper.class);

    public static DynamicObject[] queryBankCardAllInfoById(Long personId) {
        return null;
    }

    public static void disableOrEnableBo(List<Long> boIdList, boolean disabled) {
        HisModelController hisModelController = new HisModelController();
        HisEnableParamBo hisEnableParamBo = new HisEnableParamBo();
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber("hsas_payaccountcfg");
        hisBaseBo.setBoIdList(boIdList);
        hisEnableParamBo.setHisBaseBo(hisBaseBo);
        hisEnableParamBo.setDisabled(disabled);
        hisModelController.disableOrEnableBo(hisEnableParamBo);
    }

    public static List<DynamicObject> queryBankCardAllInfoByPersonId(Long personId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_perbankcard");
        String selectProperties = "id,person.id,accountrelation.id,cardpurpose,sourcevid";
        QFilter filter = new QFilter("person.id", "=", (Object)personId);
        filter.and("isdelete", "=", (Object)Boolean.FALSE);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        QFilter[] filters = new QFilter[]{filter};
        return Arrays.asList(helper.query(selectProperties, filters));
    }

    public static void rebuildData(IFormView view) {
        DynamicObjectCollection entryentities = view.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryentities.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryentities.get(index);
            String salaryItemMark = dynamicObject.getString("salaryitemmark");
            Long salaryitemId = dynamicObject.getLong("salaryitem.id");
            if (!"1".equals(salaryItemMark) || salaryitemId != 0L) continue;
            dynamicObject.set("salaryitemshow", (Object)view.getPageCache().get("salaryitemmark"));
        }
        view.updateView("entryentity");
    }

    public static String getSalaryItem(String salaryItemMark) {
        if ("0".equals(salaryItemMark)) {
            salaryItemMark = ResManager.loadKDString((String)"\u5168\u90e8", (String)"PaySalarySettingHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        } else if (OTHER.equals(salaryItemMark)) {
            salaryItemMark = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"PaySalarySettingHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return salaryItemMark;
    }

    public static PaySalAccountConfigDTO getSpecialRuleDataFormPage(DynamicObjectCollection collection, String ruleContent) {
        PaySalAccountConfigDTO configDto = new PaySalAccountConfigDTO();
        List<PaySalaryDTO> list = PaySalarySettingHelper.createDefaultRuleData(collection);
        configDto.setPaySalaryDTOArrayList(list);
        PayRuleDetailDTO ruleDetailDTO = new PayRuleDetailDTO(Boolean.FALSE, ruleContent);
        configDto.setPayRuleDetailDTO(ruleDetailDTO);
        return configDto;
    }

    public static List<PaySalaryDTO> createDefaultRuleData(DynamicObjectCollection collection) {
        ArrayList<PaySalaryDTO> list = new ArrayList<PaySalaryDTO>(10);
        for (DynamicObject subData : collection) {
            Long salaryItemId = PaySalarySettingHelper.getBaseDataId(subData, "opsalaryitemdata");
            String salaryItem = PaySalarySettingHelper.getBaseDataMark(subData.getString("opsalaryitem"), salaryItemId);
            String salaryItemName = PaySalaryAccountConstants.NOTTARGET.contains(salaryItem) ? salaryItem : PaySalarySettingHelper.getBaseDataName(subData, "opsalaryitemdata");
            Long payCurrencyId = PaySalarySettingHelper.getBaseDataId(subData, "oppaycurrencydata");
            String payCurrency = PaySalarySettingHelper.getBaseDataMark(subData.getString("oppaycurrency"), payCurrencyId);
            String payCurrencyName = PaySalaryAccountConstants.NOTTARGET.contains(payCurrency) ? payCurrency : PaySalarySettingHelper.getBaseDataName(subData, "oppaycurrencydata");
            String paymentWay = subData.getString("oppaymentway");
            BigDecimal payScale = subData.getBigDecimal("oppayscale");
            BigDecimal payAmount = subData.getBigDecimal("oppayamount");
            Long paySubjectId = subData.getLong("oppaysubject.id");
            Long payType = subData.getLong("oppaytype.id");
            Long payCategoryId = subData.getLong("oppaytype.paycategory.id");
            Long bankPurposeId = PaySalarySettingHelper.getBaseDataId(subData, "opbankpurposedata");
            String bankPurpose = PaySalarySettingHelper.getBaseDataMark(subData.getString("opbankpurpose"), bankPurposeId);
            String bankPurposeName = PaySalaryAccountConstants.NOTTARGET.contains(bankPurpose) ? bankPurpose : PaySalarySettingHelper.getBaseDataName(subData, "opbankpurposedata");
            Long payrollacRelationId = PaySalarySettingHelper.getBaseDataId(subData, "oppayrollacrelationdata");
            String payrollacRelation = PaySalarySettingHelper.getBaseDataMark(subData.getString("oppayrollacrelation"), payrollacRelationId);
            String payrollacRelationName = PaySalaryAccountConstants.NOTTARGET.contains(payrollacRelation) ? payrollacRelation : PaySalarySettingHelper.getBaseDataName(subData, "oppayrollacrelationdata");
            PaySalaryDTO paySalary = new PaySalaryDTO(salaryItem, salaryItemId, payCurrency, payCurrencyId, paymentWay, payScale, payAmount, paySubjectId, payType, bankPurpose, bankPurposeId, payrollacRelation, payrollacRelationId);
            paySalary.setPayCategoryId(payCategoryId);
            paySalary.setSalaryName(salaryItemName);
            paySalary.setPayCurrencyName(payCurrencyName);
            paySalary.setBankPurposeName(bankPurposeName);
            paySalary.setPayrollacRelationName(payrollacRelationName);
            list.add(paySalary);
        }
        return list;
    }

    public static PaySalAccountConfigDTO getSpecialRuleDataToCache(DynamicObjectCollection collection, String ruleContent) {
        List<PaySalaryDTO> list = PaySalarySettingHelper.createSpecialRuleData(collection);
        PaySalAccountConfigDTO configDto = new PaySalAccountConfigDTO();
        configDto.setPaySalaryDTOArrayList(list);
        PayRuleDetailDTO ruleDetailDTO = new PayRuleDetailDTO(Boolean.FALSE, ruleContent);
        configDto.setPayRuleDetailDTO(ruleDetailDTO);
        return configDto;
    }

    public static List<PaySalaryDTO> createSpecialRuleData(DynamicObjectCollection collection) {
        ArrayList<PaySalaryDTO> list = new ArrayList<PaySalaryDTO>(10);
        for (DynamicObject subData : collection) {
            Long salaryItemId = PaySalarySettingHelper.getBaseDataId(subData, "salaryitemdata");
            String salaryItem = PaySalarySettingHelper.getBaseDataMark(subData.getString("salaryitem"), salaryItemId);
            String salaryItemName = PaySalaryAccountConstants.NOTTARGET.contains(salaryItem) ? salaryItem : PaySalarySettingHelper.getBaseDataName(subData, "salaryitemdata");
            Long payCurrencyId = PaySalarySettingHelper.getBaseDataId(subData, "paycurrencydata");
            String payCurrency = PaySalarySettingHelper.getBaseDataMark(subData.getString("paycurrency"), payCurrencyId);
            String payCurrencyName = PaySalaryAccountConstants.NOTTARGET.contains(payCurrency) ? payCurrency : PaySalarySettingHelper.getBaseDataName(subData, "paycurrencydata");
            String paymentWay = subData.getString("paymentway");
            BigDecimal payScale = subData.getBigDecimal("payscale");
            BigDecimal payAmount = subData.getBigDecimal("payamount");
            Long paySubjectId = subData.getLong("paysubject.id");
            Long payType = subData.getLong("paytype.id");
            Long payCategoryId = subData.getLong("paytype.paycategory.id");
            Long bankPurposeId = PaySalarySettingHelper.getBaseDataId(subData, "bankpurposedata");
            String bankPurpose = PaySalarySettingHelper.getBaseDataMark(subData.getString("bankpurpose"), bankPurposeId);
            String bankPurposeName = PaySalaryAccountConstants.NOTTARGET.contains(bankPurpose) ? bankPurpose : PaySalarySettingHelper.getBaseDataName(subData, "bankpurposedata");
            Long payrollacRelationId = PaySalarySettingHelper.getBaseDataId(subData, "payrollacrelationdata");
            String payrollacRelation = PaySalarySettingHelper.getBaseDataMark(subData.getString("payrollacrelation"), payrollacRelationId);
            String payrollacRelationName = PaySalaryAccountConstants.NOTTARGET.contains(payrollacRelation) ? payrollacRelation : PaySalarySettingHelper.getBaseDataName(subData, "payrollacrelationdata");
            PaySalaryDTO paySalary = new PaySalaryDTO(salaryItem, salaryItemId, payCurrency, payCurrencyId, paymentWay, payScale, payAmount, paySubjectId, payType, bankPurpose, bankPurposeId, payrollacRelation, payrollacRelationId);
            paySalary.setPayCategoryId(payCategoryId);
            paySalary.setSalaryName(salaryItemName);
            paySalary.setPayCurrencyName(payCurrencyName);
            paySalary.setBankPurposeName(bankPurposeName);
            paySalary.setPayrollacRelationName(payrollacRelationName);
            list.add(paySalary);
        }
        return list;
    }

    public static void setSpecialRuleDataToPage(PaySalAccountConfigDTO dto, IFormView view) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter = PaySalarySettingHelper.createTableSetter(setter);
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        List paySalaryDTOList = dto.getPaySalaryDTOArrayList();
        model.beginInit();
        for (PaySalaryDTO paySalaryDTO : paySalaryDTOList) {
            setter.addRow(new Object[]{paySalaryDTO.getSalaryName(), paySalaryDTO.getSalaryItem(), paySalaryDTO.getSalaryItemId(), paySalaryDTO.getPayCurrencyName(), paySalaryDTO.getPayCurrency(), paySalaryDTO.getPayCurrencyId(), paySalaryDTO.getPaymentWay(), paySalaryDTO.getPayScale(), paySalaryDTO.getPayAmount(), paySalaryDTO.getPaySubjectId(), paySalaryDTO.getPayType(), paySalaryDTO.getBankPurposeName(), paySalaryDTO.getBankPurpose(), paySalaryDTO.getBankPurposeId(), paySalaryDTO.getPayrollacRelationName(), paySalaryDTO.getPayrollacRelation(), paySalaryDTO.getPayrollacRelationId()});
        }
        model.batchCreateNewEntryRow("opentryentity", setter);
        model.endInit();
        view.updateView("opentryentity");
    }

    public static void setSpecialRuleDataToSubEntry(int seq, PaySalAccountConfigDTO dto, IFormView view) {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter = PaySalarySettingHelper.createSaveTableSetter(setter);
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        List paySalaryDTOList = dto.getPaySalaryDTOArrayList();
        AbstractFormDataModel entryOperate = model;
        entryOperate.setEntryCurrentRowIndex("specialentryentity", seq);
        entryOperate.deleteEntryData("subentryentity");
        model.beginInit();
        for (PaySalaryDTO paySalaryDTO : paySalaryDTOList) {
            setter.addRow(new Object[]{paySalaryDTO.getSalaryItem(), paySalaryDTO.getSalaryItemId(), paySalaryDTO.getPayCurrency(), paySalaryDTO.getPayCurrencyId(), paySalaryDTO.getPaymentWay(), paySalaryDTO.getPayScale(), paySalaryDTO.getPayAmount(), paySalaryDTO.getPaySubjectId(), paySalaryDTO.getPayType(), paySalaryDTO.getBankPurpose(), paySalaryDTO.getBankPurposeId(), paySalaryDTO.getPayrollacRelation(), paySalaryDTO.getPayrollacRelationId()});
        }
        model.batchCreateNewEntryRow("subentryentity", setter);
        model.endInit();
        view.updateView("subentryentity");
    }

    public static DynamicObject getAuditAndEnableData(Long useOrgID, Long countryId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hsas_payaccountcfg", (Long)useOrgID);
        QFilter countryFilter = new QFilter("country.id", "=", (Object)countryId);
        if (orgFilter != null) {
            countryFilter.and(orgFilter);
        }
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        String selectFields = "id,sourcevid,name,useorg,country,opsalaryitem,opsalaryitemdata,oppaymentway,oppaytype,oppayscale,oppayamount,oppaycurrency,oppaycurrencydata,oppaysubject,opentryentity.opbankpurpose,opbankpurposedata,oppayrollacrelation,oppayrollacrelationdata,rulecontent,salaryitem,salaryitemdata,paycurrency,paycurrencydata,paymentway,payscale,payamount,paysubject,paytype,bankpurpose,bankpurposedata,payrollacrelation,payrollacrelationdata";
        return serviceHelper.queryOne(selectFields, new QFilter[]{statusFilter, enableFilter, countryFilter, hisCurrFilter});
    }

    public static DynamicObject getSalaryFileCalCurrency(Long payRollGroupId) {
        SWCDataServiceHelper payRollGroupHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter payRollGroupFilter = new QFilter("id", "=", (Object)payRollGroupId);
        payRollGroupFilter.and("iscurrentversion", "=", (Object)"1");
        return payRollGroupHelper.queryOne("currency.id,currency.name,currency.amtprecision", new QFilter[]{payRollGroupFilter}).getDynamicObject("currency");
    }

    public static DynamicObject querySalaryFileInfoById(long salaryFileId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter qFilter = new QFilter("id", "=", (Object)salaryFileId);
        return serviceHelper.queryOne("org,payrollregion,number,person,adminorg,depcytype.name,empgroup.name,payrollgroup,laborrelrecord.lawentity.name", new QFilter[]{qFilter});
    }

    public static DynamicObject getAuditAndEnableData(QFilter[] qFilters) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payaccountcfg");
        return serviceHelper.queryOne("id,name,useorg,country", qFilters);
    }

    public static String getSalaryItemName(DynamicObject row) {
        row.getDynamicObject(KEY_SALARYITEM);
        String salaryItemMark = row.getString(KEY_SALARYITEMMark);
        String salaryItemShow = row.getDynamicObject(KEY_SALARYITEM) == null ? PaySalarySettingHelper.getSalaryItem(salaryItemMark) : row.getDynamicObject(KEY_SALARYITEM).getString("name");
        return salaryItemShow;
    }

    public static String getFilterGridap(IFormView view) {
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        List relFilters = condition.getFilterRow();
        String data = "";
        if (relFilters != null && relFilters.size() > 0) {
            data = SerializationUtils.toJsonString((Object)condition);
        }
        return data;
    }

    public static void getSalaryFilePersonRangeRule(DynamicObject payRule, List<Long> salaryFileIdList, Map<Long, PersonRangeDTO> personFileInfo) {
        if (CollectionUtils.isEmpty(salaryFileIdList) || payRule == null) {
            return;
        }
        HashSet<String> fieldSet = new HashSet<String>(16);
        DynamicObjectCollection specialEntityCol = payRule.getDynamicObjectCollection("specialentryentity");
        if (CollectionUtils.isEmpty((Collection)specialEntityCol)) {
            return;
        }
        for (DynamicObject specialEntity : specialEntityCol) {
            String ruleContent = specialEntity.getString("rulecontent");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleContent, FilterCondition.class);
            for (SimpleFilterRow row : filterCondition.getFilterRow()) {
                fieldSet.add(row.getFieldName());
            }
        }
        QFilter filter = new QFilter("id", "in", salaryFileIdList);
        QueryEntityType entityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_payaccountpersonquery");
        DynamicObjectCollection dyoColl = HRQueryEntityHelper.getInstance().getQueryDyoColl(entityType, "id," + String.join((CharSequence)",", fieldSet), new QFilter[]{filter}, "");
        for (DynamicObject dy : dyoColl) {
            Long salaryFileId = dy.getLong("id");
            PersonRangeDTO personRange = new PersonRangeDTO();
            fieldSet.forEach(field -> personRange.addDtoNameLangMap(field, dy.get(field)));
            personFileInfo.put(salaryFileId, personRange);
        }
    }

    public static List<PaySettingDTO> createPaySettingData(DynamicObjectCollection collection) {
        ArrayList<PaySettingDTO> list = new ArrayList<PaySettingDTO>(10);
        for (DynamicObject subData : collection) {
            Long salaryItemId = subData.getLong("salaryitem.id");
            String salaryItem = subData.getString("salaryitemmark");
            String salaryItemName = subData.getString("salaryitemshow");
            Long payCurrencyId = subData.getLong("currency.id");
            String paymentWay = subData.getString("paymentway");
            BigDecimal payScale = subData.getBigDecimal("payrate");
            BigDecimal payAmount = subData.getBigDecimal("payamount");
            Long paySubjectId = subData.getLong("paysubject.id");
            Long payType = subData.getLong("paytype.id");
            Long perBankCardId = subData.getLong("perbankcard.id");
            PaySettingDTO paySetting = new PaySettingDTO(salaryItem, salaryItemId, salaryItemName, payCurrencyId, paymentWay, payScale, payAmount, paySubjectId, payType, perBankCardId);
            list.add(paySetting);
        }
        return list;
    }

    public static TableValueSetter createTableSetter(TableValueSetter setter) {
        setter.addField("opsalaryitemshow", new Object[0]);
        setter.addField("opsalaryitem", new Object[0]);
        setter.addField("opsalaryitemdata", new Object[0]);
        setter.addField("oppaycurrencyshow", new Object[0]);
        setter.addField("oppaycurrency", new Object[0]);
        setter.addField("oppaycurrencydata", new Object[0]);
        setter.addField("oppaymentway", new Object[0]);
        setter.addField("oppayscale", new Object[0]);
        setter.addField("oppayamount", new Object[0]);
        setter.addField("oppaysubject", new Object[0]);
        setter.addField("oppaytype", new Object[0]);
        setter.addField("opbankpurposeshow", new Object[0]);
        setter.addField("opbankpurpose", new Object[0]);
        setter.addField("opbankpurposedata", new Object[0]);
        setter.addField("oppayrollacrelationshow", new Object[0]);
        setter.addField("oppayrollacrelation", new Object[0]);
        setter.addField("oppayrollacrelationdata", new Object[0]);
        return setter;
    }

    public static TableValueSetter createSaveTableSetter(TableValueSetter setter) {
        setter.addField("salaryitem", new Object[0]);
        setter.addField("salaryitemdata", new Object[0]);
        setter.addField("paycurrency", new Object[0]);
        setter.addField("paycurrencydata", new Object[0]);
        setter.addField("paymentway", new Object[0]);
        setter.addField("payscale", new Object[0]);
        setter.addField("payamount", new Object[0]);
        setter.addField("paysubject", new Object[0]);
        setter.addField("paytype", new Object[0]);
        setter.addField("bankpurpose", new Object[0]);
        setter.addField("bankpurposedata", new Object[0]);
        setter.addField("payrollacrelation", new Object[0]);
        setter.addField("payrollacrelationdata", new Object[0]);
        return setter;
    }

    public static int[] getDeleteRowIndexes(int deleteNum) {
        int[] deleteIndexes = new int[deleteNum];
        for (int i = 0; i < deleteNum; ++i) {
            deleteIndexes[i] = i;
        }
        return deleteIndexes;
    }

    public static Long getBaseDataId(DynamicObject paySalary, String key) {
        Long baseDataId = 0L;
        if (paySalary.get(key) != null) {
            baseDataId = paySalary.getLong(key + ".id");
        }
        return baseDataId;
    }

    private static String getBaseDataMark(String mark, Long baseDataId) {
        if (PaySalaryAccountConstants.NOTTARGET.contains(mark) && baseDataId == 0L) {
            return mark;
        }
        return "1";
    }

    public static String getBaseDataName(DynamicObject paySalary, String key) {
        String baseDataName = null;
        if (paySalary.get(key) != null) {
            baseDataName = paySalary.getString(key + ".name");
        }
        return baseDataName;
    }

    public static synchronized void updatePaySettingProgressInfo(ISWCAppCache appCache, String recordId, UpdatePaySettingResult result) {
        String format = String.format(Locale.ROOT, "paySettingUpdateProgress_%s", recordId);
        PaySettingUpdateProgressInfo progressInfo = (PaySettingUpdateProgressInfo)appCache.get(format, PaySettingUpdateProgressInfo.class);
        if (progressInfo == null) {
            return;
        }
        int finishCount = progressInfo.getFinish();
        int fail = progressInfo.getFail();
        int success = progressInfo.getSuccess();
        int successSize = result.getSuccessNum();
        int finishNum = result.getFinishNum();
        int failNum = result.getFailNum();
        progressInfo.setFinish(finishCount + finishNum);
        progressInfo.setSuccess(success + successSize);
        progressInfo.setFail(fail + failNum);
        ArrayList<Long> successIdList = progressInfo.getSuccessIdList();
        ArrayList<UpdateErrorResult> errorResultList = progressInfo.getErrorResultList();
        successIdList = SWCListUtils.isEmpty(successIdList) ? new ArrayList<Long>() : successIdList;
        errorResultList = SWCListUtils.isEmpty(errorResultList) ? new ArrayList<UpdateErrorResult>() : errorResultList;
        successIdList.addAll(result.getSuccessIdList());
        errorResultList.addAll(result.getErrorList());
        progressInfo.setSuccessIdList(successIdList);
        progressInfo.setErrorResultList(errorResultList);
        logger.info("ErrorResultListSize\uff1a{}", (Object)errorResultList.size());
        logger.info("SuccessIdListSize\uff1a{}", (Object)successIdList.size());
        int status = progressInfo.getTotal() == progressInfo.getFinish() ? 2 : 1;
        progressInfo.setStatus(status);
        appCache.put(format, (Object)progressInfo);
        String floatingTaskId = (String)appCache.get(String.format(Locale.ROOT, "paySettingUpdateJob_%s", recordId), String.class);
        HRBackgroundTaskHelper.getInstance().feedbackProgress(floatingTaskId, (progressInfo.getSuccess() + progressInfo.getFail()) * 100 / progressInfo.getTotal(), "", null);
    }

    public static Map<Long, Set<Long>> getPayRollGroupAndItemMap(Set<Long> payRollGroupIdList) {
        HashSet<Long> calRuleIdSet = new HashSet<Long>(16);
        Map<Long, Set<Long>> payRollGroupAndCalRuleMap = PaySalarySettingHelper.getCalRuleByGroup(payRollGroupIdList, calRuleIdSet);
        return PaySalarySettingHelper.getSalaryItemIdByCalRule(payRollGroupAndCalRuleMap, calRuleIdSet);
    }

    private static Map<Long, Set<Long>> getCalRuleByGroup(Set<Long> payRollGroupIdList, Set<Long> calRuleAllIdSet) {
        HashMap<Long, Set<Long>> payRollGroupAndCalRuleMap = new HashMap<Long, Set<Long>>(16);
        if (CollectionUtils.isEmpty(payRollGroupIdList)) {
            return payRollGroupAndCalRuleMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter idQFilter = new QFilter("id", "in", payRollGroupIdList);
        DynamicObject[] payRollSceneDyArray = helper.query("id,payrollsceneentry,payrollsceneentry.payrollscene", new QFilter[]{idQFilter});
        if (payRollSceneDyArray.length == 0) {
            return payRollGroupAndCalRuleMap;
        }
        for (DynamicObject dy : payRollSceneDyArray) {
            HashSet<Long> calRuleIdSet = new HashSet<Long>(16);
            long payRollGroupId = dy.getLong("id");
            DynamicObjectCollection payRollSceneEntry = dy.getDynamicObjectCollection("payrollsceneentry");
            for (DynamicObject entry : payRollSceneEntry) {
                long payRollSceneId = entry.getLong("payrollscene.calrule.id");
                calRuleIdSet.add(payRollSceneId);
                calRuleAllIdSet.add(payRollSceneId);
            }
            payRollGroupAndCalRuleMap.put(payRollGroupId, calRuleIdSet);
        }
        return payRollGroupAndCalRuleMap;
    }

    public static Map<Long, Set<Long>> getSalaryItemIdByCalRule(Map<Long, Set<Long>> payRollGroupAndCalRuleMap, Set<Long> calRuleAllIdSet) {
        HashMap<Long, Set<Long>> payRollGroupAndSalaryItemMap = new HashMap<Long, Set<Long>>(16);
        if (CollectionUtils.isEmpty(payRollGroupAndCalRuleMap)) {
            return payRollGroupAndSalaryItemMap;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter idQFilter = new QFilter("boid", "in", calRuleAllIdSet);
        DynamicObject[] calRuleDyArray = helper.query("id,boid,calruleitementry,calruleitementry.salaryitem,calruleitementry.ispayoutitem", new QFilter[]{idQFilter});
        HashMap<Long, Set> calRuleAndSalaryItemMap = new HashMap<Long, Set>(calRuleDyArray.length);
        for (DynamicObject calRule : calRuleDyArray) {
            Long calRuleId = calRule.getLong("boid");
            Set salaryIdSet = calRuleAndSalaryItemMap.getOrDefault(calRuleId, new HashSet(16));
            DynamicObjectCollection calRuleEntryColl = calRule.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject calRuleEntryDy : calRuleEntryColl) {
                String isPayOutItem = calRuleEntryDy.getString("ispayoutitem");
                if (!SWCStringUtils.equals((String)isPayOutItem, (String)"1")) continue;
                long salaryId = calRuleEntryDy.getLong("salaryitem.id");
                salaryIdSet.add(salaryId);
            }
            calRuleAndSalaryItemMap.put(calRuleId, salaryIdSet);
        }
        payRollGroupAndCalRuleMap.forEach((groupId, ruleIdSet) -> ruleIdSet.forEach(ruleId -> {
            Set salaryIdGroupSet = payRollGroupAndSalaryItemMap.getOrDefault(groupId, new HashSet(16));
            salaryIdGroupSet.addAll((Collection)calRuleAndSalaryItemMap.get(ruleId));
            payRollGroupAndSalaryItemMap.put((Long)groupId, salaryIdGroupSet);
        }));
        return payRollGroupAndSalaryItemMap;
    }
}

