/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paycfgrule.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsas.business.paysalarysetting.paycfgrule.validator.PaySettingRuleBaseValidator;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;

public class PaySettingRuleRateValidator
extends PaySettingRuleBaseValidator {
    @Override
    List<String> validator(DynamicObject paySetting) {
        DynamicObjectCollection paySettingEntryCol = paySetting.getDynamicObjectCollection("opentryentity");
        ArrayList<String> errMsg = new ArrayList<String>(10);
        HashSet<Object> isAmountSet = new HashSet<Object>(16);
        HashMap<Object, BigDecimal> payRateMap = new HashMap<Object, BigDecimal>(16);
        HashMap<Long, String> salaryItemIdMapName = new HashMap<Long, String>(16);
        for (DynamicObject entryData : paySettingEntryCol) {
            String salaryItemMark = entryData.getString("opsalaryitem");
            boolean bl = !PaySalaryAccountConstants.NOTTARGET.contains(salaryItemMark);
            String paymentWay = entryData.getString("oppaymentway");
            long salaryItemId = entryData.getLong("opsalaryitemdata.id");
            String salaryItemName = entryData.getString("opsalaryitemdata.name");
            if (bl) {
                salaryItemIdMapName.put(salaryItemId, salaryItemName);
            }
            if ("0".equals(paymentWay)) {
                BigDecimal payRateTotal;
                BigDecimal payRate = entryData.getBigDecimal("oppayscale");
                if (bl) {
                    payRateTotal = payRateMap.get(salaryItemId) != null ? (BigDecimal)payRateMap.get(salaryItemId) : BigDecimal.ZERO;
                    payRateMap.put(salaryItemId, payRateTotal.add(payRate));
                    continue;
                }
                payRateTotal = payRateMap.get(salaryItemMark) != null ? (BigDecimal)payRateMap.get(salaryItemMark) : BigDecimal.ZERO;
                payRateMap.put(salaryItemMark, payRateTotal.add(payRate));
                continue;
            }
            isAmountSet.add(bl ? Long.valueOf(salaryItemId) : salaryItemMark);
        }
        Set isProportionSet = payRateMap.keySet();
        Set isNotProportionSet = isAmountSet.stream().filter(obj -> !isProportionSet.contains(obj)).collect(Collectors.toSet());
        for (Object t : isNotProportionSet) {
            if ("0".equals(t)) {
                errMsg.add(ResManager.loadKDString((String)"\u85aa\u916c\u5b9e\u53d1\u9879\u76ee\u4ec5\u8bbe\u7f6e\u4e86\u6307\u5b9a\u91d1\u989d\u53d1\u653e\uff0c\u8bf7\u4e3a\u5269\u4f59\u6b3e\u9879\u8bbe\u7f6e\u6307\u5b9a\u6bd4\u4f8b\u53d1\u653e\uff08\u6bd4\u4f8b\u548c100%\uff09\u3002", (String)"PaySettingRuleRateValidator_0", (String)"swc-hsas-business", (Object[])new Object[0]));
                continue;
            }
            if ("2".equals(t)) {
                errMsg.add(ResManager.loadKDString((String)"\u201c\u5176\u4ed6\u201d\u9879\u4ec5\u8bbe\u7f6e\u4e86\u6307\u5b9a\u91d1\u989d\u53d1\u653e\uff0c\u8bf7\u4e3a\u5269\u4f59\u6b3e\u9879\u8bbe\u7f6e\u6307\u5b9a\u6bd4\u4f8b\u53d1\u653e\uff0c\u6bd4\u4f8b\u548c100%\u3002", (String)"PaySettingRuleRateValidator_1", (String)"swc-hsas-business", (Object[])new Object[0]));
                continue;
            }
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c%s\u201d\u4ec5\u8bbe\u7f6e\u4e86\u6307\u5b9a\u91d1\u989d\u53d1\u653e\uff0c\u8bf7\u4e3a\u5269\u4f59\u6b3e\u9879\u8bbe\u7f6e\u6307\u5b9a\u6bd4\u4f8b\u53d1\u653e\uff08\u6bd4\u4f8b\u548c100%%)\u3002", (String)"PaySettingRuleRateValidator_2", (String)"swc-hsas-business", (Object[])new Object[0]), salaryItemIdMapName.get((Long)t)));
        }
        for (Map.Entry entry : payRateMap.entrySet()) {
            Object mark = entry.getKey();
            BigDecimal hundred = new BigDecimal(100);
            BigDecimal payRate = (BigDecimal)entry.getValue();
            if (hundred.compareTo(payRate) == 0) continue;
            if ("0".equals(mark)) {
                errMsg.add(ResManager.loadKDString((String)"\u201c\u85aa\u916c\u9879\u76ee\u201d\u7684\u53d1\u653e\u6bd4\u4f8b\u9700\u8981\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PaySettingRuleRateValidator_3", (String)"swc-hsas-business", (Object[])new Object[0]));
                continue;
            }
            if ("2".equals(mark)) {
                errMsg.add(ResManager.loadKDString((String)"\u201c\u5176\u4ed6\u201d\u9879\u7684\u53d1\u653e\u6bd4\u4f8b\u9700\u8981\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PaySettingRuleRateValidator_4", (String)"swc-hsas-business", (Object[])new Object[0]));
                continue;
            }
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c%s\u201d\u7684\u53d1\u653e\u6bd4\u4f8b\u4e0d\u7b49\u4e8e100%%\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PaySettingRuleRateValidator_5", (String)"swc-hsas-business", (Object[])new Object[0]), salaryItemIdMapName.get((Long)mark)));
        }
        if (errMsg.isEmpty() && this.getNextValidator() != null) {
            return this.getNextValidator().validator(paySetting);
        }
        return errMsg;
    }
}

