/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paycfgrule.validator;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsas.business.paysalarysetting.paycfgrule.validator.PaySettingRuleBaseValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySettingRuleRuleAmountAccuracyValidator
extends PaySettingRuleBaseValidator {
    @Override
    List<String> validator(DynamicObject paySetting) {
        DynamicObjectCollection paySettingEntryCol = paySetting.getDynamicObjectCollection("opentryentity");
        ArrayList<String> errMsg = new ArrayList<String>(10);
        for (int index = 0; index < paySettingEntryCol.size(); ++index) {
            DynamicObject entryData = (DynamicObject)paySettingEntryCol.get(index);
            String paymentWay = entryData.getString("oppaymentway");
            String payCurrency = entryData.getString("oppaycurrency");
            if (!SWCStringUtils.equals((String)"1", (String)paymentWay) || "0".equals(payCurrency)) continue;
            String currencyName = entryData.getString("oppaycurrencydata.name");
            BigDecimal payAmount = entryData.getBigDecimal("oppayamount");
            int payAmountScale = payAmount.stripTrailingZeros().scale();
            int scale = entryData.getInt("oppaycurrencydata.amtprecision");
            if (scale >= payAmountScale) continue;
            errMsg.add(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u7b2c{1}\u884c\uff1a\u60a8\u8f93\u5165\u7684\u53d1\u653e\u91d1\u989d\u4e0e{2}\u91d1\u989d\u7cbe\u5ea6\u8981\u6c42({3}\u4f4d\u5c0f\u6570\uff09\u4e0d\u5339\u914d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PaySettingRuleRuleAmountAccuracyValidator_0", (String)"swc-hsas-business", (Object[])new Object[0]), this.getEntityName(), index + 1, currencyName, scale));
        }
        if (errMsg.isEmpty() && this.getNextValidator() != null) {
            return this.getNextValidator().validator(paySetting);
        }
        return errMsg;
    }
}

