/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paysetting.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingResult;
import kd.swc.hsas.business.paysalarysetting.paysetting.thread.UpdatePaySettingThread;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;

public class PaySettingBatchThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(PaySettingBatchThread.class);
    private static final int DEFAULT_COUNT = 5000;
    private RequestContext requestContext;
    private String recordId;
    private List<Long> salaryFileIdList;
    private Boolean isHandUpdateBankCard;

    public PaySettingBatchThread(RequestContext requestContext, String recordId, List<Long> salaryFileIdList, Boolean isHandUpdateBankCard) {
        this.requestContext = requestContext;
        this.recordId = recordId;
        this.salaryFileIdList = salaryFileIdList;
        this.isHandUpdateBankCard = isHandUpdateBankCard;
    }

    public PaySettingBatchThread(RequestContext requestContext, List<Long> salaryFileIdList, Boolean isHandUpdateBankCard) {
        this.requestContext = requestContext;
        this.salaryFileIdList = salaryFileIdList;
        this.isHandUpdateBankCard = isHandUpdateBankCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        List salaryFileIdSplit = SWCListUtils.split(this.salaryFileIdList, (int)5000);
        ArrayList futureList = new ArrayList(salaryFileIdSplit.size());
        UpdatePaySettingResult result = UpdatePaySettingResult.getInstance();
        CountDownLatch latch = new CountDownLatch(salaryFileIdSplit.size());
        salaryFileIdSplit.forEach(file -> {
            UpdatePaySettingThread updatePaySettingThread = new UpdatePaySettingThread(this.requestContext, this.recordId, latch, (List<Long>)file, this.isHandUpdateBankCard);
            Future errorResult = SWCThreadPoolFactory.getPaysettingUpdateThreadpool().submit((Callable)updatePaySettingThread);
            futureList.add(errorResult);
        });
        boolean isSuccess = false;
        try {
            isSuccess = latch.await(5 * salaryFileIdSplit.size(), TimeUnit.SECONDS);
            if (isSuccess) {
                futureList.forEach(e -> {
                    try {
                        result.addResult((UpdatePaySettingResult)e.get());
                    }
                    catch (Exception e1) {
                        logger.error("Update PaySetting : {}", (Object)e1.getMessage());
                    }
                });
            }
        }
        catch (InterruptedException e2) {
            logger.error("Update PaySetting : {}", (Object)e2.getMessage());
        }
        finally {
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
            appCache.put("updatepaysettinglock", (Object)"0");
        }
    }

    public UpdatePaySettingResult synRun() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        List salaryFileIdSplit = SWCListUtils.split(this.salaryFileIdList, (int)5000);
        UpdatePaySettingResult result = UpdatePaySettingResult.getInstance();
        try {
            for (List salaryFileIdList : salaryFileIdSplit) {
                UpdatePaySettingThread updatePaySettingThread = new UpdatePaySettingThread(this.requestContext, this.recordId, null, salaryFileIdList, this.isHandUpdateBankCard);
                result.addResult(updatePaySettingThread.call());
            }
        }
        catch (Exception e) {
            logger.error("Update PaySetting error:{}", (Object)e.getMessage());
        }
        return result;
    }
}

