/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.paysalarysetting.paysetting.updateobject;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.ErrorResultObserver;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingErrorEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.updateobject.BasePaySettingStrategy;
import kd.swc.hsas.common.constants.PaySalaryAccountConstants;
import kd.swc.hsas.common.dto.PaySalaryDTO;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.GeneralFilterCompareService;

public class UpdateCoverStrategy
extends BasePaySettingStrategy {
    private static final Log logger = LogFactory.getLog(UpdateCoverStrategy.class);
    private static Set<String> ignoreFields = new HashSet<String>(16);

    public UpdateCoverStrategy(ErrorResultObserver observer) {
        this.OBSERVER = observer;
    }

    @Override
    public boolean strategyMethod(UpdatePaySettingDTO updatePaySettingDTO) {
        DynamicObject paySettingRule = updatePaySettingDTO.getPaySettingRule();
        DynamicObject paySetting = updatePaySettingDTO.getPaySetting();
        DynamicObject salaryFile = updatePaySettingDTO.getSalaryFile();
        Set<Long> salaryItemSet = updatePaySettingDTO.getSalaryItem();
        UpdatePaySettingErrorEnum reasonWarning = null;
        if (paySettingRule == null) {
            String orgName = salaryFile.getString("org.name");
            String countryName = salaryFile.getString("payrollregion.name");
            String reason = UpdatePaySettingErrorEnum.NOT_PAY_RULE.getDesc();
            this.OBSERVER.setErrorResult(salaryFile, MessageFormat.format(reason, orgName, countryName), UpdatePaySettingErrorEnum.NOT_PAY_RULE);
            return false;
        }
        List<PaySalaryDTO> matchRuleList = this.matchRule(paySettingRule, updatePaySettingDTO.getPersonRange());
        if (matchRuleList == null || matchRuleList.isEmpty()) {
            this.OBSERVER.setErrorResult(salaryFile, UpdatePaySettingErrorEnum.NOT_MATCH_RULE);
            return false;
        }
        List unCanSalaryIdList = matchRuleList.stream().filter(rule -> rule.getSalaryItemId() != 0L && (salaryItemSet == null || !salaryItemSet.contains(rule.getSalaryItemId()))).collect(Collectors.toList());
        if (!unCanSalaryIdList.isEmpty()) {
            Set nameSet = unCanSalaryIdList.stream().map(PaySalaryDTO::getSalaryName).collect(Collectors.toSet());
            String reason = UpdatePaySettingErrorEnum.SALARY_ITEM_UNUSE.getDesc();
            this.OBSERVER.setErrorResult(salaryFile, MessageFormat.format(reason, String.join((CharSequence)"\u3001", nameSet)), UpdatePaySettingErrorEnum.SALARY_ITEM_UNUSE);
            return false;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paysetting");
        DynamicObjectCollection dynamicObjectCollection = helper.genEmptyEntryCollection(paySetting, "entryentity");
        for (int index = 0; index < matchRuleList.size(); ++index) {
            PaySalaryDTO matchRule = matchRuleList.get(index);
            Long payCategoryId = matchRule.getPayCategoryId();
            Long relationId = matchRule.getPayrollacRelationId();
            Long bankPurposeId = matchRule.getBankPurposeId();
            Long perBankCardId = 0L;
            String payCurrencyMark = matchRule.getPayCurrency();
            String paymentWay = matchRule.getPaymentWay();
            if ("0".equals(payCurrencyMark)) {
                DynamicObject calCurrency = updatePaySettingDTO.getCalCurrency();
                matchRule.setPayCurrencyId(Long.valueOf(calCurrency.getLong("id")));
                if ("1".equals(paymentWay)) {
                    BigDecimal payAmount = matchRule.getPayAmount();
                    String currencyName = calCurrency.getString("name");
                    int payAmountScale = payAmount.stripTrailingZeros().scale();
                    int scale = calCurrency.getInt("amtprecision");
                    if (scale < payAmountScale) {
                        String reason = UpdatePaySettingErrorEnum.AMOUNT_ACCURACY.getDesc();
                        this.OBSERVER.setErrorResult(salaryFile, MessageFormat.format(reason, currencyName, scale), UpdatePaySettingErrorEnum.AMOUNT_ACCURACY);
                        return false;
                    }
                }
            }
            if (PaySalaryAccountConstants.NEEDBANKCARDIDS.contains(payCategoryId)) {
                Set<Long> perBankCardSet = this.matchPerBankCard(bankPurposeId, relationId, updatePaySettingDTO.getPerBankCardList());
                if (reasonWarning == null && perBankCardSet.isEmpty()) {
                    reasonWarning = UpdatePaySettingErrorEnum.NOT_BANK_CARD;
                }
                if (reasonWarning == null && perBankCardSet.size() > 1) {
                    reasonWarning = UpdatePaySettingErrorEnum.MORE_BANK_CARD;
                }
                perBankCardId = perBankCardSet.size() == 1 ? perBankCardSet.iterator().next() : Long.valueOf(0L);
            }
            dynamicObjectCollection.add((Object)this.updatePaySetting(helper, matchRule, index, perBankCardId));
        }
        if (!this.isChange(paySetting, dynamicObjectCollection)) {
            this.OBSERVER.setErrorResult(salaryFile, ErrorLevel.Warning, UpdatePaySettingErrorEnum.NOT_UPDATE_RULE);
            return false;
        }
        if (reasonWarning != null) {
            this.OBSERVER.setErrorResult(salaryFile, ErrorLevel.Warning, reasonWarning);
        }
        paySetting.set("entryentity", (Object)dynamicObjectCollection);
        paySetting.set("ismanuallymodify", (Object)Boolean.FALSE);
        paySetting.set("payrule", (Object)this.getDynamicObjectById("hsas_payaccountcfg", paySettingRule.getLong("sourcevid")));
        updatePaySettingDTO.setPaySetting(paySetting);
        return true;
    }

    private boolean isChange(DynamicObject paySetting, DynamicObjectCollection dynamicObjectCollection) {
        DynamicObjectCollection DBCollection = paySetting.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection.size() != DBCollection.size() || dynamicObjectCollection.size() == 0) {
            return true;
        }
        IDataEntityType dataEntityType = ((DynamicObject)DBCollection.get(0)).getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            DynamicObject DBEntry = (DynamicObject)DBCollection.get(index);
            DynamicObject entry = (DynamicObject)dynamicObjectCollection.get(index);
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (ignoreFields.contains(propertyName)) continue;
                if (property instanceof BasedataProp) {
                    long entryLongValue;
                    long DBEntryLongValue = DBEntry.getLong(propertyName + ".id");
                    if (DBEntryLongValue == (entryLongValue = entry.getLong(propertyName + ".id"))) continue;
                    return true;
                }
                if (property instanceof DecimalProp) {
                    BigDecimal entryDecimalValue;
                    BigDecimal DBEntryDecimalValue = DBEntry.getBigDecimal(propertyName);
                    if (DBEntryDecimalValue.compareTo(entryDecimalValue = entry.getBigDecimal(propertyName)) == 0) continue;
                    return true;
                }
                if (property instanceof MulBasedataProp) {
                    DynamicObjectCollection DBMmulBasedatas = DBEntry.getDynamicObjectCollection("mulbasedatafield");
                    DynamicObjectCollection mulBasedatas = entry.getDynamicObjectCollection("mulbasedatafield");
                    if (DBMmulBasedatas.size() != mulBasedatas.size()) {
                        return true;
                    }
                    HashSet<Long> mulBasedataIds = new HashSet<Long>(DBMmulBasedatas.size());
                    for (DynamicObject mulBasedata : DBMmulBasedatas) {
                        mulBasedataIds.add(mulBasedata.getLong("fbasedataid_id"));
                    }
                    for (DynamicObject mulBasedata : mulBasedatas) {
                        if (!mulBasedataIds.add(mulBasedata.getLong("fbasedataid_id"))) continue;
                        return true;
                    }
                    continue;
                }
                Object DBEntryValue = DBEntry.get(propertyName);
                Object entryValue = entry.get(propertyName);
                if (DBEntryValue != null && entryValue != null && !DBEntryValue.equals(entryValue)) {
                    return true;
                }
                if ((DBEntryValue != null || entryValue == null) && (DBEntryValue == null || entryValue != null)) continue;
                return true;
            }
        }
        return false;
    }

    private DynamicObject updatePaySetting(SWCDataServiceHelper helper, PaySalaryDTO matchRule, int index, Long perBankCardId) {
        DynamicObject payEntry = helper.generateEmptyEntryDynamicObject("entryentity");
        payEntry.set("seq", (Object)(index + 1));
        payEntry.set("salaryitemshow", (Object)matchRule.getSalaryName());
        payEntry.set("salaryitemmark", (Object)matchRule.getSalaryItem());
        payEntry.set("salaryitem", (Object)this.getDynamicObjectById("hsbs_salaryitem", matchRule.getSalaryItemId()));
        payEntry.set("currency", (Object)this.getDynamicObjectById("bd_currency", matchRule.getPayCurrencyId()));
        payEntry.set("paymentway", (Object)matchRule.getPaymentWay());
        payEntry.set("payrate", (Object)matchRule.getPayScale());
        payEntry.set("payamount", (Object)matchRule.getPayAmount());
        payEntry.set("paysubject", (Object)this.getDynamicObjectById("hsbs_paysubject", matchRule.getPaySubjectId()));
        payEntry.set("paytype", (Object)this.getDynamicObjectById("hsbs_paymethod", matchRule.getPayType()));
        payEntry.set("perbankcard", (Object)this.getDynamicObjectById("hrpi_perbankcard", perBankCardId));
        return payEntry;
    }

    private Set<Long> matchPerBankCard(Long bankPurposeId, Long relationId, List<DynamicObject> perBankCardList) {
        return perBankCardList.stream().filter(card -> {
            Long bankRelationId = card.getLong("accountrelation.id");
            Set bankPurposeIdSet = card.getDynamicObjectCollection("cardpurpose").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
            return !(bankPurposeId != 0L && !bankPurposeIdSet.contains(bankPurposeId) || relationId != 0L && !bankRelationId.equals(relationId));
        }).map(card -> card.getLong("sourcevid")).collect(Collectors.toSet());
    }

    private List<PaySalaryDTO> matchRule(DynamicObject paySettingRule, PersonRangeDTO personRange) {
        DynamicObjectCollection specialEntity = paySettingRule.getDynamicObjectCollection("specialentryentity");
        if (!specialEntity.isEmpty() && personRange != null) {
            GeneralFilterCompareService service = new GeneralFilterCompareService();
            DynamicObject matchRule = specialEntity.stream().filter(obj -> service.isMatch(obj.getString("rulecontent"), personRange.getDtoNameLangMap())).findFirst().orElse(null);
            if (matchRule != null) {
                DynamicObjectCollection specialRule = matchRule.getDynamicObjectCollection("subentryentity");
                return PaySalarySettingHelper.createSpecialRuleData(specialRule);
            }
        }
        DynamicObjectCollection defaultRule = paySettingRule.getDynamicObjectCollection("opentryentity");
        return PaySalarySettingHelper.createDefaultRuleData(defaultRule);
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        logger.info("entityName :{} id :{}", (Object)entityName, (Object)id);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }

    static {
        ignoreFields.add("id");
        ignoreFields.add("status");
        ignoreFields.add("enable");
        ignoreFields.add("creator");
        ignoreFields.add("modifier");
        ignoreFields.add("modifytime");
        ignoreFields.add("createtime");
        ignoreFields.add("entryboid");
        ignoreFields.add("salaryitemshow");
    }
}

