/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.payschedule;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.service.WorkCalendarLoadService;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PaySchTplHelper {
    private static final Log logger = LogFactory.getLog(PaySchTplHelper.class);
    public static final String SELECT_SCHEME_ALL = "all";
    public static final String SELECT_SCHEME_CREATE = "create";
    public static final String SELECT_SCHEME_RELATE = "relate";
    public static final String ACTION_CREATE_SUCCESS = "action_create_success";

    public static DynamicObject[] queryPaySchAllFieldDys(List<Long> patSchIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        QFilter filter = new QFilter("id", "in", patSchIds);
        String selProps = "name,number,paybizaction,startdate,enddate,tracker,description,createtime,creator,modifytime,modifier,status,disabler,index,enable,issyspreset,org,payrollgrp,payrollgrpv,calperiodtype,calperiod,prepaybizaction,calfrequency,paybizproc,payrollsceneisenable,msgtpl,msgpushstep,msgpushnum,receiver";
        return helper.query(selProps, filter.toArray());
    }

    public static DynamicObject[] queryPaySchPartFieldDys(Date date, List<Long> periodIds, Long paySchTplId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        QFilter filter = new QFilter("calperiod", "in", periodIds);
        filter.and("startdate", "<=", (Object)date);
        filter.and("enddate", ">=", (Object)date);
        filter.and("payschtpl", "=", (Object)paySchTplId);
        String selProps = "name,startdate,enddate,payrollgrp.name,calperiod.name";
        return helper.query(selProps, filter.toArray());
    }

    public static DynamicObject[] queryPaySchPartFieldDys(List<Long> periodIds, Long paySchTplId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        QFilter filter = new QFilter("calperiod", "in", periodIds);
        filter.and("payschtpl", "=", (Object)paySchTplId);
        String selProps = "startdate,enddate";
        return helper.query(selProps, filter.toArray());
    }

    public static DynamicObjectCollection getPeriodDys(Object periodTypeId) {
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter qFilter = new QFilter("periodtypeid", "=", periodTypeId);
        String selProps = "id,name,startdate,enddate";
        return periodHelper.queryOriginalCollection(selProps, qFilter.toArray(), "startdate asc");
    }

    public static DynamicObject queryPeriodDy(Object periodId) {
        SWCDataServiceHelper paySchTplHelper = new SWCDataServiceHelper("hsbs_calperiod");
        String selPros = "id,name,startdate,enddate";
        return paySchTplHelper.queryOne(selPros, periodId);
    }

    public static DynamicObject[] queryPeriodDys(List<Long> periodIds) {
        SWCDataServiceHelper paySchTplHelper = new SWCDataServiceHelper("hsbs_calperiod");
        String selPros = "id,name,startdate,enddate";
        QFilter qFilter = new QFilter("id", "in", periodIds);
        return paySchTplHelper.query(selPros, qFilter.toArray());
    }

    public static DynamicObject queryPaySchTplDy(Object paySchTplId) {
        SWCDataServiceHelper paySchTplHelper = new SWCDataServiceHelper("hsas_payscheduletpl");
        String selPros = "org,workplan,payrollgrp,payrollgrpv,payrollscene,calfrequency,calperiodtype,paybizproc,entryentity,paybizaction,actdaynum,actdaytype,prepaybizaction,tracker,paybizactiondesc,paybizactionpoint,actdateboundary,actdatetype,perioddateboundary,operation,oprationdays,selperiod,everymonthday,isworkday,selworkday,daytype";
        return paySchTplHelper.queryOne(selPros, paySchTplId);
    }

    public static DynamicObjectCollection queryPayBizProcEntry(Long payBizProcId) {
        SWCDataServiceHelper payBizProcHelper = new SWCDataServiceHelper("hsbs_paybizproc");
        String selProps = "entryentity,paybizaction.id,prepaybizaction";
        DynamicObject payBizProcDy = payBizProcHelper.queryOne(selProps, (Object)payBizProcId);
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        if (!SWCObjectUtils.isEmpty((Object)payBizProcDy)) {
            dyColl = payBizProcDy.getDynamicObjectCollection("entryentity");
        }
        return dyColl;
    }

    public static Map<Long, List<Long>> getEntryPreMap(DynamicObjectCollection dyColl) {
        HashMap<Long, List<Long>> nodeMap = new HashMap<Long, List<Long>>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            DynamicObjectCollection mulBaseData = dyObj.getDynamicObjectCollection("prepaybizaction");
            ArrayList<Long> prePayTasks = new ArrayList<Long>(10);
            for (DynamicObject prepaybizaction : mulBaseData) {
                prePayTasks.add(prepaybizaction.getLong("fbasedataid_id"));
            }
            nodeMap.put(dyObj.getLong("paybizaction.id"), prePayTasks);
        }
        return nodeMap;
    }

    public static Map<Long, List<Map<String, Object>>> queryTplSubEntryInfoMap(DynamicObject paySchTplDy) {
        DynamicObjectCollection dyColl = paySchTplDy.getDynamicObjectCollection("entryentity");
        String querySql = "SELECT T1.FDETAILID,T1.FISENABLE,T1.FMSGTPLID,T1.FMSGPUSHSTEP,T1.FMSGPUSHNUM,T1.FMSGPUSHDAYTYPE,T1.FMSGPUSHTIME,T2.FBASEDATAID  FROM T_HSAS_PAYSCHTPLDETAIL T1 LEFT JOIN T_HSAS_PAYSCHTPLRECEIVER T2 ON T1.FDETAILID = T2.FDETAILID WHERE FENTRYID = ?";
        HashMap<Long, List<Map<String, Object>>> subEntryMap = new HashMap<Long, List<Map<String, Object>>>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            List subEntryInfoLists = (List)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])new Object[]{dyObj.getLong("id")}, rs -> {
                ArrayList subEntryInfoList = new ArrayList(dyColl.size());
                long detailId = 0L;
                HashMap<String, Object> result = new HashMap<String, Object>(6);
                ArrayList<Long> baseDataIds = new ArrayList<Long>(10);
                while (rs.next()) {
                    if (detailId != rs.getLong("FDETAILID")) {
                        detailId = rs.getLong("FDETAILID");
                        result = new HashMap(6);
                        baseDataIds = new ArrayList(10);
                        result.put("isenable", rs.getString("FISENABLE"));
                        result.put("msgtpl", rs.getLong("FMSGTPLID"));
                        result.put("msgpushstep", rs.getString("FMSGPUSHSTEP"));
                        result.put("msgpushnum", rs.getString("FMSGPUSHNUM"));
                        result.put("msgpushdaytype", rs.getString("FMSGPUSHDAYTYPE"));
                        result.put("msgpushtime", rs.getString("FMSGPUSHTIME"));
                        baseDataIds.add(rs.getLong("FBASEDATAID"));
                        result.put("receiver", baseDataIds);
                        subEntryInfoList.add(result);
                        continue;
                    }
                    baseDataIds.add(rs.getLong("FBASEDATAID"));
                    result.put("receiver", baseDataIds);
                }
                return subEntryInfoList;
            });
            subEntryMap.put(dyObj.getLong("paybizaction.id"), subEntryInfoLists);
        }
        return subEntryMap;
    }

    public static Date getSelPayTaskDate(DynamicObject paySchTplDy, DynamicObject startPeriod, DynamicObject startNextPeriod) {
        Date payTaskDate = null;
        String payTaskDateType = paySchTplDy.getString("actdatetype");
        if (!"1".equals(payTaskDateType)) {
            String periodDateType = paySchTplDy.getString("perioddateboundary");
            payTaskDate = "0".equals(periodDateType) ? startPeriod.getDate("startdate") : startPeriod.getDate("enddate");
            String op = paySchTplDy.getString("operation");
            int opNum = paySchTplDy.getInt("oprationdays");
            String dayType = paySchTplDy.getString("daytype");
            if ("0".equals(dayType)) {
                payTaskDate = SWCDateTimeUtils.addDay((Date)payTaskDate, (long)((long)opNum * ("0".equals(op) ? -1L : 1L)));
            } else {
                List<Map<String, String>> workCalendar = PayScheduleHelper.getWorkCalendar(paySchTplDy.getLong("workplan.id"), SWCDateTimeUtils.getYear((Date)payTaskDate));
                payTaskDate = WorkCalendarLoadService.getWorkDate(payTaskDate, "1".equals(op), opNum, workCalendar, false);
            }
        } else {
            int endDateMonth;
            int everyMonthDay = paySchTplDy.getInt("everymonthday");
            int month = 0;
            int year = 0;
            String selPeriodStr = paySchTplDy.getString("selperiod");
            Date startDate = startPeriod.getDate("startdate");
            Date endDate = startPeriod.getDate("enddate");
            if (startNextPeriod != null && "1".equals(selPeriodStr)) {
                startDate = startNextPeriod.getDate("startdate");
                endDate = startNextPeriod.getDate("enddate");
            }
            int startDateDay = SWCDateTimeUtils.getDay((Date)startDate);
            int endDateDay = SWCDateTimeUtils.getDay((Date)endDate);
            int startDateMonth = SWCDateTimeUtils.getMonth((Date)startDate);
            if (startDateMonth == (endDateMonth = SWCDateTimeUtils.getMonth((Date)endDate))) {
                year = SWCDateTimeUtils.getYear((Date)startDate);
                month = startDateMonth;
                everyMonthDay = everyMonthDay > endDateDay ? endDateDay : everyMonthDay;
            } else if (startDateMonth < endDateMonth) {
                year = SWCDateTimeUtils.getYear((Date)startDate);
                month = everyMonthDay >= startDateDay ? startDateMonth : endDateMonth;
                everyMonthDay = PaySchTplHelper.getEveryMonthDay(year, month, everyMonthDay);
            } else {
                if (everyMonthDay >= startDateDay) {
                    month = startDateMonth;
                    year = SWCDateTimeUtils.getYear((Date)startDate);
                } else {
                    month = endDateMonth;
                    year = SWCDateTimeUtils.getYear((Date)endDate);
                }
                everyMonthDay = PaySchTplHelper.getEveryMonthDay(year, month, everyMonthDay);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, everyMonthDay);
            payTaskDate = calendar.getTime();
        }
        logger.info("\u521d\u59cb\u951a\u70b9\u65e5\u671f {}", (Object)SerializationUtils.toJsonString((Object)payTaskDate));
        return payTaskDate;
    }

    public static int getEveryMonthDay(int year, int month, int everyMonthDay) {
        if (everyMonthDay > 28) {
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    return everyMonthDay;
                }
                case 2: {
                    return year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    return everyMonthDay > 30 ? 30 : everyMonthDay;
                }
            }
            return everyMonthDay;
        }
        return everyMonthDay;
    }

    public static Map<Long, Map<String, Date>> getPaySchDate(DynamicObject paySchTplDy, Date selPayTaskDate, List<Map<String, String>> workCalendar, Map<Long, List<Long>> entryPreMap) {
        logger.info("\u5de5\u4f5c\u65e5\u5386\u6570\u636e\uff1a{}", (Object)SerializationUtils.toJsonString(workCalendar));
        DynamicObjectCollection dyColl = paySchTplDy.getDynamicObjectCollection("entryentity");
        long payTaskId = paySchTplDy.getLong("paybizactionpoint.id");
        HashMap<Long, Map<String, Date>> paySchDateMapFirst = new HashMap<Long, Map<String, Date>>(dyColl.size());
        Map<Long, Map<String, Object>> paySchTplEntryMap = PaySchTplHelper.getPaySchTplEntryMap(dyColl);
        logger.info("\u4efb\u52a1\u671f\u9650\u4fe1\u606f\uff1a{}", (Object)SerializationUtils.toJsonString(paySchTplEntryMap));
        Map<String, Date> selNodeDateMap = PaySchTplHelper.getEntranceNodeDateMap(paySchTplDy, selPayTaskDate, payTaskId, paySchTplEntryMap, workCalendar);
        paySchDateMapFirst.put(payTaskId, selNodeDateMap);
        logger.info("\u7528\u6237\u9009\u62e9\u7684\u951a\u70b9\u7684\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)SerializationUtils.toJsonString(selNodeDateMap));
        Map<Long, List<Long>> entryNextMap = PaySchTplHelper.getEntryNextMap(dyColl, entryPreMap);
        PaySchTplHelper.setEndNodeDateInLoop(payTaskId, selNodeDateMap, entryNextMap, paySchDateMapFirst, paySchTplEntryMap, workCalendar);
        if (payTaskId == 1139088905400819712L) {
            selNodeDateMap.put("endDate", SWCDateTimeUtils.addDay((Date)selNodeDateMap.get("endDate"), (long)1L));
            selNodeDateMap.put("startDate", SWCDateTimeUtils.addDay((Date)selNodeDateMap.get("startDate"), (long)1L));
            paySchDateMapFirst.put(payTaskId, selNodeDateMap);
        }
        logger.info("\u6b63\u5411\u9012\u5f52\u7684\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)SerializationUtils.toJsonString(paySchDateMapFirst));
        Map endNodeDateMap = (Map)paySchDateMapFirst.get(1139088905400819712L);
        HashMap<Long, Map<String, Date>> paySchDateMapLast = new HashMap<Long, Map<String, Date>>(dyColl.size());
        paySchDateMapLast.put(1139088905400819712L, endNodeDateMap);
        PaySchTplHelper.setAllNodeDateInLoop(1139088905400819712L, endNodeDateMap, entryPreMap, paySchDateMapFirst, paySchDateMapLast, paySchTplEntryMap, workCalendar);
        logger.info("\u9006\u5411\u9012\u5f52\u7684\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)SerializationUtils.toJsonString(paySchDateMapLast));
        return paySchDateMapLast;
    }

    public static void setAllNodeDateInLoop(Long payTask, Map<String, Date> curNodeDateMap, Map<Long, List<Long>> entryPreMap, Map<Long, Map<String, Date>> paySchDateMapFirst, Map<Long, Map<String, Date>> paySchDateMapLast, Map<Long, Map<String, Object>> paySchTplEntryMap, List<Map<String, String>> workCalendar) {
        if (payTask == 1139088596750377984L) {
            return;
        }
        List<Long> prePayTasks = entryPreMap.get(payTask);
        for (Long prePayTask : prePayTasks) {
            Map<String, Object> payTaskInfoMap = paySchTplEntryMap.get(prePayTask);
            Integer payTaskDayNum = MapUtils.getInteger(payTaskInfoMap, (Object)"payTaskDayNum");
            String payTaskDayType = MapUtils.getString(payTaskInfoMap, (Object)"payTaskDayType");
            Date endDate = SWCDateTimeUtils.addDay((Date)curNodeDateMap.get("startDate"), (long)-1L);
            Date startDate = "0".equals(payTaskDayType) ? WorkCalendarLoadService.getWorkDate(endDate, false, payTaskDayNum, workCalendar, true) : SWCDateTimeUtils.addDay((Date)endDate, (long)(1 - payTaskDayNum));
            HashMap<String, Date> dateInfoMap = new HashMap<String, Date>(16);
            dateInfoMap.put("startDate", startDate);
            dateInfoMap.put("endDate", endDate);
            Map<String, Date> preSetDateMap = paySchDateMapFirst.get(prePayTask);
            if (preSetDateMap != null && !preSetDateMap.isEmpty()) {
                dateInfoMap.put("startDate", preSetDateMap.get("startDate"));
                dateInfoMap.put("endDate", preSetDateMap.get("endDate"));
            } else {
                Map<String, Date> preSetDateMapLat = paySchDateMapLast.get(prePayTask);
                if (preSetDateMapLat != null && !preSetDateMapLat.isEmpty()) {
                    Date preSetStartDate = preSetDateMapLat.get("startDate");
                    Date preSetEndDate = preSetDateMapLat.get("endDate");
                    if (startDate.after(preSetStartDate) || endDate.after(preSetEndDate)) {
                        dateInfoMap.put("startDate", preSetStartDate);
                        dateInfoMap.put("endDate", preSetEndDate);
                    }
                }
            }
            paySchDateMapLast.put(prePayTask, dateInfoMap);
            List<Long> prePrePayTasks = entryPreMap.get(prePayTask);
            if (prePrePayTasks == null || prePrePayTasks.isEmpty()) continue;
            HashMap<String, Date> dateInfo2Map = new HashMap<String, Date>(16);
            dateInfo2Map.put("startDate", (Date)dateInfoMap.get("startDate"));
            dateInfo2Map.put("endDate", (Date)dateInfoMap.get("endDate"));
            PaySchTplHelper.setAllNodeDateInLoop(prePayTask, dateInfo2Map, entryPreMap, paySchDateMapFirst, paySchDateMapLast, paySchTplEntryMap, workCalendar);
        }
    }

    public static Map<Long, List<Long>> getEntryNextMap(DynamicObjectCollection dyColl, Map<Long, List<Long>> entryPreMap) {
        HashMap<Long, List<Long>> entryNextMap = new HashMap<Long, List<Long>>(entryPreMap.size());
        for (DynamicObject dyObj : dyColl) {
            long payTaskId = dyObj.getLong("paybizaction.id");
            ArrayList<Long> nextPayTasks = new ArrayList<Long>(10);
            for (Map.Entry<Long, List<Long>> map : entryPreMap.entrySet()) {
                if (payTaskId == map.getKey() || !map.getValue().contains(payTaskId)) continue;
                nextPayTasks.add(map.getKey());
            }
            entryNextMap.put(payTaskId, nextPayTasks);
        }
        return entryNextMap;
    }

    public static void setEndNodeDateInLoop(Long payTask, Map<String, Date> curNodeDateMap, Map<Long, List<Long>> entryNextMap, Map<Long, Map<String, Date>> paySchDateMap, Map<Long, Map<String, Object>> paySchTplEntryMap, List<Map<String, String>> workCalendar) {
        if (payTask == 1139088905400819712L) {
            return;
        }
        List<Long> nextPayTasks = entryNextMap.get(payTask);
        for (Long nextPayTask : nextPayTasks) {
            Map<String, Object> payTaskInfoMap = paySchTplEntryMap.get(nextPayTask);
            Integer payTaskDayNum = MapUtils.getInteger(payTaskInfoMap, (Object)"payTaskDayNum");
            String payTaskDayType = MapUtils.getString(payTaskInfoMap, (Object)"payTaskDayType");
            Date startDate = SWCDateTimeUtils.addDay((Date)curNodeDateMap.get("endDate"), (long)1L);
            Date endDate = "0".equals(payTaskDayType) ? WorkCalendarLoadService.getWorkDate(startDate, true, payTaskDayNum, workCalendar, true) : SWCDateTimeUtils.addDay((Date)startDate, (long)(payTaskDayNum - 1));
            HashMap<String, Date> dateInfoMap = new HashMap<String, Date>(2);
            dateInfoMap.put("startDate", startDate);
            dateInfoMap.put("endDate", endDate);
            Map<String, Date> preSetDateMap = paySchDateMap.get(nextPayTask);
            if (preSetDateMap != null && !preSetDateMap.isEmpty()) {
                Date preSetStartDate = preSetDateMap.get("startDate");
                Date preSetEndDate = preSetDateMap.get("endDate");
                if (startDate.before(preSetStartDate)) {
                    dateInfoMap.put("startDate", preSetStartDate);
                }
                if (endDate.before(preSetEndDate)) {
                    dateInfoMap.put("endDate", preSetEndDate);
                }
            }
            paySchDateMap.put(nextPayTask, dateInfoMap);
            List<Long> nextNextPayTasks = entryNextMap.get(nextPayTask);
            if (nextNextPayTasks == null || nextNextPayTasks.isEmpty()) continue;
            HashMap<String, Date> dateInfo2Map = new HashMap<String, Date>(2);
            dateInfo2Map.put("startDate", (Date)dateInfoMap.get("startDate"));
            dateInfo2Map.put("endDate", (Date)dateInfoMap.get("endDate"));
            PaySchTplHelper.setEndNodeDateInLoop(nextPayTask, dateInfo2Map, entryNextMap, paySchDateMap, paySchTplEntryMap, workCalendar);
        }
    }

    public static Map<Long, Map<String, Object>> getPaySchTplEntryMap(DynamicObjectCollection paySchTplEntry) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(paySchTplEntry.size());
        for (DynamicObject entry : paySchTplEntry) {
            HashMap<String, Object> taskInfoMap = new HashMap<String, Object>(2);
            int payTaskDayNum = entry.getInt("actdaynum");
            String payTaskDayType = entry.getString("actdaytype");
            taskInfoMap.put("payTaskDayNum", payTaskDayNum);
            taskInfoMap.put("payTaskDayType", payTaskDayType);
            long payTaskId = entry.getLong("paybizaction.id");
            result.put(payTaskId, taskInfoMap);
        }
        HashMap<String, Object> taskInfoMap = new HashMap<String, Object>(2);
        taskInfoMap.put("payTaskDayNum", 1);
        taskInfoMap.put("payTaskDayType", "1");
        result.put(1139088596750377984L, taskInfoMap);
        result.put(1139088905400819712L, taskInfoMap);
        return result;
    }

    public static Map<String, Date> getEntranceNodeDateMap(DynamicObject paySchTplDy, Date selPayTaskDate, long payTaskId, Map<Long, Map<String, Object>> paySchTplEntryMap, List<Map<String, String>> workCalendar) {
        HashMap<String, Date> selPayTaskMap = new HashMap<String, Date>(16);
        Date afterWorkDayRuleDate = PaySchTplHelper.adjustPayTaskDateByWorkDay(paySchTplDy, selPayTaskDate, workCalendar);
        logger.info("\u7ecf\u8fc7\u5de5\u4f5c\u65e5\u89c4\u5219\u5904\u7406\u7684\u951a\u70b9\u65e5\u671f\uff1a{}", (Object)SerializationUtils.toJsonString((Object)afterWorkDayRuleDate));
        if (payTaskId == 1139088596750377984L) {
            selPayTaskMap.put("endDate", SWCDateTimeUtils.addDay((Date)afterWorkDayRuleDate, (long)-1L));
            selPayTaskMap.put("startDate", SWCDateTimeUtils.addDay((Date)afterWorkDayRuleDate, (long)-1L));
            return selPayTaskMap;
        }
        String payTaskDateBoundary = paySchTplDy.getString("actdateboundary");
        Map<String, Object> taskInfoMap = paySchTplEntryMap.get(payTaskId);
        Integer payTaskDayNum = MapUtils.getInteger(taskInfoMap, (Object)"payTaskDayNum");
        String payTaskDayType = MapUtils.getString(taskInfoMap, (Object)"payTaskDayType");
        if ("0".equals(payTaskDateBoundary)) {
            selPayTaskMap.put("startDate", afterWorkDayRuleDate);
            if ("1".equals(payTaskDayType)) {
                Date endDate = SWCDateTimeUtils.addDay((Date)afterWorkDayRuleDate, (long)(payTaskDayNum - 1));
                selPayTaskMap.put("endDate", endDate);
            } else {
                Date endDate = WorkCalendarLoadService.getWorkDate(afterWorkDayRuleDate, true, payTaskDayNum, workCalendar, true);
                selPayTaskMap.put("endDate", endDate);
            }
        } else {
            selPayTaskMap.put("endDate", afterWorkDayRuleDate);
            if ("1".equals(payTaskDayType)) {
                Date startDate = SWCDateTimeUtils.addDay((Date)afterWorkDayRuleDate, (long)(1 - payTaskDayNum));
                selPayTaskMap.put("startDate", startDate);
            } else {
                Date startDate = WorkCalendarLoadService.getWorkDate(afterWorkDayRuleDate, false, payTaskDayNum, workCalendar, true);
                selPayTaskMap.put("startDate", startDate);
            }
        }
        return selPayTaskMap;
    }

    public static Date adjustPayTaskDateByWorkDay(DynamicObject paySchTplDy, Date payTaskDate, List<Map<String, String>> workCalendar) {
        boolean isWorkDaySel;
        String payTaskDateType = paySchTplDy.getString("actdatetype");
        if (!"1".equals(payTaskDateType)) {
            return payTaskDate;
        }
        String selWorkDay = paySchTplDy.getString("selworkday");
        boolean bl = isWorkDaySel = !"2".equals(selWorkDay);
        if (isWorkDaySel && !PaySchTplHelper.isWorkDay(payTaskDate, workCalendar)) {
            payTaskDate = WorkCalendarLoadService.getWorkDate(payTaskDate, "1".equals(selWorkDay), 1, workCalendar, true);
        }
        return payTaskDate;
    }

    public static boolean isWorkDay(Date date, List<Map<String, String>> workCalendar) {
        if (workCalendar.isEmpty()) {
            logger.error("workCalendar isEmpty ! ");
            return true;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = format.format(date);
        for (Map<String, String> map : workCalendar) {
            String workDateStr = map.get("workDate");
            if (!dateStr.equals(workDateStr)) continue;
            String dateType = map.get("dateType");
            return "1".equals(dateType);
        }
        return true;
    }

    public static Map<String, List<DynamicObject>> groupPaySchByDate(List<Long> orgIds, Long payRollGroupId, Long payrollSceneId, List<Long> calPeriodIds, String selectScheme, Long currentUserId) {
        DynamicObject[] query;
        HashMap<String, List<DynamicObject>> dateToPaySch = new HashMap<String, List<DynamicObject>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        String selPros = "name,number,schedulestatus,org,payrollgrp,payrollscene,calperiod,startdate,endDate,creator,tracker";
        List<QFilter> qfilters = PaySchTplHelper.buildQFilter(orgIds, payRollGroupId, payrollSceneId, calPeriodIds, selectScheme, currentUserId);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter == null) {
            qfilters.add(new QFilter("1", "!=", (Object)1));
        } else {
            qfilters.addAll(authorizedDataRuleQFilter);
        }
        for (DynamicObject dynamicObject : query = helper.query(selPros, qfilters.toArray(new QFilter[0]))) {
            if (!PaySchTplHelper.filterResultSet(selectScheme, currentUserId, dynamicObject)) continue;
            PaySchTplHelper.fillInTheMap(dynamicObject, dateToPaySch);
        }
        return dateToPaySch;
    }

    private static boolean filterResultSet(String selectScheme, Long currentUserId, DynamicObject dynamicObject) {
        boolean flag = false;
        if (SWCStringUtils.equals((String)SELECT_SCHEME_RELATE, (String)selectScheme)) {
            DynamicObjectCollection trackers = dynamicObject.getDynamicObjectCollection("tracker");
            for (DynamicObject tracker : trackers) {
                if (!currentUserId.equals(tracker.getLong("fbasedataid_id"))) continue;
                flag = true;
                break;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private static List<QFilter> buildQFilter(List<Long> orgIds, Long payRollGroupId, Long payrollSceneId, List<Long> calPeriodIds, String selectScheme, Long currentUserId) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        if (orgIds != null) {
            qfilters.add(new QFilter("org", "in", orgIds));
        }
        if (payRollGroupId != null) {
            qfilters.add(new QFilter("payrollgrp", "=", (Object)payRollGroupId));
        }
        if (payrollSceneId != null) {
            qfilters.add(new QFilter("payrollscene", "=", (Object)payrollSceneId));
        }
        if (calPeriodIds != null) {
            qfilters.add(new QFilter("calperiod", "in", calPeriodIds));
        }
        if (SWCStringUtils.equals((String)SELECT_SCHEME_CREATE, (String)selectScheme)) {
            qfilters.add(new QFilter("creator", "=", (Object)currentUserId));
        }
        qfilters.add(new QFilter("enable", "=", (Object)"1"));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        return qfilters;
    }

    private static void fillInTheMap(DynamicObject paySchEveryDate, Map<String, List<DynamicObject>> dateToPaySch) {
        Date startDate = paySchEveryDate.getDate("startdate");
        Date endDate = paySchEveryDate.getDate("endDate");
        Date date = startDate;
        while (SWCDateTimeUtils.dayBefore((Date)date, (Date)endDate) || SWCDateTimeUtils.dayEquals((Date)date, (Date)endDate)) {
            List list = dateToPaySch.computeIfAbsent(SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"), key -> new ArrayList());
            list.add(paySchEveryDate);
            date = SWCDateTimeUtils.addDay((Date)date, (long)1L);
        }
    }

    public static void showPage(AfterDoOperationEventArgs args, String formId, AbstractFormPlugin iFormPlugin) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (successPkIds != null && !successPkIds.isEmpty()) {
            Object paySchTplId = successPkIds.get(0);
            QFilter qFilter = new QFilter("id", "=", paySchTplId);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payscheduletpl");
            String selPros = "calperiodtype.id";
            DynamicObject paySchTplDy = helper.queryOne(selPros, qFilter.toArray());
            long periodTypeId = paySchTplDy.getLong("calperiodtype.id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("periodTypeId", (Object)periodTypeId);
            showParameter.setCustomParam("periodTypeName", (Object)paySchTplDy.getString("calperiodtype.name"));
            showParameter.setCustomParam("paySchTplId", paySchTplId);
            if (formId.contains("hsas_payschtplnewsch")) {
                showParameter.setCloseCallBack(new CloseCallBack(iFormPlugin.getPluginName(), ACTION_CREATE_SUCCESS));
            }
            iFormPlugin.getView().showForm(showParameter);
        }
    }

    public static void showFilterListPage(String generateBatch, AbstractFormPlugin iFormPlugin) {
        if (StringUtils.isEmpty((CharSequence)generateBatch)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hsas_payschedule");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("generatebatch", "=", (Object)generateBatch));
        showParameter.setListFilterParameter(listFilterParameter);
        iFormPlugin.getView().showForm((FormShowParameter)showParameter);
    }
}

