/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.personchange;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hsas.business.extpoint.personchange.IPersonChangeGenerateExtService;
import kd.sdk.swc.hsas.common.events.personchagne.PersonChangeSaveArgs;
import kd.swc.hsas.business.personchange.PersonChangeGenerateExtService;
import kd.swc.hsas.business.prorationevent.ProrationEventService;
import kd.swc.hsas.common.enums.PersonChangeSourceEnum;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class PersonChangeServiceHelper {
    public static final Log log = LogFactory.getLog(PersonChangeServiceHelper.class);
    private static SWCDataServiceHelper pcHelper = new SWCDataServiceHelper("hsas_personchange");
    private static SWCDataServiceHelper pcLogHelper = new SWCDataServiceHelper("hsas_personchangelog");
    private static SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_personchgbizdata");
    private static SWCDataServiceHelper changeReasonHelper = new SWCDataServiceHelper("hsbs_changereason");
    private static SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
    private static DynamicObjectType personChangeType = EntityMetadataCache.getDataEntityType((String)"hsas_personchange");
    private static DynamicObjectType personChangeLogType = EntityMetadataCache.getDataEntityType((String)"hsas_personchangelog");
    private static DynamicObjectType personChgBizDataType = EntityMetadataCache.getDataEntityType((String)"hsas_personchgbizdata");
    private static ProrationEventService prorationEventService = new ProrationEventService();
    private static final char SPLIT_CHAR = '\u3001';
    private static final String ERROR_MSG = "errorMsg";
    public static final int MAX_THREAD_COUNT = 5;
    private static final int SUCCESS_CODE = 200;
    private static final String SOURCE_ITF = "-1";
    private static final String SOURCE_BIZDATA = "2";
    public static final String STEP_SIZE_IS_FULL = "codeRuleStepSizeIsFull";

    public static PersonChangeServiceHelper getInstance() {
        return new PersonChangeServiceHelper();
    }

    public static List<Map<String, Object>> generateProrationEvent(DynamicObject[] dataEntities) {
        if (SWCArrayUtils.isEmpty((Object[])dataEntities)) {
            return null;
        }
        List<Map<String, Object>> params = PersonChangeServiceHelper.assembleGenProrationEvent(dataEntities);
        List<Map<String, Object>> result = prorationEventService.autoGenrateEvent(params);
        HashMap<Long, Map<String, Object>> resMap = new HashMap<Long, Map<String, Object>>(result.size());
        for (Map<String, Object> subMap : result) {
            resMap.put(MapUtils.getLong(subMap, (Object)"personChange"), subMap);
        }
        for (DynamicObject dataEntity : dataEntities) {
            Long personChangeId = dataEntity.getLong("id");
            Map res = (Map)resMap.get(personChangeId);
            if (null == res) continue;
            PersonChangeServiceHelper.dealReturnData(dataEntity, res);
        }
        return result;
    }

    public static List<Map<String, Object>> abandonProrationEvent(List<DynamicObject> personChanges) {
        ArrayList<Map<String, Long>> params = new ArrayList<Map<String, Long>>(personChanges.size());
        for (DynamicObject personChange : personChanges) {
            HashMap<String, Long> param = new HashMap<String, Long>(16);
            param.put("personChange", personChange.getLong("id"));
            param.put("salaryFile", personChange.getLong("salaryfile.id"));
            params.add(param);
        }
        List<Map<String, Object>> result = prorationEventService.abandonProrationEvent(params);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealReturnData(DynamicObject perosnChange, Map<String, Object> returnData) {
        String code = String.valueOf(returnData.get("code"));
        try (TXHandle txHandle = TX.requiresNew();){
            if ("200".equals(code)) {
                perosnChange.set("generatedstatus", (Object)"1");
                perosnChange.set("errormsg", null);
                pcHelper.saveOne(perosnChange);
            } else {
                if ("300".equals(code)) {
                    perosnChange.set("generatedstatus", (Object)SOURCE_BIZDATA);
                    perosnChange.set("errormsg", (Object)MapUtils.getString(returnData, (Object)"message"));
                } else if ("400".equals(code)) {
                    perosnChange.set("generatedstatus", (Object)"0");
                    perosnChange.set("errormsg", (Object)MapUtils.getString(returnData, (Object)"message"));
                }
                Long personChangeId = perosnChange.getLong("id");
                DLock lock = DLock.create((String)("UPDATE_PERSON_CHANGE_LOCK_" + personChangeId));
                if (lock.tryLock()) {
                    try {
                        DynamicObject personChangeNew = pcHelper.queryOne((Object)personChangeId);
                        if (!"1".equals(personChangeNew.getString("generatedstatus"))) {
                            pcHelper.saveOne(perosnChange);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            txHandle.commit();
        }
    }

    private static List<Map<String, Object>> assembleGenProrationEvent(DynamicObject[] dataEntities) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(dataEntities.length);
        for (DynamicObject dy : dataEntities) {
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(16);
            map.put("salaryFile", Long.valueOf(dy.getLong("salaryfile.id")));
            map.put("prorationDate", dy.getDate("changedate"));
            map.put("changeReason", Long.valueOf(dy.getLong("changereason.id")));
            map.put("personChange", Long.valueOf(dy.getLong("id")));
            map.put("operator", Long.valueOf(RequestContext.get().getCurrUserId()));
            params.add(map);
        }
        return params;
    }

    public static String getKey(Object ... params) {
        StringBuilder buf = new StringBuilder();
        for (Object param : params) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(param);
        }
        return buf.toString();
    }

    private static void tryCallGenerateProrationEvent(List<DynamicObject> personChanges) {
        if (CollectionUtils.isEmpty(personChanges)) {
            return;
        }
        Set personChangeIds = personChanges.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", personChangeIds);
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException\uff1a", (Throwable)e);
            }
            Object[] personChagnesInDB = pcHelper.query("id", new QFilter[]{filter});
            if (SWCArrayUtils.isEmpty((Object[])personChagnesInDB) || personChagnesInDB.length != personChangeIds.size()) continue;
            PersonChangeServiceHelper.generateProrationEvent(personChanges.toArray(new DynamicObject[personChanges.size()]));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> genPersonChange(String source, List<Map<String, Object>> params) {
        log.info("genPersonChange params size is :{}", (Object)params.size());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        try {
            DynamicObject[] personChangeArr = this.createPersonChange(source, params);
            SWCThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
                List<DynamicObject> waitGenerateEventDys = Arrays.stream(personChangeArr).filter(dy -> !"1".equals(dy.getString("generatedstatus"))).collect(Collectors.toList());
                PersonChangeServiceHelper.tryCallGenerateProrationEvent(waitGenerateEventDys);
            });
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("message", null);
            resultMap.put("result", params);
        }
        catch (Exception exp) {
            try {
                String msg;
                if (exp instanceof KDException && STEP_SIZE_IS_FULL.equals(((KDException)exp).getErrorCode().getCode())) {
                    msg = ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u6d41\u6c34\u53f7\u5df2\u7528\u5b8c\uff0c\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u8c03\u6574\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"PersonChangeServiceHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]);
                    if (PersonChangeSourceEnum.BIZDATA.getCode().equals(source)) {
                        resultMap.put(STEP_SIZE_IS_FULL, null);
                    }
                } else {
                    msg = ResManager.loadKDString((String)"\u5185\u90e8\u5f02\u5e38\uff0c\u751f\u6210\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\u3002", (String)"PersonChangeServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
                }
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", msg);
                this.markOperationResult(params, Boolean.FALSE, msg);
                log.error("genPersonChange() error {}:", (Object)exp.getMessage());
                resultMap.put("result", params);
            }
            catch (Throwable throwable) {
                resultMap.put("result", params);
                throw throwable;
            }
        }
        return resultMap;
    }

    public Map<String, Object> genPersonChangeForSalaryFile(List<Map<String, Object>> params) {
        Map<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("result", params);
        try {
            log.info("genPersonChangeForSalaryFile() params size: {}", (Object)params.size());
            List<Map<String, Object>> successList = this.checkMustInputCommon(PersonChangeSourceEnum.MANUAL.getCode(), params);
            log.info("genPersonChangeForSalaryFile() successList size: {}", (Object)successList.size());
            successList.forEach(map -> {
                if (SWCObjectUtils.isEmpty(map.get("creatorId"))) {
                    map.put("creatorId", RequestContext.get().getCurrUserId());
                }
            });
            resultMap = this.genPersonChange(PersonChangeSourceEnum.MANUAL.getCode(), successList);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            log.error("genPersonChangeForSalaryFile() error {0}", (Throwable)e);
        }
        return resultMap;
    }

    public Map<String, Object> genPersonChangeForColla(List<Map<String, Object>> params) {
        Map<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("result", params);
        try {
            log.info("genPersonChangeForColla() params size: {}", (Object)params.size());
            List<Map<String, Object>> successList = this.checkMustInputCommon(PersonChangeSourceEnum.COLLA.getCode(), params);
            log.info("genPersonChangeForColla() successList size: {}", (Object)successList.size());
            this.dealPropInfoForColla(successList);
            resultMap = this.genPersonChange(PersonChangeSourceEnum.COLLA.getCode(), successList);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            log.error("genPersonChangeForSalaryFile() error {0}", (Throwable)e);
        }
        return resultMap;
    }

    private void dealPropInfoForColla(List<Map<String, Object>> successList) {
        log.info("dealPropInfoForColla...{}", (Object)successList.size());
        successList.forEach(map -> map.put("creatorId", RequestContext.get().getCurrUserId()));
        List taskIds = successList.stream().map(map -> (Long)map.get("taskCenterId")).collect(Collectors.toList());
        String taskCenterClass = successList.stream().findFirst().map(item -> MapUtils.getString((Map)item, (Object)"taskCenterClass")).orElse("hpdi_taskcenter");
        SWCDataServiceHelper helper = new SWCDataServiceHelper(taskCenterClass);
        QFilter filter = new QFilter("id", "in", taskIds);
        DynamicObject[] taskArr = helper.query("id,orgmsgrecvcenter.msgaction.id", new QFilter[]{filter});
        Map<Long, Long> taskMap = Arrays.stream(taskArr).collect(Collectors.toMap(tk -> tk.getLong("id"), tk -> tk.getLong("orgmsgrecvcenter.msgaction.id"), (k1, k2) -> k1));
        log.info("dealPropInfoForColla...taskMap...{}", (Object)taskMap.toString());
        successList.forEach(map -> {
            Long actionId = (Long)taskMap.get(map.get("taskCenterId"));
            if (actionId == null) {
                actionId = 0L;
            }
            map.put("actionId", actionId);
        });
    }

    public Map<String, Object> genPersonChangeForBizData(List<Map<String, Object>> params) {
        long beginTime = System.currentTimeMillis();
        Map<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("result", params);
        try {
            log.info("genPersonChangeForBizData() params size: {}", (Object)params.size());
            List<Map<String, Object>> successList = this.checkMustInputForBizData(params);
            log.info("genPersonChangeForBizData() successList size: {}", (Object)successList.size());
            Set salaryFileIds = params.stream().map(entry -> MapUtils.getLong((Map)entry, (Object)"salaryFileId")).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", salaryFileIds);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
            DynamicObject[] salaryFiles = helper.query("id,org.number", new QFilter[]{filter});
            Map<Long, String> sfMap = Arrays.stream(salaryFiles).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("org.number"), (k1, k2) -> k1));
            Map<String, Object> crMap = this.getChangeReason(successList, sfMap);
            ArrayList<Map<String, Object>> waitGenerateList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> notMatchList = new ArrayList<Map<String, Object>>();
            Date currentDate = this.getCurrentDate();
            successList.forEach(map -> {
                Long changeReasonId = MapUtils.getLong((Map)crMap, (Object)PersonChangeServiceHelper.getKey(map.get("salaryAdjustRsnId"), map.get("actionId"), sfMap.get(map.get("salaryFileId"))));
                if (SWCObjectUtils.isEmpty((Object)changeReasonId)) {
                    notMatchList.add((Map<String, Object>)map);
                } else {
                    map.put("changeReasonId", changeReasonId);
                    waitGenerateList.add((Map<String, Object>)map);
                }
                if (SWCObjectUtils.isEmpty(map.get("creatorId"))) {
                    map.put("creatorId", 1L);
                }
                if (SWCObjectUtils.isEmpty(map.get("changeDate"))) {
                    map.put("changeDate", currentDate);
                }
            });
            log.info("genPersonChangeForBizData() waitGenerateList size: {}", (Object)waitGenerateList.size());
            resultMap = this.genPersonChange(PersonChangeSourceEnum.BIZDATA.getCode(), waitGenerateList);
            if (MapUtils.getBoolean(resultMap, (Object)"success").booleanValue()) {
                this.afterGenPersonChange(waitGenerateList, Boolean.TRUE);
            } else if (resultMap.containsKey(STEP_SIZE_IS_FULL)) {
                this.genPersonChangeLog(PersonChangeSourceEnum.BIZDATA.getCode(), MapUtils.getString(resultMap, (Object)"message"), waitGenerateList, null, null);
                resultMap.remove(STEP_SIZE_IS_FULL);
            }
            if (CollectionUtils.isNotEmpty(notMatchList)) {
                log.info("genPersonChangeForBizData() notMatchList size: {}", (Object)notMatchList.size());
                String notMatchMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u89c4\u5219\u7ba1\u7406\u7684\u7b56\u7565\u7ba1\u7406\u914d\u7f6e\u3002", (String)"PersonChangeLogHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
                this.genPersonChangeLog(PersonChangeSourceEnum.BIZDATA.getCode(), notMatchMsg, notMatchList, crMap, sfMap);
            }
        }
        catch (Exception exp) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", exp.getMessage());
            log.error("genPersonChangeForBizData() error {0}", (Throwable)exp);
        }
        long endTime = System.currentTimeMillis();
        log.info("genPersonChangeForBizData() spend time : {}", (Object)(endTime - beginTime));
        return resultMap;
    }

    public Map<String, Object> genPersonChangeIF(List<Map<String, Object>> params) {
        Map<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("result", params);
        if (CollectionUtils.isEmpty(params)) {
            resultMap.put("success", Boolean.FALSE);
            return resultMap;
        }
        try {
            log.info("genPersonChangeIF() params size: {}", (Object)params.size());
            List successList = this.checkMustInputCommon(SOURCE_ITF, params);
            successList = this.checkDataValid(successList);
            PersonChangeSaveArgs args = new PersonChangeSaveArgs();
            args.setInputParams(successList);
            args.setReturnParams(successList);
            this.invokeCheckExtFields(args);
            successList = args.getReturnParams();
            this.convertDate(successList);
            log.info("genPersonChangeIF() successList size: {}", (Object)successList.size());
            successList.forEach(map -> {
                if (SWCObjectUtils.isEmpty(map.get("creatorId"))) {
                    map.put("creatorId", RequestContext.get().getCurrUserId());
                }
            });
            resultMap = this.genPersonChange(MapUtils.getString(params.get(0), (Object)"source"), successList);
            try {
                args.setInputParams(successList);
                this.invokeSavePersonChange(args);
            }
            catch (Exception excp) {
                log.error("genPersonChangeIF() save extended fields error {0}", (Throwable)excp);
            }
            resultMap.put("result", params);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            log.error("genPersonChangeIF() error {0}", (Throwable)e);
        }
        return resultMap;
    }

    public Map<String, Object> abandonPersonChangeIF(List<Map<String, Object>> params) {
        log.info("abandonPersonChangeIF() params size: {}", (Object)params.size());
        List<Map<String, Object>> successList = this.checkAbandonMustInput(SOURCE_ITF, params);
        successList = this.checkAbandonStatus(successList);
        log.info("abandonPersonChangeIF() successList size: {}", (Object)successList.size());
        Map<String, Object> resultMap = this.doAbandonPersonChange(SOURCE_ITF, successList);
        resultMap.put("result", params);
        return resultMap;
    }

    public Map<String, Object> abandonPersonChange(String type, List<Map<String, Object>> params) {
        log.info("abandonPersonChange() params size: {}", (Object)params.size());
        List<Map<String, Object>> successList = this.checkAbandonMustInput(type, params);
        log.info("abandonPersonChange() successList size: {}", (Object)successList.size());
        Map<String, Object> resultMap = this.doAbandonPersonChange(type, successList);
        resultMap.put("result", params);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] createPersonChange(String source, List<Map<String, Object>> params) {
        DynamicObject[] personChangeArr = new DynamicObject[]{};
        DLock lock = DLock.create((String)"CREATE_PERSON_CHANGE_LOCK");
        long beginTime = System.currentTimeMillis();
        try {
            lock.lock();
            DynamicObject[] dbPersonChangeArr = this.getPersonChanges(params);
            Map<String, DynamicObject> dbMap = Arrays.stream(dbPersonChangeArr).collect(Collectors.toMap(dy -> PersonChangeServiceHelper.getKey(dy.getLong("salaryfile.id"), dy.getLong("changereason.id"), SWCDateTimeUtils.format((Date)dy.getDate("changedate"), (String)"yyyy-MM-dd")), dy -> dy, (k1, k2) -> k1));
            Map<String, List<Map>> pMap = params.stream().collect(Collectors.groupingBy(item -> PersonChangeServiceHelper.getKey(MapUtils.getLong((Map)item, (Object)"salaryFileId"), MapUtils.getLong((Map)item, (Object)"changeReasonId"), SWCDateTimeUtils.format((Date)((Date)MapUtils.getObject((Map)item, (Object)"changeDate")), (String)"yyyy-MM-dd"))));
            long[] ids = DB.genLongIds((String)"hsas_personchange", (int)pMap.size());
            ArrayList<Long> personChangeIds = new ArrayList<Long>(ids.length);
            ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(params.size());
            ArrayList<Map<String, Object>> waitCreateList = new ArrayList<Map<String, Object>>(params.size());
            ArrayList<DynamicObject> personChangeList = new ArrayList<DynamicObject>(pMap.size());
            int index = 0;
            for (Map.Entry<String, List<Map>> entry : pMap.entrySet()) {
                List<Map<String, Object>> entryValues = entry.getValue();
                DynamicObject dbPersonChange = dbMap.get(entry.getKey());
                if (!SWCObjectUtils.isEmpty((Object)dbPersonChange)) {
                    successList.addAll(entryValues);
                    personChangeIds.add(dbPersonChange.getLong("id"));
                    this.writeBackProcessing(entryValues, dbPersonChange);
                    continue;
                }
                Map param = entryValues.get(0);
                DynamicObject personChange = this.initPersonChange(ids[index], source, param);
                personChangeIds.add(ids[index]);
                personChangeList.add(personChange);
                waitCreateList.addAll(entryValues);
                this.writeBackProcessing(entryValues, personChange);
                ++index;
            }
            if (CollectionUtils.isNotEmpty(personChangeList)) {
                try (TXHandle txHandle = TX.requiresNew();){
                    pcHelper.save(personChangeList.toArray(new DynamicObject[personChangeList.size()]));
                    successList.addAll(waitCreateList);
                    txHandle.commit();
                }
            }
            this.markOperationResult(successList, Boolean.TRUE, null);
            QFilter filter = new QFilter("id", "in", personChangeIds);
            personChangeArr = pcHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_personchange"), new QFilter[]{filter});
        }
        finally {
            lock.unlock();
        }
        long endTime = System.currentTimeMillis();
        log.info("createPersonChange() spend time : {}", (Object)(endTime - beginTime));
        return personChangeArr;
    }

    private void genPersonChangeLog(String source, String errorMsg, List<Map<String, Object>> params, Map<String, Object> errorMap, Map<Long, String> sfMap) {
        ArrayList<DynamicObject> waitCreateList = new ArrayList<DynamicObject>(params.size());
        for (Map<String, Object> param : params) {
            String returnMsg = errorMsg;
            if (MapUtils.isNotEmpty(errorMap) && MapUtils.isNotEmpty(sfMap) && SWCStringUtils.isEmpty((String)(returnMsg = MapUtils.getString(errorMap, (Object)PersonChangeServiceHelper.getKey(param.get("salaryAdjustRsnId"), param.get("actionId"), sfMap.get(param.get("salaryFileId")), ERROR_MSG))))) {
                returnMsg = errorMsg;
            }
            DynamicObject dy = this.initPersonChangeLog(source, returnMsg, param);
            waitCreateList.add(dy);
        }
        if (CollectionUtils.isNotEmpty(waitCreateList)) {
            pcLogHelper.save(waitCreateList.toArray(new DynamicObject[waitCreateList.size()]));
        }
    }

    private Map<String, Object> doAbandonPersonChange(String source, List<Map<String, Object>> params) {
        log.info("doAbandonPersonChange() params size is : {}", (Object)params.size());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("result", params);
        if (CollectionUtils.isEmpty(params)) {
            return resultMap;
        }
        try {
            switch (source) {
                case "-1": {
                    this.doAbandonPersonChangeIF(params);
                    break;
                }
                case "2": {
                    this.doAbandonPersonChangeFromBizData(params);
                    break;
                }
            }
            this.markOperationResult(params, Boolean.TRUE, null);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5185\u90e8\u5f02\u5e38\u3002\u5e9f\u5f03\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u5931\u8d25\u3002", (String)"PersonChangeServiceHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", msg);
            this.markOperationResult(params, Boolean.FALSE, msg);
            log.error("genPersonChange() error : {}", (Object)e.getMessage());
        }
        return resultMap;
    }

    private void doAbandonPersonChangeFromBizData(List<Map<String, Object>> params) {
        DynamicObject[] personChanges;
        Set<Long> waitAbandonIds;
        HashSet<Long> bizDataIds = new HashSet<Long>(params.size());
        HashSet<String> keySet = new HashSet<String>(params.size());
        for (Map<String, Object> param : params) {
            bizDataIds.add(MapUtils.getLong(param, (Object)"bizDataId"));
            keySet.add(PersonChangeServiceHelper.getKey(MapUtils.getLong(param, (Object)"bizDataId"), MapUtils.getString(param, (Object)"cycle")));
        }
        QFilter bizFilter = new QFilter("bizdataid", "in", bizDataIds);
        Object[] bizDyArr = bizDataHelper.query("id, personchange.id, bizdataid, cycle", new QFilter[]{bizFilter});
        if (SWCArrayUtils.isEmpty((Object[])bizDyArr)) {
            return;
        }
        List bizDys = Arrays.stream(bizDyArr).filter(dy -> keySet.contains(PersonChangeServiceHelper.getKey(dy.getLong("bizdataid"), dy.getString("cycle")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bizDys)) {
            return;
        }
        ArrayList<Object> pkIds = new ArrayList<Object>(bizDys.size());
        HashSet<Long> pcIds = new HashSet<Long>(bizDys.size());
        for (DynamicObject bizDy : bizDys) {
            pkIds.add(bizDy.getPkValue());
            pcIds.add(bizDy.getLong("personchange.id"));
        }
        bizDataHelper.delete(pkIds.toArray());
        QFilter bizFilterNew = new QFilter("personchange.id", "in", pcIds);
        Object[] bizDyArrNew = bizDataHelper.query("id, personchange.id", new QFilter[]{bizFilterNew});
        if (SWCArrayUtils.isEmpty((Object[])bizDyArrNew)) {
            waitAbandonIds = pcIds;
        } else {
            Set pcIdSet = Arrays.stream(bizDyArrNew).map(dy -> dy.getLong("personchange.id")).collect(Collectors.toSet());
            waitAbandonIds = pcIds.stream().filter(id -> !pcIdSet.contains(id)).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(waitAbandonIds)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", waitAbandonIds);
        for (DynamicObject personChange : personChanges = pcHelper.query("id, status", new QFilter[]{filter})) {
            personChange.set("status", (Object)"0");
        }
        pcHelper.update(personChanges);
    }

    private void doAbandonPersonChangeIF(List<Map<String, Object>> params) {
        List personChangeIds = params.stream().map(param -> MapUtils.getLong((Map)param, (Object)"personChange")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", personChangeIds);
        DynamicObject[] personChangeArr = pcHelper.query("id, salaryfile.id, status, generatedstatus, errormsg", new QFilter[]{filter});
        List<DynamicObject> personChanges = Arrays.stream(personChangeArr).filter(dy -> "1".equals(dy.getString("generatedstatus"))).collect(Collectors.toList());
        List<Map<String, Object>> result = PersonChangeServiceHelper.abandonProrationEvent(personChanges);
        Map<Long, String> failMap = result.stream().filter(item -> 200 != MapUtils.getIntValue((Map)item, (Object)"code")).collect(Collectors.toMap(item -> MapUtils.getLong((Map)item, (Object)"personChange"), item -> MapUtils.getString((Map)item, (Object)"message")));
        for (DynamicObject personChange : personChangeArr) {
            personChange.set("status", (Object)"0");
            String errorMsg = failMap.get(personChange.getLong("id"));
            if (!SWCStringUtils.isNotEmpty((String)errorMsg)) continue;
            personChange.set("errormsg", (Object)errorMsg);
        }
        pcHelper.update(personChangeArr);
    }

    private List<Map<String, Object>> checkMustInputCommon(String source, List<Map<String, Object>> params) {
        String msgStart = ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a", (String)"PersonChangeServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgSalaryFIle = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848", (String)"PersonChangeServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgChangeReason = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0", (String)"PersonChangeServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgChangeDate = ResManager.loadKDString((String)"\u53d8\u52a8\u65e5\u671f", (String)"PersonChangeServiceHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgTask = ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1", (String)"PersonChangeServiceHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgSource = ResManager.loadKDString((String)"\u6765\u6e90", (String)"PersonChangeServiceHelper_19", (String)"swc-hsas-business", (Object[])new Object[0]);
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> param : params) {
            Boolean flag = Boolean.TRUE;
            StringBuilder stringBuilder = new StringBuilder();
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"salaryFileId"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(msgSalaryFIle);
            }
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"changeReasonId"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgChangeReason);
            }
            if (SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"changeDate"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgChangeDate);
            }
            if (PersonChangeSourceEnum.COLLA.getCode().equals(source) && SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"taskCenterId"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgTask);
            }
            if (SOURCE_ITF.equals(source) && SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"source"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgSource);
            }
            if (flag.booleanValue()) {
                successList.add(param);
                continue;
            }
            param.put("success", Boolean.FALSE);
            param.put("message", msgStart + stringBuilder);
        }
        return successList;
    }

    private List<Map<String, Object>> checkMustInputForBizData(List<Map<String, Object>> params) {
        String msgStart = ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a", (String)"PersonChangeServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgSalaryFIle = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848", (String)"PersonChangeServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgBizDataId = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636eID", (String)"PersonChangeServiceHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgBizDataCode = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7", (String)"PersonChangeServiceHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgCycle = ResManager.loadKDString((String)"\u5faa\u73af\u9879", (String)"PersonChangeServiceHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgActionAndSalary = ResManager.loadKDString((String)"\u201c\u5b9a\u8c03\u85aa\u7c7b\u578b\u201d\u548c\u201c\u4e1a\u52a1\u64cd\u4f5c\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"PersonChangeServiceHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]);
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> param : params) {
            Boolean flag = Boolean.TRUE;
            StringBuilder builder = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"salaryFileId"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(msgSalaryFIle);
            }
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"bizDataId"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgBizDataId);
            }
            if (SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"bizDataCode"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgBizDataCode);
            }
            if (SWCStringUtils.isEmpty((String)MapUtils.getString(param, (Object)"cycle"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgCycle);
            }
            if (!flag.booleanValue()) {
                builder.append(msgStart);
            }
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"salaryAdjustRsnId")) && SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"actionId"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\uff1b');
                }
                stringBuilder.append(msgActionAndSalary);
            }
            if (flag.booleanValue()) {
                successList.add(param);
                continue;
            }
            param.put("success", Boolean.FALSE);
            param.put("message", builder.append((CharSequence)stringBuilder).toString());
        }
        return successList;
    }

    private List<Map<String, Object>> checkAbandonMustInput(String type, List<Map<String, Object>> params) {
        List<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(10);
        switch (type) {
            case "-1": {
                successList = this.checkAbandonMustInputIF(params);
                break;
            }
            case "2": {
                successList = this.checkAbandonMustInputBizData(params);
                break;
            }
        }
        return successList;
    }

    private List<Map<String, Object>> checkAbandonMustInputIF(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(params.size());
        String msgStart = ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a", (String)"PersonChangeServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgPcId = ResManager.loadKDString((String)"\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55ID", (String)"PersonChangeServiceHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        String errMsg = msgStart + msgPcId;
        for (Map<String, Object> param : params) {
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"personChange"))) {
                param.put("success", Boolean.FALSE);
                param.put("message", errMsg);
                continue;
            }
            successList.add(param);
        }
        return successList;
    }

    private List<Map<String, Object>> checkAbandonMustInputBizData(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>();
        String msgStart = ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a", (String)"PersonChangeServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgBizDataId = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636eID", (String)"PersonChangeServiceHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgCycle = ResManager.loadKDString((String)"\u5faa\u73af\u9879", (String)"PersonChangeServiceHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Object> param : params) {
            Boolean flag = Boolean.TRUE;
            StringBuilder builder = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"bizDataId"))) {
                flag = Boolean.FALSE;
                stringBuilder.append(msgBizDataId);
            }
            if (SWCObjectUtils.isEmpty((Object)MapUtils.getLong(param, (Object)"cycle"))) {
                flag = Boolean.FALSE;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\u3001');
                }
                stringBuilder.append(msgCycle);
            }
            if (flag.booleanValue()) {
                successList.add(param);
                continue;
            }
            builder.append(msgStart);
            param.put("success", Boolean.FALSE);
            param.put("message", builder.append((CharSequence)stringBuilder).toString());
        }
        return successList;
    }

    private List<Map<String, Object>> checkAbandonStatus(List<Map<String, Object>> params) {
        String notExistsMsg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"PersonChangeServiceHelper_18", (String)"swc-hsas-business", (Object[])new Object[0]);
        String statusErrMsg = ResManager.loadKDString((String)"{0}\uff1a\u8be5\u6570\u636e\u5df2\u5e9f\u5f03\u3002", (String)"PersonChangeServiceHelper_17", (String)"swc-hsas-business", (Object[])new Object[0]);
        List personChangeIds = params.stream().map(param -> MapUtils.getLong((Map)param, (Object)"personChange")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", personChangeIds);
        DynamicObject[] personChanges = pcHelper.query("id, number, status", new QFilter[]{filter});
        Map<Long, DynamicObject> pcStatusMap = Arrays.stream(personChanges).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(personChanges.length);
        for (Map<String, Object> param2 : params) {
            DynamicObject personChange = pcStatusMap.get(MapUtils.getLong(param2, (Object)"personChange"));
            if (SWCObjectUtils.isEmpty((Object)personChange)) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", notExistsMsg);
                continue;
            }
            if ("0".equals(personChange.getString("status"))) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", MessageFormat.format(statusErrMsg, personChange.getString("number")));
                continue;
            }
            successList.add(param2);
        }
        return successList;
    }

    private List<Map<String, Object>> checkDataValid(List<Map<String, Object>> params) {
        String msgSalaryFileNotExists = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u5b58\u5728\u3002", (String)"PersonChangeServiceHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgSalaryFileInvalid = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u53d8\u52a8\u8bb0\u5f55\u3002", (String)"PersonChangeServiceHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgChangeReasonNotExists = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e0d\u5b58\u5728\u3002", (String)"PersonChangeServiceHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgChangeReasonInvalid = ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0\u4e0d\u53ef\u7528\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u53d8\u52a8\u8bb0\u5f55\u3002", (String)"PersonChangeServiceHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        ArrayList salaryFileIds = new ArrayList(params.size());
        ArrayList changeReasonIds = new ArrayList(params.size());
        params.forEach(param -> {
            salaryFileIds.add(MapUtils.getLong((Map)param, (Object)"salaryFileId"));
            changeReasonIds.add(MapUtils.getLong((Map)param, (Object)"changeReasonId"));
        });
        QFilter crFilter = new QFilter("id", "in", changeReasonIds);
        DynamicObject[] changeReasonArr = changeReasonHelper.query("id, enable", crFilter.toArray());
        Map<Long, DynamicObject> crMap = Arrays.stream(changeReasonArr).collect(Collectors.toMap(cr -> cr.getLong("id"), cr -> cr, (k1, k2) -> k1));
        QFilter sfFilter = new QFilter("id", "in", salaryFileIds);
        DynamicObject[] salaryFileArr = salaryFileHelper.query("id, status", sfFilter.toArray());
        Map<Long, DynamicObject> sfMap = Arrays.stream(salaryFileArr).collect(Collectors.toMap(sf -> sf.getLong("id"), sf -> sf, (k1, k2) -> k1));
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(params.size());
        for (Map<String, Object> param2 : params) {
            DynamicObject dy = sfMap.get(MapUtils.getLong(param2, (Object)"salaryFileId"));
            if (SWCObjectUtils.isEmpty((Object)dy)) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", msgSalaryFileNotExists);
                continue;
            }
            if (!"C".equals(dy.getString("status"))) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", msgSalaryFileInvalid);
                continue;
            }
            dy = crMap.get(MapUtils.getLong(param2, (Object)"changeReasonId"));
            if (SWCObjectUtils.isEmpty((Object)dy)) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", msgChangeReasonNotExists);
                continue;
            }
            if (!dy.getBoolean("enable")) {
                param2.put("success", Boolean.FALSE);
                param2.put("message", msgChangeReasonInvalid);
                continue;
            }
            successList.add(param2);
        }
        return successList;
    }

    private DynamicObject[] getPersonChanges(List<Map<String, Object>> params) {
        HashSet<Long> salaryFileIds = new HashSet<Long>(params.size());
        HashSet<Long> changeReasonIds = new HashSet<Long>(params.size());
        HashSet<Date> changeDates = new HashSet<Date>(params.size());
        for (Map<String, Object> param : params) {
            salaryFileIds.add(MapUtils.getLong(param, (Object)"salaryFileId"));
            changeReasonIds.add(MapUtils.getLong(param, (Object)"changeReasonId"));
            changeDates.add((Date)MapUtils.getObject(param, (Object)"changeDate"));
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"1");
        qFilter.and("salaryfile.id", "in", salaryFileIds);
        qFilter.and("changereason.id", "in", changeReasonIds);
        qFilter.and("changedate", "in", changeDates);
        DynamicObject[] personChangeArr = pcHelper.query("id, number, salaryfile.id, changereason.id, changedate", new QFilter[]{qFilter});
        return personChangeArr;
    }

    private DynamicObject[] getPersonChgBizDatas(Set<Long> personChangeIds, Set<Long> bizDataIds) {
        QFilter filter = new QFilter("personchange.id", "in", personChangeIds);
        filter.and("bizdataid", "in", bizDataIds);
        DynamicObject[] personChgBizDataArr = bizDataHelper.query("personchange.id, bizdataid", new QFilter[]{filter});
        return personChgBizDataArr;
    }

    private DynamicObject initPersonChange(Long id, String source, Map<String, Object> param) {
        DynamicObject personChange = (DynamicObject)personChangeType.createInstance();
        personChange.set("id", (Object)id);
        try {
            personChange.set("number", (Object)CodeRuleHelper.getNumber((DynamicObject)personChange, null));
        }
        catch (Exception exp) {
            throw new KDException((Throwable)exp, new ErrorCode(STEP_SIZE_IS_FULL, exp.getMessage()), new Object[0]);
        }
        personChange.set("status", (Object)"1");
        personChange.set("salaryfile_id", param.get("salaryFileId"));
        personChange.set("changereason_id", param.get("changeReasonId"));
        personChange.set("changedate", param.get("changeDate"));
        personChange.set("source", param.getOrDefault("source", source));
        personChange.set("action_id", param.get("actionId"));
        personChange.set("taskcenter_id", param.get("taskCenterId"));
        if (!SWCObjectUtils.isEmpty((Object)param.get("creatorId"))) {
            personChange.set("creator_id", param.get("creatorId"));
        }
        return personChange;
    }

    private DynamicObject initPersonChangeLog(String source, String errorMsg, Map<String, Object> param) {
        DynamicObject personChangeLog = (DynamicObject)personChangeLogType.createInstance();
        personChangeLog.set("bizdataid", param.get("bizDataId"));
        personChangeLog.set("bizdatacode", param.get("bizDataCode"));
        personChangeLog.set("cycle", param.get("cycle"));
        personChangeLog.set("salaryfile_id", param.get("salaryFileId"));
        personChangeLog.set("salaryadjustrsn_id", param.get("salaryAdjustRsnId"));
        personChangeLog.set("action_id", param.get("actionId"));
        personChangeLog.set("changedate", param.get("changeDate"));
        personChangeLog.set("status", (Object)"0");
        personChangeLog.set("errormsg", (Object)errorMsg);
        personChangeLog.set("operatedate", (Object)new Date());
        personChangeLog.set("source", (Object)source);
        return personChangeLog;
    }

    private void handlerPersonChgBizData(Long personChangeId, List<Map<String, Object>> params, List<DynamicObject> personChgBizDataList) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_personchgbizdata");
        for (Map<String, Object> param : params) {
            DynamicObject dy = (DynamicObject)personChgBizDataType.createInstance();
            dy.set("personchange", (Object)personChangeId);
            dy.set("bizdataid", param.get("bizDataId"));
            dy.set("cycle", param.get("cycle"));
            personChgBizDataList.add(dy);
        }
    }

    private void markOperationResult(List<Map<String, Object>> params, Boolean result, String msg) {
        for (Map<String, Object> param : params) {
            param.put("success", result);
            param.put("message", msg);
        }
    }

    private Map<String, Object> getChangeReason(List<Map<String, Object>> params, Map<Long, String> sfMap) {
        Map<String, List<Map>> gMap = params.stream().collect(Collectors.groupingBy(item -> PersonChangeServiceHelper.getKey(item.get("salaryAdjustRsnId"), item.get("actionId"), sfMap.get(item.get("salaryFileId")))));
        HashMap<String, Object> resMap = new HashMap<String, Object>(gMap.size());
        for (Map.Entry<String, List<Map>> entry : gMap.entrySet()) {
            Map map = entry.getValue().get(0);
            String buNumber = MapUtils.getString(sfMap, map.get("salaryFileId"));
            Long salaryAdjustRsnId = MapUtils.getLong((Map)map, (Object)"salaryAdjustRsnId");
            Long actionId = MapUtils.getLong((Map)map, (Object)"actionId");
            this.callRuleEngine(buNumber, salaryAdjustRsnId, actionId, entry.getKey(), resMap);
        }
        return resMap;
    }

    public void callRuleEngine(String buNumber, Long salaryAdjustRsnId, Long actionId, String key, Map<String, Object> result) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("cloudId", "/U+QDTL900//");
        requestMap.put("bizApp", "hsas");
        requestMap.put("sceneNumber", "SCENE202303151725");
        requestMap.put("buNumber", buNumber);
        HashMap<String, DynamicObject> inputParam = new HashMap<String, DynamicObject>(16);
        inputParam.put("hsbs_salaryadjustrsn", this.getDynamicInfo("hsbs_salaryadjustrsn", salaryAdjustRsnId, "id"));
        inputParam.put("hbss_action", this.getDynamicInfo("hbss_action", actionId, "id"));
        requestMap.put("inputParams", inputParam);
        log.info("RequestContext : {}", (Object)RequestContext.get());
        Map resultMap = (Map)SWCMServiceUtils.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngineForOriginal", (Object[])new Object[]{requestMap});
        log.info("PersonChangeServiceHelper.callRuleEngine resultMap: {}", (Object)resultMap);
        this.convertRuleResponse(resultMap, key, result);
    }

    private void convertRuleResponse(Map<String, Object> resultMap, String key, Map<String, Object> result) {
        String responseCode = String.valueOf(resultMap.get("responseCode"));
        if (!"200".equals(responseCode)) {
            String errorMsg = MapUtils.getString(resultMap, (Object)ERROR_MSG);
            result.put(PersonChangeServiceHelper.getKey(key, ERROR_MSG), errorMsg);
            return;
        }
        List policys = (List)resultMap.get("policyResults");
        if (CollectionUtils.isEmpty((Collection)policys)) {
            return;
        }
        for (Map policy : policys) {
            List matchRules = (List)policy.get("ruleResults");
            if (CollectionUtils.isEmpty((Collection)matchRules)) continue;
            for (Map matchRule : matchRules) {
                List matchResults = (List)matchRule.get("matchResults");
                if (CollectionUtils.isEmpty((Collection)matchResults)) continue;
                result.put(key, MapUtils.getLong((Map)((Map)matchResults.get(0)), (Object)"value"));
                return;
            }
        }
    }

    private DynamicObject getDynamicInfo(String entityName, Long filterId, String filterField) {
        if (null == filterId || filterId == 0L) {
            return null;
        }
        log.info(MessageFormat.format("ERManFileListGetDynamicInfo==={0}", filterId));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter(filterField, "=", (Object)filterId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return serviceHelper.loadDynamicObject(qFilters);
    }

    private Date getCurrentDate() {
        Date now = new Date();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(now);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.set(14, 0);
        return cal1.getTime();
    }

    public static QFilter getFilterHasPermOrg(String fieldKey) {
        HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_personchangelog", (String)"47150e89000000ac");
        if (permOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List orgIds = permOrgResult.getHasPermOrgs();
        if (null == orgIds) {
            return new QFilter("1", "!=", (Object)1);
        }
        return new QFilter(fieldKey, "in", (Object)orgIds);
    }

    public void afterGenPersonChange(List<Map<String, Object>> params, Boolean needLog) {
        String errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u53d8\u52a8\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PersonChangeServiceHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        Object[] dbPersonChangeArr = this.getPersonChanges(params);
        HashMap<String, Object> errorMap = new HashMap<String, Object>(16);
        HashMap<Long, String> sfMap = new HashMap<Long, String>(16);
        if (SWCArrayUtils.isEmpty((Object[])dbPersonChangeArr) && needLog.booleanValue()) {
            this.genPersonChangeLog(PersonChangeSourceEnum.BIZDATA.getCode(), errorMsg, params, errorMap, sfMap);
            return;
        }
        Set<Long> personChangeIds = Arrays.stream(dbPersonChangeArr).filter(dy -> !SWCObjectUtils.isEmpty((Object)dy)).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(personChangeIds)) {
            return;
        }
        Map<String, Long> dbMap = Arrays.stream(dbPersonChangeArr).collect(Collectors.toMap(dy -> PersonChangeServiceHelper.getKey(dy.getLong("salaryfile.id"), dy.getLong("changereason.id"), SWCDateTimeUtils.format((Date)dy.getDate("changedate"), (String)"yyyy-MM-dd")), dy -> dy.getLong("id"), (k1, k2) -> k1));
        Map<String, List<Map>> pMap = params.stream().collect(Collectors.groupingBy(item -> PersonChangeServiceHelper.getKey(MapUtils.getLong((Map)item, (Object)"salaryFileId"), MapUtils.getLong((Map)item, (Object)"changeReasonId"), SWCDateTimeUtils.format((Date)((Date)MapUtils.getObject((Map)item, (Object)"changeDate")), (String)"yyyy-MM-dd"))));
        Set<Long> allBizDataIds = params.stream().map(param -> MapUtils.getLong((Map)param, (Object)"bizDataId")).collect(Collectors.toSet());
        DynamicObject[] personChgBizDataArr = this.getPersonChgBizDatas(personChangeIds, allBizDataIds);
        Map relateMap = Arrays.stream(personChgBizDataArr).collect(Collectors.groupingBy(dy -> dy.getLong("personchange.id"), Collectors.mapping(dy -> dy.getLong("bizdataid"), Collectors.toSet())));
        ArrayList<Map<String, Object>> waitCreateLogList = new ArrayList<Map<String, Object>>(params.size());
        ArrayList<Map<String, Object>> waitCreateList = new ArrayList<Map<String, Object>>(params.size());
        ArrayList<DynamicObject> personChgBizDataList = new ArrayList<DynamicObject>(params.size());
        for (Map.Entry<String, List<Map>> entry : pMap.entrySet()) {
            List<Map> entryValues = entry.getValue();
            Long personChangeId = dbMap.get(entry.getKey());
            if (null != personChangeId && 0L != personChangeId) {
                Set bizDataIds = relateMap.getOrDefault(personChangeId, new HashSet());
                List<Map<String, Object>> unRelatedList = entryValues.stream().filter(subMap -> !bizDataIds.contains(MapUtils.getLong((Map)subMap, (Object)"bizDataId"))).collect(Collectors.toList());
                this.handlerPersonChgBizData(personChangeId, unRelatedList, personChgBizDataList);
                waitCreateList.addAll(unRelatedList);
                continue;
            }
            waitCreateLogList.addAll(entryValues);
        }
        try {
            if (CollectionUtils.isNotEmpty(personChgBizDataList)) {
                bizDataHelper.save(personChgBizDataList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            log.error("afterGenPersonChange() save personChgBizData fail : {}", (Object)e.getMessage());
            waitCreateLogList.addAll(waitCreateList);
        }
        if (needLog.booleanValue() && CollectionUtils.isNotEmpty(waitCreateLogList)) {
            this.genPersonChangeLog(PersonChangeSourceEnum.BIZDATA.getCode(), errorMsg, waitCreateLogList, errorMap, sfMap);
        }
    }

    private void convertDate(List<Map<String, Object>> params) {
        for (Map<String, Object> param : params) {
            Object changeDate = param.get("changeDate");
            if (changeDate instanceof Date) continue;
            try {
                Date newChangeDate = SWCDateTimeUtils.parseDate((String)String.valueOf(changeDate));
                param.put("changeDate", newChangeDate);
            }
            catch (ParseException e) {
                log.error("ChangeDate Format Error!");
            }
        }
    }

    private void writeBackProcessing(List<Map<String, Object>> params, DynamicObject personChange) {
        for (Map<String, Object> param : params) {
            param.put("personChange", personChange.getLong("id"));
            param.put("number", personChange.getString("number"));
        }
    }

    private void invokeCheckExtFields(PersonChangeSaveArgs args) {
        PersonChangeGenerateExtService extService = new PersonChangeGenerateExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IPersonChangeGenerateExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.personchange.IPersonChangeGenerateExtService#checkExtFields", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.checkExtFields(args);
            return null;
        });
    }

    private void invokeSavePersonChange(PersonChangeSaveArgs args) {
        PersonChangeGenerateExtService extService = new PersonChangeGenerateExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IPersonChangeGenerateExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.personchange.IPersonChangeGenerateExtService#savePersonChange", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.savePersonChange(args);
            return null;
        });
    }
}

