/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.personhr;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class AdminOrgCompanyChangeHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgCompanyChangeHelper.class);
    private static final String KEY_IS_SUCCESS = "isSuccess";
    private static final String KEY_ERROR_MSG = "errorMsg";
    private static final HRBaseServiceHelper EMPPOSORGREL_SERVICE_HELPER = new HRBaseServiceHelper("hsas_empposorgrelhr");
    private static final HRBaseServiceHelper CMPEMP_SERVICE_HELPER = new HRBaseServiceHelper("hsas_cmpemp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> companyChangeSync(Set<Long> orgBoIdSet, Long companyId, Date effectDate) {
        LOGGER.info("AdminOrgCompanyChangeHelper.companyChangeSync start , orgBoIdSet:{}, companyId:{}, effectDate:{},", new Object[]{orgBoIdSet, companyId, effectDate});
        long start = System.currentTimeMillis();
        Map<String, Object> resultMap = AdminOrgCompanyChangeHelper.successMap();
        try {
            DynamicObjectCollection empposDyColl = EMPPOSORGREL_SERVICE_HELPER.queryOriginalCollection("id,boid,cmpemp.id,depemp.id,adminorg.id,company.id,isprimary", new QFilter[]{new QFilter("adminorg.id", "in", orgBoIdSet), new QFilter("company.id", "!=", (Object)companyId)});
            if (empposDyColl.isEmpty()) {
                LOGGER.info("AdminOrgCompanyChangeHelper.companyChangeSync not data update.");
                Map<String, Object> map = resultMap;
                return map;
            }
            ArrayList<Long> empposBoid = new ArrayList<Long>(empposDyColl.size());
            ArrayList<Long> cmpempBoid = new ArrayList<Long>(empposDyColl.size());
            empposDyColl.forEach(empposDy -> {
                long boid = empposDy.getLong("id");
                empposBoid.add(boid);
                String isprimary = empposDy.getString("isprimary");
                if (HRStringUtils.equals((String)isprimary, (String)"1")) {
                    long cmpempId = empposDy.getLong("cmpemp.id");
                    cmpempBoid.add(cmpempId);
                }
            });
            try (TXHandle required = TX.required();){
                try {
                    AdminOrgCompanyChangeHelper.updateEmpposorgrel(empposBoid, companyId);
                    AdminOrgCompanyChangeHelper.updateCmpemp(cmpempBoid, companyId);
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.error("AdminOrgCompanyChangeHelper.companyChangeSync updateError! {}", (Object)ex.getMessage(), (Object)ex);
                    AdminOrgCompanyChangeHelper.setFail(resultMap, ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("AdminOrgCompanyChangeHelper.companyChangeSync error! {}", (Object)e.getMessage(), (Object)e);
            AdminOrgCompanyChangeHelper.setFail(resultMap, e.getMessage());
        }
        finally {
            LOGGER.info("AdminOrgCompanyChangeHelper.companyChangeSync end. time is: {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        return resultMap;
    }

    private static void updateEmpposorgrel(List<Long> empposBoid, Long companyId) {
        DynamicObject[] empposDyArr;
        LOGGER.info("AdminOrgCompanyChangeHelper.companyChangeSync adminOrgInfoQuery, updateEmpposorgrel empposBoid:{}", empposBoid);
        for (DynamicObject empposDy : empposDyArr = EMPPOSORGREL_SERVICE_HELPER.query("id,boid,adminorg,company", new QFilter[]{new QFilter("id", "in", empposBoid)})) {
            empposDy.set("company", (Object)companyId);
        }
        EMPPOSORGREL_SERVICE_HELPER.update(empposDyArr);
    }

    private static void updateCmpemp(List<Long> cmpempBoid, Long companyId) {
        LOGGER.info("AdminOrgCompanyChangeHelper.companyChangeSync updateCmpemp, updateEmpposorgrel cmpempBoid:{}", cmpempBoid);
        if (CollectionUtils.isNotEmpty(cmpempBoid)) {
            DynamicObject[] cmpempDyArr;
            for (DynamicObject cmpempDy : cmpempDyArr = CMPEMP_SERVICE_HELPER.query("id,boid,company", new QFilter[]{new QFilter("boid", "in", cmpempBoid)})) {
                cmpempDy.set("company", (Object)companyId);
            }
            CMPEMP_SERVICE_HELPER.update(cmpempDyArr);
        }
    }

    private static Map<String, Object> successMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(KEY_IS_SUCCESS, true);
        resultMap.put(KEY_ERROR_MSG, "");
        return resultMap;
    }

    private static void setFail(Map<String, Object> resultMap, String errMsg) {
        resultMap.put(KEY_IS_SUCCESS, false);
        resultMap.put(KEY_ERROR_MSG, errMsg);
    }
}

