/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.personhr;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.person.IPersonExtService;
import kd.swc.hsas.business.personhr.PersonExtService;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class PersonServiceHelper {
    private static final Log LOG = LogFactory.getLog(PersonServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";
    private static final String KEY_DATA = "data";
    private static final int BATCH_SIZE_MAX = 10000;
    private static final String KEY_DEALINFO = "dealInfo";
    private static final String HSAS_DATAUPDATELOG = "hsas_dataupdatelog";
    private static final String MAINOP = "modifyPersonNumber";
    private static final String CHILDOP = "hsas";

    public Map<String, Object> modifyPersonNumber(Map<String, Object> param) {
        LOG.info("call...PersonServiceHelper.modifyPersonNumber...begin...{}", (Object)SerializationUtils.toJsonString(param));
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (!param.containsKey(KEY_DEALINFO)) {
            param.put(KEY_DEALINFO, new LinkedHashMap(16));
        }
        if (!param.containsKey("batchnum")) {
            param.put("batchnum", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSSS"));
        }
        try {
            if (!this.validateParam(param)) {
                throw new RuntimeException(String.valueOf(result.get(KEY_MSG)));
            }
            this.dealModifyPersonNumberITC(param);
            this.dealModifyPersonNumberHCDM(param);
            this.dealModifyPersonNumberExt(param);
            this.dealModifyPersonNumberSWC(param);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put(KEY_DATA, param);
            this.generateSuccessLog(param);
        }
        catch (Exception ex) {
            LOG.error("call...PersonServiceHelper.modifyPersonNumber...runerror...", (Throwable)ex);
            result.put(KEY_SUCCESS, Boolean.FALSE);
            String msg = ex.getMessage();
            if (msg != null && msg.length() >= 497) {
                msg = msg.substring(0, 497) + "...";
            }
            result.put(KEY_MSG, msg);
            this.generateFailLog(param, msg);
        }
        LOG.info("call...PersonServiceHelper.modifyPersonNumber...end...{}", (Object)SerializationUtils.toJsonString(param));
        return result;
    }

    private void generateFailLog(Map<String, Object> param, String msg) {
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(HSAS_DATAUPDATELOG);
        DynamicObject logDy = logHelper.generateEmptyDynamicObject();
        logDy.set("batchnum", param.get("batchnum"));
        logDy.set("mainop", (Object)MAINOP);
        logDy.set("childop", (Object)CHILDOP);
        logDy.set("updatestatus", (Object)"F");
        logDy.set("logdatatype", (Object)"T");
        logDy.set("errormsg", (Object)msg);
        logDy.set("remark", (Object)SerializationUtils.toJsonString(param));
        logHelper.saveOne(logDy);
    }

    private void generateSuccessLog(Map<String, Object> param) {
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(HSAS_DATAUPDATELOG);
        DynamicObject logDy = logHelper.generateEmptyDynamicObject();
        logDy.set("batchnum", param.get("batchnum"));
        logDy.set("mainop", (Object)MAINOP);
        logDy.set("childop", (Object)CHILDOP);
        logDy.set("updatestatus", (Object)"S");
        logDy.set("logdatatype", (Object)"T");
        logDy.set("remark", (Object)SerializationUtils.toJsonString(param));
        logHelper.saveOne(logDy);
    }

    private void dealModifyPersonNumberHCDM(Map<String, Object> param) {
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberHCDM..begin...param={}", (Object)SerializationUtils.toJsonString(param));
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hcdm", (String)"IHCDMPersonService", (String)MAINOP, (Object[])new Object[]{param});
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberHCDM..end...result={}", (Object)SerializationUtils.toJsonString((Object)result));
        if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
            throw new RuntimeException((String)result.get(KEY_MSG));
        }
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.putAll((Map)((Map)result.get(KEY_DATA)).get(KEY_DEALINFO));
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberHCDM..end...param={}", (Object)SerializationUtils.toJsonString(param));
    }

    private void dealModifyPersonNumberSWC(Map<String, Object> param) {
        try (TXHandle txHandle = TX.required();){
            List datas = (List)param.get(KEY_DATA);
            HashSet<String> oriNumbers = new HashSet<String>(16);
            ArrayList<String> empnumbers = new ArrayList<String>(10);
            HashMap<String, String> numberMap = new HashMap<String, String>(16);
            for (Map data : datas) {
                String oriNumber = String.valueOf(data.get("oriNumber"));
                String newNumber = String.valueOf(data.get("newNumber"));
                oriNumbers.add(oriNumber);
                empnumbers.add(oriNumber);
                empnumbers.add(newNumber);
                numberMap.put(oriNumber, newNumber);
            }
            this.dealModifyPersonNumberForEntityEqual(param, oriNumbers, numberMap, "hsas_temporarydata", "empnumber");
            this.dealModifyPersonNumberForEntityEqual(param, oriNumbers, numberMap, "hsas_calperson", "empnumber");
            HashMap<String, Object> paramSyncData = new HashMap<String, Object>();
            paramSyncData.put("empnumbers", empnumbers);
            SyncPersonHelper helper = new SyncPersonHelper();
            Map<String, Object> result = helper.syncData(paramSyncData);
            if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
                throw new RuntimeException(String.valueOf(result.get(KEY_MSG)));
            }
            Map resultMap = (Map)param.get(KEY_DEALINFO);
            resultMap.put("person.syncData", result.get(KEY_DATA));
            txHandle.commit();
        }
    }

    private boolean validateParam(Map<String, Object> param) {
        List datas = (List)param.get(KEY_DATA);
        if (datas == null) {
            LOG.info("call...dealModifyPersonNumber...end...datas is null");
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, "data is null");
            return false;
        }
        LOG.info("call...dealModifyPersonNumber...end...datas.size={}...", (Object)datas.size());
        if (datas.size() > 10000) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, "data size over 10000");
            return false;
        }
        if (datas.size() <= 30) {
            LOG.info("call...dealModifyPersonNumber...end...param={}...", (Object)SerializationUtils.toJsonString(param));
        }
        return true;
    }

    private DynamicObject[] dealModifyPersonNumberForEntityRel(Map<String, Object> param, Set<String> oriNumbers, Map<String, String> numberMap, String entityNumber, String propertyName, String relPropertyName) {
        DynamicObject[] dataDys;
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(HSAS_DATAUPDATELOG);
        ArrayList<DynamicObject> logDys = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter(relPropertyName, "in", oriNumbers);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityNumber);
        for (DynamicObject empDy : dataDys = empHelper.query(propertyName, new QFilter[]{qFilter})) {
            String propertyVal = empDy.getString(propertyName);
            String oriVal = empDy.getString(relPropertyName);
            String newVal = numberMap.get(oriVal);
            empDy.set(propertyName, (Object)propertyVal.replace(oriVal, newVal));
            DynamicObject logDy = logHelper.generateEmptyDynamicObject();
            logDy.set("batchnum", param.get("batchnum"));
            logDy.set("mainop", (Object)MAINOP);
            logDy.set("childop", (Object)CHILDOP);
            logDy.set("entityNumber", (Object)entityNumber);
            logDy.set("field", (Object)propertyName);
            logDy.set("updatestatus", (Object)"S");
            logDy.set("logdatatype", (Object)"D");
            logDy.set("dataid", empDy.get("id"));
            logDy.set("orivalue", (Object)oriVal);
            logDy.set("newvalue", (Object)newVal);
            logDys.add(logDy);
        }
        empHelper.update(dataDys);
        logHelper.save(logDys.toArray(new DynamicObject[0]));
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.put(entityNumber + "#" + propertyName, dataDys.length);
        return dataDys;
    }

    private DynamicObject[] dealModifyPersonNumberForEntityEqual(Map<String, Object> param, Set<String> oriNumbers, Map<String, String> numberMap, String entityNumber, String propertyName) {
        DynamicObject[] dataDys;
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper(HSAS_DATAUPDATELOG);
        ArrayList<DynamicObject> logDys = new ArrayList<DynamicObject>(10);
        QFilter qFilter = new QFilter(propertyName, "in", oriNumbers);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityNumber);
        for (DynamicObject empDy : dataDys = empHelper.query(propertyName, new QFilter[]{qFilter})) {
            String oriVal = empDy.getString(propertyName);
            String newVal = numberMap.get(empDy.get(propertyName));
            empDy.set(propertyName, (Object)newVal);
            DynamicObject logDy = logHelper.generateEmptyDynamicObject();
            logDy.set("batchnum", param.get("batchnum"));
            logDy.set("mainop", (Object)MAINOP);
            logDy.set("childop", (Object)CHILDOP);
            logDy.set("entityNumber", (Object)entityNumber);
            logDy.set("field", (Object)propertyName);
            logDy.set("updatestatus", (Object)"S");
            logDy.set("logdatatype", (Object)"D");
            logDy.set("dataid", empDy.get("id"));
            logDy.set("orivalue", (Object)oriVal);
            logDy.set("newvalue", (Object)newVal);
            logDys.add(logDy);
        }
        empHelper.update(dataDys);
        logHelper.save(logDys.toArray(new DynamicObject[0]));
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.put(entityNumber + "#" + propertyName, dataDys.length);
        return dataDys;
    }

    private void dealModifyPersonNumberITC(Map<String, Object> param) {
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberITC..begin...param={}", (Object)SerializationUtils.toJsonString(param));
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSPersonService", (String)MAINOP, (Object[])new Object[]{param});
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberITC..end...result={}", (Object)SerializationUtils.toJsonString((Object)result));
        if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
            throw new RuntimeException((String)result.get(KEY_MSG));
        }
        Map resultMap = (Map)param.get(KEY_DEALINFO);
        resultMap.putAll((Map)((Map)result.get(KEY_DATA)).get(KEY_DEALINFO));
        LOG.info("call...PersonServiceHelper.modifyPersonNumber.dealModifyPersonNumberITC..end...param={}", (Object)SerializationUtils.toJsonString(param));
    }

    private void dealModifyPersonNumberExt(Map<String, Object> param) {
        PersonExtService iPersonExtService = new PersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iPersonExtService, IPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.person.IPersonExtService#modifyPersonNumber", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.modifyPersonNumber(param);
            return null;
        });
    }

    public Map<String, Object> syncEmployeeExtField(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (result.containsKey(KEY_SUCCESS)) {
                return result;
            }
            Map<String, Object> datas = this.syncEmployeeExtFieldCore(param);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put(KEY_DATA, datas);
        }
        catch (Exception ex) {
            LOG.error("PersonServiceHelper...syncEmployeeExtField.error\uff1a", (Throwable)ex);
            result.put(KEY_SUCCESS, Boolean.FALSE);
            result.put(KEY_MSG, ex.getMessage());
        }
        return result;
    }

    private Map<String, Object> syncEmployeeExtFieldCore(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> presetDataMap = new HashMap<String, Object>();
        this.dealCollaExtField(param, presetDataMap);
        result.put("presetDataMap", presetDataMap);
        return result;
    }

    private void dealCollaExtField(Map<String, Object> param, Map<String, Object> presetDataMap) {
        String bizEntityNumber = String.valueOf(param.get("bizEntityNumber"));
        ArrayList<Long> setIds = new ArrayList<Long>(10);
        SWCDataServiceHelper collaSerHelper = new SWCDataServiceHelper("hsbs_fieldmap");
        QFilter filter = new QFilter("number", "=", (Object)"1010_S");
        DynamicObject collaDy = collaSerHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)collaSerHelper.getEntityName()), filter.toArray());
        if (collaDy == null) {
            return;
        }
        DynamicObjectCollection entrys = collaDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection subentrys = null;
        for (DynamicObject entry : entrys) {
            if (!bizEntityNumber.equals(entry.getString("entityobject.number"))) continue;
            subentrys = entry.getDynamicObjectCollection("fieldmapdetail");
            break;
        }
        if (subentrys == null || subentrys.size() == 0) {
            return;
        }
        Map<String, DynamicObject> paramMap = subentrys.stream().collect(Collectors.toMap(dy -> dy.getString("targetobjectfield"), dy -> dy, (v1, v2) -> v1));
        List fields = (List)param.get(KEY_DATA);
        SyncPersonHelper personHelper = new SyncPersonHelper();
        List<String> commFieldList = personHelper.getCommFieldList(bizEntityNumber);
        for (Map field : fields) {
            String fieldkey = String.valueOf(field.get("number"));
            String type = String.valueOf(field.get("type"));
            Boolean isDelete = (Boolean)field.get("delete");
            if ("BasedataPropField".equals(type) || "MulBasedataField".equals(type) || "AttachmentPanelAp".equals(type)) continue;
            DynamicObject paramDB = paramMap.get(fieldkey);
            if (paramDB == null && !isDelete.booleanValue()) {
                if (!commFieldList.contains(fieldkey) && !commFieldList.contains(fieldkey + ".id")) continue;
                DynamicObject newEntry = subentrys.addNew();
                newEntry.set("targetobjectfield", (Object)fieldkey);
                newEntry.set("subscibeapifield", (Object)fieldkey);
                if ("BasedataField".equals(type)) {
                    newEntry.set("subscibeapifield", (Object)(fieldkey + "_id"));
                }
                newEntry.set("subscibeobject", ((DynamicObject)subentrys.get(0)).get("subscibeobject"));
                newEntry.set("seq", (Object)subentrys.size());
            }
            if (paramDB == null || !isDelete.booleanValue()) continue;
            subentrys.remove((Object)paramDB);
        }
        collaSerHelper.saveOne(collaDy);
        setIds.add(collaDy.getLong("id"));
        presetDataMap.put(collaSerHelper.getEntityName(), setIds);
    }
}

