/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.personhr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.entity.property.HisModelBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.person.ISyncPersonExtService;
import kd.sdk.swc.hsas.common.events.person.AfterSyncPersonCopyEvent;
import kd.sdk.swc.hsas.common.events.person.InitSyncPersonEvent;
import kd.swc.hsas.business.personhr.SyncPersonExtService;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SyncPersonHelper {
    private final Log logger = LogFactory.getLog(SyncPersonHelper.class);
    private static final SyncPersonHelper service = new SyncPersonHelper();
    private static final Object lock1 = new Object();
    public final int SAVE_DATA_SIZE = 500;

    public static SyncPersonHelper getInstance() {
        return service;
    }

    public Map<String, String> getFormIdMap() {
        LinkedHashMap<String, String> formIdMap = new LinkedHashMap<String, String>(16);
        formIdMap.put("hrpi_person", "hsas_personhr");
        formIdMap.put("hrpi_employee", "hsas_employee");
        formIdMap.put("hrpi_cmpemp", "hsas_cmpemp");
        formIdMap.put("hrpi_depemp", "hsas_depemp");
        formIdMap.put("hrpi_pernontsprop", "hsas_pernontsprop");
        formIdMap.put("hrpi_empentrel", "hsas_empentrel");
        formIdMap.put("hrpi_empjobrel", "hsas_empjobrel");
        formIdMap.put("hrpi_trialperiod", "hsas_trialperiod");
        formIdMap.put("hrpi_empposorgrel", "hsas_empposorgrelhr");
        formIdMap.put("hrpi_managingscope", "hsas_managingscope");
        formIdMap.put("hrpi_perprotitle", "hsas_perprotitlehr");
        formIdMap.put("hrpi_perserlen", "hsas_perserlen");
        formIdMap.put("hrpi_pertsprop", "hsas_pertsprop");
        formIdMap.put("hrpi_pereduexp", "hsas_pereduexp");
        formIdMap.put("hrpi_projectmember", "hsas_projectmember");
        InitSyncPersonEvent initEvent = new InitSyncPersonEvent();
        this.invokeInitSyncPerson(initEvent);
        Map formIdMapExt = initEvent.getFormIdMap();
        if (formIdMapExt != null) {
            for (Map.Entry entry : formIdMapExt.entrySet()) {
                formIdMap.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return formIdMap;
    }

    private void invokeInitSyncPerson(InitSyncPersonEvent args) {
        SyncPersonExtService iSalaryFileEditExtPlugin = new SyncPersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileEditExtPlugin, ISyncPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.person.ISyncPersonExtService#initSyncPerson", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.initSyncPerson(args);
            return null;
        });
    }

    public static String newRuleNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hsas_syncpersonmonitor");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
    }

    public void buildSyncLogData(String orgEntity, String destEntity, List<Long> employeeIds, int way, List<DynamicObject> logDyList, String msg, String monitorNumber) {
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_employee");
        DynamicObject[] empDys = empHelper.query("id,empnumber,person", new QFilter[]{new QFilter("id", "in", employeeIds)});
        boolean flag = false;
        for (DynamicObject empDy : empDys) {
            long employee = empDy.getLong("id");
            for (DynamicObject logDy : logDyList) {
                long existEmployee = logDy.getLong("employee");
                if (employee != existEmployee || "hrpi_person".equals(orgEntity)) continue;
                logDy.set("targetentity", (Object)(logDy.getString("targetentity") + " " + destEntity));
                logDy.set("sourceentity", (Object)(logDy.getString("sourceentity") + " " + orgEntity));
                String failReason = logDy.getString("syncfailurereason");
                if (StringUtils.isNotEmpty((String)failReason) && failReason.length() < 1700) {
                    logDy.set("syncfailurereason", (Object)(failReason + " | " + msg));
                }
                flag = true;
                break;
            }
            if (flag) continue;
            SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_syncpersonhrlog");
            DynamicObject dy = logHelper.generateEmptyDynamicObject();
            dy.set("targetentity", (Object)destEntity);
            dy.set("sourceentity", (Object)orgEntity);
            dy.set("syncfailurereason", (Object)msg);
            dy.set("employee", (Object)employee);
            dy.set("empnumber", (Object)empDy.getString("empnumber"));
            dy.set("empname", (Object)empDy.getString("person.name"));
            dy.set("sourceapplication", (Object)"hrpi");
            dy.set("syncway", (Object)way);
            dy.set("syncstatus", (Object)"F");
            dy.set("syncdate", (Object)new Date());
            dy.set("batchnumber", (Object)monitorNumber);
            this.setSystemFieldValue(dy);
            logDyList.add(dy);
        }
    }

    public void setSystemFieldValue(DynamicObject destDy) {
        long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        destDy.set("creator", (Object)userId);
        destDy.set("modifier", (Object)userId);
        destDy.set("createtime", (Object)now);
        destDy.set("modifytime", (Object)now);
    }

    public Map<String, Object> syncData(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String monitorNumber = SyncPersonHelper.newRuleNumber();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        Object empnumbersObj = param.get("empnumbers");
        if (empnumbersObj instanceof List) {
            qfilters.add(new QFilter("empnumber", "in", empnumbersObj));
        }
        if (qfilters.isEmpty()) {
            result.put("success", Boolean.FALSE);
            result.put("message", "no filter");
            return result;
        }
        qfilters.add(BaseDataHisHelper.getHisCurrFilter());
        DynamicObject[] empDys = BusinessDataServiceHelper.load((String)"hrpi_employee", (String)"id,person", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"id", (int)100000);
        List<Map<Long, Long>> empList = this.getIdMap(empDys);
        int totalRows = empList.size();
        if (totalRows == 0) {
            totalRows = -1;
        }
        SyncPersonHelper.getInstance().saveMonitorDy(totalRows, null, monitorNumber, "1");
        this.syncData(2, empList, monitorNumber);
        SyncPersonHelper.getInstance().saveMonitorDy(0, null, monitorNumber, "0");
        this.setMonitorLog(param, monitorNumber);
        result.put("success", Boolean.TRUE);
        result.put("data", param);
        result.put("monitorNumber", monitorNumber);
        return result;
    }

    private void setMonitorLog(Map<String, Object> param, String monitorNumber) {
        SWCDataServiceHelper monitorHelper = new SWCDataServiceHelper("hsas_syncpersonmonitor");
        DynamicObject monitorDy = monitorHelper.queryOne("id,totalcount,successcount,failcount,syncstatus,modifytime", new QFilter[]{new QFilter("batchnumber", "=", (Object)monitorNumber)});
        param.put("monitorNumber", monitorNumber);
        param.put("total", 0);
        param.put("success", 0);
        param.put("fail", 0);
        if (!SWCObjectUtils.isEmpty((Object)monitorDy)) {
            param.put("total", monitorDy.get("totalcount"));
            param.put("success", monitorDy.get("successcount"));
            param.put("fail", monitorDy.get("failcount"));
        }
    }

    private List<Map<Long, Long>> getIdMap(DynamicObject[] dys) {
        ArrayList<Map<Long, Long>> empIds = new ArrayList<Map<Long, Long>>(16);
        if (dys == null) {
            return empIds;
        }
        for (DynamicObject dy : dys) {
            HashMap<Long, Long> data = new HashMap<Long, Long>(1);
            data.put(dy.getLong("id"), dy.getLong("person.id"));
            empIds.add(data);
        }
        return empIds;
    }

    public void syncData(int way, List<Map<Long, Long>> empList, String monitorNumber) {
        List subTmpList = Lists.partition(empList, (int)500);
        for (List currentList : subTmpList) {
            if (this.ifBreak()) break;
            this.loopSyncData(way, currentList, monitorNumber, "1");
        }
    }

    private boolean ifBreak() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter qFilter = new QFilter("mid", "=", (Object)9);
        DynamicObject stopDy = helper.queryOne("id", new QFilter[]{qFilter});
        return stopDy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> loopSyncData(int way, List<Map<Long, Long>> currentList, String monitorNumber, String syncStatus) {
        boolean isNormal;
        ArrayList logDyList;
        HashMap<String, Object> countMap;
        block13: {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            countMap = new HashMap<String, Object>(2);
            logDyList = new ArrayList();
            TXHandle txHandle = null;
            isNormal = true;
            try {
                txHandle = TX.requiresNew();
                Map<String, String> formIdMap = this.getFormIdMap();
                this.logger.info("SyncPersonDataList.syncAllPersons...execing...subList..loopSyncData..begin...{}...{}", (Object)monitorNumber, (Object)currentList.get(0).toString());
                formIdMap.forEach((key, value) -> this.syncPersonInfo((String)key, (String)value, currentList, way, logDyList, monitorNumber));
                this.logger.info("SyncPersonDataList.syncAllPersons...execing...subList..loopSyncData..end...{}...{}", (Object)monitorNumber, (Object)currentList.get(0).toString());
                txHandle.commit();
                if (txHandle == null) break block13;
            }
            catch (Exception e) {
                block14: {
                    try {
                        if (txHandle != null) {
                            txHandle.markRollback();
                        }
                        this.logger.error("loopSyncData error.logHelper.save.. ", (Throwable)e);
                        this.logger.error("loopSyncData error.logHelper.logDyList.size.. ", (Object)logDyList.size());
                        if (logDyList.size() == 0) {
                            isNormal = false;
                        }
                        if (txHandle == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (txHandle != null) {
                            txHandle.close();
                        }
                        if (isNormal) {
                            countMap.put("failcount", logDyList.size());
                            countMap.put("succcount", currentList.size() - logDyList.size());
                        } else {
                            countMap.put("failcount", currentList.size());
                            countMap.put("succcount", 0);
                        }
                        this.saveMonitorDy(0, countMap, monitorNumber, syncStatus);
                        SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_syncpersonhrlog");
                        logHelper.save(logDyList.toArray(new DynamicObject[logDyList.size()]));
                        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
                        throw throwable;
                    }
                    txHandle.close();
                }
                if (isNormal) {
                    countMap.put("failcount", logDyList.size());
                    countMap.put("succcount", currentList.size() - logDyList.size());
                } else {
                    countMap.put("failcount", currentList.size());
                    countMap.put("succcount", 0);
                }
                this.saveMonitorDy(0, countMap, monitorNumber, syncStatus);
                SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_syncpersonhrlog");
                logHelper.save(logDyList.toArray(new DynamicObject[logDyList.size()]));
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
            }
            txHandle.close();
        }
        if (isNormal) {
            countMap.put("failcount", logDyList.size());
            countMap.put("succcount", currentList.size() - logDyList.size());
        } else {
            countMap.put("failcount", currentList.size());
            countMap.put("succcount", 0);
        }
        this.saveMonitorDy(0, countMap, monitorNumber, syncStatus);
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_syncpersonhrlog");
        logHelper.save(logDyList.toArray(new DynamicObject[logDyList.size()]));
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        return countMap;
    }

    private void syncPersonInfo(String orgEntity, String destEntity, List<Map<Long, Long>> employeeDys, int way, List<DynamicObject> logDyList, String monitorNumber) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        ArrayList<Long> personList = new ArrayList<Long>(10);
        try {
            QFilter qFilter;
            this.logger.info("syncAllPersons..syncPersonInfo..begin.orgEntity:{}, destEntity:{}, id=:{}", new Object[]{orgEntity, destEntity, employeeDys.get(0).toString()});
            if (CollectionUtils.isEmpty(employeeDys)) {
                return;
            }
            for (Map<Long, Long> idMap : employeeDys) {
                idList.addAll(idMap.keySet());
                personList.addAll(idMap.values());
            }
            SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(orgEntity);
            switch (orgEntity) {
                case "hrpi_employee": {
                    qFilter = new QFilter("boid", "in", idList);
                    break;
                }
                case "hrpi_person": {
                    qFilter = new QFilter("boid", "in", personList);
                    break;
                }
                case "hrpi_pernontsprop": 
                case "hrpi_perprotitle": 
                case "hrpi_pertsprop": 
                case "hrpi_pereduexp": 
                case "hrpi_managingscope": {
                    qFilter = new QFilter("person.boid", "in", personList);
                    break;
                }
                default: {
                    qFilter = new QFilter("employee.boid", "in", idList);
                }
            }
            List<String> commFieldList = this.getCommFieldList(orgEntity, destEntity);
            String fields = commFieldList.toString().replace("[", "").replace("]", "");
            DynamicObject[] orgDys = orgHelper.query(fields, new QFilter[]{qFilter});
            SWCDataServiceHelper desthelper = new SWCDataServiceHelper(destEntity);
            DynamicObject[] destDys = desthelper.query(SWCHisBaseDataHelper.getSelectProperties((String)destEntity), new QFilter[]{qFilter});
            this.logger.info("syncAllPersons..syncPersonInfo..execing.orgEntity:{}, destEntity:{}, id=:{}", new Object[]{orgEntity, destEntity, employeeDys.get(0).toString()});
            this.syncPersonOneEntity(orgEntity, destEntity, commFieldList, orgDys, destDys);
            this.logger.info("syncAllPersons..syncPersonInfo..end.orgEntity:{}, destEntity:{}, id=:{}", new Object[]{orgEntity, destEntity, employeeDys.get(0).toString()});
        }
        catch (Exception e) {
            this.logger.error("syncPersonInfo error. ", (Throwable)e);
            String msg = "";
            msg = e.getMessage() != null && e.getMessage().length() > 200 ? e.getMessage().substring(0, 190) : e.getMessage();
            msg = "destEntity:" + destEntity + "(" + msg + ")";
            this.buildSyncLogData(orgEntity, destEntity, idList, way, logDyList, msg, monitorNumber);
            throw new KDException((Throwable)e, new ErrorCode("SYNCPERSONINFO ONE ENTITY ERROR", e.getMessage()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMonitorDy(int totalCount, Map<String, Object> countMap, String monitorNumber, String syncstatus) {
        Object object = lock1;
        synchronized (object) {
            try (TXHandle txHandle = TX.requiresNew();){
                SWCDataServiceHelper monitorHelper = new SWCDataServiceHelper("hsas_syncpersonmonitor");
                DynamicObject monitorDy = monitorHelper.queryOne("id,totalcount,successcount,failcount,syncstatus,modifytime", new QFilter[]{new QFilter("batchnumber", "=", (Object)monitorNumber)});
                if (SWCObjectUtils.isEmpty((Object)monitorDy)) {
                    monitorDy = monitorHelper.generateEmptyDynamicObject();
                    monitorDy.set("batchnumber", (Object)monitorNumber);
                    monitorDy.set("successcount", (Object)0);
                    monitorDy.set("failcount", (Object)0);
                    this.setSystemFieldValue(null, monitorDy);
                }
                monitorDy.set("syncstatus", (Object)syncstatus);
                monitorDy.set("modifytime", (Object)new Date());
                if (totalCount == -1) {
                    monitorDy.set("totalcount", (Object)0);
                } else if (totalCount != 0) {
                    monitorDy.set("totalcount", (Object)totalCount);
                }
                if (countMap != null) {
                    monitorDy.set("successcount", (Object)(monitorDy.getLong("successcount") + Long.parseLong(String.valueOf(countMap.get("succcount")))));
                    monitorDy.set("failcount", (Object)(monitorDy.getLong("failcount") + Long.parseLong(String.valueOf(countMap.get("failcount")))));
                }
                monitorHelper.saveOne(monitorDy);
                txHandle.commit();
            }
        }
    }

    private void setSystemFieldValue(DynamicObject orgDy, DynamicObject destDy) {
        String userId = RequestContext.get().getUserId();
        Date now = new Date();
        destDy.set("creator", (Object)userId);
        destDy.set("modifier", (Object)userId);
        destDy.set("createtime", (Object)now);
        destDy.set("modifytime", (Object)now);
    }

    @NotNull
    public List<String> getCommFieldList(String destEntity) {
        Map<String, String> formIdMap = this.getFormIdMap();
        for (Map.Entry<String, String> formMap : formIdMap.entrySet()) {
            if (!formMap.getValue().equals(destEntity)) continue;
            return this.getCommFieldList(formMap.getKey(), formMap.getValue());
        }
        return new ArrayList<String>(1);
    }

    @NotNull
    public List<String> getCommFieldList(String orgEntity, String destEntity) {
        MainEntityType orgEntityType = EntityMetadataCache.getDataEntityType((String)orgEntity);
        List orgFieldList = SWCHisBaseDataHelper.getEntityFieldsOnlyId((MainEntityType)orgEntityType, (String)orgEntity);
        MainEntityType destEntityType = EntityMetadataCache.getDataEntityType((String)destEntity);
        List destFieldList = SWCHisBaseDataHelper.getEntityFieldsOnlyId((MainEntityType)destEntityType, (String)destEntity);
        List<String> commFieldList = orgFieldList.stream().filter(orgField -> destFieldList.contains(orgField)).collect(Collectors.toList());
        commFieldList.add("id");
        commFieldList.remove("changedescription");
        commFieldList.remove("ismodify");
        Iterator it = commFieldList.iterator();
        while (it.hasNext()) {
            String field = ((String)it.next()).replace(".id", "");
            Object orgType = orgEntityType.getAllFields().get(field);
            Object destType = destEntityType.getAllFields().get(field);
            if ("id".equals(field)) continue;
            if (orgType == null || destType == null) {
                it.remove();
                continue;
            }
            if (orgType.getClass().equals(destType.getClass()) || orgType.getClass().isAssignableFrom(TextProp.class) && destType.getClass().isAssignableFrom(MuliLangTextProp.class) || orgType.getClass().isAssignableFrom(MuliLangTextProp.class) && destType.getClass().isAssignableFrom(TextProp.class) || orgType.getClass().isAssignableFrom(DateProp.class) && destType.getClass().isAssignableFrom(DateTimeProp.class) || orgType.getClass().isAssignableFrom(DateTimeProp.class) && destType.getClass().isAssignableFrom(DateProp.class) || orgType.getClass().isAssignableFrom(BasedataProp.class) && destType.getClass().isAssignableFrom(HisModelBasedataProp.class) || destType.getClass().isAssignableFrom(BasedataProp.class) && orgType.getClass().isAssignableFrom(HisModelBasedataProp.class)) continue;
            it.remove();
            this.logger.info("syncPersonInfo..getCommFieldList..exists type not equal..field:{}", (Object)field);
        }
        return commFieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncPersonOneEntity(String orgEntity, String destEntity, List<Long> entityBoIds) {
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        TXHandle txHandle = TX.requiresNew();
        try {
            List<String> commFieldList = this.getCommFieldList(orgEntity, destEntity);
            SWCDataServiceHelper orgHelper = new SWCDataServiceHelper(orgEntity);
            String fields = commFieldList.toString().replace("[", "").replace("]", "");
            QFilter qFilter = new QFilter("boid", "in", entityBoIds);
            DynamicObject[] entityDys = orgHelper.query(fields, new QFilter[]{qFilter});
            SWCDataServiceHelper desthelper = new SWCDataServiceHelper(destEntity);
            DynamicObject[] destDys = desthelper.query(SWCHisBaseDataHelper.getSelectProperties((String)destEntity), new QFilter[]{qFilter});
            this.syncPersonOneEntity(orgEntity, destEntity, commFieldList, entityDys, destDys);
            txHandle.commit();
        }
        catch (Exception ex) {
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        }
    }

    private void syncPersonOneEntity(String orgEntity, String destEntity, List<String> commFieldList, DynamicObject[] entityDys, DynamicObject[] destDys) {
        SWCDataServiceHelper desthelper = new SWCDataServiceHelper(destEntity);
        Map<Long, DynamicObject> dbDyMap = Arrays.stream(destDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        HashSet hrpiIds = new HashSet(16);
        ArrayList<DynamicObject> destDyList = new ArrayList<DynamicObject>();
        Arrays.stream(entityDys).forEach(orgDy -> {
            Long id = orgDy.getLong("id");
            hrpiIds.add(id);
            DynamicObject newDy = (DynamicObject)dbDyMap.get(id);
            if (newDy == null) {
                newDy = destDys != null && destDys.length >= 1 ? (DynamicObject)destDys[0].getDataEntityType().createInstance() : desthelper.generateEmptyDynamicObject();
                newDy.set("id", (Object)id);
            }
            SWCBaseUtils.copyFieldId((DynamicObject)newDy, (DynamicObject)orgDy, (String[])commFieldList.toArray(new String[commFieldList.size()]));
            destDyList.add(newDy);
        });
        for (DynamicObject destDy : destDys) {
            if (hrpiIds.contains(destDy.getLong("id"))) continue;
            SWCBaseUtils.copyFieldId((DynamicObject)destDy, (DynamicObject)destDy, (String[])commFieldList.toArray(new String[commFieldList.size()]));
            destDy.set("datastatus", (Object)"-1");
            destDy.set("modifytime", (Object)new Date());
            destDyList.add(destDy);
        }
        this.doAfterCopy(destEntity, destDyList);
        this.logger.info("syncAllPersons..syncPersonOneEntity...save begin orgEntity:{}, destEntity:{}, entityDys.size:{}", new Object[]{orgEntity, destEntity, entityDys.length});
        DynamicObject[] waitSaveDestDys = destDyList.toArray(new DynamicObject[destDyList.size()]);
        desthelper.save(waitSaveDestDys);
        this.logger.info("syncAllPersons..syncPersonOneEntity...save begining orgEntity:{}, destEntity:{}, entityDys.size:{} saveend", new Object[]{orgEntity, destEntity, entityDys.length});
        this.doAfterSave(destEntity, destDyList);
        this.logger.info("syncAllPersons..syncPersonOneEntity...save end orgEntity:{}, destEntity:{}, entityDys.size:{}", new Object[]{orgEntity, destEntity, entityDys.length});
    }

    private void doAfterCopy(String destEntity, List<DynamicObject> destDyList) {
        block5: {
            block6: {
                block4: {
                    if (CollectionUtils.isEmpty(destDyList)) {
                        return;
                    }
                    AfterSyncPersonCopyEvent afterSyncPersonCopyEvent = new AfterSyncPersonCopyEvent();
                    afterSyncPersonCopyEvent.setDestEntity(destEntity);
                    afterSyncPersonCopyEvent.setDestDyList(destDyList);
                    this.invokeAfterSyncPersonCopy(afterSyncPersonCopyEvent);
                    afterSyncPersonCopyEvent.getDestDyList();
                    if (!"hsas_employee".equals(destEntity)) break block4;
                    Map<Long, String> nameMap = this.queryBaseDataNameMap(destDyList, "person", "hsas_personhr");
                    for (DynamicObject newDy : destDyList) {
                        newDy.set("showname", (Object)nameMap.get(newDy.get("person")));
                        newDy.set("datasource", (Object)"C");
                    }
                    break block5;
                }
                if (!"hsas_empposorgrelhr".equals(destEntity)) break block6;
                this.logger.info("syncAllPersons..syncPersonOneEntity...save begin orgEntity:{}...query hbpm_positionhr begin...", (Object)destEntity);
                Map<Long, String> nameMap = this.queryBaseDataNameMap(destDyList, "position", "hbpm_positionhr");
                this.logger.info("syncAllPersons..syncPersonOneEntity...save begin orgEntity:{}...query hbpm_stposition begin...", (Object)destEntity);
                Map<Long, String> nameMapStd = this.queryBaseDataNameMap(destDyList, "stdposition", "hbpm_stposition");
                this.logger.info("syncAllPersons..syncPersonOneEntity...save begin orgEntity:{}...query hbpm_stposition end...", (Object)destEntity);
                for (DynamicObject newDy : destDyList) {
                    String positionName = nameMap.get(newDy.get("position"));
                    String stdpositionName = nameMapStd.get(newDy.get("stdposition"));
                    String name = StringUtils.isNotEmpty((String)positionName) ? positionName : (StringUtils.isNotEmpty((String)stdpositionName) ? stdpositionName : null);
                    newDy.set("showname", (Object)name);
                }
                break block5;
            }
            if (!"hsas_depemp".equals(destEntity)) break block5;
            Map<Long, String> nameMap = this.queryBaseDataNameMap(destDyList, "dutyworkroles", "hbpm_dutyworkroles");
            for (DynamicObject newDy : destDyList) {
                newDy.set("showname", (Object)nameMap.get(newDy.get("dutyworkroles")));
            }
        }
    }

    private void invokeAfterSyncPersonCopy(AfterSyncPersonCopyEvent args) {
        SyncPersonExtService iSalaryFileEditExtPlugin = new SyncPersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)iSalaryFileEditExtPlugin, ISyncPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.person.ISyncPersonExtService#afterSyncPersonCopy", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterSyncPersonCopy(args);
            return null;
        });
    }

    @NotNull
    private Map<Long, String> queryBaseDataNameMap(List<DynamicObject> destDyList, String propName, String entity) {
        List personIds = destDyList.stream().map(dy -> dy.getLong(propName)).collect(Collectors.toList());
        personIds.remove(0L);
        if (personIds.size() == 0) {
            return new HashMap<Long, String>(0);
        }
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper(entity);
        QFilter qFilter = new QFilter("id", "in", personIds);
        DynamicObjectCollection personDys = personHelper.queryOriginalCollection("id, name", new QFilter[]{qFilter});
        return personDys.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name")));
    }

    private void doAfterSave(String destEntity, List<DynamicObject> destDyList) {
        Set<Long> personIds;
        if ("hsas_personhr".equals(destEntity)) {
            personIds = destDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            SalaryFileHelper.refreshFileName(personIds);
        }
        if ("hsas_depemp".equals(destEntity)) {
            Set<Long> depEmpIds = destDyList.stream().filter(item -> item.getBoolean("iscurrentversion")).map(single -> single.getLong("id")).collect(Collectors.toSet());
            Set<Long> employeeIds = destDyList.stream().map(single -> single.getLong("employee")).collect(Collectors.toSet());
            SalaryFileEmpPosOrgRelHelper.updateDepEmpTimeRemainedFlag(depEmpIds);
            SalaryFileEmpPosOrgRelHelper.updateEmployeeRemainedFlag(employeeIds);
        }
        if ("hsas_empposorgrelhr".equals(destEntity)) {
            personIds = destDyList.stream().map(dy -> dy.getLong("person")).collect(Collectors.toSet());
            SalaryFileHelper.refreshAdminorgVid(personIds);
        }
    }

    public static List<QFilter> getReturnDataQFilters(Map<String, Object> returnDataMap) {
        Date enddate;
        Date startdate;
        QFilter typeFilter;
        List laborreltype;
        QFilter qfilter;
        List enterprise;
        List empNumberOrNameList;
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(10);
        if (returnDataMap == null) {
            return qfilters;
        }
        List empIdList = (List)returnDataMap.get("empIdList");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)empIdList)) {
            QFilter qfilter2 = new QFilter("id", "in", (Object)empIdList);
            qfilters.add(qfilter2);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)(empNumberOrNameList = (List)returnDataMap.get("empNumberOrNameList")))) {
            QFilter numberQfilter = new QFilter("empnumber", "in", (Object)empNumberOrNameList);
            numberQfilter.or("person.name", "in", (Object)empNumberOrNameList);
            qfilters.add(numberQfilter);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)(enterprise = (List)returnDataMap.get("enterprise")))) {
            QFilter qfilter3 = new QFilter("enterprise", "in", (Object)enterprise);
            qfilters.add(qfilter3);
        }
        String permEntity = "hsas_employee";
        String permItemId = "47150e89000000ac";
        long userId = RequestContext.get().getCurrUserId();
        QFilter entFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)userId, (String)"/UHMBBGZQ65X", (String)permEntity, (String)"enterprise", (String)permItemId);
        if (entFilter != null) {
            SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hbss_enterprise");
            DynamicObject[] dynamicObject = empHelper.query("id", new QFilter[]{entFilter});
            List ids = Arrays.asList(dynamicObject).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            if (kd.bos.util.CollectionUtils.isNotEmpty(ids)) {
                qfilter = new QFilter("enterprise", "in", ids);
                qfilters.add(qfilter);
            }
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)(laborreltype = (List)returnDataMap.get("laborreltype")))) {
            QFilter qfilter4 = new QFilter("laborreltype", "in", (Object)laborreltype);
            qfilters.add(qfilter4);
        }
        if ((typeFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)userId, (String)"/UHMBBGZQ65X", (String)permEntity, (String)"laborreltype", (String)permItemId)) != null) {
            SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hbss_laborreltype");
            DynamicObject[] dynamicObject = empHelper.query("id", new QFilter[]{typeFilter});
            List ids = Arrays.asList(dynamicObject).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            if (kd.bos.util.CollectionUtils.isNotEmpty(ids)) {
                QFilter qfilter5 = new QFilter("laborreltype", "in", ids);
                qfilters.add(qfilter5);
            }
        }
        if ((startdate = (Date)returnDataMap.get("startdate")) != null) {
            qfilter = new QFilter("enddate", ">=", (Object)startdate);
            qfilters.add(qfilter);
        }
        if ((enddate = (Date)returnDataMap.get("enddate")) != null) {
            QFilter qfilter6 = new QFilter("startdate", "<=", (Object)enddate);
            qfilters.add(qfilter6);
        }
        return qfilters;
    }

    public static int queryTotalRows(List<QFilter> qfilters) {
        if (qfilters == null) {
            return 0;
        }
        QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
        qfilters.add(currFilter);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_employee");
        return empHelper.count(qfilters.toArray(new QFilter[0]));
    }

    public static List<Long> queryEmpIds(List<QFilter> qfilters) {
        if (qfilters == null) {
            return null;
        }
        QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
        qfilters.add(currFilter);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hrpi_employee");
        DynamicObject[] empDys = empHelper.query(qfilters.toArray(new QFilter[0]));
        return Arrays.stream(empDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }
}

