/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.prorationevent;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class ProrationEventUtils {
    public static ListShowParameter createEventListShowParameter(Long personChangeId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_prorationevent");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("personchange", "=", (Object)personChangeId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(filter);
        showParameter.setListFilterParameter(new ListFilterParameter(filters, "prorationdate desc,salaryfile.employee.empnumber asc,salaryfile.number asc"));
        return showParameter;
    }

    public static Map<String, DynamicObject> getProrationEventMap(QFilter filter) {
        String fields = "id,salaryfile.id,prorationdate,prorationgenrule.id,changereason.id";
        DynamicObjectCollection result = ProrationEventUtils.getProrationEventData(filter, fields);
        return result.stream().collect(Collectors.toMap(obj -> ProrationEventUtils.getMapKey(obj), obj -> obj, (key1, key2) -> key1));
    }

    public static String getMapKey(DynamicObject obj) {
        return obj.getLong("salaryfile.id") + "@;@" + obj.getLong("prorationgenrule.id") + "@;@" + obj.getLong("changereason.id") + "@;@" + SWCDateTimeUtils.format((Date)obj.getDate("prorationdate"), (String)"yyyy-MM-dd");
    }

    public static DynamicObjectCollection getProrationEventData(QFilter filter, String fields) {
        if (filter == null) {
            return new DynamicObjectCollection();
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationevent");
        return helper.queryOriginalCollection(fields, new QFilter[]{filter});
    }

    public static void setMulBaseDataFieldValue(DynamicObjectCollection entryList, DynamicObject eventObj) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        for (DynamicObject mulBasedataDy : entryList) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            newMulBasedataColl.add((Object)copyDynObj);
        }
        eventObj.set("salaryitem", (Object)newMulBasedataColl);
    }

    public static Map<Long, List<DynamicObject>> getProrationEventRelMap(Set<Long> proratonEventIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calprorationrel");
        QFilter filter = new QFilter("prorationevent.id", "in", proratonEventIdSet);
        String[] statusArr = new String[]{CalPayrollTaskStateEnum.UNCAL.getCode(), CalPayrollTaskStateEnum.CALPROCESSING.getCode(), CalPayrollTaskStateEnum.AUDIT.getCode(), CalPayrollTaskStateEnum.APPROVALEDING.getCode(), CalPayrollTaskStateEnum.APPROVALED_NOT_PASS.getCode()};
        filter.and("caltask.taskstatus", "in", (Object)statusArr);
        DynamicObjectCollection data = helper.queryOriginalCollection("prorationevent.id,caltask.name", new QFilter[]{filter});
        return data.stream().collect(Collectors.groupingBy(obj -> obj.getLong("prorationevent.id")));
    }

    public static String getCalTaskName(List<DynamicObject> relList) {
        Set calTaskNameSet = relList.stream().map(obj -> obj.getString("caltask.name")).collect(Collectors.toSet());
        return SWCListUtils.join(calTaskNameSet, (String)"\uff0c");
    }
}

