/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salarydeatilresult.export;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class SalaryDetailResultExportHelper {
    private static final Object DATATYPE = "dataType";

    public int writeAbstractRows(SXSSFSheet sheet, DynamicObject taskInfo, Map<Integer, Integer> columnWidthMap, int row) {
        SXSSFRow headRow = sheet.createRow(row);
        SXSSFCell cell = headRow.createCell(0);
        String cellValue = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1", (String)"SalaryDetailResultExportHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        cell = headRow.createCell(1);
        cellValue = taskInfo.getString("name");
        cell.setCellValue(cellValue);
        columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        cellValue = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"SalaryDetailResultExportHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(0)) {
            columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        cell = headRow.createCell(1);
        cellValue = taskInfo.getString("payrollgroupv.name");
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(1)) {
            columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        cellValue = ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u6b62\u65e5\u671f", (String)"SalaryDetailResultExportHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(0)) {
            columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        cell = headRow.createCell(1);
        Date startDate = taskInfo.getDate("STARTDATE");
        Date endDate = taskInfo.getDate("ENDDATE");
        String startDateStr = SWCInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"STARTDATE", (Date)startDate);
        String endDateStr = SWCInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"ENDDATE", (Date)endDate);
        cellValue = startDateStr + " - " + endDateStr;
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(1)) {
            columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        cellValue = ResManager.loadKDString((String)"\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", (String)"SalaryDetailResultExportHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(0)) {
            columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        cell = headRow.createCell(1);
        Date payRollDate = taskInfo.getDate("payrolldate");
        cellValue = SWCDateTimeUtils.format((Date)payRollDate, (String)"yyyy-MM");
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(1)) {
            columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        cellValue = ResManager.loadKDString((String)"\u6838\u7b97\u5e01\u79cd", (String)"SalaryDetailResultExportHelper_20", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(0)) {
            columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        cell = headRow.createCell(1);
        String currencyName = taskInfo.getString("payrollgroupv.currency.name");
        String currencyNumber = taskInfo.getString("payrollgroupv.currency.number");
        cellValue = currencyName + "\uff08" + currencyNumber + "\uff09";
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(1)) {
            columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        headRow = sheet.createRow(++row);
        cell = headRow.createCell(0);
        cellValue = ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"SalaryDetailResultExportHelper_17", (String)"swc-hsas-business", (Object[])new Object[0]);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(0)) {
            columnWidthMap.put(0, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        cell = headRow.createCell(1);
        Date exrateDate = taskInfo.getDate("exratedate");
        cellValue = SWCInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"exratedate", (Date)exrateDate);
        cell.setCellValue(cellValue);
        if (SalaryDetailResultExportHelper.getColumnWidth(cellValue) > columnWidthMap.get(1)) {
            columnWidthMap.put(1, SalaryDetailResultExportHelper.getColumnWidth(cellValue));
        }
        return ++row;
    }

    public static int getColumnWidth(String value) {
        int width = 0;
        int flag = 1;
        try {
            width = value.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            width = 30;
        }
        flag = width >= 0 && width < 20 ? 75 : (width >= 20 && width < 30 ? 65 : (width >= 30 && width < 40 ? 60 : (width >= 40 && width < 55 ? 55 : 50)));
        return width * flag;
    }

    public int write2ExportHead(SXSSFSheet sheet, Map<String, String> headData, Map<String, Map<String, Object>> gridItemInfo, Map<Integer, Integer> columnWidthMap, int currRowIndex) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headData, gridItemInfo);
        return this.createHeadColumn(sheet.getWorkbook(), sheet, headList, gridItemInfo, columnWidthMap, currRowIndex);
    }

    private int createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, String>> headList, Map<String, Map<String, Object>> gridItemInfo, Map<Integer, Integer> columnWidthMap, int currRowIndex) {
        SXSSFRow headRow = sheet.createRow(currRowIndex);
        int headSize = headList.size();
        HashSet mustColumn = Sets.newHashSet((Object[])new String[]{"salaryfileNum"});
        for (int i = 0; i < headSize; ++i) {
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headString = headList.get(i).get("value");
            String headKey = headList.get(i).get("key");
            cell.setCellValue(headString);
            if (columnWidthMap.get(i) == null) {
                columnWidthMap.put(i, SalaryDetailResultExportHelper.getColumnWidth(headString));
            } else if (SalaryDetailResultExportHelper.getColumnWidth(headString) > columnWidthMap.get(i)) {
                columnWidthMap.put(i, SalaryDetailResultExportHelper.getColumnWidth(headString));
            }
            CellStyle headColumnStyle = this.getHeadColumnStyle(wb);
            if (mustColumn.contains(headKey)) {
                Font font = wb.createFont();
                font.setColor((short)10);
                headColumnStyle.setFont(font);
            }
            cell.setCellStyle(headColumnStyle);
        }
        return ++currRowIndex;
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    public List<Map<String, String>> HeadMapToListMap(Map<String, String> headData, Map<String, Map<String, Object>> gridItemInfo) {
        HashMap<String, String> temp;
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        ArrayList<Map<String, Object>> tplList = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> map : gridItemInfo.values()) {
            tplList.add(map);
        }
        Collections.sort(tplList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int seq1 = (Integer)o1.get("seq");
                int seq2 = (Integer)o2.get("seq");
                return seq1 - seq2;
            }
        });
        for (Map.Entry entry : headData.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!this.isFixField(key, gridItemInfo)) continue;
            temp = new HashMap<String, String>(16);
            temp.put("key", key);
            temp.put("value", value);
            list.add(temp);
        }
        for (Map map : tplList) {
            String number = (String)map.get("uniquecode");
            String name = (String)map.get("name");
            temp = new HashMap(16);
            String fieldKey = number.replace("_", "").toLowerCase();
            temp.put("key", fieldKey);
            temp.put("value", name);
            list.add(temp);
        }
        return list;
    }

    public boolean isFixField(String number, Map<String, Map<String, Object>> gridItemInfo) {
        return !gridItemInfo.containsKey(number);
    }

    public Sheet write2ExportContent(SXSSFSheet sheet, Integer beginIndex, String pageKey, String pageName, List<Map<String, Object>> exportDataList, Map<String, String> headData, Map<String, Map<String, Object>> gridItemInfo, Map<Integer, Integer> columnWidthMap, boolean isImport) {
        List<Map<String, String>> headList = this.HeadMapToListMap(headData, gridItemInfo);
        SalaryDetailResultExportHelper.createContentColumn(sheet.getWorkbook(), sheet, beginIndex, exportDataList, headList, gridItemInfo, columnWidthMap, isImport);
        return sheet;
    }

    private static void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, List<Map<String, String>> headList, Map<String, Map<String, Object>> gridItemInfo, Map<Integer, Integer> columnWidthMap, boolean isImport) {
        if (exportDataList.isEmpty()) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        boolean isAllowEdit = false;
        CellRangeAddressList allowModifyCellList = new CellRangeAddressList();
        CellRangeAddressList forbidModifyCellList = new CellRangeAddressList();
        String cover = ResManager.loadKDString((String)"\u8986\u76d6", (String)"SalaryDetailResultExportHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = null;
            exportDataMap = exportDataList.get(rowIndex - beginIndex);
            isAllowEdit = MapUtils.getBooleanValue(exportDataMap, (Object)"isallowedit");
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                String sign;
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = headList.get(columnIndex).get("key");
                if (null == key) continue;
                Object value = exportDataMap.get(key);
                if (isImport && "actiontype".equals(key)) {
                    CellRangeAddress region = new CellRangeAddress(rowIndex, rowIndex, columnIndex, columnIndex);
                    if (isAllowEdit) {
                        value = cover;
                        allowModifyCellList.addCellRangeAddress(region);
                    } else {
                        value = "--";
                        forbidModifyCellList.addCellRangeAddress(region);
                    }
                }
                if (null == value || SWCStringUtils.isEmpty((String)value.toString())) continue;
                Map<String, Object> itemInfo = SalaryDetailResultExportHelper.getItemInfo(gridItemInfo, key);
                String cellStyleKey = SalaryDetailResultExportHelper.getCellStyleKey(itemInfo, sign = (String)exportDataMap.get(key + "_sign"));
                CellStyle defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey);
                if (defaultStyle == null) {
                    defaultStyle = SalaryDetailResultExportHelper.getDefaultCellStyle(itemInfo, sign, wb);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                String dataType = "";
                if (null == itemInfo) {
                    if (value instanceof String) {
                        dataType = "text";
                    } else if (value instanceof Date) {
                        dataType = "date";
                    } else if (value instanceof BigDecimal) {
                        dataType = "num";
                    } else if (value instanceof Boolean) {
                        boolean boolVal = (Boolean)value;
                        value = boolVal ? ResManager.loadKDString((String)"\u662f", (String)"SalaryDetailResultExportHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"SalaryDetailResultExportHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
                        dataType = "text";
                    }
                } else {
                    dataType = (String)itemInfo.get(DATATYPE);
                }
                if ("salaryfilev.paystatus".equals(key)) {
                    String strVal = String.valueOf(value);
                    if (SWCStringUtils.equals((String)strVal, (String)"0")) {
                        value = ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u85aa", (String)"SalaryDetailResultExportHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
                    } else if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                        value = ResManager.loadKDString((String)"\u6b63\u5e38\u7b97\u85aa", (String)"SalaryDetailResultExportHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
                    }
                }
                if ("empposorgrelhrv.isprimary".equals(key)) {
                    String strVal = String.valueOf(value);
                    if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                        value = ResManager.loadKDString((String)"\u662f", (String)"SalaryDetailResultExportHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
                    } else if (SWCStringUtils.equals((String)strVal, (String)"0")) {
                        value = ResManager.loadKDString((String)"\u5426", (String)"SalaryDetailResultExportHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
                    }
                }
                if ("trialperiodv.probationunit".equals(key)) {
                    String strVal = String.valueOf(value);
                    if (SWCStringUtils.equals((String)strVal, (String)"4")) {
                        value = Character.valueOf('-');
                    } else if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                        value = ResManager.loadKDString((String)"\u4e2a\u6708", (String)"SalaryDetailResultExportHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
                    } else if (SWCStringUtils.equals((String)strVal, (String)"2")) {
                        value = ResManager.loadKDString((String)"\u5468", (String)"SalaryDetailResultExportHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]);
                    } else if (SWCStringUtils.equals((String)strVal, (String)"3")) {
                        value = ResManager.loadKDString((String)"\u5929", (String)"SalaryDetailResultExportHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
                    }
                }
                if (SWCStringUtils.equals((String)"bizdatagenstatus", (String)key)) {
                    String strVal = String.valueOf(value);
                    if (SWCStringUtils.equals((String)strVal, (String)"1")) {
                        value = ResManager.loadKDString((String)"\u672a\u751f\u6210", (String)"SalaryDetailResultExportHelper_18", (String)"swc-hsas-business", (Object[])new Object[0]);
                    } else if (SWCStringUtils.equals((String)strVal, (String)"2")) {
                        value = ResManager.loadKDString((String)"\u5df2\u751f\u6210", (String)"SalaryDetailResultExportHelper_19", (String)"swc-hsas-business", (Object[])new Object[0]);
                    }
                }
                SalaryDetailResultExportHelper.parseCellValue(columnCell, value, dataType);
                if (value != null && SalaryDetailResultExportHelper.getColumnWidth(String.valueOf(value)) > columnWidthMap.get(columnIndex)) {
                    columnWidthMap.put(columnIndex, SalaryDetailResultExportHelper.getColumnWidth(String.valueOf(value)));
                }
                columnCell.setCellType(SalaryDetailResultExportHelper.getCellType(dataType));
                columnCell.setCellStyle(defaultStyle);
            }
        }
        if (isImport) {
            String[] option;
            HashMap<String, Object> validationMap;
            ArrayList<Map<String, Object>> validationList = new ArrayList<Map<String, Object>>(10);
            if (allowModifyCellList.getCellRangeAddresses().length > 0) {
                validationMap = new HashMap<String, Object>(16);
                option = new String[]{cover, ResManager.loadKDString((String)"\u7d2f\u52a0", (String)"SalaryDetailResultExportHelper_2", (String)"swc-hsas-business", (Object[])new Object[0])};
                validationMap.put("option", option);
                validationMap.put("celllist", allowModifyCellList);
                validationMap.put("tips", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7d2f\u52a0\u65f6\uff0c\u8bf7\u5148\u6e05\u7a7a\u5355\u5143\u683c\u6570\u636e\uff0c\u518d\u586b\u5199\u7d2f\u52a0\u503c\u3002", (String)"SalaryDetailResultExportHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
                validationList.add(validationMap);
            }
            if (forbidModifyCellList.getCellRangeAddresses().length > 0) {
                validationMap = new HashMap(16);
                option = new String[]{"--"};
                validationMap.put("option", option);
                validationMap.put("celllist", forbidModifyCellList);
                validationList.add(validationMap);
            }
            SalaryDetailResultExportHelper.addValidation(sheet, validationList);
        }
    }

    public static Map<String, Object> getItemInfo(Map<String, Map<String, Object>> gridItemInfo, String key) {
        for (Map.Entry<String, Map<String, Object>> entry : gridItemInfo.entrySet()) {
            String itemKey = entry.getKey();
            if (!SWCStringUtils.equals((String)key, (String)itemKey.replace("_", "").toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void addValidation(SXSSFSheet sheet, List<Map<String, Object>> validationList) {
        for (Map<String, Object> validationMap : validationList) {
            String[] option = (String[])validationMap.get("option");
            CellRangeAddressList cellList = (CellRangeAddressList)validationMap.get("celllist");
            String tips = (String)validationMap.get("tips");
            DataValidationConstraint constraint = sheet.getDataValidationHelper().createExplicitListConstraint(option);
            DataValidation validation = sheet.getDataValidationHelper().createValidation(constraint, cellList);
            if (SWCStringUtils.isNotEmpty((String)tips)) {
                validation.createPromptBox("", tips);
                validation.setShowPromptBox(true);
            }
            if (validation instanceof XSSFDataValidation) {
                validation.setSuppressDropDownArrow(true);
                validation.setShowErrorBox(true);
            } else {
                validation.setSuppressDropDownArrow(false);
            }
            sheet.addValidationData(validation);
        }
    }

    public static void parseCellValue(SXSSFCell cell, Object value, String dataType) {
        if (SWCStringUtils.equals((String)dataType, (String)"text")) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            if (value instanceof Date) {
                String dateStr = SWCInteDateTimeUtil.formateDate((Date)((Date)value));
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCInteDateTimeUtil.formateDate((Date)dateValue);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                cell.setCellValue(valueStr);
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)"num") || SWCStringUtils.equals((String)dataType, (String)"amount")) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    public static CellStyle getDefaultCellStyle(Map<String, Object> itemInfoMap, String sign, SXSSFWorkbook wb) {
        String dataType = "";
        Integer scale = 0;
        CellStyle cellStyle = wb.createCellStyle();
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        if (SWCStringUtils.equals((String)dataType, (String)"num")) {
            SalaryDetailResultExportHelper.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)"date")) {
            SalaryDetailResultExportHelper.getDateCellStyle(wb, cellStyle);
        } else if (SWCStringUtils.equals((String)dataType, (String)"amount")) {
            SalaryDetailResultExportHelper.getAmountCellStyle(wb, cellStyle, sign, scale);
        } else {
            SalaryDetailResultExportHelper.getStringCellStyle(wb, cellStyle);
        }
        return cellStyle;
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String sign, int scale) {
        if (SWCStringUtils.isEmpty((String)sign)) {
            sign = "";
        }
        DataFormat format = wb.createDataFormat();
        String styleStr = sign + "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    public static String getCellStyleKey(Map<String, Object> itemInfoMap, String sign) {
        StringBuilder keyBuilder = new StringBuilder();
        String dataType = "";
        Integer scale = 0;
        if (null == itemInfoMap) {
            dataType = "text";
        } else {
            dataType = (String)itemInfoMap.get(DATATYPE);
            scale = (Integer)itemInfoMap.get("scale");
        }
        if (SWCStringUtils.isEmpty((String)dataType)) {
            dataType = "text";
        }
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(scale);
        keyBuilder.append('#');
        keyBuilder.append(sign);
        return keyBuilder.toString();
    }
}

