/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salarydeatilresult.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calresulttpl.helper.CalResultTplAddItemServiceHelper;
import kd.swc.hsas.business.salaryresultlist.helper.HSASCalResultListHelper;
import kd.swc.hsas.common.enums.CalResultTplColorEnum;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryDetailResultListHelper {
    public Map<String, String> getFixedCloum() {
        LinkedHashMap<String, String> fixedCloumMap = new LinkedHashMap<String, String>(3);
        LocaleString salaryfilevStr = new LocaleString(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"SalaryDetailResultListHelper_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        fixedCloumMap.put("filenumber", salaryfilevStr.toString());
        LocaleString nameStr = new LocaleString(ResManager.loadKDString((String)"\u59d3\u540d", (String)"SalaryDetailResultListHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        fixedCloumMap.put("name", nameStr.toString());
        LocaleString empnumberStr = new LocaleString(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SalaryDetailResultListHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        fixedCloumMap.put("empnumber", empnumberStr.toString());
        return fixedCloumMap;
    }

    public String buildCalPersonSql(Map<String, String> calPersonInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("filenumber,name,empnumber,salaryfilev.id");
        Map<String, String> fixedCloum = this.getFixedCloum();
        for (Map.Entry<String, String> entry : calPersonInfo.entrySet()) {
            String field = entry.getKey();
            if (fixedCloum.containsKey(field)) continue;
            sb.append(',').append(entry.getKey());
            if (SWCStringUtils.equals((String)"salaryfilev.adminorg.name", (String)field)) {
                sb.append(',').append("adminorg.name");
                continue;
            }
            if (!SWCStringUtils.equals((String)"salaryfilev.empgroup.name", (String)field)) continue;
            sb.append(',').append("empgroup.name");
        }
        return sb.toString();
    }

    public ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        return col;
    }

    public void setFontColor(DynamicObject dy, ListColumn column, Map<Long, String> colorMap) {
        String color = colorMap.get(dy.getLong("calcolor.id"));
        column.setForeColor(color);
    }

    public Map<String, String> getCalPersonListInfo(Long calResultTplId, IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        String cacheKey = view.getPageId() + calResultTplId;
        LinkedHashMap<String, String> itemMap = new LinkedHashMap();
        if ((itemMap = (Map)pageCache.get(cacheKey, itemMap.getClass())) != null) {
            return itemMap;
        }
        itemMap = this.getCalPersonListFormDB(calResultTplId, view);
        pageCache.put(cacheKey, itemMap);
        return itemMap;
    }

    private Map<String, String> getCalPersonListFormDB(Long calResultTplId, IFormView view) {
        DynamicObjectCollection payRollList;
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresulttpl");
        String queryField = "id,number,name,uniquecode,payrolllist.fieldname,payrolllist.alias,payrolllist.field,ishighlight,highlightcolor";
        QFilter filter = new QFilter("id", "=", (Object)calResultTplId);
        DynamicObject tplData = helper.queryOne(queryField, new QFilter[]{filter});
        if (tplData == null) {
            return tempMap;
        }
        if (tplData.getBoolean("ishighlight") && SWCStringUtils.isNotEmpty((String)tplData.getString("highlightcolor"))) {
            String highLightColor = tplData.getString("highlightcolor");
            for (CalResultTplColorEnum calResultTplColorEnum : CalResultTplColorEnum.values()) {
                if (!SWCStringUtils.equals((String)calResultTplColorEnum.getCode(), (String)highLightColor)) continue;
                view.getPageCache().put("highlightcolor", calResultTplColorEnum.getColorStyle());
                break;
            }
        }
        if ((payRollList = tplData.getDynamicObjectCollection("payrolllist")) == null || payRollList.size() == 0) {
            return tempMap;
        }
        for (DynamicObject payRollObj : payRollList) {
            String fieldName = payRollObj.getString("fieldname");
            String alias = payRollObj.getString("alias");
            String fieldId = payRollObj.getString("field");
            if (SWCStringUtils.isEmpty((String)alias)) {
                tempMap.put(fieldId, fieldName);
                continue;
            }
            tempMap.put(fieldId, alias);
        }
        return tempMap;
    }

    public Map<String, Map<String, Object>> getCalResultTplInfo(Long calResultTplId, IFormView view, Long calTaskId) {
        SWCPageCache pageCache = new SWCPageCache(view);
        String cacheKey = view.getPageId() + calResultTplId + calTaskId;
        LinkedHashMap<String, Map<String, Object>> itemMap = new LinkedHashMap();
        if ((itemMap = (Map)pageCache.get(cacheKey, itemMap.getClass())) != null) {
            return itemMap;
        }
        DynamicObject taskInfo = this.getTaskInfo(calTaskId);
        if (SWCObjectUtils.isEmpty((Object)taskInfo)) {
            return itemMap;
        }
        itemMap = this.getCalResultTplFormDB(calResultTplId, taskInfo);
        pageCache.put(cacheKey, itemMap);
        return itemMap;
    }

    private Map<String, Map<String, Object>> getCalResultTplFormDB(Long calResultTplId, DynamicObject taskInfo) {
        LinkedHashMap<String, Map<String, Object>> tempMap = new LinkedHashMap<String, Map<String, Object>>(16);
        DynamicObject calCurrency = taskInfo.getDynamicObject("payrollgroupv.currency");
        Long calCurrencyId = calCurrency.getLong("id");
        String calCurrencyNum = calCurrency.getString("number");
        String calCurrencyName = calCurrency.getString("name");
        int currencyAmtprecision = taskInfo.getInt("payrollgroupv.currency.amtprecision");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresulttpl");
        String queryField = "id,number,name,uniquecode,resultlist.itemunicodeid,resultlist.resultalias,resultlist.seq";
        QFilter filter = new QFilter("id", "=", (Object)calResultTplId);
        DynamicObject tplData = helper.queryOne(queryField, new QFilter[]{filter});
        if (tplData == null) {
            return tempMap;
        }
        DynamicObjectCollection resultDatas = tplData.getDynamicObjectCollection("resultlist");
        if (resultDatas == null || resultDatas.size() == 0) {
            return tempMap;
        }
        Map<String, Integer> seqMap = this.getSeqByDynamicObject(resultDatas);
        Map<String, String> aliasMap = this.getAliasByDynamicObject(resultDatas);
        ArrayList<String> ftList = new ArrayList<String>(10);
        ArrayList<String> slList = new ArrayList<String>(10);
        ArrayList<String> bsList = new ArrayList<String>(10);
        ArrayList<String> sdList = new ArrayList<String>(10);
        ArrayList<String> spList = new ArrayList<String>(10);
        ArrayList<String> acList = new ArrayList<String>(10);
        for (DynamicObject dataObj : resultDatas) {
            String uniqueCode = dataObj.getString("itemunicodeid");
            if (uniqueCode.startsWith("FT_")) {
                ftList.add(uniqueCode);
                continue;
            }
            if (uniqueCode.startsWith("SL_") || uniqueCode.startsWith("SI_")) {
                slList.add(uniqueCode);
                continue;
            }
            if (uniqueCode.startsWith("BS_")) {
                bsList.add(uniqueCode);
                continue;
            }
            if (uniqueCode.startsWith("SD_")) {
                sdList.add(uniqueCode);
                continue;
            }
            if (uniqueCode.startsWith("SP_")) {
                spList.add(uniqueCode);
                continue;
            }
            if (!uniqueCode.startsWith("AC_")) continue;
            acList.add(uniqueCode);
        }
        if (ftList != null && ftList.size() > 0) {
            this.getFTItemData(ftList, aliasMap, seqMap, tempMap);
        }
        Long totalSalaryId = taskInfo.getLong("calrulev.totalsalary.id");
        Long netSalaryId = taskInfo.getLong("calrulev.netsalary.id");
        if (slList != null && slList.size() > 0) {
            this.getSLItemData(slList, aliasMap, seqMap, currencyAmtprecision, calCurrencyId, calCurrencyNum, calCurrencyName, totalSalaryId, netSalaryId, tempMap);
        }
        if (bsList != null && bsList.size() > 0) {
            this.getBSItemData(helper, queryField, filter, bsList, aliasMap, seqMap, currencyAmtprecision, calCurrencyId, calCurrencyNum, calCurrencyName, tempMap);
        }
        if (sdList != null && sdList.size() > 0) {
            this.getSDItemData(helper, queryField, filter, sdList, aliasMap, seqMap, currencyAmtprecision, calCurrencyId, calCurrencyNum, calCurrencyName, tempMap);
        }
        if (spList != null && spList.size() > 0) {
            this.getSPItemData(helper, queryField, filter, spList, aliasMap, seqMap, currencyAmtprecision, calCurrencyId, calCurrencyNum, calCurrencyName, tempMap);
        }
        if (acList != null && acList.size() > 0) {
            this.getAccItemData(helper, queryField, filter, acList, aliasMap, currencyAmtprecision, calCurrencyId, seqMap, calCurrencyNum, calCurrencyName, tempMap);
        }
        return tempMap;
    }

    private void getAccItemData(SWCDataServiceHelper helper, String queryField, QFilter filter, List<String> acList, Map<String, String> aliasMap, int currencyAmtprecision, Long calCurrencyId, Map<String, Integer> seqMap, String calCurrencyNum, String calCurrencyName, Map<String, Map<String, Object>> tempMap) {
        helper = new SWCDataServiceHelper("hsas_accumulator");
        queryField = "id,number,name,uniquecode,datatype.showtype,datatype.storagetype,dataprecision.scale";
        filter = new QFilter("uniquecode", "in", acList);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        for (DynamicObject resultObj : result) {
            String name = resultObj.getString("name");
            String uniqueCode = resultObj.getString("uniquecode");
            String alias = this.getAlias(uniqueCode, aliasMap);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                name = alias;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            Long id = resultObj.getLong("id");
            dataMap.put("id", id);
            dataMap.put("name", name);
            dataMap.put("uniquecode", uniqueCode);
            String number = resultObj.getString("number");
            dataMap.put("number", number);
            String showType = resultObj.getString("datatype.showtype");
            dataMap.put("showType", showType);
            String dataType = resultObj.getString("datatype.storagetype");
            dataMap.put("dataType", dataType);
            if (SWCStringUtils.equals((String)showType, (String)SWCShowType.NUM.getCode())) {
                dataMap.put("dataLength", 13);
                Integer scale = resultObj.getInt("dataprecision.scale");
                if (scale != null) {
                    dataMap.put("scale", scale);
                }
            } else if (SWCStringUtils.equals((String)showType, (String)SWCShowType.AMOUNT.getCode())) {
                dataMap.put("dataLength", 13);
                dataMap.put("scale", currencyAmtprecision);
                dataMap.put("calCurrencyId", String.valueOf(calCurrencyId));
                dataMap.put("calCurrencyNum", calCurrencyNum);
                dataMap.put("calCurrencyName", calCurrencyName);
            }
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    private int getSeq(String uniqueCode, Map<String, Integer> seqMap) {
        Integer seq = seqMap.get(uniqueCode);
        if (seq != null) {
            return seq;
        }
        return 0;
    }

    private String getAlias(String uniqueCode, Map<String, String> aliasMap) {
        return aliasMap.get(uniqueCode);
    }

    private void getSPItemData(SWCDataServiceHelper helper, String queryField, QFilter filter, List<String> spList, Map<String, String> aliasMap, Map<String, Integer> seqMap, int currencyAmtprecision, Long calCurrencyId, String calCurrencyNum, String calCurrencyName, Map<String, Map<String, Object>> tempMap) {
        helper = new SWCDataServiceHelper("hsbs_supportitem");
        queryField = "id,number,name,uniquecode,datatype.showtype,datatype.storagetype,datalength,dataprecision.scale";
        filter = new QFilter("uniquecode", "in", spList);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        for (DynamicObject resultObj : result) {
            String name = resultObj.getString("name");
            String uniqueCode = resultObj.getString("uniquecode");
            String alias = this.getAlias(uniqueCode, aliasMap);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                name = alias;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("name", name);
            dataMap.put("uniquecode", uniqueCode);
            String number = resultObj.getString("number");
            dataMap.put("number", number);
            String showType = resultObj.getString("datatype.showtype");
            dataMap.put("showType", showType);
            String dataType = resultObj.getString("datatype.storagetype");
            dataMap.put("dataType", dataType);
            if (SWCStringUtils.equals((String)showType, (String)SWCShowType.NUM.getCode())) {
                dataMap.put("dataLength", 13);
                Integer scale = resultObj.getInt("dataprecision.scale");
                if (scale != null) {
                    dataMap.put("scale", scale);
                }
            } else if (SWCStringUtils.equals((String)showType, (String)SWCShowType.TEXT.getCode())) {
                Integer dataLength = resultObj.getInt("datalength");
                dataMap.put("dataLength", dataLength);
            } else if (SWCStringUtils.equals((String)showType, (String)SWCShowType.AMOUNT.getCode())) {
                dataMap.put("dataLength", 13);
                dataMap.put("scale", currencyAmtprecision);
                dataMap.put("calCurrencyId", String.valueOf(calCurrencyId));
                dataMap.put("calCurrencyNum", calCurrencyNum);
                dataMap.put("calCurrencyName", calCurrencyName);
            }
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    private void getSDItemData(SWCDataServiceHelper helper, String queryField, QFilter filter, List<String> sdList, Map<String, String> aliasMap, Map<String, Integer> seqMap, int currencyAmtprecision, Long calCurrencyId, String calCurrencyNum, String calCurrencyName, Map<String, Map<String, Object>> tempMap) {
        helper = new SWCDataServiceHelper("hsbs_standarditem");
        queryField = "id,number,name,uniquecode,currency";
        filter = new QFilter("uniquecode", "in", sdList);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        for (DynamicObject resultObj : result) {
            String name = resultObj.getString("name");
            String uniqueCode = resultObj.getString("uniquecode");
            String alias = this.getAlias(uniqueCode, aliasMap);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                name = alias;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("name", name);
            dataMap.put("uniquecode", uniqueCode);
            String number = resultObj.getString("number");
            dataMap.put("number", number);
            dataMap.put("showType", SWCShowType.AMOUNT.getCode());
            dataMap.put("dataType", SWCShowType.AMOUNT.getCode());
            dataMap.put("dataLength", 13);
            Integer amtprecision = resultObj.getInt("currency.amtprecision");
            dataMap.put("scale", 2);
            if (amtprecision != null) {
                dataMap.put("scale", currencyAmtprecision);
            }
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            dataMap.put("calCurrencyId", String.valueOf(calCurrencyId));
            dataMap.put("calCurrencyNum", calCurrencyNum);
            dataMap.put("calCurrencyName", calCurrencyName);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    private void getBSItemData(SWCDataServiceHelper helper, String queryField, QFilter filter, List<String> bsList, Map<String, String> aliasMap, Map<String, Integer> seqMap, int currencyAmtprecision, Long calCurrencyId, String calCurrencyNum, String calCurrencyName, Map<String, Map<String, Object>> tempMap) {
        helper = new SWCDataServiceHelper("hsbs_bizitem");
        queryField = "id,number,name,uniquecode,datatype.showtype,datatype.storagetype,datalength,scalelimit";
        filter = new QFilter("uniquecode", "in", bsList);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        for (DynamicObject resultObj : result) {
            String name = resultObj.getString("name");
            String uniqueCode = resultObj.getString("uniquecode");
            String alias = this.getAlias(uniqueCode, aliasMap);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                name = alias;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("id", resultObj.getLong("id"));
            dataMap.put("name", name);
            dataMap.put("uniquecode", uniqueCode);
            String number = resultObj.getString("number");
            dataMap.put("number", number);
            String showType = resultObj.getString("datatype.showtype");
            dataMap.put("showType", showType);
            String dataType = resultObj.getString("datatype.storagetype");
            dataMap.put("dataType", dataType);
            Integer dataLength = resultObj.getInt("datalength");
            if (dataLength != null) {
                dataMap.put("dataLength", dataLength);
            }
            dataMap.put("scale", 10);
            if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)dataType)) {
                dataMap.put("dataLength", 13);
                dataMap.put("scale", currencyAmtprecision);
                dataMap.put("calCurrencyId", String.valueOf(calCurrencyId));
                dataMap.put("calCurrencyNum", calCurrencyNum);
                dataMap.put("calCurrencyName", calCurrencyName);
            } else if (SWCStringUtils.equals((String)SWCShowType.NUM.getCode(), (String)dataType)) {
                dataMap.put("dataLength", 13);
                String scaleLimit = resultObj.getString("scalelimit");
                if (SWCStringUtils.isNotEmpty((String)scaleLimit)) {
                    dataMap.put("scale", Integer.parseInt(scaleLimit));
                }
            }
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    private void getSLItemData(List<String> slList, Map<String, String> aliasMap, Map<String, Integer> seqMap, int currencyAmtprecision, Long calCurrencyId, String calCurrencyNum, String calCurrencyName, Long totalSalaryId, Long netSalaryId, Map<String, Map<String, Object>> tempMap) {
        String sql = this.getRuleItemSql(slList);
        ResultSetHandler res = rs -> {
            LinkedHashMap<String, HashMap> slTempMap = new LinkedHashMap<String, HashMap>(16);
            int dataLength = 0;
            int scale = 0;
            Long id = 0L;
            Long dataroundId = 0L;
            Long dataTypeId = 0L;
            String number = "";
            String name = "";
            String storagetype = "";
            String showType = "";
            String dataTypeName = "";
            boolean ispayoutitem = false;
            HashMap itemData = null;
            while (rs.next()) {
                id = rs.getLong("itemId");
                number = rs.getString("itemNum");
                name = rs.getString("itemName");
                String uniquecode = rs.getString("uniquecode");
                String alias = this.getAlias(uniquecode, aliasMap);
                if (SWCStringUtils.isNotEmpty((String)alias)) {
                    name = alias;
                }
                storagetype = rs.getString("storagetype");
                showType = rs.getString("showType");
                dataLength = rs.getInt("dataLen");
                scale = rs.getInt("scale");
                dataroundId = rs.getLong("dataroundid");
                ispayoutitem = SWCStringUtils.equals((String)rs.getString("ispayoutitem"), (String)"1");
                dataTypeId = rs.getLong("dataTypeId");
                dataTypeName = rs.getString("dataTypeName");
                itemData = Maps.newHashMapWithExpectedSize((int)32);
                itemData.put("id", id);
                itemData.put("number", number);
                itemData.put("name", name);
                itemData.put("dataType", storagetype);
                itemData.put("showType", showType);
                itemData.put("dataTypeId", dataTypeId);
                itemData.put("dataTypeName", dataTypeName);
                itemData.put("dataLength", dataLength);
                if (SWCStringUtils.equals((String)SWCShowType.AMOUNT.getCode(), (String)storagetype)) {
                    itemData.put("scale", currencyAmtprecision);
                    itemData.put("calCurrencyId", String.valueOf(calCurrencyId));
                    itemData.put("calCurrencyNum", calCurrencyNum);
                    itemData.put("calCurrencyName", calCurrencyName);
                } else {
                    itemData.put("scale", scale);
                }
                itemData.put("dataroundId", dataroundId);
                itemData.put("ispayoutitem", ispayoutitem);
                itemData.put("istotalsalary", id.equals(totalSalaryId));
                itemData.put("isnetsalary", id.equals(netSalaryId));
                slTempMap.put(uniquecode, itemData);
            }
            return slTempMap;
        };
        String locale = String.valueOf(RequestContext.get().getLang().getLocale());
        Map itemMap = (Map)SWCDbUtil.query((DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[]{locale, locale}, (ResultSetHandler)res);
        for (Map.Entry entry : itemMap.entrySet()) {
            String uniqueCode = (String)entry.getKey();
            Map dataMap = (Map)entry.getValue();
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            dataMap.put("uniquecode", uniqueCode);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    private String getRuleItemSql(List<String> uniqueCodeList) {
        StringBuilder uniqueCodeSb = new StringBuilder();
        uniqueCodeSb.append('(');
        int size = uniqueCodeList.size();
        for (int i = 0; i < size; ++i) {
            String uniqueCode = uniqueCodeList.get(i);
            uniqueCodeSb.append('\'').append(uniqueCode).append('\'');
            if (i == size - 1) continue;
            uniqueCodeSb.append(',');
        }
        uniqueCodeSb.append(')');
        StringBuilder sb = new StringBuilder();
        sb.append("select item.fid itemId,item.fnumber itemNum,item.funiquecode uniquecode,item.fdatalength dataLen,item.fdataroundid dataroundid,item.fproratesummarytype proratesummarytype,");
        sb.append("ruleItem.fispayoutitem ispayoutitem,");
        sb.append(SWCConstants.NEW_LINE);
        sb.append(" case when item_l.fname is null THEN  item.fname else item_l.fname end as itemName, dataType.fid dataTypeId,datatype_l.fname dataTypeName, dataType.fstoragetype storagetype, dataType.fshowtype showType, t_precion.fscale scale").append(SWCConstants.NEW_LINE);
        sb.append("  from t_hsbs_salaryitem item").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsbs_salaryitem_l item_l on item.fid=item_l.fid and item_l.flocaleid=?").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsbs_datatype dataType on item.fdatatypeid=dataType.fid").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsbs_datatype_l dataType_l on dataType.fid=dataType_l.fid and dataType_l.flocaleid=?").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsbs_dataprecision t_precion on item.fdataprecisionid=t_precion.fid").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsas_calruleitementry ruleItem on item.fid=ruleItem.fsalaryitemid").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsas_calpayrolltask task on task.fcalrulevid=ruleItem.fid").append(SWCConstants.NEW_LINE);
        sb.append("  left join t_hsas_calrule calRule on ruleItem.fid=calRule.fid").append(SWCConstants.NEW_LINE);
        sb.append(" where item.funiquecode in ").append((CharSequence)uniqueCodeSb).append(SWCConstants.NEW_LINE);
        sb.append("  order by ruleItem.fseq").append(SWCConstants.NEW_LINE);
        return sb.toString();
    }

    private void getFTItemData(List<String> ftList, Map<String, String> aliasMap, Map<String, Integer> seqMap, Map<String, Map<String, Object>> tempMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        String queryField = "id,number,name,datatype.showtype,datatype.storagetype,uniquecode,dataround.id,dataprecision.id";
        QFilter filter = new QFilter("uniquecode", "in", ftList);
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        for (DynamicObject resultObj : result) {
            String name = resultObj.getString("name");
            String uniqueCode = resultObj.getString("uniquecode");
            String alias = this.getAlias(uniqueCode, aliasMap);
            if (SWCStringUtils.isNotEmpty((String)alias)) {
                name = alias;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("name", name);
            dataMap.put("uniquecode", uniqueCode);
            String itemNumber = resultObj.getString("number");
            dataMap.put("number", itemNumber);
            String showType = resultObj.getString("datatype.showtype");
            dataMap.put("showType", showType);
            String dataType = resultObj.getString("datatype.storagetype");
            dataMap.put("dataType", dataType);
            if (SWCStringUtils.equals((String)showType, (String)SWCShowType.NUM.getCode())) {
                long precision = resultObj.getLong("dataprecision.id");
                long dataRound = resultObj.getLong("dataround.id");
                dataMap.put("dataLength", 13);
                dataMap.put("scale", ItemDataUtils.getScal((long)precision));
                dataMap.put("dataRound", dataRound);
            } else if (SWCStringUtils.equals((String)showType, (String)SWCShowType.TEXT.getCode())) {
                dataMap.put("dataLength", 50);
            }
            int seq = this.getSeq(uniqueCode, seqMap);
            dataMap.put("seq", seq);
            tempMap.put(uniqueCode, dataMap);
        }
    }

    public String getBCDataType(String fieldType) {
        if (SWCStringUtils.equals((String)fieldType, (String)"BigDecimal")) {
            return SWCShowType.NUM.getCode();
        }
        if (SWCStringUtils.equals((String)fieldType, (String)"Date")) {
            return SWCShowType.DATE.getCode();
        }
        return SWCShowType.TEXT.getCode();
    }

    private Map<String, String> getAliasByDynamicObject(DynamicObjectCollection resultDatas) {
        HashMap<String, String> retMap = new HashMap<String, String>(16);
        if (resultDatas == null || resultDatas.size() == 0) {
            return retMap;
        }
        for (DynamicObject resultData : resultDatas) {
            String resultUnicode = resultData.getString("itemunicodeid");
            String alias = resultData.getString("resultalias");
            retMap.put(resultUnicode, alias);
        }
        return retMap;
    }

    private Map<String, Integer> getSeqByDynamicObject(DynamicObjectCollection resultDatas) {
        HashMap<String, Integer> retMap = new HashMap<String, Integer>(16);
        if (resultDatas == null || resultDatas.size() == 0) {
            return retMap;
        }
        for (DynamicObject resultData : resultDatas) {
            String resultUnicode = resultData.getString("itemunicodeid");
            Integer seq = resultData.getInt("seq");
            retMap.put(resultUnicode, seq);
        }
        return retMap;
    }

    public DynamicObject getTaskInfo(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "name,payrollgroup.name,payrollgroupv.name,payrollgroupv.bsed,payrollgroupv.bsled,calrule.name,calrulev,calrulev.name,calrulev.bsed,calrulev.totalsalary.id,calrulev.netsalary.id,calrulev.bsled,payrolldate,calcount,period.name,payrollgroupv.currency.amtprecision";
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        QFilter[] filters = new QFilter[]{taskFilter};
        DynamicObject taskInfo = helper.queryOne(field, filters);
        return taskInfo;
    }

    public long getPayGroupIdByVid(long payRollGroupVid) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        String queryField = "id,number,boid";
        QFilter filter = new QFilter("id", "=", (Object)payRollGroupVid);
        DynamicObject result = helper.queryOne(queryField, new QFilter[]{filter});
        return result.getLong("boid");
    }

    public DynamicObjectCollection getCalResultTpl(Long payRollGroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresulttpl");
        String queryField = "id,number,name";
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
        filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
        DynamicObjectCollection result = helper.queryOriginalCollection(queryField, new QFilter[]{filter});
        return result;
    }

    public Map<String, String> getExportHeaders(long calResultTplId, String pageId, boolean isImport, Map<String, Map<String, Object>> gridItemInfo, Map<String, String> payRollListInfo) {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(16);
        List<String> fixedColumnNumberList = Arrays.asList("empnumber", "name", "filenumber");
        List fixedColumnList = payRollListInfo.keySet().stream().filter(single -> fixedColumnNumberList.contains(single)).collect(Collectors.toList());
        for (String string : fixedColumnList) {
            headerMap.put(string, payRollListInfo.get(string));
        }
        for (Map.Entry entry : payRollListInfo.entrySet()) {
            String key = (String)entry.getKey();
            if (fixedColumnList.contains(key)) continue;
            headerMap.put(key, (String)entry.getValue());
        }
        Iterator<Map<String, Object>> it = gridItemInfo.values().iterator();
        String string = "";
        String name = "";
        boolean allowResultCover = false;
        while (it.hasNext()) {
            Map<String, Object> itemMap = it.next();
            String string2 = MapUtils.getString(itemMap, (Object)"uniquecode");
            name = MapUtils.getString(itemMap, (Object)"name");
            if (isImport) {
                allowResultCover = MapUtils.getBooleanValue(itemMap, (Object)"allowresultcover");
                if (!allowResultCover) continue;
                headerMap.put(string2, name);
                continue;
            }
            headerMap.put(string2, name);
        }
        return headerMap;
    }

    public ListShowParameter getCalTableListForm(String parentPageId, long calTaskId, Long calResultTplId) {
        Map<String, String> taskInfo = this.getTaskInfoToMap(calTaskId);
        if (taskInfo == null) {
            return null;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsas_calpersonlist");
        showParameter.setBillFormId("hsas_calperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("payrolltaskdatanumber", (Object)taskInfo.get("payrolltaskdatanumber"));
        showParameter.setCustomParam("payrolltaskdataid", (Object)calTaskId);
        showParameter.setCustomParam("org", (Object)taskInfo.get("orgId"));
        showParameter.setCustomParam("name", (Object)taskInfo.get("name"));
        showParameter.setCustomParam("startdate", (Object)taskInfo.get("startdate"));
        showParameter.setCustomParam("enddate", (Object)taskInfo.get("enddate"));
        showParameter.setCustomParam("calListViewVid", (Object)taskInfo.get("calListViewVid"));
        showParameter.setCustomParam("payrollgroup", (Object)taskInfo.get("payrollgroup"));
        showParameter.setCustomParam("payrollgroupv", (Object)taskInfo.get("payrollgroupv"));
        showParameter.setCustomParam("payrolldate", (Object)taskInfo.get("payrolldate"));
        showParameter.setCustomParam("calTaskType", (Object)taskInfo.get("calTaskType"));
        showParameter.setCustomParam("payRollSceneVId", (Object)taskInfo.get("payRollSceneVId"));
        showParameter.setCustomParam("calPeriodId", (Object)taskInfo.get("calPeriodVId"));
        showParameter.setCustomParam("calRuleId", (Object)taskInfo.get("calRuleId"));
        showParameter.setCustomParam("calRuleVId", (Object)taskInfo.get("calRuleVId"));
        showParameter.setCustomParam("calTimes", (Object)taskInfo.get("calCount"));
        showParameter.setCustomParam("orgName", (Object)taskInfo.get("orgName"));
        showParameter.setCustomParam("taskstatus", (Object)taskInfo.get("taskstatus"));
        showParameter.setCustomParam("countryId", (Object)taskInfo.get("countryId"));
        showParameter.setCustomParam("isEdit", (Object)Boolean.FALSE);
        showParameter.setCustomParam("isSplitPage", (Object)Boolean.TRUE);
        showParameter.setCustomParam("isShowNotCover", (Object)Boolean.TRUE);
        showParameter.setCustomParam("notShowColumns", null);
        showParameter.setCustomParam("editColumns", null);
        showParameter.setCustomParam("isShowSalaryItem", (Object)Boolean.FALSE);
        showParameter.setPageId(parentPageId + "bill" + calTaskId + "tpl" + calResultTplId);
        return showParameter;
    }

    private Map<String, String> getTaskInfoToMap(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject dy = helper.queryOne("org.id,name,startdate,enddate,calcount,calrule.id,calrulev.id,org.name,taskstatus,country.id,payrollgroup.id,payrolldate,payrollgroupv.id,tasktype,payrollscenev.id,period.id,callistviewv.id", (Object)taskId);
        if (null == dy) {
            return null;
        }
        String orgStr = dy.getString("org.id");
        String name = dy.getString("name");
        String startDate = dy.getString("startdate");
        String endDate = dy.getString("enddate");
        String calCount = dy.getString("calcount");
        String calRuleId = dy.getString("calrule.id");
        String calRuleVId = dy.getString("calrulev.id");
        String orgName = dy.getString("org.name");
        String taskstatus = dy.getString("taskstatus");
        String calListViewVid = dy.getString("callistviewv.id");
        long countryId = dy.getLong("country.id");
        String calTaskType = dy.getString("tasktype");
        String payRollSceneId = dy.getString("payrollscenev.id");
        String calPeriodId = dy.getString("period.id");
        map.put("payrolltaskdatanumber", dy.getString("number"));
        map.put("orgId", orgStr);
        map.put("name", name);
        map.put("startdate", startDate);
        map.put("enddate", endDate);
        map.put("calCount", calCount);
        map.put("calRuleId", calRuleId);
        map.put("calRuleVId", calRuleVId);
        map.put("orgName", orgName);
        map.put("taskstatus", taskstatus);
        map.put("countryId", String.valueOf(countryId));
        map.put("payrollgroup", dy.getString("payrollgroup.id"));
        map.put("payrollgroupv", dy.getString("payrollgroupv.id"));
        map.put("payrolldate", dy.getString("payrolldate"));
        map.put("calTaskType", calTaskType);
        map.put("payRollSceneVId", payRollSceneId);
        map.put("calPeriodVId", calPeriodId);
        map.put("calListViewVid", calListViewVid);
        return map;
    }

    public static FormShowParameter openCalResultDetailPage(Long calResultTplId, Long calTaskId, String parentPageId) {
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        ListShowParameter showParameter = helper.getCalTableListForm(parentPageId, calTaskId, calResultTplId);
        if (showParameter == null) {
            return null;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_calresulttpl_appcache");
        String pageId = showParameter.getPageId();
        appCache.put(pageId + "_calResultTplCache", (Object)calResultTplId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c", (String)"HSASCalResultDetailPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("pageType", (Object)"salaryDetailResultPage");
        return showParameter;
    }

    public static ListShowParameter openCalResultTplPage(Long calTaskId, DynamicObjectCollection calResultTpls) {
        if (calResultTpls == null || calResultTpls.size() == 0) {
            return null;
        }
        Set calResultTplIds = calResultTpls.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        Map<String, Object> calMessage = SalaryDetailResultListHelper.getCalMessage(calTaskId);
        long payRollGroupVid = MapUtils.getLong(calMessage, (Object)"payRollGroupVid");
        long payRollGroupId = HSASCalResultListHelper.getPayGroupIdByVid(payRollGroupVid);
        QFilter filter = new QFilter("payrollgroups.fbasedataid_id", "=", (Object)payRollGroupId);
        filter.and("bsed", "<=", (Object)SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("id", "in", calResultTplIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        long defaultTplId = SalaryDetailResultListHelper.getDefaultTplId(calResultTpls);
        if (defaultTplId > 0L) {
            showParameter.setSelectedRow((Object)defaultTplId);
        }
        showParameter.setBillFormId("hsas_calresulttpl");
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u6a21\u677f", (String)"HSASCalResultDetailPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        return showParameter;
    }

    private static long getDefaultTplId(DynamicObjectCollection calResultTpls) {
        for (DynamicObject dataObj : calResultTpls) {
            String isDefault = dataObj.getString("isdefault");
            if (!SWCStringUtils.isNotEmpty((String)isDefault)) continue;
            return dataObj.getLong("id");
        }
        return 0L;
    }

    public static DynamicObjectCollection getCalResultTplInfo(Long calTaskId) {
        Map<String, Object> calMessage = SalaryDetailResultListHelper.getCalMessage(calTaskId);
        long payRollGroupVid = MapUtils.getLong(calMessage, (Object)"payRollGroupVid");
        long payRollGroupId = HSASCalResultListHelper.getPayGroupIdByVid(payRollGroupVid);
        CalResultTplAddItemServiceHelper helper = new CalResultTplAddItemServiceHelper();
        DynamicObjectCollection calResultTpls = helper.getCalResultTpl(payRollGroupId);
        return calResultTpls;
    }

    private static Map<String, Object> getCalMessage(Long calTaskId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObject taskInfo = SalaryDetailResultListHelper.getTaskInfoObj(calTaskId);
        if (taskInfo == null) {
            return map;
        }
        String taskName = taskInfo.getString("name");
        String payRollGroupName = taskInfo.getString("payrollgroupv.name");
        Date groupbred = taskInfo.getDate("payrollgroupv.bsed");
        String groupbredStr = SWCDateTimeUtils.format((Date)groupbred, (String)"yyyyMMdd");
        String calRuleName = taskInfo.getString("calrulev.name");
        Date rulebred = taskInfo.getDate("calrulev.bsed");
        String rulebredStr = rulebred != null ? SWCDateTimeUtils.format((Date)rulebred, (String)"yyyyMMdd") : "";
        Date payRollDate = taskInfo.getDate("payrolldate");
        String payRollDateStr = SWCDateTimeUtils.formatDate((Date)payRollDate);
        payRollGroupName = String.format("%s %s", payRollGroupName, groupbredStr);
        calRuleName = String.format("%s %s", calRuleName, rulebredStr);
        String periodInfo = "";
        map.put("taskName", taskName);
        map.put("payRollGroupName", payRollGroupName);
        map.put("payRollGroupVid", taskInfo.getLong("payrollgroupv.id"));
        map.put("calRuleName", calRuleName);
        map.put("calRuleVid", taskInfo.getLong("calrulev.id"));
        map.put("periodInfo", periodInfo);
        map.put("payRollDateStr", payRollDateStr);
        Long orgId = taskInfo.getLong("org.id");
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    private static DynamicObject getTaskInfoObj(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "name,payrollgroup.name,payrollgroupv.name,payrollgroupv.bsed,payrollgroupv.bsled,calrule.name,calrulev,calrulev.name,calrulev.bsed,calrulev.bsle,payrolldate,calcount,period.name,org.id";
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        QFilter[] filters = new QFilter[]{taskFilter};
        return helper.queryOne(field, filters);
    }
}

