/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salarydeatilresult.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryDetailResultMarkListHelper {
    private static final String SALARY_DETAIL_MARK_TABLE = "hsas_salarydtmark";
    private static final int DEFAULT_SIZE = 500;

    public void saveSalaryDetailResultMarkInfo(Map<String, Object> dataMap, Long calTaskId) {
        this.addMarkInfo(calTaskId, dataMap);
    }

    public void addMarkInfo(Long calTaskId, Map<String, Object> dataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String markReason = (String)dataMap.get("markReason");
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("markreason", "=", (Object)markReason);
        DynamicObject[] markArrays = helper.query("createtime,modifytime,modifier,marknum,calpersonentry.calpersonid,createtime", new QFilter[]{filter});
        if (markArrays == null || markArrays.length == 0) {
            DynamicObject markObj = helper.generateEmptyDynamicObject();
            markObj.set("caltaskid", (Object)calTaskId);
            String isApproveShow = (String)dataMap.get("isApproveShow");
            markObj.set("isapproveshow", (Object)isApproveShow);
            int selectListCount = (Integer)dataMap.get("selectListCount");
            markObj.set("marknum", (Object)selectListCount);
            markObj.set("markreason", (Object)markReason);
            markObj.set("createtime", (Object)new Date());
            markObj.set("modifytime", (Object)new Date());
            markObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            markObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection calPersonColl = markObj.getDynamicObjectCollection("calpersonentry");
            List selectList = (List)dataMap.get("selectList");
            for (Long calPersonId : selectList) {
                DynamicObject calPersonObj = new DynamicObject(calPersonColl.getDynamicObjectType());
                calPersonObj.set("calpersonid", (Object)calPersonId);
                calPersonColl.add((Object)calPersonObj);
            }
            markObj.set("calpersonentry", (Object)calPersonColl);
            helper.saveOne(markObj);
        } else {
            DynamicObject markObj = markArrays[0];
            HashSet<Long> markSet = new HashSet<Long>(16);
            DynamicObjectCollection markPersonColl = markObj.getDynamicObjectCollection("calpersonentry");
            for (DynamicObject markPersonObj : markPersonColl) {
                markSet.add(markPersonObj.getLong("calpersonid"));
            }
            List selectList = (List)dataMap.get("selectList");
            for (Long calPersonId : selectList) {
                if (markSet.contains(calPersonId)) continue;
                DynamicObject calPersonObj = new DynamicObject(markPersonColl.getDynamicObjectType());
                calPersonObj.set("calpersonid", (Object)calPersonId);
                markPersonColl.add((Object)calPersonObj);
            }
            markObj.set("modifytime", (Object)new Date());
            markObj.set("createtime", (Object)new Date());
            markObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            markObj.set("marknum", (Object)markPersonColl.size());
            helper.updateOne(markObj);
        }
    }

    public boolean calPersonIdEqs(List<Long> selectList, Set<Long> calPersonIdSet) {
        for (Long calPersonId : selectList) {
            if (calPersonIdSet.contains(calPersonId)) continue;
            return false;
        }
        return true;
    }

    public DynamicObject[] getMarkInfoByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,markreason,marknum,createtime,isapproveshow,calpersonentry,calpersonentry.calpersonid";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        DynamicObject[] queryColl = helper.query(filed, new QFilter[]{filter}, "createtime desc");
        return queryColl;
    }

    public Set<Long> getCalPersonIds(Long calTaskId) {
        HashSet<Long> calPersonIds = new HashSet<Long>(16);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        if (authorizedDataRuleQFilter == null || authorizedDataRuleQFilter.size() == 0) {
            DynamicObjectCollection calPersonIdColl = calPersonHelper.queryOriginalCollection("id", new QFilter[]{filter});
            if (calPersonIdColl == null || calPersonIdColl.size() == 0) {
                return calPersonIds;
            }
            for (DynamicObject dataObj : calPersonIdColl) {
                calPersonIds.add(dataObj.getLong("id"));
            }
            return calPersonIds;
        }
        QFilter[] filters = new QFilter[authorizedDataRuleQFilter.size() + 1];
        int tempIndex = 0;
        Iterator dataObj = authorizedDataRuleQFilter.iterator();
        while (dataObj.hasNext()) {
            QFilter qFilter;
            filters[tempIndex] = qFilter = (QFilter)dataObj.next();
            ++tempIndex;
        }
        filters[tempIndex] = filter;
        DynamicObjectCollection calPersonIdColl = calPersonHelper.queryOriginalCollection("id", filters);
        if (calPersonIdColl == null || calPersonIdColl.size() == 0) {
            return calPersonIds;
        }
        for (DynamicObject dataObj2 : calPersonIdColl) {
            calPersonIds.add(dataObj2.getLong("id"));
        }
        return calPersonIds;
    }

    public void delMarkInfo(long[] markIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id";
        QFilter filter = new QFilter("id", "in", (Object)markIds);
        Object[] queryColl = helper.query(filed, new QFilter[]{filter}, null);
        helper.delete(queryColl);
    }

    public void saveMarkInfo(long[] markIds, Map<Long, DynamicObject> updateMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,markreason,isapproveshow,createtime";
        QFilter filter = new QFilter("id", "in", (Object)markIds);
        DynamicObject[] queryColl = helper.query(filed, new QFilter[]{filter}, "createtime desc");
        Date newMarkDate = new Date();
        int size = queryColl.length;
        for (int i = 0; i < size; ++i) {
            String markReason;
            String queryReason;
            DynamicObject queryObj = queryColl[i];
            long queryMarkId = queryObj.getLong("id");
            DynamicObject updateObj = updateMap.get(queryMarkId);
            if (updateObj == null || SWCStringUtils.equals((String)(queryReason = queryObj.getString("markreason")), (String)(markReason = updateObj.getString("markreason")))) continue;
            String isApproveShow = updateObj.getString("isapproveshow");
            queryObj.set("markreason", (Object)markReason);
            queryObj.set("isapproveshow", (Object)isApproveShow);
            queryObj.set("createtime", (Object)newMarkDate);
        }
        helper.update(queryColl);
    }

    public Map<Long, List<DynamicObject>> getAllCalPersonMarkInfoByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,markreason,calpersonentry.calpersonid,createtime";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        DynamicObject[] queryColl = helper.query(filed, new QFilter[]{filter}, "createtime desc");
        if (queryColl == null || queryColl.length == 0) {
            return new HashMap<Long, List<DynamicObject>>(16);
        }
        HashMap<Long, List<DynamicObject>> calPersonMarkMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject markObj : queryColl) {
            DynamicObjectCollection calPersonIdColl = markObj.getDynamicObjectCollection("calpersonentry");
            if (calPersonIdColl == null || calPersonIdColl.size() == 0) continue;
            for (DynamicObject calPersonIdObj : calPersonIdColl) {
                long calPersonId = calPersonIdObj.getLong("calpersonid");
                ArrayList<DynamicObject> markList = (ArrayList<DynamicObject>)calPersonMarkMap.get(calPersonId);
                if (markList == null) {
                    markList = new ArrayList<DynamicObject>(10);
                }
                markList.add(markObj);
                calPersonMarkMap.put(calPersonId, markList);
            }
        }
        return calPersonMarkMap;
    }

    public void delCalPersonMarkInfo(long[] markIds, long calPersonId) {
        int i;
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,markreason,calpersonentry.calpersonid,createtime,marknum";
        QFilter filter = new QFilter("id", "in", (Object)markIds);
        filter.and("calpersonentry.calpersonid", "=", (Object)calPersonId);
        DynamicObject[] queryColl = helper.query(filed, new QFilter[]{filter}, null);
        if (queryColl == null || queryColl.length == 0) {
            return;
        }
        ArrayList<DynamicObject> delColl = new ArrayList<DynamicObject>(queryColl.length);
        ArrayList<DynamicObject> updateColl = new ArrayList<DynamicObject>(queryColl.length);
        for (DynamicObject markObj : queryColl) {
            DynamicObjectCollection calPersonIdColl = markObj.getDynamicObjectCollection("calpersonentry");
            if (calPersonIdColl.size() == 1) {
                delColl.add(markObj);
                continue;
            }
            updateColl.add(markObj);
        }
        if (delColl != null && delColl.size() > 0) {
            int size = delColl.size();
            Object[] delArray = new DynamicObject[size];
            for (i = 0; i < size; ++i) {
                delArray[i] = (DynamicObject)delColl.get(i);
            }
            helper.delete(delArray);
        }
        if (updateColl == null || updateColl.size() == 0) {
            return;
        }
        for (DynamicObject markObj : updateColl) {
            DynamicObjectCollection calPersonIdColl = markObj.getDynamicObjectCollection("calpersonentry");
            DynamicObjectCollection updateCalPersonColl = new DynamicObjectCollection();
            for (DynamicObject calPersonObj : calPersonIdColl) {
                long id = calPersonObj.getLong("calpersonid");
                if (id == calPersonId) continue;
                updateCalPersonColl.add((Object)calPersonObj);
            }
            markObj.set("calpersonentry", (Object)updateCalPersonColl);
            int markNum = markObj.getInt("marknum");
            markObj.set("marknum", (Object)(--markNum));
        }
        int size = updateColl.size();
        DynamicObject[] updateArray = new DynamicObject[size];
        for (i = 0; i < size; ++i) {
            updateArray[i] = (DynamicObject)updateColl.get(i);
        }
        helper.update(updateArray);
    }

    public DynamicObject[] getSelectMarkInfoByCalPersonIds(long[] calPersonIds, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,markreason,calpersonentry.calpersonid,createtime,marknum";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("calpersonentry.calpersonid", "in", (Object)calPersonIds);
        DynamicObject[] markInfos = helper.query(filed, new QFilter[]{filter}, null);
        return markInfos;
    }

    public void delCalPersonListMarkInfo(DynamicObject[] delColl) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        helper.delete((Object[])delColl);
    }

    public void updateCalPersonListMarkInfo(DynamicObject[] updateColl) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        helper.update(updateColl);
    }

    public DynamicObject getCalPersonIdsByMarkId(long markId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String filed = "id,calpersonentry.calpersonid";
        QFilter filter = new QFilter("id", "=", (Object)markId);
        DynamicObject markInfo = helper.queryOne(filed, new QFilter[]{filter});
        return markInfo;
    }

    public void delCalPersonAndDelCalPersonMark(Long calTaskId, Set<Long> delCalPersonIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper(SALARY_DETAIL_MARK_TABLE);
        String field = "id,calpersonentry.calpersonid";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("calpersonentry.calpersonid", "in", delCalPersonIdSet);
        DynamicObject[] markColl = helper.query(field, new QFilter[]{filter}, null);
        if (markColl == null || markColl.length == 0) {
            return;
        }
        ArrayList<Long> delCalPersonEntryIdList = new ArrayList<Long>(10);
        for (DynamicObject markObj : markColl) {
            DynamicObjectCollection calPersonEntry = markObj.getDynamicObjectCollection("calpersonentry");
            for (DynamicObject calPersonObj : calPersonEntry) {
                long calPersonId = calPersonObj.getLong("calpersonid");
                if (!delCalPersonIdSet.contains(calPersonId)) continue;
                delCalPersonEntryIdList.add(calPersonObj.getLong("id"));
            }
        }
        if (delCalPersonEntryIdList == null || delCalPersonEntryIdList.size() == 0) {
            return;
        }
        String deleteSqlModel = "DELETE FROM T_HSAS_CALPERSONMARK WHERE FENTRYID IN ({0})";
        int size = delCalPersonEntryIdList.size();
        int partCount = size / 500;
        if (partCount * 500 < size) {
            ++partCount;
        }
        for (int index = 1; index <= partCount; ++index) {
            int start = (index - 1) * 500;
            int end = index * 500;
            end = end > size ? size : end;
            List partTaskIdList = delCalPersonEntryIdList.subList(start, end);
            StringBuilder sb = new StringBuilder();
            Iterator iterator = partTaskIdList.iterator();
            while (iterator.hasNext()) {
                sb.append(String.valueOf(iterator.next()));
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            String deleteSql = MessageFormat.format(deleteSqlModel, sb.toString());
            SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteSql, (Object[])new Object[0]);
        }
    }
}

