/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.salaryfile.SalaryFileDBHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SWCSalaryFileServiceHelper {
    public static final String EMP_POS_INFO_ENT = "EmpPosInfoEnt";
    public static final String EMP_POS_INFO = "EmpPosInfo";
    private static final Log log = LogFactory.getLog(SWCSalaryFileServiceHelper.class);

    public static Long getCurrencyId(String fileId) {
        if (SWCStringUtils.isEmpty((String)fileId)) {
            return 0L;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        String properties = "payrollgroup,currency.id";
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(fileId));
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject salaryFile = serviceHelper.queryOne(properties, filters);
        if (null == salaryFile) {
            return 0L;
        }
        return salaryFile.getLong("payrollgroup.currency.id");
    }

    public static DynamicObject getFileByEmp(Object empObj, Long salaryFileId) {
        if (null == empObj) {
            return null;
        }
        long empId = ((DynamicObject)empObj).getLong("id");
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter empFilter = new QFilter("empposinfo", "=", (Object)empId);
        QFilter salaryfileFilter = new QFilter("salaryfile", "!=", (Object)salaryFileId);
        QFilter satusFilter = new QFilter("salaryfile.status", "!=", (Object)"E");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-2");
        return empHelper.queryOne("salaryfile.number,empposinfo.number", new QFilter[]{empFilter, satusFilter, salaryfileFilter, dataStatusFilter});
    }

    public static List<QFilter> getEmpList(long employeeId, String isPrimary) {
        SWCDataServiceHelper empServiceHelper = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter personFilter = new QFilter("employee", "=", (Object)employeeId);
        QFilter empTypeFilter = null;
        if (SWCStringUtils.isNotEmpty((String)isPrimary)) {
            empTypeFilter = new QFilter("isprimary", "=", (Object)isPrimary);
        }
        DynamicObject[] empObjs = empServiceHelper.query(new QFilter[]{personFilter, empTypeFilter});
        ArrayList<Long> idList = new ArrayList<Long>(empObjs.length);
        for (DynamicObject empObj : empObjs) {
            idList.add(empObj.getLong("id"));
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        return Collections.singletonList(idFilter);
    }

    public static void assembleSalaryFileDataAndOpenFormView(Long pkId, IFormView formView) {
        SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView(pkId, formView, false, "false");
    }

    public static void assembleSalaryFileDataAndOpenFormView(Long pkId, IFormView formView, String isOnlyView) {
        SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView(pkId, formView, false, isOnlyView);
    }

    private static void assembleSalaryFileDataAndOpenFormView(Long pkId, IFormView formView, boolean useParentView, String isOnlyView) {
        log.info("SalaryFileList.billListHyperLinkClick.NUMBER begin..assembleSalaryFileDataAndOpenFormView...5.1...");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)pkId)};
        DynamicObject salaryFileDyobj = helper.queryOne("boid, employee, status, payrollgroup, payrollregion, paystatus, sourcevid, iscurrentversion", qFilters);
        if (null != salaryFileDyobj) {
            log.info("SalaryFileList.billListHyperLinkClick.NUMBER begin..assembleSalaryFileDataAndOpenFormView...5.2...");
            SWCSalaryFileServiceHelper.openSalaryFile(pkId, salaryFileDyobj, formView, useParentView, isOnlyView);
        } else {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"PersonListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private static void openSalaryFile(Long pkId, DynamicObject salaryFileDyobj, IFormView formView, boolean useParentView, String isOnlyView) {
        int index;
        log.info("SalaryFileList.billListHyperLinkClick.NUMBER begin..assembleSalaryFileDataAndOpenFormView...5.3...");
        String isCardExpire = formView.getPageCache().get("isCardExpire");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_addpersonfile");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("salaryfileid", (Object)salaryFileDyobj.getString("boid"));
        String captionName = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848 - %s", (String)"SWCSalaryFileServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        if (salaryFileDyobj.getBoolean("iscurrentversion")) {
            showParameter.setCustomParam("ishispage", (Object)Boolean.FALSE);
            showParameter.setCustomParam("salaryFileVid", (Object)salaryFileDyobj.getLong("sourcevid"));
        } else {
            showParameter.setCustomParam("ishispage", (Object)Boolean.TRUE);
            showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
            showParameter.setCustomParam("salaryFileVid", (Object)salaryFileDyobj.getLong("id"));
            captionName = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5386\u53f2 - %s", (String)"SWCSalaryFileServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        showParameter.setCustomParam("personid", (Object)salaryFileDyobj.getString("employee.id"));
        showParameter.setCustomParam("hsbs_entitytype_id", (Object)"1010");
        showParameter.setCustomParam("currentObjectPKId", (Object)salaryFileDyobj.getString("employee.id"));
        showParameter.setCustomParam("status", (Object)salaryFileDyobj.getString("status"));
        showParameter.setCustomParam("isCardExpire", (Object)isCardExpire);
        showParameter.setCustomParam("isOnlyView", (Object)isOnlyView);
        showParameter.setCustomParam("regionId", (Object)salaryFileDyobj.getLong("payrollregion.id"));
        String pageId = formView.getPageId() + pkId;
        String parentFormId = formView.getFormShowParameter().getParentFormId();
        if (parentFormId != null && (index = parentFormId.indexOf(95)) > 0) {
            pageId = parentFormId.substring(0, index) + pageId;
        }
        showParameter.setPageId(pageId);
        showParameter.setCaption(String.format(Locale.ROOT, captionName, salaryFileDyobj.getString("employee.person.name")));
        log.info("SalaryFileList.billListHyperLinkClick.NUMBER begin..assembleSalaryFileDataAndOpenFormView...5.4...");
        if (useParentView) {
            formView.getParentView().showForm(showParameter);
        } else {
            log.info("SalaryFileList.billListHyperLinkClick.NUMBER begin..assembleSalaryFileDataAndOpenFormView...5.5...");
            formView.showForm(showParameter);
        }
    }

    public static String getCurrencyIdInPayRollGroup(String payRollGroupId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(payRollGroupId));
        DynamicObject payRollGroupDyobj = serviceHelper.queryOne("currency", new QFilter[]{qFilter});
        if (null != payRollGroupDyobj) {
            return payRollGroupDyobj.getString("currency.id");
        }
        return null;
    }

    public static void setCurrencyIntoEntryentity(IFormView view, int entryentitySize) {
        String salaryFileId = (String)view.getFormShowParameter().getCustomParam("salaryfileid");
        Long defaultCurrencyId = SWCSalaryFileServiceHelper.getCurrencyId(salaryFileId);
        view.getModel().setValue("currency", (Object)defaultCurrencyId, entryentitySize - 1);
    }

    public static Map<String, List<Long>> getSalaryFileMultiEntityPkIds(EndOperationTransactionArgs e) {
        List<Long> salaryFileIds = SWCSalaryFileServiceHelper.getSuccessPkIds(e);
        if (!salaryFileIds.isEmpty()) {
            return SalaryFileDBHelper.getInstance().queryRelatedSalaryFileDataBySalaryFileIds(salaryFileIds);
        }
        return new HashMap<String, List<Long>>();
    }

    private static List<Long> getSuccessPkIds(EndOperationTransactionArgs e) {
        DynamicObject[] dyobjs;
        ArrayList<Long> pkIds = new ArrayList<Long>(10);
        for (DynamicObject dyobj : dyobjs = e.getDataEntities()) {
            pkIds.add(dyobj.getLong("id"));
        }
        return pkIds;
    }

    public static QFilter filterSalaryItem(IDataModel dataModel) {
        DynamicObjectCollection rows = null;
        rows = dataModel.getEntryEntity("entryentity");
        List salItemIds = rows.stream().map(xx -> xx.getLong("salaryitem.id")).collect(Collectors.toList());
        return new QFilter("id", "not in", salItemIds);
    }

    public static void refreshSalaryFileEmpAndScope(List<Long> salaryFileIds, boolean isCludeWaitAudit) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("boid", "in", salaryFileIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        ArrayList status = SWCHisBaseConstants.getValidStatus();
        if (isCludeWaitAudit) {
            status.add("-5");
        }
        filter.and("datastatus", "in", (Object)status);
        DynamicObject[] filehis = fileHelper.query("boid, managingscope.id, empposinfo.id", new QFilter[]{filter});
        ArrayList<DynamicObject> manageScopeList = new ArrayList<DynamicObject>(10);
        HashSet<Long> empIds = new HashSet<Long>(16);
        HashSet<Long> scopeIds = new HashSet<Long>(16);
        Long id = null;
        for (DynamicObject fileDy : filehis) {
            id = fileDy.getLong("empposinfo.id");
            if (empIds.contains(id)) continue;
            empIds.add(id);
            DynamicObject orgRel = SWCSalaryFileServiceHelper.getEmpposorgrelObj(fileDy);
            if (fileDy.getLong("managingscope.id") == 0L || scopeIds.contains(id = Long.valueOf(fileDy.getLong("managingscope.id")))) continue;
            scopeIds.add(id);
            DynamicObject manageScope = SWCSalaryFileServiceHelper.getManageScopeObj(fileDy);
            manageScopeList.add(manageScope);
        }
        SWCSalaryFileServiceHelper.saveByOperation("hsas_filemanagingscope", salaryFileIds, manageScopeList);
    }

    private static void saveByOperation(String entityName, List<Long> salaryFileIds, List<DynamicObject> objList) {
        QFilter filter = new QFilter("salaryfile", "in", salaryFileIds);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityName);
        empHelper.deleteByFilter(new QFilter[]{filter});
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
        OperationResult operationResult = opImpl.localInvokeOperation("save", objList.toArray(new DynamicObject[objList.size()]), operateOption);
        log.info("saveByOperation {0} operationResult,errorMsgs = {1}", (Object)entityName, (Object)SWCSalaryFileServiceHelper.getOpErrorMsg(operationResult));
    }

    @NotNull
    private static String getOpErrorMsg(OperationResult operationResult) {
        StringBuilder errorMsgs = new StringBuilder();
        List operateInfos = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo operateInfo : operateInfos) {
            errorMsgs.append(operateInfo.getMessage());
        }
        String msg = operationResult.getMessage();
        if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
            errorMsgs.append(msg);
        }
        return errorMsgs.toString();
    }

    private static DynamicObject getManageScopeObj(DynamicObject dataEntity) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_filemanagingscope");
        DynamicObject manageScope = serviceHelper.generateEmptyDynamicObject();
        manageScope.set("salaryfile", (Object)dataEntity.getLong("boid"));
        manageScope.set("managingscope", (Object)dataEntity.getLong("managingscope.id"));
        return manageScope;
    }

    private static DynamicObject getEmpposorgrelObj(DynamicObject dataEntity) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_empposorgrel");
        DynamicObject empDyobj = serviceHelper.generateEmptyDynamicObject();
        ORM orm = ORM.create();
        Long newId = orm.genLongId("hsas_empposorgrel");
        empDyobj.set("id", (Object)newId);
        empDyobj.set("salaryfile", (Object)dataEntity.getLong("boid"));
        empDyobj.set("empposinfo", (Object)dataEntity.getLong("empposinfo.id"));
        return empDyobj;
    }
}

