/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileBeforeValidateDepEmpDateService;
import kd.sdk.swc.hsas.common.events.salaryfile.SalaryFileBeforeValidateDepEmpDateEvent;
import kd.swc.hsas.common.dto.DateTimeRangeEntity;
import kd.swc.hsas.common.dto.MultiDateTimeRangeEntity;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SalaryFileEmpPosOrgRelHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileEmpPosOrgRelHelper.class);
    private static final String QUERY_FIELD = "id,salaryfile,workrole,ismainworkrole,paystartdate,payenddate,status,seq";
    private static final SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
    private static final SWCDataServiceHelper depEmpOrm = new SWCDataServiceHelper("hsas_depemp");

    public static OperationResult saveEmpPosOrgRel(List<Map<String, Object>> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return null;
        }
        HashSet<Long> salaryFileBoIds = new HashSet<Long>(16);
        for (Map<String, Object> data : datas) {
            salaryFileBoIds.add((Long)data.get("salaryFileId"));
        }
        DynamicObject[] dataObjects = SalaryFileEmpPosOrgRelHelper.getEmpPosOrgRelBySalaryFileBoId(salaryFileBoIds);
        Map<Long, DynamicObject> empPosMap = Arrays.stream(dataObjects).collect(Collectors.toMap(dy -> dy.getLong("salaryfile.id"), dy -> dy, (k1, k2) -> k1));
        SWCDataServiceHelper fileServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter("boid", "in", salaryFileBoIds);
        ArrayList datastatus = SWCHisBaseConstants.getValidStatus();
        datastatus.add("-3");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)datastatus);
        DynamicObject[] salaryFiles = fileServiceHelper.query("id,boid,number,status,datastatus,depemp,firstbsed,bsed,bsled,paystatus,iscurrentversion", new QFilter[]{salaryFileFilter, dataStatusFilter});
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, List<DynamicObject>> salaryFileVerMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject salaryFile : salaryFiles) {
            Long l = salaryFile.getLong("boid");
            if (salaryFile.getBoolean("iscurrentversion")) {
                salaryFileMap.put(l, salaryFile);
            }
            if ("C".equals(salaryFile.getString("status")) && "-3".equals(salaryFile.getString("datastatus"))) continue;
            List files = salaryFileVerMap.getOrDefault(l, new ArrayList(10));
            files.add(salaryFile);
            salaryFileVerMap.put(l, files);
        }
        Map<Long, Map<Long, Map<String, Object>>> querySalaryDataMap = SalaryFileEmpPosOrgRelHelper.getSalaryFileDataMap(salaryFileVerMap);
        HashMap<String, Object> preDataMap = new HashMap<String, Object>(16);
        preDataMap.put("empPosMap", empPosMap);
        preDataMap.put("salaryFileMap", salaryFileMap);
        preDataMap.put("salaryFileVerMap", salaryFileVerMap);
        preDataMap.put("querySalaryDataMap", querySalaryDataMap);
        ArrayList<DynamicObject> empPosDys = new ArrayList<DynamicObject>(10);
        for (Map map : datas) {
            DynamicObject empPosDy = SalaryFileEmpPosOrgRelHelper.saveEmpPosOrgRel(map, preDataMap);
            if (empPosDy == null) continue;
            empPosDys.add(empPosDy);
        }
        if (!CollectionUtils.isEmpty(empPosDys)) {
            OperationResult operationResult = SalaryFileEmpPosOrgRelHelper.invokeSaveOperation(empPosDys.toArray(new DynamicObject[0]));
            return operationResult;
        }
        return null;
    }

    private static DynamicObject saveEmpPosOrgRel(Map<String, Object> data, Map<String, Object> preDataMap) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        Long salaryFileId = (Long)data.get("salaryFileId");
        List workRoles = (List)data.get("workRoles");
        if (CollectionUtils.isEmpty((Collection)workRoles)) {
            return null;
        }
        Map querySalaryDataMap = (Map)((Map)preDataMap.get("querySalaryDataMap")).get(salaryFileId);
        DynamicObject salaryFileObject = (DynamicObject)((Map)preDataMap.get("salaryFileMap")).get(salaryFileId);
        if (salaryFileObject == null) {
            return null;
        }
        Map empPosMap = (Map)preDataMap.get("empPosMap");
        DynamicObject dataObject = (DynamicObject)empPosMap.get(salaryFileId);
        if (dataObject == null) {
            Optional first = empPosMap.values().stream().findFirst();
            dataObject = first.isPresent() ? (DynamicObject)((DynamicObject)first.get()).getDataEntityType().createInstance() : empPosOrgRelOrm.generateEmptyDynamicObject("hsas_empposorgrel");
        }
        dataObject.set("salaryfile", (Object)salaryFileObject);
        DynamicObjectCollection entryEntities = dataObject.getDynamicObjectCollection("entryentity");
        String status = salaryFileObject.getString("status");
        Map<Long, List<DynamicObject>> existWorkRoles = entryEntities.stream().collect(Collectors.groupingBy(item -> item.getLong("workrole.id")));
        for (Map workRole : workRoles) {
            Long workRoleId = (Long)workRole.get("workRoleId");
            DynamicObject workRoleDyObject = (DynamicObject)workRole.get("workRole");
            Date payStartDate = (Date)workRole.get("payStartDate");
            Date payEndDate = (Date)workRole.get("payEndDate");
            String isStopPayEndDate = (String)workRole.get("isStopPayEndDate");
            String payStatus = (String)workRole.get("payStatus");
            String isMainWorkRole = (String)workRole.get("isMainWorkRole");
            List<DynamicObject> existWorkRoleList = existWorkRoles.get(workRoleId);
            if ("0".equalsIgnoreCase(payStatus)) {
                if ("1".equalsIgnoreCase(isStopPayEndDate) && "1".equals(isMainWorkRole) && !CollectionUtils.isEmpty(existWorkRoleList)) {
                    SalaryFileEmpPosOrgRelHelper.upatePayEndDataWhenStopPay(entryEntities, workRole, existWorkRoleList);
                }
                boolean isContain = false;
                for (DynamicObject entryEntity : entryEntities) {
                    long tempWorkRoleId = entryEntity.getLong("workrole.id");
                    if (tempWorkRoleId != workRoleId) continue;
                    entryEntity.set("ismainworkrole", (Object)isMainWorkRole);
                    isContain = true;
                }
                if (isContain) continue;
                entryEntities.add((Object)SalaryFileEmpPosOrgRelHelper.newObjectEntryData(dataObject, workRole));
                continue;
            }
            if (CollectionUtils.isEmpty(existWorkRoleList)) {
                entryEntities.add((Object)SalaryFileEmpPosOrgRelHelper.newObjectEntryData(dataObject, workRole));
                continue;
            }
            entryEntities.removeAll(existWorkRoleList);
            if ("1".equals(isMainWorkRole)) {
                if ("A".equalsIgnoreCase(status)) {
                    entryEntities.add((Object)SalaryFileEmpPosOrgRelHelper.newObjectEntryData(dataObject, workRole));
                }
                if (!"C".equalsIgnoreCase(status)) continue;
                entryEntities.addAll(SalaryFileEmpPosOrgRelHelper.addEntryDateRange(dataObject, workRole, existWorkRoleList));
                continue;
            }
            entryEntities.addAll(SalaryFileEmpPosOrgRelHelper.addEntryDateRange(dataObject, workRole, existWorkRoleList));
        }
        SalaryFileEmpPosOrgRelHelper.clearDepemp(salaryFileId, entryEntities, status, preDataMap);
        SalaryFileEmpPosOrgRelHelper.refreshIndex(entryEntities);
        return dataObject;
    }

    private static void upatePayEndDataWhenStopPay(DynamicObjectCollection entryEntities, Map<String, Object> workRole, List<DynamicObject> existWorkRoleList) {
        Date salaryFileBsed = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)workRole.get("salaryFileBsed"));
        List payEndDateList = existWorkRoleList.stream().sorted(Comparator.comparing(dynamicObject -> ((DynamicObject)dynamicObject).getDate("payenddate")).reversed()).collect(Collectors.toList());
        int size = payEndDateList.size();
        Date addDayResult = DateUtils.addDays((Date)salaryFileBsed, (int)-1);
        for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject2 = (DynamicObject)payEndDateList.get(i);
            Date endDate = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)dynamicObject2.get("payenddate"));
            Date startDate = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)dynamicObject2.get("paystartdate"));
            if (salaryFileBsed.after(startDate) && !salaryFileBsed.after(endDate)) {
                dynamicObject2.set("payenddate", (Object)addDayResult);
            }
            if (!salaryFileBsed.after(startDate)) {
                if (i == size - 1) {
                    dynamicObject2.set("payenddate", (Object)salaryFileBsed);
                    dynamicObject2.set("paystartdate", (Object)salaryFileBsed);
                } else {
                    entryEntities.remove((Object)dynamicObject2);
                }
            }
            dynamicObject2.set("ismainworkrole", workRole.get("isMainWorkRole"));
        }
    }

    public static Date getDateDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(KDDateUtils.getSysTimeZone());
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static void refreshIndex(DynamicObjectCollection entryEntities) {
        for (int i = 0; i < entryEntities.size(); ++i) {
            ((DynamicObject)entryEntities.get(i)).set("seq", (Object)i);
        }
    }

    private static List<DynamicObject> addEntryDateRange(DynamicObject dataObject, Map<String, Object> workRole, List<DynamicObject> existWorkRoleList) {
        Long workRoleId = (Long)workRole.get("workRoleId");
        DynamicObject workRoleDyObject = (DynamicObject)workRole.get("workRole");
        Date payStartDate = (Date)workRole.get("payStartDate");
        Date payEndDate = (Date)workRole.get("payEndDate");
        String isMainWorkRole = (String)workRole.get("isMainWorkRole");
        MultiDateTimeRangeEntity dateRange = new MultiDateTimeRangeEntity();
        for (DynamicObject dynamicObject : existWorkRoleList) {
            dateRange.add(SalaryFileEmpPosOrgRelHelper.getDateDay(dynamicObject.getDate("paystartdate")), SalaryFileEmpPosOrgRelHelper.getDateDay(dynamicObject.getDate("payenddate")));
        }
        MultiDateTimeRangeEntity resultRange = dateRange.plus(new MultiDateTimeRangeEntity().add(payStartDate, payEndDate), true);
        List rangeEntities = resultRange.getRangeEntities();
        int size = existWorkRoleList.size();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < rangeEntities.size(); ++i) {
            DynamicObject tempEntry;
            DateTimeRangeEntity dateTimeRangeEntity = (DateTimeRangeEntity)rangeEntities.get(i);
            if (i < size) {
                tempEntry = existWorkRoleList.get(i);
                tempEntry.set("paystartdate", (Object)dateTimeRangeEntity.getStartDate());
                tempEntry.set("payenddate", (Object)dateTimeRangeEntity.getEndDate());
                tempEntry.set("ismainworkrole", (Object)isMainWorkRole);
            } else {
                HashMap<String, Object> workRoleMap = new HashMap<String, Object>(16);
                workRoleMap.put("workRoleId", workRoleId);
                workRoleMap.put("payStartDate", dateTimeRangeEntity.getStartDate());
                workRoleMap.put("payEndDate", dateTimeRangeEntity.getEndDate());
                workRoleMap.put("isMainWorkRole", isMainWorkRole);
                workRoleMap.put("workRole", workRoleDyObject);
                tempEntry = SalaryFileEmpPosOrgRelHelper.newObjectEntryData(dataObject, workRoleMap);
            }
            result.add(tempEntry);
        }
        return result;
    }

    private static DynamicObject newObjectEntryData(DynamicObject dataObject, Map<String, Object> workRole) {
        Long workRoleId = (Long)workRole.get("workRoleId");
        Date payStartDate = (Date)workRole.get("payStartDate");
        Date payEndDate = (Date)workRole.get("payEndDate");
        String isMainWorkRole = (String)workRole.get("isMainWorkRole");
        DynamicObject newEntry = empPosOrgRelOrm.generateEmptyEntryDynamicObject(dataObject, "entryentity");
        newEntry.set("workrole", workRole.get("workRole"));
        newEntry.set("paystartdate", (Object)payStartDate);
        newEntry.set("payenddate", (Object)payEndDate);
        newEntry.set("ismainworkrole", (Object)isMainWorkRole);
        return newEntry;
    }

    private static void clearDepemp(Long salaryFileId, DynamicObjectCollection dynamicObjects, String status, Map<String, Object> preDataMap) {
        List salaryFileHis = (List)((Map)preDataMap.get("salaryFileVerMap")).get(salaryFileId);
        if (CollectionUtils.isEmpty((Collection)salaryFileHis)) {
            return;
        }
        Set depempVIds = salaryFileHis.stream().map(his -> his.getLong("depemp.id")).collect(Collectors.toSet());
        Iterator it = dynamicObjects.iterator();
        while (it.hasNext()) {
            DynamicObject entry = (DynamicObject)it.next();
            if (!"1".equals(entry.getString("ismainworkrole")) || depempVIds.contains(entry.getLong("workrole.id"))) continue;
            it.remove();
        }
    }

    private static Map<Long, Map<Long, Map<String, Object>>> getSalaryFileDataMap(Map<Long, List<DynamicObject>> salaryFileVerMap) {
        HashMap<Long, Map<Long, Map<String, Object>>> resultAll = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : salaryFileVerMap.entrySet()) {
            Map result = null;
            for (DynamicObject querySalaryFile : entry.getValue()) {
                long fileId = querySalaryFile.getLong("boid");
                long depEmpId = querySalaryFile.getLong("depemp.id");
                if (depEmpId == 0L || !"1".equals(querySalaryFile.getString("paystatus"))) continue;
                result = resultAll.getOrDefault(fileId, new HashMap(16));
                Map orDefault = result.getOrDefault(depEmpId, new HashMap(2));
                Date bsed = SalaryFileEmpPosOrgRelHelper.getDateDay(querySalaryFile.getDate("bsed"));
                Date lastBsed = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)orDefault.get("bsed"));
                if (bsed != null && (lastBsed == null || bsed.before(lastBsed))) {
                    orDefault.put("bsed", bsed);
                }
                Date bsled = querySalaryFile.getDate("bsled");
                Date lastBsled = (Date)orDefault.get("bsled");
                if (bsled != null && (lastBsled == null || bsled.after(lastBsled))) {
                    orDefault.put("bsled", bsled);
                }
                result.put(depEmpId, orDefault);
                resultAll.put(fileId, result);
            }
        }
        return resultAll;
    }

    public static List<DynamicObject> getEmpPosOrgRelByDepEmpId(Set<Long> depEmpIds) {
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter enableQFilter = new QFilter("salaryfile.enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("salaryfile.status", "!=", (Object)"E");
        QFilter depEmpQFilter = new QFilter("entryentity.workrole.id", "in", depEmpIds);
        DynamicObject[] result = empPosOrgRelOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_empposorgrel"), new QFilter[]{enableQFilter, statusQFilter, depEmpQFilter}, "entryentity.paystartdate asc");
        return Arrays.asList(result);
    }

    public static Date getMaxDate() {
        try {
            Date endDate = SWCDateTimeUtils.parseDate((String)"2999-12-31");
            return endDate;
        }
        catch (ParseException ex) {
            LOGGER.info("parse date error.", (Object)ex);
            return null;
        }
    }

    public static void updateDepEmpTimeRemainedFlag(Set<Long> depEmpIds) {
        SWCDataServiceHelper empServiceHelper = new SWCDataServiceHelper("hsas_depemp");
        QFilter empIdQFilter = new QFilter("id", "in", depEmpIds);
        DynamicObject[] employeeDys = empServiceHelper.query("person.id", new QFilter[]{empIdQFilter});
        Set personIds = Arrays.stream(employeeDys).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
        QFilter personIdQFilter = new QFilter("person.id", "in", personIds);
        QFilter currentQFilter = BaseDataHisHelper.getHisCurrFilter();
        DynamicObject[] employeeDysAll = empServiceHelper.query("id", new QFilter[]{currentQFilter, personIdQFilter});
        Set<Long> allDepEmpIds = Arrays.stream(employeeDysAll).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.updateDepEmpTimeRemainedFlagCore(allDepEmpIds);
    }

    private static void updateDepEmpTimeRemainedFlagCore(Set<Long> depEmpIds) {
        if (CollectionUtils.isEmpty(depEmpIds)) {
            return;
        }
        List<DynamicObject> empPosOrgRelByDepEmpId = SalaryFileEmpPosOrgRelHelper.getEmpPosOrgRelByDepEmpId(depEmpIds);
        Map<Long, Map<String, Date>> startEndDataMap = SalaryFileEmpPosOrgRelHelper.getStartEndDate(empPosOrgRelByDepEmpId, depEmpIds);
        Map<Long, List<Map<String, Object>>> workRoleDateMap = SalaryFileEmpPosOrgRelHelper.getEmpDepDateMap(empPosOrgRelByDepEmpId, depEmpIds);
        HashMap<Long, Boolean> updateDataMap = new HashMap<Long, Boolean>(depEmpIds.size());
        for (Long depEmpId : depEmpIds) {
            updateDataMap.put(depEmpId, Boolean.TRUE);
        }
        if (CollectionUtils.isEmpty(workRoleDateMap)) {
            for (Long depEmpId : depEmpIds) {
                updateDataMap.put(depEmpId, Boolean.TRUE);
            }
            SalaryFileEmpPosOrgRelHelper.updateTimeRemained(updateDataMap);
            return;
        }
        workRoleDateMap.forEach((workRoleId, dateData) -> {
            MultiDateTimeRangeEntity dateTimeRange;
            if (CollectionUtils.isEmpty((Collection)dateData)) {
                updateDataMap.put((Long)workRoleId, Boolean.TRUE);
                return;
            }
            Map startEndDateMap = (Map)startEndDataMap.get(workRoleId);
            if (CollectionUtils.isEmpty((Map)startEndDateMap)) {
                updateDataMap.put((Long)workRoleId, Boolean.TRUE);
                return;
            }
            Date startDate = (Date)startEndDateMap.get("startDate");
            Date endDate = (Date)startEndDateMap.get("endDate");
            if (endDate == null) {
                endDate = SalaryFileEmpPosOrgRelHelper.getMaxDate();
            }
            updateDataMap.put((Long)workRoleId, !(dateTimeRange = SalaryFileEmpPosOrgRelHelper.mergeDate(dateData)).isCovered(new DateTimeRangeEntity(startDate, endDate)));
        });
        if (CollectionUtils.isEmpty(updateDataMap)) {
            return;
        }
        SalaryFileEmpPosOrgRelHelper.updateTimeRemained(updateDataMap);
    }

    private static MultiDateTimeRangeEntity mergeDate(List<Map<String, Object>> dateMap) {
        MultiDateTimeRangeEntity result = new MultiDateTimeRangeEntity();
        if (CollectionUtils.isEmpty(dateMap)) {
            return result;
        }
        for (Map<String, Object> objectMap : dateMap) {
            result.add((Date)objectMap.get("payStartDate"), (Date)objectMap.get("payEndDate"));
        }
        return result.mergeAdjacent();
    }

    private static void updateTimeRemained(Map<Long, Boolean> updateDataMap) {
        SWCDataServiceHelper depEmpOrm = new SWCDataServiceHelper("hsas_depemp");
        DynamicObject[] query = depEmpOrm.query("id,istimeremained", new QFilter[]{new QFilter("id", "in", updateDataMap.keySet())});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            long aLong = dynamicObject.getLong("id");
            dynamicObject.set("istimeremained", (Object)updateDataMap.get(aLong));
        }
        depEmpOrm.save(query);
    }

    public static void updateEmployeeRemainedFlag(Set<Long> employeeIds) {
        SWCDataServiceHelper employeeServiceHelper = new SWCDataServiceHelper("hsas_employee");
        QFilter employeeIdQFilter = new QFilter("id", "in", employeeIds);
        DynamicObject[] employeeDys = employeeServiceHelper.query("person.id", new QFilter[]{employeeIdQFilter});
        Set personIds = Arrays.stream(employeeDys).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
        QFilter personIdQFilter = new QFilter("person.id", "in", personIds);
        QFilter currentQFilter = BaseDataHisHelper.getHisCurrFilter();
        DynamicObject[] employeeDysAll = employeeServiceHelper.query("id", new QFilter[]{currentQFilter, personIdQFilter});
        Set<Long> allEmployeeIds = Arrays.stream(employeeDysAll).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        SalaryFileEmpPosOrgRelHelper.updateEmployeeRemainedFlagCore(allEmployeeIds);
    }

    private static void updateEmployeeRemainedFlagCore(Set<Long> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds)) {
            return;
        }
        List<DynamicObject> depEmps = SalaryFileEmpPosOrgRelHelper.getDepEmpByEmployeeId(employeeIds);
        HashMap<Long, Boolean> updateDataMap = new HashMap<Long, Boolean>(employeeIds.size());
        if (CollectionUtils.isEmpty(depEmps)) {
            for (Long employeeId : employeeIds) {
                updateDataMap.put(employeeId, Boolean.TRUE);
            }
            SalaryFileEmpPosOrgRelHelper.updateDepRemained(updateDataMap);
            return;
        }
        for (DynamicObject depEmp : depEmps) {
            long employeeId = depEmp.getLong("employee.id");
            Boolean timeRemained = depEmp.getBoolean("istimeremained");
            updateDataMap.put(employeeId, updateDataMap.getOrDefault(employeeId, Boolean.FALSE) != false || timeRemained != false);
        }
        SalaryFileEmpPosOrgRelHelper.updateDepRemained(updateDataMap);
    }

    private static void updateDepRemained(Map<Long, Boolean> updateDataMap) {
        SWCDataServiceHelper depEmpOrm = new SWCDataServiceHelper("hsas_employee");
        DynamicObject[] query = depEmpOrm.query("id,isdepremained", new QFilter[]{new QFilter("id", "in", updateDataMap.keySet())});
        if (query == null || query.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            long aLong = dynamicObject.getLong("id");
            dynamicObject.set("isdepremained", (Object)updateDataMap.get(aLong));
        }
        depEmpOrm.save(query);
    }

    public static void deleteEmpPosOrgRelBySalaryFileIds(Set<Long> deleteSalaryFileIds) {
        SalaryFileEmpPosOrgRelHelper.updateEmployeeAndDepEmpFlags(deleteSalaryFileIds);
        SalaryFileEmpPosOrgRelHelper.deleteEmpPosOrgRelBySalaryFileBoId(deleteSalaryFileIds);
    }

    public static void abandonEmpPosOrgRelBySalaryFileIds(Set<Long> deleteSalaryFileIds) {
        SalaryFileEmpPosOrgRelHelper.updateEmployeeAndDepEmpFlags(deleteSalaryFileIds);
    }

    public static Map<Long, List<Map<String, Object>>> getEmpDepDateMap(List<DynamicObject> empPosOrgRelByDepEmps, Set<Long> depEmpIds) {
        HashMap<Long, List<Map<String, Object>>> result = new HashMap<Long, List<Map<String, Object>>>(16);
        for (DynamicObject dataEntity : empPosOrgRelByDepEmps) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject entry : dynamicObjectCollection) {
                long workRoleId = entry.getLong("workrole.id");
                if (workRoleId == 0L || !depEmpIds.contains(workRoleId)) continue;
                String workRoleNumber = entry.getString("workrole.number");
                Date payStartDate = entry.getDate("paystartdate");
                Date payEndDate = entry.getDate("payenddate");
                List orDefault = result.getOrDefault(workRoleId, new ArrayList(10));
                result.put(workRoleId, orDefault);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("salaryFileId", dataEntity.getLong("salaryfile.id"));
                dataMap.put("salaryFileNumber", dataEntity.getString("salaryfile.number"));
                dataMap.put("workRoleId", workRoleId);
                dataMap.put("workRoleNumber", workRoleNumber);
                dataMap.put("payStartDate", payStartDate);
                dataMap.put("payEndDate", payEndDate);
                orDefault.add(dataMap);
            }
        }
        return result;
    }

    private static OperationResult invokeSaveOperation(DynamicObject[] saveDatas) {
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("ishasright", "true");
        opOption.setVariableValue("strictvalidation", "true");
        opOption.setVariableValue("skipCheckDataPermission", "true");
        opOption.setVariableValue("skipCheckSpecialDataPermission", "true");
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult tempOpResult = operationService.localInvokeOperation("save", saveDatas, opOption);
        return tempOpResult;
    }

    private static void updateEmployeeAndDepEmpFlags(Set<Long> deleteSalaryFileIds) {
        HashSet<Long> depEmpIds = new HashSet<Long>(16);
        HashSet<Long> employeeIds = new HashSet<Long>(16);
        SalaryFileEmpPosOrgRelHelper.getEmployeeAndWorkRoleIdsBySalaryFileBoId(deleteSalaryFileIds, employeeIds, depEmpIds);
        SalaryFileEmpPosOrgRelHelper.updateDepEmpTimeRemainedFlag(depEmpIds);
        SalaryFileEmpPosOrgRelHelper.updateEmployeeRemainedFlag(employeeIds);
    }

    private static void deleteEmpPosOrgRelBySalaryFileBoId(Set<Long> salaryFileBoId) {
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        empPosOrgRelOrm.deleteByFilter(new QFilter[]{new QFilter("salaryfile.id", "in", salaryFileBoId)});
    }

    private static DynamicObject[] getEmpPosOrgRelBySalaryFileBoId(Set<Long> salaryFileBoIds) {
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        return empPosOrgRelOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_empposorgrel"), new QFilter[]{new QFilter("salaryfile.id", "in", salaryFileBoIds)});
    }

    private static void getEmployeeAndWorkRoleIdsBySalaryFileBoId(Set<Long> salaryFileBoIds, Set<Long> employeeIds, Set<Long> depEmpIds) {
        DynamicObject[] empPosOrgRels = SalaryFileEmpPosOrgRelHelper.getEmpPosOrgRelBySalaryFileBoId(salaryFileBoIds);
        if (empPosOrgRels == null || empPosOrgRels.length == 0) {
            return;
        }
        for (DynamicObject empPosOrgRel : empPosOrgRels) {
            DynamicObjectCollection dynamicObjectCollection = empPosOrgRel.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                depEmpIds.add(dynamicObject.getLong("workrole.id"));
                employeeIds.add(dynamicObject.getLong("workrole.employee.id"));
            }
        }
    }

    private static Map<Long, Map<String, Date>> getStartEndDate(List<DynamicObject> empPosOrgRelByDepEmpId, Set<Long> depEmpIds) {
        HashMap<Long, Map<String, Date>> result = new HashMap<Long, Map<String, Date>>(16);
        for (DynamicObject dataEntity : empPosOrgRelByDepEmpId) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) continue;
            for (DynamicObject entry : dynamicObjectCollection) {
                long workRoleId = entry.getLong("workrole.id");
                if (workRoleId == 0L || !depEmpIds.contains(workRoleId)) continue;
                Map orDefault = result.getOrDefault(workRoleId, new HashMap(16));
                orDefault.put("startDate", entry.getDate("workrole.startdate"));
                orDefault.put("endDate", entry.getDate("workrole.enddate"));
                result.put(workRoleId, orDefault);
            }
        }
        return result;
    }

    private static List<DynamicObject> getDepEmpByEmployeeId(Set<Long> employeeIds) {
        SWCDataServiceHelper depemp = new SWCDataServiceHelper("hsas_depemp");
        QFilter currentQFilter = BaseDataHisHelper.getHisCurrFilter();
        QFilter employeeIdQFilter = new QFilter("employee.id", "in", employeeIds);
        DynamicObject[] result = depemp.query("id,employee,istimeremained", new QFilter[]{currentQFilter, employeeIdQFilter});
        return Arrays.asList(result);
    }

    public static DynamicObject[] getEmpPosOrgRelByEmployeeId(Set<Long> salaryFileBoIds) {
        if (CollectionUtils.isEmpty(salaryFileBoIds)) {
            return null;
        }
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter salaryFileIdFilter = new QFilter("salaryfile.id", "in", salaryFileBoIds);
        DynamicObject[] query = empPosOrgRelOrm.query("id,salaryfile,workroel,workrole.startdate,workrole.enddate,paystartdate,payenddate,ismainworkrole", new QFilter[]{salaryFileIdFilter});
        return query;
    }

    public static Map<Long, Set<Long>> getMainWorkRoleBySalaryFileIds(List<Long> salaryFileBoIds) {
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter salaryFileFilter = new QFilter("boid", "in", salaryFileBoIds);
        ArrayList datastatus = SWCHisBaseConstants.getValidStatus();
        datastatus.add("-3");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)datastatus);
        DynamicObject[] query = salaryFileOrm.query("id,depemp,boid", new QFilter[]{salaryFileFilter, dataStatusFilter});
        if (query == null || query.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject dynamicObject : query) {
            long boId = dynamicObject.getLong("boid");
            Set idSet = result.computeIfAbsent(boId, item -> new HashSet(16));
            idSet.add(dynamicObject.getLong("depemp.id"));
        }
        return result;
    }

    public static boolean isValidateDepEmpDateForFronted() {
        SalaryFileBeforeValidateDepEmpDateEvent event = new SalaryFileBeforeValidateDepEmpDateEvent();
        HRPluginProxy proxy = HRPlugInProxyFactory.create(ev -> ev.setValidate(Boolean.TRUE), ISalaryFileBeforeValidateDepEmpDateService.class, (String)"kd.sdk.swc.hsas.business.extpoint.salaryfile.ISalaryFileBeforeValidateDepEmpDateService#isValidate", null);
        proxy.callReplaceIfPresent(ext -> {
            ext.isValidate(event);
            return null;
        });
        return event.getValidate();
    }
}

