/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SalaryFileHelper {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileHelper.class);

    public static void refreshFileName(Set<Long> personIds) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter nameNotEqualFilter = QFilter.of((String)"name != person.name", (Object[])new Object[0]);
        if (personIds != null && personIds.size() >= 1) {
            nameNotEqualFilter.and("person.id", "in", personIds);
        }
        LOGGER.info("SalaryFileHelper.refreshFileName...filter= {}", (Object)nameNotEqualFilter.toString());
        Object[] fileDys = fileHelper.query("name, person.name", new QFilter[]{nameNotEqualFilter});
        LOGGER.info("SalaryFileHelper.refreshFileName...fileDys.length= {}", (Object)fileDys.length);
        if (SWCArrayUtils.isEmpty((Object[])fileDys)) {
            return;
        }
        for (Object fileDy : fileDys) {
            fileDy.set("name", fileDy.get("person.name"));
        }
        fileHelper.update((DynamicObject[])fileDys);
    }

    public static void refreshAdminorgVid(Set<Long> personIds) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("person.id", "in", personIds);
        LOGGER.info("SalaryFileHelper.refreshAdminorgVid...filter= {}", (Object)filter.toString());
        Object[] fileDys = fileHelper.query("adminorg.id, adminorgvid.id, empposinfo.adminorg.id, empposinfo.adminorgvid.id", new QFilter[]{filter});
        LOGGER.info("SalaryFileHelper.refreshAdminorgVid...fileDys.length= {}", (Object)fileDys.length);
        if (SWCArrayUtils.isEmpty((Object[])fileDys)) {
            return;
        }
        ArrayList<Object> waitSave = new ArrayList<Object>(10);
        for (Object fileDy : fileDys) {
            Long empAdminOrgVId;
            Long adminorgVId = fileDy.getLong("adminorgvid.id");
            if (adminorgVId.equals(empAdminOrgVId = Long.valueOf(fileDy.getLong("empposinfo.adminorgvid.id")))) continue;
            fileDy.set("adminorgvid", (Object)fileDy.getLong("empposinfo.adminorgvid.id"));
            waitSave.add(fileDy);
        }
        fileHelper.update(waitSave.toArray(new DynamicObject[0]));
    }

    public static void setEmpposinfo(DynamicObject[] dataEntities) {
        ArrayList<Long> depEmpIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long id = dataEntity.getLong("depemp.id");
            if (id == null || id == 0L) continue;
            depEmpIds.add(id);
        }
        SWCDataServiceHelper empPosOrgRelHr = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter depEmpIdFilter = new QFilter("depemp.id", "in", depEmpIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)depEmpIdFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] empPosOrgs = empPosOrgRelHr.query("depemp.id, cmpemp.id, startdate, adminorg.id, adminorgvid.id", new QFilter[]{depEmpIdFilter, dataStatusFilter});
        if (empPosOrgs != null && empPosOrgs.length > 0) {
            Map<Long, DynamicObject> empPosOrgMap = Arrays.stream(empPosOrgs).collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy, (k1, k2) -> k1));
            for (DynamicObject dataEntity : dataEntities) {
                Long depempId = dataEntity.getLong("depemp.id");
                dataEntity.set("empposinfo", (Object)empPosOrgMap.get(depempId));
            }
        }
    }

    public static void setAdminorgVid(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("adminorgvid", dataEntity.get("empposinfo.adminorgvid"));
        }
    }

    public static void setManagingScope(DynamicObject[] dataEntities) {
        ArrayList<Long> empIds = new ArrayList<Long>(10);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dynamicObject = dataEntities[i];
            long tempId = dynamicObject.getLong("depemp.cmpemp.id");
            if (tempId <= 0L) continue;
            empIds.add(tempId);
        }
        SWCDataServiceHelper scopeServiceHelper = new SWCDataServiceHelper("hsas_managingscope");
        QFilter qFilter = new QFilter("cmpemp.id", "in", empIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObject[] scopeDyobj = scopeServiceHelper.query("id, cmpemp.id", new QFilter[]{qFilter});
        if (scopeDyobj == null || scopeDyobj.length == 0) {
            return;
        }
        Map<Long, DynamicObject> map = Arrays.stream(scopeDyobj).collect(Collectors.toMap(obj -> obj.getLong("cmpemp.id"), value -> value, (k1, k2) -> k1));
        for (int j = 0; j < dataEntities.length; ++j) {
            DynamicObject dynamicObject = dataEntities[j];
            DynamicObject obj2 = map.get(dynamicObject.getLong("depemp.cmpemp.id"));
            if (null == obj2) continue;
            DynamicObject newMana = scopeServiceHelper.generateEmptyDynamicObject();
            newMana.set("id", (Object)obj2.getLong("id"));
            dynamicObject.set("managingscope", (Object)newMana);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshFileLaborrelrecord() {
        SWCDataServiceHelper depServiceHelper = new SWCDataServiceHelper("hsas_depemp");
        DBRoute dbRoute = new DBRoute("swc");
        String QUERY_SQL = "SELECT TOP 10000 FID,FDEPEMPID FROM T_HSAS_SALARYFILE F WHERE NOT EXISTS(SELECT 1 FROM T_HSAS_SALARYFILE_B B WHERE B.FID = F.FID) ";
        String INSERT_SQL = "INSERT INTO T_HSAS_SALARYFILE_B(FID, FCHANGEREASONID, FLABORRELRECORDID) VALUES(?, ?, ?) ";
        DataSet dateSet = SWCDbUtil.queryDataSet((String)"refreshFileLaborrelrecord", (DBRoute)dbRoute, (String)QUERY_SQL, (Object[])new Object[0]);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(10000);
        ArrayList insertList = Lists.newArrayListWithExpectedSize((int)10000);
        while (!dateSet.isEmpty()) {
            try (TXHandle txHandle = TX.requiresNew();){
                while (dateSet.hasNext()) {
                    Row next = dateSet.next();
                    idMap.put(next.getLong("fid"), next.getLong("fdepempid"));
                }
                QFilter qFilter = new QFilter("id", "in", idMap.values());
                DynamicObject[] depDys = depServiceHelper.query("id, laborrelrecord.id", new QFilter[]{qFilter});
                Map<Long, Long> labMap = Arrays.stream(depDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("laborrelrecord.id"), (k1, k2) -> k1));
                for (Map.Entry idRls : idMap.entrySet()) {
                    Long labId = labMap.get(idRls.getValue());
                    if (labId == null) {
                        labId = 0L;
                    }
                    insertList.add(new Object[]{idRls.getKey(), 0, labId});
                }
                SWCDbUtil.executeBatch((DBRoute)dbRoute, (String)INSERT_SQL, (List)insertList);
                txHandle.commit();
            }
            idMap.clear();
            insertList.clear();
            dateSet.close();
            dateSet = SWCDbUtil.queryDataSet((String)"refreshFileLaborrelrecord", (DBRoute)dbRoute, (String)QUERY_SQL, (Object[])new Object[0]);
        }
        dateSet.close();
    }

    public static Map<Long, Set<Long>> getUseableSalaryCalsList(Set<Long> orgSet, Set<Long> styleSet) {
        if (CollectionUtils.isEmpty(orgSet) || CollectionUtils.isEmpty(styleSet)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (Long orgId : orgSet) {
            DynamicObjectCollection tempDataList = BaseDataServiceHelper.queryBaseData((String)"hsas_salarycalcstyle", (Long)orgId, (QFilter)new QFilter("id", "in", styleSet), (String)"id");
            if (CollectionUtils.isEmpty((Collection)tempDataList)) continue;
            for (DynamicObject dynamicObject : tempDataList) {
                long tempId = dynamicObject.getLong("id");
                Set dataSet = result.computeIfAbsent(tempId, item -> new HashSet(16));
                dataSet.add(orgId);
            }
        }
        return result;
    }
}

