/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryfile.ImportRowEntity;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataOperate;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileImportDataConvert2DyObj {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileImportDataConvert2DyObj.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String SALARYFILE = "salaryfile";
    private static final String EMPLOYEE = "employee";
    private static final String PERBANKCARD = "perbankcard";
    private static final String BASE_DATA_SELECT_PROPS = "id,name,number,status,enable";
    private static final String BASE_DATA_SELECT_MIN_PROPS = "id,name,number,status,enable";
    private static final String HSAS_SALARYFILE_BASE_DATA_SELECT_PROPS = "id,number,bsed,bsled,enable,status,org.id,adminorg.id,payrollgroup.id,person.id,empgroup.id,employee.id,payrollregion.id";
    private static final String KEY_HRPI_EMLPOYEE = "hrpi_employee";
    private static final String KEY_HRPI_PERSON = "hrpi_person";

    public static void assembleImportData(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger) {
        LOGGER.info("SalaryFileImportDataConvert2DyObj assembleImportData begin 1-1");
        LinkedHashMap<String, Map<String, List<String>>> baseDataValMap = new LinkedHashMap<String, Map<String, List<String>>>();
        for (ImportRowEntity rowInfo : rowInfos) {
            SalaryFileImportDataConvert2DyObj.assemblyDynamicObject(mainEntityType, rowInfo, baseDataValMap, logger);
        }
        LOGGER.info("SalaryFileImportDataConvert2DyObj getBasedataRel begin 1-2");
        Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = SalaryFileImportDataConvert2DyObj.getBasedataRel(baseDataValMap);
        LOGGER.info("SalaryFileImportDataConvert2DyObj fillBasedata2DynamicObject begin 1-3");
        SalaryFileImportDataConvert2DyObj.fillBasedata2DynamicObject(mainEntityType, rowInfos, logger, basedataValRels);
        LOGGER.info("SalaryFileImportDataConvert2DyObj fillBasedata2DynamicObject end 1-4");
    }

    private static void fillBasedata2DynamicObject(MainEntityType mainEntityType, List<ImportRowEntity> rowInfos, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        String entityId = mainEntityType.getName();
        for (ImportRowEntity rowInfo : rowInfos) {
            int rowIndex = rowInfo.getRowIndex();
            JSONObject importJsonData = rowInfo.getData();
            DynamicObject entityDyObj = rowInfo.getEntityDyobj(entityId);
            SalaryFileImportDataConvert2DyObj.prepareFillBasedata(importJsonData, entityDyObj, rowIndex, logger, basedataValRels);
            rowInfo.putEntityDyobj(entityId, entityDyObj);
        }
    }

    private static void prepareFillBasedata(JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels) {
        DynamicObjectType dyObjType = entityDyObj.getDynamicObjectType();
        for (String fieldKey : entityJson.keySet()) {
            DynamicProperty basedataDP = dyObjType.getProperty(fieldKey);
            if (basedataDP instanceof BasedataProp) {
                SalaryFileImportDataConvert2DyObj.fillBasedataToEntity(fieldKey, entityJson, null, entityDyObj, rowIndex, logger, basedataValRels, (BasedataProp)basedataDP, 0);
                continue;
            }
            if (basedataDP instanceof MulBasedataProp) {
                SalaryFileImportDataConvert2DyObj.fillMulBasedataToEntity(fieldKey, entityJson, entityDyObj, rowIndex, logger, basedataValRels, (MulBasedataProp)basedataDP, 0);
                continue;
            }
            if (!(basedataDP instanceof EntryProp)) continue;
            JSONArray entryJsonArr = entityJson.getJSONArray(fieldKey);
            DynamicObjectCollection entryEntityColl = entityDyObj.getDynamicObjectCollection(fieldKey);
            int size = entryJsonArr.size();
            for (int i = 0; i < size; ++i) {
                JSONObject entryEntityJson = entryJsonArr.getJSONObject(i);
                for (String entryFieldKey : entryEntityJson.keySet()) {
                    SalaryFileImportDataConvert2DyObj.fillBasedataToEntryEntity(entryFieldKey, entityDyObj, entryEntityColl, entryEntityJson, basedataValRels, rowIndex, logger, i);
                }
            }
        }
    }

    private static void fillBasedataToEntity(String fieldKey, JSONObject entityJson, DynamicObject dynamicObj, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, BasedataProp basedataDP, int index) {
        JSONObject basedataJson = entityJson.getJSONObject(fieldKey);
        if (basedataJson == null) {
            return;
        }
        String importPropKey = basedataJson.getString("importprop");
        BasedataProp basedataProp = basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importPropKey);
            if (null != basedataValsMap) {
                List<DynamicObject> basedataDyobjs = basedataValsMap.get(basedataJson.get((Object)importPropKey));
                if (PERBANKCARD.equals(fieldKey)) {
                    if (null == basedataDyobjs) {
                        String errorMsg = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u7ef4\u62a4\u4eba\u5458\u94f6\u884c\u5361\u4fe1\u606f\u3002", (String)"SalaryFileImportDataConvert2DyObj_7", (String)"swc-hsas-business", (Object[])new Object[0]);
                        SalaryFileImportDataOperate.log(rowIndex + index, errorMsg, logger);
                        return;
                    }
                    Long personId = dynamicObj.getLong("salaryfile.person.id");
                    List perBankCardList = basedataDyobjs.stream().filter(data -> personId.equals(data.getLong("person.id"))).collect(Collectors.toList());
                    int size = perBankCardList.size();
                    if (size == 1) {
                        entityDyObj.set(fieldKey, perBankCardList.get(0));
                        return;
                    }
                    if (size == 0) {
                        String errorMsg = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u7ef4\u62a4\u4eba\u5458\u94f6\u884c\u5361\u4fe1\u606f\u3002", (String)"SalaryFileImportDataConvert2DyObj_7", (String)"swc-hsas-business", (Object[])new Object[0]);
                        SalaryFileImportDataOperate.log(rowIndex + index, errorMsg, logger);
                        entityDyObj.set(fieldKey, null);
                        return;
                    }
                    SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getDuplicateDataErrorMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, basedataDyobjs), logger);
                    entityDyObj.set(fieldKey, null);
                    return;
                }
                if (null == basedataDyobjs) {
                    SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                    entityDyObj.set(fieldKey, null);
                } else if (basedataDyobjs.size() != 1) {
                    SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getDuplicateDataErrorMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, basedataDyobjs), logger);
                    entityDyObj.set(fieldKey, null);
                } else {
                    DynamicObject basedata = basedataDyobjs.get(0);
                    if (!SALARYFILE.equals(fieldKey) && !EMPLOYEE.equals(fieldKey)) {
                        if (SalaryFileImportDataConvert2DyObj.isUseStatusQualified(basedata)) {
                            entityDyObj.set(fieldKey, (Object)basedata);
                        } else {
                            SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedataStatusUnqualifiedMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                        }
                    } else {
                        entityDyObj.set(fieldKey, (Object)basedata);
                    }
                }
            }
        } else if (basedataProp.isMustInput()) {
            SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
            entityDyObj.set(fieldKey, null);
        }
    }

    private static void fillMulBasedataToEntity(String fieldKey, JSONObject entityJson, DynamicObject entityDyObj, int rowIndex, ImportLogger logger, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, MulBasedataProp basedataDP, int index) {
        JSONObject basedataJson = entityJson.getJSONObject(fieldKey);
        if (basedataJson == null) {
            return;
        }
        String importPropKey = basedataJson.getString("importprop");
        MulBasedataProp basedataProp = basedataDP;
        String basedataEntityId = basedataProp.getBaseEntityId();
        Map<String, Map<String, List<DynamicObject>>> importPropVals = basedataValRels.get(basedataEntityId);
        if (null != importPropVals) {
            Map<String, List<DynamicObject>> basedataValsMap = importPropVals.get(importPropKey);
            if (null != basedataValsMap) {
                String basedataVal = basedataJson.getString(importPropKey);
                List<String> list = Arrays.asList(basedataVal.split(","));
                DynamicObjectCollection basedataDyobjs = new DynamicObjectCollection();
                basedataValsMap.forEach((k, val) -> {
                    if (list.contains(k)) {
                        basedataDyobjs.addAll((Collection)val);
                    }
                });
                if (list.size() != basedataDyobjs.size()) {
                    SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                    entityDyObj.set(fieldKey, null);
                } else {
                    boolean isMatch = basedataDyobjs.stream().anyMatch(basedata -> !SalaryFileImportDataConvert2DyObj.isUseStatusQualified(basedata));
                    if (isMatch) {
                        SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedataStatusUnqualifiedMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
                        entityDyObj.set(fieldKey, null);
                    } else {
                        entityDyObj.set(fieldKey, (Object)basedataDyobjs);
                    }
                }
            }
        } else if (basedataProp.isMustInput()) {
            SalaryFileImportDataOperate.log(rowIndex + index, SalaryFileImportDataConvert2DyObj.getBasedNoMatchMsg(rowIndex + index, (DynamicProperty)basedataDP, importPropKey, entityDyObj, fieldKey), logger);
            entityDyObj.set(fieldKey, null);
        }
    }

    private static void fillBasedataToEntryEntity(String entryFieldKey, DynamicObject dynamicObj, DynamicObjectCollection entryEntityColl, JSONObject entryEntityJson, Map<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels, int rowIndex, ImportLogger logger, int index) {
        for (DynamicObject entryDyObj : entryEntityColl) {
            String importPropVal;
            String basedataVal;
            DynamicObjectType dyObjType = entryDyObj.getDynamicObjectType();
            DynamicProperty basedataDP = dyObjType.getProperty(entryFieldKey);
            if (!(basedataDP instanceof BasedataProp)) continue;
            JSONObject basedataJson = entryEntityJson.getJSONObject(entryFieldKey);
            String entryBasedataVal = entryDyObj.getString(entryFieldKey);
            if (basedataJson == null || !(basedataVal = basedataJson.getString(importPropVal = basedataJson.getString("importprop"))).equals(entryBasedataVal)) continue;
            SalaryFileImportDataConvert2DyObj.fillBasedataToEntity(entryFieldKey, entryEntityJson, dynamicObj, entryDyObj, rowIndex, logger, basedataValRels, (BasedataProp)basedataDP, index);
            break;
        }
    }

    private static void assemblyDynamicObject(MainEntityType mainEntityType, ImportRowEntity rowInfo, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger) {
        DynamicObject dynamicObj = (DynamicObject)mainEntityType.createInstance();
        JSONObject importJsonData = rowInfo.getData();
        int rowIndex = rowInfo.getRowIndex();
        DataEntityPropertyCollection allProps = mainEntityType.getProperties();
        for (IDataEntityProperty dp : allProps) {
            SalaryFileImportDataConvert2DyObj.fillVal2DynamicObj(importJsonData, rowIndex, dynamicObj, dp, baseDataValMap, logger);
        }
        Long pkId = ORM.create().genLongId((IDataEntityType)mainEntityType);
        dynamicObj.set("id", (Object)pkId);
        rowInfo.putEntityDyobj(mainEntityType.getName(), dynamicObj);
    }

    private static Map<String, Map<String, Map<String, List<DynamicObject>>>> getBasedataRel(Map<String, Map<String, List<String>>> baseDataValMap) {
        HashMap<String, Map<String, Map<String, List<DynamicObject>>>> basedataValRels = new HashMap<String, Map<String, Map<String, List<DynamicObject>>>>();
        ArrayList<String> entityFilterList = new ArrayList<String>();
        entityFilterList.add("hsas_employee");
        entityFilterList.add(KEY_HRPI_EMLPOYEE);
        entityFilterList.add("hsas_personhr");
        entityFilterList.add(KEY_HRPI_PERSON);
        entityFilterList.add("hsas_itemgroup");
        entityFilterList.add("hsbs_paysubject");
        entityFilterList.add("hrpi_perbankcard");
        entityFilterList.add("hsas_salaryfile");
        for (Map.Entry<String, Map<String, List<String>>> basedataEntityMap : baseDataValMap.entrySet()) {
            String basedataEntityId = basedataEntityMap.getKey();
            Map<String, List<String>> importPropValMap = basedataEntityMap.getValue();
            if (null == importPropValMap) continue;
            for (Map.Entry<String, List<String>> importPropKeyMap : importPropValMap.entrySet()) {
                DynamicObject[] basedataDyObjs;
                String importPropKey = importPropKeyMap.getKey();
                List<String> basedataValList = importPropKeyMap.getValue();
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(basedataEntityId);
                QFilter qFilter = new QFilter(importPropKey, "in", basedataValList);
                String selectProperties = "";
                if ("hsas_salaryfile".equals(basedataEntityId)) {
                    BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                    selectProperties = HSAS_SALARYFILE_BASE_DATA_SELECT_PROPS;
                } else if (entityFilterList.contains(basedataEntityId)) {
                    BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                    selectProperties = "id,name,number,status,enable";
                } else {
                    selectProperties = "id,name,number,status,enable";
                }
                if ("hsbs_paymethod".equals(basedataEntityId)) {
                    selectProperties = selectProperties + ",paycategory";
                }
                if (!"hsas_salaryfile".equals(basedataEntityId) && !KEY_HRPI_EMLPOYEE.equals(basedataEntityId)) {
                    QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                    statusFilter.and(new QFilter("enable", "=", (Object)"1"));
                    qFilter.and(statusFilter);
                }
                HashMap<String, List<DynamicObject>> basedataRelMap = new HashMap<String, List<DynamicObject>>();
                if ("hrpi_perbankcard".equals(basedataEntityId)) {
                    importPropKey = "bankcardnum";
                    selectProperties = selectProperties + ",bankcardnum,person.id";
                    List distinctValList = basedataValList.stream().distinct().collect(Collectors.toList());
                    ArrayList<DynamicObject> bankCardDyList = new ArrayList<DynamicObject>(10);
                    QFilter filter = new QFilter("isdelete", "=", (Object)"0");
                    BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
                    for (String bankCardNum : distinctValList) {
                        QFilter bankCardNumFilter = new QFilter(importPropKey, "=", (Object)bankCardNum);
                        DynamicObject[] bankCardDyArray = serviceHelper.query(selectProperties, new QFilter[]{filter, bankCardNumFilter});
                        if (bankCardDyArray == null) continue;
                        bankCardDyList.addAll(Arrays.asList(bankCardDyArray));
                    }
                    for (DynamicObject dyObj : bankCardDyList) {
                        SalaryFileImportDataConvert2DyObj.fillBaseDataRel(basedataRelMap, dyObj, importPropKey);
                    }
                } else if (KEY_HRPI_EMLPOYEE.equals(basedataEntityId)) {
                    qFilter.and(new QFilter("datastatus", "!=", (Object)"-1"));
                    basedataDyObjs = serviceHelper.query(selectProperties + ",empnumber,startdate,enddate", new QFilter[]{qFilter});
                    Map<String, List<DynamicObject>> basedataDyObjsByImportPropKey = Arrays.stream(basedataDyObjs).collect(Collectors.groupingBy(employee -> employee.getString("empnumber")));
                    for (Map.Entry<String, List<DynamicObject>> entry : basedataDyObjsByImportPropKey.entrySet()) {
                        DynamicObject tmpDyObj;
                        List<DynamicObject> value = entry.getValue();
                        if (value.size() > 1) {
                            tmpDyObj = null;
                            try {
                                Date date = SWCDateTimeUtils.parseDate((String)SWCDateTimeUtils.format((Date)new Date(), (String)YYYY_MM_DD));
                                for (DynamicObject dynamicObject : value) {
                                    Date startDate = dynamicObject.getDate("startdate");
                                    Date endDate = dynamicObject.getDate("enddate");
                                    if (date.compareTo(startDate) < 0 || date.compareTo(endDate) >= 0) continue;
                                    tmpDyObj = dynamicObject;
                                    break;
                                }
                                if (tmpDyObj == null) continue;
                                SalaryFileImportDataConvert2DyObj.fillBaseDataRel(basedataRelMap, tmpDyObj, importPropKey);
                            }
                            catch (ParseException e) {
                                LOGGER.error("parseDate exception");
                            }
                            continue;
                        }
                        tmpDyObj = value.get(0);
                        SalaryFileImportDataConvert2DyObj.fillBaseDataRel(basedataRelMap, tmpDyObj, importPropKey);
                    }
                } else {
                    for (DynamicObject dyObj : basedataDyObjs = serviceHelper.query(selectProperties, new QFilter[]{qFilter})) {
                        SalaryFileImportDataConvert2DyObj.fillBaseDataRel(basedataRelMap, dyObj, importPropKey);
                    }
                }
                HashMap<String, HashMap<String, List<DynamicObject>>> importPropVals = new HashMap<String, HashMap<String, List<DynamicObject>>>();
                importPropVals.put(importPropKey, basedataRelMap);
                basedataValRels.put(basedataEntityId, importPropVals);
            }
        }
        return basedataValRels;
    }

    private static void fillBaseDataRel(Map<String, List<DynamicObject>> basedataRelMap, DynamicObject dyObj, String importPropKey) {
        List<DynamicObject> exsitDyObjList = basedataRelMap.get(dyObj.getString(importPropKey));
        if (null == exsitDyObjList) {
            exsitDyObjList = new ArrayList<DynamicObject>();
            exsitDyObjList.add(dyObj);
        } else {
            exsitDyObjList.add(dyObj);
        }
        basedataRelMap.put(dyObj.getString(importPropKey), exsitDyObjList);
    }

    private static void fillVal2DynamicObj(JSONObject importJsonData, int rowIndex, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger) {
        String fieldKey = dp.getName();
        String fieldVal = importJsonData.getString(fieldKey);
        if (SWCStringUtils.isNotEmpty((String)fieldVal)) {
            if (dp instanceof LargeTextProp || dp instanceof VarcharProp || dp instanceof MuliLangTextProp || dp instanceof TextProp || dp instanceof ComboProp) {
                if (dp instanceof MuliLangTextProp) {
                    Map muliLangTextMap = (Map)JSONObject.parseObject((String)importJsonData.getJSONObject(fieldKey).toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    dynamicObj.set(fieldKey, (Object)LocaleString.fromMap((Map)muliLangTextMap));
                } else {
                    dynamicObj.set(fieldKey, (Object)fieldVal);
                }
            } else if (dp instanceof DecimalProp) {
                SalaryFileImportDataConvert2DyObj.fillDecimalProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, dp);
            } else if (dp instanceof DateProp) {
                SalaryFileImportDataConvert2DyObj.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD, dp);
            } else if (dp instanceof DateTimeProp) {
                SalaryFileImportDataConvert2DyObj.fillDateProp(fieldKey, fieldVal, dynamicObj, rowIndex, logger, YYYY_MM_DD_HH_MM_SS, dp);
            } else if (dp instanceof BooleanProp) {
                if (SWCStringUtils.equals((String)fieldVal, (String)"true")) {
                    dynamicObj.set(fieldKey, (Object)Boolean.TRUE);
                } else {
                    dynamicObj.set(fieldKey, (Object)Boolean.FALSE);
                }
            } else if (dp instanceof BasedataProp) {
                SalaryFileImportDataConvert2DyObj.fillBasedataProp(fieldKey, importJsonData, dynamicObj, dp, baseDataValMap);
            } else if (dp instanceof MulBasedataProp) {
                SalaryFileImportDataConvert2DyObj.fillMulBasedataProp(fieldKey, importJsonData, dynamicObj, dp, baseDataValMap);
            } else if (dp instanceof EntryProp) {
                SalaryFileImportDataConvert2DyObj.fillEntryProp(fieldVal, rowIndex, dynamicObj, fieldKey, baseDataValMap, logger);
            } else if (dp instanceof LongProp) {
                dynamicObj.set(fieldKey, (Object)Long.valueOf(fieldVal));
            }
        } else if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
            dynamicObj.set(fieldKey, (Object)new Date());
        } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
            dynamicObj.set(fieldKey, (Object)RequestContext.get().getUserId());
        } else if (dp instanceof FieldProp) {
            if ("payrate".equals(fieldKey)) {
                dynamicObj.set(fieldKey, null);
            } else {
                dynamicObj.set(fieldKey, ((FieldProp)dp).getDefValue());
            }
        }
    }

    private static void fillBasedataProp(String fieldKey, JSONObject importJsonData, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap) {
        JSONObject basedataJson = importJsonData.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        String basedataEntityId = ((BasedataProp)dp).getBaseEntityId();
        Map importPropValMap = baseDataValMap.computeIfAbsent(basedataEntityId, k -> new HashMap());
        List basedataValList = importPropValMap.computeIfAbsent(importProp, k -> new ArrayList());
        basedataValList.add(basedataVal);
        dynamicObj.set(fieldKey, (Object)basedataVal);
    }

    private static void fillMulBasedataProp(String fieldKey, JSONObject importJsonData, DynamicObject dynamicObj, IDataEntityProperty dp, Map<String, Map<String, List<String>>> baseDataValMap) {
        JSONObject basedataJson = importJsonData.getJSONObject(fieldKey);
        String importProp = basedataJson.getString("importprop");
        String basedataVal = basedataJson.getString(importProp);
        String basedataEntityId = ((MulBasedataProp)dp).getBaseEntityId();
        Map importPropValMap = baseDataValMap.computeIfAbsent(basedataEntityId, k -> new HashMap());
        List basedataValList = importPropValMap.computeIfAbsent(importProp, k -> new ArrayList());
        List<String> list = Arrays.asList(basedataVal.split(","));
        basedataValList.addAll(list);
        dynamicObj.set(fieldKey, list);
    }

    private static void fillEntryProp(String fieldVal, int rowIndex, DynamicObject dynamicObj, String fieldKey, Map<String, Map<String, List<String>>> baseDataValMap, ImportLogger logger) {
        JSONArray entryJsonArr = JSONArray.parseArray((String)fieldVal);
        DynamicObjectCollection entryEntityColl = dynamicObj.getDynamicObjectCollection(fieldKey);
        DynamicObjectType entryType = null;
        DynamicObject entryDyObj = null;
        int size = entryJsonArr.size();
        for (int i = 0; i < size; ++i) {
            JSONObject entryJson = entryJsonArr.getJSONObject(i);
            entryType = entryEntityColl.getDynamicObjectType();
            entryDyObj = new DynamicObject(entryType);
            for (IDataEntityProperty idp : entryType.getProperties()) {
                if ("id".equals(idp.getName())) continue;
                SalaryFileImportDataConvert2DyObj.fillVal2DynamicObj(entryJson, rowIndex, entryDyObj, idp, baseDataValMap, logger);
            }
            entryDyObj.set("seq", (Object)(i + 1));
            entryEntityColl.add((Object)entryDyObj);
        }
    }

    private static void fillDecimalProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, IDataEntityProperty dp) {
        try {
            dynamicObj.set(fieldKey, (Object)new BigDecimal(fieldVal));
        }
        catch (NumberFormatException e) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a{0}", (String)"SalaryFileImportDataConvert2DyObj_6", (String)"swc-hsas-business", (Object[])new Object[0]);
            SalaryFileImportDataOperate.log(rowIndex, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    private static void fillDateProp(String fieldKey, String fieldVal, DynamicObject dynamicObj, int rowIndex, ImportLogger logger, String fmt, IDataEntityProperty dp) {
        try {
            dynamicObj.set(fieldKey, (Object)SWCDateTimeUtils.parseDate((String)fieldVal, (String)fmt));
        }
        catch (ParseException e) {
            String msg = ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{0}\u3002", (String)"SalaryFileImportDataConvert2DyObj_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            SalaryFileImportDataOperate.log(rowIndex, MessageFormat.format(msg, dp.getDisplayName().getLocaleValue()), logger);
        }
    }

    private static String getBasedNoMatchMsg(int rowIndex, DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a{1}\u201c{2}\u201d\u3002", (String)"SalaryFileImportDataConvert2DyObj_1", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName(), SalaryFileImportDataConvert2DyObj.getImportPropDisName(importProp), dyobj.getString(fieldId));
    }

    public static String getBasedataStatusUnqualifiedMsg(int rowIndex, DynamicProperty dp, String importProp, DynamicObject dyobj, String fieldId) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599({0})\u6570\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u5df2\u5ba1\u6838\u201d\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u53ef\u7528\u201d\uff1a{1}\u201c{2}\u201d\u3002", (String)"SalaryFileImportDataConvert2DyObj_2", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName(), SalaryFileImportDataConvert2DyObj.getImportPropDisName(importProp), dyobj.getString(fieldId));
    }

    public static String getDuplicateDataErrorMsg(int rowIndex, DynamicProperty dp, String importProp, List<DynamicObject> basedataDyObjs) {
        return MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u503c\u201c{1}\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u552f\u4e00\u3002", (String)"SalaryFileImportDataConvert2DyObj_3", (String)"swc-hsas-business", (Object[])new Object[0]), dp.getDisplayName(), basedataDyObjs.get(0).getString(importProp));
    }

    public static String getImportPropDisName(String importProp) {
        if (SWCStringUtils.equals((String)importProp, (String)"number")) {
            return ResManager.loadKDString((String)"\u7f16\u7801", (String)"SalaryFileImportDataConvert2DyObj_4", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        if (SWCStringUtils.equals((String)importProp, (String)"name")) {
            return ResManager.loadKDString((String)"\u540d\u79f0", (String)"SalaryFileImportDataConvert2DyObj_5", (String)"swc-hsas-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static boolean isUseStatusQualified(DynamicObject basedata) {
        boolean isQualified = true;
        if (!SWCStringUtils.equals((String)basedata.getString("status"), (String)"C") || !SWCStringUtils.equals((String)basedata.getString("enable"), (String)"1")) {
            isQualified = false;
        }
        return isQualified;
    }
}

